Program RbsTrialDecode (Input,Output);

Function LowByte(Value : word) : word;
Begin
  LowByte := Value - (Value div 256)*256;
End;

Function HighByte(Value : word) : word;
Begin
  HighByte := Value div 256;
End;

Function Encode(Var InBX : word;
                InCX : word;
                CorrectInput : byte) : byte;
Var
  BX,
  CX            : word;
  CorrectOutput,
  BH,
  BL,
  CH,
  CL,
  TempByte      : byte;

Begin
  BX := InBX;
  CX := InCX;
  BH := HighByte(InBX);
  BL := LowByte(InBX);
  CorrectOutPut := CorrectInput + BL;
  If (CorrectOutput < CorrectInput) Then
  Begin
    CorrectOutput := (CorrectOutput XOR 255) + 1;
    BL := BL + 1;
  End;
  BX := 256*BH + BL;
  CX := CX*BX;
  CL := LowByte(CX);
  CH := HighByte(CX);
  CorrectOutput := CorrectOutput - CH - CL;
  BH := HighByte(BX);
  BL := LowByte(BX);
  BX := 256*BL + BH;
  InBX := BX;
  Encode := CorrectOutput;
End;

Function Decode(Var InBX      : word;
                InCX          : word;
                CorrectOutput : byte;
                NoJump        : boolean) : Byte;

Var

  BX,
  CX  : word;
  CorrectInput     : byte;
  BH,
  BL,
  CH,
  CL,
  TempByte   : byte;

Begin
  If NoJump Then
  Begin
    CX := InCX;
    BX := InBX;
    BL := LowByte(InBX);
    BH := HighByte(InBX);
    CX := CX * BX;
    CL := LowByte(CX);
    CH := HighByte(CX);
    TempByte := CL + CH;
    CorrectInput := CorrectOutput + TempByte - BL;
    BX := BH + 256*BL;
    TempByte := CorrectInput + BL;
    If TempByte >= CorrectInput Then
    Begin
      Decode := CorrectInput;
      InBX := BX;
    End
    Else
      Decode := 0;
  End
  Else
  Begin
    CX := InCX;
    BX := InBX;
    BL := LowByte(BX);
    BH := HighByte(BX);
    BL := BL + 1;
    BX := BL + BH*256;
    CX := BX * CX;
    CL := LowByte(CX);
    CH := HighByte(CX);
    TempByte := CL+CH;
    CorrectInput := ((CorrectOutput + TempByte) XOR 255) + 1 -
LowByte(InBX);
    BX := BH + 256*BL;
    TempByte := CorrectInput + LowByte(InBX);
    If TempByte < CorrectInput Then
    Begin
      Decode := CorrectInput;
      InBX := BX;
    End
    Else
      Decode := 0;
  End;
End;


Const
  EncodedPassword : array[2..11] of byte =
(31,245,207,138,86,33,217,123,86,10);

Var
  InBX,
  InCX,
  Counter1,
  Counter2,
  Mask,
  Temp           : word;
  CorrectInput,
  a,b            : byte;
  GoodPassword,
  NoJump         : boolean;
  PasswordString : String;

Begin
  Writeln;
  For Counter1 := 0 to 511 do
  Begin
    Mask := 1;
    InBX := 40357;
    GoodPassword := True;
    PasswordString := '';
    For Counter2 := 1 to 9 do
    Begin
      Temp := Counter1 and Mask;
      NoJump := Temp <> 0;
      InCX := 12 - Counter2;
      CorrectInput := Decode(InBX,InCX,EncodedPassword[InCX],NoJump);
      If (CorrectInput <= 126) and (CorrectInput >= 32) Then
        PasswordString := PasswordString + Chr(CorrectInput)
      Else
      Begin
        PasswordString := PasswordString + Chr(CorrectInput);
        GoodPassword := False;
      End;
      Mask := Mask * 2;
    End {for};
    a := Encode(InBX,2,13);
    b := Encode(InBX,1,0);
    If GoodPassword and (a = 31) and (b = 97) Then
      Writeln(PasswordString);
  End {for};
End.
