//***********************************************************
//*   solution for Duelist's Crackme #3 , solved by Nuno1   *
//*   any comments can be sent to nuno_2@hotmail.com        *
//***********************************************************

//this program will run for around 7 min and will return a binary like number
//that 0 mean OFF and 1 mean ON .

//when finished , the last number will be the answer ,
//the number will be 01100110110010010. and it is the right key
//for the crackme.
//
//you are welcome to run it yourself and wait till it reach the end ;).
//
//before trying to understand the code here,read the tutorial for the crackme.
//Have a good time ;)

#include <stdio.h>
#include <stdlib.h>

#define RESULT_NUMBER 0xf35466 //this is the result number we need to reach.
#define NUMBER_OF_CHECKBOXS 18 //as the name said .. number of checkboxs.

#define TRUE  1     //some defines that will help us make the code look good.
#define FALSE 0

	//this table is the check box table .
	//each checkbox doesn't represent the "REAL" checkbox number.
	//for example the first checkbox on the crackme is really 17 . (11h)
	//so this is a transalation table for the checkbox.
	int CheckBoxTable[18]={17,2 ,3 ,1 ,8 ,
						   6 ,7 ,10,11,4 ,
						   12,13,14,15,16,
						   18,5 ,9};

	//this is the table that the crackme multiply from
	//see above for the use of it..
	int MulTable[19] = {0x16,0x49,0x5e,0x15,0x27,0x26,
						0x21,0x25,0x1d,0x59,0x53,0x37,
						0x31,0x48,0x5d,0x0c,0x61,0x52,
						0x4d};

	//this Table is the checkboxs that we are building.
	int CheckBoxs[18] = {0,0,0,0,0,0,0,0,0,
						 0,0,0,0,0,0,0,0,0};

//***************************************************************//
//*int ChkCheckBox() - this function make the calculation of the*//
//*					   crackme with the 'CheckBoxs' table and   *//
//*					   return TRUE if the result is equal to    *//
//*                    RESULT_NUMBER number.                    *//
//***************************************************************//

int ChkCheckBox() {
	long t;
	unsigned long Total = 0; //total will hold the current CheckBoxs state
							 //result.

	long Num1=0,Num2=0;      //some used numbers in the crackme.

	//here we start to make the calculation of the crackme as we debugged it.

	Num1 = MulTable[0]; //Num1 take the first number from the MulTable;

	//we start a loop on all the checkboxs.
	for(t=0;t<18;t++) {
		//checking if the checkbox is ON or OFF.
		if(CheckBoxs[t]) {
			//if checkbox is ON we do the above calculation.
			Num2 = MulTable[t+1]; //take the next number from the MulTable
			Num2 = Num2 * Num1;   //Multiply it with the old Number.
			Num2 = Num2 * (t+1);  //Multiply the result with the checkbox
								  //Index.
			Total= Total + Num2;  //and finally add it to the Total.
		}
		Num1 = MulTable[t+1]; //Num1 now gets the Next number from
							  //The MulTable.

	}
	//when finished the loop , we multpily it with 0x4d.
	Total = Total * 0x4d;
	//checking if the Total equal to the result.
	if(Total == RESULT_NUMBER)
		//if it is .. we found the number we return TRUE.
		return TRUE;
	else
		//if not .. to bad .. FALSE.
		return FALSE;
}


//**************************************************************************//
//*void FindCombination(int Level) - This function print all Combinations  *//
//*							         Until the right one . if no one found *//
//*									 return and finished.                  *//
//*                                  Level can be named CheckBox, it used  *//
//*                                  when call himself to move to the next *//
//*									 CheckBox.							   *//
//**************************************************************************//

void FindCombination(int Level) {
	int t;
	//we have to print the checkbox when we got to the last one and
	//we dont want to continue so we do this statment..
	if (Level != NUMBER_OF_CHECKBOXS) {
		//first we put a FALSE in the checkbox.
		CheckBoxs[Level] = FALSE;
		//then we call to the Next Level (CheckBox).
		FindCombination(Level+1);
		//in second stage we put it in TRUE.
		CheckBoxs[Level] = TRUE;
		FindCombination(Level+1);
		//as you may understand the first time we finished 18 checkboxs
		//it will look like that : 000000000000000000
		//second one will be     : 000000000000000001
		//after                  : 000000000000000010
		//and after              : 000000000000000011
		//and so on and so on ;)
	}
	else
	{
		//if it got to the last level we need first to print the checkboxs.
		for(t=0;t<18;t++)
			//as i said before , the checkboxs are not really in the "REAL"
			//places. so i use the CheckBoxTable to know witch one is the
			//real one.
			printf("%d",CheckBoxs[(CheckBoxTable[t]-1)]);

		//nice little line feed ;)
		printf("\n");

		//is it the right combination ??
		if(ChkCheckBox()) {
			//yeah !! it is ! exit and the last number is the right one.
			exit(1);
		}
	}
}

//*****************************************
//				Main program             //
//*****************************************

void main() {
	//we just call the sweet lovely FindCombination and tell him
	//to start with the first checkbox (0 is the first one).
	FindCombination(0);
	//if it continue until here .. it means that no combination found
	//for the RESULT_NUMBER .
	printf("hey !! there is no combination for the number %lX.\n",RESULT_NUMBER);

}
//end of the program.