//******************************************************************
//*             solution for Kwazy Webbit's PacMe Crackme          *
//*                   solved By Nuno1 on 24 july 1999              *
//*           any comments can be sent to nuno_2@hotmail.com       *
//******************************************************************

// this is a KeyFile Generator.

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#define FILENAME "KwazyWeb.bit" //the file to create the KeyFile.

//a tables of moves for the MAZE.
//there is only up , down , left , right possiblitys ;)
//here is the table :
//-----------
//|0|  Up   |
//|1| Right |
//|2| Down  |
//|3| Left  |
//-----------

const char MAZEMOVES[18*4] =  {2,2,2,1,2,2,2,3,2,2,1,
							   1,0,1,0,0,1,1,1,0,0,3,
							   3,3,0,3,0,0,1,1,1,1,1,
							   2,1,1,0,1,1,2,1,1,1,2,
							   2,3,3,2,3,3,0,3,3,2,2,
							   2,3,2,2,1,1,1,0,0,1,1,
							   1,1,2,2,3,3};

//**********************************************//
//        Print a logo for the program
//**********************************************//

void PrintLogo() {
	printf("************************************************\n");
	printf("    solution for Kwazy Webbit's PacMe Crackme   \n");
	printf("         solved By Nuno1 on 22 july 1999        \n");
	printf(" any comments can be sent to nuno_2@hotmail.com \n");
	printf("************************************************\n");
}

//********************************//
//          Main Program          //
//********************************//

void main(int argc,char **argv) {

	char UserName[50]; //this variable will hold the user name from
						//the arguments.
	unsigned char Numbers[0x1c];

	char Step1,Step2,Step3,Step4;

	long UserNameTotal = 0;

	FILE *f;
	int t;

	//Print The Logo.
	PrintLogo();

	for(t=0;t<50;t++)
    	UserName[t] = 0;
	if (argc == 1) {    //checking if there paramaters are entered.
		//if no .. we print the syntax of the program
		//(argv[0] is the application executeble file)
		printf("syntax : %s <Your Registration Name>\n",argv[0]);
		//exit from the program.
		exit(-1);
	}
	else
	{
		//if paramaters been prompt we cut them all to one string
		//with " " seperate .. because the name can be with spaces.
		for(t=1;t<=argc-1;t++) {
			strcat(UserName,argv[t]);
			if (t != argc-1)
				strcat(UserName," ");
		}
	}

	//here we calculate the username total.
	for(t=0;t<=strlen(UserName);t++) {
		UserNameTotal = UserNameTotal + UserName[t];
	}
	//this is the encryption method for the steps.. used our total ofcourse.

	//the 0x12 is really the numbers of steps we have to do .. but
	//it is multiply with 4 because each byte represet 4 steps.
	for(t=0;t<0x12;t++) {

		//Step 1 is the most left 2 bits
		Step1 = MAZEMOVES[t*4]   << 6;
		//Step 2 is the second left 2 bits
		Step2 = MAZEMOVES[t*4+1] << 4;
		//Step 3 is the second right 2 bits
		Step3 = MAZEMOVES[t*4+2] << 2;
		//Step 4 is the first right 2 bits.
		Step4 = MAZEMOVES[t*4+3];

		//after we build the 4 steps into we add it to one byte.
		Numbers[t] = Step1+Step2+Step3+Step4;
		//Xor it with the Total of the username (this is the encryption)
		Numbers[t] = Numbers[t] ^ (char)UserNameTotal;
	}
	//now we write the file.

	//open the file and check if its open.
	if ((f = fopen(FILENAME,"wb")) == NULL) {
		printf("Error write file %s !!! ",FILENAME);
		exit(-1);
	}
	//t = string length of username.
	t = strlen(UserName);
	//write he first byte as the length of the string.
	fwrite(&t,1,1,f);
	//write the username
	fwrite(&UserName,t,1,f);
	//and write the encrypted steps.
	fwrite(&Numbers,0x12,1,f);
	//close the file
	fclose(f);
	printf("\nthe file %s as been generated for %s.\n",FILENAME,&UserName);

}
//end of the program
