#include <stdio.h>
#include <fcntl.h>
#include <io.h>

struct infostruct {
  char *filename;
  unsigned long filesize;
  unsigned long ps_size;
};

struct patchstruct {
  unsigned long pos;
  unsigned char old_byte;
  unsigned char new_byte;
};

int do_patch(struct infostruct is, struct patchstruct ps[]);

#define PATCHSIZE_1 5
struct infostruct is_1 = { "crackme1.exe" , 0x2000 , PATCHSIZE_1 };
struct patchstruct ps_1 [PATCHSIZE_1] = {
  { 0x61E, 0xE8, 0x90 },
  { 0x61F, 0xDA, 0x90 },
  { 0x620, 0x01, 0x90 },
  { 0x621, 0x00, 0x90 },
  { 0x622, 0x00, 0x90 },
};

int main(void) {
  printf("                                                                    \n");
  printf("  ۲                   ܲ     ܲ           ܲ \n");
  printf("     ܲ ߲      ߲ܲ   ۲\n");
  printf("  ߲     ۲    ߲\n");
  printf("             ۰ ۲      \n");
  printf("   ޲ݰ     ۲ ۲     \n");
  printf("   ۲   ۲   ۲       ۲   MtD! \n");
  printf("   ۲߲    ޲     ۲۲   ۲۲  \n");
  printf("       ۲۲ ۲ ۲۲ \n");
  printf("    ܲ ߲           ۲ \n");
  printf(" ߲ ߲       ߲ ߲ܲ       ߲߲ ߲ܲ ܲ\n");
  printf("                                                                         \n");
  printf("                  Phox Crackme 1.0 patch by Duelist of iNSiDE99.            \n");
  printf("\n");
  do_patch(is_1, ps_1);
  printf("\n");
  printf("                      iNSiDE99, bringing you TRUE quality.                  \n");
  return 0;
}

int do_patch(struct infostruct is, struct patchstruct ps[]) {
  int handle;
  unsigned long counter;
  unsigned char value;

  printf("  checking for %s... ", is.filename);

  if ((handle = open(is.filename, O_RDWR | O_BINARY)) == -1) {
    printf("not found.\n");
    return -1;
  } else printf("found... ");

  if (filelength(handle) != is.filesize) {
    printf("incorrect filesize.\n");
    return -1;
  } else printf("now patching... ");

  for (counter=0; counter<is.ps_size; counter++) {
    lseek(handle, ps[counter].pos, SEEK_SET);
    read(handle, &value, 1);
    if (value != ps[counter].old_byte) {
      if (value == ps[counter].new_byte) {
        printf("file already patched.\n");
        return -2;
      }
      printf("incompatible file.\n");
      return -2;
    }
    lseek(handle, ps[counter].pos, SEEK_SET);
    write(handle, &ps[counter].new_byte, 1);
  }
  printf("done.\n");
  close(handle);
  return 0;
}
