// This program works fine - you should never get msgbox.

#include <windows.h>

LRESULT CALLBACK USERTestProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  if(uMsg == WM_DESTROY)
    PostQuitMessage(0);
  else
    return DefWindowProc(hwnd, uMsg, wParam, lParam);
  return 0;
}    

TCHAR USERTestClassName[] = TEXT("USERTestClass");

WNDCLASS USERTestClass =
{CS_GLOBALCLASS, USERTestProc, 0, 0, NULL, NULL, NULL,
 (HBRUSH)(COLOR_WINDOW+1), NULL, USERTestClassName};

DWORD WINAPI ThreadFunc(LPVOID Something) {
  USERTestClass.hInstance = GetModuleHandle(NULL);
  USERTestClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  USERTestClass.hCursor = LoadCursor(NULL, IDC_ARROW);  
  return RegisterClass(&USERTestClass);
}

void main(void) {
  HANDLE hThread;
  DWORD tid;
  MSG msg;
  HWND hwnd;
  DWORD et, ts;
  BOOL r;
  if(hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadFunc, NULL, 0, &tid)) {
    WaitForSingleObject(hThread, INFINITE);
    et = GetExitCodeThread(hThread, &ts);
    CloseHandle(hThread);
    if(et && ts) {
      if(hwnd = CreateWindow(USERTestClassName, TEXT("Window"),
                             WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                             CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                             NULL, NULL, GetModuleHandle(NULL), NULL)) {
        ShowWindow(hwnd, SW_SHOWNORMAL);
        while((r = GetMessage(&msg, NULL, 0, 0)) && (r != -1))
          DispatchMessage(&msg);
      }
      else
      if(GetLastError() == ERROR_CANNOT_FIND_WND_CLASS)
        MessageBox(NULL, TEXT("has taken \"USERTestClass\" class out."),
                  TEXT("Child thread termination"), MB_OK);
    }
  }
}