// This program works fine sometimes - sometimes you get msgbox.

#include <windows.h>

LRESULT CALLBACK USERTestProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  if(uMsg == WM_DESTROY)
    PostQuitMessage(0);
  else
    return DefWindowProc(hwnd, uMsg, wParam, lParam);
  return 0;
}    

TCHAR USERTestClassName[] = TEXT("USERTestClass");

WNDCLASS USERTestClass =
{CS_GLOBALCLASS, USERTestProc, 0, 0, NULL, NULL, NULL,
 (HBRUSH)(COLOR_WINDOW+1), NULL, USERTestClassName};

DWORD WINAPI ThreadFunc0(LPVOID Something) {
  USERTestClass.hInstance = GetModuleHandle(NULL);
  USERTestClass.hIcon = LoadIcon(NULL, IDI_APPLICATION);
  USERTestClass.hCursor = LoadCursor(NULL, IDC_ARROW);  
  return RegisterClass(&USERTestClass);
}

void WINAPI ThreadFunc1(LPVOID Something) {
  MSG msg;
  HWND hwnd;
  BOOL r;
  if(hwnd = CreateWindow(USERTestClassName, TEXT("Window"),
                         WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                         CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                         NULL, NULL, GetModuleHandle(NULL), NULL)) {
    ShowWindow(hwnd, SW_SHOWNORMAL);
    while((r = GetMessage(&msg, NULL, 0, 0)) && (r != -1))
      DispatchMessage(&msg);
  }
  else
  if(GetLastError() == ERROR_CANNOT_FIND_WND_CLASS)
    MessageBox(NULL, TEXT("has taken \"USERTestClass\" class out."),
              TEXT("Too fast primary thread termination"), MB_OK);
}

void main(void) {
  HANDLE hThread;
  DWORD tid;
  DWORD et, ts;
  if(hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadFunc0, NULL, 0, &tid)) {
    WaitForSingleObject(hThread, INFINITE);
    et = GetExitCodeThread(hThread, &ts);
    CloseHandle(hThread);
    if(et && ts)
      if(hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadFunc1, NULL, 0, &tid))
        CloseHandle(hThread);
  }
  //Sleep(5000); //uncomment and it will work fine -> give it chance
                 //to call CreateWindow(USERTestClassName,...) before I die
}