#include <windows.h>

static FARPROC pDefWindowProc, pPostQuitMessage, pLoadIcon, pLoadCursor,
               pRegisterClass, pCreateWindow, pShowWindow, pGetMessage,
               pDispatchMessage, pMessageBox;

LRESULT CALLBACK USERTestProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  if(uMsg == WM_DESTROY)
    pPostQuitMessage(0);
  else
    return pDefWindowProc(hwnd, uMsg, wParam, lParam);
  return 0;
}    

TCHAR USERTestClassName[] = TEXT("USERTestClass");

WNDCLASS USERTestClass =
{CS_GLOBALCLASS, USERTestProc, 0, 0, NULL, NULL, NULL,
 (HBRUSH)(COLOR_WINDOW+1), NULL, USERTestClassName};

volatile BOOL Done = FALSE;

void WINAPI ThreadFunc(LPVOID Something) {
  HINSTANCE ts;
  if(ts = LoadLibrary(TEXT("USER32.dll"))) {
    if(!(pDefWindowProc = GetProcAddress(ts, "DefWindowProcA"))) return;
    if(!(pPostQuitMessage = GetProcAddress(ts, "PostQuitMessage"))) return;
    if(!(pLoadIcon = GetProcAddress(ts, "LoadIconA"))) return;
    if(!(pLoadCursor = GetProcAddress(ts, "LoadCursorA"))) return;
    if(!(pRegisterClass = GetProcAddress(ts, "RegisterClassA"))) return;
    if(!(pCreateWindow = GetProcAddress(ts, "CreateWindowExA"))) return;
    if(!(pShowWindow = GetProcAddress(ts, "ShowWindow"))) return;
    if(!(pGetMessage = GetProcAddress(ts, "GetMessageA"))) return;
    if(!(pDispatchMessage = GetProcAddress(ts, "DispatchMessageA"))) return;
    if(!(pMessageBox = GetProcAddress(ts, "MessageBoxA"))) return;
    Done = TRUE;
//    for(;;);
  }
}

void WINAPI ThreadFunc1(LPVOID Something) {
  USERTestClass.hInstance = GetModuleHandle(NULL);
  USERTestClass.hIcon = (HICON)pLoadIcon(NULL, IDI_APPLICATION);
  USERTestClass.hCursor = (HCURSOR)pLoadCursor(NULL, IDC_ARROW);  
  Done = pRegisterClass(&USERTestClass);
//  for(;;);
}

void main(void) {
  HANDLE hThread, ts;
  DWORD tid;
  MSG msg;
  HWND hwnd;
  DWORD et;
  BOOL r; 

  if(hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadFunc, NULL, 0, &tid)) {
    CloseHandle(hThread);
    Sleep(3000);
    if(Done) {
      Done = FALSE;  
      if(hThread = CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)ThreadFunc1, NULL, 0, &tid)) {
        CloseHandle(hThread);
        Sleep(2000);
        if(Done && (hwnd = (HWND)pCreateWindow(0, USERTestClassName, TEXT("Window"),
                                     WS_OVERLAPPEDWINDOW | WS_VISIBLE,
                                     CW_USEDEFAULT, 0, CW_USEDEFAULT, 0,
                                     NULL, NULL, GetModuleHandle(NULL), NULL))) {
          pShowWindow(hwnd, SW_SHOWNORMAL);
          while((r = pGetMessage(&msg, NULL, 0, 0)) && (r != -1))
            pDispatchMessage(&msg);
        }
        else
        if(GetLastError() == ERROR_CANNOT_FIND_WND_CLASS)
          pMessageBox(NULL, TEXT("has taken \"USERTestClass\" class out."),
                     TEXT("Child threads termination"), MB_OK);
      }
    }
  }
}