COMMENT /*++ BUILD Version: 0005    ;; Increment this if a change has global effects

Module Name:
    ntstatus.inc

Abstract:
    Constant definitions for the NTSTATUS values.

Notes:
    Please add new error values to the end of the file.  To do otherwise
    will jumble the error values.

--*/


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/
;;
;; Standard Success values
;;
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/


;;
;; The success status codes 0 - 63 are reserved for wait completion status.
;; FacilityCodes 0x5 - 0xF have been allocated by various drivers.
;;
 STATUS_SUCCESS                          EQU 000000000H ;; ntsubauth

;;
;;  Values are 32 bit values layed out as follows:
;;
;;   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
;;   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
;;  +---+-+-+-----------------------+-------------------------------+
;;  |Sev|C|R|     Facility          |               Code            |
;;  +---+-+-+-----------------------+-------------------------------+
;;
;;  where
;;
;;      Sev - is the severity code
;;
;;          00 - Success
;;          01 - Informational
;;          10 - Warning
;;          11 - Error
;;
;;      C - is the Customer code flag
;;
;;      R - is a reserved bit
;;
;;      Facility - is the facility code
;;
;;      Code - is the facility's status code
;;
;;
;; Define the facility codes
;;
 FACILITY_USB_ERROR_CODE          EQU 10H
 FACILITY_RPC_STUBS               EQU 3H
 FACILITY_RPC_RUNTIME             EQU 2H
 FACILITY_IO_ERROR_CODE           EQU 4H
 FACILITY_HID_ERROR_CODE          EQU 11H
 FACILITY_FIREWIRE_ERROR_CODE     EQU 12H
 FACILITY_CLUSTER_ERROR_CODE      EQU 13H


;;
;; Define the severity codes
;;
 STATUS_SEVERITY_WARNING          EQU 2H
 STATUS_SEVERITY_SUCCESS          EQU 0H
 STATUS_SEVERITY_INFORMATIONAL    EQU 1H
 STATUS_SEVERITY_ERROR            EQU 3H


;;
;; MessageId: STATUS_WAIT_0
;;
;; MessageText:
;;
;;  STATUS_WAIT_0
;;
 STATUS_WAIT_0                    EQU 000000000H    ;; winnt

;;
;; MessageId: STATUS_WAIT_1
;;
;; MessageText:
;;
;;  STATUS_WAIT_1
;;
 STATUS_WAIT_1                    EQU 000000001H

;;
;; MessageId: STATUS_WAIT_2
;;
;; MessageText:
;;
;;  STATUS_WAIT_2
;;
 STATUS_WAIT_2                    EQU 000000002H

;;
;; MessageId: STATUS_WAIT_3
;;
;; MessageText:
;;
;;  STATUS_WAIT_3
;;
 STATUS_WAIT_3                    EQU 000000003H

;;
;; MessageId: STATUS_WAIT_63
;;
;; MessageText:
;;
;;  STATUS_WAIT_63
;;
 STATUS_WAIT_63                   EQU 00000003FH


;;
;; The success status codes 128 - 191 are reserved for wait completion
;; status with an abandoned mutant object.
;;
 STATUS_ABANDONED                        EQU 000000080H

;;
;; MessageId: STATUS_ABANDONED_WAIT_0
;;
;; MessageText:
;;
;;  STATUS_ABANDONED_WAIT_0
;;
 STATUS_ABANDONED_WAIT_0          EQU 000000080H    ;; winnt

;;
;; MessageId: STATUS_ABANDONED_WAIT_63
;;
;; MessageText:
;;
;;  STATUS_ABANDONED_WAIT_63
;;
 STATUS_ABANDONED_WAIT_63         EQU 0000000BFH

;;
;; MessageId: STATUS_USER_APC
;;
;; MessageText:
;;
;;  The success status codes 256, 257, 258, and 258 are reserved for
;;  User APC, Kernel APC, Alerted, and Timeout.
;;
 STATUS_USER_APC                  EQU 0000000C0H    ;; winnt

;;
;; MessageId: STATUS_KERNEL_APC
;;
;; MessageText:
;;
;;  The success status codes 256, 257, 258, and 258 are reserved for
;;  User APC, Kernel APC, Alerted, and Timeout.
;;
 STATUS_KERNEL_APC                EQU 000000100H

;;
;; MessageId: STATUS_ALERTED
;;
;; MessageText:
;;
;;  The success status codes 256, 257, 258, and 258 are reserved for
;;  User APC, Kernel APC, Alerted, and Timeout.
;;
 STATUS_ALERTED                   EQU 000000101H

;;
;; MessageId: STATUS_TIMEOUT
;;
;; MessageText:
;;
;;  The success status codes 256, 257, 258, and 258 are reserved for
;;  User APC, Kernel APC, Alerted, and Timeout.
;;
 STATUS_TIMEOUT                   EQU 000000102H    ;; winnt

;;
;; MessageId: STATUS_PENDING
;;
;; MessageText:
;;
;;  The operation that was requested is pending completion.
;;
 STATUS_PENDING                   EQU 000000103H    ;; winnt

;;
;; MessageId: STATUS_REPARSE
;;
;; MessageText:
;;
;;  A reparse should be performed by the Object Manager since the name of the
;;  file resulted in a symbolic link.
;;
 STATUS_REPARSE                   EQU 000000104H

;;
;; MessageId: STATUS_MORE_ENTRIES
;;
;; MessageText:
;;
;;  Returned by enumeration APIs to indicate more information is available
;;  to successive calls.
;;
 STATUS_MORE_ENTRIES              EQU 000000105H

;;
;; MessageId: STATUS_NOT_ALL_ASSIGNED
;;
;; MessageText:
;;
;;  Indicates not all privileges referenced are assigned to the caller.
;;  This allows, for example, all privileges to be disabled without having
;;  to know exactly which privileges are assigned.
;;
 STATUS_NOT_ALL_ASSIGNED          EQU 000000106H

;;
;; MessageId: STATUS_SOME_NOT_MAPPED
;;
;; MessageText:
;;
;;  Some of the information to be translated has not been translated.
;;
 STATUS_SOME_NOT_MAPPED           EQU 000000107H

;;
;; MessageId: STATUS_OPLOCK_BREAK_IN_PROGRESS
;;
;; MessageText:
;;
;;  An open/create operation completed while an oplock break is
;;  underway.
;;
 STATUS_OPLOCK_BREAK_IN_PROGRESS  EQU 000000108H

;;
;; MessageId: STATUS_VOLUME_MOUNTED
;;
;; MessageText:
;;
;;  A new volume has been mounted by a file system.
;;
 STATUS_VOLUME_MOUNTED            EQU 000000109H

;;
;; MessageId: STATUS_RXACT_COMMITTED
;;
;; MessageText:
;;
;;  This success level status indicates that the transaction state already
;;  exists for the registry sub-tree, but that a transaction commit was
;;  previously aborted.  The commit has now been completed.
;;  This status value is returned by the runtime library (RTH registry
;;  transaction package (RXact).
;;
 STATUS_RXACT_COMMITTED           EQU 00000010AH

;;
;; MessageId: STATUS_NOTIFY_CLEANUP
;;
;; MessageText:
;;
;;  This indicates that a notify change request has been completed due to
;;  closing the handle which made the notify change request.
;;
 STATUS_NOTIFY_CLEANUP            EQU 00000010BH

;;
;; MessageId: STATUS_NOTIFY_ENUM_DIR
;;
;; MessageText:
;;
;;  This indicates that a notify change request is being completed and that the
;;  information is not being returned in the caller's buffer.  The caller now
;;  needs to enumerate the files to find the changes.
;;
 STATUS_NOTIFY_ENUM_DIR           EQU 00000010CH

;;
;; MessageId: STATUS_NO_QUOTAS_FOR_ACCOUNT
;;
;; MessageText:
;;
;;  {No Quotas}
;;  No system quota limits are specifically set for this account.
;;
 STATUS_NO_QUOTAS_FOR_ACCOUNT     EQU 00000010DH

;;
;; MessageId: STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED
;;
;; MessageText:
;;
;;  {Connect Failure on Primary Transport}
;;  An attempt was made to connect to the remote server %s on the primary transport, but the
;;  connection failed.  The computer WAS able to connect on a secondary transport.
;;
 STATUS_PRIMARY_TRANSPORT_CONNECT_FAILED EQU 00000010EH

;;
;; MessageId: STATUS_PAGE_FAULT_TRANSITION
;;
;; MessageText:
;;
;;  Page fault was a transition fault.
;;
 STATUS_PAGE_FAULT_TRANSITION     EQU 000000110H

;;
;; MessageId: STATUS_PAGE_FAULT_DEMAND_ZERO
;;
;; MessageText:
;;
;;  Page fault was a demand zero fault.
;;
 STATUS_PAGE_FAULT_DEMAND_ZERO    EQU 000000111H

;;
;; MessageId: STATUS_PAGE_FAULT_COPY_ON_WRITE
;;
;; MessageText:
;;
;;  Page fault was a demand zero fault.
;;
 STATUS_PAGE_FAULT_COPY_ON_WRITE  EQU 000000112H

;;
;; MessageId: STATUS_PAGE_FAULT_GUARD_PAGE
;;
;; MessageText:
;;
;;  Page fault was a demand zero fault.
;;
 STATUS_PAGE_FAULT_GUARD_PAGE     EQU 000000113H

;;
;; MessageId: STATUS_PAGE_FAULT_PAGING_FILE
;;
;; MessageText:
;;
;;  Page fault was satisfied by reading from a secondary storage device.
;;
 STATUS_PAGE_FAULT_PAGING_FILE    EQU 000000114H

;;
;; MessageId: STATUS_CACHE_PAGE_LOCKED
;;
;; MessageText:
;;
;;  Cached page was locked during operation.
;;
 STATUS_CACHE_PAGE_LOCKED         EQU 000000115H

;;
;; MessageId: STATUS_CRASH_DUMP
;;
;; MessageText:
;;
;;  Crash dump exists in paging file.
;;
 STATUS_CRASH_DUMP                EQU 000000116H

;;
;; MessageId: STATUS_BUFFER_ALL_ZEROS
;;
;; MessageText:
;;
;;  Specified buffer contains all zeros.
;;
 STATUS_BUFFER_ALL_ZEROS          EQU 000000117H

;;
;; MessageId: STATUS_REPARSE_OBJECT
;;
;; MessageText:
;;
;;  A reparse should be performed by the Object Manager since the name of the
;;  file resulted in a symbolic link.
;;
 STATUS_REPARSE_OBJECT            EQU 000000118H

;;
;; MessageId: STATUS_RESOURCE_REQUIREMENTS_CHANGED
;;
;; MessageText:
;;
;;  The device has succeeded a query-stop and its resource requirements have changed.
;;
 STATUS_RESOURCE_REQUIREMENTS_CHANGED EQU 000000119H



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/
;;
;; Standard Information values
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/

;;
;; MessageId: STATUS_OBJECT_NAME_EXISTS
;;
;; MessageText:
;;
;;  {Object Exists}
;;  An attempt was made to create an object and the object name already existed.
;;
 STATUS_OBJECT_NAME_EXISTS        EQU 040000000H

;;
;; MessageId: STATUS_THREAD_WAS_SUSPENDED
;;
;; MessageText:
;;
;;  {Thread Suspended}
;;  A thread termination occurred while the thread was suspended. The
;;  thread was resumed, and termination proceeded.
;;
 STATUS_THREAD_WAS_SUSPENDED      EQU 040000001H

;;
;; MessageId: STATUS_WORKING_SET_LIMIT_RANGE
;;
;; MessageText:
;;
;;  {Working Set Range Error}
;;  An attempt was made to set the working set minimum or maximum
;;  to values which are outside of the allowable range.
;;
 STATUS_WORKING_SET_LIMIT_RANGE   EQU 040000002H

;;
;; MessageId: STATUS_IMAGE_NOT_AT_BASE
;;
;; MessageText:
;;
;;  {Image Relocated}
;;  An image file could not be mapped at the address specified in
;;  the image file.  Local fixups must be performed on this image.
;;
 STATUS_IMAGE_NOT_AT_BASE         EQU 040000003H

;;
;; MessageId: STATUS_RXACT_STATE_CREATED
;;
;; MessageText:
;;
;;  This informational level status indicates that a specified registry
;;  sub-tree transaction state did not yet exist and had to be created.
;;  This status value is returned by the runtime library (RTH registry
;;  transaction package (RXact).
;;
 STATUS_RXACT_STATE_CREATED       EQU 040000004H

;;
;; MessageId: STATUS_SEGMENT_NOTIFICATION
;;
;; MessageText:
;;
;;  {Segment Load}
;;  A virtual DOS machine (VDM) is loading, unloading, or moving an MS-DOS
;;  or Win16 program segment image. An exception is raised so a debugger can
;;  load, unload or track symbols and breakpoints within these 16-bit segments.
;;
 STATUS_SEGMENT_NOTIFICATION      EQU 040000005H    ;; winnt

;;
;; MessageId: STATUS_LOCAL_USER_SESSION_KEY
;;
;; MessageText:
;;
;;  {Local Session Key}
;;  A user session key was requested for a local RPC connection. The session key
;;  returned is a constant value and not unique to this connection.
;;
 STATUS_LOCAL_USER_SESSION_KEY    EQU 040000006H

;;
;; MessageId: STATUS_BAD_CURRENT_DIRECTORY
;;
;; MessageText:
;;
;;  {Invalid Current Directory}
;;  The process cannot switch to the startup current directory %s.
;;  Select OK to set current directory to %s, or select CANCEL
;;  to exit.
;;
 STATUS_BAD_CURRENT_DIRECTORY     EQU 040000007H

;;
;; MessageId: STATUS_SERIAL_MORE_WRITES
;;
;; MessageText:
;;
;;  {Serial IOCTL Complete}
;;  A serial I/O operation was completed by another write to a serial port.
;;  (The IOCTL_SERIAL_XOFF_COUNTER reached zero.)
;;
 STATUS_SERIAL_MORE_WRITES        EQU 040000008H

;;
;; MessageId: STATUS_REGISTRY_RECOVERED
;;
;; MessageText:
;;
;;  {Registry Recovery}
;;  One of the files containing the system's Registry data had to be recovered
;;  by use of a log or alternate copy.  The recovery was successful.
;;
 STATUS_REGISTRY_RECOVERED        EQU 040000009H

;;
;; MessageId: STATUS_FT_READ_RECOVERY_FROM_BACKUP
;;
;; MessageText:
;;
;;  {Redundant Read}
;;  To satisfy a read request, the NT fault-tolerant file system successfully
;;  read the requested data from a redundant copy. This was done because
;;  the file system encountered a failure on a member of the fault-tolerant
;;  volume, but was unable to reassign the failing area of the device.
;;
 STATUS_FT_READ_RECOVERY_FROM_BACKUP EQU 04000000AH

;;
;; MessageId: STATUS_FT_WRITE_RECOVERY
;;
;; MessageText:
;;
;;  {Redundant Write}
;;  To satisfy a write request, the NT fault-tolerant file system successfully
;;  wrote a redundant copy of the information. This was done because the
;;  file system encountered a failure on a member of the fault-tolerant
;;  volume, but was not able to reassign the failing area of the device.
;;
 STATUS_FT_WRITE_RECOVERY         EQU 04000000BH

;;
;; MessageId: STATUS_SERIAL_COUNTER_TIMEOUT
;;
;; MessageText:
;;
;;  {Serial IOCTL Timeout}
;;  A serial I/O operation completed because the time-out period expired.
;;  (The IOCTL_SERIAL_XOFF_COUNTER had not reached zero.)
;;
 STATUS_SERIAL_COUNTER_TIMEOUT    EQU 04000000CH

;;
;; MessageId: STATUS_NULL_LM_PASSWORD
;;
;; MessageText:
;;
;;  {Password Too Complex}
;;  The NT password is too complex to be converted to a LAN Manager password.
;;  The LAN Manager password returned is a NULL string.
;;
 STATUS_NULL_LM_PASSWORD          EQU 04000000DH

;;
;; MessageId: STATUS_IMAGE_MACHINE_TYPE_MISMATCH
;;
;; MessageText:
;;
;;  {Machine Type Mismatch}
;;  The image file %s is valid, but is for a machine type other than the current machine. Select OK to continue, or CANCEL to fail the DLL load.
;;
 STATUS_IMAGE_MACHINE_TYPE_MISMATCH EQU 04000000EH

;;
;; MessageId: STATUS_RECEIVE_PARTIAL
;;
;; MessageText:
;;
;;  {Partial Data Received}
;;  The network transport returned partial data to its client. The remaining
;;  data will be sent later.
;;
 STATUS_RECEIVE_PARTIAL           EQU 04000000FH

;;
;; MessageId: STATUS_RECEIVE_EXPEDITED
;;
;; MessageText:
;;
;;  {Expedited Data Received}
;;  The network transport returned data to its client that was marked as
;;  expedited by the remote system.
;;
 STATUS_RECEIVE_EXPEDITED         EQU 040000010H

;;
;; MessageId: STATUS_RECEIVE_PARTIAL_EXPEDITED
;;
;; MessageText:
;;
;;  {Partial Expedited Data Received}
;;  The network transport returned partial data to its client and this data
;;  was marked as expedited by the remote system. The remaining data will
;;  be sent later.
;;
 STATUS_RECEIVE_PARTIAL_EXPEDITED EQU 040000011H

;;
;; MessageId: STATUS_EVENT_DONE
;;
;; MessageText:
;;
;;  {TDI Event Done}
;;  The TDI indication has completed successfully.
;;
 STATUS_EVENT_DONE                EQU 040000012H

;;
;; MessageId: STATUS_EVENT_PENDING
;;
;; MessageText:
;;
;;  {TDI Event Pending}
;;  The TDI indication has entered the pending state.
;;
 STATUS_EVENT_PENDING             EQU 040000013H

;;
;; MessageId: STATUS_CHECKING_FILE_SYSTEM
;;
;; MessageText:
;;
;;  Checking file system on %wZ
;;
 STATUS_CHECKING_FILE_SYSTEM      EQU 040000014H

;;
;; MessageId: STATUS_FATAL_APP_EXIT
;;
;; MessageText:
;;
;;  {Fatal Application Exit}
;;  %s
;;
 STATUS_FATAL_APP_EXIT            EQU 040000015H

;;
;; MessageId: STATUS_PREDEFINED_HANDLE
;;
;; MessageText:
;;
;;  The specified registry key is referenced by a predefined handle.
;;
 STATUS_PREDEFINED_HANDLE         EQU 040000016H

;;
;; MessageId: STATUS_WAS_UNLOCKED
;;
;; MessageText:
;;
;;  {Page Unlocked}
;;  The page protection of a locked page was changed to 'No Access'
;;  and the page was unlocked from memory and from the process.
;;
 STATUS_WAS_UNLOCKED              EQU 040000017H

;;
;; MessageId: STATUS_SERVICE_NOTIFICATION
;;
;; MessageText:
;;
;;  %s
;;
 STATUS_SERVICE_NOTIFICATION      EQU 040000018H

;;
;; MessageId: STATUS_WAS_LOCKED
;;
;; MessageText:
;;
;;  {Page Locked}
;;  One of the pages to lock was already locked.
;;
 STATUS_WAS_LOCKED                EQU 040000019H

;;
;; MessageId: STATUS_LOG_HARD_ERROR
;;
;; MessageText:
;;
;;  Application popup: %1 : %2
;;
 STATUS_LOG_HARD_ERROR            EQU 04000001AH

;;
;; MessageId: STATUS_ALREADY_WIN32
;;
;; MessageText:
;;
;;  STATUS_ALREADY_WIN32
;;
 STATUS_ALREADY_WIN32             EQU 04000001BH

;;
;; MessageId: STATUS_WX86_UNSIMULATE
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_UNSIMULATE           EQU 04000001CH

;;
;; MessageId: STATUS_WX86_CONTINUE
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_CONTINUE             EQU 04000001DH

;;
;; MessageId: STATUS_WX86_SINGLE_STEP
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_SINGLE_STEP          EQU 04000001EH

;;
;; MessageId: STATUS_WX86_BREAKPOINT
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_BREAKPOINT           EQU 04000001FH

;;
;; MessageId: STATUS_WX86_EXCEPTION_CONTINUE
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_EXCEPTION_CONTINUE   EQU 040000020H

;;
;; MessageId: STATUS_WX86_EXCEPTION_LASTCHANCE
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_EXCEPTION_LASTCHANCE EQU 040000021H

;;
;; MessageId: STATUS_WX86_EXCEPTION_CHAIN
;;
;; MessageText:
;;
;;  Exception status code used by Win32 x86 emulation subsystem.
;;
 STATUS_WX86_EXCEPTION_CHAIN      EQU 040000022H

;;
;; MessageId: STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE
;;
;; MessageText:
;;
;;  {Machine Type Mismatch}
;;  The image file %s is valid, but is for a machine type other than the current machine.
;;
 STATUS_IMAGE_MACHINE_TYPE_MISMATCH_EXE EQU 040000023H

;;
;; MessageId: STATUS_NO_YIELD_PERFORMED
;;
;; MessageText:
;;
;;  A yield execution was performed and no thread was available to run.
;;
 STATUS_NO_YIELD_PERFORMED        EQU 040000024H

;;
;; MessageId: STATUS_TIMER_RESUME_IGNORED
;;
;; MessageText:
;;
;;  The resumeable flag to a timer API was ignored.
;;
 STATUS_TIMER_RESUME_IGNORED      EQU 040000025H

;;
;; MessageId: STATUS_ARBITRATION_UNHANDLED
;;
;; MessageText:
;;
;;  The arbiter has deferred arbitration of these resources to its parent
;;
 STATUS_ARBITRATION_UNHANDLED     EQU 040000026H



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/
;;
;; Standard Warning values
;;
;;
;; Note:  Do NOT use the value 0x80000000L, as this is a non-portable value
;;        for the NT_SUCCESS macro.  Warning values start with a code of 1.
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/

;;
;; MessageId: STATUS_GUARD_PAGE_VIOLATION
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Guard Page Exception
;;  A page of memory that marks the end of a data structure, such as a stack
;;  or an array, has been accessed.
;;
 STATUS_GUARD_PAGE_VIOLATION      EQU 080000001H    ;; winnt

;;
;; MessageId: STATUS_DATATYPE_MISALIGNMENT
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Alignment Fault
;;  A datatype misalignment was detected in a load or store instruction.
;;
 STATUS_DATATYPE_MISALIGNMENT     EQU 080000002H    ;; winnt

;;
;; MessageId: STATUS_BREAKPOINT
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Breakpoint
;;  A breakpoint has been reached.
;;
 STATUS_BREAKPOINT                EQU 080000003H    ;; winnt

;;
;; MessageId: STATUS_SINGLE_STEP
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Single Step
;;  A single step or trace operation has just been completed.
;;
 STATUS_SINGLE_STEP               EQU 080000004H    ;; winnt

;;
;; MessageId: STATUS_BUFFER_OVERFLOW
;;
;; MessageText:
;;
;;  {Buffer Overflow}
;;  The data was too large to fit into the specified buffer.
;;
 STATUS_BUFFER_OVERFLOW           EQU 080000005H

;;
;; MessageId: STATUS_NO_MORE_FILES
;;
;; MessageText:
;;
;;  {No More Files}
;;  No more files were found which match the file specification.
;;
 STATUS_NO_MORE_FILES             EQU 080000006H

;;
;; MessageId: STATUS_WAKE_SYSTEM_DEBUGGER
;;
;; MessageText:
;;
;;  {Kernel Debugger Awakened}
;;  the system debugger was awakened by an interrupt.
;;
 STATUS_WAKE_SYSTEM_DEBUGGER      EQU 080000007H

;;
;; MessageId: STATUS_HANDLES_CLOSED
;;
;; MessageText:
;;
;;  {Handles Closed}
;;  Handles to objects have been automatically closed as a result of the
;;  requested operation.
;;
 STATUS_HANDLES_CLOSED            EQU 08000000AH

;;
;; MessageId: STATUS_NO_INHERITANCE
;;
;; MessageText:
;;
;;  {Non-Inheritable ACL}
;;  An access control list (ACH contains no components that can be inherited.
;;
 STATUS_NO_INHERITANCE            EQU 08000000BH

;;
;; MessageId: STATUS_GUID_SUBSTITUTION_MADE
;;
;; MessageText:
;;
;;  {GUID Substitution}
;;  During the translation of a global identifier (GUID) to a Windows NT
;;  security ID (SID), no administratively-defined GUID prefix was found.
;;  A substitute prefix was used, which will not compromise system security.
;;  However, this may provide a more restrictive access than intended.
;;
 STATUS_GUID_SUBSTITUTION_MADE    EQU 08000000CH

;;
;; MessageId: STATUS_PARTIAL_COPY
;;
;; MessageText:
;;
;;  {Partial Copy}
;;  Due to protection conflicts not all the requested bytes could be
;;  copied.
;;
 STATUS_PARTIAL_COPY              EQU 08000000DH

;;
;; MessageId: STATUS_DEVICE_PAPER_EMPTY
;;
;; MessageText:
;;
;;  {Out of Paper}
;;  The printer is out of paper.
;;
 STATUS_DEVICE_PAPER_EMPTY        EQU 08000000EH

;;
;; MessageId: STATUS_DEVICE_POWERED_OFF
;;
;; MessageText:
;;
;;  {Device Power Is Off}
;;  The printer power has been turned off.
;;
 STATUS_DEVICE_POWERED_OFF        EQU 08000000FH

;;
;; MessageId: STATUS_DEVICE_OFF_LINE
;;
;; MessageText:
;;
;;  {Device Offline}
;;  The printer has been taken offline.
;;
 STATUS_DEVICE_OFF_LINE           EQU 080000010H

;;
;; MessageId: STATUS_DEVICE_BUSY
;;
;; MessageText:
;;
;;  {Device Busy}
;;  The device is currently busy.
;;
 STATUS_DEVICE_BUSY               EQU 080000011H

;;
;; MessageId: STATUS_NO_MORE_EAS
;;
;; MessageText:
;;
;;  {No More EAs}
;;  No more extended attributes (EAs) were found for the file.
;;
 STATUS_NO_MORE_EAS               EQU 080000012H

;;
;; MessageId: STATUS_INVALID_EA_NAME
;;
;; MessageText:
;;
;;  {Illegal EA}
;;  The specified extended attribute (EA) name contains at least one illegal
;;  character.
;;
 STATUS_INVALID_EA_NAME           EQU 080000013H

;;
;; MessageId: STATUS_EA_LIST_INCONSISTENT
;;
;; MessageText:
;;
;;  {Inconsistent EA List}
;;  The extended attribute (EA) list is inconsistent.
;;
 STATUS_EA_LIST_INCONSISTENT      EQU 080000014H

;;
;; MessageId: STATUS_INVALID_EA_FLAG
;;
;; MessageText:
;;
;;  {Invalid EA Flag}
;;  An invalid extended attribute (EA) flag was set.
;;
 STATUS_INVALID_EA_FLAG           EQU 080000015H

;;
;; MessageId: STATUS_VERIFY_REQUIRED
;;
;; MessageText:
;;
;;  {Verifying Disk}
;;  The media has changed and a verify operation is in progress so no
;;  reads or writes may be performed to the device, except those used in
;;  the verify operation.
;;
 STATUS_VERIFY_REQUIRED           EQU 080000016H

;;
;; MessageId: STATUS_EXTRANEOUS_INFORMATION
;;
;; MessageText:
;;
;;  {Too Much Information}
;;  The specified access control list (ACH contained more information than
;;  was expected.
;;
 STATUS_EXTRANEOUS_INFORMATION    EQU 080000017H

;;
;; MessageId: STATUS_RXACT_COMMIT_NECESSARY
;;
;; MessageText:
;;
;;  This warning level status indicates that the transaction state already
;;  exists for the registry sub-tree, but that a transaction commit was
;;  previously aborted.  The commit has NOT been completed, but has not been
;;  rolled back either (so it may still be committed if desired).
;;  This status value is returned by the runtime library (RTH registry
;;  transaction package (RXact).
;;
 STATUS_RXACT_COMMIT_NECESSARY    EQU 080000018H

;;
;; MessageId: STATUS_NO_MORE_ENTRIES
;;
;; MessageText:
;;
;;  {No More Entries}
;;  No more entries are available from an enumeration operation.
;;
 STATUS_NO_MORE_ENTRIES           EQU 08000001AH

;;
;; MessageId: STATUS_FILEMARK_DETECTED
;;
;; MessageText:
;;
;;  {Filemark Found}
;;  A filemark was detected.
;;
 STATUS_FILEMARK_DETECTED         EQU 08000001BH

;;
;; MessageId: STATUS_MEDIA_CHANGED
;;
;; MessageText:
;;
;;  {Media Changed}
;;  The media may have changed.
;;
 STATUS_MEDIA_CHANGED             EQU 08000001CH

;;
;; MessageId: STATUS_BUS_RESET
;;
;; MessageText:
;;
;;  {I/O Bus Reset}
;;  An I/O bus reset was detected.
;;
 STATUS_BUS_RESET                 EQU 08000001DH

;;
;; MessageId: STATUS_END_OF_MEDIA
;;
;; MessageText:
;;
;;  {End of Media}
;;  The end of the media was encountered.
;;
 STATUS_END_OF_MEDIA              EQU 08000001EH

;;
;; MessageId: STATUS_BEGINNING_OF_MEDIA
;;
;; MessageText:
;;
;;  Beginning of tape or partition has been detected.
;;
 STATUS_BEGINNING_OF_MEDIA        EQU 08000001FH

;;
;; MessageId: STATUS_MEDIA_CHECK
;;
;; MessageText:
;;
;;  {Media Changed}
;;  The media may have changed.
;;
 STATUS_MEDIA_CHECK               EQU 080000020H

;;
;; MessageId: STATUS_SETMARK_DETECTED
;;
;; MessageText:
;;
;;  A tape access reached a setmark.
;;
 STATUS_SETMARK_DETECTED          EQU 080000021H

;;
;; MessageId: STATUS_NO_DATA_DETECTED
;;
;; MessageText:
;;
;;  During a tape access, the end of the data written is reached.
;;
 STATUS_NO_DATA_DETECTED          EQU 080000022H

;;
;; MessageId: STATUS_REDIRECTOR_HAS_OPEN_HANDLES
;;
;; MessageText:
;;
;;  The redirector is in use and cannot be unloaded.
;;
 STATUS_REDIRECTOR_HAS_OPEN_HANDLES EQU 080000023H

;;
;; MessageId: STATUS_SERVER_HAS_OPEN_HANDLES
;;
;; MessageText:
;;
;;  The server is in use and cannot be unloaded.
;;
 STATUS_SERVER_HAS_OPEN_HANDLES   EQU 080000024H

;;
;; MessageId: STATUS_ALREADY_DISCONNECTED
;;
;; MessageText:
;;
;;  The specified connection has already been disconnected.
;;
 STATUS_ALREADY_DISCONNECTED      EQU 080000025H

;;
;; MessageId: STATUS_LONGJUMP
;;
;; MessageText:
;;
;;  A long jump has been executed.
;;
 STATUS_LONGJUMP                  EQU 080000026H



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/
;;
;;  Standard Error values
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;/

;;
;; MessageId: STATUS_UNSUCCESSFUL
;;
;; MessageText:
;;
;;  {Operation Failed}
;;  The requested operation was unsuccessful.
;;
 STATUS_UNSUCCESSFUL              EQU 0C0000001H

;;
;; MessageId: STATUS_NOT_IMPLEMENTED
;;
;; MessageText:
;;
;;  {Not Implemented}
;;  The requested operation is not implemented.
;;
 STATUS_NOT_IMPLEMENTED           EQU 0C0000002H

;;
;; MessageId: STATUS_INVALID_INFO_CLASS
;;
;; MessageText:
;;
;;  {Invalid Parameter}
;;  The specified information class is not a valid information class for
;;  the specified object.
;;
 STATUS_INVALID_INFO_CLASS        EQU 0C0000003H    ;; ntsubauth

;;
;; MessageId: STATUS_INFO_LENGTH_MISMATCH
;;
;; MessageText:
;;
;;  The specified information record length does not match the length
;;  required for the specified information class.
;;
 STATUS_INFO_LENGTH_MISMATCH      EQU 0C0000004H

;;
;; MessageId: STATUS_ACCESS_VIOLATION
;;
;; MessageText:
;;
;;  The instruction at "0x%08lx" referenced memory at "0x%08lx". The memory
;;  could not be "%s".
;;
 STATUS_ACCESS_VIOLATION          EQU 0C0000005H    ;; winnt ntsubauth

;;
;; MessageId: STATUS_IN_PAGE_ERROR
;;
;; MessageText:
;;
;;  The instruction at "0x%08lx" referenced memory at "0x%08lx". The required
;;  data was not placed into memory because of an I/O error status of "0x%08lx".
;;
 STATUS_IN_PAGE_ERROR             EQU 0C0000006H    ;; winnt

;;
;; MessageId: STATUS_PAGEFILE_QUOTA
;;
;; MessageText:
;;
;;  The pagefile quota for the process has been exhausted.
;;
 STATUS_PAGEFILE_QUOTA            EQU 0C0000007H

;;
;; MessageId: STATUS_INVALID_HANDLE
;;
;; MessageText:
;;
;;  An invalid HANDLE was specified.
;;
 STATUS_INVALID_HANDLE            EQU 0C0000008H    ;; winnt

;;
;; MessageId: STATUS_BAD_INITIAL_STACK
;;
;; MessageText:
;;
;;  An invalid initial stack was specified in a call to NtCreateThread.
;;
 STATUS_BAD_INITIAL_STACK         EQU 0C0000009H

;;
;; MessageId: STATUS_BAD_INITIAL_PC
;;
;; MessageText:
;;
;;  An invalid initial start address was specified in a call to NtCreateThread.
;;
 STATUS_BAD_INITIAL_PC            EQU 0C000000AH

;;
;; MessageId: STATUS_INVALID_CID
;;
;; MessageText:
;;
;;  An invalid Client ID was specified.
;;
 STATUS_INVALID_CID               EQU 0C000000BH

;;
;; MessageId: STATUS_TIMER_NOT_CANCELED
;;
;; MessageText:
;;
;;  An attempt was made to cancel or set a timer that has an associated APC
;;  and the subject thread is not the thread that originally set the timer
;;  with an associated APC routine.
;;
 STATUS_TIMER_NOT_CANCELED        EQU 0C000000CH

;;
;; MessageId: STATUS_INVALID_PARAMETER
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function.
;;
 STATUS_INVALID_PARAMETER         EQU 0C000000DH

;;
;; MessageId: STATUS_NO_SUCH_DEVICE
;;
;; MessageText:
;;
;;  A device which does not exist was specified.
;;
 STATUS_NO_SUCH_DEVICE            EQU 0C000000EH

;;
;; MessageId: STATUS_NO_SUCH_FILE
;;
;; MessageText:
;;
;;  {File Not Found}
;;  The file %s does not exist.
;;
 STATUS_NO_SUCH_FILE              EQU 0C000000FH

;;
;; MessageId: STATUS_INVALID_DEVICE_REQUEST
;;
;; MessageText:
;;
;;  The specified request is not a valid operation for the target device.
;;
 STATUS_INVALID_DEVICE_REQUEST    EQU 0C0000010H

;;
;; MessageId: STATUS_END_OF_FILE
;;
;; MessageText:
;;
;;  The end-of-file marker has been reached.  There is no valid data in the
;;  file beyond this marker.
;;
 STATUS_END_OF_FILE               EQU 0C0000011H

;;
;; MessageId: STATUS_WRONG_VOLUME
;;
;; MessageText:
;;
;;  {Wrong Volume}
;;  The wrong volume is in the drive.
;;  Please insert volume %s into drive %s.
;;
 STATUS_WRONG_VOLUME              EQU 0C0000012H

;;
;; MessageId: STATUS_NO_MEDIA_IN_DEVICE
;;
;; MessageText:
;;
;;  {No Disk}
;;  There is no disk in the drive.
;;  Please insert a disk into drive %s.
;;
 STATUS_NO_MEDIA_IN_DEVICE        EQU 0C0000013H

;;
;; MessageId: STATUS_UNRECOGNIZED_MEDIA
;;
;; MessageText:
;;
;;  {Unknown Disk Format}
;;  The disk in drive %s is not formatted properly.
;;  Please check the disk, and reformat if necessary.
;;
 STATUS_UNRECOGNIZED_MEDIA        EQU 0C0000014H

;;
;; MessageId: STATUS_NONEXISTENT_SECTOR
;;
;; MessageText:
;;
;;  {Sector Not Found}
;;  The specified sector does not exist.
;;
 STATUS_NONEXISTENT_SECTOR        EQU 0C0000015H

;;
;; MessageId: STATUS_MORE_PROCESSING_REQUIRED
;;
;; MessageText:
;;
;;  {Still Busy}
;;  The specified I/O request packet (IRP) cannot be disposed of because the
;;  I/O operation is not complete.
;;
 STATUS_MORE_PROCESSING_REQUIRED  EQU 0C0000016H

;;
;; MessageId: STATUS_NO_MEMORY
;;
;; MessageText:
;;
;;  {Not Enough Quota}
;;  Not enough virtual memory or paging file quota is available to complete
;;  the specified operation.
;;
 STATUS_NO_MEMORY                 EQU 0C0000017H    ;; winnt

;;
;; MessageId: STATUS_CONFLICTING_ADDRESSES
;;
;; MessageText:
;;
;;  {Conflicting Address Range}
;;  The specified address range conflicts with the address space.
;;
 STATUS_CONFLICTING_ADDRESSES     EQU 0C0000018H

;;
;; MessageId: STATUS_NOT_MAPPED_VIEW
;;
;; MessageText:
;;
;;  Address range to unmap is not a mapped view.
;;
 STATUS_NOT_MAPPED_VIEW           EQU 0C0000019H

;;
;; MessageId: STATUS_UNABLE_TO_FREE_VM
;;
;; MessageText:
;;
;;  Virtual memory cannot be freed.
;;
 STATUS_UNABLE_TO_FREE_VM         EQU 0C000001AH

;;
;; MessageId: STATUS_UNABLE_TO_DELETE_SECTION
;;
;; MessageText:
;;
;;  Specified section cannot be deleted.
;;
 STATUS_UNABLE_TO_DELETE_SECTION  EQU 0C000001BH

;;
;; MessageId: STATUS_INVALID_SYSTEM_SERVICE
;;
;; MessageText:
;;
;;  An invalid system service was specified in a system service call.
;;
 STATUS_INVALID_SYSTEM_SERVICE    EQU 0C000001CH

;;
;; MessageId: STATUS_ILLEGAL_INSTRUCTION
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Illegal Instruction
;;  An attempt was made to execute an illegal instruction.
;;
 STATUS_ILLEGAL_INSTRUCTION       EQU 0C000001DH    ;; winnt

;;
;; MessageId: STATUS_INVALID_LOCK_SEQUENCE
;;
;; MessageText:
;;
;;  {Invalid Lock Sequence}
;;  An attempt was made to execute an invalid lock sequence.
;;
 STATUS_INVALID_LOCK_SEQUENCE     EQU 0C000001EH

;;
;; MessageId: STATUS_INVALID_VIEW_SIZE
;;
;; MessageText:
;;
;;  {Invalid Mapping}
;;  An attempt was made to create a view for a section which is bigger
;;  than the section.
;;
 STATUS_INVALID_VIEW_SIZE         EQU 0C000001FH

;;
;; MessageId: STATUS_INVALID_FILE_FOR_SECTION
;;
;; MessageText:
;;
;;  {Bad File}
;;  The attributes of the specified mapping file for a section of memory
;;  cannot be read.
;;
 STATUS_INVALID_FILE_FOR_SECTION  EQU 0C0000020H

;;
;; MessageId: STATUS_ALREADY_COMMITTED
;;
;; MessageText:
;;
;;  {Already Committed}
;;  The specified address range is already committed.
;;
 STATUS_ALREADY_COMMITTED         EQU 0C0000021H

;;
;; MessageId: STATUS_ACCESS_DENIED
;;
;; MessageText:
;;
;;  {Access Denied}
;;  A process has requested access to an object, but has not been granted
;;  those access rights.
;;
 STATUS_ACCESS_DENIED             EQU 0C0000022H

;;
;; MessageId: STATUS_BUFFER_TOO_SMALL
;;
;; MessageText:
;;
;;  {Buffer Too Small}
;;  The buffer is too small to contain the entry.  No information has been
;;  written to the buffer.
;;
 STATUS_BUFFER_TOO_SMALL          EQU 0C0000023H

;;
;; MessageId: STATUS_OBJECT_TYPE_MISMATCH
;;
;; MessageText:
;;
;;  {Wrong Type}
;;  There is a mismatch between the type of object required by the requested
;;  operation and the type of object that is specified in the request.
;;
 STATUS_OBJECT_TYPE_MISMATCH      EQU 0C0000024H

;;
;; MessageId: STATUS_NONCONTINUABLE_EXCEPTION
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Cannot Continue
;;  Windows NT cannot continue from this exception.
;;
 STATUS_NONCONTINUABLE_EXCEPTION  EQU 0C0000025H    ;; winnt

;;
;; MessageId: STATUS_INVALID_DISPOSITION
;;
;; MessageText:
;;
;;  An invalid exception disposition was returned by an exception handler.
;;
 STATUS_INVALID_DISPOSITION       EQU 0C0000026H    ;; winnt

;;
;; MessageId: STATUS_UNWIND
;;
;; MessageText:
;;
;;  Unwind exception code.
;;
 STATUS_UNWIND                    EQU 0C0000027H

;;
;; MessageId: STATUS_BAD_STACK
;;
;; MessageText:
;;
;;  An invalid or unaligned stack was encountered during an unwind operation.
;;
 STATUS_BAD_STACK                 EQU 0C0000028H

;;
;; MessageId: STATUS_INVALID_UNWIND_TARGET
;;
;; MessageText:
;;
;;  An invalid unwind target was encountered during an unwind operation.
;;
 STATUS_INVALID_UNWIND_TARGET     EQU 0C0000029H

;;
;; MessageId: STATUS_NOT_LOCKED
;;
;; MessageText:
;;
;;  An attempt was made to unlock a page of memory which was not locked.
;;
 STATUS_NOT_LOCKED                EQU 0C000002AH

;;
;; MessageId: STATUS_PARITY_ERROR
;;
;; MessageText:
;;
;;  Device parity error on I/O operation.
;;
 STATUS_PARITY_ERROR              EQU 0C000002BH

;;
;; MessageId: STATUS_UNABLE_TO_DECOMMIT_VM
;;
;; MessageText:
;;
;;  An attempt was made to decommit uncommitted virtual memory.
;;
 STATUS_UNABLE_TO_DECOMMIT_VM     EQU 0C000002CH

;;
;; MessageId: STATUS_NOT_COMMITTED
;;
;; MessageText:
;;
;;  An attempt was made to change the attributes on memory that
;;  has not been committed.
;;
 STATUS_NOT_COMMITTED             EQU 0C000002DH

;;
;; MessageId: STATUS_INVALID_PORT_ATTRIBUTES
;;
;; MessageText:
;;
;;  Invalid Object Attributes specified to NtCreatePort or invalid
;;  Port Attributes specified to NtConnectPort
;;
 STATUS_INVALID_PORT_ATTRIBUTES   EQU 0C000002EH

;;
;; MessageId: STATUS_PORT_MESSAGE_TOO_LONG
;;
;; MessageText:
;;
;;  Length of message passed to NtRequestPort or NtRequestWaitReplyPort
;;  was longer than the maximum message allowed by the port.
;;
 STATUS_PORT_MESSAGE_TOO_LONG     EQU 0C000002FH

;;
;; MessageId: STATUS_INVALID_PARAMETER_MIX
;;
;; MessageText:
;;
;;  An invalid combination of parameters was specified.
;;
 STATUS_INVALID_PARAMETER_MIX     EQU 0C0000030H

;;
;; MessageId: STATUS_INVALID_QUOTA_LOWER
;;
;; MessageText:
;;
;;  An attempt was made to lower a quota limit below the current usage.
;;
 STATUS_INVALID_QUOTA_LOWER       EQU 0C0000031H

;;
;; MessageId: STATUS_DISK_CORRUPT_ERROR
;;
;; MessageText:
;;
;;  {Corrupt Disk}
;;  The file system structure on the disk is corrupt and unusable.
;;  Please run the Chkdsk utility on the volume %s.
;;
 STATUS_DISK_CORRUPT_ERROR        EQU 0C0000032H

;;
;; MessageId: STATUS_OBJECT_NAME_INVALID
;;
;; MessageText:
;;
;;  Object Name invalid.
;;
 STATUS_OBJECT_NAME_INVALID       EQU 0C0000033H

;;
;; MessageId: STATUS_OBJECT_NAME_NOT_FOUND
;;
;; MessageText:
;;
;;  Object Name not found.
;;
 STATUS_OBJECT_NAME_NOT_FOUND     EQU 0C0000034H

;;
;; MessageId: STATUS_OBJECT_NAME_COLLISION
;;
;; MessageText:
;;
;;  Object Name already exists.
;;
 STATUS_OBJECT_NAME_COLLISION     EQU 0C0000035H

;;
;; MessageId: STATUS_PORT_DISCONNECTED
;;
;; MessageText:
;;
;;  Attempt to send a message to a disconnected communication port.
;;
 STATUS_PORT_DISCONNECTED         EQU 0C0000037H

;;
;; MessageId: STATUS_DEVICE_ALREADY_ATTACHED
;;
;; MessageText:
;;
;;  An attempt was made to attach to a device that was already attached to
;;  another device.
;;
 STATUS_DEVICE_ALREADY_ATTACHED   EQU 0C0000038H

;;
;; MessageId: STATUS_OBJECT_PATH_INVALID
;;
;; MessageText:
;;
;;  Object Path Component was not a directory object.
;;
 STATUS_OBJECT_PATH_INVALID       EQU 0C0000039H

;;
;; MessageId: STATUS_OBJECT_PATH_NOT_FOUND
;;
;; MessageText:
;;
;;  {Path Not Found}
;;  The path %s does not exist.
;;
 STATUS_OBJECT_PATH_NOT_FOUND     EQU 0C000003AH

;;
;; MessageId: STATUS_OBJECT_PATH_SYNTAX_BAD
;;
;; MessageText:
;;
;;  Object Path Component was not a directory object.
;;
 STATUS_OBJECT_PATH_SYNTAX_BAD    EQU 0C000003BH

;;
;; MessageId: STATUS_DATA_OVERRUN
;;
;; MessageText:
;;
;;  {Data Overrun}
;;  A data overrun error occurred.
;;
 STATUS_DATA_OVERRUN              EQU 0C000003CH

;;
;; MessageId: STATUS_DATA_LATE_ERROR
;;
;; MessageText:
;;
;;  {Data Late}
;;  A data late error occurred.
;;
 STATUS_DATA_LATE_ERROR           EQU 0C000003DH

;;
;; MessageId: STATUS_DATA_ERROR
;;
;; MessageText:
;;
;;  {Data Error}
;;  An error in reading or writing data occurred.
;;
 STATUS_DATA_ERROR                EQU 0C000003EH

;;
;; MessageId: STATUS_CRC_ERROR
;;
;; MessageText:
;;
;;  {Bad CRC}
;;  A cyclic redundancy check (CRC) checksum error occurred.
;;
 STATUS_CRC_ERROR                 EQU 0C000003FH

;;
;; MessageId: STATUS_SECTION_TOO_BIG
;;
;; MessageText:
;;
;;  {Section Too Large}
;;  The specified section is too big to map the file.
;;
 STATUS_SECTION_TOO_BIG           EQU 0C0000040H

;;
;; MessageId: STATUS_PORT_CONNECTION_REFUSED
;;
;; MessageText:
;;
;;  The NtConnectPort request is refused.
;;
 STATUS_PORT_CONNECTION_REFUSED   EQU 0C0000041H

;;
;; MessageId: STATUS_INVALID_PORT_HANDLE
;;
;; MessageText:
;;
;;  The type of port handle is invalid for the operation requested.
;;
 STATUS_INVALID_PORT_HANDLE       EQU 0C0000042H

;;
;; MessageId: STATUS_SHARING_VIOLATION
;;
;; MessageText:
;;
;;  A file cannot be opened because the share access flags are
;;  incompatible.
;;
 STATUS_SHARING_VIOLATION         EQU 0C0000043H

;;
;; MessageId: STATUS_QUOTA_EXCEEDED
;;
;; MessageText:
;;
;;  Insufficient quota exists to complete the operation
;;
 STATUS_QUOTA_EXCEEDED            EQU 0C0000044H

;;
;; MessageId: STATUS_INVALID_PAGE_PROTECTION
;;
;; MessageText:
;;
;;  The specified page protection was not valid.
;;
 STATUS_INVALID_PAGE_PROTECTION   EQU 0C0000045H

;;
;; MessageId: STATUS_MUTANT_NOT_OWNED
;;
;; MessageText:
;;
;;  An attempt to release a mutant object was made by a thread that was not the
;;  owner of the mutant object.
;;
 STATUS_MUTANT_NOT_OWNED          EQU 0C0000046H

;;
;; MessageId: STATUS_SEMAPHORE_LIMIT_EXCEEDED
;;
;; MessageText:
;;
;;  An attempt was made to release a semaphore such that its maximum count
;;  would have been exceeded.
;;
 STATUS_SEMAPHORE_LIMIT_EXCEEDED  EQU 0C0000047H

;;
;; MessageId: STATUS_PORT_ALREADY_SET
;;
;; MessageText:
;;
;;  An attempt to set a processes DebugPort or ExceptionPort was made,
;;  but a port already exists in the process.
;;
 STATUS_PORT_ALREADY_SET          EQU 0C0000048H

;;
;; MessageId: STATUS_SECTION_NOT_IMAGE
;;
;; MessageText:
;;
;;  An attempt was made to query image information on a section
;;  which does not map an image.
;;
 STATUS_SECTION_NOT_IMAGE         EQU 0C0000049H

;;
;; MessageId: STATUS_SUSPEND_COUNT_EXCEEDED
;;
;; MessageText:
;;
;;  An attempt was made to suspend a thread whose suspend count
;;  was at its maximum.
;;
 STATUS_SUSPEND_COUNT_EXCEEDED    EQU 0C000004AH

;;
;; MessageId: STATUS_THREAD_IS_TERMINATING
;;
;; MessageText:
;;
;;  An attempt was made to suspend a thread that has begun
;;  termination.
;;
 STATUS_THREAD_IS_TERMINATING     EQU 0C000004BH

;;
;; MessageId: STATUS_BAD_WORKING_SET_LIMIT
;;
;; MessageText:
;;
;;  An attempt was made to set the working set limit to an
;;  invalid value (minimum greater than maximum, etc).
;;
 STATUS_BAD_WORKING_SET_LIMIT     EQU 0C000004CH

;;
;; MessageId: STATUS_INCOMPATIBLE_FILE_MAP
;;
;; MessageText:
;;
;;  A section was created to map a file which is not compatible
;;  to an already existing section which maps the same file.
;;
 STATUS_INCOMPATIBLE_FILE_MAP     EQU 0C000004DH

;;
;; MessageId: STATUS_SECTION_PROTECTION
;;
;; MessageText:
;;
;;  A view to a section specifies a protection which is incompatible
;;  with the initial view's protection.
;;
 STATUS_SECTION_PROTECTION        EQU 0C000004EH

;;
;; MessageId: STATUS_EAS_NOT_SUPPORTED
;;
;; MessageText:
;;
;;  An operation involving EAs failed because the file system does not
;;  support EAs.
;;
 STATUS_EAS_NOT_SUPPORTED         EQU 0C000004FH

;;
;; MessageId: STATUS_EA_TOO_LARGE
;;
;; MessageText:
;;
;;  An EA operation failed because EA set is too large.
;;
 STATUS_EA_TOO_LARGE              EQU 0C0000050H

;;
;; MessageId: STATUS_NONEXISTENT_EA_ENTRY
;;
;; MessageText:
;;
;;  An EA operation failed because the name or EA index is invalid.
;;
 STATUS_NONEXISTENT_EA_ENTRY      EQU 0C0000051H

;;
;; MessageId: STATUS_NO_EAS_ON_FILE
;;
;; MessageText:
;;
;;  The file for which EAs were requested has no EAs.
;;
 STATUS_NO_EAS_ON_FILE            EQU 0C0000052H

;;
;; MessageId: STATUS_EA_CORRUPT_ERROR
;;
;; MessageText:
;;
;;  The EA is corrupt and non-readable.
;;
 STATUS_EA_CORRUPT_ERROR          EQU 0C0000053H

;;
;; MessageId: STATUS_FILE_LOCK_CONFLICT
;;
;; MessageText:
;;
;;  A requested read/write cannot be granted due to a conflicting file lock.
;;
 STATUS_FILE_LOCK_CONFLICT        EQU 0C0000054H

;;
;; MessageId: STATUS_LOCK_NOT_GRANTED
;;
;; MessageText:
;;
;;  A requested file lock cannot be granted due to other existing locks.
;;
 STATUS_LOCK_NOT_GRANTED          EQU 0C0000055H

;;
;; MessageId: STATUS_DELETE_PENDING
;;
;; MessageText:
;;
;;  A non close operation has been requested of a file object with a
;;  delete pending.
;;
 STATUS_DELETE_PENDING            EQU 0C0000056H

;;
;; MessageId: STATUS_CTL_FILE_NOT_SUPPORTED
;;
;; MessageText:
;;
;;  An attempt was made to set the control attribute on a file.  This
;;  attribute is not supported in the target file system.
;;
 STATUS_CTL_FILE_NOT_SUPPORTED    EQU 0C0000057H

;;
;; MessageId: STATUS_UNKNOWN_REVISION
;;
;; MessageText:
;;
;;  Indicates a revision number encountered or specified is not one
;;  known by the service.  It may be a more recent revision than the
;;  service is aware of.
;;
 STATUS_UNKNOWN_REVISION          EQU 0C0000058H

;;
;; MessageId: STATUS_REVISION_MISMATCH
;;
;; MessageText:
;;
;;  Indicates two revision levels are incompatible.
;;
 STATUS_REVISION_MISMATCH         EQU 0C0000059H

;;
;; MessageId: STATUS_INVALID_OWNER
;;
;; MessageText:
;;
;;  Indicates a particular Security ID may not be assigned as the
;;  owner of an object.
;;
 STATUS_INVALID_OWNER             EQU 0C000005AH

;;
;; MessageId: STATUS_INVALID_PRIMARY_GROUP
;;
;; MessageText:
;;
;;  Indicates a particular Security ID may not be assigned as the
;;  primary group of an object.
;;
 STATUS_INVALID_PRIMARY_GROUP     EQU 0C000005BH

;;
;; MessageId: STATUS_NO_IMPERSONATION_TOKEN
;;
;; MessageText:
;;
;;  An attempt has been made to operate on an impersonation token
;;  by a thread that is not currently impersonating a client.
;;
 STATUS_NO_IMPERSONATION_TOKEN    EQU 0C000005CH

;;
;; MessageId: STATUS_CANT_DISABLE_MANDATORY
;;
;; MessageText:
;;
;;  A mandatory group may not be disabled.
;;
 STATUS_CANT_DISABLE_MANDATORY    EQU 0C000005DH

;;
;; MessageId: STATUS_NO_LOGON_SERVERS
;;
;; MessageText:
;;
;;  There are currently no logon servers available to service the logon
;;  request.
;;
 STATUS_NO_LOGON_SERVERS          EQU 0C000005EH

;;
;; MessageId: STATUS_NO_SUCH_LOGON_SESSION
;;
;; MessageText:
;;
;;   A specified logon session does not exist.  It may already have
;;   been terminated.
;;
 STATUS_NO_SUCH_LOGON_SESSION     EQU 0C000005FH

;;
;; MessageId: STATUS_NO_SUCH_PRIVILEGE
;;
;; MessageText:
;;
;;   A specified privilege does not exist.
;;
 STATUS_NO_SUCH_PRIVILEGE         EQU 0C0000060H

;;
;; MessageId: STATUS_PRIVILEGE_NOT_HELD
;;
;; MessageText:
;;
;;   A required privilege is not held by the client.
;;
 STATUS_PRIVILEGE_NOT_HELD        EQU 0C0000061H

;;
;; MessageId: STATUS_INVALID_ACCOUNT_NAME
;;
;; MessageText:
;;
;;  The name provided is not a properly formed account name.
;;
 STATUS_INVALID_ACCOUNT_NAME      EQU 0C0000062H

;;
;; MessageId: STATUS_USER_EXISTS
;;
;; MessageText:
;;
;;  The specified user already exists.
;;
 STATUS_USER_EXISTS               EQU 0C0000063H

;;
;; MessageId: STATUS_NO_SUCH_USER
;;
;; MessageText:
;;
;;  The specified user does not exist.
;;
 STATUS_NO_SUCH_USER              EQU 0C0000064H     ;; ntsubauth

;;
;; MessageId: STATUS_GROUP_EXISTS
;;
;; MessageText:
;;
;;  The specified group already exists.
;;
 STATUS_GROUP_EXISTS              EQU 0C0000065H

;;
;; MessageId: STATUS_NO_SUCH_GROUP
;;
;; MessageText:
;;
;;  The specified group does not exist.
;;
 STATUS_NO_SUCH_GROUP             EQU 0C0000066H

;;
;; MessageId: STATUS_MEMBER_IN_GROUP
;;
;; MessageText:
;;
;;  The specified user account is already in the specified group account.
;;  Also used to indicate a group cannot be deleted because it contains
;;  a member.
;;
 STATUS_MEMBER_IN_GROUP           EQU 0C0000067H

;;
;; MessageId: STATUS_MEMBER_NOT_IN_GROUP
;;
;; MessageText:
;;
;;  The specified user account is not a member of the specified group account.
;;
 STATUS_MEMBER_NOT_IN_GROUP       EQU 0C0000068H

;;
;; MessageId: STATUS_LAST_ADMIN
;;
;; MessageText:
;;
;;  Indicates the requested operation would disable or delete the last
;;  remaining administration account.  This is not allowed to prevent
;;  creating a situation in which the system cannot be administrated.
;;
 STATUS_LAST_ADMIN                EQU 0C0000069H

;;
;; MessageId: STATUS_WRONG_PASSWORD
;;
;; MessageText:
;;
;;  When trying to update a password, this return status indicates that
;;  the value provided as the current password is not correct.
;;
 STATUS_WRONG_PASSWORD            EQU 0C000006AH     ;; ntsubauth

;;
;; MessageId: STATUS_ILL_FORMED_PASSWORD
;;
;; MessageText:
;;
;;  When trying to update a password, this return status indicates that
;;  the value provided for the new password contains values that are
;;  not allowed in passwords.
;;
 STATUS_ILL_FORMED_PASSWORD       EQU 0C000006BH

;;
;; MessageId: STATUS_PASSWORD_RESTRICTION
;;
;; MessageText:
;;
;;  When trying to update a password, this status indicates that some
;;  password update rule has been violated.  For example, the password
;;  may not meet length criteria.
;;
 STATUS_PASSWORD_RESTRICTION      EQU 0C000006CH     ;; ntsubauth

;;
;; MessageId: STATUS_LOGON_FAILURE
;;
;; MessageText:
;;
;;  The attempted logon is invalid.  This is either due to a bad username
;;  or authentication information.
;;
 STATUS_LOGON_FAILURE             EQU 0C000006DH     ;; ntsubauth

;;
;; MessageId: STATUS_ACCOUNT_RESTRICTION
;;
;; MessageText:
;;
;;  Indicates a referenced user name and authentication information are
;;  valid, but some user account restriction has prevented successful
;;  authentication (such as time-of-day restrictions).
;;
 STATUS_ACCOUNT_RESTRICTION       EQU 0C000006EH     ;; ntsubauth

;;
;; MessageId: STATUS_INVALID_LOGON_HOURS
;;
;; MessageText:
;;
;;  The user account has time restrictions and may not be logged onto
;;  at this time.
;;
 STATUS_INVALID_LOGON_HOURS       EQU 0C000006FH     ;; ntsubauth

;;
;; MessageId: STATUS_INVALID_WORKSTATION
;;
;; MessageText:
;;
;;  The user account is restricted such that it may not be used to
;;  log on from the source workstation.
;;
 STATUS_INVALID_WORKSTATION       EQU 0C0000070H     ;; ntsubauth

;;
;; MessageId: STATUS_PASSWORD_EXPIRED
;;
;; MessageText:
;;
;;  The user account's password has expired.
;;
 STATUS_PASSWORD_EXPIRED          EQU 0C0000071H     ;; ntsubauth

;;
;; MessageId: STATUS_ACCOUNT_DISABLED
;;
;; MessageText:
;;
;;  The referenced account is currently disabled and may not be logged on to.
;;
 STATUS_ACCOUNT_DISABLED          EQU 0C0000072H     ;; ntsubauth

;;
;; MessageId: STATUS_NONE_MAPPED
;;
;; MessageText:
;;
;;  None of the information to be translated has been translated.
;;
 STATUS_NONE_MAPPED               EQU 0C0000073H

;;
;; MessageId: STATUS_TOO_MANY_LUIDS_REQUESTED
;;
;; MessageText:
;;
;;  The number of LUIDs requested may not be allocated with a single
;;  allocation.
;;
 STATUS_TOO_MANY_LUIDS_REQUESTED  EQU 0C0000074H

;;
;; MessageId: STATUS_LUIDS_EXHAUSTED
;;
;; MessageText:
;;
;;  Indicates there are no more LUIDs to allocate.
;;
 STATUS_LUIDS_EXHAUSTED           EQU 0C0000075H

;;
;; MessageId: STATUS_INVALID_SUB_AUTHORITY
;;
;; MessageText:
;;
;;  Indicates the sub-authority value is invalid for the particular use.
;;
 STATUS_INVALID_SUB_AUTHORITY     EQU 0C0000076H

;;
;; MessageId: STATUS_INVALID_ACL
;;
;; MessageText:
;;
;;  Indicates the ACL structure is not valid.
;;
 STATUS_INVALID_ACL               EQU 0C0000077H

;;
;; MessageId: STATUS_INVALID_SID
;;
;; MessageText:
;;
;;  Indicates the SID structure is not valid.
;;
 STATUS_INVALID_SID               EQU 0C0000078H

;;
;; MessageId: STATUS_INVALID_SECURITY_DESCR
;;
;; MessageText:
;;
;;  Indicates the SECURITY_DESCRIPTOR structure is not valid.
;;
 STATUS_INVALID_SECURITY_DESCR    EQU 0C0000079H

;;
;; MessageId: STATUS_PROCEDURE_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified procedure address cannot be found in the
;;  DLL.
;;
 STATUS_PROCEDURE_NOT_FOUND       EQU 0C000007AH

;;
;; MessageId: STATUS_INVALID_IMAGE_FORMAT
;;
;; MessageText:
;;
;;  {Bad Image}
;;  The application or DLL %s is not a valid Windows NT image.
;;  Please check this against your installation diskette.
;;
 STATUS_INVALID_IMAGE_FORMAT      EQU 0C000007BH

;;
;; MessageId: STATUS_NO_TOKEN
;;
;; MessageText:
;;
;;  An attempt was made to reference a token that doesn't exist.
;;  This is typically done by referencing the token associated with a thread
;;  when the thread is not impersonating a client.
;;
 STATUS_NO_TOKEN                  EQU 0C000007CH

;;
;; MessageId: STATUS_BAD_INHERITANCE_ACL
;;
;; MessageText:
;;
;;  Indicates that an attempt to build either an inherited ACL or ACE
;;  was not successful.
;;  This can be caused by a number of things.  One of the more probable
;;  causes is the replacement of a CreatorId with an SID that didn't fit
;;  into the ACE or ACL.
;;
 STATUS_BAD_INHERITANCE_ACL       EQU 0C000007DH

;;
;; MessageId: STATUS_RANGE_NOT_LOCKED
;;
;; MessageText:
;;
;;  The range specified in NtUnlockFile was not locked.
;;
 STATUS_RANGE_NOT_LOCKED          EQU 0C000007EH

;;
;; MessageId: STATUS_DISK_FULL
;;
;; MessageText:
;;
;;  An operation failed because the disk was full.
;;
 STATUS_DISK_FULL                 EQU 0C000007FH

;;
;; MessageId: STATUS_SERVER_DISABLED
;;
;; MessageText:
;;
;;  The GUID allocation server is [already] disabled at the moment.
;;
 STATUS_SERVER_DISABLED           EQU 0C0000080H

;;
;; MessageId: STATUS_SERVER_NOT_DISABLED
;;
;; MessageText:
;;
;;  The GUID allocation server is [already] enabled at the moment.
;;
 STATUS_SERVER_NOT_DISABLED       EQU 0C0000081H

;;
;; MessageId: STATUS_TOO_MANY_GUIDS_REQUESTED
;;
;; MessageText:
;;
;;  Too many GUIDs were requested from the allocation server at once.
;;
 STATUS_TOO_MANY_GUIDS_REQUESTED  EQU 0C0000082H

;;
;; MessageId: STATUS_GUIDS_EXHAUSTED
;;
;; MessageText:
;;
;;  The GUIDs could not be allocated because the Authority Agent was
;;  exhausted.
;;
 STATUS_GUIDS_EXHAUSTED           EQU 0C0000083H

;;
;; MessageId: STATUS_INVALID_ID_AUTHORITY
;;
;; MessageText:
;;
;;  The value provided was an invalid value for an identifier authority.
;;
 STATUS_INVALID_ID_AUTHORITY      EQU 0C0000084H

;;
;; MessageId: STATUS_AGENTS_EXHAUSTED
;;
;; MessageText:
;;
;;  There are no more authority agent values available for the given
;;  identifier authority value.
;;
 STATUS_AGENTS_EXHAUSTED          EQU 0C0000085H

;;
;; MessageId: STATUS_INVALID_VOLUME_LABEL
;;
;; MessageText:
;;
;;  An invalid volume label has been specified.
;;
 STATUS_INVALID_VOLUME_LABEL      EQU 0C0000086H

;;
;; MessageId: STATUS_SECTION_NOT_EXTENDED
;;
;; MessageText:
;;
;;  A mapped section could not be extended.
;;
 STATUS_SECTION_NOT_EXTENDED      EQU 0C0000087H

;;
;; MessageId: STATUS_NOT_MAPPED_DATA
;;
;; MessageText:
;;
;;  Specified section to flush does not map a data file.
;;
 STATUS_NOT_MAPPED_DATA           EQU 0C0000088H

;;
;; MessageId: STATUS_RESOURCE_DATA_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified image file did not contain a resource
;;  section.
;;
 STATUS_RESOURCE_DATA_NOT_FOUND   EQU 0C0000089H

;;
;; MessageId: STATUS_RESOURCE_TYPE_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified resource type cannot be found in the
;;  image file.
;;
 STATUS_RESOURCE_TYPE_NOT_FOUND   EQU 0C000008AH

;;
;; MessageId: STATUS_RESOURCE_NAME_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified resource name cannot be found in the
;;  image file.
;;
 STATUS_RESOURCE_NAME_NOT_FOUND   EQU 0C000008BH

;;
;; MessageId: STATUS_ARRAY_BOUNDS_EXCEEDED
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Array bounds exceeded.
;;
 STATUS_ARRAY_BOUNDS_EXCEEDED     EQU 0C000008CH    ;; winnt

;;
;; MessageId: STATUS_FLOAT_DENORMAL_OPERAND
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point denormal operand.
;;
 STATUS_FLOAT_DENORMAL_OPERAND    EQU 0C000008DH    ;; winnt

;;
;; MessageId: STATUS_FLOAT_DIVIDE_BY_ZERO
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point division by zero.
;;
 STATUS_FLOAT_DIVIDE_BY_ZERO      EQU 0C000008EH    ;; winnt

;;
;; MessageId: STATUS_FLOAT_INEXACT_RESULT
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point inexact result.
;;
 STATUS_FLOAT_INEXACT_RESULT      EQU 0C000008FH    ;; winnt

;;
;; MessageId: STATUS_FLOAT_INVALID_OPERATION
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point invalid operation.
;;
 STATUS_FLOAT_INVALID_OPERATION   EQU 0C0000090H    ;; winnt

;;
;; MessageId: STATUS_FLOAT_OVERFLOW
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point overflow.
;;
 STATUS_FLOAT_OVERFLOW            EQU 0C0000091H    ;; winnt

;;
;; MessageId: STATUS_FLOAT_STACK_CHECK
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point stack check.
;;
 STATUS_FLOAT_STACK_CHECK         EQU 0C0000092H    ;; winnt

;;
;; MessageId: STATUS_FLOAT_UNDERFLOW
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Floating-point underflow.
;;
 STATUS_FLOAT_UNDERFLOW           EQU 0C0000093H    ;; winnt

;;
;; MessageId: STATUS_INTEGER_DIVIDE_BY_ZERO
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Integer division by zero.
;;
 STATUS_INTEGER_DIVIDE_BY_ZERO    EQU 0C0000094H    ;; winnt

;;
;; MessageId: STATUS_INTEGER_OVERFLOW
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Integer overflow.
;;
 STATUS_INTEGER_OVERFLOW          EQU 0C0000095H    ;; winnt

;;
;; MessageId: STATUS_PRIVILEGED_INSTRUCTION
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Privileged instruction.
;;
 STATUS_PRIVILEGED_INSTRUCTION    EQU 0C0000096H    ;; winnt

;;
;; MessageId: STATUS_TOO_MANY_PAGING_FILES
;;
;; MessageText:
;;
;;  An attempt was made to install more paging files than the
;;  system supports.
;;
 STATUS_TOO_MANY_PAGING_FILES     EQU 0C0000097H

;;
;; MessageId: STATUS_FILE_INVALID
;;
;; MessageText:
;;
;;  The volume for a file has been externally altered such that the
;;  opened file is no longer valid.
;;
 STATUS_FILE_INVALID              EQU 0C0000098H

;;
;; MessageId: STATUS_ALLOTTED_SPACE_EXCEEDED
;;
;; MessageText:
;;
;;  When a block of memory is allotted for future updates, such as the memory
;;  allocated to hold discretionary access control and primary group information,
;;  successive updates may exceed the amount of memory originally allotted.
;;  Since quota may already have been charged to several processes which have
;;  handles to the object, it is not reasonable to alter the size of the
;;  allocated memory.  Instead, a request that requires more memory than has
;;  been allotted must fail and the STATUS_ALLOTED_SPACE_EXCEEDED error returned.
;;
 STATUS_ALLOTTED_SPACE_EXCEEDED   EQU 0C0000099H

;;
;; MessageId: STATUS_INSUFFICIENT_RESOURCES
;;
;; MessageText:
;;
;;  Insufficient system resources exist to complete the API.
;;
 STATUS_INSUFFICIENT_RESOURCES    EQU 0C000009AH     ;; ntsubauth

;;
;; MessageId: STATUS_DFS_EXIT_PATH_FOUND
;;
;; MessageText:
;;
;;  An attempt has been made to open a DFS exit path control file.
;;
 STATUS_DFS_EXIT_PATH_FOUND       EQU 0C000009BH

;;
;; MessageId: STATUS_DEVICE_DATA_ERROR
;;
;; MessageText:
;;
;;  STATUS_DEVICE_DATA_ERROR
;;
 STATUS_DEVICE_DATA_ERROR         EQU 0C000009CH

;;
;; MessageId: STATUS_DEVICE_NOT_CONNECTED
;;
;; MessageText:
;;
;;  STATUS_DEVICE_NOT_CONNECTED
;;
 STATUS_DEVICE_NOT_CONNECTED      EQU 0C000009DH

;;
;; MessageId: STATUS_DEVICE_POWER_FAILURE
;;
;; MessageText:
;;
;;  STATUS_DEVICE_POWER_FAILURE
;;
 STATUS_DEVICE_POWER_FAILURE      EQU 0C000009EH

;;
;; MessageId: STATUS_FREE_VM_NOT_AT_BASE
;;
;; MessageText:
;;
;;  Virtual memory cannot be freed as base address is not the base
;;  of the region and a region size of zero was specified.
;;
 STATUS_FREE_VM_NOT_AT_BASE       EQU 0C000009FH

;;
;; MessageId: STATUS_MEMORY_NOT_ALLOCATED
;;
;; MessageText:
;;
;;  An attempt was made to free virtual memory which is not allocated.
;;
 STATUS_MEMORY_NOT_ALLOCATED      EQU 0C00000A0H

;;
;; MessageId: STATUS_WORKING_SET_QUOTA
;;
;; MessageText:
;;
;;  The working set is not big enough to allow the requested pages to be
;;  locked.
;;
 STATUS_WORKING_SET_QUOTA         EQU 0C00000A1H

;;
;; MessageId: STATUS_MEDIA_WRITE_PROTECTED
;;
;; MessageText:
;;
;;  {Write Protect Error}
;;  The disk cannot be written to because it is write protected.
;;  Please remove the write protection from the volume %s in drive %s.
;;
 STATUS_MEDIA_WRITE_PROTECTED     EQU 0C00000A2H

;;
;; MessageId: STATUS_DEVICE_NOT_READY
;;
;; MessageText:
;;
;;  {Drive Not Ready}
;;  The drive is not ready for use; its door may be open.
;;  Please check drive %s and make sure that a disk is inserted
;;  and that the drive door is closed.
;;
 STATUS_DEVICE_NOT_READY          EQU 0C00000A3H

;;
;; MessageId: STATUS_INVALID_GROUP_ATTRIBUTES
;;
;; MessageText:
;;
;;  The specified attributes are invalid, or incompatible with the
;;  attributes for the group as a whole.
;;
 STATUS_INVALID_GROUP_ATTRIBUTES  EQU 0C00000A4H

;;
;; MessageId: STATUS_BAD_IMPERSONATION_LEVEL
;;
;; MessageText:
;;
;;  A specified impersonation level is invalid.
;;  Also used to indicate a required impersonation level was not provided.
;;
 STATUS_BAD_IMPERSONATION_LEVEL   EQU 0C00000A5H

;;
;; MessageId: STATUS_CANT_OPEN_ANONYMOUS
;;
;; MessageText:
;;
;;  An attempt was made to open an Anonymous level token.
;;  Anonymous tokens may not be opened.
;;
 STATUS_CANT_OPEN_ANONYMOUS       EQU 0C00000A6H

;;
;; MessageId: STATUS_BAD_VALIDATION_CLASS
;;
;; MessageText:
;;
;;  The validation information class requested was invalid.
;;
 STATUS_BAD_VALIDATION_CLASS      EQU 0C00000A7H

;;
;; MessageId: STATUS_BAD_TOKEN_TYPE
;;
;; MessageText:
;;
;;  The type of a token object is inappropriate for its attempted use.
;;
 STATUS_BAD_TOKEN_TYPE            EQU 0C00000A8H

;;
;; MessageId: STATUS_BAD_MASTER_BOOT_RECORD
;;
;; MessageText:
;;
;;  The type of a token object is inappropriate for its attempted use.
;;
 STATUS_BAD_MASTER_BOOT_RECORD    EQU 0C00000A9H

;;
;; MessageId: STATUS_INSTRUCTION_MISALIGNMENT
;;
;; MessageText:
;;
;;  An attempt was made to execute an instruction at an unaligned address
;;  and the host system does not support unaligned instruction references.
;;
 STATUS_INSTRUCTION_MISALIGNMENT  EQU 0C00000AAH

;;
;; MessageId: STATUS_INSTANCE_NOT_AVAILABLE
;;
;; MessageText:
;;
;;  The maximum named pipe instance count has been reached.
;;
 STATUS_INSTANCE_NOT_AVAILABLE    EQU 0C00000ABH

;;
;; MessageId: STATUS_PIPE_NOT_AVAILABLE
;;
;; MessageText:
;;
;;  An instance of a named pipe cannot be found in the listening state.
;;
 STATUS_PIPE_NOT_AVAILABLE        EQU 0C00000ACH

;;
;; MessageId: STATUS_INVALID_PIPE_STATE
;;
;; MessageText:
;;
;;  The named pipe is not in the connected or closing state.
;;
 STATUS_INVALID_PIPE_STATE        EQU 0C00000ADH

;;
;; MessageId: STATUS_PIPE_BUSY
;;
;; MessageText:
;;
;;  The specified pipe is set to complete operations and there are current
;;  I/O operations queued so it cannot be changed to queue operations.
;;
 STATUS_PIPE_BUSY                 EQU 0C00000AEH

;;
;; MessageId: STATUS_ILLEGAL_FUNCTION
;;
;; MessageText:
;;
;;  The specified handle is not open to the server end of the named pipe.
;;
 STATUS_ILLEGAL_FUNCTION          EQU 0C00000AFH

;;
;; MessageId: STATUS_PIPE_DISCONNECTED
;;
;; MessageText:
;;
;;  The specified named pipe is in the disconnected state.
;;
 STATUS_PIPE_DISCONNECTED         EQU 0C00000B0H

;;
;; MessageId: STATUS_PIPE_CLOSING
;;
;; MessageText:
;;
;;  The specified named pipe is in the closing state.
;;
 STATUS_PIPE_CLOSING              EQU 0C00000B1H

;;
;; MessageId: STATUS_PIPE_CONNECTED
;;
;; MessageText:
;;
;;  The specified named pipe is in the connected state.
;;
 STATUS_PIPE_CONNECTED            EQU 0C00000B2H

;;
;; MessageId: STATUS_PIPE_LISTENING
;;
;; MessageText:
;;
;;  The specified named pipe is in the listening state.
;;
 STATUS_PIPE_LISTENING            EQU 0C00000B3H

;;
;; MessageId: STATUS_INVALID_READ_MODE
;;
;; MessageText:
;;
;;  The specified named pipe is not in message mode.
;;
 STATUS_INVALID_READ_MODE         EQU 0C00000B4H

;;
;; MessageId: STATUS_IO_TIMEOUT
;;
;; MessageText:
;;
;;  {Device Timeout}
;;  The specified I/O operation on %s was not completed before the time-out
;;  period expired.
;;
 STATUS_IO_TIMEOUT                EQU 0C00000B5H

;;
;; MessageId: STATUS_FILE_FORCED_CLOSED
;;
;; MessageText:
;;
;;  The specified file has been closed by another process.
;;
 STATUS_FILE_FORCED_CLOSED        EQU 0C00000B6H

;;
;; MessageId: STATUS_PROFILING_NOT_STARTED
;;
;; MessageText:
;;
;;  Profiling not started.
;;
 STATUS_PROFILING_NOT_STARTED     EQU 0C00000B7H

;;
;; MessageId: STATUS_PROFILING_NOT_STOPPED
;;
;; MessageText:
;;
;;  Profiling not stopped.
;;
 STATUS_PROFILING_NOT_STOPPED     EQU 0C00000B8H

;;
;; MessageId: STATUS_COULD_NOT_INTERPRET
;;
;; MessageText:
;;
;;  The passed ACL did not contain the minimum required information.
;;
 STATUS_COULD_NOT_INTERPRET       EQU 0C00000B9H

;;
;; MessageId: STATUS_FILE_IS_A_DIRECTORY
;;
;; MessageText:
;;
;;  The file that was specified as a target is a directory and the caller
;;  specified that it could be anything but a directory.
;;
 STATUS_FILE_IS_A_DIRECTORY       EQU 0C00000BAH

;;
;; Network specific errors.
;;
;;
;;
;; MessageId: STATUS_NOT_SUPPORTED
;;
;; MessageText:
;;
;;  The network request is not supported.
;;
 STATUS_NOT_SUPPORTED             EQU 0C00000BBH

;;
;; MessageId: STATUS_REMOTE_NOT_LISTENING
;;
;; MessageText:
;;
;;  This remote computer is not listening.
;;
 STATUS_REMOTE_NOT_LISTENING      EQU 0C00000BCH

;;
;; MessageId: STATUS_DUPLICATE_NAME
;;
;; MessageText:
;;
;;  A duplicate name exists on the network.
;;
 STATUS_DUPLICATE_NAME            EQU 0C00000BDH

;;
;; MessageId: STATUS_BAD_NETWORK_PATH
;;
;; MessageText:
;;
;;  The network path cannot be located.
;;
 STATUS_BAD_NETWORK_PATH          EQU 0C00000BEH

;;
;; MessageId: STATUS_NETWORK_BUSY
;;
;; MessageText:
;;
;;  The network is busy.
;;
 STATUS_NETWORK_BUSY              EQU 0C00000BFH

;;
;; MessageId: STATUS_DEVICE_DOES_NOT_EXIST
;;
;; MessageText:
;;
;;  This device does not exist.
;;
 STATUS_DEVICE_DOES_NOT_EXIST     EQU 0C00000C0H

;;
;; MessageId: STATUS_TOO_MANY_COMMANDS
;;
;; MessageText:
;;
;;  The network BIOS command limit has been reached.
;;
 STATUS_TOO_MANY_COMMANDS         EQU 0C00000C1H

;;
;; MessageId: STATUS_ADAPTER_HARDWARE_ERROR
;;
;; MessageText:
;;
;;  An I/O adapter hardware error has occurred.
;;
 STATUS_ADAPTER_HARDWARE_ERROR    EQU 0C00000C2H

;;
;; MessageId: STATUS_INVALID_NETWORK_RESPONSE
;;
;; MessageText:
;;
;;  The network responded incorrectly.
;;
 STATUS_INVALID_NETWORK_RESPONSE  EQU 0C00000C3H

;;
;; MessageId: STATUS_UNEXPECTED_NETWORK_ERROR
;;
;; MessageText:
;;
;;  An unexpected network error occurred.
;;
 STATUS_UNEXPECTED_NETWORK_ERROR  EQU 0C00000C4H

;;
;; MessageId: STATUS_BAD_REMOTE_ADAPTER
;;
;; MessageText:
;;
;;  The remote adapter is not compatible.
;;
 STATUS_BAD_REMOTE_ADAPTER        EQU 0C00000C5H

;;
;; MessageId: STATUS_PRINT_QUEUE_FULL
;;
;; MessageText:
;;
;;  The printer queue is full.
;;
 STATUS_PRINT_QUEUE_FULL          EQU 0C00000C6H

;;
;; MessageId: STATUS_NO_SPOOL_SPACE
;;
;; MessageText:
;;
;;  Space to store the file waiting to be printed is not available on the server.
;;
 STATUS_NO_SPOOL_SPACE            EQU 0C00000C7H

;;
;; MessageId: STATUS_PRINT_CANCELLED
;;
;; MessageText:
;;
;;  The requested print file has been canceled.
;;
 STATUS_PRINT_CANCELLED           EQU 0C00000C8H

;;
;; MessageId: STATUS_NETWORK_NAME_DELETED
;;
;; MessageText:
;;
;;  The network name was deleted.
;;
 STATUS_NETWORK_NAME_DELETED      EQU 0C00000C9H

;;
;; MessageId: STATUS_NETWORK_ACCESS_DENIED
;;
;; MessageText:
;;
;;  Network access is denied.
;;
 STATUS_NETWORK_ACCESS_DENIED     EQU 0C00000CAH

;;
;; MessageId: STATUS_BAD_DEVICE_TYPE
;;
;; MessageText:
;;
;;  {Incorrect Network Resource Type}
;;  The specified device type (LPT, for example) conflicts with the actual
;;  device type on the remote resource.
;;
 STATUS_BAD_DEVICE_TYPE           EQU 0C00000CBH

;;
;; MessageId: STATUS_BAD_NETWORK_NAME
;;
;; MessageText:
;;
;;  {Network Name Not Found}
;;  The specified share name cannot be found on the remote server.
;;
 STATUS_BAD_NETWORK_NAME          EQU 0C00000CCH

;;
;; MessageId: STATUS_TOO_MANY_NAMES
;;
;; MessageText:
;;
;;  The name limit for the local computer network adapter card was exceeded.
;;
 STATUS_TOO_MANY_NAMES            EQU 0C00000CDH

;;
;; MessageId: STATUS_TOO_MANY_SESSIONS
;;
;; MessageText:
;;
;;  The network BIOS session limit was exceeded.
;;
 STATUS_TOO_MANY_SESSIONS         EQU 0C00000CEH

;;
;; MessageId: STATUS_SHARING_PAUSED
;;
;; MessageText:
;;
;;  File sharing has been temporarily paused.
;;
 STATUS_SHARING_PAUSED            EQU 0C00000CFH

;;
;; MessageId: STATUS_REQUEST_NOT_ACCEPTED
;;
;; MessageText:
;;
;;  No more connections can be made to this remote computer at this time
;;  because there are already as many connections as the computer can accept.
;;
 STATUS_REQUEST_NOT_ACCEPTED      EQU 0C00000D0H

;;
;; MessageId: STATUS_REDIRECTOR_PAUSED
;;
;; MessageText:
;;
;;  Print or disk redirection is temporarily paused.
;;
 STATUS_REDIRECTOR_PAUSED         EQU 0C00000D1H

;;
;; MessageId: STATUS_NET_WRITE_FAULT
;;
;; MessageText:
;;
;;  A network data fault occurred.
;;
 STATUS_NET_WRITE_FAULT           EQU 0C00000D2H

;;
;; MessageId: STATUS_PROFILING_AT_LIMIT
;;
;; MessageText:
;;
;;  The number of active profiling objects is at the maximum and no more may be started.
;;
 STATUS_PROFILING_AT_LIMIT        EQU 0C00000D3H

;;
;; MessageId: STATUS_NOT_SAME_DEVICE
;;
;; MessageText:
;;
;;  {Incorrect Volume}
;;  The target file of a rename request is located on a different device
;;  than the source of the rename request.
;;
 STATUS_NOT_SAME_DEVICE           EQU 0C00000D4H

;;
;; MessageId: STATUS_FILE_RENAMED
;;
;; MessageText:
;;
;;  The file specified has been renamed and thus cannot be modified.
;;
 STATUS_FILE_RENAMED              EQU 0C00000D5H

;;
;; MessageId: STATUS_VIRTUAL_CIRCUIT_CLOSED
;;
;; MessageText:
;;
;;  {Network Request Timeout}
;;  The session with a remote server has been disconnected because the time-out
;;  interval for a request has expired.
;;
 STATUS_VIRTUAL_CIRCUIT_CLOSED    EQU 0C00000D6H

;;
;; MessageId: STATUS_NO_SECURITY_ON_OBJECT
;;
;; MessageText:
;;
;;  Indicates an attempt was made to operate on the security of
;;  an object that does not have security associated with it.
;;
 STATUS_NO_SECURITY_ON_OBJECT     EQU 0C00000D7H

;;
;; MessageId: STATUS_CANT_WAIT
;;
;; MessageText:
;;
;;  Used to indicate that an operation cannot continue without blocking
;;  for I/O.
;;
 STATUS_CANT_WAIT                 EQU 0C00000D8H

;;
;; MessageId: STATUS_PIPE_EMPTY
;;
;; MessageText:
;;
;;  Used to indicate that a read operation was done on an empty pipe.
;;
 STATUS_PIPE_EMPTY                EQU 0C00000D9H

;;
;; MessageId: STATUS_CANT_ACCESS_DOMAIN_INFO
;;
;; MessageText:
;;
;;  Indicates a Windows NT Server could not be contacted or that
;;  objects within the domain are protected such that necessary
;;  information could not be retrieved.
;;
 STATUS_CANT_ACCESS_DOMAIN_INFO   EQU 0C00000DAH

;;
;; MessageId: STATUS_CANT_TERMINATE_SELF
;;
;; MessageText:
;;
;;  Indicates that a thread attempted to terminate itself by default
;;  (called NtTerminateThread with NULH and it was the last thread
;;  in the current process.
;;
 STATUS_CANT_TERMINATE_SELF       EQU 0C00000DBH

;;
;; MessageId: STATUS_INVALID_SERVER_STATE
;;
;; MessageText:
;;
;;  Indicates the Sam Server was in the wrong state to
;;  perform the desired operation.
;;
 STATUS_INVALID_SERVER_STATE      EQU 0C00000DCH

;;
;; MessageId: STATUS_INVALID_DOMAIN_STATE
;;
;; MessageText:
;;
;;  Indicates the Domain was in the wrong state to
;;  perform the desired operation.
;;
 STATUS_INVALID_DOMAIN_STATE      EQU 0C00000DDH

;;
;; MessageId: STATUS_INVALID_DOMAIN_ROLE
;;
;; MessageText:
;;
;;  This operation is only allowed for the Primary Domain Controller of the domain.
;;
 STATUS_INVALID_DOMAIN_ROLE       EQU 0C00000DEH

;;
;; MessageId: STATUS_NO_SUCH_DOMAIN
;;
;; MessageText:
;;
;;  The specified Domain did not exist.
;;
 STATUS_NO_SUCH_DOMAIN            EQU 0C00000DFH

;;
;; MessageId: STATUS_DOMAIN_EXISTS
;;
;; MessageText:
;;
;;  The specified Domain already exists.
;;
 STATUS_DOMAIN_EXISTS             EQU 0C00000E0H

;;
;; MessageId: STATUS_DOMAIN_LIMIT_EXCEEDED
;;
;; MessageText:
;;
;;  An attempt was made to exceed the limit on the number of domains per server
;;  for this release.
;;
 STATUS_DOMAIN_LIMIT_EXCEEDED     EQU 0C00000E1H

;;
;; MessageId: STATUS_OPLOCK_NOT_GRANTED
;;
;; MessageText:
;;
;;  Error status returned when oplock request is denied.
;;
 STATUS_OPLOCK_NOT_GRANTED        EQU 0C00000E2H

;;
;; MessageId: STATUS_INVALID_OPLOCK_PROTOCOL
;;
;; MessageText:
;;
;;  Error status returned when an invalid oplock acknowledgment
;;  is received by a file system.
;;
 STATUS_INVALID_OPLOCK_PROTOCOL   EQU 0C00000E3H

;;
;; MessageId: STATUS_INTERNAL_DB_CORRUPTION
;;
;; MessageText:
;;
;;  This error indicates that the requested operation cannot be
;;  completed due to a catastrophic media failure or on-disk data
;;  structure corruption.
;;
 STATUS_INTERNAL_DB_CORRUPTION    EQU 0C00000E4H

;;
;; MessageId: STATUS_INTERNAL_ERROR
;;
;; MessageText:
;;
;;  This error indicates that the SAM server has encountered an
;;  internal consistency error in its database.  This catastrophic
;;  failure will prevent further operation of SAM.
;;
 STATUS_INTERNAL_ERROR            EQU 0C00000E5H

;;
;; MessageId: STATUS_GENERIC_NOT_MAPPED
;;
;; MessageText:
;;
;;  Indicates generic access types were contained in an access mask
;;  which should already be mapped to non-generic access types.
;;
 STATUS_GENERIC_NOT_MAPPED        EQU 0C00000E6H

;;
;; MessageId: STATUS_BAD_DESCRIPTOR_FORMAT
;;
;; MessageText:
;;
;;  Indicates a security descriptor is not in the necessary format (absolute
;;  or self-relative).
;;
 STATUS_BAD_DESCRIPTOR_FORMAT     EQU 0C00000E7H

;;
;; Status codes raised by the Cache Manager which must be considered as
;; "expected" by its callers.
;;
;;
;; MessageId: STATUS_INVALID_USER_BUFFER
;;
;; MessageText:
;;
;;  An access to a user buffer failed at an "expected" point in time.
;;  This code is defined since the caller does not want to accept
;;  STATUS_ACCESS_VIOLATION in its filter.
;;
 STATUS_INVALID_USER_BUFFER       EQU 0C00000E8H

;;
;; MessageId: STATUS_UNEXPECTED_IO_ERROR
;;
;; MessageText:
;;
;;  If an I/O error is returned which is not defined in the standard FsRtl filter,
;;  it is converted to the following error which is guaranteed to be in the
;;  filter.  In this case information is lost, however, the filter correctly
;;  handles the exception.
;;
 STATUS_UNEXPECTED_IO_ERROR       EQU 0C00000E9H

;;
;; MessageId: STATUS_UNEXPECTED_MM_CREATE_ERR
;;
;; MessageText:
;;
;;  If an MM error is returned which is not defined in the standard FsRtl filter,
;;  it is converted to one of the following errors which is guaranteed to be in the
;;  filter.  In this case information is lost, however, the filter correctly
;;  handles the exception.
;;
 STATUS_UNEXPECTED_MM_CREATE_ERR  EQU 0C00000EAH

;;
;; MessageId: STATUS_UNEXPECTED_MM_MAP_ERROR
;;
;; MessageText:
;;
;;  If an MM error is returned which is not defined in the standard FsRtl filter,
;;  it is converted to one of the following errors which is guaranteed to be in the
;;  filter.  In this case information is lost, however, the filter correctly
;;  handles the exception.
;;
 STATUS_UNEXPECTED_MM_MAP_ERROR   EQU 0C00000EBH

;;
;; MessageId: STATUS_UNEXPECTED_MM_EXTEND_ERR
;;
;; MessageText:
;;
;;  If an MM error is returned which is not defined in the standard FsRtl filter,
;;  it is converted to one of the following errors which is guaranteed to be in the
;;  filter.  In this case information is lost, however, the filter correctly
;;  handles the exception.
;;
 STATUS_UNEXPECTED_MM_EXTEND_ERR  EQU 0C00000ECH

;;
;; MessageId: STATUS_NOT_LOGON_PROCESS
;;
;; MessageText:
;;
;;  The requested action is restricted for use by logon processes
;;  only.  The calling process has not registered as a logon process.
;;
 STATUS_NOT_LOGON_PROCESS         EQU 0C00000EDH

;;
;; MessageId: STATUS_LOGON_SESSION_EXISTS
;;
;; MessageText:
;;
;;  An attempt has been made to start a new session manager or
;;  LSA logon session with an ID that is already in use.
;;
 STATUS_LOGON_SESSION_EXISTS      EQU 0C00000EEH

;;
;; MessageId: STATUS_INVALID_PARAMETER_1
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the first argument.
;;
 STATUS_INVALID_PARAMETER_1       EQU 0C00000EFH

;;
;; MessageId: STATUS_INVALID_PARAMETER_2
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the second argument.
;;
 STATUS_INVALID_PARAMETER_2       EQU 0C00000F0H

;;
;; MessageId: STATUS_INVALID_PARAMETER_3
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the third argument.
;;
 STATUS_INVALID_PARAMETER_3       EQU 0C00000F1H

;;
;; MessageId: STATUS_INVALID_PARAMETER_4
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the fourth argument.
;;
 STATUS_INVALID_PARAMETER_4       EQU 0C00000F2H

;;
;; MessageId: STATUS_INVALID_PARAMETER_5
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the fifth argument.
;;
 STATUS_INVALID_PARAMETER_5       EQU 0C00000F3H

;;
;; MessageId: STATUS_INVALID_PARAMETER_6
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the sixth argument.
;;
 STATUS_INVALID_PARAMETER_6       EQU 0C00000F4H

;;
;; MessageId: STATUS_INVALID_PARAMETER_7
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the seventh argument.
;;
 STATUS_INVALID_PARAMETER_7       EQU 0C00000F5H

;;
;; MessageId: STATUS_INVALID_PARAMETER_8
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the eighth argument.
;;
 STATUS_INVALID_PARAMETER_8       EQU 0C00000F6H

;;
;; MessageId: STATUS_INVALID_PARAMETER_9
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the ninth argument.
;;
 STATUS_INVALID_PARAMETER_9       EQU 0C00000F7H

;;
;; MessageId: STATUS_INVALID_PARAMETER_10
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the tenth argument.
;;
 STATUS_INVALID_PARAMETER_10      EQU 0C00000F8H

;;
;; MessageId: STATUS_INVALID_PARAMETER_11
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the eleventh argument.
;;
 STATUS_INVALID_PARAMETER_11      EQU 0C00000F9H

;;
;; MessageId: STATUS_INVALID_PARAMETER_12
;;
;; MessageText:
;;
;;  An invalid parameter was passed to a service or function as
;;  the twelfth argument.
;;
 STATUS_INVALID_PARAMETER_12      EQU 0C00000FAH

;;
;; MessageId: STATUS_REDIRECTOR_NOT_STARTED
;;
;; MessageText:
;;
;;   An attempt was made to access a network file, but the network software
;;   was not yet started.
;;
 STATUS_REDIRECTOR_NOT_STARTED    EQU 0C00000FBH

;;
;; MessageId: STATUS_REDIRECTOR_STARTED
;;
;; MessageText:
;;
;;   An attempt was made to start the redirector, but the redirector
;;   has already been started.
;;
 STATUS_REDIRECTOR_STARTED        EQU 0C00000FCH

;;
;; MessageId: STATUS_STACK_OVERFLOW
;;
;; MessageText:
;;
;;  A new guard page for the stack cannot be created.
;;
 STATUS_STACK_OVERFLOW            EQU 0C00000FDH    ;; winnt

;;
;; MessageId: STATUS_NO_SUCH_PACKAGE
;;
;; MessageText:
;;
;;  A specified authentication package is unknown.
;;
 STATUS_NO_SUCH_PACKAGE           EQU 0C00000FEH

;;
;; MessageId: STATUS_BAD_FUNCTION_TABLE
;;
;; MessageText:
;;
;;  A malformed function table was encountered during an unwind operation.
;;
 STATUS_BAD_FUNCTION_TABLE        EQU 0C00000FFH

;;
;; MessageId: STATUS_VARIABLE_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified environment variable name was not found
;;  in the specified environment block.
;;
 STATUS_VARIABLE_NOT_FOUND        EQU 0C0000100H

;;
;; MessageId: STATUS_DIRECTORY_NOT_EMPTY
;;
;; MessageText:
;;
;;  Indicates that the directory trying to be deleted is not empty.
;;
 STATUS_DIRECTORY_NOT_EMPTY       EQU 0C0000101H

;;
;; MessageId: STATUS_FILE_CORRUPT_ERROR
;;
;; MessageText:
;;
;;  {Corrupt File}
;;  The file or directory %s is corrupt and unreadable.
;;  Please run the Chkdsk utility.
;;
 STATUS_FILE_CORRUPT_ERROR        EQU 0C0000102H

;;
;; MessageId: STATUS_NOT_A_DIRECTORY
;;
;; MessageText:
;;
;;  A requested opened file is not a directory.
;;
 STATUS_NOT_A_DIRECTORY           EQU 0C0000103H

;;
;; MessageId: STATUS_BAD_LOGON_SESSION_STATE
;;
;; MessageText:
;;
;;  The logon session is not in a state that is consistent with the
;;  requested operation.
;;
 STATUS_BAD_LOGON_SESSION_STATE   EQU 0C0000104H

;;
;; MessageId: STATUS_LOGON_SESSION_COLLISION
;;
;; MessageText:
;;
;;  An internal LSA error has occurred.  An authentication package has
;;  requested the creation of a Logon Session but the ID of an already
;;  existing Logon Session has been specified.
;;
 STATUS_LOGON_SESSION_COLLISION   EQU 0C0000105H

;;
;; MessageId: STATUS_NAME_TOO_LONG
;;
;; MessageText:
;;
;;  A specified name string is too long for its intended use.
;;
 STATUS_NAME_TOO_LONG             EQU 0C0000106H

;;
;; MessageId: STATUS_FILES_OPEN
;;
;; MessageText:
;;
;;  The user attempted to force close the files on a redirected
;;  drive, but there were opened files on the drive, and the user
;;  did not specify a sufficient level of force.
;;
 STATUS_FILES_OPEN                EQU 0C0000107H

;;
;; MessageId: STATUS_CONNECTION_IN_USE
;;
;; MessageText:
;;
;;  The user attempted to force close the files on a redirected
;;  drive, but there were opened directories on the drive, and the user
;;  did not specify a sufficient level of force.
;;
 STATUS_CONNECTION_IN_USE         EQU 0C0000108H

;;
;; MessageId: STATUS_MESSAGE_NOT_FOUND
;;
;; MessageText:
;;
;;  RtlFindMessage could not locate the requested message ID in the
;;  message table resource.
;;
 STATUS_MESSAGE_NOT_FOUND         EQU 0C0000109H

;;
;; MessageId: STATUS_PROCESS_IS_TERMINATING
;;
;; MessageText:
;;
;;  An attempt was made to duplicate an object handle into or out
;;  of an exiting process.
;;
 STATUS_PROCESS_IS_TERMINATING    EQU 0C000010AH

;;
;; MessageId: STATUS_INVALID_LOGON_TYPE
;;
;; MessageText:
;;
;;  Indicates an invalid value has been provided for the LogonType
;;  requested.
;;
 STATUS_INVALID_LOGON_TYPE        EQU 0C000010BH

;;
;; MessageId: STATUS_NO_GUID_TRANSLATION
;;
;; MessageText:
;;
;;  Indicates that an attempt was made to assign protection to a
;;  file system file or directory and one of the SIDs in the security
;;  descriptor could not be translated into a GUID that could be stored
;;  by the file system.
;;  This causes the protection attempt to fail, which may cause a file
;;  creation attempt to fail.
;;
 STATUS_NO_GUID_TRANSLATION       EQU 0C000010CH

;;
;; MessageId: STATUS_CANNOT_IMPERSONATE
;;
;; MessageText:
;;
;;  Indicates that an attempt has been made to impersonate via a named
;;  pipe that has not yet been read from.
;;
 STATUS_CANNOT_IMPERSONATE        EQU 0C000010DH

;;
;; MessageId: STATUS_IMAGE_ALREADY_LOADED
;;
;; MessageText:
;;
;;  Indicates that the specified image is already loaded.
;;
 STATUS_IMAGE_ALREADY_LOADED      EQU 0C000010EH


;;
;; ============================================================
;; NOTE: The following ABIOS error code should be reserved on
;;       non ABIOS kernel.  Eventually, I will remove the ifdef
;;       ABIOS.
;; ============================================================
;;
;;
;; MessageId: STATUS_ABIOS_NOT_PRESENT
;;
;; MessageText:
;;
;;  STATUS_ABIOS_NOT_PRESENT
;;
 STATUS_ABIOS_NOT_PRESENT         EQU 0C000010FH

;;
;; MessageId: STATUS_ABIOS_LID_NOT_EXIST
;;
;; MessageText:
;;
;;  STATUS_ABIOS_LID_NOT_EXIST
;;
 STATUS_ABIOS_LID_NOT_EXIST       EQU 0C0000110H

;;
;; MessageId: STATUS_ABIOS_LID_ALREADY_OWNED
;;
;; MessageText:
;;
;;  STATUS_ABIOS_LID_ALREADY_OWNED
;;
 STATUS_ABIOS_LID_ALREADY_OWNED   EQU 0C0000111H

;;
;; MessageId: STATUS_ABIOS_NOT_LID_OWNER
;;
;; MessageText:
;;
;;  STATUS_ABIOS_NOT_LID_OWNER
;;
 STATUS_ABIOS_NOT_LID_OWNER       EQU 0C0000112H

;;
;; MessageId: STATUS_ABIOS_INVALID_COMMAND
;;
;; MessageText:
;;
;;  STATUS_ABIOS_INVALID_COMMAND
;;
 STATUS_ABIOS_INVALID_COMMAND     EQU 0C0000113H

;;
;; MessageId: STATUS_ABIOS_INVALID_LID
;;
;; MessageText:
;;
;;  STATUS_ABIOS_INVALID_LID
;;
 STATUS_ABIOS_INVALID_LID         EQU 0C0000114H

;;
;; MessageId: STATUS_ABIOS_SELECTOR_NOT_AVAILABLE
;;
;; MessageText:
;;
;;  STATUS_ABIOS_SELECTOR_NOT_AVAILABLE
;;
 STATUS_ABIOS_SELECTOR_NOT_AVAILABLE EQU 0C0000115H

;;
;; MessageId: STATUS_ABIOS_INVALID_SELECTOR
;;
;; MessageText:
;;
;;  STATUS_ABIOS_INVALID_SELECTOR
;;
 STATUS_ABIOS_INVALID_SELECTOR    EQU 0C0000116H

;;
;; MessageId: STATUS_NO_LDT
;;
;; MessageText:
;;
;;  Indicates that an attempt was made to change the size of the LDT for
;;  a process that has no LDT.
;;
 STATUS_NO_LDT                    EQU 0C0000117H

;;
;; MessageId: STATUS_INVALID_LDT_SIZE
;;
;; MessageText:
;;
;;  Indicates that an attempt was made to grow an LDT by setting its size,
;;  or that the size was not an even number of selectors.
;;
 STATUS_INVALID_LDT_SIZE          EQU 0C0000118H

;;
;; MessageId: STATUS_INVALID_LDT_OFFSET
;;
;; MessageText:
;;
;;  Indicates that the starting value for the LDT information was not
;;  an integral multiple of the selector size.
;;
 STATUS_INVALID_LDT_OFFSET        EQU 0C0000119H

;;
;; MessageId: STATUS_INVALID_LDT_DESCRIPTOR
;;
;; MessageText:
;;
;;  Indicates that the user supplied an invalid descriptor when trying
;;  to set up Ldt descriptors.
;;
 STATUS_INVALID_LDT_DESCRIPTOR    EQU 0C000011AH

;;
;; MessageId: STATUS_INVALID_IMAGE_NE_FORMAT
;;
;; MessageText:
;;
;;  The specified image file did not have the correct format. It
;;  appears to be NE format.
;;
 STATUS_INVALID_IMAGE_NE_FORMAT   EQU 0C000011BH

;;
;; MessageId: STATUS_RXACT_INVALID_STATE
;;
;; MessageText:
;;
;;  Indicates that the transaction state of a registry sub-tree is
;;  incompatible with the requested operation.
;;  For example, a request has been made to start a new transaction with
;;  one already in progress, or a request has been made to apply a transaction
;;  when one is not currently in progress.
;;  This status value is returned by the runtime library (RTH registry
;;  transaction package (RXact).
;;
 STATUS_RXACT_INVALID_STATE       EQU 0C000011CH

;;
;; MessageId: STATUS_RXACT_COMMIT_FAILURE
;;
;; MessageText:
;;
;;  Indicates an error has occurred during a registry transaction commit.
;;  The database has been left in an unknown, but probably inconsistent,
;;  state.  The state of the registry transaction is left as COMMITTING.
;;  This status value is returned by the runtime library (RTH registry
;;  transaction package (RXact).
;;
 STATUS_RXACT_COMMIT_FAILURE      EQU 0C000011DH

;;
;; MessageId: STATUS_MAPPED_FILE_SIZE_ZERO
;;
;; MessageText:
;;
;;  An attempt was made to map a file of size zero with the
;;  maximum size specified as zero.
;;
 STATUS_MAPPED_FILE_SIZE_ZERO     EQU 0C000011EH

;;
;; MessageId: STATUS_TOO_MANY_OPENED_FILES
;;
;; MessageText:
;;
;;  Too many files are opened on a remote server.  This error should only
;;  be returned by the NT redirector on a remote drive.
;;
 STATUS_TOO_MANY_OPENED_FILES     EQU 0C000011FH

;;
;; MessageId: STATUS_CANCELLED
;;
;; MessageText:
;;
;;  The I/O request was canceled.
;;
 STATUS_CANCELLED                 EQU 0C0000120H

;;
;; MessageId: STATUS_CANNOT_DELETE
;;
;; MessageText:
;;
;;  An attempt has been made to remove a file or directory that cannot
;;  be deleted.
;;
 STATUS_CANNOT_DELETE             EQU 0C0000121H

;;
;; MessageId: STATUS_INVALID_COMPUTER_NAME
;;
;; MessageText:
;;
;;  Indicates a name specified as a remote computer name is syntactically
;;  invalid.
;;
 STATUS_INVALID_COMPUTER_NAME     EQU 0C0000122H

;;
;; MessageId: STATUS_FILE_DELETED
;;
;; MessageText:
;;
;;  An I/O request other than close was performed on a file after it has
;;  been deleted, which can only happen to a request which did not complete
;;  before the last handle was closed via NtClose.
;;
 STATUS_FILE_DELETED              EQU 0C0000123H

;;
;; MessageId: STATUS_SPECIAL_ACCOUNT
;;
;; MessageText:
;;
;;  Indicates an operation has been attempted on a built-in (special)
;;  SAM account which is incompatible with built-in accounts.  For
;;  example, built-in accounts cannot be deleted.
;;
 STATUS_SPECIAL_ACCOUNT           EQU 0C0000124H

;;
;; MessageId: STATUS_SPECIAL_GROUP
;;
;; MessageText:
;;
;;  The operation requested may not be performed on the specified
;;  group because it is a built-in special group.
;;
 STATUS_SPECIAL_GROUP             EQU 0C0000125H

;;
;; MessageId: STATUS_SPECIAL_USER
;;
;; MessageText:
;;
;;  The operation requested may not be performed on the specified
;;  user because it is a built-in special user.
;;
 STATUS_SPECIAL_USER              EQU 0C0000126H

;;
;; MessageId: STATUS_MEMBERS_PRIMARY_GROUP
;;
;; MessageText:
;;
;;  Indicates a member cannot be removed from a group because the
;;  group is currently the member's primary group.
;;
 STATUS_MEMBERS_PRIMARY_GROUP     EQU 0C0000127H

;;
;; MessageId: STATUS_FILE_CLOSED
;;
;; MessageText:
;;
;;  An I/O request other than close and several other special case
;;  operations was attempted using a file object that had already been
;;  closed.
;;
 STATUS_FILE_CLOSED               EQU 0C0000128H

;;
;; MessageId: STATUS_TOO_MANY_THREADS
;;
;; MessageText:
;;
;;  Indicates a process has too many threads to perform the requested
;;  action.  For example, assignment of a primary token may only be
;;  performed when a process has zero or one threads.
;;
 STATUS_TOO_MANY_THREADS          EQU 0C0000129H

;;
;; MessageId: STATUS_THREAD_NOT_IN_PROCESS
;;
;; MessageText:
;;
;;  An attempt was made to operate on a thread within a specific process,
;;  but the thread specified is not in the process specified.
;;
 STATUS_THREAD_NOT_IN_PROCESS     EQU 0C000012AH

;;
;; MessageId: STATUS_TOKEN_ALREADY_IN_USE
;;
;; MessageText:
;;
;;  An attempt was made to establish a token for use as a primary token
;;  but the token is already in use.  A token can only be the primary token
;;  of one process at a time.
;;
 STATUS_TOKEN_ALREADY_IN_USE      EQU 0C000012BH

;;
;; MessageId: STATUS_PAGEFILE_QUOTA_EXCEEDED
;;
;; MessageText:
;;
;;  Page file quota was exceeded.
;;
 STATUS_PAGEFILE_QUOTA_EXCEEDED   EQU 0C000012CH

;;
;; MessageId: STATUS_COMMITMENT_LIMIT
;;
;; MessageText:
;;
;;  {Out of Virtual Memory}
;;  Your system is running low on virtual memory.  Please close some
;;  applications.  You can then start the System option in the Control Panel
;;  and choose the Virtual Memory button to create an additional paging file
;;  or to increase the size of your current paging file.
;;
 STATUS_COMMITMENT_LIMIT          EQU 0C000012DH

;;
;; MessageId: STATUS_INVALID_IMAGE_LE_FORMAT
;;
;; MessageText:
;;
;;  The specified image file did not have the correct format, it
;;  appears to be LE format.
;;
 STATUS_INVALID_IMAGE_LE_FORMAT   EQU 0C000012EH

;;
;; MessageId: STATUS_INVALID_IMAGE_NOT_MZ
;;
;; MessageText:
;;
;;  The specified image file did not have the correct format, it
;;  did not have an initial MZ.
;;
 STATUS_INVALID_IMAGE_NOT_MZ      EQU 0C000012FH

;;
;; MessageId: STATUS_INVALID_IMAGE_PROTECT
;;
;; MessageText:
;;
;;  The specified image file did not have the correct format, it
;;  did not have a proper e_lfarlc in the MZ header.
;;
 STATUS_INVALID_IMAGE_PROTECT     EQU 0C0000130H

;;
;; MessageId: STATUS_INVALID_IMAGE_WIN_16
;;
;; MessageText:
;;
;;  The specified image file did not have the correct format, it
;;  appears to be a 16-bit Windows image.
;;
 STATUS_INVALID_IMAGE_WIN_16      EQU 0C0000131H

;;
;; MessageId: STATUS_LOGON_SERVER_CONFLICT
;;
;; MessageText:
;;
;;  The Netlogon service cannot start because another Netlogon service running
;;  in the domain conflicts with the specified role.
;;
 STATUS_LOGON_SERVER_CONFLICT     EQU 0C0000132H

;;
;; MessageId: STATUS_TIME_DIFFERENCE_AT_DC
;;
;; MessageText:
;;
;;  The time at the Primary Domain Controller is different than the
;;  time at the Backup Domain Controller or member server by too large
;;  an amount.
;;
 STATUS_TIME_DIFFERENCE_AT_DC     EQU 0C0000133H

;;
;; MessageId: STATUS_SYNCHRONIZATION_REQUIRED
;;
;; MessageText:
;;
;;  The SAM database on a Windows NT Server is
;;  significantly out of synchronization with the copy on the Domain
;;  Controller.  A complete synchronization is required.
;;
 STATUS_SYNCHRONIZATION_REQUIRED  EQU 0C0000134H

;;
;; MessageId: STATUS_DLL_NOT_FOUND
;;
;; MessageText:
;;
;;  {Unable To Locate DLL}
;;  The dynamic link library %s could not be found in the specified path %s.
;;
 STATUS_DLL_NOT_FOUND             EQU 0C0000135H

;;
;; MessageId: STATUS_OPEN_FAILED
;;
;; MessageText:
;;
;;  The NtCreateFile API failed.  This error should never be returned to an
;;  application, it is a place holder for the NT Lan Manager Redirector to
;;  use in its internal error mapping routines.
;;
 STATUS_OPEN_FAILED               EQU 0C0000136H

;;
;; MessageId: STATUS_IO_PRIVILEGE_FAILED
;;
;; MessageText:
;;
;;  {Privilege Failed}
;;  The I/O permissions for the process could not be changed.
;;
 STATUS_IO_PRIVILEGE_FAILED       EQU 0C0000137H

;;
;; MessageId: STATUS_ORDINAL_NOT_FOUND
;;
;; MessageText:
;;
;;  {Ordinal Not Found}
;;  The ordinal %ld could not be located in the dynamic link library %s.
;;
 STATUS_ORDINAL_NOT_FOUND         EQU 0C0000138H

;;
;; MessageId: STATUS_ENTRYPOINT_NOT_FOUND
;;
;; MessageText:
;;
;;  {Entry Point Not Found}
;;  The procedure entry point %s could not be located in the dynamic link library %s.
;;
 STATUS_ENTRYPOINT_NOT_FOUND      EQU 0C0000139H

;;
;; MessageId: STATUS_CONTROL_C_EXIT
;;
;; MessageText:
;;
;;  {Application Exit by CTRL+C}
;;  The application terminated as a result of a CTRL+C.
;;
 STATUS_CONTROL_C_EXIT            EQU 0C000013AH    ;; winnt

;;
;; MessageId: STATUS_LOCAL_DISCONNECT
;;
;; MessageText:
;;
;;  {Virtual Circuit Closed}
;;  The network transport on your computer has closed a network
;;  connection. There may or may not be I/O requests outstanding.
;;
 STATUS_LOCAL_DISCONNECT          EQU 0C000013BH

;;
;; MessageId: STATUS_REMOTE_DISCONNECT
;;
;; MessageText:
;;
;;  {Virtual Circuit Closed}
;;  The network transport on a remote computer has closed a network
;;  connection. There may or may not be I/O requests outstanding.
;;
 STATUS_REMOTE_DISCONNECT         EQU 0C000013CH

;;
;; MessageId: STATUS_REMOTE_RESOURCES
;;
;; MessageText:
;;
;;  {Insufficient Resources on Remote Computer}
;;  The remote computer has insufficient resources to complete the
;;  network request. For instance, there may not be enough memory
;;  available on the remote computer to carry out the request at
;;  this time.
;;
 STATUS_REMOTE_RESOURCES          EQU 0C000013DH

;;
;; MessageId: STATUS_LINK_FAILED
;;
;; MessageText:
;;
;;  {Virtual Circuit Closed}
;;  An existing connection (virtual circuit) has been broken at the
;;  remote computer. There is probably something wrong with the
;;  network software protocol or the network hardware on the
;;  remote computer.
;;
 STATUS_LINK_FAILED               EQU 0C000013EH

;;
;; MessageId: STATUS_LINK_TIMEOUT
;;
;; MessageText:
;;
;;  {Virtual Circuit Closed}
;;  The network transport on your computer has closed a network
;;  connection because it had to wait too long for a response
;;  from the remote computer.
;;
 STATUS_LINK_TIMEOUT              EQU 0C000013FH

;;
;; MessageId: STATUS_INVALID_CONNECTION
;;
;; MessageText:
;;
;;  The connection handle given to the transport was invalid.
;;
 STATUS_INVALID_CONNECTION        EQU 0C0000140H

;;
;; MessageId: STATUS_INVALID_ADDRESS
;;
;; MessageText:
;;
;;  The address handle given to the transport was invalid.
;;
 STATUS_INVALID_ADDRESS           EQU 0C0000141H

;;
;; MessageId: STATUS_DLL_INIT_FAILED
;;
;; MessageText:
;;
;;  {DLL Initialization Failed}
;;  Initialization of the dynamic link library %s failed. The process is
;;  terminating abnormally.
;;
 STATUS_DLL_INIT_FAILED           EQU 0C0000142H

;;
;; MessageId: STATUS_MISSING_SYSTEMFILE
;;
;; MessageText:
;;
;;  {Missing System File}
;;  The required system file %s is bad or missing.
;;
 STATUS_MISSING_SYSTEMFILE        EQU 0C0000143H

;;
;; MessageId: STATUS_UNHANDLED_EXCEPTION
;;
;; MessageText:
;;
;;  {Application Error}
;;  The exception %s (0x%08lx) occurred in the application at location 0x%08lx.
;;
 STATUS_UNHANDLED_EXCEPTION       EQU 0C0000144H

;;
;; MessageId: STATUS_APP_INIT_FAILURE
;;
;; MessageText:
;;
;;  {Application Error}
;;  The application failed to initialize properly (0x%lx).  Click on OK to
;;  terminate the application.
;;
 STATUS_APP_INIT_FAILURE          EQU 0C0000145H

;;
;; MessageId: STATUS_PAGEFILE_CREATE_FAILED
;;
;; MessageText:
;;
;;  {Unable to Create Paging File}
;;  The creation of the paging file %s failed (%lx). The requested size was %ld.
;;
 STATUS_PAGEFILE_CREATE_FAILED    EQU 0C0000146H

;;
;; MessageId: STATUS_NO_PAGEFILE
;;
;; MessageText:
;;
;;  {No Paging File Specified}
;;  No paging file was specified in the system configuration.
;;
 STATUS_NO_PAGEFILE               EQU 0C0000147H

;;
;; MessageId: STATUS_INVALID_LEVEL
;;
;; MessageText:
;;
;;  {Incorrect System Call Level}
;;  An invalid level was passed into the specified system call.
;;
 STATUS_INVALID_LEVEL             EQU 0C0000148H

;;
;; MessageId: STATUS_WRONG_PASSWORD_CORE
;;
;; MessageText:
;;
;;  {Incorrect Password to LAN Manager Server}
;;  You specified an incorrect password to a LAN Manager 2.x or MS-NET server.
;;
 STATUS_WRONG_PASSWORD_CORE       EQU 0C0000149H

;;
;; MessageId: STATUS_ILLEGAL_FLOAT_CONTEXT
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  A real-mode application issued a floating-point instruction and floating-point
;;  hardware is not present.
;;
 STATUS_ILLEGAL_FLOAT_CONTEXT     EQU 0C000014AH

;;
;; MessageId: STATUS_PIPE_BROKEN
;;
;; MessageText:
;;
;;  The pipe operation has failed because the other end of the pipe has been
;;  closed.
;;
 STATUS_PIPE_BROKEN               EQU 0C000014BH

;;
;; MessageId: STATUS_REGISTRY_CORRUPT
;;
;; MessageText:
;;
;;  {The Registry Is Corrupt}
;;  The structure of one of the files that contains Registry data is corrupt, or
;;  the image of the file in memory is corrupt, or the file could not
;;  be recovered because the alternate copy or log was absent or corrupt.
;;
 STATUS_REGISTRY_CORRUPT          EQU 0C000014CH

;;
;; MessageId: STATUS_REGISTRY_IO_FAILED
;;
;; MessageText:
;;
;;  An I/O operation initiated by the Registry failed unrecoverably.
;;  The Registry could not read in, or write out, or flush, one of the files
;;  that contain the system's image of the Registry.
;;
 STATUS_REGISTRY_IO_FAILED        EQU 0C000014DH

;;
;; MessageId: STATUS_NO_EVENT_PAIR
;;
;; MessageText:
;;
;;  An event pair synchronization operation was performed using the thread
;;  specific client/server event pair object, but no event pair object was
;;  associated with the thread.
;;
 STATUS_NO_EVENT_PAIR             EQU 0C000014EH

;;
;; MessageId: STATUS_UNRECOGNIZED_VOLUME
;;
;; MessageText:
;;
;;  The volume does not contain a recognized file system.
;;  Please make sure that all required file system drivers are loaded and that the
;;  volume is not corrupt.
;;
 STATUS_UNRECOGNIZED_VOLUME       EQU 0C000014FH

;;
;; MessageId: STATUS_SERIAL_NO_DEVICE_INITED
;;
;; MessageText:
;;
;;  No serial device was successfully initialized.  The serial driver will unload.
;;
 STATUS_SERIAL_NO_DEVICE_INITED   EQU 0C0000150H

;;
;; MessageId: STATUS_NO_SUCH_ALIAS
;;
;; MessageText:
;;
;;  The specified local group does not exist.
;;
 STATUS_NO_SUCH_ALIAS             EQU 0C0000151H

;;
;; MessageId: STATUS_MEMBER_NOT_IN_ALIAS
;;
;; MessageText:
;;
;;  The specified account name is not a member of the local group.
;;
 STATUS_MEMBER_NOT_IN_ALIAS       EQU 0C0000152H

;;
;; MessageId: STATUS_MEMBER_IN_ALIAS
;;
;; MessageText:
;;
;;  The specified account name is already a member of the local group.
;;
 STATUS_MEMBER_IN_ALIAS           EQU 0C0000153H

;;
;; MessageId: STATUS_ALIAS_EXISTS
;;
;; MessageText:
;;
;;  The specified local group already exists.
;;
 STATUS_ALIAS_EXISTS              EQU 0C0000154H

;;
;; MessageId: STATUS_LOGON_NOT_GRANTED
;;
;; MessageText:
;;
;;  A requested type of logon (e.g., Interactive, Network, Service) is not
;;  granted by the target system's local security policy.  Please ask the
;;  system administrator to grant the necessary form of logon.
;;
 STATUS_LOGON_NOT_GRANTED         EQU 0C0000155H

;;
;; MessageId: STATUS_TOO_MANY_SECRETS
;;
;; MessageText:
;;
;;  The maximum number of secrets that may be stored in a single system has been
;;  exceeded.  The length and number of secrets is limited to satisfy United
;;  States State Department export restrictions.
;;
 STATUS_TOO_MANY_SECRETS          EQU 0C0000156H

;;
;; MessageId: STATUS_SECRET_TOO_LONG
;;
;; MessageText:
;;
;;  The length of a secret exceeds the maximum length allowed.  The length and
;;  number of secrets is limited to satisfy United States State Department
;;  export restrictions.
;;
 STATUS_SECRET_TOO_LONG           EQU 0C0000157H

;;
;; MessageId: STATUS_INTERNAL_DB_ERROR
;;
;; MessageText:
;;
;;  The Local Security Authority (LSA) database contains an internal inconsistency.
;;
 STATUS_INTERNAL_DB_ERROR         EQU 0C0000158H

;;
;; MessageId: STATUS_FULLSCREEN_MODE
;;
;; MessageText:
;;
;;  The requested operation cannot be performed in fullscreen mode.
;;
 STATUS_FULLSCREEN_MODE           EQU 0C0000159H

;;
;; MessageId: STATUS_TOO_MANY_CONTEXT_IDS
;;
;; MessageText:
;;
;;  During a logon attempt, the user's security context accumulated too many
;;  security IDs.  This is a very unusual situation.  Remove the user from
;;  some global or local groups to reduce the number of security ids to
;;  incorporate into the security context.
;;
 STATUS_TOO_MANY_CONTEXT_IDS      EQU 0C000015AH

;;
;; MessageId: STATUS_LOGON_TYPE_NOT_GRANTED
;;
;; MessageText:
;;
;;  A user has requested a type of logon (e.g., interactive or network) that
;;  has not been granted.  An administrator has control over who may logon
;;  interactively and through the network.
;;
 STATUS_LOGON_TYPE_NOT_GRANTED    EQU 0C000015BH

;;
;; MessageId: STATUS_NOT_REGISTRY_FILE
;;
;; MessageText:
;;
;;  The system has attempted to load or restore a file into the registry, and the
;;  specified file is not in the format of a registry file.
;;
 STATUS_NOT_REGISTRY_FILE         EQU 0C000015CH

;;
;; MessageId: STATUS_NT_CROSS_ENCRYPTION_REQUIRED
;;
;; MessageText:
;;
;;  An attempt was made to change a user password in the security account manager
;;  without providing the necessary NT cross-encrypted password.
;;
 STATUS_NT_CROSS_ENCRYPTION_REQUIRED EQU 0C000015DH

;;
;; MessageId: STATUS_DOMAIN_CTRLR_CONFIG_ERROR
;;
;; MessageText:
;;
;;  A Windows NT Server has incorrect configuration.
;;
 STATUS_DOMAIN_CTRLR_CONFIG_ERROR EQU 0C000015EH

;;
;; MessageId: STATUS_FT_MISSING_MEMBER
;;
;; MessageText:
;;
;;  An attempt was made to explicitly access the secondary copy of information
;;  via a device control to the Fault Tolerance driver and the secondary copy
;;  is not present in the system.
;;
 STATUS_FT_MISSING_MEMBER         EQU 0C000015FH

;;
;; MessageId: STATUS_ILL_FORMED_SERVICE_ENTRY
;;
;; MessageText:
;;
;;  A configuration registry node representing a driver service entry was ill-formed
;;  and did not contain required value entries.
;;
 STATUS_ILL_FORMED_SERVICE_ENTRY  EQU 0C0000160H

;;
;; MessageId: STATUS_ILLEGAL_CHARACTER
;;
;; MessageText:
;;
;;  An illegal character was encountered.  For a multi-byte character set this
;;  includes a lead byte without a succeeding trail byte.  For the Unicode character set
;;  this includes the characters 0xFFFF and 0xFFFE.
;;
 STATUS_ILLEGAL_CHARACTER         EQU 0C0000161H

;;
;; MessageId: STATUS_UNMAPPABLE_CHARACTER
;;
;; MessageText:
;;
;;  No mapping for the Unicode character exists in the target multi-byte code page.
;;
 STATUS_UNMAPPABLE_CHARACTER      EQU 0C0000162H

;;
;; MessageId: STATUS_UNDEFINED_CHARACTER
;;
;; MessageText:
;;
;;  The Unicode character is not defined in the Unicode character set installed on
;;  the system.
;;
 STATUS_UNDEFINED_CHARACTER       EQU 0C0000163H

;;
;; MessageId: STATUS_FLOPPY_VOLUME
;;
;; MessageText:
;;
;;  The paging file cannot be created on a floppy diskette.
;;
 STATUS_FLOPPY_VOLUME             EQU 0C0000164H

;;
;; MessageId: STATUS_FLOPPY_ID_MARK_NOT_FOUND
;;
;; MessageText:
;;
;;  {Floppy Disk Error}
;;  While accessing a floppy disk, an ID address mark was not found.
;;
 STATUS_FLOPPY_ID_MARK_NOT_FOUND  EQU 0C0000165H

;;
;; MessageId: STATUS_FLOPPY_WRONG_CYLINDER
;;
;; MessageText:
;;
;;  {Floppy Disk Error}
;;  While accessing a floppy disk, the track address from the sector ID field
;;  was found to be different than the track address maintained by the controller.
;;
 STATUS_FLOPPY_WRONG_CYLINDER     EQU 0C0000166H

;;
;; MessageId: STATUS_FLOPPY_UNKNOWN_ERROR
;;
;; MessageText:
;;
;;  {Floppy Disk Error}
;;  The floppy disk controller reported an error that is not recognized by the
;;  floppy disk driver.
;;
 STATUS_FLOPPY_UNKNOWN_ERROR      EQU 0C0000167H

;;
;; MessageId: STATUS_FLOPPY_BAD_REGISTERS
;;
;; MessageText:
;;
;;  {Floppy Disk Error}
;;  While accessing a floppy-disk, the controller returned inconsistent results
;;  via its registers.
;;
 STATUS_FLOPPY_BAD_REGISTERS      EQU 0C0000168H

;;
;; MessageId: STATUS_DISK_RECALIBRATE_FAILED
;;
;; MessageText:
;;
;;  {Hard Disk Error}
;;  While accessing the hard disk, a recalibrate operation failed, even after retries.
;;
 STATUS_DISK_RECALIBRATE_FAILED   EQU 0C0000169H

;;
;; MessageId: STATUS_DISK_OPERATION_FAILED
;;
;; MessageText:
;;
;;  {Hard Disk Error}
;;  While accessing the hard disk, a disk operation failed even after retries.
;;
 STATUS_DISK_OPERATION_FAILED     EQU 0C000016AH

;;
;; MessageId: STATUS_DISK_RESET_FAILED
;;
;; MessageText:
;;
;;  {Hard Disk Error}
;;  While accessing the hard disk, a disk controller reset was needed, but even that failed.
;;
 STATUS_DISK_RESET_FAILED         EQU 0C000016BH

;;
;; MessageId: STATUS_SHARED_IRQ_BUSY
;;
;; MessageText:
;;
;;  An attempt was made to open a device that was sharing an IRQ with other devices.
;;  At least one other device that uses that IRQ was already opened.  Two concurrent
;;  opens of devices that share an IRQ and only work via interrupts is not supported
;;  for the particular bus type that the devices use.
;;
 STATUS_SHARED_IRQ_BUSY           EQU 0C000016CH

;;
;; MessageId: STATUS_FT_ORPHANING
;;
;; MessageText:
;;
;;  {FT Orphaning}
;;  A disk that is part of a fault-tolerant volume can no longer be accessed.
;;
 STATUS_FT_ORPHANING              EQU 0C000016DH

;;
;; MessageId: STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT
;;
;; MessageText:
;;
;;  The system bios failed to connect a system interrupt to the device or bus for
;;  which the device is connected.
;;
 STATUS_BIOS_FAILED_TO_CONNECT_INTERRUPT EQU 0C000016EH

;;
;; MessageId: STATUS_PARTITION_FAILURE
;;
;; MessageText:
;;
;;  Tape could not be partitioned.
;;
 STATUS_PARTITION_FAILURE         EQU 0C0000172H

;;
;; MessageId: STATUS_INVALID_BLOCK_LENGTH
;;
;; MessageText:
;;
;;  When accessing a new tape of a multivolume partition, the current
;;  blocksize is incorrect.
;;
 STATUS_INVALID_BLOCK_LENGTH      EQU 0C0000173H

;;
;; MessageId: STATUS_DEVICE_NOT_PARTITIONED
;;
;; MessageText:
;;
;;  Tape partition information could not be found when loading a tape.
;;
 STATUS_DEVICE_NOT_PARTITIONED    EQU 0C0000174H

;;
;; MessageId: STATUS_UNABLE_TO_LOCK_MEDIA
;;
;; MessageText:
;;
;;  Attempt to lock the eject media mechanism fails.
;;
 STATUS_UNABLE_TO_LOCK_MEDIA      EQU 0C0000175H

;;
;; MessageId: STATUS_UNABLE_TO_UNLOAD_MEDIA
;;
;; MessageText:
;;
;;  Unload media fails.
;;
 STATUS_UNABLE_TO_UNLOAD_MEDIA    EQU 0C0000176H

;;
;; MessageId: STATUS_EOM_OVERFLOW
;;
;; MessageText:
;;
;;  Physical end of tape was detected.
;;
 STATUS_EOM_OVERFLOW              EQU 0C0000177H

;;
;; MessageId: STATUS_NO_MEDIA
;;
;; MessageText:
;;
;;  {No Media}
;;  There is no media in the drive.
;;  Please insert media into drive %s.
;;
 STATUS_NO_MEDIA                  EQU 0C0000178H

;;
;; MessageId: STATUS_NO_SUCH_MEMBER
;;
;; MessageText:
;;
;;  A new member could not be added to a local group because the member does
;;  not exist.
;;
 STATUS_NO_SUCH_MEMBER            EQU 0C000017AH

;;
;; MessageId: STATUS_INVALID_MEMBER
;;
;; MessageText:
;;
;;  A new member could not be added to a local group because the member has the
;;  wrong account type.
;;
 STATUS_INVALID_MEMBER            EQU 0C000017BH

;;
;; MessageId: STATUS_KEY_DELETED
;;
;; MessageText:
;;
;;  Illegal operation attempted on a registry key which has been marked for deletion.
;;
 STATUS_KEY_DELETED               EQU 0C000017CH

;;
;; MessageId: STATUS_NO_LOG_SPACE
;;
;; MessageText:
;;
;;  System could not allocate required space in a registry log.
;;
 STATUS_NO_LOG_SPACE              EQU 0C000017DH

;;
;; MessageId: STATUS_TOO_MANY_SIDS
;;
;; MessageText:
;;
;;  Too many Sids have been specified.
;;
 STATUS_TOO_MANY_SIDS             EQU 0C000017EH

;;
;; MessageId: STATUS_LM_CROSS_ENCRYPTION_REQUIRED
;;
;; MessageText:
;;
;;  An attempt was made to change a user password in the security account manager
;;  without providing the necessary LM cross-encrypted password.
;;
 STATUS_LM_CROSS_ENCRYPTION_REQUIRED EQU 0C000017FH

;;
;; MessageId: STATUS_KEY_HAS_CHILDREN
;;
;; MessageText:
;;
;;  An attempt was made to create a symbolic link in a registry key that already
;;  has subkeys or values.
;;
 STATUS_KEY_HAS_CHILDREN          EQU 0C0000180H

;;
;; MessageId: STATUS_CHILD_MUST_BE_VOLATILE
;;
;; MessageText:
;;
;;  An attempt was made to create a Stable subkey under a Volatile parent key.
;;
 STATUS_CHILD_MUST_BE_VOLATILE    EQU 0C0000181H

;;
;; MessageId: STATUS_DEVICE_CONFIGURATION_ERROR
;;
;; MessageText:
;;
;;  The I/O device is configured incorrectly or the configuration parameters to the
;;  driver are incorrect.
;;
 STATUS_DEVICE_CONFIGURATION_ERROR EQU 0C0000182H

;;
;; MessageId: STATUS_DRIVER_INTERNAL_ERROR
;;
;; MessageText:
;;
;;  An error was detected between two drivers or within an I/O driver.
;;
 STATUS_DRIVER_INTERNAL_ERROR     EQU 0C0000183H

;;
;; MessageId: STATUS_INVALID_DEVICE_STATE
;;
;; MessageText:
;;
;;  The device is not in a valid state to perform this request.
;;
 STATUS_INVALID_DEVICE_STATE      EQU 0C0000184H

;;
;; MessageId: STATUS_IO_DEVICE_ERROR
;;
;; MessageText:
;;
;;  The I/O device reported an I/O error.
;;
 STATUS_IO_DEVICE_ERROR           EQU 0C0000185H

;;
;; MessageId: STATUS_DEVICE_PROTOCOL_ERROR
;;
;; MessageText:
;;
;;  A protocol error was detected between the driver and the device.
;;
 STATUS_DEVICE_PROTOCOL_ERROR     EQU 0C0000186H

;;
;; MessageId: STATUS_BACKUP_CONTROLLER
;;
;; MessageText:
;;
;;  This operation is only allowed for the Primary Domain Controller of the domain.
;;
 STATUS_BACKUP_CONTROLLER         EQU 0C0000187H

;;
;; MessageId: STATUS_LOG_FILE_FULL
;;
;; MessageText:
;;
;;  Log file space is insufficient to support this operation.
;;
 STATUS_LOG_FILE_FULL             EQU 0C0000188H

;;
;; MessageId: STATUS_TOO_LATE
;;
;; MessageText:
;;
;;  A write operation was attempted to a volume after it was dismounted.
;;
 STATUS_TOO_LATE                  EQU 0C0000189H

;;
;; MessageId: STATUS_NO_TRUST_LSA_SECRET
;;
;; MessageText:
;;
;;  The workstation does not have a trust secret for the primary domain in
;;  the local LSA database.
;;
 STATUS_NO_TRUST_LSA_SECRET       EQU 0C000018AH

;;
;; MessageId: STATUS_NO_TRUST_SAM_ACCOUNT
;;
;; MessageText:
;;
;;  The SAM database on the Windows NT Server does not have a computer
;;  account for this workstation trust relationship.
;;
 STATUS_NO_TRUST_SAM_ACCOUNT      EQU 0C000018BH

;;
;; MessageId: STATUS_TRUSTED_DOMAIN_FAILURE
;;
;; MessageText:
;;
;;  The logon request failed because the trust relationship between the
;;  primary domain and the trusted domain failed.
;;
 STATUS_TRUSTED_DOMAIN_FAILURE    EQU 0C000018CH

;;
;; MessageId: STATUS_TRUSTED_RELATIONSHIP_FAILURE
;;
;; MessageText:
;;
;;  The logon request failed because the trust relationship between this
;;  workstation and the primary domain failed.
;;
 STATUS_TRUSTED_RELATIONSHIP_FAILURE EQU 0C000018DH

;;
;; MessageId: STATUS_EVENTLOG_FILE_CORRUPT
;;
;; MessageText:
;;
;;  The Eventlog log file is corrupt.
;;
 STATUS_EVENTLOG_FILE_CORRUPT     EQU 0C000018EH

;;
;; MessageId: STATUS_EVENTLOG_CANT_START
;;
;; MessageText:
;;
;;  No Eventlog log file could be opened.  The Eventlog service did not start.
;;
 STATUS_EVENTLOG_CANT_START       EQU 0C000018FH

;;
;; MessageId: STATUS_TRUST_FAILURE
;;
;; MessageText:
;;
;;  The network logon failed. This may be because the validation authority can't
;;  be reached.
;;
 STATUS_TRUST_FAILURE             EQU 0C0000190H

;;
;; MessageId: STATUS_MUTANT_LIMIT_EXCEEDED
;;
;; MessageText:
;;
;;  An attempt was made to acquire a mutant such that its maximum count
;;  would have been exceeded.
;;
 STATUS_MUTANT_LIMIT_EXCEEDED     EQU 0C0000191H

;;
;; MessageId: STATUS_NETLOGON_NOT_STARTED
;;
;; MessageText:
;;
;;   An attempt was made to logon, but the netlogon service was not started.
;;
 STATUS_NETLOGON_NOT_STARTED      EQU 0C0000192H

;;
;; MessageId: STATUS_ACCOUNT_EXPIRED
;;
;; MessageText:
;;
;;  The user's account has expired.
;;
 STATUS_ACCOUNT_EXPIRED           EQU 0C0000193H    ;; ntsubauth

;;
;; MessageId: STATUS_POSSIBLE_DEADLOCK
;;
;; MessageText:
;;
;;  {EXCEPTION}
;;  Possible deadlock condition.
;;
 STATUS_POSSIBLE_DEADLOCK         EQU 0C0000194H

;;
;; MessageId: STATUS_NETWORK_CREDENTIAL_CONFLICT
;;
;; MessageText:
;;
;;  The credentials supplied conflict with an existing set of credentials.
;;
 STATUS_NETWORK_CREDENTIAL_CONFLICT EQU 0C0000195H

;;
;; MessageId: STATUS_REMOTE_SESSION_LIMIT
;;
;; MessageText:
;;
;;  An attempt was made to establish a session to a network server, but there
;;  are already too many sessions established to that server.
;;
 STATUS_REMOTE_SESSION_LIMIT      EQU 0C0000196H

;;
;; MessageId: STATUS_EVENTLOG_FILE_CHANGED
;;
;; MessageText:
;;
;;  The log file has changed between reads.
;;
 STATUS_EVENTLOG_FILE_CHANGED     EQU 0C0000197H

;;
;; MessageId: STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT
;;
;; MessageText:
;;
;;  The account used is an Interdomain Trust account.  Use your global user account or local user account to access this server.
;;
 STATUS_NOLOGON_INTERDOMAIN_TRUST_ACCOUNT EQU 0C0000198H

;;
;; MessageId: STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT
;;
;; MessageText:
;;
;;  The account used is a Computer Account.  Use your global user account or local user account to access this server.
;;
 STATUS_NOLOGON_WORKSTATION_TRUST_ACCOUNT EQU 0C0000199H

;;
;; MessageId: STATUS_NOLOGON_SERVER_TRUST_ACCOUNT
;;
;; MessageText:
;;
;;  The account used is an Server Trust account.  Use your global user account or local user account to access this server.
;;
 STATUS_NOLOGON_SERVER_TRUST_ACCOUNT EQU 0C000019AH

;;
;; MessageId: STATUS_DOMAIN_TRUST_INCONSISTENT
;;
;; MessageText:
;;
;;  The name or SID of the domain specified is inconsistent with the trust information for that domain.
;;
 STATUS_DOMAIN_TRUST_INCONSISTENT EQU 0C000019BH

;;
;; MessageId: STATUS_FS_DRIVER_REQUIRED
;;
;; MessageText:
;;
;;  A volume has been accessed for which a file system driver is required that has not yet been loaded.
;;
 STATUS_FS_DRIVER_REQUIRED        EQU 0C000019CH

;;
;; MessageId: STATUS_NO_USER_SESSION_KEY
;;
;; MessageText:
;;
;;  There is no user session key for the specified logon session.
;;
 STATUS_NO_USER_SESSION_KEY       EQU 0C0000202H

;;
;; MessageId: STATUS_USER_SESSION_DELETED
;;
;; MessageText:
;;
;;  The remote user session has been deleted.
;;
 STATUS_USER_SESSION_DELETED      EQU 0C0000203H

;;
;; MessageId: STATUS_RESOURCE_LANG_NOT_FOUND
;;
;; MessageText:
;;
;;  Indicates the specified resource language ID cannot be found in the
;;  image file.
;;
 STATUS_RESOURCE_LANG_NOT_FOUND   EQU 0C0000204H

;;
;; MessageId: STATUS_INSUFF_SERVER_RESOURCES
;;
;; MessageText:
;;
;;  Insufficient server resources exist to complete the request.
;;
 STATUS_INSUFF_SERVER_RESOURCES   EQU 0C0000205H

;;
;; MessageId: STATUS_INVALID_BUFFER_SIZE
;;
;; MessageText:
;;
;;  The size of the buffer is invalid for the specified operation.
;;
 STATUS_INVALID_BUFFER_SIZE       EQU 0C0000206H

;;
;; MessageId: STATUS_INVALID_ADDRESS_COMPONENT
;;
;; MessageText:
;;
;;  The transport rejected the network address specified as invalid.
;;
 STATUS_INVALID_ADDRESS_COMPONENT EQU 0C0000207H

;;
;; MessageId: STATUS_INVALID_ADDRESS_WILDCARD
;;
;; MessageText:
;;
;;  The transport rejected the network address specified due to an
;;  invalid use of a wildcard.
;;
 STATUS_INVALID_ADDRESS_WILDCARD  EQU 0C0000208H

;;
;; MessageId: STATUS_TOO_MANY_ADDRESSES
;;
;; MessageText:
;;
;;  The transport address could not be opened because all the available
;;  addresses are in use.
;;
 STATUS_TOO_MANY_ADDRESSES        EQU 0C0000209H

;;
;; MessageId: STATUS_ADDRESS_ALREADY_EXISTS
;;
;; MessageText:
;;
;;  The transport address could not be opened because it already exists.
;;
 STATUS_ADDRESS_ALREADY_EXISTS    EQU 0C000020AH

;;
;; MessageId: STATUS_ADDRESS_CLOSED
;;
;; MessageText:
;;
;;  The transport address is now closed.
;;
 STATUS_ADDRESS_CLOSED            EQU 0C000020BH

;;
;; MessageId: STATUS_CONNECTION_DISCONNECTED
;;
;; MessageText:
;;
;;  The transport connection is now disconnected.
;;
 STATUS_CONNECTION_DISCONNECTED   EQU 0C000020CH

;;
;; MessageId: STATUS_CONNECTION_RESET
;;
;; MessageText:
;;
;;  The transport connection has been reset.
;;
 STATUS_CONNECTION_RESET          EQU 0C000020DH

;;
;; MessageId: STATUS_TOO_MANY_NODES
;;
;; MessageText:
;;
;;  The transport cannot dynamically acquire any more nodes.
;;
 STATUS_TOO_MANY_NODES            EQU 0C000020EH

;;
;; MessageId: STATUS_TRANSACTION_ABORTED
;;
;; MessageText:
;;
;;  The transport aborted a pending transaction.
;;
 STATUS_TRANSACTION_ABORTED       EQU 0C000020FH

;;
;; MessageId: STATUS_TRANSACTION_TIMED_OUT
;;
;; MessageText:
;;
;;  The transport timed out a request waiting for a response.
;;
 STATUS_TRANSACTION_TIMED_OUT     EQU 0C0000210H

;;
;; MessageId: STATUS_TRANSACTION_NO_RELEASE
;;
;; MessageText:
;;
;;  The transport did not receive a release for a pending response.
;;
 STATUS_TRANSACTION_NO_RELEASE    EQU 0C0000211H

;;
;; MessageId: STATUS_TRANSACTION_NO_MATCH
;;
;; MessageText:
;;
;;  The transport did not find a transaction matching the specific
;;  token.
;;
 STATUS_TRANSACTION_NO_MATCH      EQU 0C0000212H

;;
;; MessageId: STATUS_TRANSACTION_RESPONDED
;;
;; MessageText:
;;
;;  The transport had previously responded to a transaction request.
;;
 STATUS_TRANSACTION_RESPONDED     EQU 0C0000213H

;;
;; MessageId: STATUS_TRANSACTION_INVALID_ID
;;
;; MessageText:
;;
;;  The transport does not recognized the transaction request
;;  identifier specified.
;;
 STATUS_TRANSACTION_INVALID_ID    EQU 0C0000214H

;;
;; MessageId: STATUS_TRANSACTION_INVALID_TYPE
;;
;; MessageText:
;;
;;  The transport does not recognize the transaction request
;;  type specified.
;;
 STATUS_TRANSACTION_INVALID_TYPE  EQU 0C0000215H

;;
;; MessageId: STATUS_NOT_SERVER_SESSION
;;
;; MessageText:
;;
;;  The transport can only process the specified request on
;;  the server side of a session.
;;
 STATUS_NOT_SERVER_SESSION        EQU 0C0000216H

;;
;; MessageId: STATUS_NOT_CLIENT_SESSION
;;
;; MessageText:
;;
;;  The transport can only process the specified request on
;;  the client side of a session.
;;
 STATUS_NOT_CLIENT_SESSION        EQU 0C0000217H

;;
;; MessageId: STATUS_CANNOT_LOAD_REGISTRY_FILE
;;
;; MessageText:
;;
;;  {Registry File Failure}
;;  The registry cannot load the hive (file):
;;  %s
;;  or its log or alternate.
;;  It is corrupt, absent, or not writeable.
;;
 STATUS_CANNOT_LOAD_REGISTRY_FILE EQU 0C0000218H

;;
;; MessageId: STATUS_DEBUG_ATTACH_FAILED
;;
;; MessageText:
;;
;;  {Unexpected Failure in DebugActiveProcess}
;;  An unexpected failure occurred while processing a DebugActiveProcess API
;;  request.  You may choose OK to terminate the process, or Cancel to
;;  ignore the error.
;;
 STATUS_DEBUG_ATTACH_FAILED       EQU 0C0000219H

;;
;; MessageId: STATUS_SYSTEM_PROCESS_TERMINATED
;;
;; MessageText:
;;
;;  {Fatal System Error}
;;  The %s system process terminated unexpectedly
;;  with a status of 0x%08x (0x%08x 0x%08x).
;;  The system has been shut down.
;;
 STATUS_SYSTEM_PROCESS_TERMINATED EQU 0C000021AH

;;
;; MessageId: STATUS_DATA_NOT_ACCEPTED
;;
;; MessageText:
;;
;;  {Data Not Accepted}
;;  The TDI client could not handle the data received during an
;;  indication.
;;
 STATUS_DATA_NOT_ACCEPTED         EQU 0C000021BH

;;
;; MessageId: STATUS_NO_BROWSER_SERVERS_FOUND
;;
;; MessageText:
;;
;;  {Unable to Retrieve Browser Server List}
;;  The list of servers for this workgroup is not currently available.
;;
 STATUS_NO_BROWSER_SERVERS_FOUND  EQU 0C000021CH

;;
;; MessageId: STATUS_VDM_HARD_ERROR
;;
;; MessageText:
;;
;;  NTVDM encountered a hard error.
;;
 STATUS_VDM_HARD_ERROR            EQU 0C000021DH

;;
;; MessageId: STATUS_DRIVER_CANCEL_TIMEOUT
;;
;; MessageText:
;;
;;  {Cancel Timeout}
;;  The driver %s failed to complete a cancelled I/O request in the allotted time.
;;
 STATUS_DRIVER_CANCEL_TIMEOUT     EQU 0C000021EH

;;
;; MessageId: STATUS_REPLY_MESSAGE_MISMATCH
;;
;; MessageText:
;;
;;  {Reply Message Mismatch}
;;  An attempt was made to reply to an LPC message, but the thread specified
;;  by the client ID in the message was not waiting on that message.
;;
 STATUS_REPLY_MESSAGE_MISMATCH    EQU 0C000021FH

;;
;; MessageId: STATUS_MAPPED_ALIGNMENT
;;
;; MessageText:
;;
;;  {Mapped View Aligment Incorrect}
;;  An attempt was made to map a view of a file, but either the specified base
;;  address or the offset into the file were not aligned on the proper
;;  allocation granularity.
;;
 STATUS_MAPPED_ALIGNMENT          EQU 0C0000220H

;;
;; MessageId: STATUS_IMAGE_CHECKSUM_MISMATCH
;;
;; MessageText:
;;
;;  {Bad Image Checksum}
;;  The image %s is possibly corrupt. The header checksum does not
;;  match the computed checksum.
;;
 STATUS_IMAGE_CHECKSUM_MISMATCH   EQU 0C0000221H

;;
;; MessageId: STATUS_LOST_WRITEBEHIND_DATA
;;
;; MessageText:
;;
;;  {Lost Delayed-Write Data}
;;  The system was attempting to transfer file data from buffers to %s.
;;  The write operation failed, and only some of the data may have been
;;  written to the file.
;;
 STATUS_LOST_WRITEBEHIND_DATA     EQU 0C0000222H

;;
;; MessageId: STATUS_CLIENT_SERVER_PARAMETERS_INVALID
;;
;; MessageText:
;;
;;  The parameter(s) passed to the server in the client/server shared memory
;;  window were invalid. Too much data may have been put in the shared memory
;;  window.
;;
 STATUS_CLIENT_SERVER_PARAMETERS_INVALID EQU 0C0000223H

;;
;; MessageId: STATUS_PASSWORD_MUST_CHANGE
;;
;; MessageText:
;;
;;  The user must change his password before he logs on the first time.
;;
 STATUS_PASSWORD_MUST_CHANGE      EQU 0C0000224H    ;; ntsubauth

;;
;; MessageId: STATUS_NOT_FOUND
;;
;; MessageText:
;;
;;  The object was not found.
;;
 STATUS_NOT_FOUND                 EQU 0C0000225H

;;
;; MessageId: STATUS_NOT_TINY_STREAM
;;
;; MessageText:
;;
;;  The stream is not a tiny stream.
;;
 STATUS_NOT_TINY_STREAM           EQU 0C0000226H

;;
;; MessageId: STATUS_RECOVERY_FAILURE
;;
;; MessageText:
;;
;;  A transaction recover failed.
;;
 STATUS_RECOVERY_FAILURE          EQU 0C0000227H

;;
;; MessageId: STATUS_STACK_OVERFLOW_READ
;;
;; MessageText:
;;
;;  The request must be handled by the stack overflow code.
;;
 STATUS_STACK_OVERFLOW_READ       EQU 0C0000228H

;;
;; MessageId: STATUS_FAIL_CHECK
;;
;; MessageText:
;;
;;  A consistancy check failed.
;;
 STATUS_FAIL_CHECK                EQU 0C0000229H

;;
;; MessageId: STATUS_DUPLICATE_OBJECTID
;;
;; MessageText:
;;
;;  The attempt to insert the ID in the index failed because the
;;  ID is already in the index.
;;
 STATUS_DUPLICATE_OBJECTID        EQU 0C000022AH

;;
;; MessageId: STATUS_OBJECTID_EXISTS
;;
;; MessageText:
;;
;;  The attempt to set the object's ID failed because the object
;;  already has an ID.
;;
 STATUS_OBJECTID_EXISTS           EQU 0C000022BH

;;
;; MessageId: STATUS_CONVERT_TO_LARGE
;;
;; MessageText:
;;
;;  Internal OFS status codes indicating how an allocation operation is
;;  handled.  Either it is retried after the containing onode is moved
;;  or the extent stream is converted to a large stream.
;;
 STATUS_CONVERT_TO_LARGE          EQU 0C000022CH

;;
;; MessageId: STATUS_RETRY
;;
;; MessageText:
;;
;;  The request needs to be retried.
;;
 STATUS_RETRY                     EQU 0C000022DH

;;
;; MessageId: STATUS_FOUND_OUT_OF_SCOPE
;;
;; MessageText:
;;
;;  The attempt to find the object found an object matching by ID
;;  on the volume but it is out of the scope of the handle used
;;  for the operation.
;;
 STATUS_FOUND_OUT_OF_SCOPE        EQU 0C000022EH

;;
;; MessageId: STATUS_ALLOCATE_BUCKET
;;
;; MessageText:
;;
;;  The bucket array must be grown.  Retry transaction after doing so.
;;
 STATUS_ALLOCATE_BUCKET           EQU 0C000022FH

;;
;; MessageId: STATUS_PROPSET_NOT_FOUND
;;
;; MessageText:
;;
;;  The property set specified does not exist on the object.
;;
 STATUS_PROPSET_NOT_FOUND         EQU 0C0000230H

;;
;; MessageId: STATUS_MARSHALL_OVERFLOW
;;
;; MessageText:
;;
;;  The user/kernel marshalling buffer has overflowed.
;;
 STATUS_MARSHALL_OVERFLOW         EQU 0C0000231H

;;
;; MessageId: STATUS_INVALID_VARIANT
;;
;; MessageText:
;;
;;  The supplied variant structure contains invalid data.
;;
 STATUS_INVALID_VARIANT           EQU 0C0000232H

;;
;; MessageId: STATUS_DOMAIN_CONTROLLER_NOT_FOUND
;;
;; MessageText:
;;
;;  Could not find a domain controller for this domain.
;;
 STATUS_DOMAIN_CONTROLLER_NOT_FOUND EQU 0C0000233H

;;
;; MessageId: STATUS_ACCOUNT_LOCKED_OUT
;;
;; MessageText:
;;
;;  The user account has been automatically locked because too many invalid logon
;;  attempts or password change attempts have been requested.
;;
 STATUS_ACCOUNT_LOCKED_OUT        EQU 0C0000234H    ;; ntsubauth

;;
;; MessageId: STATUS_HANDLE_NOT_CLOSABLE
;;
;; MessageText:
;;
;;  NtClose was called on a handle that was protected from close via NtSetInformationObject.
;;
 STATUS_HANDLE_NOT_CLOSABLE       EQU 0C0000235H

;;
;; MessageId: STATUS_CONNECTION_REFUSED
;;
;; MessageText:
;;
;;  The transport connection attempt was refused by the remote system.
;;
 STATUS_CONNECTION_REFUSED        EQU 0C0000236H

;;
;; MessageId: STATUS_GRACEFUL_DISCONNECT
;;
;; MessageText:
;;
;;  The transport connection was gracefully closed.
;;
 STATUS_GRACEFUL_DISCONNECT       EQU 0C0000237H

;;
;; MessageId: STATUS_ADDRESS_ALREADY_ASSOCIATED
;;
;; MessageText:
;;
;;  The transport endpoint already has an address associated with it.
;;
 STATUS_ADDRESS_ALREADY_ASSOCIATED EQU 0C0000238H

;;
;; MessageId: STATUS_ADDRESS_NOT_ASSOCIATED
;;
;; MessageText:
;;
;;  An address has not yet been associated with the transport endpoint.
;;
 STATUS_ADDRESS_NOT_ASSOCIATED    EQU 0C0000239H

;;
;; MessageId: STATUS_CONNECTION_INVALID
;;
;; MessageText:
;;
;;  An operation was attempted on a nonexistent transport connection.
;;
 STATUS_CONNECTION_INVALID        EQU 0C000023AH

;;
;; MessageId: STATUS_CONNECTION_ACTIVE
;;
;; MessageText:
;;
;;  An invalid operation was attempted on an active transport connection.
;;
 STATUS_CONNECTION_ACTIVE         EQU 0C000023BH

;;
;; MessageId: STATUS_NETWORK_UNREACHABLE
;;
;; MessageText:
;;
;;  The remote network is not reachable by the transport.
;;
 STATUS_NETWORK_UNREACHABLE       EQU 0C000023CH

;;
;; MessageId: STATUS_HOST_UNREACHABLE
;;
;; MessageText:
;;
;;  The remote system is not reachable by the transport.
;;
 STATUS_HOST_UNREACHABLE          EQU 0C000023DH

;;
;; MessageId: STATUS_PROTOCOL_UNREACHABLE
;;
;; MessageText:
;;
;;  The remote system does not support the transport protocol.
;;
 STATUS_PROTOCOL_UNREACHABLE      EQU 0C000023EH

;;
;; MessageId: STATUS_PORT_UNREACHABLE
;;
;; MessageText:
;;
;;  No service is operating at the destination port of the transport
;;  on the remote system.
;;
 STATUS_PORT_UNREACHABLE          EQU 0C000023FH

;;
;; MessageId: STATUS_REQUEST_ABORTED
;;
;; MessageText:
;;
;;  The request was aborted.
;;
 STATUS_REQUEST_ABORTED           EQU 0C0000240H

;;
;; MessageId: STATUS_CONNECTION_ABORTED
;;
;; MessageText:
;;
;;  The transport connection was aborted by the local system.
;;
 STATUS_CONNECTION_ABORTED        EQU 0C0000241H

;;
;; MessageId: STATUS_BAD_COMPRESSION_BUFFER
;;
;; MessageText:
;;
;;  The specified buffer contains ill-formed data.
;;
 STATUS_BAD_COMPRESSION_BUFFER    EQU 0C0000242H

;;
;; MessageId: STATUS_USER_MAPPED_FILE
;;
;; MessageText:
;;
;;  The requested operation cannot be performed on a file with a user mapped section open.
;;
 STATUS_USER_MAPPED_FILE          EQU 0C0000243H

;;
;; MessageId: STATUS_AUDIT_FAILED
;;
;; MessageText:
;;
;;  {Audit Failed}
;;  An attempt to generate a security audit failed.
;;
 STATUS_AUDIT_FAILED              EQU 0C0000244H

;;
;; MessageId: STATUS_TIMER_RESOLUTION_NOT_SET
;;
;; MessageText:
;;
;;  The timer resolution was not previously set by the current process.
;;
 STATUS_TIMER_RESOLUTION_NOT_SET  EQU 0C0000245H

;;
;; MessageId: STATUS_CONNECTION_COUNT_LIMIT
;;
;; MessageText:
;;
;;  A connection to the server could not be made because the limit on the number of
;;  concurrent connections for this account has been reached.
;;
 STATUS_CONNECTION_COUNT_LIMIT    EQU 0C0000246H

;;
;; MessageId: STATUS_LOGIN_TIME_RESTRICTION
;;
;; MessageText:
;;
;;  Attempting to login during an unauthorized time of day for this account.
;;
 STATUS_LOGIN_TIME_RESTRICTION    EQU 0C0000247H

;;
;; MessageId: STATUS_LOGIN_WKSTA_RESTRICTION
;;
;; MessageText:
;;
;;  The account is not authorized to login from this station.
;;
 STATUS_LOGIN_WKSTA_RESTRICTION   EQU 0C0000248H

;;
;; MessageId: STATUS_IMAGE_MP_UP_MISMATCH
;;
;; MessageText:
;;
;;  {UP/MP Image Mismatch}
;;  The image %s has been modified for use on a uniprocessor system,
;;  but you are running it on a multiprocessor machine.
;;  Please reinstall the image file.
;;
 STATUS_IMAGE_MP_UP_MISMATCH      EQU 0C0000249H

;;
;; MessageId: STATUS_INSUFFICIENT_LOGON_INFO
;;
;; MessageText:
;;
;;  There is insufficient account information to log you on.
;;
 STATUS_INSUFFICIENT_LOGON_INFO   EQU 0C0000250H

;;
;; MessageId: STATUS_BAD_DLL_ENTRYPOINT
;;
;; MessageText:
;;
;;  {Invalid DLL Entrypoint}
;;  The dynamic link library %s is not written correctly. The stack pointer has been left in an inconsistent state.
;;  The entrypoint should be declared as WINAPI or STDCALL. Select YES to fail the DLL load. Select NO to continue
;;  execution. Selecting NO may cause the application to operate incorrectly.
;;
 STATUS_BAD_DLL_ENTRYPOINT        EQU 0C0000251H

;;
;; MessageId: STATUS_BAD_SERVICE_ENTRYPOINT
;;
;; MessageText:
;;
;;  {Invalid Service Callback Entrypoint}
;;  The %s service is not written correctly. The stack pointer has been left in an inconsistent state.
;;  The callback entrypoint should be declared as WINAPI or STDCALL. Selecting OK will cause the
;;  service to continue operation. However, the service process may operate incorrectly.
;;
 STATUS_BAD_SERVICE_ENTRYPOINT    EQU 0C0000252H

;;
;; MessageId: STATUS_LPC_REPLY_LOST
;;
;; MessageText:
;;
;;  The server received the messages but did not send a reply.
;;
 STATUS_LPC_REPLY_LOST            EQU 0C0000253H

;;
;; MessageId: STATUS_IP_ADDRESS_CONFLICT1
;;
;; MessageText:
;;
;;  The system has detected an IP address conflict with another system on the
;;  network. The local interface has been disabled. More details are available in
;;  the system event log. Consult your network administrator to resolve the
;;  conflict.
;;
 STATUS_IP_ADDRESS_CONFLICT1      EQU 0C0000254H

;;
;; MessageId: STATUS_IP_ADDRESS_CONFLICT2
;;
;; MessageText:
;;
;;  The system has detected an IP address conflict with another system on the
;;  network. Network operations on this system may be disrupted as a result.
;;  More details are available in the system event log. Consult your network
;;  administrator immediately to resolve the conflict.
;;
 STATUS_IP_ADDRESS_CONFLICT2      EQU 0C0000255H

;;
;; MessageId: STATUS_REGISTRY_QUOTA_LIMIT
;;
;; MessageText:
;;
;;  {Low on Registry Quota}
;;  Your system is running low on registry quota.
;;  Start the System option in the Control Panel and choose the Change button in the
;;  Virtual Memory section of the Performance tab to increase the registry quota.
;;
 STATUS_REGISTRY_QUOTA_LIMIT      EQU 0C0000256H

;;
;; MessageId: STATUS_PATH_NOT_COVERED
;;
;; MessageText:
;;
;;  The contacted server does not support the indicated part of the DFS namespace.
;;
 STATUS_PATH_NOT_COVERED          EQU 0C0000257H

;;
;; MessageId: STATUS_NO_CALLBACK_ACTIVE
;;
;; MessageText:
;;
;;  A callback return system service cannot be executed when no callback is active.
;;
 STATUS_NO_CALLBACK_ACTIVE        EQU 0C0000258H

;;
;; MessageId: STATUS_LICENSE_QUOTA_EXCEEDED
;;
;; MessageText:
;;
;;  The service being accessed is licensed for a particular number of connections.
;;  No more connections can be made to the service at this time
;;  because there are already as many connections as the service can accept.
;;
 STATUS_LICENSE_QUOTA_EXCEEDED    EQU 0C0000259H

;;
;; MessageId: STATUS_PWD_TOO_SHORT
;;
;; MessageText:
;;
;;  The password provided is too short to meet the policy of your user account.
;;  Please choose a longer password.
;;
 STATUS_PWD_TOO_SHORT             EQU 0C000025AH

;;
;; MessageId: STATUS_PWD_TOO_RECENT
;;
;; MessageText:
;;
;;  The policy of your user account does not allow you to change passwords too
;;  frequently.  This is done to prevent users from changing back to a familiar, but
;;  potentially discovered, password.  If you feel your password has been compromised
;;  then please contact your administrator immediately to have a new one assigned.
;;
 STATUS_PWD_TOO_RECENT            EQU 0C000025BH

;;
;; MessageId: STATUS_PWD_HISTORY_CONFLICT
;;
;; MessageText:
;;
;;  You have attempted to change your password to one that you have used in the past.
;;  The policy of your user account does not allow this.  Please select a password
;;  that you have not previously used.
;;
 STATUS_PWD_HISTORY_CONFLICT      EQU 0C000025CH

;;
;; MessageId: STATUS_PLUGPLAY_NO_DEVICE
;;
;; MessageText:
;;
;;  You have attempted to load a legacy device driver while its device instance had
;;  been disabled.
;;
 STATUS_PLUGPLAY_NO_DEVICE        EQU 0C000025EH

;;
;; MessageId: STATUS_UNSUPPORTED_COMPRESSION
;;
;; MessageText:
;;
;;  The specified compression format is unsupported.
;;
 STATUS_UNSUPPORTED_COMPRESSION   EQU 0C000025FH

;;
;; MessageId: STATUS_INVALID_HW_PROFILE
;;
;; MessageText:
;;
;;  The specified hardware profile configuration is invalid.
;;
 STATUS_INVALID_HW_PROFILE        EQU 0C0000260H

;;
;; MessageId: STATUS_INVALID_PLUGPLAY_DEVICE_PATH
;;
;; MessageText:
;;
;;  The specified Plug and Play registry device path is invalid.
;;
 STATUS_INVALID_PLUGPLAY_DEVICE_PATH EQU 0C0000261H

;;
;; MessageId: STATUS_DRIVER_ORDINAL_NOT_FOUND
;;
;; MessageText:
;;
;;  {Driver Entry Point Not Found}
;;  The %s device driver could not locate the ordinal %ld in driver %s.
;;
 STATUS_DRIVER_ORDINAL_NOT_FOUND  EQU 0C0000262H

;;
;; MessageId: STATUS_DRIVER_ENTRYPOINT_NOT_FOUND
;;
;; MessageText:
;;
;;  {Driver Entry Point Not Found}
;;  The %s device driver could not locate the entry point %s in driver %s.
;;
 STATUS_DRIVER_ENTRYPOINT_NOT_FOUND EQU 0C0000263H

;;
;; MessageId: STATUS_RESOURCE_NOT_OWNED
;;
;; MessageText:
;;
;;  {Application Error}
;;  The application attempted to release a resource it did not own.  Click on OK to
;;  terminate the application.
;;
 STATUS_RESOURCE_NOT_OWNED        EQU 0C0000264H

;;
;; MessageId: STATUS_TOO_MANY_LINKS
;;
;; MessageText:
;;
;;  An attempt was made to create more links on a file than
;;  the file system supports.
;;
 STATUS_TOO_MANY_LINKS            EQU 0C0000265H

;;
;; MessageId: STATUS_QUOTA_LIST_INCONSISTENT
;;
;; MessageText:
;;
;;  The specified quota list is internally inconsistent with its descriptor.
;;
 STATUS_QUOTA_LIST_INCONSISTENT   EQU 0C0000266H

;;
;; MessageId: STATUS_FILE_IS_OFFLINE
;;
;; MessageText:
;;
;;  The specified file has been relocated to offline storage.
;;
 STATUS_FILE_IS_OFFLINE           EQU 0C0000267H

;;
;; MessageId: STATUS_EVALUATION_EXPIRATION
;;
;; MessageText:
;;
;;  {Windows NT Evaluation Notification}
;;  The evaluation period for this installation of Windows NT has expired.
;;  This system will shutdown in 1 hour. To restore access to this installation
;;  of Windows NT, please upgrade this installation using a licensed distribution
;;  of this product.
;;
 STATUS_EVALUATION_EXPIRATION     EQU 0C0000268H

;;
;; MessageId: STATUS_ILLEGAL_DLL_RELOCATION
;;
;; MessageText:
;;
;;  {Illegal System DLL Relocation}
;;  The system DLL %s was relocated in memory. The application will not run properly.
;;  The relocation occured because the DLL %s occupied an address range reserved for
;;  Windows NT system DLL's. The vendor supplying the DLL should be contacted for a new DLL.
;;
 STATUS_ILLEGAL_DLL_RELOCATION    EQU 0C0000269H

;;
;; MessageId: STATUS_LICENSE_VIOLATION
;;
;; MessageText:
;;
;;  {License Violation}
;;  The system has detected tampering with your registered product type. This is a violation
;;  of your software license. Tampering with product type is not permitted.
;;
 STATUS_LICENSE_VIOLATION         EQU 0C000026AH

;;
;; MessageId: STATUS_DLL_INIT_FAILED_LOGOFF
;;
;; MessageText:
;;
;;  {DLL Initialization Failed}
;;  The application failed to initialize because the window station is shutting down.
;;
 STATUS_DLL_INIT_FAILED_LOGOFF    EQU 0C000026BH

;;
;; MessageId: STATUS_DRIVER_UNABLE_TO_LOAD
;;
;; MessageText:
;;
;;  {Unable to Load Device Driver}
;;  %s device driver could not be loaded.
;;  Error Status was 0x%x
;;
 STATUS_DRIVER_UNABLE_TO_LOAD     EQU 0C000026CH

;;
;; MessageId: STATUS_DFS_UNAVAILABLE
;;
;; MessageText:
;;
;;  DFS is unavailable on the contacted server.
;;
 STATUS_DFS_UNAVAILABLE           EQU 0C000026DH

;;
;; MessageId: STATUS_VOLUME_DISMOUNTED
;;
;; MessageText:
;;
;;  An operation was attempted to a volume after it was dismounted.
;;
 STATUS_VOLUME_DISMOUNTED         EQU 0C000026EH

;;
;; MessageId: STATUS_WX86_INTERNAL_ERROR
;;
;; MessageText:
;;
;;  An internal error occurred in the Win32 x86 emulation subsystem.
;;
 STATUS_WX86_INTERNAL_ERROR       EQU 0C000026FH

;;
;; MessageId: STATUS_WX86_FLOAT_STACK_CHECK
;;
;; MessageText:
;;
;;  Win32 x86 emulation subsystem Floating-point stack check.
;;
 STATUS_WX86_FLOAT_STACK_CHECK    EQU 0C0000270H

;;
;; MessageId: STATUS_VALIDATE_CONTINUE
;;
;; MessageText:
;;
;;  The validation process needs to continue on to the next step.
;;
 STATUS_VALIDATE_CONTINUE         EQU 0C0000271H

;;
;; MessageId: STATUS_NO_MATCH
;;
;; MessageText:
;;
;;  There was no match for the specified key in the index.
;;
 STATUS_NO_MATCH                  EQU 0C0000272H

;;
;; MessageId: STATUS_NO_MORE_MATCHES
;;
;; MessageText:
;;
;;  There are no more matches for the current index enumeration.
;;
 STATUS_NO_MORE_MATCHES           EQU 0C0000273H

;;
;; MessageId: STATUS_INVALID_VLM_OPERATION
;;
;; MessageText:
;;
;;  The specified Very Large Memory (64-bit Virtual Addressing) operation is invalid.
;;
 STATUS_INVALID_VLM_OPERATION     EQU 0C0000274H

;;
;; MessageId: STATUS_NOT_A_REPARSE_POINT
;;
;; MessageText:
;;
;;  The NTFS file or directory is not a reparse point.
;;
 STATUS_NOT_A_REPARSE_POINT       EQU 0C0000275H

;;
;; MessageId: STATUS_IO_REPARSE_TAG_INVALID
;;
;; MessageText:
;;
;;  The NT I/O reparse tag passed for the NTFS reparse point is invalid.
;;
 STATUS_IO_REPARSE_TAG_INVALID    EQU 0C0000276H

;;
;; MessageId: STATUS_IO_REPARSE_TAG_MISMATCH
;;
;; MessageText:
;;
;;  The NT I/O reparse tag does not match the one present in the NTFS reparse point.
;;
 STATUS_IO_REPARSE_TAG_MISMATCH   EQU 0C0000277H

;;
;; MessageId: STATUS_IO_REPARSE_DATA_INVALID
;;
;; MessageText:
;;
;;  The user data passed for the NTFS reparse point is invalid.
;;
 STATUS_IO_REPARSE_DATA_INVALID   EQU 0C0000278H

;;
;; MessageId: STATUS_IO_REPARSE_TAG_NOT_HANDLED
;;
;; MessageText:
;;
;;  The layered file system driver for this IO tag did not handle it when needed.
;;
 STATUS_IO_REPARSE_TAG_NOT_HANDLED EQU 0C0000279H

;;
;; MessageId: STATUS_REPARSE_POINT_NOT_RESOLVED
;;
;; MessageText:
;;
;;  The NTFS symbolic link could not be resolved even though the initial file name is valid.
;;
 STATUS_REPARSE_POINT_NOT_RESOLVED EQU 0C0000280H

;;
;; MessageId: STATUS_DIRECTORY_IS_A_REPARSE_POINT
;;
;; MessageText:
;;
;;  The NTFS directory is a reparse point.
;;
 STATUS_DIRECTORY_IS_A_REPARSE_POINT EQU 0C0000281H

;;
;; MessageId: STATUS_RANGE_LIST_CONFLICT
;;
;; MessageText:
;;
;;  The range could not be added to the range list because of a conflict.
;;
 STATUS_RANGE_LIST_CONFLICT       EQU 0C0000282H

;;
;; MessageId: STATUS_SOURCE_ELEMENT_EMPTY
;;
;; MessageText:
;;
;;  The specified medium changer source element contains no media.
;;
 STATUS_SOURCE_ELEMENT_EMPTY      EQU 0C0000283H

;;
;; MessageId: STATUS_DESTINATION_ELEMENT_FULL
;;
;; MessageText:
;;
;;  The specified medium changer destination element already contains media.
;;
 STATUS_DESTINATION_ELEMENT_FULL  EQU 0C0000284H

;;
;; MessageId: STATUS_ILLEGAL_ELEMENT_ADDRESS
;;
;; MessageText:
;;
;;  The specified medium changer element does not exist.
;;
 STATUS_ILLEGAL_ELEMENT_ADDRESS   EQU 0C0000285H

;;
;; MessageId: STATUS_MAGAZINE_NOT_PRESENT
;;
;; MessageText:
;;
;;  The specified element is contained within a magazine that is no longer present.
;;
 STATUS_MAGAZINE_NOT_PRESENT      EQU 0C0000286H

;;
;; MessageId: STATUS_REINITIALIZATION_NEEDED
;;
;; MessageText:
;;
;;  The device requires reinitialization due to hardware errors.
;;
 STATUS_REINITIALIZATION_NEEDED   EQU 0C0000287H

;;
;; MessageId: STATUS_DEVICE_REQUIRES_CLEANING
;;
;; MessageText:
;;
;;  The device has indicated that cleaning is necessary.
;;
 STATUS_DEVICE_REQUIRES_CLEANING  EQU 080000288H

;;
;; MessageId: STATUS_DEVICE_DOOR_OPEN
;;
;; MessageText:
;;
;;  The device has indicated that it's door is open. Further operations require it closed and secured.
;;
 STATUS_DEVICE_DOOR_OPEN          EQU 080000289H

;;
;; MessageId: STATUS_ENCRYPTION_FAILED
;;
;; MessageText:
;;
;;  The file encryption attempt failed.
;;
 STATUS_ENCRYPTION_FAILED         EQU 0C000028AH

;;
;; MessageId: STATUS_DECRYPTION_FAILED
;;
;; MessageText:
;;
;;  The file decryption attempt failed.
;;
 STATUS_DECRYPTION_FAILED         EQU 0C000028BH

;;
;; MessageId: STATUS_RANGE_NOT_FOUND
;;
;; MessageText:
;;
;;  The specified range could not be found in the range list.
;;
 STATUS_RANGE_NOT_FOUND           EQU 0C000028CH

;;
;; MessageId: STATUS_NO_RECOVERY_POLICY
;;
;; MessageText:
;;
;;  There is no encryption recovery policy configured for this system.
;;
 STATUS_NO_RECOVERY_POLICY        EQU 0C000028DH

;;
;; MessageId: STATUS_NO_EFS
;;
;; MessageText:
;;
;;  The required encryption driver is not loaded for this system.
;;
 STATUS_NO_EFS                    EQU 0C000028EH

;;
;; MessageId: STATUS_WRONG_EFS
;;
;; MessageText:
;;
;;  The file was encrypted with a different encryption driver than is currently loaded.
;;
 STATUS_WRONG_EFS                 EQU 0C000028FH

;;
;; MessageId: STATUS_NO_USER_KEYS
;;
;; MessageText:
;;
;;  There are no EFS keys defined for the user.
;;
 STATUS_NO_USER_KEYS              EQU 0C0000290H

;;
;; MessageId: STATUS_FILE_NOT_ENCRYPTED
;;
;; MessageText:
;;
;;  The specified file is not encrypted.
;;
 STATUS_FILE_NOT_ENCRYPTED        EQU 0C0000291H

;;
;; MessageId: STATUS_NOT_EXPORT_FORMAT
;;
;; MessageText:
;;
;;  The specified file is not in the defined EFS export format.
;;
 STATUS_NOT_EXPORT_FORMAT         EQU 0C0000292H

;;
;; MessageId: STATUS_FILE_ENCRYPTED
;;
;; MessageText:
;;
;;  The specified file is encrypted and the user does not have the ability to decrypt it.
;;
 STATUS_FILE_ENCRYPTED            EQU 0C0000293H

;;
;; MessageId: STATUS_WAKE_SYSTEM
;;
;; MessageText:
;;
;;  The system has awoken
;;
 STATUS_WAKE_SYSTEM               EQU 040000294H

;;
;; MessageId: STATUS_WMI_GUID_NOT_FOUND
;;
;; MessageText:
;;
;;  The guid passed was not recognized as valid by a WMI data provider.
;;
 STATUS_WMI_GUID_NOT_FOUND        EQU 0C0000295H

;;
;; MessageId: STATUS_WMI_INSTANCE_NOT_FOUND
;;
;; MessageText:
;;
;;  The instance name passed was not recognized as valid by a WMI data provider.
;;
 STATUS_WMI_INSTANCE_NOT_FOUND    EQU 0C0000296H

;;
;; MessageId: STATUS_WMI_ITEMID_NOT_FOUND
;;
;; MessageText:
;;
;;  The data item id passed was not recognized as valid by a WMI data provider.
;;
 STATUS_WMI_ITEMID_NOT_FOUND      EQU 0C0000297H

;;
;; MessageId: STATUS_WMI_TRY_AGAIN
;;
;; MessageText:
;;
;;  The WMI request could not be completed and should be retried.
;;
 STATUS_WMI_TRY_AGAIN             EQU 0C0000298H

;;
;; MessageId: STATUS_SHARED_POLICY
;;
;; MessageText:
;;
;;  The policy object is shared and can only be modified at the root
;;
 STATUS_SHARED_POLICY             EQU 0C0000299H

;;
;; MessageId: STATUS_POLICY_OBJECT_NOT_FOUND
;;
;; MessageText:
;;
;;  The policy object does not exist when it should
;;
 STATUS_POLICY_OBJECT_NOT_FOUND   EQU 0C000029AH

;;
;; MessageId: STATUS_WOW_ASSERTION
;;
;; MessageText:
;;
;;  WOW Assertion Error.
;;
 STATUS_WOW_ASSERTION             EQU 0C0009898H

;;
;; MessageId: RPC_NT_INVALID_STRING_BINDING
;;
;; MessageText:
;;
;;  The string binding is invalid.
;;
 RPC_NT_INVALID_STRING_BINDING    EQU 0C0020001H

;;
;; MessageId: RPC_NT_WRONG_KIND_OF_BINDING
;;
;; MessageText:
;;
;;  The binding handle is not the correct type.
;;
 RPC_NT_WRONG_KIND_OF_BINDING     EQU 0C0020002H

;;
;; MessageId: RPC_NT_INVALID_BINDING
;;
;; MessageText:
;;
;;  The binding handle is invalid.
;;
 RPC_NT_INVALID_BINDING           EQU 0C0020003H

;;
;; MessageId: RPC_NT_PROTSEQ_NOT_SUPPORTED
;;
;; MessageText:
;;
;;  The RPC protocol sequence is not supported.
;;
 RPC_NT_PROTSEQ_NOT_SUPPORTED     EQU 0C0020004H

;;
;; MessageId: RPC_NT_INVALID_RPC_PROTSEQ
;;
;; MessageText:
;;
;;  The RPC protocol sequence is invalid.
;;
 RPC_NT_INVALID_RPC_PROTSEQ       EQU 0C0020005H

;;
;; MessageId: RPC_NT_INVALID_STRING_UUID
;;
;; MessageText:
;;
;;  The string UUID is invalid.
;;
 RPC_NT_INVALID_STRING_UUID       EQU 0C0020006H

;;
;; MessageId: RPC_NT_INVALID_ENDPOINT_FORMAT
;;
;; MessageText:
;;
;;  The endpoint format is invalid.
;;
 RPC_NT_INVALID_ENDPOINT_FORMAT   EQU 0C0020007H

;;
;; MessageId: RPC_NT_INVALID_NET_ADDR
;;
;; MessageText:
;;
;;  The network address is invalid.
;;
 RPC_NT_INVALID_NET_ADDR          EQU 0C0020008H

;;
;; MessageId: RPC_NT_NO_ENDPOINT_FOUND
;;
;; MessageText:
;;
;;  No endpoint was found.
;;
 RPC_NT_NO_ENDPOINT_FOUND         EQU 0C0020009H

;;
;; MessageId: RPC_NT_INVALID_TIMEOUT
;;
;; MessageText:
;;
;;  The timeout value is invalid.
;;
 RPC_NT_INVALID_TIMEOUT           EQU 0C002000AH

;;
;; MessageId: RPC_NT_OBJECT_NOT_FOUND
;;
;; MessageText:
;;
;;  The object UUID was not found.
;;
 RPC_NT_OBJECT_NOT_FOUND          EQU 0C002000BH

;;
;; MessageId: RPC_NT_ALREADY_REGISTERED
;;
;; MessageText:
;;
;;  The object UUID has already been registered.
;;
 RPC_NT_ALREADY_REGISTERED        EQU 0C002000CH

;;
;; MessageId: RPC_NT_TYPE_ALREADY_REGISTERED
;;
;; MessageText:
;;
;;  The type UUID has already been registered.
;;
 RPC_NT_TYPE_ALREADY_REGISTERED   EQU 0C002000DH

;;
;; MessageId: RPC_NT_ALREADY_LISTENING
;;
;; MessageText:
;;
;;  The RPC server is already listening.
;;
 RPC_NT_ALREADY_LISTENING         EQU 0C002000EH

;;
;; MessageId: RPC_NT_NO_PROTSEQS_REGISTERED
;;
;; MessageText:
;;
;;  No protocol sequences have been registered.
;;
 RPC_NT_NO_PROTSEQS_REGISTERED    EQU 0C002000FH

;;
;; MessageId: RPC_NT_NOT_LISTENING
;;
;; MessageText:
;;
;;  The RPC server is not listening.
;;
 RPC_NT_NOT_LISTENING             EQU 0C0020010H

;;
;; MessageId: RPC_NT_UNKNOWN_MGR_TYPE
;;
;; MessageText:
;;
;;  The manager type is unknown.
;;
 RPC_NT_UNKNOWN_MGR_TYPE          EQU 0C0020011H

;;
;; MessageId: RPC_NT_UNKNOWN_IF
;;
;; MessageText:
;;
;;  The interface is unknown.
;;
 RPC_NT_UNKNOWN_IF                EQU 0C0020012H

;;
;; MessageId: RPC_NT_NO_BINDINGS
;;
;; MessageText:
;;
;;  There are no bindings.
;;
 RPC_NT_NO_BINDINGS               EQU 0C0020013H

;;
;; MessageId: RPC_NT_NO_PROTSEQS
;;
;; MessageText:
;;
;;  There are no protocol sequences.
;;
 RPC_NT_NO_PROTSEQS               EQU 0C0020014H

;;
;; MessageId: RPC_NT_CANT_CREATE_ENDPOINT
;;
;; MessageText:
;;
;;  The endpoint cannot be created.
;;
 RPC_NT_CANT_CREATE_ENDPOINT      EQU 0C0020015H

;;
;; MessageId: RPC_NT_OUT_OF_RESOURCES
;;
;; MessageText:
;;
;;  Not enough resources are available to complete this operation.
;;
 RPC_NT_OUT_OF_RESOURCES          EQU 0C0020016H

;;
;; MessageId: RPC_NT_SERVER_UNAVAILABLE
;;
;; MessageText:
;;
;;  The RPC server is unavailable.
;;
 RPC_NT_SERVER_UNAVAILABLE        EQU 0C0020017H

;;
;; MessageId: RPC_NT_SERVER_TOO_BUSY
;;
;; MessageText:
;;
;;  The RPC server is too busy to complete this operation.
;;
 RPC_NT_SERVER_TOO_BUSY           EQU 0C0020018H

;;
;; MessageId: RPC_NT_INVALID_NETWORK_OPTIONS
;;
;; MessageText:
;;
;;  The network options are invalid.
;;
 RPC_NT_INVALID_NETWORK_OPTIONS   EQU 0C0020019H

;;
;; MessageId: RPC_NT_NO_CALL_ACTIVE
;;
;; MessageText:
;;
;;  There are no remote procedure calls active on this thread.
;;
 RPC_NT_NO_CALL_ACTIVE            EQU 0C002001AH

;;
;; MessageId: RPC_NT_CALL_FAILED
;;
;; MessageText:
;;
;;  The remote procedure call failed.
;;
 RPC_NT_CALL_FAILED               EQU 0C002001BH

;;
;; MessageId: RPC_NT_CALL_FAILED_DNE
;;
;; MessageText:
;;
;;  The remote procedure call failed and did not execute.
;;
 RPC_NT_CALL_FAILED_DNE           EQU 0C002001CH

;;
;; MessageId: RPC_NT_PROTOCOL_ERROR
;;
;; MessageText:
;;
;;  An RPC protocol error occurred.
;;
 RPC_NT_PROTOCOL_ERROR            EQU 0C002001DH

;;
;; MessageId: RPC_NT_UNSUPPORTED_TRANS_SYN
;;
;; MessageText:
;;
;;  The transfer syntax is not supported by the RPC server.
;;
 RPC_NT_UNSUPPORTED_TRANS_SYN     EQU 0C002001FH

;;
;; MessageId: RPC_NT_UNSUPPORTED_TYPE
;;
;; MessageText:
;;
;;  The type UUID is not supported.
;;
 RPC_NT_UNSUPPORTED_TYPE          EQU 0C0020021H

;;
;; MessageId: RPC_NT_INVALID_TAG
;;
;; MessageText:
;;
;;  The tag is invalid.
;;
 RPC_NT_INVALID_TAG               EQU 0C0020022H

;;
;; MessageId: RPC_NT_INVALID_BOUND
;;
;; MessageText:
;;
;;  The array bounds are invalid.
;;
 RPC_NT_INVALID_BOUND             EQU 0C0020023H

;;
;; MessageId: RPC_NT_NO_ENTRY_NAME
;;
;; MessageText:
;;
;;  The binding does not contain an entry name.
;;
 RPC_NT_NO_ENTRY_NAME             EQU 0C0020024H

;;
;; MessageId: RPC_NT_INVALID_NAME_SYNTAX
;;
;; MessageText:
;;
;;  The name syntax is invalid.
;;
 RPC_NT_INVALID_NAME_SYNTAX       EQU 0C0020025H

;;
;; MessageId: RPC_NT_UNSUPPORTED_NAME_SYNTAX
;;
;; MessageText:
;;
;;  The name syntax is not supported.
;;
 RPC_NT_UNSUPPORTED_NAME_SYNTAX   EQU 0C0020026H

;;
;; MessageId: RPC_NT_UUID_NO_ADDRESS
;;
;; MessageText:
;;
;;  No network address is available to use to construct a UUID.
;;
 RPC_NT_UUID_NO_ADDRESS           EQU 0C0020028H

;;
;; MessageId: RPC_NT_DUPLICATE_ENDPOINT
;;
;; MessageText:
;;
;;  The endpoint is a duplicate.
;;
 RPC_NT_DUPLICATE_ENDPOINT        EQU 0C0020029H

;;
;; MessageId: RPC_NT_UNKNOWN_AUTHN_TYPE
;;
;; MessageText:
;;
;;  The authentication type is unknown.
;;
 RPC_NT_UNKNOWN_AUTHN_TYPE        EQU 0C002002AH

;;
;; MessageId: RPC_NT_MAX_CALLS_TOO_SMALL
;;
;; MessageText:
;;
;;  The maximum number of calls is too small.
;;
 RPC_NT_MAX_CALLS_TOO_SMALL       EQU 0C002002BH

;;
;; MessageId: RPC_NT_STRING_TOO_LONG
;;
;; MessageText:
;;
;;  The string is too long.
;;
 RPC_NT_STRING_TOO_LONG           EQU 0C002002CH

;;
;; MessageId: RPC_NT_PROTSEQ_NOT_FOUND
;;
;; MessageText:
;;
;;  The RPC protocol sequence was not found.
;;
 RPC_NT_PROTSEQ_NOT_FOUND         EQU 0C002002DH

;;
;; MessageId: RPC_NT_PROCNUM_OUT_OF_RANGE
;;
;; MessageText:
;;
;;  The procedure number is out of range.
;;
 RPC_NT_PROCNUM_OUT_OF_RANGE      EQU 0C002002EH

;;
;; MessageId: RPC_NT_BINDING_HAS_NO_AUTH
;;
;; MessageText:
;;
;;  The binding does not contain any authentication information.
;;
 RPC_NT_BINDING_HAS_NO_AUTH       EQU 0C002002FH

;;
;; MessageId: RPC_NT_UNKNOWN_AUTHN_SERVICE
;;
;; MessageText:
;;
;;  The authentication service is unknown.
;;
 RPC_NT_UNKNOWN_AUTHN_SERVICE     EQU 0C0020030H

;;
;; MessageId: RPC_NT_UNKNOWN_AUTHN_LEVEL
;;
;; MessageText:
;;
;;  The authentication level is unknown.
;;
 RPC_NT_UNKNOWN_AUTHN_LEVEL       EQU 0C0020031H

;;
;; MessageId: RPC_NT_INVALID_AUTH_IDENTITY
;;
;; MessageText:
;;
;;  The security context is invalid.
;;
 RPC_NT_INVALID_AUTH_IDENTITY     EQU 0C0020032H

;;
;; MessageId: RPC_NT_UNKNOWN_AUTHZ_SERVICE
;;
;; MessageText:
;;
;;  The authorization service is unknown.
;;
 RPC_NT_UNKNOWN_AUTHZ_SERVICE     EQU 0C0020033H

;;
;; MessageId: EPT_NT_INVALID_ENTRY
;;
;; MessageText:
;;
;;  The entry is invalid.
;;
 EPT_NT_INVALID_ENTRY             EQU 0C0020034H

;;
;; MessageId: EPT_NT_CANT_PERFORM_OP
;;
;; MessageText:
;;
;;  The operation cannot be performed.
;;
 EPT_NT_CANT_PERFORM_OP           EQU 0C0020035H

;;
;; MessageId: EPT_NT_NOT_REGISTERED
;;
;; MessageText:
;;
;;  There are no more endpoints available from the endpoint mapper.
;;
 EPT_NT_NOT_REGISTERED            EQU 0C0020036H

;;
;; MessageId: RPC_NT_NOTHING_TO_EXPORT
;;
;; MessageText:
;;
;;  No interfaces have been exported.
;;
 RPC_NT_NOTHING_TO_EXPORT         EQU 0C0020037H

;;
;; MessageId: RPC_NT_INCOMPLETE_NAME
;;
;; MessageText:
;;
;;  The entry name is incomplete.
;;
 RPC_NT_INCOMPLETE_NAME           EQU 0C0020038H

;;
;; MessageId: RPC_NT_INVALID_VERS_OPTION
;;
;; MessageText:
;;
;;  The version option is invalid.
;;
 RPC_NT_INVALID_VERS_OPTION       EQU 0C0020039H

;;
;; MessageId: RPC_NT_NO_MORE_MEMBERS
;;
;; MessageText:
;;
;;  There are no more members.
;;
 RPC_NT_NO_MORE_MEMBERS           EQU 0C002003AH

;;
;; MessageId: RPC_NT_NOT_ALL_OBJS_UNEXPORTED
;;
;; MessageText:
;;
;;  There is nothing to unexport.
;;
 RPC_NT_NOT_ALL_OBJS_UNEXPORTED   EQU 0C002003BH

;;
;; MessageId: RPC_NT_INTERFACE_NOT_FOUND
;;
;; MessageText:
;;
;;  The interface was not found.
;;
 RPC_NT_INTERFACE_NOT_FOUND       EQU 0C002003CH

;;
;; MessageId: RPC_NT_ENTRY_ALREADY_EXISTS
;;
;; MessageText:
;;
;;  The entry already exists.
;;
 RPC_NT_ENTRY_ALREADY_EXISTS      EQU 0C002003DH

;;
;; MessageId: RPC_NT_ENTRY_NOT_FOUND
;;
;; MessageText:
;;
;;  The entry is not found.
;;
 RPC_NT_ENTRY_NOT_FOUND           EQU 0C002003EH

;;
;; MessageId: RPC_NT_NAME_SERVICE_UNAVAILABLE
;;
;; MessageText:
;;
;;  The name service is unavailable.
;;
 RPC_NT_NAME_SERVICE_UNAVAILABLE  EQU 0C002003FH

;;
;; MessageId: RPC_NT_INVALID_NAF_ID
;;
;; MessageText:
;;
;;  The network address family is invalid.
;;
 RPC_NT_INVALID_NAF_ID            EQU 0C0020040H

;;
;; MessageId: RPC_NT_CANNOT_SUPPORT
;;
;; MessageText:
;;
;;  The requested operation is not supported.
;;
 RPC_NT_CANNOT_SUPPORT            EQU 0C0020041H

;;
;; MessageId: RPC_NT_NO_CONTEXT_AVAILABLE
;;
;; MessageText:
;;
;;  No security context is available to allow impersonation.
;;
 RPC_NT_NO_CONTEXT_AVAILABLE      EQU 0C0020042H

;;
;; MessageId: RPC_NT_INTERNAL_ERROR
;;
;; MessageText:
;;
;;  An internal error occurred in RPC.
;;
 RPC_NT_INTERNAL_ERROR            EQU 0C0020043H

;;
;; MessageId: RPC_NT_ZERO_DIVIDE
;;
;; MessageText:
;;
;;  The RPC server attempted an integer divide by zero.
;;
 RPC_NT_ZERO_DIVIDE               EQU 0C0020044H

;;
;; MessageId: RPC_NT_ADDRESS_ERROR
;;
;; MessageText:
;;
;;  An addressing error occurred in the RPC server.
;;
 RPC_NT_ADDRESS_ERROR             EQU 0C0020045H

;;
;; MessageId: RPC_NT_FP_DIV_ZERO
;;
;; MessageText:
;;
;;  A floating point operation at the RPC server caused a divide by zero.
;;
 RPC_NT_FP_DIV_ZERO               EQU 0C0020046H

;;
;; MessageId: RPC_NT_FP_UNDERFLOW
;;
;; MessageText:
;;
;;  A floating point underflow occurred at the RPC server.
;;
 RPC_NT_FP_UNDERFLOW              EQU 0C0020047H

;;
;; MessageId: RPC_NT_FP_OVERFLOW
;;
;; MessageText:
;;
;;  A floating point overflow occurred at the RPC server.
;;
 RPC_NT_FP_OVERFLOW               EQU 0C0020048H

;;
;; MessageId: RPC_NT_NO_MORE_ENTRIES
;;
;; MessageText:
;;
;;  The list of RPC servers available for auto-handle binding has been exhausted.
;;
 RPC_NT_NO_MORE_ENTRIES           EQU 0C0030001H

;;
;; MessageId: RPC_NT_SS_CHAR_TRANS_OPEN_FAIL
;;
;; MessageText:
;;
;;  The file designated by DCERPCCHARTRANS cannot be opened.
;;
 RPC_NT_SS_CHAR_TRANS_OPEN_FAIL   EQU 0C0030002H

;;
;; MessageId: RPC_NT_SS_CHAR_TRANS_SHORT_FILE
;;
;; MessageText:
;;
;;  The file containing the character translation table has fewer than
;;  512 bytes.
;;
 RPC_NT_SS_CHAR_TRANS_SHORT_FILE  EQU 0C0030003H

;;
;; MessageId: RPC_NT_SS_IN_NULL_CONTEXT
;;
;; MessageText:
;;
;;  A null context handle is passed as an [in] parameter.
;;
 RPC_NT_SS_IN_NULL_CONTEXT        EQU 0C0030004H

;;
;; MessageId: RPC_NT_SS_CONTEXT_MISMATCH
;;
;; MessageText:
;;
;;  The context handle does not match any known context handles.
;;
 RPC_NT_SS_CONTEXT_MISMATCH       EQU 0C0030005H

;;
;; MessageId: RPC_NT_SS_CONTEXT_DAMAGED
;;
;; MessageText:
;;
;;  The context handle changed during a call.
;;
 RPC_NT_SS_CONTEXT_DAMAGED        EQU 0C0030006H

;;
;; MessageId: RPC_NT_SS_HANDLES_MISMATCH
;;
;; MessageText:
;;
;;  The binding handles passed to a remote procedure call do not match.
;;
 RPC_NT_SS_HANDLES_MISMATCH       EQU 0C0030007H

;;
;; MessageId: RPC_NT_SS_CANNOT_GET_CALL_HANDLE
;;
;; MessageText:
;;
;;  The stub is unable to get the call handle.
;;
 RPC_NT_SS_CANNOT_GET_CALL_HANDLE EQU 0C0030008H

;;
;; MessageId: RPC_NT_NULL_REF_POINTER
;;
;; MessageText:
;;
;;  A null reference pointer was passed to the stub.
;;
 RPC_NT_NULL_REF_POINTER          EQU 0C0030009H

;;
;; MessageId: RPC_NT_ENUM_VALUE_OUT_OF_RANGE
;;
;; MessageText:
;;
;;  The enumeration value is out of range.
;;
 RPC_NT_ENUM_VALUE_OUT_OF_RANGE   EQU 0C003000AH

;;
;; MessageId: RPC_NT_BYTE_COUNT_TOO_SMALL
;;
;; MessageText:
;;
;;  The byte count is too small.
;;
 RPC_NT_BYTE_COUNT_TOO_SMALL      EQU 0C003000BH

;;
;; MessageId: RPC_NT_BAD_STUB_DATA
;;
;; MessageText:
;;
;;  The stub received bad data.
;;
 RPC_NT_BAD_STUB_DATA             EQU 0C003000CH

;;
;; MessageId: RPC_NT_CALL_IN_PROGRESS
;;
;; MessageText:
;;
;;  A remote procedure call is already in progress for this thread.
;;
 RPC_NT_CALL_IN_PROGRESS          EQU 0C0020049H

;;
;; MessageId: RPC_NT_NO_MORE_BINDINGS
;;
;; MessageText:
;;
;;  There are no more bindings.
;;
 RPC_NT_NO_MORE_BINDINGS          EQU 0C002004AH

;;
;; MessageId: RPC_NT_GROUP_MEMBER_NOT_FOUND
;;
;; MessageText:
;;
;;  The group member was not found.
;;
 RPC_NT_GROUP_MEMBER_NOT_FOUND    EQU 0C002004BH

;;
;; MessageId: EPT_NT_CANT_CREATE
;;
;; MessageText:
;;
;;  The endpoint mapper database entry could not be created.
;;
 EPT_NT_CANT_CREATE               EQU 0C002004CH

;;
;; MessageId: RPC_NT_INVALID_OBJECT
;;
;; MessageText:
;;
;;  The object UUID is the nil UUID.
;;
 RPC_NT_INVALID_OBJECT            EQU 0C002004DH

;;
;; MessageId: RPC_NT_NO_INTERFACES
;;
;; MessageText:
;;
;;  No interfaces have been registered.
;;
 RPC_NT_NO_INTERFACES             EQU 0C002004FH

;;
;; MessageId: RPC_NT_CALL_CANCELLED
;;
;; MessageText:
;;
;;  The remote procedure call was cancelled.
;;
 RPC_NT_CALL_CANCELLED            EQU 0C0020050H

;;
;; MessageId: RPC_NT_BINDING_INCOMPLETE
;;
;; MessageText:
;;
;;  The binding handle does not contain all required information.
;;
 RPC_NT_BINDING_INCOMPLETE        EQU 0C0020051H

;;
;; MessageId: RPC_NT_COMM_FAILURE
;;
;; MessageText:
;;
;;  A communications failure occurred during a remote procedure call.
;;
 RPC_NT_COMM_FAILURE              EQU 0C0020052H

;;
;; MessageId: RPC_NT_UNSUPPORTED_AUTHN_LEVEL
;;
;; MessageText:
;;
;;  The requested authentication level is not supported.
;;
 RPC_NT_UNSUPPORTED_AUTHN_LEVEL   EQU 0C0020053H

;;
;; MessageId: RPC_NT_NO_PRINC_NAME
;;
;; MessageText:
;;
;;  No principal name registered.
;;
 RPC_NT_NO_PRINC_NAME             EQU 0C0020054H

;;
;; MessageId: RPC_NT_NOT_RPC_ERROR
;;
;; MessageText:
;;
;;  The error specified is not a valid Windows NT RPC error code.
;;
 RPC_NT_NOT_RPC_ERROR             EQU 0C0020055H

;;
;; MessageId: RPC_NT_UUID_LOCAL_ONLY
;;
;; MessageText:
;;
;;  A UUID that is valid only on this computer has been allocated.
;;
 RPC_NT_UUID_LOCAL_ONLY           EQU 040020056H

;;
;; MessageId: RPC_NT_SEC_PKG_ERROR
;;
;; MessageText:
;;
;;  A security package specific error occurred.
;;
 RPC_NT_SEC_PKG_ERROR             EQU 0C0020057H

;;
;; MessageId: RPC_NT_NOT_CANCELLED
;;
;; MessageText:
;;
;;  Thread is not cancelled.
;;
 RPC_NT_NOT_CANCELLED             EQU 0C0020058H

;;
;; MessageId: RPC_NT_INVALID_ES_ACTION
;;
;; MessageText:
;;
;;  Invalid operation on the encoding/decoding handle.
;;
 RPC_NT_INVALID_ES_ACTION         EQU 0C0030059H

;;
;; MessageId: RPC_NT_WRONG_ES_VERSION
;;
;; MessageText:
;;
;;  Incompatible version of the serializing package.
;;
 RPC_NT_WRONG_ES_VERSION          EQU 0C003005AH

;;
;; MessageId: RPC_NT_WRONG_STUB_VERSION
;;
;; MessageText:
;;
;;  Incompatible version of the RPC stub.
;;
 RPC_NT_WRONG_STUB_VERSION        EQU 0C003005BH

;;
;; MessageId: RPC_NT_INVALID_PIPE_OBJECT
;;
;; MessageText:
;;
;;  The RPC pipe object is invalid or corrupted.
;;
 RPC_NT_INVALID_PIPE_OBJECT       EQU 0C003005CH

;;
;; MessageId: RPC_NT_INVALID_PIPE_OPERATION
;;
;; MessageText:
;;
;;  An invalid operation was attempted on an RPC pipe object.
;;
 RPC_NT_INVALID_PIPE_OPERATION    EQU 0C003005DH

;;
;; MessageId: RPC_NT_WRONG_PIPE_VERSION
;;
;; MessageText:
;;
;;  Unsupported RPC pipe version.
;;
 RPC_NT_WRONG_PIPE_VERSION        EQU 0C003005EH

;;
;; MessageId: RPC_NT_PIPE_CLOSED
;;
;; MessageText:
;;
;;  The RPC pipe object has already been closed.
;;
 RPC_NT_PIPE_CLOSED               EQU 0C003005FH

;;
;; MessageId: RPC_NT_PIPE_DISCIPLINE_ERROR
;;
;; MessageText:
;;
;;  The RPC call completed before all pipes were processed.
;;
 RPC_NT_PIPE_DISCIPLINE_ERROR     EQU 0C0030060H

;;
;; MessageId: RPC_NT_PIPE_EMPTY
;;
;; MessageText:
;;
;;  No more data is available from the RPC pipe.
;;
 RPC_NT_PIPE_EMPTY                EQU 0C0030061H

;;
;; MessageId: RPC_NT_INVALID_ASYNC_HANDLE
;;
;; MessageText:
;;
;;  Invalid asynchronous remote procedure call handle.
;;
 RPC_NT_INVALID_ASYNC_HANDLE      EQU 0C0020062H

;;
;; MessageId: RPC_NT_INVALID_ASYNC_CALL
;;
;; MessageText:
;;
;;  Invalid asynchronous RPC call handle for this operation.
;;
 RPC_NT_INVALID_ASYNC_CALL        EQU 0C0020063H

;;
;; MessageId: RPC_NT_SEND_INCOMPLETE
;;
;; MessageText:
;;
;;  Some data remains to be sent in the request buffer.
;;
 RPC_NT_SEND_INCOMPLETE           EQU 0400200AFH

;; added from winnt.h
STATUS_FLOAT_MULTIPLE_FAULTS     EQU 0C00002B4H
STATUS_FLOAT_MULTIPLE_TRAPS      EQU 0C00002B5H
STATUS_ILLEGAL_VLM_REFERENCE     EQU 0C00002C0H
