;all functions assume local machine

;------------------------------------
;returns TRUE/FALSE in EAX
RemoveService PROC USES EBX ESI EDI, szServiceName
   SUB      EBX, EBX
   iWin32i  OpenSCManager, NULL, 0, SC_MANAGER_CONNECT OR SC_MANAGER_ENUMERATE_SERVICE OR SC_MANAGER_QUERY_LOCK_STATUS
   TEST     EAX, EAX
   JE       ErrorOpenSCManager
   MOV      ESI, EAX
   iWin32i  OpenService, ESI, szServiceName, SERVICE_STOP OR DELETE
   TEST     EAX, EAX
   JE       ErrorOpenService
   MOV      EDI, EAX
   SUB      ESP, SIZEOF SERVICE_STATUS
   iWin32   ControlService, EDI, SERVICE_CONTROL_STOP, ESP
   ADD      ESP, SIZEOF SERVICE_STATUS
   iWin32   DeleteService, EDI
   MOV      EBX, EAX
   iWin32   CloseServiceHandle, EDI
  ErrorOpenService:
   iWin32   CloseServiceHandle, ESI
  ErrorOpenSCManager:
   MOV      EAX, EBX
   RET
RemoveService ENDP

;------------------------------------
;creating service reguires administrator group in token

;returns ZF set if succeeded
;returns handle in EAX
;bool in EDX if service was installed by this function

MAX_SRVCREATE_LOOPS = 70
SRVCREATE_MS = 127

GetDeviceHandle PROC USES EBX ESI EDI, szDeviceName, szServiceName, szDriverPathName
   LOCAL    lDeviceName[MAX_PATH] : SIGN
   LOCAL    gDeviceName[MAX_PATH] : SIGN
   LEA      ESI, lDeviceName
   LEA      EDI, gDeviceName
   MOV      EBX, szDeviceName
   AND      SIGN PTR [ESI], 0
   AND      SIGN PTR [EDI], 0
   CMP      SIGN PTR [EBX], '\'
   JE       CopyDeviceName
 IF UNICODE
   MOV      EAX, 005C005CH
   MOV      [ESI], EAX
   MOV      [EDI], EAX
   MOV      EAX, 005C002EH
   MOV      [ESI+4], EAX
   MOV      [EDI+4], EAX
   MOV      EAX, 006C0047H
   MOV      [EDI+8], EAX
   MOV      EAX, 0062006FH
   MOV      [EDI+12], EAX
   MOV      EAX, 006C0061H
   MOV      [EDI+16], EAX
   oMOV     EAX, 5CH
   MOV      [EDI+20], EAX
   ADD      ESI, 8
   ADD      EDI, 22
 ELSE  
   MOV      EAX, '\.\\'
   MOV      [ESI], EAX
   MOV      [EDI], EAX
   MOV      EAX, 'bolG'
   MOV      [EDI+4], EAX
   MOV      EAX, '\la'
   MOV      [EDI+8], EAX
   ADD      ESI, 4
   ADD      EDI, 11
 ENDIF
 CopyDeviceName:
   iWin32i  lstrcpy, ESI, EBX    
   iWin32i  lstrcpy, EDI, EBX
   sWin32   CheckDevice
   PUSH     FALSE
   JNE      DeviceExists

   ;machine was rebooted probably -> remove registry entries
   MOV      EBX, szServiceName
   sWin32   RemoveService, EBX

   iWin32i  OpenSCManager, NULL, 0, SC_MANAGER_ALL_ACCESS
   TEST     EAX, EAX
   JE       ErrorOpenSCManager
   MOV      ESI, EAX
   oMOV     EDI, MAX_SRVCREATE_LOOPS 

  SrvCreateLoop:
   SUB      ECX, ECX
   iWin32i  CreateService, ESI, EBX, EBX,\
                           SERVICE_ALL_ACCESS,  SERVICE_KERNEL_DRIVER,\
                           SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,\
                           szDriverPathName, ECX, ECX, ECX, ECX, ECX
   TEST     EAX, EAX
   JNE      SrvCreated
   ;my idea
   iWin32   GetLastError
   CMP      EAX, ERROR_SERVICE_MARKED_FOR_DELETE
   JNE      ErrorCreateService
   iWin32   WaitForSingleObject, CurrentThread, SRVCREATE_MS
   DEC      EDI
   JG       SrvCreateLoop
   JMP      ErrorCreateService
      
 SrvCreated:
   MOV      EDI, EAX
   iWin32i  StartService, EDI, 0, NULL
   TEST     EAX, EAX 
   JE       ErrorStartService
   INC      DWORD PTR [ESP]
   JMP      ServiceStarted
  ErrorStartService:
   iWin32   DeleteService, EDI
  ServiceStarted:
   iWin32   CloseServiceHandle, EDI
  ErrorCreateService:
   iWin32   CloseServiceHandle, ESI
  ErrorOpenSCManager:
   sWin32   CheckDevice
  DeviceExists:
   POP      EDX
   RET

  CheckDevice:
   LEA      EAX, gDeviceName
   sWin32   CheckFile
   JNE      CheckDeviceReturn
   LEA      EAX, lDeviceName
   sWin32   CheckFile
  CheckDeviceReturn:
   RETN

  CheckFile:
   iWin32i  CreateFile, EAX, GENERIC_READ OR GENERIC_WRITE, 0, 0, OPEN_EXISTING, 0, 0
   CMP      EAX, INVALID_HANDLE_VALUE
   RETN
GetDeviceHandle ENDP
