;@GOTO -)
.586P
.MODEL FLAT
UNICODE=1
INCLUDE WINDOWS.INC
INCLUDE ..\COMMON\APIMACRO.MAC
INCLUDE ..\COMMON\NtStruc.INC
INCLUDE ..\COMMON\NTDDK.INC
INCLUDE ..\COMMON\NTSTATUS.INC
INCLUDELIB iNTOSKRNL.lib
INCLUDELIB iHAL.lib

INCLUDE ..\COMMON\DumpXDT2.INC

;===============================================================================
.CODE INIT
  DriverEntry   PROC USES EBX ESI EDI, DriverObject, RegPath 
     SUB        EAX, EAX
     oLEA	EDI, DeviceNameUnicode
     MOV	ESI, DriverObject
     ASSUME     ESI: PDRIVER_OBJECT
     ExtensionSize      EQU EAX
     DevType	        EQU FILE_DEVICE_UNKNOWN
     DevCharacteristic  EQU EAX
     Exclusive	        EQU EAX
     PUSH       EAX
     iWin32     IoCreateDevice, ESI, ExtensionSize, EDI, DevType,\
	                        DevCharacteristic, Exclusive, ESP
     TEST       EAX,  EAX
     POP        EBX
     JL         CreateDeviceFailed

     ;OR         (DEVICE_OBJECT PTR [EBX]).FLAGS, DO_BUFFERED_IO
   
     oLEA       EAX,  StandardDispatch
     MOV        [ESI].PDRIVER_UNLOAD,                  OFFSET Unload 
     MOV        [ESI].PDISPATCH_IRP_MJ_CREATE,         EAX  
     MOV        [ESI].PDISPATCH_IRP_MJ_CLOSE,          EAX  
     MOV        [ESI].PDISPATCH_IRP_MJ_DEVICE_CONTROL, OFFSET Dispatch 

     iWin32     IoCreateSymbolicLink, OFFSET SymLinkNameUnicode, EDI
     TEST       EAX,  EAX
     JGE        SymLinkCreated

     PUSH       EAX 
     iWin32     IoDeleteDevice, EBX
     POP        EAX
     JMP        CreateDeviceFailed

    SymLinkCreated:
     iMOV       EDX, KeNumberProcessors
     MOVZX      ECX, BYTE PTR [EDX]
     DEC        ECX 
     MOV        MaxCPUNo, ECX
     SUB        EAX, EAX  ;STATUS_SUCCESS
    CreateDeviceFailed:
     RET        ;from now, INIT, reloc and other discardable sections do not exist
  DriverEntry   ENDP
;===============================================================================
.CODE
  DIOCServices  DWORD GetDrvVersion, GetCPUxxGDT, GetCPUxxIDT
  MinService    EQU  0
  MaxService    EQU  2
  DeviceNameUnicode  UNICODE_STRING <LDeviceName*2,    LDeviceName*2,    sDeviceName>
  SymLinkNameUnicode UNICODE_STRING <LDosDeviceName*2, LDosDeviceName*2, sDosDeviceName>
  TEXTW            DeviceName, <\Device\DumpXDT2>
  TEXTW         DosDeviceName, <\DosDevices\DumpXDT2>
  MaxCPUNo      DWORD 0
;===============================================================================
  Unload        PROC  DriverObject
     iWin32     IoDeleteSymbolicLink, OFFSET SymLinkNameUnicode
     MOV	EAX,  DriverObject
     iWin32     IoDeleteDevice , (DRIVER_OBJECT PTR [EAX])._PDEVICE_OBJECT
     RET     
  Unload	ENDP
;===============================================================================
  Dispatch      PROC  USES EBX ESI EDI  DeviceObject, pIRP
     MOV	ECX,  pIRP
     ASSUME     ECX:  PIRP
     MOV	EDI,  [ECX].PCurrentIrpStackLocation
     MOV	ESI,  [ECX].SystemBuffer 
     ASSUME     EDI:  PIO_STACK_LOCATION
     MOV        EAX,  [EDI].DeviceIoControl.IoControlCode
     PUSH       ECX   ; save IRP
 
     XOR	EAX,  DumpXDT2Mask
     CMP        EAX,  MaxService SHL 2
     JA         ItsBad

     TEST       AL,   11B
     JE         fDIOCServices ; non-buffered and semi-buffered methods not supported
                              ; because wr are lazy and do not want to probe & lock user buffers
    ItsBad:
     MOV        EAX,  STATUS_INVALID_DEVICE_REQUEST ;STATUS_NOT_IMPLEMENTED ;STATUS_INVALID_PARAMETER; STATUS_INVALID_USER_BUFFER
     SUB        EDX,  EDX
     JMP        QuitDispatch

    fDIOCServices:
     CALL       DIOCServices[EAX]
    QuitDispatch:
     POP        ECX  ; restore IRP
     PUSH       EAX  ; save status
     MOV        [ECX].IoStatus.Information, EDX
     MOV        [ECX].IoStatus.Status, EAX 
     SUB        EDX, EDX
     iWin32     IofCompleteRequest ; Elis and VC call fast, others call std (IoCompleteRequest)
     POP        EAX  ; return status
     RET
  Dispatch      ENDP
;===============================================================================
  StandardDispatch  PROC DeviceObject, pIRP
     MOV        ECX, pIRP
     SUB        EDX, EDX
     PUSH       EDX  ;STATUS_SUCCESSFUL
     MOV        [ECX].IoStatus.Information, EDX
     MOV        [ECX].IoStatus.Status, EDX 
     iWin32     IofCompleteRequest
     POP        EAX 
     RET     
  StandardDispatch  ENDP
;===============================================================================
     ASSUME     ESI: PTR _XDT
     ASSUME     FS: NOTHING

  GetDrvVersion PROC
     MOV        [ESI].Status, 100H
     oMOV       EDX, SIZEOF _XDT.Status
     SUB        EAX, EAX  ;STATUS_SUCCESS
     RET
  GetDrvVersion ENDP
;--------------------------
     TEXTA      zGDTmis, <GDT mismatch for CPU /#02u: SGDT=0x/#08X vs. KPCR=0x/#08X/n/0>
     TEXTA      zIDTmis, <IDT mismatch for CPU /#02u: SIDT=0x/#08X vs. KPCR=0x/#08X/n/0>

  GetCPUxxXDT   PROC  GetIDT
     LOCAL      AfMask :DWORD
     MOV        EAX, [ESI].CPUNo
     MOV        ECX, MaxCPUNo
     CMP        ECX, EAX
     JB         InvalidCPU
     PUSH       EAX
     iWin32     KeGetCurrentThread
     POP        ECX
     oMOV       EDX, 1
     MOV        EBX, EAX
     SHL        EDX, CL
     PUSH       EDX
     ;PsLockProcess
     SUB        ESP, SIZEOF PROCESS_BASIC_INFORMATION
     MOV        EAX, ESP
     iWin32     ZwQueryInformationProcess, NtCurrentProcess, ProcessBasicInformation, EAX, SIZEOF PROCESS_BASIC_INFORMATION, NULL
     MOV        ECX, (PROCESS_BASIC_INFORMATION PTR [ESP]).AffinityMask
     ADD        ESP, SIZEOF PROCESS_BASIC_INFORMATION
     POP        EDX 
     TEST       EAX, EAX
     JL         InvalidCPU
     TEST       EDX, ECX
     JE         InvalidCPU
     MOV        AfMask, ECX  
     iWin32     KeSetAffinityThread, EBX, EDX
     SUB        EDX, EDX
     PUSH       EDX
     PUSH       DX
     CMP        GetIDT, FALSE
     JE         fGetGDT

     SIDT       [ESP]
     MOV        ECX, FS:38H  ;KPCR.IDT
     JMP        @F
   fGetGDT:
     SGDT       [ESP]
     MOV        ECX, FS:3CH  ;KPCR.GDT
   @@:
     POP        DX
     POP        EAX
     PUSHp      ECX, EDX, EAX
     iWin32     KeSetAffinityThread, EBX, AfMask
     POPc       ECX, EDX, EAX
     ;PsUnLockProcess
     CMP        ECX, EAX
     JE         BaseOK
   PrintMismatch:
     PUSHp      EDX, EAX
     MOV        EDX, szGDTmis
     CMP        GetIDT, FALSE
     JE         gGetGDT
     MOV        EDX, szIDTmis
   gGetGDT:
     icWin32    DbgPrint, EDX, [ESI].CPUNo, EAX, ECX
     POPc       EDX, EAX
   BaseOK:
     MOV        [ESI].XDTBase, EAX
     MOV        [ESI].XDTSize, EDX
     INC        EDX
     AND         DL, NOT 111B
     LEA        ECX, [EDX+SIZEOF _XDT]
     CMP        [EDI].DeviceIoControl.OutputBufferLength, ECX
     JB         SmallBuffer
     PUSH       ECX
    
     LEA        EDX, [EAX+EDX]
     ADD        ESI, SIZEOF _XDT ;xdt is copied here
    @@:
     MOV        ECX, [EAX]
     MOV        DWORD PTR [ESI], ECX
     ADD        EAX, SIZEOF DWORD
     ADD        ESI, SIZEOF DWORD
     CMP        EAX, EDX
     JB         @B
     SUB        EAX, EAX  ;STATUS_SUCCESS
     POP        EDX
     MOV        [ESI].Status, EAX
     RET
    InvalidCPU:
     ;PsUnLockProcess
     oMOV       EDX, SIZEOF _XDT
     MOV        [ESI].Status, DumpXDT2InvalidCPUNo
     oMOV       [ESI].CPUNo, MaxCPUNo
     SUB        EAX, EAX  ;STATUS_SUCCESS
     RET
    SmallBuffer: 
     oMOV       EDX, SIZEOF _XDT
     MOV        [ESI].Status, DumpXDT2SmallBuffer
     SUB        EAX, EAX  ;STATUS_SUCCESS
     RET
  GetCPUxxXDT   ENDP

;--------------------------
  GetCPUxxGDT   PROC
     sWin32     GetCPUxxXDT, FALSE
      RET
  GetCPUxxGDT   ENDP

;--------------------------
  GetCPUxxIDT   PROC
     sWin32     GetCPUxxXDT, TRUE
     RET
  GetCPUxxIDT   ENDP
     ASSUME ESI : NOTHING
;===============================================================================  
END DriverEntry
:-)
@ECHO  OFF
CALL MAKEiLIB.bat
ML /c /Cp /Gz /nologo /coff DumpXDT2.bat
eLINK DumpXDT2.obj /nologo /MERGE:.rdata=.text /OPTidata /DRIVER /align:0x20 /out:DumpXDT2.sys /base:0x10000 /subsystem:native /IGNORE:4078
DEL DumpXDT2.obj
DEL iNTOSKRNL.lib
DEL iHAL.lib
PAUSE
CLS