;@GOTO -)
.586P
.MODEL FLAT
INCLUDE WINDOWS.inc
UNICODE=1
INCLUDE ..\COMMON\APIMACRO.mac
INCLUDE ..\COMMON\NTSTATUS.inc
INCLUDE ..\COMMON\NtStruc.inc
INCLUDE ..\COMMON\DumpXDT2.inc
INCLUDELIB iKERNEL32
INCLUDELIB iUSER32
INCLUDELIB iADVAPI32

;------------------------------------------------------------------------------

.DATA?
   DriverPathName SIGN MAX_PATH DUP (?)
   Place CHAR 128 DUP (?)
   ReturnEIP DWORD ?

.CODE
   DescriptorTypes  DWORD _Reserved, TSS16I, LDT,       TSS16A, CallG16, TaskG,     IntG16, TrapG16,\
                          _Reserved, TSS32I, _Reserved, TSS32A, CallG32, _Reserved, IntG32, TrapG32,\
                          Data16,    Code16, Data32,    Code32
   TEXT      zDumpXDT2ServiceName, <DumpXDT2/0>
   TEXT      zDumpXDT2DeviceName,  <DumpXDT2/0>
;------------------------------------------------------------------------------
;must be included in code segment:
INCLUDE PrintXDT.asm
INCLUDE ..\COMMON\ServiceDD.inc
INCLUDE ..\COMMON\GetCLArgs.inc
;------------------------------------------------------------------------------
 PrimaryThread    PROC
   CLD
   iWin32i   GetCommandLine
   MOV       ESI, EAX
   oLEA      EDI, DriverPathName
   sWin32i   GetParAndNextParPos
   TEST      EAX, EAX
   JE        InvCmdLine
   sWin32i   GetParAndNextParPos
   TEST      EAX, EAX
   JE        InvCmdLine
   SUB       EAX, EAX
   SUB       EBP, EBP
   MOV       ESI, EDI
   oMOV      ECX, 5
  @@:
IF UNICODE
   LODSW
   TEST      AX,  AX
   JE        CPUNoDone
   SUB       AX,  '0'
   JB        InvCmdLine 
   CMP       AX,  '9'
ELSE
   LODSB
   TEST      AL,  AL
   JE        CPUNoDone
   SUB       AL,  '0'
   JB        InvCmdLine 
   CMP       AL,  '9'
ENDIF
   JA        InvCmdLine 
   IMUL      EBP, 10
   ADD       EBP, EAX
   LOOP      @B  
   JMP       InvCmdLine

  CPUNoDone:

   iWin32i   GetModuleFileName, NULL, EDI, MAX_PATH
   oMOV      ECX, 's'
   MOV       SIGN PTR [EDI+EAX*SIGN_-2*SIGN_], 'y'
 IF UNICODE 
   MOV       [EDI+EAX*SIGN_-3*SIGN_], CX
   MOV       [EDI+EAX*SIGN_-1*SIGN_], CX
 ELSE
   MOV       [EDI+EAX*SIGN_-3*SIGN_], CL
   MOV       [EDI+EAX*SIGN_-1*SIGN_], CL
 ENDIF

   sWin32    GetDeviceHandle, szDumpXDT2DeviceName, szDumpXDT2ServiceName, EDI
   PUSH      EDX  ;was serivce installed by this app?
   JE        NoDevice
   MOV       EDI, EAX
   
   PUSH      0    ;lpbytesreturned
   MOV       ESI, ESP
   SUB       ESP, SIZEOF _XDT
   MOV       EBX, ESP 
   ASSUME    EBX :PTR _XDT
   MOV       [EBX].CPUNo, EBP

   iWin32    DeviceIoControl, EDI, DumpXDT2GetVersion, EBX, SIZEOF _XDT, EBX, SIZEOF _XDT, ESI, NULL
   TEST      EAX, EAX
   JE        IOFailed
   CMP       [EBX].Status, 100H
   JNE       VerMismatch

   SUB       ESP, SIZEOF SYSTEM_INFO
   iWin32    GetSystemInfo, ESP
   MOV       EAX, (SYSTEM_INFO PTR [ESP]).dwActiveProcessorMask
   ADD       ESP, SIZEOF SYSTEM_INFO
   iWin32    SetProcessAffinityMask, NtCurrentProcess, EAX

;--get GDT
   iWin32    DeviceIoControl, EDI, DumpXDT2GetGDT, EBX, SIZEOF _XDT, EBX, SIZEOF _XDT, ESI, NULL
   TEST      EAX, EAX
   JE        IOFailed0
   MOV       EAX, [EBX].Status
   CMP       EAX, DumpXDT2InvalidCPUNo
   JE        WrongCPUNo
   CMP       EAX, DumpXDT2SmallBuffer
   JNE       GDTOk

   MOV       EAX, [EBX].XDTSize
   INC       EAX
   AND         AL, NOT 111B
   ADD       EAX, SIZEOF _XDT
   PUSH      EAX
   iWin32    LocalAlloc, LPTR, EAX
   TEST      EAX, EAX
   POP       ECX
   JE        NoMemory
   MOV       EDX, [EBX].CPUNo
   MOV       EBX, EAX
   MOV       [EBX].CPUNo, EDX
  GDTOk:
   iWin32    DeviceIoControl, EDI, DumpXDT2GetGDT, EBX, ECX, EBX, ECX, ESI, NULL
   TEST      EAX, EAX
   JE        IOFailed0
   CMP       [EBX].Status, STATUS_SUCCESS
   JNE       IOFailed0

   PUSHp     EBX, ESI, EDI
   MOV       EDI, [EBX].XDTSize
   LEA       ESI, [EBX+SIZEOF _XDT]
   cWin32    printf, szGDT, [EBX].XDTBase, EDI
   sWin32    PrintXDT
   POPc      EBX, ESI, EDI

  IOFailed0:
   CMP       EBX, ESP
   JE        @F
   iWin32    LocalFree, EBX
   MOV       EBX, ESP
  @@:
   
;--get IDT
   iWin32    DeviceIoControl, EDI, DumpXDT2GetIDT, EBX, SIZEOF _XDT, EBX, SIZEOF _XDT, ESI, NULL
   TEST      EAX, EAX
   JE        IOFailed1
   MOV       EAX, [EBX].Status
   CMP       EAX, DumpXDT2InvalidCPUNo
   JE        WrongCPUNo
   CMP       EAX, DumpXDT2SmallBuffer
   JNE       IDTOk

   MOV       EAX, [EBX].XDTSize
   INC       EAX
   AND         AL, NOT 111B
   ADD       EAX, SIZEOF _XDT
   PUSH      EAX
   iWin32    LocalAlloc, LPTR, EAX
   TEST      EAX, EAX
   POP       ECX
   JE        NoMemory
   MOV       EDX, [EBX].CPUNo
   MOV       EBX, EAX
   MOV       [EBX].CPUNo, EDX
  IDTOk:
   iWin32    DeviceIoControl, EDI, DumpXDT2GetIDT, EBX, ECX, EBX, ECX, ESI, NULL
   TEST      EAX, EAX
   JE        IOFailed1
   CMP       [EBX].Status, STATUS_SUCCESS
   JNE       IOFailed1

   PUSHp     EBX, ESI, EDI
   MOV       EDI, [EBX].XDTSize
   MOV       Patch03, 3
   LEA       ESI, [EBX+SIZEOF _XDT]
   cWin32    printf, szIDT, [EBX].XDTBase, EDI
   sWin32    PrintXDT
   POPc      EBX, ESI, EDI

  IOFailed1:
   CMP       EBX, ESP
   JE        @F
   iWin32    LocalFree, EBX
  @@:
   JMP       Cleanup

  IOFailed:
   cWin32    printf, szIOFailed
   JMP       Cleanup
  VerMismatch:
   cWin32    printf, szVerMismatch
   JMP       Cleanup
  WrongCPUNo:
   cWin32    printf, szWrongCPUNo, EBP, [EBX].CPUNo
   JMP       Cleanup
  NoMemory:
   cWin32    printf, szNoMemory

  Cleanup:
   ADD       ESP, SIZEOF _XDT
   POP       ECX  ;lpbytesreturned
   iWin32    CloseHandle, EDI
  CheckServ:
   POP       ECX  ;was service installed by this app?
   JECXZ     Exitus ;no
   sWin32    RemoveService, szDumpXDT2ServiceName
   JMP       Exitus

  NoDevice:
   cWin32    printf, szNoDevice
   JMP       CheckServ
  InvCmdLine:
   cWin32    printf, szInvCmdLine
  Exitus:
   iWin32    _lread, STD_INPUT_HANDLE, ESP, 4
   iWin32    ExitProcess, EAX

  TEXTA      zIOFailed, <IO failed!/0>
  TEXTA      zVerMismatch, <Wrong device version!/0>
  TEXTA      zWrongCPUNo,  <Wrong CPU#: /#d, maximum /#d !/0>
  TEXTA      zNoMemory,    <Heap exhausted!/0>
  TEXTA      zNoDevice,    <Can not install service, load driver or create//open device!/0>
  TEXTA      zInvCmdLine,  <Usage: DumpXDT /(CPU#/)/0>
 PrimaryThread ENDP
;-------------------------------------------------------------------------------
END PrimaryThread
:-)
@ECHO OFF
CALL MAKEiLIB.bat
ML /c /coff /Cp /Gz /nologo DumpXDT2.bat
eLINK DumpXDT2 /IGNORE:4108,4078,4060 /nologo /SUBSYSTEM:CONSOLE /OPTidata /MERGE:.rdata=.text /MERGE:PrcWorks=.text /SECTION:.text,EWR
DEL DumpXDT2.obj
DEL iKERNEL32.lib
DEL iADVAPI32.lib
PAUSE
CLS