;@GOTO TRANSLATE

;see DemoVDD.bat



;calling VDD from DPMI subsystem


.MODEL TINY, PASCAL
.586P

   RegisterModule   EQU DD 0058C4C4H      
   UnRegisterModule EQU DD 0158C4C4H      
   DispatchCall     EQU DD 0258C4C4H      
   VDDUnSimulate16  EQU DB 0C4H,0C4H,0FEH 

.CODE
.STARTUP

   ;CS=DS=ES

   LEA   DX,   Intro
   MOV   AH,   9
   INT   21H

   MOV   AX,   3306H
   INT   21H                              

   CMP   BX,   3205H                      
   LEA   DX,   MustUnderNT
   JNE   Write


   LEA   SI,   VDDDLL                     ;DS:SI = NameZ of VDD
   LEA   DI,   VDDregister                ;ES:DI = NameZ of register routine 
                                          ;        can be 0:0 
   LEA   BX,   VDDdispatch                ;DS:BX = NameZ of Dispatch routine 
   RegisterModule                         ;returns NC , AX=handle if succeeded
   LEA   DX,   RegisterFailed
   JC    Write                            ;returns CY , AX=error code if failed


   MOV   hDLL, AX
   MOV   CX,   BufferSize                  ;my private parameter
   LEA   DX,   Buffer                      ;my private parameter
   MOV   SI,   DX
FnGetVersion          EQU 0 SHL 2
FnGetSDT              EQU 1 SHL 2

   MOV   BX,   FnGetSDT
   DispatchCall                            ;required parameter: AX=handle 
   LEA   DX,   DispatchFailed
   JC    Close&Write

   OR    EAX,  EAX                         ;returns in AX number of written
   LEA   DX,   BufferIsEmpty               ;bytes  (private)
   JE    Close&Write


   PUSH  SIZE BufferForGetSDT
   POP   ECX
   CDQ
   DIV   ECX
   LEA   DX, NTCALL
   XCHG  AX, CX
   SUB   BX, BX
 There:
   CALL  DWordToStringHex, EBX, 2, OFFSET NN 
   LODSD
   CALL  DWordToStringHex, EAX, 8, OFFSET Entry 
   LODSB
   SHR   AL, 2
   CALL  DWordToStringHex, EAX, 2, OFFSET NArgm
   MOV   AH,9
   INT   21H
   INC   BX
   LOOP  There
   LEA   DX, NoWrite

  Close&Write:
   MOV   AX,   hDLL
   UnRegisterModule                        ;required parameter: AX=handle 

  Write:
   MOV   AH, 9
   INT   21H
  Written:
  .EXIT


DWordToStringHex PROC PASCAL Value:DWORD,FNum,StrPtr:near ptr
     USES DI,AX,CX,eDX,BX

     pushf
     std
     mov di,StrPtr
     mov edx,Value
     mov cx,FNum
     add di,cx
     dec di

  @@Cykl:
     dec cx
     js @@Konec
     mov al,dl
     and al,0Fh
     add al,'0'
     cmp al,'9'
     jbe @@Next
     add al,7
    @@Next:
     stosb
     shr edx,4
     jmp @@Cykl
  @@Konec:
       popf
       RET
DWordToStringHex   ENDP



   Intro          DB       "NTCALL by EliCZ displays entry addresses and number of parameters according to"
                  DB 13,10,"the 1st service descriptor",13,10,36
   NTCALL         DB       "NTCALL "
       NN         DB "00 : entry "
       Entry      DB "00000000, parameters "
       NArgm      DB "00",13,10
       NoWrite    DB 36

   MustUnderNT    DB 13,10,"NTCALL must run under Windows NT!",7,36
   RegisterFailed DB 13,10,"RegisterModule failed!",7
                  DB 13,10,"Causes: NTCALL is ALREADY started. "
                  DB       "NTCALL.dll or NTCALL.sys aren't accessible.",7,36
   DispatchFailed DB 13,10,"DispatchCall failed!",7,36
   BufferIsEmpty  DB 13,10,"Buffer is empty!",7,36

   Success        DB 13,10,"NTdump version "
   MajorVersion   DB "0."
   MinorVersion   DW "00"
                  DB " is present.",36

   VDDDLL         DB "NTCALL.dll",0
   VDDregister    DB "NTcallVDDRegister",0
   VDDdispatch    DB "NTcallVDDDispatch",0
   hDLL           DW ?

.DATA

   MAX_SERVICES          EQU 100H

   BufferForGetSDT       STRUCT
     ServiceEntry        DWORD  ?
     ArgCount            BYTE   ?
   BufferForGetSDT       ENDS


   Buffer         DB (SIZE BufferForGetSDT*MAX_SERVICES) DUP (?) 
   BufferSize     EQU $-Buffer

END

:TRANSLATE
@ECHO OFF
TASM32  /M /Q /T %0, NTcom
TLINK /3/x/t NTcom, NTcall
DEL   NTcom.obj