;@GOTO TRANSLATE


;===============================================================================

.586P
.MODEL FLAT, STDCALL

 OPTION      CASEMAP:NONE
 UNICODE     = 0  ;because of WriteFile
 ARGUMENTS   = 0  ;koliduje s hWnd a hDlg a..hInstance
 INCLUDE     W32MAIN.INC

 INCLUDELIB  KERNEL32.LIB
 INCLUDELIB  USER32.LIB
 INCLUDELIB  ADVAPI32.LIB

 INCLUDE     KERNEL32.INC
 INCLUDE     USER32.INC
 
 wsprintfA   PROTO C :DWORD, :VARARG
 wsprintf    EQU <wsprintfA>

 INCLUDE     ADVAPI32.INC

 INCLUDE     NTcall.INC

.586P

 CallDriver  PROTO :DWORD

;===============================================================================
.DATA

   STRLEN        MACRO @String
                 L&@String = ($-@String) / CHAR_
                 ENDM

   Information   LABEL  CHAR
                 STRING <NTCALL by EliCZ displays entry addresses and number of parameters according to/n>
                 STRING <the 1st service descriptor/n>
                 STRLEN Information
   ErOpenSCM     LABEL  CHAR
                 STRING <Can/-t open Service Manager/:/n> 
                 STRLEN ErOpenSCM
   ErStartSrv    LABEL  CHAR 
                 STRING <Can/-t start service/:/n> 
                 STRLEN ErStartSrv
   ErRemoveSrv   LABEL  CHAR
                 STRING <Can/-t remove service/:/n> 
                 STRLEN ErRemoveSrv
   ErOpenDev     LABEL  CHAR
                 STRING <Can/-t open device/:/n> 
                 STRLEN ErOpenDev
   ErDriverFail  LABEL  CHAR
                 STRING <Driver failed/:/n> 
                 STRLEN ErDriverFail
   ErIncorVer    LABEL  CHAR
                 STRING <Incorrect .sys version/:/n> 
                 STRLEN ErIncorVer

   StrTemplate   LABEL CHAR
                 STRING <NTCALL /#0.2lX : entry /#0.8lX, parameters /#0.2lX/n/0> 
                 STRLEN StrTemplate

   DosDeviceName LABEL  CHAR
                 STRING <\\.\>
   DriverName    LABEL  CHAR
                 STRING <NTCALL/0> 
   _ServiceExe   LABEL  CHAR
                 STRING <\NTCALL.sys/0> 


   SC_MANAGER_ALL_ACCESS  EQU STANDARD_RIGHTS_REQUIRED OR 03FH 
   SERVICE_ALL_ACCESS     EQU STANDARD_RIGHTS_REQUIRED OR 1FFH
   SERVICE_KERNEL_DRIVER  EQU 001H
   SERVICE_DEMAND_START   EQU 003H
   SERVICE_ERROR_NORMAL   EQU 001H
   SERVICE_CONTROL_STOP   EQU 001H


  SetText        MACRO  Message
   PUSH          L&Message
   MOV           EAX, OFFSET Message
   POP           ECX
   JMP           Write
                 ENDM

   WhereToJMP    DWORD  AfterInfo

.DATA?
   schSCManager  HANDLE ?
   schService    HANDLE ?
   hDevice       HANDLE ?
   hOutPut       HANDLE ?

SERVICE_STATUS STRUCT
  dwServiceType             DWORD      ?
  dwCurrentState            DWORD      ?
  dwControlsAccepted        DWORD      ?
  dwWin32ExitCode           DWORD      ?
  dwServiceSpecificExitCode DWORD      ?
  dwCheckPoint              DWORD      ?
  dwWaitHint                DWORD      ?
SERVICE_STATUS ENDS
   serviceStatus SERVICE_STATUS <>

   Written       DWORD  ?
   ServiceExe    LABEL  CHAR
   NTbuffer      LABEL  NTbufferS
                 DB (SIZEOF NTbufferS* MAX_SERVICES) DUP (?)
   FinalString   LABEL  CHAR
                 CHAR   LStrTemplate-6*3+2+8+2 DUP (?)

;===============================================================================
.CODE

 Start:
   SUB      EBP, EBP
   INVOKE   GetStdHandle, STD_OUTPUT_HANDLE
   MOV      hOutPut, EAX

   SetText  Information

  AfterInfo:
   MOV      WhereToJMP, OFFSET RemoveDriver

   MOV      EBX, OFFSET DriverName
   MOV      ESI, OFFSET ServiceExe
   MOV      EDI, OFFSET schService

   INVOKE   GetCurrentDirectory, MAX_PATH, ESI

   INVOKE   lstrcat, ESI, ADDR _ServiceExe
 
   INVOKE   OpenSCManager, EBP, EBP, SC_MANAGER_ALL_ACCESS
   MOV      schSCManager, EAX
   TEST     EAX, EAX
   JE       ErrorOpenSCManager


   INVOKE   CreateService, schSCManager, EBX, EBX,\
                            SERVICE_ALL_ACCESS, SERVICE_KERNEL_DRIVER,\
                            SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,\
                            ESI, EBP, EBP, EBP, EBP, EBP

   MOV      [EDI], EAX
   XCHG     EAX, ECX
   JECXZ    @f

   INVOKE   StartService, ECX, EBP, EBP
   TEST     EAX, EAX
   JNE      OpenDevice
  @@:
   JMP      ErrorStartService

  OpenDevice:
    INVOKE  CreateFile,  ADDR DosDeviceName,\
                         GENERIC_READ OR GENERIC_WRITE,\
                         FILE_SHARE_READ OR FILE_SHARE_WRITE,\
                         EBP, OPEN_EXISTING, EBP, EBP
    MOV     hDevice, EAX
    CMP     EAX,     INVALID_HANDLE_VALUE
    JE      ErrorOpenDevice

    INVOKE  CallDriver, FnGetVersion
    JZ      xErrorDriverFailed
    CMP     EAX, SIZEOF BufferForGetVersion.NTcallVersion
    JNE     ErrorDriverFailed

    CMP     NTbuffer.NTcallVersion, MajorVersion*256 + MinorVersion
    JNE     ErrorIncorrectVersion
    INVOKE  CallDriver, FnGetSDT
   xErrorDriverFailed:
    JZ      ErrorDriverFailed

    MOV     ESI, OFFSET NTbuffer


    PUSH    EDI
    PUSH    WhereToJMP
    PUSH    SIZEOF BufferForGetSDT.ServiceEntry + SIZEOF BufferForGetSDT.ArgCount
    POP     ECX
    CDQ
    DIV     ECX
    XCHG    EAX, EDI
    SUB     EBX, EBX
    MOV     WhereToJMP, OFFSET WriteLoop

   WriteLoop:
    CMP     EDI, EBX
    JLE     @f
    LODSD
    XCHG    EDX, EAX
    LODSB
    MOVZX   EAX, AL
    MOV     ECX, OFFSET FinalString
    SHR     EAX, 2
    PUSH    ECX
    INVOKE  wsprintf, ECX, ADDR StrTemplate, EBX, EDX, EAX
    XCHG    EAX, ECX
    INC     EBX
    POP     EAX
    JMP     Write

   @@:
    POP     WhereToJMP
    POP     EDI

  RemoveDriver:
   INVOKE   CloseHandle, hDevice
   INVOKE   ControlService, [EDI], SERVICE_CONTROL_STOP, ADDR serviceStatus
   INVOKE   DeleteService, [EDI]
   INVOKE   CloseServiceHandle, [EDI]
   INVOKE   CloseServiceHandle, schSCManager
   
  Exitus:
   INVOKE   ExitProcess, EBP ;STATUS_SUCCESS


  GetInfo:
   SetText  Information

  ErrorOpenSCManager:
   SetText  ErOpenSCM

  ErrorStartService:
   SetText  ErStartSrv

  ErrorRemoveService:
   SetText  ErRemoveSrv

  ErrorOpenDevice:
   SetText  ErOpenDev

  ErrorDriverFailed:
   SetText  ErDriverFail

  ErrorIncorrectVersion:
   SetText  ErIncorVer

  Write:
   INVOKE   WriteFile, hOutPut, EAX, ECX, ADDR Written, EBP
   JMP      WhereToJMP



 CallDriver PROC DrvFunc:DWORD

   LOCAL BytesReturned:DWORD

   MOV      EAX, DrvFunc
   LEA      ECX, BytesReturned
   OR       EAX, ICCMask
   INVOKE   DeviceIoControl, hDevice, EAX, NULL, 0, ADDR NTbuffer,\
                             SIZEOF NTbufferS* MAX_SERVICES, ECX,  NULL
   OR       EAX, EAX
   MOV      EAX, BytesReturned
   RET
 CallDriver ENDP

END Start

:TRANSLATE
@echo off
ML /c /coff %0
LINK.EXE NTcallEXE.obj /SUBSYSTEM:CONSOLE /RELEASE /ALIGN:0X1000 /MERGE:.text=NTCALL /SECTION:NTCALL,RWE  /MERGE:.data=NTCALL /MERGE:.rdata=EliCZ /BASE:0x2A10000 /OUT:NTCALL.exe
DEL NTcallEXE.obj
