;@GOTO TRANSLATE

.586P
.MODEL FLAT, STDCALL

   OPTION      CASEMAP:NONE
   UNICODE     = 1
   ARGUMENTS   = 0
   INCLUDE     W32MAIN.INC
   INCLUDE     NTDDK.INC

   INCLUDE     NTcall.INC

   INCLUDE     NToskrnl.INC
   INCLUDELIB  NTOSKRNL.lib

   YOU_KNOW_HOW_TO_PLAY_WITH_API   = FALSE    ;nobody knows my technology
   ;see Information, question: How to make ASM more flexible


;===============================================================================
.DATA
   NTcallServices     DWORD  GetVersion, GetSDT 
   MinService         EQU    0
   MaxService         EQU    LENGTH NTcallServices

.DATA?
   ALIGN 4
   SymLinkNameUnicode UNICODE_STRING {}

;===============================================================================
.CODE INIT

  DeviceName    LABEL  CHAR
                STRING <\Device\NTCALL/0>
  DosDeviceName LABEL  CHAR
                STRING <\DosDevices\NTCALL/0>


  DriverEntry   PROC USES EBX ESI EDI, DriverObject, RegPath 

     LOCAL      DeviceObject      :DWORD
     LOCAL      DevNameUnicode    :UNICODE_STRING

     LEA        EDI,  DevNameUnicode

  IF YOU_KNOW_HOW_TO_PLAY_WITH_API
     MOV        EBX,  RtlInitUnicodeString
  ELSE
     INVOKE     RtlInitUnicodeString,  EDI, ADDR DeviceName
  ENDIF
     ;returns EAX=0 if  [EDI] != 0

     LEA        ECX,  DeviceObject
     MOV	ESI,  DriverObject
     ASSUME     ESI:  PTR DRIVER_OBJECT
     ExtensionSize      EQU EAX ;0
     DevType	        EQU FILE_DEVICE_UNKNOWN SHR 16
     DevCharacteristic  EQU EAX ;0
     Exclusive	        EQU EAX ;FALSE
     INVOKE     IoCreateDevice, ESI, ExtensionSize, EDI, DevType,\
	                        DevCharacteristic, Exclusive, ECX
     TEST       EAX,  EAX
     JL         CreateDeviceFailed

     MOV        EDX,  DeviceObject
     OR         (PDEVICE_OBJECT [EDX]).FLAGS, DO_BUFFERED_IO
   
     MOV        EAX,  OFFSET StandardDispatch
     MOV        [ESI].PDRIVER_UNLOAD,                  OFFSET Unload 
     MOV        [ESI].PDISPATCH_IRP_MJ_CREATE,         EAX  
     MOV        [ESI].PDISPATCH_IRP_MJ_CLOSE,          EAX  
     MOV        [ESI].PDISPATCH_IRP_MJ_DEVICE_CONTROL, OFFSET Dispatch 


     MOV        EAX,  OFFSET SymLinkNameUnicode
     PUSH       EDI
     PUSH       EAX


  IF YOU_KNOW_HOW_TO_PLAY_WITH_API
     INVOKE     EBX,  EAX, ADDR DosDeviceName
  ELSE                   
     INVOKE     RtlInitUnicodeString,  EAX, ADDR DosDeviceName
  ENDIF

     CALL       IoCreateSymbolicLink
     TEST       EAX,  EAX
     JGE        SymLinkCreated

     PUSH       EAX 
     INVOKE     IoDeleteDevice , DeviceObject
     POP        EAX

    SymLinkCreated:
    CreateDeviceFailed:
     RET
  DriverEntry   ENDP
;===============================================================================

.CODE
  Unload        PROC  DriverObject
     INVOKE     IoDeleteSymbolicLink, ADDR SymLinkNameUnicode
     MOV	EAX,  DriverObject
     INVOKE     IoDeleteDevice , (PDRIVER_OBJECT [EAX])._PDEVICE_OBJECT
     RET     
  Unload	ENDP

  Dispatch      PROC  USES EBX ESI EDI  DeviceObject, pIRP

     MOV	ECX,  pIRP
     ASSUME     ECX:  PTR _IRP
     MOV	EDI,  [ECX].PCurrentIrpStackLocation
     MOV	ESI,  [ECX].SystemBuffer 
     MOV        EAX,  (PIO_STACK_LOCATION [EDI]).DeviceIoControl.IoControlCode

     PUSH       ECX   ;save IRP
 
     XOR	EAX,  ICCMask
     CMP        EAX,  MaxService SHL 2
     JA         ItsBad

     TEST       AL,   11B
     JE         @f    ; Non-buffered and semi-buffered methods not supported

    ItsBad:
     MOV        EAX,  STATUS_NOT_IMPLEMENTED ;STATUS_INVALID_USER_BUFFER
     SUB        EDX,  EDX
     JMP        QuitDispatch

    @@:
     CALL       NTcallServices[EAX]
     ;returns   in EAX error_code, in EDX bytes_returned

    QuitDispatch:
     POP        ECX  ;get IRP
     PUSH       EAX
     MOV        [ECX].IoStatus.io_Information, EDX ;sets BytesReturned of DeviceIoControl
     MOV        [ECX].IoStatus.io_Status, EAX 
     SUB        EDX, EDX

  IF YOU_KNOW_HOW_TO_PLAY_WITH_API
     INVOKE     IofCompleteRequest ;this API requires ECX=PIRP,
                                   ;DL=PriorityBoost, usually IO_NO_INCREMENT=0
  ELSE
     INVOKE     IoCompleteRequest, ECX, EDX
  ENDIF
     POP        EAX  ;return with EAX=STATUS_?
     RET
  Dispatch      ENDP



  ;for IRP_MJ_CREATE and IRP_MJ_CLOSE

  StandardDispatch  PROC DeviceObject, pIRP
     MOV        ECX, pIRP
     SUB        EDX, EDX
     PUSH       EDX  ;STATUS_SUCCESSFUL
     MOV        [ECX].IoStatus.io_Information, EDX
     MOV        [ECX].IoStatus.io_Status, EDX 
     ;fields above contain 0 already, but for sure zero them

  IF YOU_KNOW_HOW_TO_PLAY_WITH_API
     INVOKE     IofCompleteRequest ;this API requires ECX=PIRP,
                                   ;DL=PriorityBoost, usually IO_NO_INCREMENT=0
  ELSE
     INVOKE     IoCompleteRequest, ECX, EDX
  ENDIF

     POP        EAX 
     RET     
  StandardDispatch  ENDP




;===============================================================================
  GetVersion:
     ASSUME     ESI: PTR BufferForGetVersion
     PUSH       SIZEOF BufferForGetVersion.NTcallVersion
     SUB        EAX, EAX ;SUCCESSFUL
     POP        EDX      
     CMP        EDX, (PIO_STACK_LOCATION [EDI]).DeviceIoControl.OutputBufferLength
     JA         BufTooSmall
     MOV        [ESI].NTcallVersion, MajorVersion*256 + MinorVersion
     RET

  BufTooSmall:
     MOV        EAX, STATUS_BUFFER_TOO_SMALL
     SUB        EDX, EDX
     RET

  GetSDT:
     SUB        EDX, EDX
     CLD


  IF YOU_KNOW_HOW_TO_PLAY_WITH_API
     MOV        EAX, KeServiceDescriptorTable  ;ntoskrnl export
  ELSE
     JMP        BufTooSmall
  ENDIF


     ASSUME     EAX: PTR ServiceDescriptor

     MOV        ECX, [EAX].HiCall
     MOV        EBX, [EAX].ArgTable
     IMUL       EDX, ECX, SIZEOF BufferForGetSDT
     CMP        EDX, (PIO_STACK_LOCATION [EDI]).DeviceIoControl.OutputBufferLength
     JA         BufTooSmall
     MOV        EDI, ESI
     ASSUME     EDI: PTR BufferForGetSDT
     MOV        ESI, [EAX].ServiceTable
   @@:
     MOV        AL,  [EBX]
     MOVSD
     INC        EBX
     STOSB
     LOOP       @b

     SUB        EAX, EAX ;SUCCESSFUL
     RET
;===============================================================================
   
END DriverEntry

:TRANSLATE
 @ECHO  OFF
 BRC32  -r SYSres.rc
 CVTRES SYSres /MACHINE:IX86
 ML     /c /coff %0
 LINK   NTcallSYS.obj SYSres.obj /SECTION:.rsrc,R /MERGE:.rdata=.text /DRIVER /align:0x20 /out:NTCALL.sys /base:0x10000 /subsystem:native
 DEL    SYSres.res
 DEL    SYSres.obj
 DEL    NTcallSYS.obj