;@GOTO TRANSLATE


.586P
.MODEL FLAT, STDCALL

 OPTION     CASEMAP: NONE    ; == LINK /Cp
 ARGUMENTS  = 0              ; comment ARGUMENTS in W32Main.inc
 UNICODE    = 1              ; for  W32Main.inc
 INCLUDE    W32Main.inc      ; from Walk32 package by Sven Schreiber

 INCLUDELIB KERNEL32.lib
 INCLUDELIB NTVDM.lib 
 INCLUDELIB ADVAPI32.lib 

 INCLUDE    NTCALL.inc

 INCLUDE    KERNEL32u.inc
 INCLUDE    NTVDM.inc 
 INCLUDE    ADVAPI32u.inc 

.DATA
   DosDeviceName LABEL  CHAR
                 STRING <\\.\>
   DriverName    LABEL  CHAR
                 STRING <NTCALL/0> 
   _ServiceExe   LABEL  CHAR
                 STRING <\NTCALL.sys/0> 


   SC_MANAGER_ALL_ACCESS  EQU STANDARD_RIGHTS_REQUIRED OR 03FH 
   SERVICE_ALL_ACCESS     EQU STANDARD_RIGHTS_REQUIRED OR 1FFH
   SERVICE_KERNEL_DRIVER  EQU 001H
   SERVICE_DEMAND_START   EQU 003H
   SERVICE_ERROR_NORMAL   EQU 001H
   SERVICE_CONTROL_STOP   EQU 001H

   hDevice       HANDLE INVALID_HANDLE_VALUE


.DATA?
   schSCManager  HANDLE ?
   schService    HANDLE ?
   hOutPut       HANDLE ?

SERVICE_STATUS STRUCT
  dwServiceType             DWORD      ?
  dwCurrentState            DWORD      ?
  dwControlsAccepted        DWORD      ?
  dwWin32ExitCode           DWORD      ?
  dwServiceSpecificExitCode DWORD      ?
  dwCheckPoint              DWORD      ?
  dwWaitHint                DWORD      ?
SERVICE_STATUS ENDS
   serviceStatus SERVICE_STATUS <>

   ServiceExe    CHAR   MAX_PATH+MAXIMUM_FILENAME_LENGTH DUP (?)


.CODE

 PUBLIC              _DllMainCRTStartup, NTcallVDDRegister, NTcallVDDDispatch

 ;NTcallVDDRegister and NTcallVDDDispatch must be EXPORTED


;-------------------------------------------------------------------------------

 EVEN

_DllMainCRTStartup   PROC  USES EBX ESI EDI,  DllHandle, Reason, pContext

    MOV      EAX,     Reason
    CMP      EAX,     DLL_PROCESS_ATTACH
    JE       Attach
    CMP      EAX,     DLL_PROCESS_DETACH
    JE       Detach
   Success:
    MOV      EAX,     TRUE       ; SUB EAX, EAX / INC EAX
    RET

 Attach:
    CMP      hDevice, INVALID_HANDLE_VALUE
    JNE      Success

    MOV      EBX, OFFSET DriverName
    MOV      ESI, OFFSET ServiceExe
    SUB      EDI, EDI

    INVOKE   GetCurrentDirectory, MAX_PATH, ESI

    INVOKE   lstrcat, ESI, ADDR _ServiceExe
 
    INVOKE   OpenSCManager, EDI, EDI, SC_MANAGER_ALL_ACCESS
    MOV      schSCManager, EAX
    TEST     EAX, EAX
    JE       ErrorOpenSCManager
  
    INVOKE   CreateService, schSCManager, EBX, EBX,\
                             SERVICE_ALL_ACCESS, SERVICE_KERNEL_DRIVER,\
                             SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL,\
                             ESI, EDI, EDI, EDI, EDI, EDI

    MOV      schService, EAX
    XCHG     EAX, ECX
    JECXZ    ErrorStartService

    INVOKE   StartService, ECX, EDI, EDI
    TEST     EAX, EAX
    JE       ErrorStartService

  OpenDevice:
    INVOKE   CreateFile,  ADDR DosDeviceName,\
                          GENERIC_READ OR GENERIC_WRITE,\
                          FILE_SHARE_READ OR FILE_SHARE_WRITE,\
                          EDI, OPEN_EXISTING, EDI, EDI
    MOV      hDevice, EAX
    CMP      EAX,     INVALID_HANDLE_VALUE
    JNE      Success

   ErrorOpenSCManager:
   ErrorStartService:
    CALL     Unload
    MOV      EAX,     FALSE      ; SUB EAX, EAX
    RET

  Detach:
    CALL     Unload
    JMP      Success

  Unload:
    INVOKE   CloseHandle, hDevice
    MOV      hDevice, INVALID_HANDLE_VALUE
    INVOKE   ControlService, schService, SERVICE_CONTROL_STOP, ADDR serviceStatus
    INVOKE   DeleteService, schService
    INVOKE   CloseServiceHandle, schService
    INVOKE   CloseServiceHandle, schSCManager
    RETN

_DllMainCRTStartup   ENDP


;-------------------------------------------------------------------------------

EVEN
NTcallVDDRegister PROC     ;called by RegisterModule
    INVOKE  setCF, 0     ;success
    RET
NTcallVDDRegister ENDP

;-------------------------------------------------------------------------------

EVEN
NTcallVDDDispatch   PROC   USES EBX ESI EDI ;called by DispatchCall

    LOCAL   BytesReturned:DWORD
 
    INVOKE  setCF, 1     ;assume error
    INVOKE  setAX, 0     ;0 bytes written

    INVOKE  getMSW       ;PM or V86? selector or segment?
    AND     EAX,  1
    MOV     ESI, EAX
    INVOKE  getCX        ;my parameter CX buffer size
    MOVZX   EBX, AX
    INVOKE  getDS        
    XCHG    EDI, EAX
    SHL     EDI, 16
    INVOKE  getDX        ;my parameter ES:DI buffer
    XCHG    DI,  AX      ; EDI = DS << 16 + DX

    INVOKE  MGetVdmPointer, EDI, EBX, ESI  ;FALSE
    ;this will call Sim32pGetVDMPointer
    ;EAX = ES*16+DI
    ;3rd parameter: FALSE - segment addressing, TRUE - selector addressing
    XCHG    EAX, EDI

    INVOKE  getBX        ;my parameter Function
    MOVZX   EAX, AX
    LEA     ESI, BytesReturned
    OR      EAX, ICCMask
    INVOKE  DeviceIoControl, hDevice, EAX, 0, 0, EDI, EBX, ESI,  0

    OR      EAX, EAX
    JZ      DeviceFailed

    INVOKE  setEAX, [ESI]  
    INVOKE  setCF, 0   ;no error

 DeviceFailed:
    RET
NTcallVDDDispatch ENDP


END

:TRANSLATE
@ECHO OFF
ML /c /coff %0
LINK NTcallVDD /RELEASE /MERGE:.text=NTCALL /SECTION:NTCALL,RWE  /MERGE:.data=NTCALL /MERGE:.rdata=EliCZ /BASE:0X30000000 /DLL /ALIGN:0X1000 /DEF:NTcallVDD.def
DEL NTcallVDD.exp
DEL NTcallVDD.lib
DEL NTcallVDD.obj
