//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>

#include "MSinc.h"

#define  MS_DELAY 32

/////////////////////////////////////////////////////////

HANDLE hMS, hMU;
DWORD pid, num = 0, RealMSSize, RealMSSizeWithoutHeader;


BOOL WINAPI PostData(DWORD Message, const BYTE *Buffer, DWORD cbytes) {
  MS_MESSAGE Msg;
  DWORD written;
  BOOL fwrite=TRUE;
  Msg.Pid = pid;
  Msg.MsgSize = cbytes;
  Msg.Message = Message;
  WaitForSingleObject(hMU, INFINITE);
  Msg.mNum = num++;
  GetLocalTime(&Msg.Time);
  while(cbytes > RealMSSizeWithoutHeader) {
    if(Buffer) {
      memcpy(&Msg.Data, Buffer, RealMSSizeWithoutHeader);
      Buffer += RealMSSizeWithoutHeader;
    }
    Msg.cbSize = RealMSSizeWithoutHeader;
    if(fwrite = WriteFile(hMS, &Msg, RealMSSize, &written, NULL))
      Sleep(MS_DELAY);
    else  
      break;
    cbytes -= RealMSSizeWithoutHeader;
  }
  Msg.cbSize = cbytes;
  if(fwrite) {
    memcpy(&Msg.Data, Buffer, cbytes);
    fwrite = WriteFile(hMS, &Msg, cbytes+MS_MSG_HEADER_SIZE, &written, NULL);
  }
  ReleaseMutex(hMU);
  return(fwrite);
}  

BOOL WINAPI PostString(TCHAR *szMsg) {
  return(PostData(MS_STRING_MSG, (BYTE *)szMsg, (_tcslen(szMsg)+1)*sizeof(TCHAR)));
}  

int _tmain(VOID) {
  LPVOID lpBuffer;
  TCHAR  szWindowName[64];
  LPMS_MESSAGE Msg;
  TCHAR* Data;
  DWORD  i;

  pid = GetCurrentProcessId();
  _stprintf(szWindowName, TEXT("MSClient %.X"), pid);
  SetConsoleTitle(szWindowName);
  if((hMS = CreateFile(MSName, GENERIC_WRITE, FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, NULL)) == INVALID_HANDLE_VALUE)
    _tprintf(TEXT("MSCLNT: Can't open mailslot!\n"));
  else {
    if((hMU = OpenMutex(SYNCHRONIZE, FALSE, MUName)) == NULL)
      _tprintf(TEXT("MSCLNT: Can't open mutex!\n"));
    else {
      if(Msg = (LPMS_MESSAGE)LocalAlloc(LPTR, MS_MAX_MSG_SIZE)) {
        Data = (TCHAR *)Msg;
        Msg->Message = MS_TEST_MSG;
        for(RealMSSize=MS_MAX_MSG_SIZE; !WriteFile(hMS, Msg, RealMSSize, &i, NULL); RealMSSize--);
          _tprintf(TEXT("MSCLNT: Real MS size = %u\n"), RealMSSize);
        RealMSSizeWithoutHeader = RealMSSize - MS_MSG_HEADER_SIZE;
//        PostData(0, (LPBYTE)LocalAlloc(LPTR, 0x2001), 0x2001);
        while(TRUE) {
          _tprintf(TEXT("Type your message or 'leave' or 'terminate' :\n"));
          _getts(Data);
          if(_tcsicmp(Data, TEXT("leave")) == 0)
            break;
          if(_tcsicmp(Data, TEXT("terminate")) == 0) {
            PostData(MS_TERMINATE_MSG, NULL, 0);
            break;
          }
          if(!PostString(Data))
            _tprintf(TEXT("\nMSCLNT: Can't post message!"));
        }
      LocalFree(Msg);
      }
      else
        _tprintf(TEXT("\nMSCLNT: Can't allocate memory!"));
      CloseHandle(hMU);
    }
    CloseHandle(hMS);
  }
  _tprintf(TEXT("\nMSCLNT: Press Enter to quit..."));
  return getchar();
}