//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>

#include "MSinc.h"


/////////////////////////////////////////////////////////

int _tmain(VOID) {
  HANDLE hMS, hMU;
  DWORD  i, cursize=0;
  LPMS_MESSAGE Msg;
  BYTE *Data;
  SYSTEMTIME Time;
  
  SetConsoleTitle(TEXT("MSServer"));
  if((hMS = CreateMailslot(MSName, MS_MAX_MSG_SIZE, MAILSLOT_WAIT_FOREVER, NULL)) == INVALID_HANDLE_VALUE)
    _tprintf(TEXT("\nMSSRV: Can't create mailslot!"));
  else {
    if((hMU = CreateMutex(NULL, FALSE, MUName)) == NULL)
      _tprintf(TEXT("\nMSSRV: Can't create mutex!"));
    else {
      if(Msg = (LPMS_MESSAGE)LocalAlloc(LPTR, MS_MAX_MSG_SIZE)) {
        while(TRUE)
          if(ReadFile(hMS, Msg, MS_MAX_MSG_SIZE, &i, NULL)) {
            if(!cursize)
              GetLocalTime(&Time);
            if(Msg->MsgSize != Msg->cbSize) {
              if(!cursize)
                if(Data=(BYTE *)LocalAlloc(LPTR, Msg->MsgSize))
                  memcpy(Data, Msg->Data, Msg->cbSize);
                else 
                 _tprintf(TEXT("\nMSSRV: Can't allocate memory!"));
              else
                if(Data)
                  memcpy(Data+cursize, Msg->Data, Msg->cbSize);
              cursize += Msg->cbSize;
              if(!Data || (cursize != Msg->MsgSize))
                continue;                  
            }
            else
              Data = Msg->Data;
       
            cursize = 0; 
            if(Msg->Message == MS_TERMINATE_MSG) {
              if(Data != Msg->Data)
                LocalFree(Data);
              break;
            } 
            else           
              if(Msg->Message == MS_TEST_MSG) {
                if(Data != Msg->Data)
                  LocalFree(Data);
                continue;
              }
              else {
                _tprintf(TEXT("\n*****\nPID=%X  MSG#=%u  SIZE=%u  SENT=%.2u:%.2u:%.2u.%.3u  RECEIVED=%.2u:%.2u:%.2u.%.3u\n"),
                         Msg->Pid, Msg->mNum, Msg->MsgSize,
                         Msg->Time.wHour, Msg->Time.wMinute, Msg->Time.wSecond, Msg->Time.wMilliseconds,
                         Time.wHour, Time.wMinute, Time.wSecond, Time.wMilliseconds);
                if(Msg->Message == MS_STRING_MSG)
                  _tprintf(TEXT("%s\n"), Data);
                else
                  for(i=0; Msg->MsgSize--; i++)
                   _tprintf(TEXT("%.2X"), *(Data+i));
                if(Data != Msg->Data)
                  LocalFree(Data);
              }
          }
          else
            _tprintf(TEXT("\nMSSRV: Can't read message!"));
        LocalFree(Msg);
      }
      else
        _tprintf(TEXT("\nMSSRV: Can't allocate memory!"));
      CloseHandle(hMU);
    }
    CloseHandle(hMS);
  }
  _tprintf(TEXT("\nMSSRV: Press Enter to quit..."));
  return getchar();
}