//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>

#include "WMinc.h"

/////////////////////////////////////////////////////////

HANDLE hMU;
DWORD pid, num = 0;
HWND hWMSrv;

BOOL WINAPI PostData(DWORD Message, const BYTE *Buffer, DWORD cbytes) {
  BOOL fwrite;
  COPYDATASTRUCT cpdata;
  LPWM_MESSAGE Msg;
  cpdata.cbData = cbytes+WM_MSG_HEADER_SIZE;
  Msg = (LPWM_MESSAGE)LocalAlloc(LPTR, cpdata.cbData);
  cpdata.lpData = Msg;
  Msg->Pid = pid;
  Msg->MsgSize = cbytes;
  Msg->cbSize = cbytes;
  Msg->Message = Message;
  WaitForSingleObject(hMU, INFINITE);
  Msg->mNum = num++;
  GetLocalTime(&Msg->Time); 
  memcpy(Msg->Data, Buffer, cbytes);
  fwrite = SendMessage(hWMSrv, WM_COPYDATA, (WPARAM)hWMSrv, (LPARAM)&cpdata);
  ReleaseMutex(hMU);
  return(fwrite);
}  

BOOL WINAPI PostString(TCHAR *szMsg) {
  return(PostData(WM_STRING_MSG, (BYTE *)szMsg, (_tcslen(szMsg)+1)*sizeof(TCHAR)));
}  

int _tmain() {
  LPVOID lpBuffer;
  TCHAR  szWindowName[64];
  LPWM_MESSAGE Msg;
  TCHAR* Data;
  DWORD  i;

  pid = GetCurrentProcessId();
  _stprintf(szWindowName, TEXT("WMClient %.X"), pid);
  SetConsoleTitle(szWindowName);
  if((hWMSrv = FindWindow(WMName, NULL)) == NULL)
    _tprintf(TEXT("WMCLNT: Can't find server!\n"));
  else
    if((hMU = OpenMutex(SYNCHRONIZE, FALSE, WUName)) == NULL)
      _tprintf(TEXT("WMCLNT: Can't open mutex!\n"));
    else {
      if(Msg = (LPWM_MESSAGE)LocalAlloc(LPTR, WM_MAX_MSG_SIZE)) {
        Data = (TCHAR *)Msg;
        Msg->Message = WM_TEST_MSG;
//        PostData(0, (LPBYTE)LocalAlloc(LPTR, 0x2001), 0x2001);
        while(TRUE) {
          _tprintf(TEXT("Type your message or 'leave' or 'terminate' :\n"));
          _getts(Data);
          if(_tcsicmp(Data, TEXT("leave")) == 0)
            break;
          if(_tcsicmp(Data, TEXT("terminate")) == 0) {
            PostData(WM_TERMINATE_MSG, NULL, 0);
            break;
          }
          if(!PostString(Data))
            _tprintf(TEXT("\nWMCLNT: Can't post message!"));
        }
        LocalFree(Msg);
      }
      else
        _tprintf(TEXT("\nWMCLNT: Can't allocate memory!"));
      CloseHandle(hMU);
    }
  _tprintf(TEXT("\nWMCLNT: Press Enter to quit..."));
  return getchar();
}