//#define UNICODE
#ifdef UNICODE
  #define _UNICODE
#endif
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <windows.h>
#include <tchar.h>

#include "WMinc.h"

LRESULT CALLBACK WMWndProc(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  SYSTEMTIME Time;
  LPWM_MESSAGE Msg;
  DWORD  i;

  if(uMsg == WM_COPYDATA) {
    GetLocalTime(&Time);
    Msg = (LPWM_MESSAGE)((COPYDATASTRUCT*)lParam)->lpData;
    if(Msg->Message == WM_TERMINATE_MSG)
      PostQuitMessage(0);
    else           
      if(Msg->Message != WM_TEST_MSG) {
        _tprintf(TEXT("\n*****\nPID=%X  MSG#=%u  SIZE=%u  SENT=%.2u:%.2u:%.2u.%.3u  RECEIVED=%.2u:%.2u:%.2u.%.3u\n"),
                 Msg->Pid, Msg->mNum, Msg->MsgSize,
                 Msg->Time.wHour, Msg->Time.wMinute, Msg->Time.wSecond, Msg->Time.wMilliseconds,
                 Time.wHour, Time.wMinute, Time.wSecond, Time.wMilliseconds);
        if(Msg->Message == WM_STRING_MSG)
          _tprintf(TEXT("%s\n"), (TCHAR *)Msg->Data);
        else
          for(i=0; Msg->MsgSize--; i++)
            _tprintf(TEXT("%.2X"), *(Msg->Data+i));
      }
    return TRUE;
    }
  else
   return DefWindowProc(hwnd, uMsg, wParam, lParam);
}

WNDCLASS WMClass =
{CS_GLOBALCLASS, WMWndProc, 0, 0, NULL, NULL, NULL,
 NULL, NULL, NULL};

/////////////////////////////////////////////////////////

int _tmain(VOID) {
  HANDLE hMU;
  DWORD  i;
  MSG    msg;
  
  SetConsoleTitle(TEXT("WMServer"));
  if(FindWindow(WMName, NULL) != NULL)
    _tprintf(TEXT("WMSRV: Server already exists!\n"));
  else
    if((hMU = CreateMutex(NULL, FALSE, WUName)) == NULL)
      _tprintf(TEXT("\nWMSRV: Can't create mutex!"));
    else {
      WMClass.hInstance = GetModuleHandle(NULL);
      WMClass.lpszClassName = WMName;
      if(RegisterClass(&WMClass) == 0)
        _tprintf(TEXT("\nWMSRV: Can't register class!"));
      else {
        if(CreateWindow(WMName, NULL, 0, 0, 0, 0, 0,
                        NULL, NULL, WMClass.hInstance, NULL) == NULL)
          _tprintf(TEXT("\nWMSRV: Can't create window!"));
        else
          while((i = GetMessage(&msg, NULL, 0, 0)) && (i != -1))
            DispatchMessage(&msg);
      } 
      CloseHandle(hMU);
    }
  _tprintf(TEXT("\nWMSRV: Press Enter to quit..."));
  return getchar();
}