#define WIN32_LEAN_AND_MEAN
//#define UNICODE
#ifdef UNICODE
#define _UNICODE
#endif
#include <tchar.h>
#include <stdio.h>
#include <conio.h>
#include <windows.h>
#define PW_STATIC_LINKING
#include <PrcWorks.h>

#define PW_MAX_SESSIONS 64

int _tmain(void) {
  HANDLE StdOut;
  DWORD r, s, t, *buf=NULL, CnslSeId, ThisSeId;
  TCHAR ProcName[MAX_PATH], *PreChars;

  typedef union {
    COORD coord;
    WORD  wsize[2];
  } LCC32_COORD;
  LCC32_COORD cbsize = {{80, 0x910}};
  FreeConsole(); 
  AllocConsole();
  StdOut = GetStdHandle(STD_OUTPUT_HANDLE);
  while(!SetConsoleScreenBufferSize(StdOut, cbsize.coord))
    cbsize.wsize[1] -= 0x10;

  SetConsoleTitle(_T("PrintPIDs - Press Esc to quit"));

  do {
    DWORD SessionId = PW_ALLSESSIONS;
    //check if there's more sessions
    for(r=0; r<PW_MAX_SESSIONS; r++)
       if(BuildPIDList(NULL, 0, r)!=PW_SESERROR)
         if(r!=0) {
           SessionId = 0; //is more sessions
           break;
         }

    _tprintf(_T("\n=================================\n"));
    do { 
      r=0; s=r+1;
      while(s>r) { 
        r=s+0x100;  
        if(buf)
          LocalFree(buf);
        buf=(LPDWORD)LocalAlloc(LPTR, r*sizeof(DWORD));
        if(!buf)
          break;
        s = BuildPIDList(buf, r, SessionId);
        if((s==PW_MEMERROR) || (s==PW_SESERROR))
          break;
      }//while
      if(buf){
        if(s!=PW_MEMERROR) {
          if(s!=PW_SESERROR) {
            for(r=0; r<s; r++)
              if(((t=PID2ProcessName(buf[r], ProcName))!=PW_PIDERROR) && (t!=PW_MEMERROR))
                if(SessionId != PW_ALLSESSIONS) {
                   ThisSeId = GetSessionId(PW_THISSESSION);
                   CnslSeId = GetSessionId(PW_CNSLSESSION);
                   if((CnslSeId == SessionId) && (ThisSeId == SessionId))
                     PreChars = _T("^@");
                   else
                     if(CnslSeId == SessionId)
                       PreChars = _T("^ ");
                     else
                       if(ThisSeId == SessionId)
                         PreChars = _T(" @");
                       else  
                         PreChars = _T("  ");
                  _tprintf(_T("%s %.2u 0x%.4X = %.5u ~ %s\n"), PreChars, SessionId, buf[r], buf[r], ProcName);
                  if(s == r+1)
                    _tprintf(_T("\n"));
                } 
                else {
                  _tprintf(_T("0x%.4X = %.5u ~ %s\n"), buf[r], buf[r], ProcName);
                }
          }//ifses
        }//ifmem
        else {
          _tprintf(_T("No memory!\n"));
        }       
      }//ifbuf
      else {
        _tprintf(_T("No memory!\n"));
      }
    } while((SessionId!=PW_ALLSESSIONS) && (++SessionId < PW_MAX_SESSIONS));
  } while(getch() != 0x1B);
  if(buf)
    LocalFree(buf);
}