#ifndef __PrintSDDL__
#define __PrintSDDL__
typedef BOOL (WINAPI *TConvertSDToStringSDRootDomain)(LPCTSTR, PSECURITY_DESCRIPTOR, DWORD, SECURITY_INFORMATION, LPTSTR*, LPDWORD);

LPTSTR WINAPI PrintSDDL(HANDLE hObject, SECURITY_INFORMATION ReqSecInfo, LPCTSTR *SystemNames) {

  HINSTANCE hADVAPI32;
  static TConvertSDToStringSDRootDomain
  pConvertSDToStringSDRootDomain = NULL;
  if(!pConvertSDToStringSDRootDomain) {
    if(!(hADVAPI32 = LoadLibrary(_T("ADVAPI32.dll"))))
      return(NULL);
    #ifdef UNICODE
      #define sConvertSDToStringSDRootDomain "ConvertSDToStringSDRootDomainW"
    #else
      #define sConvertSDToStringSDRootDomain "ConvertSDToStringSDRootDomainA"
    #endif
    if(!(pConvertSDToStringSDRootDomain =
    (TConvertSDToStringSDRootDomain)
    GetProcAddress(hADVAPI32, sConvertSDToStringSDRootDomain)))
      return(NULL);
  }

  LPTSTR MainString;
  if((MainString = (LPTSTR)LocalAlloc(LMEM_FIXED, 16384*sizeof(TCHAR))) == NULL) {
    return(NULL);
  }

  DWORD ReqLen, LastError;
  PSECURITY_DESCRIPTOR pSD = NULL;
  GetKernelObjectSecurity(hObject, ReqSecInfo, NULL, 0, &ReqLen);
  do { 
    LastError = GetLastError();
    if(pSD) {
      LocalFree(pSD);
    }
    if(LastError != ERROR_INSUFFICIENT_BUFFER) {
      _stprintf(MainString, _T("Can't get object security! (%u)"), LastError);
      return(MainString);
    }
    if(!(pSD = LocalAlloc(LMEM_FIXED, ReqLen))) {
      _stprintf(MainString, _T("Heap allocation failed! (%u)"), GetLastError());
      return(MainString);
    }
  } while(!GetKernelObjectSecurity(hObject, ReqSecInfo, pSD, ReqLen, &ReqLen));

  if(!IsValidSecurityDescriptor(pSD)) {
    _stprintf(MainString, _T("Security descriptor is not valid! (%u)"), GetLastError());
    LocalFree(pSD);
    return(MainString);
  }

  PSID pOwner;
  BOOL bOwnerDefaulted;
  if(GetSecurityDescriptorOwner(pSD, &pOwner, &bOwnerDefaulted)) {
    if(pOwner == NULL) {
      ReqSecInfo &= ~OWNER_SECURITY_INFORMATION;
    }
  }

  PSID pGroup;
  BOOL bGroupDefaulted;
  if(GetSecurityDescriptorGroup(pSD, &pGroup, &bGroupDefaulted)) {
    if(pGroup == NULL) {
      ReqSecInfo &= ~GROUP_SECURITY_INFORMATION;
    }
  }

  PACL pDacl;
  BOOL bDaclDefaulted, bDaclPresent;
  if(GetSecurityDescriptorDacl(pSD, &bDaclPresent, &pDacl, &bDaclDefaulted)) {
    if((!bDaclPresent) || (pDacl == NULL)) {
      ReqSecInfo &= ~DACL_SECURITY_INFORMATION;
    }
  }

  PACL pSacl;
  BOOL bSaclDefaulted, bSaclPresent;
  if(GetSecurityDescriptorSacl(pSD, &bSaclPresent, &pSacl, &bSaclDefaulted)) {
    if((!bSaclPresent) || (pSacl == NULL)) {
      ReqSecInfo &= ~SACL_SECURITY_INFORMATION;
    }
  }

  if(!ReqSecInfo) {
//    _stprintf(MainString, _T("Security descriptor is empty!"));
    _stprintf(MainString, _T(" "));
    return(MainString);
  }

  LPTSTR StringSD;
  LPCTSTR rSystemNames[2] =  {NULL, LPCTSTR(-1)};
  if(SystemNames == NULL) {
    SystemNames = rSystemNames;
  }
  BOOL bSuccess = FALSE;
  int i;
  for(i=0; SystemNames[i] != LPCTSTR(-1); i++) {
    if(pConvertSDToStringSDRootDomain(SystemNames[i], pSD, 1, ReqSecInfo, &StringSD, NULL)) {
      bSuccess = TRUE;
      break;
    } 
  }
  if(!bSuccess) {
    _stprintf(MainString, _T("Security descriptor can't be converted to string! (%u)"), GetLastError());
    LocalFree(pSD);
    return(MainString);
  }
 
  _stprintf(MainString, _T("%s"), StringSD);
  LocalFree(StringSD);
  LocalFree(pSD);
  return(MainString);
}

typedef BOOL (WINAPI *TConvertStringSDToSDRootDomain)(LPCTSTR, LPCTSTR, DWORD, PSECURITY_DESCRIPTOR*, LPDWORD);

BOOL WINAPI ModifySD(HANDLE hObject, SECURITY_INFORMATION ForceNone, LPCTSTR *SystemNames, LPCTSTR pSDDL) {

  HINSTANCE hADVAPI32;
  static TConvertStringSDToSDRootDomain
  pConvertStringSDToSDRootDomain = NULL;
  if(!pConvertStringSDToSDRootDomain) {
    if(!(hADVAPI32 = LoadLibrary(_T("ADVAPI32.dll"))))
      return(FALSE);
    #ifdef UNICODE
      #define sConvertStringSDToSDRootDomain "ConvertStringSDToSDRootDomainW"
    #else
      #define sConvertStringSDToSDRootDomain "ConvertStringSDToSDRootDomainA"
    #endif
    if(!(pConvertStringSDToSDRootDomain =
    (TConvertStringSDToSDRootDomain)
    GetProcAddress(hADVAPI32, sConvertStringSDToSDRootDomain)))
      return(FALSE);
  }

  PSECURITY_DESCRIPTOR pSD = NULL;

  LPCTSTR rSystemNames[2] =  {NULL, LPCTSTR(-1)};
  if(SystemNames == NULL) {
    SystemNames = rSystemNames;
  }
  BOOL bSuccess = FALSE;
  int i;
  for(i=0; SystemNames[i] != LPCTSTR(-1); i++) {
    if(pConvertStringSDToSDRootDomain(SystemNames[i], pSDDL, 1, &pSD, NULL)) {
      bSuccess = TRUE;
      break;
    } 
  }
  if(!bSuccess) {
    return(FALSE);
  }

  if(!IsValidSecurityDescriptor(pSD)) {
    LocalFree(pSD);
    return(FALSE);
  }
 
  SECURITY_INFORMATION SecInfo = 0;

  PSID pOwner;
  BOOL bOwnerDefaulted;
  if(GetSecurityDescriptorOwner(pSD, &pOwner, &bOwnerDefaulted)) {
    if((pOwner != NULL) || (ForceNone & OWNER_SECURITY_INFORMATION)) {
      SecInfo |= OWNER_SECURITY_INFORMATION;
    }
  }

  PSID pGroup;
  BOOL bGroupDefaulted;
  if(GetSecurityDescriptorGroup(pSD, &pGroup, &bGroupDefaulted)) {
    if((pGroup != NULL) || (ForceNone & GROUP_SECURITY_INFORMATION)) {
      SecInfo |= GROUP_SECURITY_INFORMATION;
    }
  }

  SECURITY_DESCRIPTOR_CONTROL Control;
  DWORD dwRevision;
  if(GetSecurityDescriptorControl(pSD, &Control, &dwRevision)) {
    if((Control & SE_DACL_PRESENT) || (ForceNone & DACL_SECURITY_INFORMATION)) {
      SecInfo |= DACL_SECURITY_INFORMATION;
    }
    if((Control & SE_SACL_PRESENT) || (ForceNone & SACL_SECURITY_INFORMATION)) {
      SecInfo |= SACL_SECURITY_INFORMATION;
    }
  }

  BOOL Result = SetKernelObjectSecurity(hObject, SecInfo, pSD);
  LocalFree(pSD);
  return(Result);
}
#endif