;@GOTO -)
.586P
.MODEL FLAT
INCLUDE WINDOWS.inc
UNICODE=0
INCLUDE APIMACRO.mac
INCLUDE NtStruc.inc
INCLUDE NtStatus.inc
INCLUDELIB iKERNEL32
INCLUDELIB Thunk

;SHUTDOWN = 1  ;standard reboot
;SYSERROR = 1  ;bugcheck
;APPERROR = 1  ;generate example error message; no rebooting, errorbox only


;for NtRaiseHardError:
APP_ERROR EQU  1
SYS_ERROR EQU  6

;for NtShutdownSystem:
SDS_SHUTDOWN EQU 0
SDS_RESTART  EQU 1
SDS_POWEROFF EQU 2


.CODE
;-------------------------------------------------------------------------------

IFDEF APPERROR
   NUM_PARAMS  = 1  ; max 5
   STRING_MAP  = 00001B
   Message0    UNICODE_STRING   <LUMessage*WCHAR_, LUMessage*WCHAR_, sUMessage>
   Params      DWORD Message0
   TEXTW       UMessage,        <KERNEL32.DLL>
ELSE
   NUM_PARAMS  = 0
   STRING_MAP  = 00000B
   TEXTA   zRtlAdjustPrivilege, <RtlAdjustPrivilege/0>
ENDIF
 
   TEXTA   zKERNEL,             <KERNEL/0>
   TEXTA   zEXITKERNEL,         <EXITKERNEL/0>
   TEXTA   zKERNEL32,           <KERNEL32.DLL/0>
   TEXTA   zQT_Thunk,           <QT_Thunk/0>

   TEXT    zNTDLL,              <NTDLL.DLL/0>
IFDEF SHUTDOWN
   TEXTA   zNtShutdownSystem,   <NtShutdownSystem/0>
ELSE
   TEXTA   zNtRaiseHardError,   <NtRaiseHardError/0>
ENDIF
;-------------------------------------------------------------------------------
PrimaryThread:

;check the OS type
   iWin32i GetModuleHandle, szKERNEL32
   TEST    EAX, EAX
   JE      Exit
   iWin32  GetProcAddress, EAX, szQT_Thunk
   TEST    EAX, EAX
;QT_Thunk is 9x-only API
   JE      IsNT

;get address of KERNEL.EXITKERNEL
   XCHG    EBX, EAX
   iWin32  LoadLibrary16, szKERNEL
   CMP     AX, 32
   JB      Exit
   iWin32  GetProcAddress16, EAX, szEXITKERNEL
   TEST    EAX, EAX
   JE      Exit
   XCHG    EDX, EAX 

;call KERNEL.EXITKERNEL
   sWin32  EBX, 'C'
   JMP     Exit

IsNT:
   iWin32i GetModuleHandle, szNTDLL
   TEST    EAX, EAX 
   JE      Exit
   XCHG    EBX, EAX
IFNDEF APPERROR
;get address of NTDLL.RtlAdjustPrivilege   
   iWin32  GetProcAddress, EBX, szRtlAdjustPrivilege
   TEST    EAX, EAX 
   JE      Exit
;set SHUTDOWN privilege
   PUSH    ECX
   sWin32  EAX, SE_SHUTDOWN_PRIVILEGE, TRUE, ADJUST_CURRENT_PROCESS, ESP
   TEST    EAX, EAX
   POP     ECX
;failed -> SHUTDOWN right is probably not assigned to the user (~guest) (check Loc.Sec.Pol.)
   JL      Exit
ENDIF
IFDEF SHUTDOWN
;get address of NTDLL.NtShutdownSystem
   iWin32  GetProcAddress, EBX, szNtShutdownSystem
   TEST    EAX, EAX 
   JE      Exit
   sWin32  EAX, SDS_RESTART
ELSE
;get address of NTDLL.NtRaiseHardError
   iWin32  GetProcAddress, EBX, szNtRaiseHardError
   TEST    EAX, EAX 
   JE      Exit
   PUSH    ECX
IFDEF APPERROR
   ;generate errorbox (see NTSTATUC.h/inc for message string and parameters types (if any)
   sWin32  EAX, STATUS_BAD_DLL_ENTRYPOINT, NUM_PARAMS, STRING_MAP, OFFSET Params, APP_ERROR, ESP
ELSE
   ;bugcheck the system (BSOD)
   sWin32  EAX, STATUS_UNSUCCESSFUL, NUM_PARAMS, STRING_MAP, NULL, SYS_ERROR, ESP
ENDIF
   POP     ECX
ENDIF

  Exit:
   iWin32  ExitProcess, EAX
END PrimaryThread
;-------------------------------------------------------------------------------
:-)
@ECHO OFF
ML /DAPPERROR /c /coff /Gz /Cp /nologo Reboot.bat
eLINK Reboot  /nologo /OUT:RebootAPPERROR.exe /SUBSYSTEM:WINDOWS /IGNORE:4060,4078 /STUB:RebootD.exe /OPTidata /MERGE:.rdata=.text
ML /DSYSERROR /c /coff /Gz /Cp /nologo Reboot.bat
eLINK Reboot  /nologo /OUT:RebootSYSERROR.exe /SUBSYSTEM:WINDOWS /IGNORE:4060,4078 /STUB:RebootD.exe /OPTidata /MERGE:.rdata=.text
ML /DSHUTDOWN /c /coff /Gz /Cp /nologo Reboot.bat
eLINK Reboot  /nologo /OUT:RebootSHUTDOWN.exe /SUBSYSTEM:WINDOWS /IGNORE:4060,4078 /STUB:RebootD.exe /OPTidata /MERGE:.rdata=.text
DEL Reboot.obj
PAUSE
CLS