IFNDEF  _HEAP_INC
_HEAP_INC   EQU     1

include types.inc

HEAP    STRUCT
    h       dd      ?
    max     dd      ?
    p       dd      ?
    cb      dd      ?
HEAP    ENDS

MAKE_PROCESS_HEAP   MACRO   pHeap:REQ,HeapCb
    LOCAL   HereIfErr
    IFB     <HeapCb>
        HeapCb  EQU 1000h
    ENDIF
.code
    lea     edx,pHeap
    and     pd[edx],0
    and     pd[edx+04h],0
    and     pd[edx+08h],0
    and     pd[edx+0Ch],0
    push    edx
    call    GetProcessHeap
    or      eax,eax
    stc
    pop     edx
    je      HereIfErr
        push    edx
        mov     [edx],eax
        invoke  HeapAlloc,eax,0,HeapCb
        or      eax,eax
        stc
        pop     edx
        je      HereIfErr
            mov     [edx+08h],eax
            mov     pd[edx+0Ch],HeapCb
            clc
    HereIfErr:
ENDM

PAGEGROW_HEAP   MACRO   pHeap
    LOCAL   HereIfErr
.code
    lea     edx,pHeap
    mov     ecx,[edx+0Ch]
    push    edx
    add     ecx,1000h
    push    ecx
    invoke  HeapReAlloc,pd[edx],0,pd[edx+08h],ecx
    pop     ecx
    or      eax,eax
    stc
    pop     edx
    je      HereIfErr
        mov     [edx+08h],eax
        mov     [edx+0Ch],ecx
        clc
    HereIfErr:
ENDM

FREE_HEAP   MACRO   pHeap:REQ
    LOCAL   HereIfErr
.code
    lea     eax,pHeap
    push    eax
    invoke  HeapFree,pd[eax],0,pd[eax+08h]
    or      eax,eax
    stc
    pop     eax
    je      HereIfErr
        and     pd[eax+0Ch],0
        and     pd[eax+08h],0
        clc
    HereIfErr:
ENDM

DESTROY_HEAP    MACRO   pHeap:REQ
    LOCAL   HereIfErr
.code
    lea     eax,pHeap
    push    eax
    invoke  HeapDestroy,pd[eax]
    or      eax,eax
    stc
    pop     eax
    je      HereIfErr
        and     pd[eax],0
        and     pd[eax+04h],0
        and     pd[eax+08h],0
        and     pd[eax+0Ch],0
        clc
    HereIfErr:
ENDM

ENDIF