IFNDEF _MAPF_INC
_MAPF_INC       EQU     1

MAPF    STRUCT
    p       dd      ?
    cb      dd      ?
    hF      dd      ?
    hM      dd      ?
MAPF    ENDS

MAKE_MAPFILE    MACRO   mfName,iTxt,pTxt
    LOCAL   azTMFxt
    LOCAL   HereOnOk
    
.code
    IFIDNI <pTxt>,<esi>
        reg     equ     edi
    ELSE
        reg     equ     esi
    ENDIF
    
    push    reg

    lea     reg,mfName
    ASSUME  reg:PTR MAPF

    and     pd[reg].hF,0
    and     pd[reg].hM,0
    and     pd[reg].p,0
    and     pd[reg].cb,0

    IFB<pTxt>
        IFB<iTxt>
            .err<il faut definir soit un nom de fichier soit un pointeur vers un nom>
        ELSE
            .data
                azMFTxt db iTxt,0
            .code
                invoke  CreateFile,@ azMFTxt,GENERIC_READ+GENERIC_WRITE,0,0,OPEN_EXISTING,0,0
        ENDIF
    ELSE
        .code
            invoke  CreateFile,pTxt,GENERIC_READ+GENERIC_WRITE,0,0,OPEN_EXISTING,0,0
    ENDIF
    inc     eax
    .IF     !ZERO?
        dec     eax
        mov     [reg].hF,eax
        invoke  CreateFileMapping,eax,0,PAGE_READWRITE,0,0,0
        or      eax,eax
        .IF     !ZERO?
            mov     [reg].hM,eax
            invoke  MapViewOfFile,eax,FILE_MAP_ALL_ACCESS,0,0,0
            or      eax,eax
            .IF     !ZERO?
                mov     [reg].p,eax
                invoke  GetFileSize,[reg].hF,0
                mov     [reg].cb,eax
                clc
                jmp     HereOnOk
            .ENDIF
        .ENDIF        
        invoke  CloseHandle,[reg].hM
        and     [reg].hM,0
    .ENDIF
    invoke  CloseHandle,[reg].hF
    and     [reg].hF,0
    stc
HereOnOk:
    pop     reg
    ASSUME  reg:NOTHING
ENDM

FREE_MAPFILE    MACRO mfName
    push    edi
    lea     edi,mfName
    push    4
    ASSUME  edi:PTR MAPF
    invoke  UnmapViewOfFile,[edi].p
    invoke  CloseHandle,[edi].hM
    invoke  CloseHandle,[edi].hF
    ASSUME  edi:NOTHING
    pop     ecx
    xor     eax,eax
    rep     stosd
    pop     edi
ENDM

ENDIF