.586p

include \masm32\projets\_inc\vxd\vxddefs.inc
include \masm32\include\vxd\vwin32.inc
include \masm32\projets\_inc\vxd\wservice.inc

include \masm32\projets\_inc\vxd\desc.inc

include \masm32\projets\_inc\opmac.inc
include \masm32\projets\_inc\vxdcom.inc

include sysacces.inc

;*************************************************************************************************
VxD_LOCKED_DATA_SEG
;*************************************************************************************************
    pDGenProt       dd      ?       ;   ptr on Descriptor General Protection Fault
    pWinGPHandler   dd      ?       ;   zin Handler for General Protection Fault
    pWinPFHandler   dd      ?       ;   zin Handler for Page Fault
;*************************************************************************************************
VxD_LOCKED_DATA_ENDS
;*************************************************************************************************
VxD_LOCKED_CODE_SEG
;*************************************************************************************************

    DECLARE_VIRTUAL_DEVICE SYSACCES,1,1,SYSACCES_control,UNDEFINED_DEVICE_ID,UNDEFINED_INIT_ORDER

    BeginProc   SYSACCES_control
        Control_Dispatch    w32_DeviceIoControl, On_Ioctl
        Control_Dispatch    Sys_Dynamic_Device_Init, On_DeviceInit
        Control_Dispatch    Sys_Dynamic_Device_Exit, On_DeviceExit
        clc
        ret
    EndProc     SYSACCES_control

    BeginProc   SysAccesGPHandler
        ;   ...
        ;   Faulter CS      ;   esp+18h
        ;   Faulter EIP     ;   esp+14h
        ;   Error Code      ;   esp+10h
        ;   WinHandler      ;   esp+0Ch
        ;   flags           ;   esp+08h
        ;   ds              ;   esp+04h
        ;   eax             ;   esp+00h

        push    eax
        pushfd
        push    ds
        push    eax

        ;   initialize data segment
        mov     eax,WIN32_VXD_DATA_SEG
        mov     ds,eax

        ;   check if SysAcces cause fault
        lea     eax,PageFaultIsHere
        cmp     eax,[esp+14h]                   ;   faulter EIP / Flat, we don't check CS
        jne     CallZinGPHandler

        ;   it is SysAcces, corrige fault
        sti
        lea     eax,Ioctl_InvalidParameter
        mov     [esp+14h],eax                   ;   change SysAcces EIP
        add     esp,5*4                         ;   clean stack
        iretd                                   ;   return to interrupted prog

    CallZinGPHandler:
        ;   it isn't SysAcces, return to WinHandler

        mov     eax,pWinGPHandler
        mov     [esp+0Ch],eax

        pop     eax
        pop     ds
        popfd
        ret
    EndProc     SysAccesGPHandler

    BeginProc   SysAccesPFHandler
        push    eax
        pushfd
        push    ds
        push    eax

        ;   initialize data segment
        mov     eax,WIN32_VXD_DATA_SEG
        mov     ds,eax

        ;   check if SysAcces cause fault
        lea     eax,PageFaultIsHere
        cmp     eax,[esp+14h]                   ;   faulter EIP / Flat, we don't check CS
        jne     CallZinPFHandler

        ;   it is SysAcces, corrige fault
        sti
        lea     eax,Ioctl_NotExist
        mov     [esp+14h],eax                   ;   change SysAcces EIP
        add     esp,5*4                         ;   clean stack
        iretd                                   ;   return to interrupted prog

    CallZinPFHandler:
        ;   it isn't SysAcces, return to WinHandler

        mov     eax,pWinPFHandler
        mov     [esp+0Ch],eax

        pop     eax
        pop     ds
        popfd
        ret
    EndProc     SysAccesPFHandler

    BeginProc   On_DeviceExit
        ;   restaure previous Handlers
        mov     eax,pWinGPHandler
        mov     edx,pWinPFHandler
        mov     esi,pDGenProt
        cli
        mov     [esi],ax
        mov     [esi+8],dx
        shr     eax,16
        shr     edx,16
        mov     [esi+6],ax
        mov     [esi+8+6],dx
        sti
        clc
        ret
    EndProc     On_DeviceExit

    BeginProc   On_Ioctl
        ASSUME  esi:PTR DIOCParams
        mov     eax,[esi].dwIoControlCode
    
        and     eax,eax
        je      Ioctl_Open
    
        mov     edi,[esi].lpvOutBuffer
        mov     ecx,[esi].cbOutBuffer
        mov     ebx,[esi].lpcbBytesReturned
        mov     edx,[esi].lpvInBuffer
    
        and     edi,edi
        je      Ioctl_InvalidParameter
        and     ebx,ebx
        je      Ioctl_InvalidParameter
    
        cmp     ecx,6
        jb      Ioctl_BufferTooSmall
    
        cmp     eax,LIST_VXDNAMES
        je      Ioctl_ListVxDs
        cmp     eax,LIST_THREADS
        je      Ioctl_ListThreads
        cmp     eax,GET_IDT
        je      Ioctl_GetIDT
        cmp     eax,GET_GDT
        jz      Ioctl_GetGDT
    
        and     edx,edx
        je      Ioctl_InvalidParameter
    
        cmp     eax,GET_DUMP
        je      Ioctl_GetDump
        cmp     eax,GET_LDT
        je      Ioctl_GetLDT
        cmp     eax,GET_VXDBYNAME
        je      Ioctl_GetVxDByName
        cmp     eax,GET_THREADCONTEXT
        je      Ioctl_GetThreadContext
    
        return  UNKNOW_COMMAND
    
    Ioctl_Open:    
        RETZ
    
    Ioctl_GetGDT:
        sgdt    pf[edi]
        jmp     Ioctl_CopyDT
    
    Ioctl_GetIDT:
        sidt    pf[edi]
        jmp     Ioctl_CopyDT
    
    Ioctl_GetLDT:
        cmp     [esi].cbInBuffer,4
        jne     Ioctl_InvalidParameter
    
        ASSUME  edi:PTR DTR
        sgdt    pf[edi]
        mov     eax,[edx]
        movzx   edx,[edi].lim
        inc     edx
        shr     edx,3
        
        cmp     eax,edx
        ja      Ioctl_InvalidParameter
        
        mov     edx,[edi].p
        lea     edx,[edx+eax*8]
        
        mov     eax,[edx+4]
        shr     eax,8
        and     al,1Fh
        
        cmp     al,2
        jne     Ioctl_InvalidParameter
    
        mov     eax,[edx]
        mov     edx,[edx+4]
        mov     [edi].lim,ax
        mov     al,dl
        shr     edx,16
        mov     ah,dh
        rol     eax,16
        mov     [edi].p,eax
    
    Ioctl_CopyDT:
        movzx   edx,[edi].lim
        mov     eax,edx
        add     edx,SIZEOF DTR+1
        inc     eax
        
        cmp     ecx,edx
        jb      Ioctl_BufferTooSmall
    
        shr     eax,2
        mov     esi,[edi].p
        mov     ecx,eax
        add     edi,SIZEOF DTR
        ASSUME  edi:NOTHING
        rep     movsd
        mov     [ebx],edx
        RETZ
    
    Ioctl_ListVxDs:
        sub     ecx,4
        shr     ecx,3                                   ;   ecx = nbVxDLogeable
        je      Ioctl_BufferTooSmall
    
        VMMCall VMM_GetDDBList
    
        xor     edx,edx

        and     eax,eax
        je      Ioctl_NotExist

        push    edi
        add     edi,4
        
    @@:
        mov     esi,eax
        mov     eax,pd[esi+0Ch]
        push    pd[esi+10h]
        stosd
        pop     eax
        stosd
        lodsd
        inc     edx
        and     eax,eax
        loopnz  @B
    
        pop     edi
        mov     [edi],edx
        shl     edx,3
        mov     [ebx],edx
        and     eax,eax
        jne     Ioctl_BufferTooSmall
        ret    
    
    Ioctl_GetVxDByName:
        cmp     [esi].cbInBuffer,8
        jne     Ioctl_InvalidParameter
    
        cmp     ecx,SIZEOF VXDBYNAME
        jb      Ioctl_BufferTooSmall
    
        VMMCall VMM_GetDDBList
    
    @@:
        mov     esi,eax
        and     eax,eax
        je      Ioctl_NotExist
        mov     eax,pd[esi+0Ch]
        mov     ecx,pd[esi+10h]
        cmp     eax,[edx]
        lodsd
        jne     @B
        cmp     ecx,[edx+4]
        jne     @B
        
        mov     ecx,((SIZEOF VXDBYNAME) SHR 2)
        rep     movsd
        mov     pd[ebx],SIZEOF VXDBYNAME
        RETZ            

    Ioctl_ListThreads:
        sub     ecx,4
        shr     ecx,2                                   ;   ecx = nb Handles Logeable
        je      Ioctl_BufferTooSmall

        push    edi                                     ;   lpvOutBuffer
        push    edi                                     ;   Cur thread handle ( in 3 line )

        VMMCall Get_Cur_Thread_Handle

        mov     eax,edi                                 ;   eax = Thread Handle
        xchg    edi,[esp]                               ;   edi = lpvOutBuffer, [esp] = Current Thread Handle
        xor     edx,edx
        add     edi,4
        mov     esi,eax

    @@:
        stosd                                           ;   copy ThreadHandle
        inc     edx
        xchg    esi,edi                                 ;   esi = lpvOutBuffer, edi = Thread Handle
        VMMCall Get_Next_Thread_Handle
        cmp     edi,[esp]
        mov     eax,edi
        xchg    edi,esi
        loopne  @B

        pop     ecx                                     ;   ecx = Cur Thread Handle
        pop     edi                                     ;   edi = lpvOutBuffer

        mov     [edi],edx

        inc     edx
        shl     edx,2

        cmp     ecx,eax
        mov     [ebx],edx
        jne     Ioctl_BufferTooSmall
        RETZ

    Ioctl_GetThreadContext:
        cmp     [esi].cbInBuffer,4
        jne     Ioctl_InvalidParameter
        cmp     ecx,SIZEOF CONTEXT
        jb      Ioctl_BufferTooSmall

        mov     edx,[edx]
        xchg    edx,edi
        
        VMMCall Validate_Thread_Handle
        jc      Ioctl_NotExist

        xchg    edx,edi

        mov     esi,[edx+10h]

        mov     ecx,( ( SIZEOF SA_CONTEXT ) SHR 2 )
        rep     movsd

        mov     pd[ebx],SIZEOF SA_CONTEXT
        RETZ
        
    Ioctl_GetDump:
        cmp     [esi].cbInBuffer,4
        jne     Ioctl_InvalidParameter
    
        mov     esi,pd[edx]
        mov     eax,4096
    
        cmp     ecx,eax
        jb      Ioctl_BufferTooSmall
        
        shr     eax,2
        mov     ecx,eax
    PageFaultIsHere:
        rep     movsd
        mov     pd[ebx],4096
        RETZ

    Ioctl_InternalError:
        return  INTERNAL_ERROR
    Ioctl_NotExist:
        return  NOT_EXIST
    Ioctl_AlreadyExist:
        return  ALREADY_EXIST
    Ioctl_InvalidParameter:
        return  INVALID_PARAMETER
    Ioctl_BufferTooSmall:
        return  BUFFER_TOO_SMALL
    
        ASSUME  esi:NOTHING
    EndProc     On_Ioctl
    
;*************************************************************************************************
VxD_LOCKED_CODE_ENDS
;*************************************************************************************************
VxD_INIT_CODE_SEG
;*************************************************************************************************

    IDTR_win:
        dw      ?
        dd      ?
        
    BeginProc   On_DeviceInit

        ;   get ptr on General Protection Fault descriptor
        lea     esi,IDTR_win
        sidt    pf[esi]
        mov     esi,pd[esi+2]
        lea     edi,[esi+13*8]
        mov     pDGenProt,edi

        ;   save old pGPHandler

        mov     ax,[edi+6]
        mov     dx,[edi]
        shl     eax,16
        mov     ax,dx
        mov     pWinGPHandler,eax

        ;   save old pPFHandler
        
        mov     ax,[edi+8+6]
        mov     dx,[edi+8]
        shl     eax,16
        mov     ax,dx
        mov     pWinPFHandler,eax

        ;   install SysAcces Handlers

        lea     eax,SysAccesGPHandler
        lea     edx,SysAccesPFHandler

        cli
        mov     [edi],ax
        mov     [edi+8],dx
        shr     eax,16
        shr     edx,16
        mov     [edi+6],ax
        mov     [edi+8+6],dx
        sti
        
        clc
        ret
    EndProc     On_DeviceInit

;*************************************************************************************************
VxD_INIT_CODE_ENDS
;*************************************************************************************************

end