VXDBYNAME       STRUCT
    DDB_SDK_Version         dw  ?
    DDB_Req_Device_Number   dw  ?
    DDB_Dev_Major_Version   db  ?
    DDB_Dev_Minor_Version   db  ?
    DDB_Flags               dw  ?
    DDB_Name                db  8 dup(?)
    DDB_Init_Order          dd  ?
    DDB_Control_Proc        dd  ?
    DDB_V86_API_Proc        dd  ?
    DDB_PM_API_Proc         dd  ?
    DDB_V86_API_CSIP        dd  ?
    DDB_PM_API_CSIP         dd  ?
    DDB_Reference_Data      dd  ?
    DDB_Service_Table_Ptr   dd  ?
    DDB_Service_Table_Size  dd  ?
VXDBYNAME       ENDS

SA_CONTEXT      STRUCT
    regEDI      dd      ?
    regESI      dd      ?
    regEBP      dd      ?
    pCtrl       dd      ?
    regEBX      dd      ?
    regEDX      dd      ?
    regECX      dd      ?
    regEAX      dd      ?
    unk0        dd      ?
    regEIP      dd      ?
    seg00       dd      ?
    regFLAG     dd      ?               ;   must be verified
    regESP      dd      ?
    seg02       dd      ?
    seg03       dd      ?
    seg04       dd      ?
    tUnk        dd      20      dup(?)
SA_CONTEXT      ENDS

GET_GDT             EQU     10h
GET_LDT             EQU     11h
GET_IDT             EQU     12h

LIST_VXDNAMES       EQU     20h
GET_VXDBYNAME       EQU     21h

LIST_THREADS        EQU     28h
GET_THREADCONTEXT   EQU     29h

GET_DUMP            EQU     30h

IFNDEF  _WAPPDEFS_INC

SIZE_OF_80387_REGISTERS   equ 50h

FLOATING_SAVE_AREA STRUCT
  ControlWord   DWORD      ?                            ;   +1Ch
  StatusWord    DWORD      ?                            ;   +20h
  TagWord       DWORD      ?                            ;   +24h
  ErrorOffset   DWORD      ?                            ;   +28h
  ErrorSelector DWORD      ?                            ;   +2Ch
  DataOffset    DWORD      ?                            ;   +30h
  DataSelector  DWORD      ?                            ;   +34h
  RegisterArea  BYTE  SIZE_OF_80387_REGISTERS dup(?)    ;   +38h
  Cr0NpxState   DWORD      ?                            ;   +88h
FLOATING_SAVE_AREA ENDS

CONTEXT_CONTROL             equ 01h
CONTEXT_INTEGER             equ 02h
CONTEXT_SEGMENTS            equ 04h
CONTEXT_FLOATING_POINT      equ 08h
CONTEXT_DEBUG_REGISTERS     equ 10h
CONTEXT_EX_REGISTERS        equ 20h

MAXIMUM_SUPPORTED_EXTENSION          equ 512

CONTEXT STRUCT
  ContextFlags  DWORD      ?                ;   +00h
  iDr0          DWORD      ?                ;   +04h
  iDr1          DWORD      ?                ;   +08h
  iDr2          DWORD      ?                ;   +0Ch
  iDr3          DWORD      ?                ;   +10h
  iDr6          DWORD      ?                ;   +14h
  iDr7          DWORD      ?                ;   +18h
  
  FloatSave     FLOATING_SAVE_AREA <>       ;   +1Ch
  
  regGs         DWORD      ?                ;   +8Ch
  regFs         DWORD      ?                ;   +90h
  regEs         DWORD      ?                ;   +94h
  regDs         DWORD      ?                ;   +98h
  
  regEdi        DWORD      ?                ;   +9Ch
  regEsi        DWORD      ?                ;   +A0h
  regEbx        DWORD      ?                ;   +A4h
  regEdx        DWORD      ?                ;   +A8h
  regEcx        DWORD      ?                ;   +ACh
  regEax        DWORD      ?                ;   +B0h
  regEbp        DWORD      ?                ;   +B4h
  regEip        DWORD      ?                ;   +B8h
  
  regCs         DWORD      ?                ;   +BCh
  regFlag       DWORD      ?                ;   +C0h
  
  regEsp        DWORD      ?                ;   +C4h
  regSs         DWORD      ?                ;   +C8h
  ExtendedRegisters db MAXIMUM_SUPPORTED_EXTENSION dup(?)
CONTEXT ENDS

ENDIF