include \masm32\projets\_inc\wappdefs.inc

include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
include \masm32\include\comctl32.inc
include \masm32\include\gdi32.inc

includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib
includelib \masm32\lib\comctl32.lib
includelib \masm32\lib\gdi32.lib

include \masm32\projets\_inc\string.inc
include \masm32\projets\_inc\vxdcom.inc
include \masm32\projets\_inc\opmac.inc
include \masm32\projets\_inc\heap.inc
include \masm32\projets\_inc\mapf.inc
include .\sysacces\sysacces.inc

STAT_STYLE      EQU     WS_CHILD+WS_VISIBLE
TAB_STYLE       EQU     WS_CHILD+WS_VISIBLE+TCS_RIGHTJUSTIFY
LV_STYLE        EQU     WS_CHILD+LVS_REPORT+LVS_NOSORTHEADER
ED_STYLE        EQU     WS_CHILD+ES_RIGHT
BT_STYLE        EQU     WS_CHILD+BS_TEXT+BS_VCENTER+BS_CENTER+BS_PUSHBUTTON
EDML_STYLE      EQU     WS_CHILD+ES_MULTILINE+ES_LEFT+ES_AUTOVSCROLL+ES_READONLY
CB_STYLE        EQU     WS_CHILD+CBS_DROPDOWN+CBS_HASSTRINGS

IDC_STATUS      EQU     2000h
IDC_TAB         EQU     2010h
IDC_LVDT        EQU     2020h
IDC_LVVXD       EQU     2030h
IDC_EDVXD1      EQU     2031h
IDC_EDTHREAD    EQU     2032h
IDC_LVDUMP      EQU     2040h
IDC_CBDUMP      EQU     2041h
IDC_BTPREV      EQU     2042h
IDC_BTNEXT      EQU     2043h
IDC_BTDAS       EQU     2044h
IDC_EDABOUT     EQU     2050h

TAB_PAGE_NB     EQU     7
TAB_PAGE_VXD    EQU     3
TAB_PAGE_THREAD EQU     4

;**************************************************************************
.data

SelLDT      dd  0
DumpBase    dd  0

azGDT       db  "GDT",0
azLDT       db  "LDT",0
azIDT       db  "IDT",0

tDescTy     dd  descTy00,descTy01,descTy02,descTy03,descTy04,descTy05,descTy06,descTy07
            dd  descTy00,descTy09,descTy00,descTy0B,descTy0C,descTy00,descTy0E,descTy0F
            dd  descTy10,descTy11,descTy12,descTy13,descTy14,descTy15,descTy16,descTy17
            dd  descTy18,descTy19,descTy1A,descTy1B,descTy1C,descTy1D,descTy1E,descTy1F

azErrHeap   db  "Erreur Heap"
fmtErrVxD   db  "Erreur VxD code:%lX",0

descTy00    db  "sys null",0
descTy01    db  "sys 286 TSS available",0
descTy02    db  "sys local descriptor table",0
descTy03    db  "sys 286 TSS busy",0
descTy04    db  "sys 286 call gate",0
descTy05    db  "sys task gate",0
descTy06    db  "sys 286 interrupt gate",0
descTy07    db  "sys 286 trap gate",0
descTy09    db  "sys 386 TSS available",0
descTy0B    db  "sys 386 TSS busy",0
descTy0C    db  "sys 386 call gate",0
descTy0E    db  "sys 386 interrupt gate",0
descTy0F    db  "sys 386 trap gate",0
descTy10    db  "data read only",0
descTy11    db  "data read only acces",0
descTy12    db  "data read/write",0
descTy13    db  "data read/write acces",0
descTy14    db  "data read only exp dwn",0
descTy15    db  "data read only exp dwn acces",0
descTy16    db  "data read/write exp dwn",0
descTy17    db  "data read/write exp dwn acces",0
descTy18    db  "code exec only",0
descTy19    db  "code exec only acces",0
descTy1A    db  "code exec/read",0
descTy1B    db  "code exec/read acces",0
descTy1C    db  "code exec only conforming",0
descTy1D    db  "code exec only conforming acces",0
descTy1E    db  "code exec/read conforming",0
descTy1F    db  "code exec/read conforming acces",0

cvtA2H      db  "0123456789ABCDEF"
fmtDD       db  "%lX",0
fmtDDZ      db  "%0.8lX",0
fmtDQ       db  "%lX%0.8lX",0
fmtDQZ      db  "%0.8lX%0.8lX",0

fmtDDB      db  "%s v%ld.%ld",CRLF,CRLF
            db  "Device Id",TAB,TAB,":%0.4lX",CRLF
            db  "Init Order",TAB,TAB,":%0.8lX",CRLF
            db  "DDK version",TAB,":%ld.%ld",CRLF,CRLF

            db  "Control Proc",TAB,":%0.8lX",CRLF
            db  "V86_API_Proc",TAB,":%0.8lX",CRLF
            db  "PM_API_Proc",TAB,":%0.8lX",CRLF
            db  "V86_API_CSIP",TAB,":%0.8lX",CRLF
            db  "PM_API_CSIP",TAB,":%0.8lX",CRLF,CRLF

            db  "Ref Data",TAB,TAB,":%0.8lX",CRLF,CRLF
            db  "nb Services",TAB,":%ld",CRLF
            db  "Table offset",TAB,":%0.8lX",0

fmtContext  db  "Registres Generaux:",CRLF
            db  "  eax",TAB,":%0.8lX",CRLF
            db  "  ecx",TAB,":%0.8lX",CRLF
            db  "  edx",TAB,":%0.8lX",CRLF
            db  "  ebx",TAB,":%0.8lX",CRLF
            db  "  esp",TAB,":%0.8lX",CRLF
            db  "  ebp",TAB,":%0.8lX",CRLF
            db  "  esi",TAB,":%0.8lX",CRLF
            db  "  edi",TAB,":%0.8lX",CRLF,CRLF

            db  "  eip",TAB,":%0.8lX",CRLF
            db  "  flags",TAB,":%0.8lX",CRLF,CRLF,0

            db  "Segments:",CRLF
            db  "  ss",TAB,":%0.4lX",CRLF
            db  "  cs",TAB,":%0.4lX",CRLF
            db  "  es",TAB,":%0.4lX",CRLF
            db  "  ds",TAB,":%0.4lX",CRLF
            db  "  fs",TAB,":%0.4lX",CRLF
            db  "  gs",TAB,":%0.4lX",CRLF,CRLF,0


azSysAccesDest  db  "\"
azSysAccesSrc   db  "sysacces.vxd",0
azFileExist     db  "A SysAcces.vxd file already Exist on your System",CRLF
                db  "Do you want to replace it ?",0


;**************************************************************************
.data?
hInstance   dd      ?
hVxD        dd      ?
hFont       dd      ?

hwMain      dd      ?
hwTabC      dd      ?
hwStatus    dd      ?
hwLVDT      dd      ?
hwLVVxD     dd      ?
hwEdVxD1    dd      ?
hwEdThread  dd      ?
hwLVDump    dd      ?
hwCbDump    dd      ?
hwBtPrev    dd      ?
hwBtNext    dd      ?
hwBtDas     dd      ?
hwEdAbout   dd      ?

pOldCbEdProc  dd      ?

wc          WNDCLASSEX  <>
msg         MSG         <>
heap        HEAP        <>
lvi         LV_ITEM     <>
OptionsMapf LABEL   MAPF
AboutMapf   MAPF        <>              ; this struct can be reuse only after WM_CREATE

azSysDir    db  MAX_PATH    dup(?)
Buff        db      512     dup(?)

;**************************************************************************
.code
start:
    ASCIIZ  azSysAcces,"\\.\Sysacces.vxd"
    ASCIIZ  azOnlyOne,"OnlyOneSysView"
    DECLARE hMutex,DWORD

    invoke  GetModuleHandle,0
    mov     hInstance,eax

    invoke  CreateMutex,0,TRUE,@ azOnlyOne
    mov     hMutex,eax
    call GetLastError
    push    0
    .IF eax != ERROR_ALREADY_EXISTS

        lea     ebx,azSysDir

        invoke  GetSystemDirectory,ebx,MAX_PATH
        invoke  lstrcat,ebx,@ azSysAccesDest
    
        invoke  CopyFile,@ azSysAccesSrc,ebx,TRUE
        .IF     !eax
            invoke  MessageBox,NULL,@ azFileExist,NULL,MB_YESNO+MB_ICONQUESTION
            .IF     eax == IDNO
                invoke  ExitProcess,0
            .ENDIF
            invoke  CopyFile,@ azSysAccesSrc,ebx,FALSE
        .ENDIF

        mov     [esp],ebx
    .ENDIF
    
    invoke  CreateFile,@ azSysAcces,0,0,0,0,FILE_FLAG_DELETE_ON_CLOSE,0
    inc     eax
    .IF     !ZERO?
        dec     eax
        mov     hVxD,eax
        MAKE_PROCESS_HEAP   heap,2000h
        and     eax,eax
        .IF     !ZERO?
            call    main
            FREE_HEAP   heap
        .ELSE
            OUTTXT  "Impossible de creer le Heap"
        .ENDIF
        invoke  CloseHandle,hVxD
    .ELSE
        OUTTXT  "Impossible d'ouvrir SysAcces.vxd"
    .ENDIF
    pop     ebx
    .IF     ebx
        invoke  DeleteFile,ebx
    .ENDIF
    invoke  ExitProcess,0
    call    InitCommonControls

;**************************************************************************

MakeTabCtrl proc
    LOCAL   tcih:TC_ITEMHEADER

    ASCIIZ  azThread,"Threads"
    ASCIIZ  azVxD,"VxDs"
    ASCIIZ  azDump,"DUMP"
    ASCIIZ  azAbout,"ABOUT"

    push    esi
    mov     tcih.imask,TCIF_TEXT

    push    @ azAbout
    push    @ azDump
    push    @ azThread
    push    @ azVxD
    push    @ azIDT
    push    @ azLDT
    push    @ azGDT
    xor     esi,esi

    .REPEAT
        pop     tcih.pszText
        invoke  SendMessage,hwTabC,TCM_INSERTITEM,esi,ADDR tcih
        inc     esi
    .UNTIL  esi == TAB_PAGE_NB

    pop     esi
    ret
MakeTabCtrl endp

MakeLVDT    proc
    LOCAL   lvc:LV_COLUMN

    invoke  SendMessage,hwLVDT,WM_SETFONT,hFont,0

    ASCIIZ  azId,"Id"
    ASCIIZ  azVal,"Valeur"
    ASCIIZ  azType,"Type"
    ASCIIZ  azDPL,"DPL"
    ASCIIZ  azDomain,"Domain"

    push    esi
    mov     lvc.imask,LVCF_TEXT+LVCF_WIDTH

    push    @ azDomain
    push    170
    push    @ azDPL
    push    30
    push    @ azType
    push    200
    push    @ azVal
    push    110
    push    @ azId
    push    30

    xor     esi,esi

    .REPEAT
        pop     lvc.lx
        pop     lvc.pszText
        invoke  SendMessage,hwLVDT,LVM_INSERTCOLUMN,esi,ADDR lvc
        inc     esi
    .UNTIL  esi == 5    

    pop     esi
    ret
MakeLVDT    endp

MakeLVVxD   proc
    LOCAL   lvc:LV_COLUMN

    ASCIIZ  azVxDName,"Name"

    mov     lvc.imask,LVCF_TEXT+LVCF_WIDTH
    mov     lvc.lx,100
    mov     lvc.pszText,@ azVxDName

    invoke  SendMessage,hwLVVxD,LVM_INSERTCOLUMN,0,ADDR lvc
    
    ret
MakeLVVxD   endp

MakeLVDump  proc
    LOCAL   lvc:LV_COLUMN

    invoke  SendMessage,hwLVDump,WM_SETFONT,hFont,0

    ASCIIZ  azAddr,"Address"
    ASCIIZ  azHexa,"Hexadecimal"
    ASCIIZ  azAscii,"ASCII"

    push    esi
    mov     lvc.imask,LVCF_TEXT+LVCF_WIDTH

    push    @ azAscii
    push    110
    push    @ azHexa
    push    300
    push    @ azAddr
    push    60

    xor     esi,esi

    .REPEAT
        pop     lvc.lx
        pop     lvc.pszText
        invoke  SendMessage,hwLVDump,LVM_INSERTCOLUMN,esi,ADDR lvc
        inc     esi
    .UNTIL  esi == 3    

    pop     esi    
    ret
MakeLVDump  endp

;**************************************************************************

GetDT       proc    DT_ID:DWORD
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD
    LOCAL   lnbD:DWORD

    ASCIIZ  fmtDT,"%sR = %0.4lX:%0.8lX"

    push    esi
    push    edi

    lea     edi,Buff

GetDT_CallVxD:
    mov     edx,GET_GDT
    add     edx,DT_ID
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,edx,@ SelLDT,4,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     GetDT_CallVxD
            mov     edi,@ azErrHeap
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    push    ebx
    push    hwLVDT
    pop     hwLV

    lodsw
    movzx   ebx,ax
    lodsd
    push    ebx
    push    eax
    
    invoke  SendMessage,hwLV,LVM_GETITEMCOUNT,0,0
    and     eax,eax
    .IF     !ZERO?
        invoke  SendMessage,hwLV,LVM_DELETEALLITEMS,0,0
    .ENDIF

    inc     ebx
    shr     ebx,3
    mov     lnbD,ebx
    xor     ebx,ebx
    mov     lvi.pszText,edi
    mov     lvi.iItem,ebx

    .WHILE  ebx < lnbD
        and     lvi.iSubItem,0
        mov     lvi.imask,LVIF_TEXT+LVIF_PARAM
        lodsd
        push    eax
        lodsd
        push    eax
        shr     eax,8
        and     eax,1Fh
        mov     lvi.lParam,eax
        invoke  wsprintf,edi,@ fmtDD,ebx
        invoke  SendMessage,hwLV,LVM_INSERTITEM,0,@ lvi
        inc     lvi.iSubItem
        pop     eax
        pop     edx
        mov     lvi.imask,LVIF_TEXT
        push    edx
        push    eax
        push    eax
        push    eax
        invoke  wsprintf,edi,@ fmtDQZ,eax,edx
        invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
        pop     eax
        and     eax,1F00h
        shr     eax,6
        inc     lvi.iSubItem
        invoke  lstrcpy,edi,pd[tDescTy+eax]
        invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
        pop     eax
        inc     lvi.iSubItem
        and     eax,6000h
        shr     eax,0dh
        invoke  wsprintf,edi,@ fmtDD,eax
        invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
        pop     edx
        pop     ecx
        inc     lvi.iSubItem
        mov     al,dh
        and     al,1Fh
        .IF     al >= 10h || al == 2 || al == 3 || al == 0Bh
            ASCIIZ  fmtDomain,"%0.8lX a %0.8lX"
            mov     eax,edx
            shr     eax,16
            mov     al,dl
            push    ecx
            shl     eax,16
            shr     ecx,16
            or      eax,ecx
            pop     ecx
            push    eax
            and     ecx,0FFFFh
            mov     eax,edx
            and     eax,0F0000h
            or      ecx,eax
            bt      edx,23
            .IF     CARRY?
                shl     ecx,12
                or      ecx,0FFFh
            .ENDIF
            pop     eax
            bt      edx,11
            jc      @F
            bt      edx,10
            jnc     @F
            xchg    eax,ecx
            inc     eax
            add     eax,ecx
            .IF     CARRY?
                or      eax,-1
            .ENDIF
            or      edx,0FFFFFh
            and     edx,4FFFFFh
            btc     edx,22
            .IF     CARRY?
                or      edx,-1
            .ENDIF
            add     edx,ecx
            .IF     CARRY?
                or      edx,-1
            .ENDIF
            mov     ecx,edx
            jmp     @1
        @@:
            add     ecx,eax
            .IF     CARRY?
                or      ecx,-1
            .ENDIF
        @1:
            invoke  wsprintf,edi,@ fmtDomain,eax,ecx
        
        .ELSEIF al == 6 || al == 7 || al == 0Eh || al == 0Fh     ; intr or trap gates
            ASCIIZ  fmtIntrTrapG,"%CDT#%lX:%0.8lX, RPL:%lX"
            push    ebx
            mov     ebx,edx
            mov     bx,cx
            shr     ecx,16
            mov     eax,ecx
            xor     edx,edx
            shr     ecx,3
            and     eax,7
            mov     dl,'G'
            btr     eax,2
            jnb     @F
                mov     dl,'L'
            @@:
            invoke  wsprintf,edi,@ fmtIntrTrapG,edx,ecx,ebx,eax
            pop     ebx

        .ELSEIF al == 5                                         ; task gates
            ASCIIZ  fmtTaskG,"%CDT#%lX, RPL:%lX"
            shr     ecx,10h
            mov     eax,ecx
            xor     edx,edx
            shr     ecx,3
            and     eax,3
            mov     dl,'G'
            btr     eax,2
            jnc     @F
                mov     dl,'L'
            @@:
            invoke  wsprintf,edi,@ fmtTaskG,edx,ecx,eax

        .ELSE
            and     pd[edi],0
        .ENDIF
        invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
        inc     ebx
        inc     lvi.iItem
    .ENDW

    mov     ecx,DT_ID
    pop     eax
    pop     ebx
    lea     ecx,[azGDT+4*ecx]
    invoke  wsprintf,edi,@ fmtDT,ecx,ebx,eax
    invoke  SetDlgItemText,hwMain,IDC_STATUS,edi

    pop     ebx
    pop     edi
    pop     esi
    ret
GetDT       endp

;**************************************************************************

ListVxDNames    proc
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD
    LOCAL   lnbVxD:DWORD

    ASCIIZ  fmtVxDCount,"%ld Drivers VxD trouvs"

    push    esi
    push    edi

    lea     edi,Buff

ListVxDName_CallVxD:
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,LIST_VXDNAMES,0,0,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     ListVxDName_CallVxD
            mov     edi,@ azErrHeap
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    push    ebx
    
    push    hwLVVxD
    pop     hwLV
    lodsd
    mov     lnbVxD,eax
    
    invoke  SendMessage,hwLV,LVM_GETITEMCOUNT,0,0
    and     eax,eax
    .IF     !ZERO?
        invoke  SendMessage,hwLV,LVM_DELETEALLITEMS,0,0
    .ENDIF

    xor     ebx,ebx
    mov     lvi.pszText,edi
    mov     lvi.iItem,ebx
    mov     lvi.iSubItem,ebx
    mov     lvi.imask,LVIF_TEXT

    .WHILE  ebx < lnbVxD
        push    edi
        movsd
        movsd
        and     pd[edi],0
        invoke  SendMessage,hwLV,LVM_INSERTITEM,0,@ lvi
        inc     ebx
        inc     lvi.iItem
        pop     edi
    .ENDW

    invoke  wsprintf,edi,@ fmtVxDCount,lnbVxD
    invoke  SetDlgItemText,hwMain,IDC_STATUS,edi

    pop     ebx
    pop     edi
    pop     esi
    ret
ListVxDNames    endp

;**************************************************************************
GetVxDByName    proc    pName:DWORD
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD

    ASCIIZ  fmtNotFound,"Impossible de trouver %s"

    push    esi
    push    edi

    lea     edi,Buff

GetVxDByName_CallVxD:
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,GET_VXDBYNAME,pName,8,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     GetVxDByName_CallVxD
            mov     edi,@ azErrHeap
        .ELSEIF eax == NOT_EXIST
            invoke  wsprintf,edi,@ fmtNotFound,pName
            invoke  ShowWindow,hwEdVxD1,SW_HIDE
            call    ListVxDNames
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    sub     esp,13*4
    lodsb
    movzx   ecx,al
    lodsb
    movzx   edx,al
    lodsw
    movzx   eax,ax
    mov     [esp+5*4],ecx
    mov     [esp+4*4],edx
    mov     [esp+2*4],eax
    lodsb
    movzx   ecx,al
    lodsb
    movzx   edx,al
    add     esi,10
    lodsd
    mov     [esp+0*4],ecx
    mov     [esp+1*4],edx
    mov     [esp+3*4],eax

    lodsd
    mov     [esp+6*4],eax
    lodsd
    mov     [esp+7*4],eax
    lodsd
    mov     [esp+8*4],eax
    lodsd
    mov     [esp+9*4],eax
    lodsd
    mov     [esp+10*4],eax

    lodsd
    mov     [esp+11*4],eax
    lodsd
    mov     [esp+13*4],eax
    lodsd
    mov     [esp+12*4],eax
    
    push    pName
    push    @ fmtDDB
    push    edi
    call    wsprintf
    add     esp,16*4

    invoke  SetDlgItemText,hwMain,IDC_EDVXD1,edi

    pop     edi
    pop     esi
    ret
GetVxDByName    endp

;**************************************************************************

ListThreads proc
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD
    LOCAL   lnbThread:DWORD

    ASCIIZ  fmtThreadCount,"%ld Threads trouvs"

    push    esi
    push    edi

    lea     edi,Buff

ListThreads_CallVxD:
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,LIST_THREADS,0,0,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     ListThreads_CallVxD
            mov     edi,@ azErrHeap
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    push    ebx
    
    push    hwLVVxD
    pop     hwLV
    lodsd
    mov     lnbThread,eax
    
    invoke  SendMessage,hwLV,LVM_GETITEMCOUNT,0,0
    and     eax,eax
    .IF     !ZERO?
        invoke  SendMessage,hwLV,LVM_DELETEALLITEMS,0,0
    .ENDIF

    xor     ebx,ebx
    mov     lvi.pszText,edi
    mov     lvi.iItem,ebx
    mov     lvi.iSubItem,ebx
    mov     lvi.imask,LVIF_TEXT+LVIF_PARAM

    .WHILE  ebx < lnbThread
        lodsd
        mov     lvi.lParam,eax
        invoke  wsprintf,edi,@ fmtDDZ,eax
        invoke  SendMessage,hwLV,LVM_INSERTITEM,0,@ lvi
        inc     ebx
        inc     lvi.iItem
    .ENDW

    invoke  wsprintf,edi,@ fmtThreadCount,lnbThread
    invoke  SetDlgItemText,hwMain,IDC_STATUS,edi

    pop     ebx
    pop     edi
    pop     esi
    ret
ListThreads    endp

;**************************************************************************

SVGetThreadContext    proc    hTh:DWORD
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD

    ASCIIZ  azNotAcces,"Handle non accessible"

    push    esi
    push    edi

    lea     edi,Buff

GetThreadContext_CallVxD:
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,GET_THREADCONTEXT,ADDR hTh,4,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     GetThreadContext_CallVxD
            mov     edi,@ azErrHeap
        .ELSEIF eax == NOT_EXIST
            invoke  lstrcpy,edi,@ azNotAcces
            invoke  ShowWindow,hwEdThread,SW_HIDE
            call    ListThreads
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    ASSUME  esi : PTR SA_CONTEXT
    push    [esi].regFLAG
    push    [esi].regEIP
    push    [esi].regEDI
    push    [esi].regESI
    push    [esi].regEBP
    push    [esi].regESP
    push    [esi].regEBX
    push    [esi].regEDX
    push    [esi].regECX
    push    [esi].regEAX
    push    @ fmtContext
    push    edi
    call    wsprintf
    add     esp,10*4

    ASSUME  esi : NOTHING

    invoke  SetDlgItemText,hwMain,IDC_EDTHREAD,edi

    pop     edi
    pop     esi
    ret
SVGetThreadContext    endp

;**************************************************************************

GetDump     proc
    LOCAL   lcbRet:DWORD
    LOCAL   hwLV:DWORD
    LOCAL   lcAddr:DWORD

    ASCIIZ  azNotExist,"This address is not present"

    push    esi
    push    edi

    lea     edi,Buff

GetDump_CallVxD:
    mov     esi,heap.p
    invoke  DeviceIoControl,hVxD,GET_DUMP,@ DumpBase,4,esi,heap.cb,ADDR lcbRet,0
    and     eax,eax
    .IF     ZERO?
        call    GetLastError
        .IF     eax == BUFFER_TOO_SMALL
            PAGEGROW_HEAP   heap
            jnc     GetDump_CallVxD
            lea     edi,azErrHeap
        .ELSEIF eax == NOT_EXIST
            test    DumpBase,0fffh
            je      @F
            and     DumpBase,0fffff000h
            jmp     GetDump_CallVxD
            @@:
            invoke  MessageBeep,MB_OK
            lea     edi,azNotExist
        .ELSE
            invoke  wsprintf,edi,@ fmtErrVxD,eax
        .ENDIF
        invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
        pop     edi
        pop     esi
        RETZ
    .ENDIF

    push    ebx
    
    push    DumpBase
    push    hwLVDump
    pop     hwLV
    pop     lcAddr

    invoke  SendMessage,hwLV,LVM_GETITEMCOUNT,0,0
    and     eax,eax
    .IF     !ZERO?
        invoke  SendMessage,hwLV,LVM_DELETEALLITEMS,0,0
    .ENDIF

    lea     ebx,cvtA2H
    mov     lvi.pszText,edi
    and     lvi.iItem,0
    mov     lvi.imask,LVIF_TEXT

GetDump_Loop:
    and     lvi.iSubItem,0
    invoke  wsprintf,edi,@ fmtDDZ,lcAddr
    invoke  SendMessage,hwLV,LVM_INSERTITEM,0,@ lvi
    add     lcAddr,16
    push    16
    inc     lvi.iSubItem
    pop     ecx
    push    edi
    push    esi
    push    edi
@@:
    lodsb
    mov     ah,al
    shr     al,4
    xlat
    stosb
    mov     al,ah
    and     al,0Fh
    xlat
    stosb
    mov     al,20h
    stosb
    loop    @B
    and     pb[edi-1],0    
    invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
    pop     edi
    pop     esi
    push    16
    inc     lvi.iSubItem
    pop     ecx
@@:
    lodsb
    cmp     al,10h
    jae     @2
    mov     al,'.'
@2:
    stosb
    loop    @B
    and     pb[edi],0
    invoke  SendMessage,hwLV,LVM_SETITEM,0,@ lvi
    pop     edi
    inc     lvi.iItem
    sub     lcbRet,16
    ja      GetDump_Loop


    ASCIIZ  fmtDumping,"Dump de %0.8lX a %0.8lX"

    mov     eax,DumpBase
    mov     ebx,eax
    add     eax,4095
    invoke  wsprintf,edi,@ fmtDumping,ebx,eax
    invoke  SetDlgItemText,hwMain,IDC_STATUS,edi
    invoke  wsprintf,edi,@ fmtDD,ebx
    invoke  SetDlgItemText,hwMain,IDC_CBDUMP,edi

    pop     ebx
    pop     edi
    pop     esi
    ret
GetDump     endp

;**************************************************************************

DumpDas     proc        pDump:DWORD, cbDump:DWORD, hFile:DWORD
    LOCAL   lcbRet
    LOCAL   lcbDump

    push    esi
    push    edi
    push    ebx

    mov     esi,pDump
    lea     edi,Buff
    lea     ebx,cvtA2H

    push    cbDump
    pop     lcbDump

    .WHILE  lcbDump
        push    edi

        mov     al,'d'
        stosb
        mov     al,'b'
        stosb
        mov     al,' '
        stosb

        mov     ecx,16

    @@:                                             ;   loc_004012B5:
        mov     al,'0'
        stosb
        lodsb
        mov     ah,al
        shr     al,4
        and     ah,0Fh
        xlat
        stosb
        mov     al,ah
        xlat
        stosb
        mov     al,'h'
        stosb
        mov     al,','
        stosb
        dec     lcbDump
        loopne  @B                                  ;   loc_004012B5

        dec     edi
        mov     al,0Dh
        stosb
        mov     al,0Ah
        stosb
        mov     al,0
        stosb

        pop     edi
        invoke  lstrlen,edi
        mov     edx,eax
        invoke  WriteFile,hFile,edi,edx,ADDR lcbRet,0

    .ENDW

    pop     ebx
    pop     edi
    pop     esi
    ret

DumpDas     endp

;**************************************************************************

.data
fnDas       db  ".\pagedas.asm",0
azProlog    db  ".586",CRLF,".model flat,stdcall",CRLF,"option casemap:none",CRLF,".code",CRLF,"start:",CRLF,0
azEpilog    db  CRLF,"end start",0
fnDasBat    db  "command.com /c .\dasbat.bat",0

azMlBuff    db  128     dup(?)
azLinkBuff  db  128     dup(?)
.code

DisasmPage  proc
    LOCAL   lcbRet:DWORD
    LOCAL   lhFile:DWORD

    invoke  CreateFile,@ fnDas,GENERIC_WRITE,0,0,CREATE_ALWAYS,0,0
    .IF     eax
        mov     lhFile,eax
        invoke  lstrlen,@ azProlog
        mov     edx,eax
        invoke  WriteFile,lhFile,@ azProlog,edx,ADDR lcbRet,0
        invoke  DumpDas,heap.p,4096,lhFile
        invoke  lstrlen,@ azEpilog
        mov     edx,eax
        invoke  WriteFile,lhFile,@ azEpilog,edx,ADDR lcbRet,0


        invoke  WinExec,@ fnDasBat,0
        invoke  CloseHandle,lhFile
    .ENDIF

    ret
DisasmPage  endp

;**************************************************************************

CbEdDumpWndProc   proc    hwCbEd:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    mov     eax,uMsg
    cmp     eax,WM_CHAR
    je      exec_CHAR
    cmp     eax,WM_SETFOCUS
    je      exec_SETFOCUS

exec_OLDPROC:
    invoke  CallWindowProc,pOldCbEdProc,hwCbEd,uMsg,wParam,lParam
    ret

exec_EDNULL:
    RETZ

exec_SETFOCUS:
    push    edi
    lea     edi,Buff
    and     pd[edi],0
    invoke  SendMessage,hwCbEd,WM_SETTEXT,0,edi
    pop     edi
    jmp     exec_OLDPROC

exec_CHAR:
    movzx   eax,pb[wParam]
    cmp     al,16h
    je      exec_OLDPROC
    cmp     al,1Bh                                 ;ESC
    je      exec_ESC
    cmp     al,0Dh
    je      exec_ENTER
    cmp     al,08h
    je      exec_OLDPROC
    .IF     (al >= 30h && al <= 39h) || (al >= 61h && al <= 'f') || (al >= 'A' && al <= 'F')
        .IF     ( al >= 'a' && al <= 'f' )
            sub     al,20h
        .ENDIF
        invoke  CallWindowProc,pOldCbEdProc,hwCbEd,uMsg,eax,lParam
    .ENDIF
    RETZ

exec_ESC:
    push    edi
    lea     edi,Buff
    invoke  wsprintf,edi,@ fmtDD,DumpBase
    invoke  SendMessage,hwCbEd,WM_SETTEXT,0,edi
    pop     edi
    RETZ

exec_ENTER:
    push    esi
    lea     esi,Buff
    invoke  SendMessage,hwCbEd,WM_GETTEXT,9,esi
    push    esi
    xor     edx,edx
    @@:
    lodsb
    and     al,al
    je      @F
    .IF     (al >= '0' && al <= '9') || (al >= 'a' && al <= 'f') || (al >= 'A' && al <= 'F')
        .IF     ( al >= 'a' && al <= 'f' )
            sub     al,20h
        .ENDIF
        rol     edx,4
        sub     al,30h
        cmp     al,9
        jbe     @3
            sub     al,7h
        @3:
        or      dl,al
        jmp     @B
    .ENDIF
    pop     esi
    pop     esi
    jmp     exec_ESC
@@:
    mov     DumpBase,edx
    pop     esi
    invoke  SendMessage,hwCbDump,CB_FINDSTRINGEXACT,-1,esi
    .IF     eax == CB_ERR
        invoke  SendMessage,hwCbDump,CB_ADDSTRING,0,esi
    .ENDIF
    pop     esi
    call    GetDump
    RETZ   

CbEdDumpWndProc   endp

;**************************************************************************

MainWndProc proc    hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

    mov     eax,uMsg

    cmp     eax,WM_NOTIFY
    je      exec_NOTIFY

    cmp     eax,WM_COMMAND
    je      exec_COMMAND

    cmp     eax,WM_DESTROY
    je      exec_DESTROY
    cmp     eax,WM_CREATE
    je      exec_CREATE

exec_DEFAULT:
    invoke DefWindowProc,hWin,uMsg,wParam,lParam
    ret

exec_NULL:
    RETZ

exec_NOTIFY:
    invoke  SendMessage,hwTabC,TCM_GETCURSEL,0,0
    mov     edx,lParam
    ASSUME  edx:PTR NMHDR

    cmp     [edx].code,TCN_SELCHANGING
    je      exec_TAB_SELCHING
    cmp     [edx].code,TCN_SELCHANGE
    je      exec_TAB_SELCHE
    cmp     [edx].code,LVN_ITEMCHANGED
    je      exec_LV_SELCHE

    ASSUME  edx:NOTHING

    jmp     exec_DEFAULT

exec_TAB_SELCHING:
    ASCIIZ  azWorking,"Working..."

    invoke  SetDlgItemText,hWin,IDC_STATUS,@ azWorking
    invoke  ShowWindow,hwLVDT,SW_HIDE
    invoke  ShowWindow,hwLVVxD,SW_HIDE
    invoke  ShowWindow,hwEdVxD1,SW_HIDE
    invoke  ShowWindow,hwLVDump,SW_HIDE
    invoke  ShowWindow,hwCbDump,SW_HIDE
    invoke  ShowWindow,hwBtPrev,SW_HIDE
    invoke  ShowWindow,hwBtNext,SW_HIDE
    invoke  ShowWindow,hwBtDas,SW_HIDE
    invoke  ShowWindow,hwEdAbout,SW_HIDE
    invoke  ShowWindow,hwEdThread,SW_HIDE
    RETZ

exec_TAB_SELCHE:        
    mov     ecx,eax

    and     eax,eax
    je      exec_GETDT
    dec     eax
    je      exec_CHECKLDT
    dec     eax
    je      exec_GETDT
    dec     eax
    je      exec_GETVXD
    dec     eax
    je      exec_GETTHREAD
    dec     eax
    je      exec_GETDUMP
    dec     eax
    je      exec_ABOUT
    RETZ

exec_CHECKLDT:

    ASCIIZ  azNoSelLDT,"Pas de Descripteur LDT selectionn"

    or      SelLDT,0
    jne     exec_GETDT
    invoke  SetDlgItemText,hWin,IDC_STATUS,@ azNoSelLDT
    RETZ

exec_GETDT:
    invoke  GetDT,ecx
    invoke  ShowWindow,hwLVDT,SW_SHOW
    RETZ

exec_GETTHREAD:
    call    ListThreads
    invoke  ShowWindow,hwLVVxD,SW_SHOW
    invoke  ShowWindow,hwEdThread,SW_SHOW
    RETZ

exec_GETVXD:
    call    ListVxDNames
    invoke  ShowWindow,hwLVVxD,SW_SHOW
    invoke  ShowWindow,hwEdVxD1,SW_SHOW
    RETZ

exec_COMMAND:
    movzx   edx,pw[wParam]

    cmp     edx,IDC_BTPREV
    je      exec_BTPREV
    cmp     edx,IDC_BTNEXT
    je      exec_BTNEXT
    cmp     edx,IDC_BTDAS
    je      exec_DAS
    jmp     exec_DEFAULT

exec_DAS:
    call    DisasmPage
    RETZ

exec_BTNEXT:
    add     DumpBase,8192
exec_BTPREV:
    sub     DumpBase,4096
    call    GetDump
    RETZ
exec_GETDUMP:
    call    GetDump
    invoke  ShowWindow,hwBtPrev,SW_SHOW
    invoke  ShowWindow,hwBtDas,SW_SHOW
    invoke  ShowWindow,hwBtNext,SW_SHOW
    invoke  ShowWindow,hwCbDump,SW_SHOW
    invoke  ShowWindow,hwLVDump,SW_SHOW
    RETZ

exec_LV_SELCHE:
    ; check TabCtrl on GDT
    and     eax,eax
    je      exec_SELDT
    cmp     al,TAB_PAGE_VXD
    je      exec_SELVXD
    cmp     al,TAB_PAGE_THREAD
    je      exec_SELTHREAD

    jmp     exec_DEFAULT    

exec_SELDT:
    ASSUME  edx:PTR NM_LISTVIEW
    push    [edx].iItem
    ASSUME  edx:NOTHING
    
    lea     edi,lvi

    ASSUME  edi:PTR LV_ITEM
    pop     [edi].iItem
    mov     [edi].imask,LVIF_PARAM
    and     [edi].iSubItem,0

    invoke  SendMessage,hwLVDT,LVM_GETITEM,0,edi
    mov     eax,lvi.lParam

    .IF     al == 2
        push    [edi].iItem
        pop     SelLDT
    .ENDIF

    ASSUME  edi:NOTHING
    RETZ

exec_SELVXD:
    ASSUME  edx:PTR NM_LISTVIEW
    push    [edx].iItem
    ASSUME  edx:NOTHING
    
    lea     edi,lvi

    ASSUME  edi:PTR LV_ITEM
    pop     [edi].iItem
    mov     [edi].imask,LVIF_TEXT
    mov     [edi].pszText,@ Buff
    mov     [edi].cchTextMax,256
    and     [edi].iSubItem,0

    invoke  SendMessage,hwLVVxD,LVM_GETITEM,0,edi

    invoke  GetVxDByName,[edi].pszText

    ASSUME  edi:NOTHING
    RETZ

exec_SELTHREAD:
    ASSUME  edx:PTR NM_LISTVIEW
    push    [edx].iItem
    ASSUME  edx:NOTHING
    
    lea     edi,lvi

    ASSUME  edi:PTR LV_ITEM
    pop     [edi].iItem
    mov     [edi].imask,LVIF_PARAM
    and     [edi].iSubItem,0

    invoke  SendMessage,hwLVVxD,LVM_GETITEM,0,edi

    invoke  SVGetThreadContext,[edi].lParam

    ASSUME  edi:NOTHING
    RETZ

exec_ABOUT:
    ASCIIZ  azAboutPg,"About Page"
    invoke  SetDlgItemText,hWin,IDC_STATUS,@ azAboutPg
    invoke  ShowWindow,hwEdAbout,SW_SHOW
    RETZ

exec_CREATE:
    ASCIIZ  cn_Button,"BUTTON"
    ASCIIZ  cn_Edit,"EDIT"
    ASCIIZ  cn_Combo,"COMBOBOX"
    ASCIIZ  cn_TabCtrl,"SysTabControl32"
    ASCIIZ  cn_ListView,"SysListView32"
    ASCIIZ  azBtPrev,"<<"
    ASCIIZ  azBtNext,">>"
    ASCIIZ  azBtDas,"Disasm"
    
    m2m     hwMain,hWin

    invoke  CreateFont,-12,-6,0,0,0,0,0,0,DEFAULT_CHARSET,0,0,0,FIXED_PITCH,0
    mov     hFont,eax

    invoke  CreateWindowEx,0,@ cn_TabCtrl,0,\
                           TAB_STYLE,\
                           0,0,582,302,\
                           hWin,IDC_TAB,hInstance,0
    mov     hwTabC,eax
    call    MakeTabCtrl

    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_ListView,0,\
                           LV_STYLE+WS_VISIBLE,\
                           10,30,560,260,\
                           hWin,IDC_LVDT,hInstance,0
    mov     hwLVDT,eax
    call    MakeLVDT

    invoke  CreateWindowEx,0,@ cn_Edit,0,\
                           EDML_STYLE+WS_VSCROLL,\
                           140,30,280,260,\
                           hWin,IDC_EDTHREAD,hInstance,0
    mov     hwEdThread,eax
    invoke  CreateWindowEx,0,@ cn_Edit,0,\
                           EDML_STYLE,\
                           140,30,280,260,\
                           hWin,IDC_EDVXD1,hInstance,0
    mov     hwEdVxD1,eax
    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_ListView,0,\
                           LV_STYLE+LVS_SORTASCENDING,\
                           10,30,120,260,\
                           hWin,IDC_LVVXD,hInstance,0
    mov     hwLVVxD,eax
    call    MakeLVVxD

    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_Button,@ azBtDas,\
                           BT_STYLE,\
                           455,34,80,20,\
                           hWin,IDC_BTDAS,hInstance,0
    mov     hwBtDas,eax
    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_Button,@ azBtPrev,\
                           BT_STYLE,\
                           45,32,80,20,\
                           hWin,IDC_BTPREV,hInstance,0
    mov     hwBtPrev,eax
    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_Combo,0,\
                           CB_STYLE,\
                           134,30,94,100,\
                           hWin,IDC_CBDUMP,hInstance,0
    mov     hwCbDump,eax
    invoke  GetWindow,eax,GW_CHILD
    invoke  SetWindowLong,eax,GWL_WNDPROC,ADDR CbEdDumpWndProc
    mov     pOldCbEdProc,eax
    invoke  SendMessage,hwCbDump,CB_LIMITTEXT,8,0
    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_Button,@ azBtNext,\
                           BT_STYLE,\
                           245,32,70,20,\
                           hWin,IDC_BTNEXT,hInstance,0
    mov     hwBtNext,eax
    invoke  CreateWindowEx,WS_EX_CLIENTEDGE,@ cn_ListView,0,\
                           LV_STYLE,\
                           45,60,490,230,\
                           hWin,IDC_LVDUMP,hInstance,0
    mov     hwLVDump,eax
    call    MakeLVDump

    invoke  CreateStatusWindow,STAT_STYLE,0,hWin,IDC_STATUS    
    mov     hwStatus,eax

    MAKE_MAPFILE    AboutMapf,".\Readme.txt"
    mov     esi,AboutMapf.p
    mov     eax,AboutMapf.cb
    and     pb[esi+eax-1],0

    invoke  CreateWindowEx,0,@ cn_Edit,esi,\
                           EDML_STYLE+WS_VSCROLL,\
                           10,30,570,260,\
                           hWin,IDC_EDABOUT,hInstance,0
    mov     hwEdAbout,eax

    FREE_MAPFILE    AboutMapf

    invoke  GetDT,0
    RETZ
    
exec_DESTROY:
    invoke  DeleteObject,hFont
    invoke  PostQuitMessage,0
    RETZ
MainWndProc endp

;**************************************************************************

main:
    ASCIIZ  cn_Main,"SysViewClass"
    ASCIIZ  wn_Main,"SysView from abragols@aol.com"
    
    lea     edi,wc
    ASSUME  edi:PTR WNDCLASSEX

    mov     [edi].cbSize,SIZEOF WNDCLASSEX
    mov     [edi].style, CS_HREDRAW or CS_VREDRAW
    mov     [edi].lpfnWndProc, @ MainWndProc
    and     [edi].cbClsExtra,0
    and     [edi].cbWndExtra,0
    m2m     [edi].hInstance,hInstance
    mov     [edi].hbrBackground,COLOR_APPWORKSPACE
    and     [edi].lpszMenuName,0
    mov     [edi].lpszClassName,@ cn_Main
    invoke  LoadIcon,hInstance,500
    mov     [edi].hIcon,eax
    mov     [edi].hIconSm,eax
    invoke  LoadCursor,NULL,IDC_ARROW
    mov     [edi].hCursor,eax

    ASSUME  edi:NOTHING

    invoke  RegisterClassEx,edi

    invoke  CreateWindowEx,WS_EX_DLGMODALFRAME,@ cn_Main,@ wn_Main,\
                           WS_CAPTION+WS_SYSMENU+WS_VISIBLE+WS_MINIMIZEBOX,\
                           CW_USEDEFAULT,CW_USEDEFAULT,590,350,\
                           0,0,hInstance,0

    .WHILE  TRUE
        invoke  GetMessage, @ msg,NULL,0,0
        .BREAK  .IF (!eax)
        invoke  TranslateMessage,@ msg
        invoke  DispatchMessage, @ msg
    .ENDW
    
    ret

end start