
// __________________________________________________________
//
//                          NtDll.h
//          Header File for ntdll.dll Clients V1.01
//                11-15-1998 Sven B. Schreiber
//                       sbs@orgon.com
// __________________________________________________________

#ifndef _NTDLL_H_
#define _NTDLL_H_

// =================================================================
// DISCLAIMER
// =================================================================

/*

This software is provided "as is" and any express or implied
warranties, including, but not limited to, the implied warranties of
merchantibility and fitness for a particular purpose are disclaimed.
In no event shall the author Sven B. Schreiber be liable for any
direct, indirect, incidental, special, exemplary, or consequential
damages (including, but not limited to, procurement of substitute
goods or services; loss of use, data, or profits; or business
interruption) however caused and on any theory of liability,
whether in contract, strict liability, or tort (including negligence
or otherwise) arising in any way out of the use of this software,
even if advised of the possibility of such damage.

*/

// =================================================================
// REVISION HISTORY
// =================================================================

/*

07-19-1998 V1.00 Original version (SBS).

    Basic support for Microsoft's NetWare redirector.

11-15-1998 V1.01 Update (SBS).

    Lots of new stuff related to NtQuerySystemInformation().

*/

// =================================================================
// MACROS
// =================================================================

#define FSC_CODE($a,$b,$c,$d) ((($a)<<16)|(($b)<<14)|(($c)<<2)|($d))

#define OFFSETOF($a,$b) ((DWORD) &((($a *) 0)->$b))

#define STATUS_SEVERITY($a) ((($a) & 0xC0000000) >> 30)
#define STATUS_CUSTOMER($a) ((($a) & 0x20000000) >> 29)
#define STATUS_RESERVED($a) ((($a) & 0x10000000) >> 28)
#define STATUS_FACILITY($a) ((($a) & 0x0FFF0000) >> 16)
#define STATUS_CODE($a)      (($a) & 0x0000FFFF)

// =================================================================
// CONSTANTS
// =================================================================

#define BYTE_                       sizeof (BYTE)
#define TBYTE_                      sizeof (TBYTE)
#define WORD_                       sizeof (WORD)
#define DWORD_                      sizeof (DWORD)

#define MAXIMUM_FILENAME_LENGTH     256
#define PORT_MAXIMUM_MESSAGE_LENGTH 256
#define INITIAL_PRIVILEGE_COUNT       3

#define TICKS_PER_MSEC              10000
#define TICKS_PER_SECOND            (1000 * TICKS_PER_MSEC  )
#define TICKS_PER_MINUTE            (  60 * TICKS_PER_SECOND)
#define TICKS_PER_HOUR              (  60 * TICKS_PER_MINUTE)
#define TICKS_PER_DAY               (  24 * TICKS_PER_HOUR  )

// =================================================================
// DEVICE CODES
// =================================================================

#define FILE_DEVICE_BEEP                    0X00000001
#define FILE_DEVICE_CD_ROM                  0X00000002
#define FILE_DEVICE_CD_ROM_FILE_SYSTEM      0X00000003
#define FILE_DEVICE_CONTROLLER              0X00000004
#define FILE_DEVICE_DATALINK                0X00000005
#define FILE_DEVICE_DFS                     0X00000006
#define FILE_DEVICE_DISK                    0X00000007
#define FILE_DEVICE_DISK_FILE_SYSTEM        0X00000008
#define FILE_DEVICE_FILE_SYSTEM             0X00000009
#define FILE_DEVICE_INPORT_PORT             0X0000000A
#define FILE_DEVICE_KEYBOARD                0X0000000B
#define FILE_DEVICE_MAILSLOT                0X0000000C
#define FILE_DEVICE_MIDI_IN                 0X0000000D
#define FILE_DEVICE_MIDI_OUT                0X0000000E
#define FILE_DEVICE_MOUSE                   0X0000000F
#define FILE_DEVICE_MULTI_UNC_PROVIDER      0X00000010
#define FILE_DEVICE_NAMED_PIPE              0X00000011
#define FILE_DEVICE_NETWORK                 0X00000012
#define FILE_DEVICE_NETWORK_BROWSER         0X00000013
#define FILE_DEVICE_NETWORK_FILE_SYSTEM     0X00000014
#define FILE_DEVICE_NULL                    0X00000015
#define FILE_DEVICE_PARALLEL_PORT           0X00000016
#define FILE_DEVICE_PHYSICAL_NETCARD        0X00000017
#define FILE_DEVICE_PRINTER                 0X00000018
#define FILE_DEVICE_SCANNER                 0X00000019
#define FILE_DEVICE_SERIAL_MOUSE_PORT       0X0000001A
#define FILE_DEVICE_SERIAL_PORT             0X0000001B
#define FILE_DEVICE_SCREEN                  0X0000001C
#define FILE_DEVICE_SOUND                   0X0000001D
#define FILE_DEVICE_STREAMS                 0X0000001E
#define FILE_DEVICE_TAPE                    0X0000001F
#define FILE_DEVICE_TAPE_FILE_SYSTEM        0X00000020
#define FILE_DEVICE_TRANSPORT               0X00000021
#define FILE_DEVICE_UNKNOWN                 0X00000022
#define FILE_DEVICE_VIDEO                   0X00000023
#define FILE_DEVICE_VIRTUAL_DISK            0X00000024
#define FILE_DEVICE_WAVE_IN                 0X00000025
#define FILE_DEVICE_WAVE_OUT                0X00000026
#define FILE_DEVICE_8042_PORT               0X00000027
#define FILE_DEVICE_NETWORK_REDIRECTOR      0X00000028
#define FILE_DEVICE_BATTERY                 0X00000029
#define FILE_DEVICE_BUS_EXTENDER            0X0000002A
#define FILE_DEVICE_MODEM                   0X0000002B
#define FILE_DEVICE_VDM                     0X0000002C

// =================================================================
// I/O ACCESS MODES
// =================================================================

#define FILE_ANY_ACCESS                     0
#define FILE_READ_ACCESS                    1
#define FILE_WRITE_ACCESS                   2

// =================================================================
// I/O METHODS
// =================================================================

#define METHOD_BUFFERED                     0
#define METHOD_IN_DIRECT                    1
#define METHOD_OUT_DIRECT                   2
#define METHOD_NEITHER                      3

// =================================================================
// I/O FLAGS
// =================================================================

#define FILE_SHARE_READ                     0x00000001
#define FILE_SHARE_WRITE                    0x00000002
#define FILE_SHARE_DELETE                   0x00000004
#define FILE_SHARE_VALID_FLAGS              0x00000007

#define FILE_SHARE_READWRITE                (FILE_SHARE_READ  | \
                                             FILE_SHARE_WRITE)

#define FILE_SHARE_ALL                      (FILE_SHARE_READ  | \
                                             FILE_SHARE_WRITE | \
                                             FILE_SHARE_DELETE)

// -----------------------------------------------------------------

#define FILE_DIRECTORY_FILE                 0x00000001
#define FILE_WRITE_THROUGH                  0x00000002
#define FILE_SEQUENTIAL_ONLY                0x00000004
#define FILE_NO_INTERMEDIATE_BUFFERING      0x00000008

#define FILE_SYNCHRONOUS_IO_ALERT           0x00000010
#define FILE_SYNCHRONOUS_IO_NONALERT        0x00000020
#define FILE_NON_DIRECTORY_FILE             0x00000040
#define FILE_CREATE_TREE_CONNECTION         0x00000080

#define FILE_COMPLETE_IF_OPLOCKED           0x00000100
#define FILE_NO_EA_KNOWLEDGE                0x00000200
#define FILE_RANDOM_ACCESS                  0x00000800

#define FILE_DELETE_ON_CLOSE                0x00001000
#define FILE_OPEN_BY_FILE_ID                0x00002000
#define FILE_OPEN_FOR_BACKUP_INTENT         0x00004000
#define FILE_NO_COMPRESSION                 0x00008000

#define FILE_RESERVE_OPFILTER               0x00100000
#define FILE_TRANSACTED_MODE                0x00200000
#define FILE_OPEN_OFFLINE_FILE              0x00400000

#define FILE_VALID_OPTION_FLAGS             0x007fffff
#define FILE_VALID_PIPE_OPTION_FLAGS        0x00000032
#define FILE_VALID_MAILSLOT_OPTION_FLAGS    0x00000032
#define FILE_VALID_SET_FLAGS                0x00000036

// =================================================================
// I/O SYSTEM DATA STRUCTURE TYPE CODES
// =================================================================

#define IO_TYPE_ADAPTER                      1
#define IO_TYPE_CONTROLLER                   2
#define IO_TYPE_DEVICE                       3
#define IO_TYPE_DRIVER                       4
#define IO_TYPE_FILE                         5
#define IO_TYPE_IRP                          6
#define IO_TYPE_MASTER_ADAPTER               7
#define IO_TYPE_OPEN_PACKET                  8
#define IO_TYPE_TIMER                        9
#define IO_TYPE_VPB                         10
#define IO_TYPE_ERROR_LOG                   11
#define IO_TYPE_ERROR_MESSAGE               12
#define IO_TYPE_DEVICE_OBJECT_EXTENSION     13

#define IO_TYPE_APC                         18
#define IO_TYPE_DPC                         19
#define IO_TYPE_DEVICE_QUEUE                20
#define IO_TYPE_EVENT_PAIR                  21
#define IO_TYPE_INTERRUPT                   22
#define IO_TYPE_PROFILE                     23

// =================================================================
// THREAD STATES
// =================================================================

#define THREAD_STATE_INITIALIZED             0
#define THREAD_STATE_READY                   1
#define THREAD_STATE_RUNNING                 2
#define THREAD_STATE_STANDBY                 3
#define THREAD_STATE_TERMINATED              4
#define THREAD_STATE_WAIT                    5
#define THREAD_STATE_TRANSITION              6
#define THREAD_STATE_UNKNOWN                 7

// =================================================================
// LdrLoadDll() FLAGS
// =================================================================

#define LDR_DONT_RESOLVE_DLL_REFERENCES     0x00000002

// =================================================================
// PROCESS_PARAMS FLAGS
// =================================================================

#define PROCESS_PARAMS_FLAG_NORMALIZED      0x00000001

// =================================================================
// FACILITY CODES
// =================================================================

#define FACILITY_NWRDR                      0x0001
#define FACILITY_RPC_RUNTIME                0x0002
#define FACILITY_RPC_STUBS                  0x0003
#define FACILITY_IO_ERROR_CODE              0x0004

#define STATUS_FACILITY_NWRDR               FACILITY_NWRDR
#define STATUS_FACILITY_RPC_RUNTIME         FACILITY_RPC_RUNTIME
#define STATUS_FACILITY_RPC_STUBS           FACILITY_RPC_STUBS
#define STATUS_FACILITY_IO_ERROR_CODE       FACILITY_IO_ERROR_CODE

// =================================================================
// SEVERITY CODES
// =================================================================

#define STATUS_SEVERITY_SUCCESS             0x0
#define STATUS_SEVERITY_INFORMATIONAL       0x1
#define STATUS_SEVERITY_WARNING             0x2
#define STATUS_SEVERITY_ERROR               0x3

// =================================================================
// STATUS CODES
// =================================================================

#define STATUS_SUCCESS                      ((NTSTATUS) 0x00000000)
#define STATUS_UNSUCCESSFUL                 ((NTSTATUS) 0xC0000001)
#define STATUS_NOT_IMPLEMENTED              ((NTSTATUS) 0xC0000002)
#define STATUS_INVALID_INFO_CLASS           ((NTSTATUS) 0xC0000003)
#define STATUS_INFO_LENGTH_MISMATCH         ((NTSTATUS) 0xC0000004)
#define STATUS_INVALID_PARAMETER            ((NTSTATUS) 0xC000000D)
#define STATUS_NO_SUCH_USER                 ((NTSTATUS) 0xC0000064)
#define STATUS_BAD_NETWORK_PATH             ((NTSTATUS) 0xC00000BE)
#define STATUS_CONNECTION_IN_USE            ((NTSTATUS) 0xC0000108)

// =================================================================
// SIMPLE TYPES
// =================================================================

typedef BYTE            **PPBYTE;
typedef TBYTE           **PPTBYTE;
typedef WORD            **PPWORD;
typedef DWORD           **PPDWORD;

typedef CHAR            **PPCHAR;
typedef SHORT           **PPSHORT;
typedef LONG            **PPLONG;
typedef void            **PPVOID;

// -----------------------------------------------------------------

typedef BYTE            KPROCESSOR_MODE;
typedef BYTE            KIRQL;
typedef LONG            NTSTATUS;
typedef DWORD           KAFFINITY;
typedef LONG            KPRIORITY;
typedef LARGE_INTEGER   QWORD;

// -----------------------------------------------------------------

typedef NTSTATUS        *PNTSTATUS,        **PPNTSTATUS;
typedef KAFFINITY       *PKAFFINITY,       **PPKAFFINITY;
typedef KIRQL           *PKIRQL,           **PPKIRQL;
typedef KPRIORITY       *PKPRIORITY,       **PPKPRIORITY;
typedef KPROCESSOR_MODE *PKPROCESSOR_MODE, **PPKPROCESSOR_MODE;
typedef OVERLAPPED      *POVERLAPPED,      **PPOVERLAPPED;
typedef PROC            *PPROC,            **PPPROC;
typedef void            *POBJECT,          **PPOBJECT;
typedef QWORD           *PQWORD,           **PPQWORD;

// -----------------------------------------------------------------

typedef NTSTATUS (NTAPI *NTSYSCALL)();
typedef NTSYSCALL *PNTSYSCALL;

typedef void (NTAPI *NTSYSCALLV)();
typedef NTSYSCALLV *PNTSYSCALLV;

typedef void (*PROCV)();
typedef PROCV *PPROCV;

// =================================================================
// ENUMERATIONS
// =================================================================

typedef enum _MODE
    {
    KernelMode,
    UserMode,
    MaximumMode
    }
        MODE,
     * PMODE,
    **PPMODE;

// -----------------------------------------------------------------

typedef enum _POOL_TYPE
    {
    NonPagedPool,
    PagedPool,
    NonPagedPoolMustSucceed,
    DontUseThisType,
    NonPagedPoolCacheAligned,
    PagedPoolCacheAligned,
    NonPagedPoolCacheAlignedMustS,
    MaxPoolType
    }
        POOL_TYPE,
     * PPOOL_TYPE,
    **PPPOOL_TYPE;

// -----------------------------------------------------------------

typedef enum _KWAIT_REASON
    {
    Executive,
    FreePage,
    PageIn,
    PoolAllocation,
    DelayExecution,
    Suspended,
    UserRequest,
    WrExecutive,
    WrFreePage,
    WrPageIn,
    WrPoolAllocation,
    WrDelayExecution,
    WrSuspended,
    WrUserRequest,
    WrEventPair,
    WrQueue,
    WrLpcReceive,
    WrLpcReply,
    WrVirtualMemory,
    WrPageOut,
    WrRendezvous,
    Spare2,
    Spare3,
    Spare4,
    Spare5,
    Spare6,
    WrKernel,
    MaximumWaitReason
    }
        KWAIT_REASON,
     * PKWAIT_REASON,
    **PPKWAIT_REASON;

// -----------------------------------------------------------------

typedef enum _EVENT_TYPE
    {
    NotificationEvent,
    SynchronizationEvent
    }
        EVENT_TYPE,
     * PEVENT_TYPE,
    **PPEVENT_TYPE;

// -----------------------------------------------------------------

typedef enum _TIMER_TYPE
    {
    NotificationTimer,
    SynchronizationTimer
    }
        TIMER_TYPE,
     * PTIMER_TYPE,
    **PPTIMER_TYPE;

// =================================================================
// PROCESS/THREAD INFO CLASS STRUCTURES
// =================================================================

typedef enum _PROCESSINFOCLASS
    {
    ProcessBasicInformation,
    ProcessQuotaLimits,
    ProcessIoCounters,
    ProcessVmCounters,
    ProcessTimes,
    ProcessBasePriority,
    ProcessRaisePriority,
    ProcessDebugPort,
    ProcessExceptionPort,
    ProcessAccessToken,
    ProcessLdtInformation,
    ProcessLdtSize,
    ProcessDefaultHardErrorMode,
    ProcessIoPortHandlers,
    ProcessPooledUsageAndLimits,
    ProcessWorkingSetWatch,
    ProcessUserModeIOPL,
    ProcessEnableAlignmentFaultFixup,
    ProcessPriorityClass,
    ProcessWx86Information,
    ProcessHandleCount,
    ProcessAffinityMask,
    ProcessPriorityBoost,
    MaxProcessInfoClass
    }
    PROCESSINFOCLASS, *PPROCESSINFOCLASS, **PPPROCESSINFOCLASS;

// -----------------------------------------------------------------

typedef enum _THREADINFOCLASS
    {
    ThreadBasicInformation,
    ThreadTimes,
    ThreadPriority,
    ThreadBasePriority,
    ThreadAffinityMask,
    ThreadImpersonationToken,
    ThreadDescriptorTableEntry,
    ThreadEnableAlignmentFaultFixup,
    ThreadEventPair,
    ThreadQuerySetWin32StartAddress,
    ThreadZeroTlsCell,
    ThreadPerformanceCount,
    ThreadAmILastThread,
    ThreadIdealProcessor,
    ThreadPriorityBoost,
    ThreadSetTlsArrayAddress,
    MaxThreadInfoClass
    }
    THREADINFOCLASS, *PTHREADINFOCLASS, **PPTHREADINFOCLASS;

// -----------------------------------------------------------------
// ProcessBasicInformation

typedef struct _PROCESS_BASIC_INFORMATION
    {
    NTSTATUS  ExitStatus;
    PVOID     PebBaseAddress;
    KAFFINITY AffinityMask;
    KPRIORITY BasePriority;
    DWORD     UniqueProcessId;
    DWORD     InheritedFromUniqueProcessId;
    }
        PROCESS_BASIC_INFORMATION,
     * PPROCESS_BASIC_INFORMATION,
    **PPPROCESS_BASIC_INFORMATION;

#define PROCESS_BASIC_INFORMATION_ \
        sizeof (PROCESS_BASIC_INFORMATION)

// -----------------------------------------------------------------
// ProcessQuotaLimits

typedef QUOTA_LIMITS **PPQUOTA_LIMITS;
#define QUOTA_LIMITS_ sizeof (QUOTA_LIMITS)

// -----------------------------------------------------------------
// ProcessIoCounters

typedef struct _IO_COUNTERS
    {
    DWORD ReadOperationCount;
    DWORD WriteOperationCount;
    DWORD OtherOperationCount;
    QWORD ReadTransferCount;
    QWORD WriteTransferCount;
    QWORD OtherTransferCount;
    }
        IO_COUNTERS,
     * PIO_COUNTERS,
    **PPIO_COUNTERS;

#define IO_COUNTERS_ \
        sizeof (IO_COUNTERS)

// -----------------------------------------------------------------
// ProcessVmCounters

typedef struct _VM_COUNTERS
    {
    DWORD PeakVirtualSize;
    DWORD VirtualSize;
    DWORD PageFaultCount;
    DWORD PeakWorkingSetSize;
    DWORD WorkingSetSize;
    DWORD QuotaPeakPagedPoolUsage;
    DWORD QuotaPagedPoolUsage;
    DWORD QuotaPeakNonPagedPoolUsage;
    DWORD QuotaNonPagedPoolUsage;
    DWORD PagefileUsage;
    DWORD PeakPagefileUsage;
    }
        VM_COUNTERS,
     * PVM_COUNTERS,
    **PPVM_COUNTERS;

#define VM_COUNTERS_ \
        sizeof (VM_COUNTERS)

// -----------------------------------------------------------------
// ProcessTimes, ThreadTimes

typedef struct _KERNEL_USER_TIMES
    {
    QWORD CreateTime;
    QWORD ExitTime;
    QWORD KernelTime;
    QWORD UserTime;
    }
        KERNEL_USER_TIMES,
     * PKERNEL_USER_TIMES,
    **PPKERNEL_USER_TIMES;

#define KERNEL_USER_TIMES_ \
        sizeof (KERNEL_USER_TIMES)

// -----------------------------------------------------------------
// ProcessAccessToken

typedef struct _PROCESS_ACCESS_TOKEN
    {
    HANDLE Token;
    HANDLE Thread;
    }
        PROCESS_ACCESS_TOKEN,
     * PPROCESS_ACCESS_TOKEN,
    **PPPROCESS_ACCESS_TOKEN;

#define PROCESS_ACCESS_TOKEN_ \
        sizeof (PROCESS_ACCESS_TOKEN)

// -----------------------------------------------------------------
// ProcessPooledUsageAndLimits

typedef struct _POOLED_USAGE_AND_LIMITS
    {
    DWORD PeakPagedPoolUsage;
    DWORD PagedPoolUsage;
    DWORD PagedPoolLimit;
    DWORD PeakNonPagedPoolUsage;
    DWORD NonPagedPoolUsage;
    DWORD NonPagedPoolLimit;
    DWORD PeakPagefileUsage;
    DWORD PagefileUsage;
    DWORD PagefileLimit;
    }
        POOLED_USAGE_AND_LIMITS,
     * PPOOLED_USAGE_AND_LIMITS,
    **PPPOOLED_USAGE_AND_LIMITS;

#define POOLED_USAGE_AND_LIMITS_ \
        sizeof (POOLED_USAGE_AND_LIMITS)

// -----------------------------------------------------------------
// ProcessWorkingSetWatch

typedef struct _PROCESS_WS_WATCH_INFORMATION
    {
    PVOID FaultingPc;
    PVOID FaultingVa;
    }
        PROCESS_WS_WATCH_INFORMATION,
     * PPROCESS_WS_WATCH_INFORMATION,
    **PPPROCESS_WS_WATCH_INFORMATION;

#define PROCESS_WS_WATCH_INFORMATION_ \
        sizeof (PROCESS_WS_WATCH_INFORMATION)

// =================================================================
// BASIC STRUCTURES
// =================================================================

typedef struct _STRING
    {
    WORD  Length;
    WORD  MaximumLength;
    PWORD Buffer;
    }
        STRING,     ANSI_STRING,    OEM_STRING,
     * PSTRING,  * PANSI_STRING,  * POEM_STRING,
    **PPSTRING, **PPANSI_STRING, **PPOEM_STRING;

#define STRING_      sizeof (STRING)
#define ANSI_STRING_ sizeof (ANSI_STRING)
#define OEM_STRING_  sizeof (OEM_STRING)

// -----------------------------------------------------------------

typedef struct _UNICODE_STRING
    {
    WORD  Length;
    WORD  MaximumLength;
    PWORD Buffer;
    }
        UNICODE_STRING,
     * PUNICODE_STRING,
    **PPUNICODE_STRING;

#define UNICODE_STRING_ \
        sizeof (UNICODE_STRING)

// -----------------------------------------------------------------

typedef struct _IO_STATUS_BLOCK
    {
    NTSTATUS Status;
    DWORD    Information;
    }
        IO_STATUS_BLOCK,
     * PIO_STATUS_BLOCK,
    **PPIO_STATUS_BLOCK;

#define IO_STATUS_BLOCK_ \
        sizeof (IO_STATUS_BLOCK)

// -----------------------------------------------------------------

typedef struct _TIME_FIELDS
    {
    WORD Year;
    WORD Month;
    WORD Day;
    WORD Hour;
    WORD Minute;
    WORD Second;
    WORD Milliseconds;
    WORD Weekday;
    }
        TIME_FIELDS,
     * PTIME_FIELDS,
    **PPTIME_FIELDS;

#define TIME_FIELDS_ \
        sizeof (TIME_FIELDS)

// -----------------------------------------------------------------

typedef struct _CLIENT_ID
    {
    HANDLE UniqueProcess;
    HANDLE UniqueThread;
    }
        CLIENT_ID,
     * PCLIENT_ID,
    **PPCLIENT_ID;

#define CLIENT_ID_ \
        sizeof (CLIENT_ID)

// -----------------------------------------------------------------

typedef union _SLIST_HEADER
    {
    DWORDLONG Alignment;
    struct
        {
        SINGLE_LIST_ENTRY Next;
        USHORT            Depth;
        USHORT            Sequence;
        };
    }
        SLIST_HEADER,
     * PSLIST_HEADER,
    **PPSLIST_HEADER;

#define SLIST_HEADER_ \
        sizeof (SLIST_HEADER)

// -----------------------------------------------------------------

typedef struct _RTL_BITMAP
    {
    DWORD  SizeOfBitMap;        // number of bits
    PDWORD Buffer;              // pointer to bit map data
    }
        RTL_BITMAP,
     * PRTL_BITMAP,
    **PPRTL_BITMAP;

#define RTL_BITMAP_ \
        sizeof (RTL_BITMAP)

// -----------------------------------------------------------------

typedef struct _SERVICE_DESCRIPTOR_TABLE
    {
    PNTSYSCALL ServiceTable;    // array of entrypoints
    PDWORD     CounterTable;    // array of counters
    DWORD      TableSize;       // number of table entries
    PBYTE      ArgumentTable;   // array of byte counts
    }
        SERVICE_DESCRIPTOR_TABLE,
     * PSERVICE_DESCRIPTOR_TABLE,
    **PPSERVICE_DESCRIPTOR_TABLE;

#define SERVICE_DESCRIPTOR_TABLE_ \
        sizeof (SERVICE_DESCRIPTOR_TABLE)

// -----------------------------------------------------------------

typedef struct _GENERATE_NAME_CONTEXT
    {
    WORD    Checksum;
    BOOLEAN ChecksumInserted;
    BYTE    NameLength;
    WORD    NameBuffer [8];
    DWORD   ExtensionLength;
    WORD    ExtensionBuffer [4];
    DWORD   LastIndexValue;
    }
        GENERATE_NAME_CONTEXT,
     * PGENERATE_NAME_CONTEXT,
    **PPGENERATE_NAME_CONTEXT;

#define GENERATE_NAME_CONTEXT_ \
        sizeof (GENERATE_NAME_CONTEXT)

// -----------------------------------------------------------------

typedef struct _SECURITY_SUBJECT_CONTEXT
    {
    PACCESS_TOKEN                ClientToken;
    SECURITY_IMPERSONATION_LEVEL ImpersonationLevel;
    PACCESS_TOKEN                PrimaryToken;
    PVOID                        ProcessAuditId;
    }
        SECURITY_SUBJECT_CONTEXT,
     * PSECURITY_SUBJECT_CONTEXT,
    **PPSECURITY_SUBJECT_CONTEXT;

#define SECURITY_SUBJECT_CONTEXT_ \
        sizeof (SECURITY_SUBJECT_CONTEXT)

// -----------------------------------------------------------------

typedef struct _INITIAL_PRIVILEGE_SET
    {
    DWORD               PrivilegeCount;
    DWORD               Control;
    LUID_AND_ATTRIBUTES Privilege [INITIAL_PRIVILEGE_COUNT];
    }
        INITIAL_PRIVILEGE_SET,
     * PINITIAL_PRIVILEGE_SET,
    **PPINITIAL_PRIVILEGE_SET;

#define INITIAL_PRIVILEGE_SET_ \
        sizeof (INITIAL_PRIVILEGE_SET)

// -----------------------------------------------------------------

typedef struct _ACCESS_STATE
    {
    LUID                     OperationID;
    BOOLEAN                  SecurityEvaluated;
    BOOLEAN                  GenerateAudit;
    BOOLEAN                  GenerateOnClose;
    BOOLEAN                  PrivilegesAllocated;
    DWORD                    Flags;
    ACCESS_MASK              RemainingDesiredAccess;
    ACCESS_MASK              PreviouslyGrantedAccess;
    ACCESS_MASK              OriginalDesiredAccess;
    SECURITY_SUBJECT_CONTEXT SubjectSecurityContext;
    PSECURITY_DESCRIPTOR     SecurityDescriptor;
    PVOID                    AuxData;
    union
        {
        INITIAL_PRIVILEGE_SET InitialPrivilegeSet;
        PRIVILEGE_SET         PrivilegeSet;
        }
        Privileges;
    BOOLEAN                  AuditPrivileges;
    UNICODE_STRING           ObjectName;
    UNICODE_STRING           ObjectTypeName;
    }
        ACCESS_STATE,
     * PACCESS_STATE,
    **PPACCESS_STATE;

#define ACCESS_STATE_ \
        sizeof (ACCESS_STATE)

// =================================================================
// KERNEL OBJECTS
// =================================================================

typedef struct _DISPATCHER_HEADER
    {
    BYTE       Type;        // DO_TYPE_*
    BYTE       Absolute;
    BYTE       Size;        // number of DWORDs
    BYTE       Inserted;
    LONG       SignalState;
    LIST_ENTRY WaitListHead;
    }
        DISPATCHER_HEADER,
     * PDISPATCHER_HEADER,
    **PPDISPATCHER_HEADER;

#define DISPATCHER_HEADER_ \
        sizeof (DISPATCHER_HEADER)

// -----------------------------------------------------------------

typedef struct _KEVENT
    {
    DISPATCHER_HEADER Header;
    }
        KEVENT,
     * PKEVENT;
    **PPKEVENT;

#define KEVENT_ \
        sizeof (KEVENT)

// -----------------------------------------------------------------

typedef struct _KEVENT_PAIR
    {
    WORD   Type;        // IO_TYPE_EVENT_PAIR (0x15)
    WORD   Size;        // number of BYTEs    (0x24)
    KEVENT Event1;
    KEVENT Event2;
    }
        KEVENT_PAIR,
     * PKEVENT_PAIR;
    **PPKEVENT_PAIR;

#define KEVENT_PAIR_ \
        sizeof (KEVENT_PAIR)

// -----------------------------------------------------------------

typedef struct _KSEMAPHORE
    {
    DISPATCHER_HEADER Header;
    LONG              Limit;
    }
        KSEMAPHORE,
     * PKSEMAPHORE,
    **PPKSEMAPHORE;

#define KSEMAPHORE_ \
        sizeof (KSEMAPHORE)

// -----------------------------------------------------------------

typedef struct _KMUTANT
    {
    DISPATCHER_HEADER Header;
    LIST_ENTRY        MutantListEntry;
    struct _KTHREAD  *OwnerThread;
    BOOLEAN           Abandoned;
    UCHAR             ApcDisable;
    }
        KMUTANT,
     * PKMUTANT,
    **PPKMUTANT;

#define KMUTANT_ \
        sizeof (KMUTANT)

// -----------------------------------------------------------------

typedef struct _FAST_MUTEX
    {
    LONG             Count;
    struct _KTHREAD *Owner;
    DWORD            Contention;
    KEVENT           Event;
    DWORD            OldIrql;
    }
        FAST_MUTEX,
     * PFAST_MUTEX,
    **PPFAST_MUTEX;

#define FAST_MUTEX_ \
        sizeof (FAST_MUTEX)

// -----------------------------------------------------------------

typedef struct _KQUEUE
    {
    DISPATCHER_HEADER Header;
    LIST_ENTRY        EntryListHead;
    DWORD             CurrentCount;
    DWORD             MaximumCount;
    LIST_ENTRY        ThreadListHead;
    }
        KQUEUE,
     * PKQUEUE,
    **PPKQUEUE;

#define KQUEUE_ \
        sizeof (KQUEUE)

// -----------------------------------------------------------------

typedef struct _KPROCESS
    {
    DISPATCHER_HEADER Header;           // DO_TYPE_PROCESS (0x1A)
    LIST_ENTRY        le10;
    DWORD             d18;
    DWORD             d1C;
    DWORD             d20;
    DWORD             d24;
    DWORD             d28;
    DWORD             d2C;
    DWORD             d30;
    DWORD             d34;
    DWORD             dKernelTime;      // ticks
    DWORD             dUserTime;        // ticks
    LIST_ENTRY        le40;
    LIST_ENTRY        OutSwapList;
    LIST_ENTRY        ThreadListHead;   // KTHREAD.ThreadList
    DWORD             d58;
    KAFFINITY         AffinityMask;
    WORD              w60;
    BYTE              bBasePriority;
    BYTE              b63;
    WORD              w64;
    BYTE              b66;
    BOOLEAN           bPriorityBoost;
    }
        KPROCESS,
     * PKPROCESS,
    **PPKPROCESS;

#define KPROCESS_ \
        sizeof (KPROCESS)

// -----------------------------------------------------------------

typedef struct _KTHREAD
    {
    DISPATCHER_HEADER         Header;       // DO_TYPE_THREAD (0x6C)
    LIST_ENTRY                le010;
    DWORD                     d018;
    DWORD                     d01C;
    struct _TEB              *pTeb;
    DWORD                     d024;
    DWORD                     d028;
    BYTE                      b02C;
    BYTE                      bThreadState; // THREAD_STATE_*
    WORD                      w02E;
    WORD                      w030;
    BYTE                      b032;
    BYTE                      bPriority;
    LIST_ENTRY                le034;
    LIST_ENTRY                le03C;
    PKPROCESS                 pProcess;
    DWORD                     d048;
    DWORD                     dContextSwitches;
    DWORD                     d050;
    WORD                      w054;
    BYTE                      b056;
    BYTE                      bWaitReason;
    DWORD                     d058;
    PLIST_ENTRY               ple05C;
    PLIST_ENTRY               ple060;
    DWORD                     d064;
    BYTE                      bBasePriority;
    BYTE                      b069;
    WORD                      w06A;
    DWORD                     d06C;
    DWORD                     d070;
    DWORD                     d074;
    DWORD                     d078;
    DWORD                     d07C;
    DWORD                     d080;
    DWORD                     d084;
    DWORD                     d088;
    DWORD                     d08C;
    DWORD                     d090;
    DWORD                     d094;
    DWORD                     d098;
    DWORD                     d09C;
    DWORD                     d0A0;
    DWORD                     d0A4;
    DWORD                     d0A8;
    DWORD                     d0AC;
    DWORD                     d0B0;
    DWORD                     d0B4;
    DWORD                     d0B8;
    DWORD                     d0BC;
    DWORD                     d0C0;
    DWORD                     d0C4;
    DWORD                     d0C8;
    DWORD                     d0CC;
    DWORD                     d0D0;
    DWORD                     d0D4;
    DWORD                     d0D8;
    PSERVICE_DESCRIPTOR_TABLE pServiceDescriptorTable;
    DWORD                     d0E0;
    DWORD                     d0E4;
    DWORD                     d0E8;
    DWORD                     d0EC;
    LIST_ENTRY                le0F0;
    DWORD                     d0F8;
    DWORD                     d0FC;
    DWORD                     d100;
    DWORD                     d104;
    DWORD                     d108;
    DWORD                     d10C;
    DWORD                     d110;
    DWORD                     d114;
    DWORD                     d118;
    BYTE                      b11C;
    BYTE                      b11D;
    WORD                      w11E;
    DWORD                     d120;
    DWORD                     d124;
    DWORD                     d128;
    DWORD                     d12C;
    DWORD                     d130;
    WORD                      w134;
    BYTE                      b136;
    KPROCESSOR_MODE           ProcessorMode;
    DWORD                     dKernelTime;  // ticks
    DWORD                     dUserTime;    // ticks
    DWORD                     d140;
    DWORD                     d144;
    DWORD                     d148;
    DWORD                     d14C;
    DWORD                     d150;
    DWORD                     d154;
    DWORD                     d158;
    DWORD                     d15C;
    DWORD                     d160;
    DWORD                     d164;
    DWORD                     d168;
    DWORD                     d16C;
    DWORD                     d170;
    PROC                      SuspendNop;
    DWORD                     d178;
    DWORD                     d17C;
    DWORD                     d180;
    DWORD                     d184;
    DWORD                     d188;
    DWORD                     d18C;
    KSEMAPHORE                SuspendSemaphore;
    LIST_ENTRY                ThreadList; // KPROCESS.ThreadListHead
    DWORD                     d1AC;
    }
        KTHREAD,
     * PKTHREAD,
    **PPKTHREAD;

#define KTHREAD_ \
        sizeof (KTHREAD)

// =================================================================
// LOOKASIDE LISTS
// =================================================================

typedef struct _GENERAL_LOOKASIDE
    {
    SLIST_HEADER ListHead;
    WORD         Depth;
    WORD         Pad;
    DWORD        TotalAllocates;
    DWORD        AllocateMisses;
    DWORD        TotalFrees;
    DWORD        FreeMisses;
    POOL_TYPE    Type;
    DWORD        Tag;
    DWORD        Size;
    PROCV        Allocate;
    PROCV        Free;
    LIST_ENTRY   ListEntry;
    DWORD        LastTotalAllocates;
    DWORD        LastAllocateMisses;
    DWORD        Future [2];
    }
        GENERAL_LOOKASIDE,
     * PGENERAL_LOOKASIDE,
    **PPGENERAL_LOOKASIDE;

#define GENERAL_LOOKASIDE_ \
        sizeof (GENERAL_LOOKASIDE)

// -----------------------------------------------------------------

typedef struct _PAGED_LOOKASIDE_LIST
    {
    GENERAL_LOOKASIDE L;
    FAST_MUTEX        Lock;
    }
        PAGED_LOOKASIDE_LIST,
     * PPAGED_LOOKASIDE_LIST,
    **PPPAGED_LOOKASIDE_LIST;

#define PAGED_LOOKASIDE_LIST_ \
        sizeof (PAGED_LOOKASIDE_LIST)

// -----------------------------------------------------------------

typedef struct _NPAGED_LOOKASIDE_LIST
    {
    GENERAL_LOOKASIDE L;
    KSPIN_LOCK        Lock;
    }
        NPAGED_LOOKASIDE_LIST,
     * PNPAGED_LOOKASIDE_LIST,
    **PPNPAGED_LOOKASIDE_LIST;

#define NPAGED_LOOKASIDE_LIST_ \
        sizeof (NPAGED_LOOKASIDE_LIST)

// =================================================================
// EXECUTIVE OBJECTS
// =================================================================

typedef struct _EPROCESS
    {
    KPROCESS                     Pcb;
    NTSTATUS                     ExitStatus;
    KEVENT                       LockEvent;
    DWORD                        LockCount;
    QWORD                        CreateTime;
    QWORD                        ExitTime;
    PVOID                        LockOwner;
    DWORD                        UniqueProcessId;
    QWORD                        ActiveProcessLinks;
    DWORD                        QuotaPeakPoolUsage [2]; // NP, P
    DWORD                        QuotaPoolUsage     [2]; // NP, P
    DWORD                        PagefileUsage;
    DWORD                        CommitCharge;
    DWORD                        PeakPagefileUsage;
    DWORD                        PeakVirtualSize;
    QWORD                        VirtualSize;
    DWORD                        Vm [12];
    DWORD                        LastProtoPteFault;
    DWORD                        DebugPort;
    DWORD                        ExceptionPort;
    DWORD                        ObjectTable;
    DWORD                        Token;
    DWORD                        WorkingSetLock [8];
    DWORD                        WorkingSetPage;
    BOOLEAN                      ProcessOutswapEnabled;
    BOOLEAN                      ProcessOutswapped;
    BOOLEAN                      AddressSpaceInitialized;
    BOOLEAN                      AddressSpaceDeleted;
    DWORD                        AddressCreationLock [9];
    DWORD                        ForkInProgress;
    DWORD                        VmOperation;
    DWORD                        VmOperationEvent;
    DWORD                        PageDirectoryPte;
    QWORD                        LastFaultCount;
    PVOID                        VadRoot;
    DWORD                        VadHint;
    DWORD                        CloneRoot;
    DWORD                        NumberOfPrivatePages;
    DWORD                        NumberOfLockedPages;
    WORD                         w184;
    BOOLEAN                      ExitProcessCalled;
    BOOLEAN                      CreateProcessReported;
    HANDLE                       SectionHandle;
    struct _PEB                 *Peb;
    PVOID                        SectionBaseAddress;
    PVOID                        QuotaBlock;
    NTSTATUS                     LastThreadExitStatus;
    PROCESS_WS_WATCH_INFORMATION WorkingSetWatch;
    DWORD                        InheritedFromUniqueProcessId;
    ACCESS_MASK                  GrantedAccess;
    DWORD                        DefaultHardErrorProcessing;
    DWORD                        LdtInformation;
    DWORD                        VadFreeHint;
    DWORD                        VdmObjects;
    KMUTANT                      ProcessMutant;
    BYTE                         ImageFileName [16];
    DWORD                        VmTrimFaultValue [2];
    PVOID                        Win32Process;
    DWORD                        d1F8;
    DWORD                        d1FC;
    }
        EPROCESS,
     * PEPROCESS,
    **PPEPROCESS;

#define EPROCESS_ \
        sizeof (EPROCESS)

// -----------------------------------------------------------------

typedef struct _ETHREAD
    {
    KTHREAD    Tcb;
    QWORD      CreateTime;
    QWORD      ExitTime;
    NTSTATUS   ExitStatus;
    LIST_ENTRY PostBlockList;
    LIST_ENTRY TerminationPortList;
    DWORD      ActiveTimerListLock;
    LIST_ENTRY ActiveTimerListHead;
    CLIENT_ID  Cid;
    KSEMAPHORE LpcReplySemaphore;
    DWORD      LpcReplyMessage;
    QWORD      LpcReplyMessageId;
    DWORD      ImpersonationInfo;
    LIST_ENTRY IrpList;
    LIST_ENTRY TopLevelIrp;
    DWORD      ReadClusterSize;
    BOOLEAN    ForwardClusterOnly;
    BOOLEAN    DisablePageFaultClustering;
    BOOLEAN    DeadThread;
    BOOLEAN    HasTerminated;
    DWORD      EventPair;
    DWORD      GrantedAccess;
    DWORD      ThreadsProcess;
    PVOID      StartAddress;
    PVOID      Win32StartAddress;
    BOOLEAN    LpcExitThreadCalled;
    BOOLEAN    HardErrorsAreDisabled;
    WORD       w23A;
    DWORD      w23C;
    }
        ETHREAD,
     * PETHREAD,
    **PPETHREAD;

#define ETHREAD_ \
        sizeof (ETHREAD)

// -----------------------------------------------------------------

typedef PETHREAD     ERESOURCE_THREAD,
                  * PERESOURCE_THREAD,
                 **PPERESOURCE_THREAD;

#define ERESOURCE_THREAD_ \
        sizeof (ERESOURCE_THREAD)

// -----------------------------------------------------------------

typedef struct _OWNER_ENTRY
    {
    ERESOURCE_THREAD OwnerThread;
    SHORT            OwnerCount;
    WORD             TableSize;
    }
        OWNER_ENTRY,
     * POWNER_ENTRY,
    **PPOWNER_ENTRY;

#define OWNER_ENTRY_ \
        sizeof (OWNER_ENTRY)

// -----------------------------------------------------------------

typedef struct _ERESOURCE_OLD
    {
    LIST_ENTRY        SystemResourcesList;
    PERESOURCE_THREAD OwnerThreads;
    PBYTE             OwnerCounts;
    WORD              TableSize;
    WORD              ActiveCount;
    WORD              Flag;
    WORD              TableRover;
    BYTE              InitialOwnerCounts  [4];
    ERESOURCE_THREAD  InitialOwnerThreads [4];
    DWORD             Spare1;
    DWORD             ContentionCount;
    WORD              NumberOfExclusiveWaiters;
    WORD              NumberOfSharedWaiters;
    KSEMAPHORE        SharedWaiters;
    KEVENT            ExclusiveWaiters;
    KSPIN_LOCK        SpinLock;
    DWORD             CreatorBackTraceIndex;
    WORD              Depth;
    WORD              Reserved;
    PVOID             OwnerBackTrace [4];
    }
        ERESOURCE_OLD,
     * PERESOURCE_OLD,
    **PPERESOURCE_OLD;

#define ERESOURCE_OLD_ \
        sizeof (ERESOURCE_OLD)

// -----------------------------------------------------------------

typedef struct _ERESOURCE_LITE
    {
    LIST_ENTRY   SystemResourcesList;
    POWNER_ENTRY OwnerTable;
    SHORT        ActiveCount;
    WORD         Flag;
    PKSEMAPHORE  SharedWaiters;
    PKEVENT      ExclusiveWaiters;
    OWNER_ENTRY  OwnerThreads [2];
    DWORD        ContentionCount;
    WORD         NumberOfSharedWaiters;
    WORD         NumberOfExclusiveWaiters;
    union
        {
        PVOID Address;
        ULONG CreatorBackTraceIndex;
        };
    KSPIN_LOCK   SpinLock;
    }
        ERESOURCE_LITE,
     * PERESOURCE_LITE,
    **PPERESOURCE_LITE;

#define ERESOURCE_LITE_ \
        sizeof (ERESOURCE_LITE)

// -----------------------------------------------------------------

typedef ERESOURCE_LITE ERESOURCE, *PERESOURCE, **PPERESOURCE;
#define ERESOURCE_ sizeof (ERESOURCE)

// =================================================================
// STRUCTURE GENERATORS
// =================================================================

#define PRESET_STRING($Symbol,$Buffer) \
    STRING $Symbol = \
        { \
        sizeof ($Buffer) - BYTE_, \
        sizeof ($Buffer), \
        $Buffer \
        };

// -----------------------------------------------------------------

#define PRESET_ANSI_STRING($Symbol,$Buffer) \
    ANSI_STRING $Symbol = \
        { \
        sizeof ($Buffer) - BYTE_, \
        sizeof ($Buffer), \
        $Buffer \
        };

// -----------------------------------------------------------------

#define PRESET_OEM_STRING($Symbol,$Buffer) \
    OEM_STRING $Symbol = \
        { \
        sizeof ($Buffer) - BYTE_, \
        sizeof ($Buffer), \
        $Buffer \
        };

// -----------------------------------------------------------------

#define PRESET_UNICODE_STRING($Symbol,$Buffer) \
    UNICODE_STRING $Symbol = \
        { \
        sizeof (L##$Buffer) - WORD_, \
        sizeof (L##$Buffer), \
        L##$Buffer \
        };

// -----------------------------------------------------------------

#define PRESET_OBJECT_ATTRIBUTES($Symbol,$ObjectName,$Attributes) \
    OBJECT_ATTRIBUTES $Symbol = \
        { \
        OBJECT_ATTRIBUTES_, \
        NULL, \
        $ObjectName, \
        $Attributes, \
        NULL, \
        NULL \
        };

// =================================================================
// FUNCTION TYPES
// =================================================================

typedef void (*PIO_APC_ROUTINE) (PVOID            ApcContext,
                                 PIO_STATUS_BLOCK IoStatusBlock,
                                 DWORD            Reserved);

// =================================================================
// MORE HEADER FILES
// =================================================================

#ifndef  _NTOBJ_H_
#include <NtObj.h>
#endif

#ifndef  _NTTEB_H_
#include <NtTeb.h>
#endif

#ifndef  _NTSYS_H_
#include <NtSys.h>
#endif

// =================================================================
// PSEUDO FUNCTIONS
// =================================================================

#define NtCurrentProcess() ((HANDLE) -1)
#define NtCurrentThread()  ((HANDLE) -2)

#define RtlLargeIntegerLessThanZero($a) (($a).HighPart < 0)

// =================================================================
// NT SYSTEM SERVICE PROTOTYPES
// =================================================================

NTSTATUS NTAPI
NtClearEvent (HANDLE hEvent);

NTSTATUS NTAPI
NtClose (HANDLE hObject);

NTSTATUS NTAPI
NtCreateDirectoryObject (PHANDLE            phDirectory,
                         ACCESS_MASK        AccessMask,
                         POBJECT_ATTRIBUTES pObjectAttributes);

NTSTATUS NTAPI
NtCreateFile (PHANDLE            phFile,
              ACCESS_MASK        AccessMask,
              POBJECT_ATTRIBUTES pObjectAttributes,
              PIO_STATUS_BLOCK   pIoStatusBlock,
              PLARGE_INTEGER     pliAllocationSize,
              DWORD              dFileAttributes,
              DWORD              dShareAccess,
              DWORD              dCreateDisposition,
              DWORD              dCreateOptions,
              PVOID              pEaBuffer,
              DWORD              dEaLength);

NTSTATUS NTAPI
NtDeleteFile (POBJECT_ATTRIBUTES pObjectAttributes);

NTSTATUS NTAPI
NtDeviceIoControlFile (HANDLE           hDevice,
                       HANDLE           hEvent,
                       PIO_APC_ROUTINE  pApcRoutine,
                       PVOID            pApcContext,
                       PIO_STATUS_BLOCK pIoStatusBlock,
                       DWORD            dIoControlCode,
                       PVOID            pInputBuffer,
                       DWORD            dInputBufferSize,
                       PVOID            pOutputBuffer,
                       DWORD            dOutputBufferSize);

NTSTATUS NTAPI
NtFsControlFile (HANDLE           hDevice,
                 HANDLE           hEvent,
                 PIO_APC_ROUTINE  pApcRoutine,
                 PVOID            pApcContext,
                 PIO_STATUS_BLOCK pIoStatusBlock,
                 DWORD            dFsControlCode,
                 PVOID            pInputBuffer,
                 DWORD            dInputBufferSize,
                 PVOID            pOutputBuffer,
                 DWORD            dOutputBufferSize);

NTSTATUS NTAPI
NtOpenEvent (PHANDLE            phEvent,
             ACCESS_MASK        AccessMask,
             POBJECT_ATTRIBUTES pObjectAttributes);

NTSTATUS NTAPI
NtOpenFile (PHANDLE            phFile,
            ACCESS_MASK        AccessMask,
            POBJECT_ATTRIBUTES pObjectAttributes,
            PIO_STATUS_BLOCK   pIoStatusBlock,
            DWORD              dShareAccess,
            DWORD              dOpenOptions);

NTSTATUS NTAPI
NtOpenProcess (PHANDLE            phProcess,
               ACCESS_MASK        AccessMask,
               POBJECT_ATTRIBUTES pObjectAttributes,
               PCLIENT_ID         pClientId);

NTSTATUS NTAPI
NtOpenThread (PHANDLE            phThread,
              ACCESS_MASK        AccessMask,
              POBJECT_ATTRIBUTES pObjectAttributes,
              PCLIENT_ID         pClientId);

NTSTATUS NTAPI
NtQueryInformationProcess (HANDLE           hProcess,
                           PROCESSINFOCLASS pic,
                           PVOID            pData,
                           DWORD            dSize,
                           PDWORD           pdSize);

NTSTATUS NTAPI
NtQueryInformationThread (HANDLE          hThread,
                          THREADINFOCLASS tic,
                          PVOID           pData,
                          DWORD           dSize,
                          PDWORD          pdSize);

NTSTATUS NTAPI
NtQuerySystemTime (PQWORD pqSystemTime);

NTSTATUS NTAPI
NtReplyPort (HANDLE hPort,
             PVOID  pReply);

NTSTATUS NTAPI
NtSetEvent (HANDLE hEvent,
            PLONG  plSignaled); // optional (NULL)

NTSTATUS NTAPI
NtSetInformationProcess (HANDLE           hProcess,
                         PROCESSINFOCLASS pic,
                         PVOID            pData,
                         DWORD            dSize);

NTSTATUS NTAPI
NtSetInformationThread (HANDLE          hThread,
                        THREADINFOCLASS tic,
                        PVOID           pData,
                        DWORD           dSize);

NTSTATUS NTAPI
NtUnmapViewOfSection (HANDLE hProcess,
                      PVOID  pBaseAddress);

NTSTATUS NTAPI
NtWaitForSingleObject (HANDLE hObject,
                       BOOL   fAlertable,
                       PQWORD qTimeout);  // NULL = infinite

// =================================================================
// LOADER API PROTOTYPES
// =================================================================

NTSTATUS NTAPI
LdrDisableThreadCalloutsForDll (HANDLE hModule);

NTSTATUS NTAPI
LdrGetDllHandle (PWORD           pwPath,    // optional (NULL, 1)
                 PVOID           pReserved, // not used (NULL)
                 PUNICODE_STRING pusPath,
                 PHANDLE         phModule);

NTSTATUS NTAPI
LdrGetProcedureAddress (HANDLE  hModule,
                        DWORD   dOrdinal,     // optional (0)
                        PSTRING psName,       // optional (NULL)
                        PPVOID  ppProcedure);

NTSTATUS NTAPI
LdrLoadDll (PWORD           pwPath,    // optional (NULL)
            PDWORD          pdFlags,   // optional (NULL)
            PUNICODE_STRING pusPath,
            PHANDLE         phModule);

NTSTATUS NTAPI
LdrQueryProcessModuleInformation (PSYSTEM_MODULE_INFORMATION psmi,
                                  DWORD             dSize,
                                  PDWORD            pdSize); // opt.

NTSTATUS NTAPI
LdrQueryImageFileExecutionOptions (PUNICODE_STRING pusImagePath,
                                   PWORD           pwOptionName,
                                   DWORD           dRequestedType,
                                   PVOID           pData,
                                   DWORD           dSize,
                                   PDWORD          pdSize); // opt.

NTSTATUS NTAPI
LdrUnloadDll (HANDLE hModule);

// =================================================================
// MEMORY MANAGER API PROTOTYPES
// =================================================================

NTSTATUS NTAPI
MmLoadSystemImage (PUNICODE_STRING pusImageFile,
                   PHANDLE         phSystemImage,
                   PPVOID          ppBaseAddress);

NTSTATUS NTAPI
MmPageEntireDriver (PVOID pBaseAddress);

NTSTATUS NTAPI
MmUnloadSystemImage (HANDLE hSystemImage);

// =================================================================
// RUNTIME LIBRARY API PROTOTYPES
// =================================================================

void NTAPI
RtlAcquirePebLock (void);

PVOID NTAPI
RtlAllocateHeap (HANDLE hHeap,
                 DWORD  dFlags,
                 DWORD  dBytes);

BOOLEAN NTAPI
RtlAreBitsClear (PRTL_BITMAP pBitMapHeader,
                 DWORD       dStartingIndex,
                 DWORD       dLength);

BOOLEAN NTAPI
RtlAreBitsSet (PRTL_BITMAP pBitMapHeader,
               DWORD       dStartingIndex,
               DWORD       dLength);

void NTAPI
RtlClearAllBits (PRTL_BITMAP pBitMapHeader);

void NTAPI
RtlClearBits (PRTL_BITMAP pBitMapHeader,
              DWORD       dStartingIndex,
              DWORD       dNumberToClear);

void NTAPI
RtlDeleteCriticalSection (PCRITICAL_SECTION pCriticalSection);

QWORD NTAPI
RtlEnlargedIntegerMultiply (LONG lMultiplicand,
                            LONG lMultiplier);

DWORD NTAPI
RtlEnlargedUnsignedDivide (QWORD  qDividend,
                           DWORD  dDivisor,
                           PDWORD pdRemainder);

QWORD NTAPI
RtlEnlargedUnsignedMultiply (DWORD dMultiplicand,
                             DWORD dMultiplier);

void NTAPI
RtlEnterCriticalSection (PCRITICAL_SECTION pCriticalSection);

QWORD NTAPI
RtlExtendedIntegerMultiply (QWORD qMultiplicand,
                            LONG  lMultiplier);

QWORD NTAPI
RtlExtendedLargeIntegerDivide (QWORD  qDividend,
                               DWORD  dDivisor,
                               PDWORD pdRemainder);

void NTAPI
RtlFillMemoryUlong (PVOID Destination,
                    DWORD Length,      // bytes, multiple of 4
                    DWORD Fill);

DWORD NTAPI
RtlFindClearBits (PRTL_BITMAP pBitMapHeader,
                  DWORD       dNumberToFind,
                  DWORD       dHintIndex);

DWORD NTAPI
RtlFindClearBitsAndSet (PRTL_BITMAP pBitMapHeader,
                        DWORD       dNumberToFind,
                        DWORD       dHintIndex);

DWORD NTAPI
RtlFindFirstRunClear (PRTL_BITMAP pBitMapHeader,
                      PDWORD      pdStartingIndex);

DWORD NTAPI
RtlFindLongestRunClear (PRTL_BITMAP pBitMapHeader,
                        PDWORD      pdStartingIndex);

DWORD NTAPI
RtlFindFirstRunSet (PRTL_BITMAP pBitMapHeader,
                    PDWORD      pdStartingIndex);

DWORD NTAPI
RtlFindLongestRunSet (PRTL_BITMAP pBitMapHeader,
                      PDWORD      pdStartingIndex);

DWORD NTAPI
RtlFindSetBits (PRTL_BITMAP pBitMapHeader,
                DWORD       dNumberToFind,
                DWORD       dHintIndex);

DWORD NTAPI
RtlFindSetBitsAndClear (PRTL_BITMAP pBitMapHeader,
                        DWORD       dNumberToFind,
                        DWORD       dHintIndex);

BOOL NTAPI
RtlFreeHeap (HANDLE hHeap,
             DWORD  dFlags,
             PVOID  pMemory);

void NTAPI
RtlGenerate8dot3Name (PUNICODE_STRING      puName,
                      BOOLEAN              bAllowExtendedCharacters,
                      PGENERATE_NAME_CONTEXT pContext,
                      PUNICODE_STRING      puName8dot3);

DWORD NTAPI
RtlGetProcessHeaps (DWORD   dNumberOfHeaps,
                    PHANDLE phProcessHeaps);

PVOID NTAPI
RtlImageNtHeader (PVOID pBaseAddress);

void NTAPI
RtlInitializeBitMap (PRTL_BITMAP pBitMapHeader,
                     PDWORD      pdBuffer,
                     DWORD       dSizeOfBitMap);

QWORD NTAPI
RtlLargeIntegerAdd (QWORD qAddend1,
                    QWORD qAddend2);

QWORD NTAPI
RtlLargeIntegerDivide (QWORD  qDividend,
                       QWORD  qDivisor,
                       PQWORD pqRemainder);

QWORD NTAPI
RtlLargeIntegerNegate (QWORD qSubtrahend);

QWORD NTAPI
RtlLargeIntegerSubtract (QWORD qMinuend,
                         QWORD qSubtrahend);

void NTAPI
RtlLeaveCriticalSection (PCRITICAL_SECTION pCriticalSection);

PPROCESS_PARAMS NTAPI
RtlNormalizeProcessParams (PPROCESS_PARAMS pProcessParams);

DWORD NTAPI
RtlNumberOfClearBits (PRTL_BITMAP pBitMapHeader);

DWORD NTAPI
RtlNumberOfSetBits (PRTL_BITMAP pBitMapHeader);

PVOID NTAPI
RtlReAllocateHeap (HANDLE hHeap,
                   DWORD  dFlags,
                   PVOID  pMemory,
                   DWORD  dBytes);

void NTAPI
RtlReleasePebLock (void);

void NTAPI
RtlSetAllBits (PRTL_BITMAP pBitMapHeader);

void NTAPI
RtlSetBits (PRTL_BITMAP pBitMapHeader,
            DWORD       dStartingIndex,
            DWORD       dNumberToSet);

DWORD NTAPI
RtlSetCriticalSectionSpinCount (PCRITICAL_SECTION pCriticalSection,
                                DWORD             dSpinCount);

DWORD NTAPI
RtlSizeHeap (HANDLE hHeap,
             DWORD  dFlags,
             PVOID  pMemory);

void NTAPI
RtlTimeToTimeFields (PQWORD       pqTime,
                     PTIME_FIELDS pTimeFields);

BOOLEAN NTAPI
RtlTimeFieldsToTime (PTIME_FIELDS pTimeFields,
                     PQWORD       pqTime);

BOOL NTAPI
RtlTryEnterCriticalSection (PCRITICAL_SECTION pCriticalSection);

// =================================================================
// LINKER CONTROL
// =================================================================

#pragma comment (linker, "/defaultlib:ntdll.lib")

// =================================================================
// END OF MAIN #ifndef CLAUSE
// =================================================================

#endif // _NTDLL_H_

// =================================================================
// END OF FILE
// =================================================================
