/* Process Memory Dumper
 *
 * Author: Evilcry
 * WebSite: http://evilcry.altervista.org
 *   
	Copyright 2007,2008,2999 Giuseppe Bonfa'

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

    http://www.gnu.org/licenses/gpl.txt
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <tchar.h>
#include <psapi.h>
#include "memwalk.h"


#pragma comment(lib,"psapi")

void PrintProcessInfos(DWORD indexProcess)
{
	TCHAR szProcessName[MAX_PATH] = TEXT("<unknown>");

    HANDLE hProcess = OpenProcess( PROCESS_QUERY_INFORMATION | PROCESS_VM_READ,
		FALSE, indexProcess );

    if (NULL != hProcess)
    {
        HMODULE hMod;
        DWORD cbNeeded;

        if ( EnumProcessModules(hProcess, &hMod, sizeof(hMod),
             &cbNeeded) )
        {
            GetModuleBaseName( hProcess, hMod, szProcessName,
                               sizeof(szProcessName)/sizeof(TCHAR) );
        }
    }
    _tprintf( TEXT("%s\t(PID: %u)\tHex: %xh\n"), szProcessName, indexProcess,indexProcess );

    CloseHandle( hProcess );
}

 
int GainPrivileges()
{
	HANDLE hToken;
	BOOL bEnablePRivilege = TRUE;
	LUID luid;
	TOKEN_PRIVILEGES tp;

	if(!OpenProcessToken(GetCurrentProcess(),TOKEN_ADJUST_PRIVILEGES,&hToken))
	{
		    printf("Can't Gain Privileges \n");
			return(EXIT_FAILURE);
	}

	if(!LookupPrivilegeValueA(NULL,"SeDebugPrivilege",&luid))
	{
		printf("SeDebugPrivilege Setup Failed \n");
		return(EXIT_FAILURE);
	}
	
	tp.PrivilegeCount = 1;
	tp.Privileges[0].Luid = luid;
	tp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	if(!AdjustTokenPrivileges(hToken,FALSE,&tp,sizeof(TOKEN_PRIVILEGES),
		FALSE,FALSE))
	{
		return(EXIT_FAILURE);
	}

	CloseHandle(hToken);
	return(EXIT_SUCCESS);
}



int main()
{
	MEMORY_BASIC_INFORMATION mbi;
	LPVMOBJECT lpList;
	SYSTEM_INFO si;
	LPVOID lpMem, lpUncommited, memStep;
	LPVOID readBuff;
	DWORD aProcesses[1024];
	DWORD cbNedded;
	DWORD cProcesses;
	DWORD hPid=0;
	DWORD dwSize, dwIndex, dwBread, dwBwrite;
	HANDLE hProcess;
	HANDLE hFile;

	unsigned int i;

	printf("Sample Memory Reader for Password Disclosure Stuff\n");
	printf("\n Process Listing... \n");
	printf("*------------------------------------*\n");

	if(!EnumProcesses(aProcesses,sizeof(aProcesses),&cbNedded))
		return (EXIT_FAILURE);
	
	cProcesses = cbNedded / sizeof(DWORD);

	for( i = 0; i<cProcesses; i++)
		PrintProcessInfos(aProcesses[i]);

	printf("Enter PID: \t");
	scanf("%d",&hPid);

	hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ | PROCESS_VM_OPERATION,
		NULL, hPid);
	
	if( hProcess == NULL)
	{
		printf("Failed to open the Process: %d",hPid);
		return (EXIT_FAILURE);
	}

	hFile = CreateFileA("Dump", FILE_ALL_ACCESS, FILE_SHARE_WRITE, NULL,
		OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
	
	if(hFile == INVALID_HANDLE_VALUE)
	{
		printf("Can't Create the File Dump\n");
		return( EXIT_FAILURE);
	}

	if ( GainPrivileges() == EXIT_FAILURE )
	{
		printf("Failed to Gain SeDebugPrivileges \n");
			return(EXIT_FAILURE);
	}

	// Let's begin the Memory Walk

	GetSystemInfo(&si);

	dwSize = TOTALVMRESERVE;

	memStep = VirtualAlloc(NULL, TOTALVMRESERVE, MEM_RESERVE, PAGE_NOACCESS);

	if(memStep == NULL)
		return(EXIT_FAILURE);

	lpList = (LPVMOBJECT)memStep;
	lpUncommited = (LPVOID)memStep;
	
	lpMem =	0;
	dwIndex = 0;

	while(lpMem < si.lpMaximumApplicationAddress)
	{
		if(((int)lpList + 4096) >= ((int)memStep + TOTALVMRESERVE))
			return(EXIT_FAILURE);

		if(lpList + sizeof(VMOBJECT) >= lpUncommited )
		{
			if( VirtualAlloc(lpUncommited,4096,MEM_COMMIT,PAGE_READWRITE) == NULL)
			{
				printf("A problem occurred in Memory Walking\n");
					return(EXIT_FAILURE);
			}

			lpUncommited = (LPVOID)((DWORD)lpList+ (DWORD)4096);
		}

		*lpList->szObjType = 0;
	    *lpList->szModule = 0;
	    *lpList->szSection = 0;
	    lpList->bNew = 0;

		VirtualQueryEx(hProcess,lpMem,&(lpList->mbi),sizeof(MEMORY_BASIC_INFORMATION));

		lpMem = (LPVOID)((DWORD)lpList->mbi.BaseAddress +
			     (DWORD)lpList->mbi.RegionSize);

		
		readBuff = VirtualAlloc(NULL,lpList->mbi.RegionSize,MEM_COMMIT,PAGE_READWRITE);

		ReadProcessMemory(hProcess,lpList->mbi.BaseAddress,readBuff,
			lpList->mbi.RegionSize,&dwBread);
		
		WriteFile(hFile,readBuff,dwBread,&dwBwrite,NULL);
		
		VirtualFree(readBuff,lpList->mbi.RegionSize, MEM_DECOMMIT);
		
		lpList++;
		++dwIndex;

	}

	CloseHandle(hProcess);
	CloseHandle(hFile);
	return(EXIT_SUCCESS);
}

