#include <stdio.h>
#include <windows.h>
#include "resource.h"
#include <miracl.h>
#include "md5.c"

HINSTANCE	hInst;

extern void _LengthToString(len,buffer);
extern void _ScrambleString(srcbuffer,len,destbuffer);

BOOL CALLBACK DialogProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{	

	unsigned char szName[100] = {0};
	unsigned char szHash[17] = {0};
	unsigned char bfSerial1[100] = {0};
	unsigned char bfSerial2[100] = {0};
	unsigned char szSerial[100] = {0};
	unsigned char szDash[2] = "-";
	long dtLength,dtChecksum,i;
	MD5_CTX md5context;
	big M,n,e;
	miracl *mip=mirsys(100,0);

	switch (message)
	{    
	case WM_CLOSE:
		EndDialog(hWnd,0);
		break;
	case WM_COMMAND:
		switch (LOWORD(wParam))
		{ 
		case IDC_GENERATE:
			dtLength=GetDlgItemText(hWnd, IDC_EDITNAME, szName, 100);
			if (dtLength<5) {
				SetDlgItemText(hWnd, IDC_EDITSERIAL, "at least 5 characters");
				break;
			}

			// modify the length
			dtLength=dtLength*dtLength*dtLength;
			dtLength=dtLength*dtLength;

			// convert modified length to string and scramble it
			_LengthToString(dtLength,&bfSerial1);
			_ScrambleString(&bfSerial1,strlen(&bfSerial1),&bfSerial2);

			lstrcpy(&szSerial,&bfSerial2);

			// generate the dword to hash
			for (i=0;i<4;i++){
				bfSerial2[i]=(((szName[i]^5)*0xFE) & 9) + 0x30;
			}
			bfSerial2[4]&=0;
			lstrcat(&szSerial,&bfSerial2);

			// generate the checksum
			dtChecksum=1;
			for (i=0;i<strlen(&szName);i++){
				dtChecksum*=szName[i];
			}

			// compute the dword to hash
			__asm{
				mov     ecx, dtChecksum
				lea     eax, [ecx*8]
				sub     eax, ecx
				shl     eax, 9
				add     eax, ecx
				lea     edx, [eax+eax*8]
				lea     eax, [ecx+edx*8]
				lea     eax, [eax+eax*2]
				shl     eax, 1
				xor     eax, 12344321h
				lea		esi, bfSerial2
				mov     dword ptr [esi], eax
			}

			// hash the dword
			MD5Init(&md5context);
			MD5Update(&md5context,&bfSerial2,4);
			MD5Final(&szHash,&md5context);

			mip->IOBASE=16;
			M=mirvar(0);
			n=mirvar(0);
			e=mirvar(0);

			cinstr(n,"D1D17744CA3D0C09");
			cinstr(e,"B54341B5A81ED9CF");

			bytes_to_big(16,&szHash,M);
			cotstr(M,&bfSerial2);
			lstrcat(&szSerial,&bfSerial2);
			lstrcat(&szSerial,&szDash);

			convert(dtChecksum,M);
			insign(PLUS,M);
			powmod(M,e,n,M);

			mip->IOBASE=60;

			cotstr(M,&bfSerial2);
			lstrcat(&szSerial,&bfSerial2);

			mirkill(M);
			mirkill(n);
			mirexit();

			SetDlgItemText(hWnd, IDC_EDITSERIAL, szSerial);
			break;
		case IDC_ABOUT:
			MessageBox(hWnd, "keygenerator for thigo' s keygenme 4\nprotection: md5 and rsa-64", "about", MB_OK);
			break;
		}
		break;
	case WM_INITDIALOG:
		SendMessageA(hWnd,WM_SETICON,(WPARAM) 1,(LPARAM) LoadIconA(hInst,MAKEINTRESOURCE(IDI_ICON)));
		break;
	}
     return 0;
}

int WINAPI WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	hInst=hInstance;
	DialogBoxParam(hInstance, MAKEINTRESOURCE(IDD_DIALOG1), NULL, (DLGPROC)DialogProc,0);
	return 0;
}
