.486
.model flat,stdcall

_LoadOps		proto	:dword

			include \masm32\include\kernel32.inc
			include	\masm32\include\user32.inc
			include	\masm32\include\windows.inc

			includelib \masm32\lib\kernel32.lib
			includelib \masm32\lib\user32.lib

; html/text output flag
bHTMLOUTPUT		equ	TRUE

; structures and constants
OP			STRUCT
	bFlags		db	?
	dtImmInfo	db	?
	OpGroup		db	?
	OpCode		db	?
	rOffset		dd	?
	Op1		dd	?
	Op2		dd	?
	Op3		dd	?
OP			ENDS

fLABEL			equ	0001b
fPROC			equ	0010b
fIMM			equ	0100b

.data
bfAsm			db	500 dup (0)
bfFormat		db	100 dup (0)
bfAddress		db	7 dup (0)
szFileName		db	'data.cod',0	; decrypted data.bin

IF (bHTMLOUTPUT)
	szFileNameD		db	'data.htm',0
ELSE
	szFileNameD		db	'data.asm',0
ENDIF

dtCodePos		dd	0

; emulator
dtEip			dd	0
dtIncEip		dd	0
dtMem			dd	0

.data?
; disasembler
hFile			dd	?
dtBytes			dd	?
dtDataLen		dd	?
ptData			dd	?
ptCode			dd	?
ptAsm			dd	?

.code

			include	procs.asm

start:			; open cod file and read to buffer
			invoke	CreateFileA,addr szFileName,GENERIC_READ,0,0,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,0
			mov	hFile,eax
			invoke	GetFileSize,eax,0
			mov	dtDataLen,eax
			invoke	GlobalAlloc,GPTR,eax
			mov	ptData,eax
			invoke	ReadFile,hFile,eax,dtDataLen,addr dtBytes,0
			invoke	CloseHandle,hFile

			; initializes memory
			invoke	GlobalAlloc,GPTR,0fffffh
			mov	ptCode,eax
			invoke	GlobalAlloc,GPTR,0fffffh
			mov	ptAsm,eax

			; disasm engine
			mov	edi,ptCode
__EngineLoop:		mov	dtIncEip,0
			mov	esi,dtEip
			add	esi,ptData

			mov	eax,dtEip
			mov	(OP ptr [edi]).rOffset,eax

			movzx	eax,byte ptr [esi]
			shr	eax,4 ; action

			cmp	eax,0
			jz	__OpCode0
			cmp	eax,1
			jz	__OpCode0
			cmp	eax,2
			jz	__OpCode0
			cmp	eax,3
			jz	__OpCode3
			cmp	eax,4
			jz	__OpCode0
			cmp	eax,5
			jz	__OpCode5
			cmp	eax,6
			jz	__OpCode6
			cmp	eax,8
			jz	__IOpCode0
			cmp	eax,9
			jz	__IOpCode0
			cmp	eax,10
			jz	__IOpCode0
			cmp	eax,11
			jz	__IOpCode3
			cmp	eax,12
			jz	__IOpCode0
			cmp	eax,14
			jz	__OpCode6
			cmp	eax,15
			jz	__Flow
			inc	dtIncEip
			jmp	__EngineReturn
;____________________________________________________________________________
__IOpCode0:		mov	dtIncEip,1
			sub	al,8
			mov	(OP ptr [edi]).OpGroup,al
			movzx	eax,byte ptr [esi]
			and	al,0fh
			mov	(OP ptr [edi]).OpCode,al
			or	(OP ptr [edi]).bFlags,fIMM
			mov	al,byte ptr [esi+1]
			shr	al,2
			mov	(OP ptr [edi]).dtImmInfo,al

			invoke	_LoadOps,eax

			mov	(OP ptr [edi]).Op1,eax
			mov	(OP ptr [edi]).Op2,ebx

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__IOpCode3:		mov	dtIncEip,3
			mov	(OP ptr [edi]).OpGroup,3
			movzx	eax,byte ptr [esi]
			and	al,07h
			mov	(OP ptr [edi]).OpCode,al

			.IF (al==0)
			movzx	edx,word ptr [esi+1]
			.ELSE
			or	(OP ptr [edi]).bFlags,fIMM
			mov	al,byte ptr [esi+1]
			shr	al,2
			mov	(OP ptr [edi]).dtImmInfo,al

			invoke	_LoadOps,eax

			mov	(OP ptr [edi]).Op1,eax
			mov	(OP ptr [edi]).Op2,ebx

			mov	eax,esi
			add	eax,dtIncEip
			movzx	edx,word ptr [eax-2]
			.ENDIF

			movzx	eax,byte ptr [esi]

			test	al,8
			jz	@f
			neg	edx
@@:			add	edx,dtEip
			add	edx,dtIncEip
			mov	(OP ptr [edi]).Op3,edx

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__OpCode0:		mov	dtIncEip,2

			mov	(OP ptr [edi]).OpGroup,al
			movzx	eax,byte ptr [esi]
			and	al,0fh
			mov	(OP ptr [edi]).OpCode,al
			movzx	eax,byte ptr [esi+1]
			mov	edx,eax
			and	eax,0fh
			shl	eax,2
			mov	(OP ptr [edi]).Op1,eax
			shr	edx,4
			shl	edx,2
			mov	(OP ptr [edi]).Op2,edx

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__OpCode3:		mov	dtIncEip,3

			mov	(OP ptr [edi]).OpGroup,3
			movzx	eax,byte ptr [esi]
			mov	bl,al
			and	al,07h
			mov	(OP ptr [edi]).OpCode,al

			.IF (al==0)
			movzx	edx,word ptr [esi+1]
			.ELSE
			inc	dtIncEip
			movzx	eax,byte ptr [esi+1]
			mov	edx,eax
			and	eax,0fh
			shl	eax,2
			mov	(OP ptr [edi]).Op1,eax
			shr	edx,4
			shl	edx,2
			mov	(OP ptr [edi]).Op2,edx
			movzx	edx,word ptr [esi+2]
			.ENDIF

			test	bl,8
			jz	@f
			neg	edx
@@:			add	edx,dtEip
			add	edx,dtIncEip
			mov	(OP ptr [edi]).Op3,edx

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__OpCode5:		mov	dtIncEip,1

			mov	(OP ptr [edi]).OpGroup,5
			movzx	eax,byte ptr [esi]
			and	al,0fh
			mov	(OP ptr [edi]).OpCode,al

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__OpCode6:		mov	dtIncEip,1
			mov	(OP ptr [edi]).OpGroup,6
			movzx	eax,byte ptr [esi]
			and	al,0fh
			mov	(OP ptr [edi]).OpCode,al

			.IF (al==0)
				add	dtIncEip,2
				movzx	eax,word ptr [esi+1]
				add	eax,dtIncEip
				sub	eax,0400h	; code base
				mov	(OP ptr [edi]).Op3,eax
			.ELSEIF (al==2 || al==3)
				or	(OP ptr [edi]).bFlags,fIMM
				mov	al,byte ptr [esi+1]
				shr	al,2
				mov	(OP ptr [edi]).dtImmInfo,al

				invoke	_LoadOps,eax

				mov	(OP ptr [edi]).Op1,eax
				sub	ebx,60h
				mov	(OP ptr [edi]).Op2,ebx
			.ENDIF

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________
__Flow:			mov	dtIncEip,1

			mov	(OP ptr [edi]).OpGroup,15
			movzx	eax,byte ptr [esi]
			and	al,0fh
			sub	al,0eh
			mov	(OP ptr [edi]).OpCode,al

			inc	dtCodePos
			add	edi,SIZEOF OP
			jmp	__EngineReturn
;____________________________________________________________________________

__EngineReturn:		mov	eax,dtIncEip
			add	dtEip,eax

			mov	eax,dtEip
			cmp	dtDataLen,eax
			jg	__EngineLoop	; loop while we have to disasm

;____________________________________________________________________________
			; second pass, check for jumps
			mov	esi,ptCode
			mov	ecx,dtCodePos
__LoopCode:		mov	al,(OP ptr [esi]).OpGroup
			mov	bl,(OP ptr [esi]).OpCode

			.IF (al==3 || (al==6 && bl==0))
				; search
				mov	edi,ptCode
				mov	ebx,dtCodePos
				mov	edx,(OP ptr [esi]).Op3
__LoopSearch:			cmp	edx,(OP ptr [edi]).rOffset
				jz	__SetFlag
				add	edi,SIZEOF OP
				dec	ebx
				jnz	__LoopSearch

				jmp	@f

__SetFlag:			.IF (al==3)
					or	(OP ptr [edi]).bFlags,fLABEL
				.ELSEIF (al==6)
					or	(OP ptr [edi]).bFlags,fPROC
				.ENDIF
			.ENDIF

@@:			add	esi,SIZEOF OP
			dec	ecx
			jnz	__LoopCode
;

.data

szAddressFormat		db	'%04X:',0
szTab			db	09h,0
szTabs			db	09h,09h,0
szCRLF			db	13,10,0

IF (bHTMLOUTPUT)
	szLoc			db	'<A HREF=#loc_%X>loc_%X</A>',0
	szSub			db	'<A HREF=#sub_%X>sub_%X</A>',0
	szLocationFormat	db	' <A CLASS=hl NAME=loc_%X>loc_%X</A>:',0
	szSubFormat		db	' <A CLASS=hl NAME=sub_%X>sub_%X',09h,'proc</A>',0
	szSubEndFormat		db	' <SPAN CLASS=hl>sub_%X',09h,'endp</SPAN>',0
	szHeader		db	'<STYLE>',13,10
				db	'.hl{color:880000}',13,10
				db	'.w{color:FF0000}',13,10
				db	'a{text-decoration:none;color:0000BB}',13,10
				db	'a:hover{color:0000FF}',13,10
				db	'pre{font-family:fixedsys}',13,10
				db	'</STYLE>',13,10
				db	'<PRE>',13,10
				db	';OP1S=DATA',13,10
				db	';OP2S=DATA',13,10
				db	'0000: <SPAN CLASS=hl>start</SPAN>:',13,10,0
	szFooter		db	'</PRE>',13,10,0
ELSE
	szLoc			db	'loc_%X',0
	szSub			db	'sub_%X',0
	szLocationFormat	db	' loc_%X:',0
	szSubFormat		db	' sub_%X',09h,'proc',0
	szSubEndFormat		db	' sub_%X',09h,'endp',0
	szHeader		db	';OP1S=DATA',13,10
				db	';OP2S=DATA',13,10
				db	'0000: start:',13,10,0
ENDIF

dtCurrentSub		dd	0

.code

			; generate asm file
			mov	esi,ptCode
			invoke	lstrcpy,ptAsm,addr szHeader
__GenerateAsm:		mov	ebx,(OP ptr [esi]).rOffset
			invoke	wsprintfA,addr bfAddress,addr szAddressFormat,ebx
			invoke	lstrcpy,addr bfAsm,addr bfAddress
			mov	al,(OP ptr [esi]).bFlags
			.IF (al & fLABEL)
				IF (bHTMLOUTPUT)
					invoke	wsprintfA,addr bfFormat,addr szLocationFormat,ebx,ebx
				ELSE
					invoke	wsprintfA,addr bfFormat,addr szLocationFormat,ebx
				ENDIF
				invoke	lstrcat,addr bfAsm,addr bfFormat
				invoke	lstrcat,addr bfAsm,addr szCRLF
				invoke	lstrcat,addr bfAsm,addr bfAddress
			.ELSEIF (al & fPROC)
				mov	dtCurrentSub,ebx
				IF (bHTMLOUTPUT)
					invoke	wsprintfA,addr bfFormat,addr szSubFormat,ebx,ebx
				ELSE
					invoke	wsprintfA,addr bfFormat,addr szSubFormat,ebx
				ENDIF
				invoke	lstrcat,addr bfAsm,addr bfFormat
				invoke	lstrcat,addr bfAsm,addr szCRLF
				invoke	lstrcat,addr bfAsm,addr bfAddress
			.ENDIF
			invoke	lstrcat,addr bfAsm,addr szTabs

			include	ASMopcodes.asm

			invoke	lstrcat,addr bfAsm,addr szCRLF
			invoke	lstrcat,ptAsm,addr bfAsm

			add	esi,SIZEOF OP
			dec	dtCodePos
			jnz	__GenerateAsm

			IF (bHTMLOUTPUT)
				invoke	lstrcat,ptAsm,addr szFooter
			ENDIF

			; outputs asm file
			invoke	CreateFileA,addr szFileNameD,GENERIC_WRITE,0,0,CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL,0
			mov	hFile,eax

			invoke	lstrlen,ptAsm
			invoke	WriteFile,hFile,ptAsm,eax,addr dtBytes,0

			invoke	CloseHandle,hFile

			invoke	ExitProcess,0

			end	start
