#include <iostream>
#include <cstdlib>
#include "windows.h"
#include "modrmd160.h"
#include "modblowfish.h"

using namespace std;

typedef unsigned char BYTE;
typedef unsigned long DWORD;

inline DWORD &bswap(DWORD &x)
{
	__asm
	{
		mov eax, x
		mov ebx, [eax]
		bswap ebx
		mov [eax], ebx
	}
	return x;
}

int main(void)
{
	BYTE szName[101];
	int nLen;
	cout << "Name : ";
	cin >> szName;
	cout << endl;
	nLen = strlen((const char *)szName);
	if (nLen < 1 || nLen > 100)
		return 0;

	DWORD digest[5];
	modMDinit(digest);
	modMDfinish(digest, szName, nLen, 0);

	DWORD serial[4] = { 1685024583, 1970239794, 1684628530, 779381042 };
	modBLOWFISH_CTX ctxModBlowfish;
	modBlowfish_Init(&ctxModBlowfish, digest);
	modBlowfish_Decrypt(&ctxModBlowfish, &serial[2], &serial[3]);
	modBlowfish_Decrypt(&ctxModBlowfish, &serial[1], &serial[2]);
	modBlowfish_Decrypt(&ctxModBlowfish, &serial[0], &serial[1]);

	BYTE szSerial[33] = { 0 };
	wsprintf((char *)szSerial, "%08X%08X%08X%08X", bswap(serial[0]), bswap(serial[1]), bswap(serial[2]), bswap(serial[3]));

	cout << szSerial;
	cout << endl;

	return 0;
}
