/*
 * Author     :  Paul Kocher
 * E-mail     :  pck@netcom.com
 * Date       :  1997
 * Description:  C implementation of the Blowfish algorithm.
 */

#define MAXKEYBYTES 56          /* 448 bits */
#define N 30

typedef struct {
  unsigned long P[N + 2];
  unsigned long S[4][256];
} modBLOWFISH_CTX;

void modBlowfish_Init(modBLOWFISH_CTX *ctx, unsigned long *key);
void modBlowfish_Encrypt(modBLOWFISH_CTX *ctx, unsigned long *xl, unsigned long *xr);
void modBlowfish_Decrypt(modBLOWFISH_CTX *ctx, unsigned long *xl, unsigned long *xr);
