;
; Load IAT list from file (C) G-RoM in 1999, 2000
;
;
; Hydra example Plugin
;
; Purpose    : this plugin will load IAT list from a file called IATLIST.SAM
; Format ex. : 000225FC  00000114  D:\WINNT\SYSTEM32\KERNEL32.dll
;
;
; Started on    : 08th August  2000
; Latest update : 28th August  2000 (IATStorage struct change)
;
		BITS 32

		%include "win32n.inc"  ; Constants
		%include "pedata.inc" ; Structs
		%include "common.inc" ; Protos
		%include "memio.inc"  ; Protos
		%include "fileio.inc" ; Protos
;
; Local struct
;
Struc IATFile
 .IATStart	RESB 8
 .Sep1		RESB 3
 .IATSize	RESB 8
 .Sep2		RESB 3
 .FileName	RESB 100h
EndStruc

;
; Public definitions.
;
global ProcessIAT			; Our export function
global _Start@12			; Main

;
; Code definition.
;
SEGMENT .text	USE32 CLASS=CODE

ThunkFile	DB "IATLIST.SAM",0      ; Hardcoded filename

;
; Locate DLL.
;

;
;esp+4 : DLL List.
;esp+8 ; DLL name to locate.
;
;eax=DLLPointer on success.
;
LocateDLL:
	push	ebp
	mov	ebp, esp
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

	mov	edi, [ebp+0ch]
	push	edi
	Call	CharUpper		; We are never too paranoid.

	mov	esi, [ebp+08h]
	sub	esi, DLLList_size
.LoopP:
	add	esi, DLLList_size
	xor	eax, eax
	cmp	[esi+DLLList.ModPath], eax
	jz	.ItIsOver	

	lea	ebx, [esi+DLLList.ModPath]

	push	ebx
	push	edi
	Call	strcmp
	test	eax, eax
	jnz	.LoopP

	mov	eax, esi

.ItIsOver:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	pop	ebp
	retn	08h

;
; Load ALL IAT thunk.
;

;
;esp+4 : PE Buffer.
;esp+8 : PE Infos.
;esp+c : DLL List.
;esp+10; IAT Buffer.
;
;eax=1 on success.
;
ProcessIAT:
	push	ebp
	mov	ebp, esp
	sub	esp, byte 0Ch
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

;
; Allocate DLL List file size.
;
	push	dword ThunkFile
	Call	GetFileSize32
	mov	[ebp-0Ch],eax

	push	eax
	Call	GetMem
	test	eax, eax
	jz	near .EndLoad

	mov	[ebp-8], eax

;
; Read IAT List file in memory.
;
	push	dword GENERIC_READ
	push	byte OPEN_EXISTING
	push	dword ThunkFile
	Call	OpenFile32
	inc	eax
	jz	near .EndFreeLoad

	dec	eax
	mov	[ebp-4], eax

	push	dword [ebp-0Ch]
	push	dword [ebp-08h]
	push	dword [ebp-04h]
	Call	ReadFile32

	push	eax
	push	dword [ebp-04]
	Call	CloseFile32
	pop	eax
	test	eax, eax
	jz	near .EndFreeLoad

;
; Proceed Line by line IAT infos.
;
	mov	esi, [ebp-08h]		; Source File
	mov	edi, [ebp+14h]		; Dest Buffer
	xor	ecx, ecx

.SaveInfos:
	test	eax, eax
	jz      .SaveBufferInfo

	xor	eax, eax
	cmp	[esi], eax
	jz      .SaveBufferInfo

;
; Save Start and End IAT infos.
;
	mov	byte [esi+IATFile.Sep1], al	; Base End
	mov	byte [esi+IATFile.Sep2], al	; Size end
	push	esi
	Call	Hex2Dec
	mov	[edi+IATStorage.IATStart], eax
	add	esi, byte IATFile.IATSize
	push	esi
	Call	Hex2Dec
	mov	[edi+IATStorage.IATLength], eax
	add	esi, byte (IATFile.FileName-IATFile.IATSize)
	mov	ebx, esi

;
; Proceed DLL name.
;
.FindCrap:
	lodsb
	test	al, al
	jz	.LookupDLL

	cmp	al, 0Dh
	jnz	.FindCrap

	xor	eax, eax
	mov	[esi-1], al
	inc	esi			; skip 0A

.LookupDLL:
	push	ebx
	push	dword [ebp+10h]
	Call	LocateDLL
	mov	[edi+IATStorage.Module], eax

;
; Deal with next line.
;
	add	edi, byte IATStorage_size
	jmp	short .SaveInfos

;
; Save IAT List Buffer
;
.SaveBufferInfo:
	xor	eax, eax
	inc	eax

.EndFreeLoad:
	push	eax
	push	dword [ebp-08h]		; Destroy tmp file buffer
	Call	FreeMem
	pop	eax

.EndLoad:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	add	esp, byte 0Ch
	pop	ebp
	retn	10h

;
; DLLMAIN.
;

;
;
;
_Start@12:
	push	byte 01h
	pop	eax
	retn	0ch
