//////////////////////////////////////////////////////////////////////////////
// YogaPlayDlg.h
//
// Yoga MPEG Audio Player
//
// 09/11/1999	fOSSiL		Initial version
//

/////////////////////////////////////////////////////////////////////////////
// CStereoDisplay window

class CStereoDisplay : public CStatic
{
// Construction
public:
	CStereoDisplay();

// Attributes
public:

// Operations
public:
	void SetText(LPCTSTR Text);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CStereoDisplay)
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CStereoDisplay();

	// Generated message map functions
protected:
	void Redraw(CDC* pDC = NULL);
	CString sText;
	CFont Font;

	//{{AFX_MSG(CStereoDisplay)
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	//}}AFX_MSG

	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////
// CYogaPlayDlg dialog

class CYogaPlayDlg : public CDialog
{
// Construction
public:
	CMenu Menu;
	CYogaPlayDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CYogaPlayDlg)
	enum { IDD = IDD_YOGAPLAY_DIALOG };
	CSliderCtrl	Volume;
	CSliderCtrl	SongPos;
	CButton	btnEject;
	CButton	btnRewind;
	CButton	btnFastFwd;
	CButton	btnPause;
	CButton	btnStop;
	CButton	btnPlay;
	CStereoDisplay Display;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CYogaPlayDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual void OnOK();
	virtual void OnCancel();
	//}}AFX_VIRTUAL

// Implementation
protected:
	void OnVolumeChange();
	void OnSongPosChange(UINT nSBCode);
	void RefreshVolume();
	int bUpdatePos;
	int bContPlay;
	void RefreshDisplay();
	void UpdateStatus();
	int bPlaying;
	int bPaused;
	int bPlayerBusy;
	int AskFiles();
	int bTimeFwd;
	CImageList BtnImages;
	HICON m_hIcon;
	HACCEL m_hAccel;

	// Generated message map functions
	//{{AFX_MSG(CYogaPlayDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnHelpAbout();
	afx_msg void OnHelp();
	afx_msg void OnTrackTimeWay();
	afx_msg void OnContPlay();
	afx_msg void OnFileOpen();
	afx_msg void OnEject();
	afx_msg void OnStop();
	afx_msg void OnPause();
	afx_msg void OnPlay();
	afx_msg void OnSkipBackward();
	afx_msg void OnSkipForward();
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg BOOL OnHelpInfo(HELPINFO* pHelpInfo);
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnActivate(UINT nState, CWnd* pWndOther, BOOL bMinimized);
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
