%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"


global Parse_HaspCode


extern sdata
extern Parser.errorMsg
extern ParseExpression


bits 32


segment _LTEXT
;-------------------------------------------------------------------------------
; HASPCODE <pwd1> <pwd2> <seed>
;-------------------------------------------------------------------------------
Parse_HaspCode:
	mov	edi,Error_BadPWD1
	call	ParseExpression		; parse <pwd1>
	jb	near Parser.errorMsg

	mov	[pwd1],ax

	call	[pSkipWhiteSpace]	; skip to <pwd2>
	jnz	@F

	mov	edi,Error_NoPWD2
	jmp	Parser.errorMsg

@@
	mov	edi,Error_BadPWD2
	call	ParseExpression		; parse <pwd2>
	jb	near Parser.errorMsg

	mov	[pwd2],ax

	call	[pSkipWhiteSpace]	; skip to <seed>
	jnz	@F

	mov	edi,Error_NoSEED
	jmp	Parser.errorMsg

@@
	mov	edi,Error_BadSEED
	call	ParseExpression		; parse <seed>
	jb	near Parser.errorMsg

	mov	[seed],ax

	call	HaspCode

	call	[pUpdateSomeWindows]	; we wanna see it, don't we ;-)

	popad
	retn

;-------------------------------------------------------------------------------
; courtesy of CrackZ
;-------------------------------------------------------------------------------
HaspCode:
	mov	edx,HaspBuffer
	movzx	eax,word [pwd2]		; Password 2
	movzx	ebx,word [pwd1]		; Password 1
	shl	eax,10h
	mov	ax,bx
	mov	[edx],eax
	xor	dword [edx], 09071966h
	xor	eax,eax			; Clear eax
	call	sub_401108

	xor	ebx,ebx
	mov	edi,HaspBuffer+14h

loc_4011F9:
	xor	eax,eax
	mov	esi,eax
	jmp	short loc_401220

loc_4011FF:
	movsx	edx,byte [ebx+HaspBuffer+4]
	shl	edx,3
	lea	ecx,[edx+HaspTable]	; Points at table entry.
	mov	eax,esi
	mov	dl,[eax+ecx]
	mov	ecx,esi
	shl	ecx,3
	add	ecx,ebx
	mov	[edi+ecx],dl
	inc	esi
	
loc_401220:
	cmp	esi,byte 8
	jb	loc_4011FF

	inc	ebx
	cmp	ebx,byte 8
	jb	loc_4011F9

	call	sub_40112E
	retn
	
;------ Functions ------

sub_401108:
	mov	cl,[edx]
	and	cl,7
	mov	[edx+eax+4],cl
	sar	dword [edx],3
	inc	ax
	cmp	ax,8
	jl	sub_401108

	retn

sub_40112E:
	movzx	ecx,word [seed]		; Seed Code
	mov	ax,cx
	lea	edi,[HaspBuffer+0Ch]
	xor	esi,esi

loc_40113E:
	mov	byte [esi+edi],0
	xor	edx,edx

loc_401144:
	movzx	eax,ax
	imul	ecx,eax,01989h
	mov	eax,ecx
	add	ax,5
	mov	ecx,7
	sub	ecx,edx
	movzx	ebx,ax
	sar	ebx,9
	and	ebx,3Fh
	mov	bl,[ebx+HaspBuffer+14h]
	shl	bl,cl
	or	[edi+esi],bl
	inc	dx
	cmp	dx,8
	jl	loc_401144

	inc	si
	cmp	si,8
	jl	loc_40113E

	movzx	eax,word [edi]
	mov	esi,[dClient_EAX]
	mov	[esi],eax

	movzx	eax,word [edi+2]
	mov	esi,[dClient_EBX]
	mov	[esi],eax

	movzx	eax,word [edi+4]
	mov	esi,[dClient_ECX]
	mov	[esi],eax

	movzx	eax,word [edi+6]
	mov	esi,[dClient_EDX]
	mov	[esi],eax

	retn


segment _LDATA
Error_BadPWD1:		db 'cannot evaluate <pwd1>',0
Error_NoPWD2:		db 'missing <pwd2>',0
Error_BadPWD2:		db 'cannot evaluate <pwd2>',0
Error_NoSEED:		db 'missing <seed>',0
Error_BadSEED:		db 'cannot evaluate <seed>',0

	align 4
pwd1:		dw 0
pwd2:		dw 0
seed:		dw 0
HaspBuffer:	times 84 db 0
HaspTable:	db 00h,00h,00h,00h,00h,00h,00h,00h,00h,01h,00h,01h,00h,01h,00h,01h
		db 01h,00h,01h,00h,01h,00h,01h,00h,00h,00h,01h,01h,00h,00h,01h,01h
		db 01h,01h,00h,00h,01h,01h,00h,00h,00h,00h,00h,00h,01h,01h,01h,01h
		db 01h,01h,01h,01h,00h,00h,00h,00h,01h,01h,01h,01h,01h,01h,01h,01h
