%include "util.mac"
%include "icedump.inc"
%include "wiat.inc"


global Parse_PageFlag


extern sdata
extern Parser.return
extern ParseAddress


bits 32


;-------------------------------------------------------------------------------
; PAGEFLAG <address> pPrWsUcC
;-------------------------------------------------------------------------------
segment _LTEXT
Parse_PageFlag:
	call	ParseAddress		; parse <address>
	jb	near Parser.return

	shr	eax,12			; linear address -> page number
	lea	edi,[4*eax+0xFF800000]	; linear address of PTE

.next:
	lodsb				; get flag
	cmp	al,0
	jnz	.p

.return:
	mov	eax,cr3			; flush TLBs
	mov	cr3,eax
	jmp	Parser.return

.p:
	cmp	al,'p'
	jnz	.P

	and	byte [edi],~0x01
	jmp	short .next

.P:
	cmp	al,'P'
	jnz	.r

	or	byte [edi],0x01
	jmp	short .next

.r:
	cmp	al,'r'
	jnz	.W

	and	byte [edi],~0x02
	jmp	short .next

.W:
	cmp	al,'W'
	jnz	.s

	or	byte [edi],0x02
	jmp	short .next

.s:
	cmp	al,'s'
	jnz	.U

	and	byte [edi],~0x04
	jmp	short .next

.U:
	cmp	al,'U'
	jnz	.c

	or	byte [edi],0x04
	jmp	short .next

.c:
	cmp	al,'c'
	jnz	.C

	and	byte [edi+1],~0x02
	jmp	short .next

.C:
	cmp	al,'C'
	jnz	.return

	or	byte [edi+1],0x02
	jmp	short .next
