; for v3.22, v3.23, v3.24, v3.25, v4.00, v4.01, v4.05.316, v4.05.526
; some symbols to make the code more readable

%ifndef INCLUDED_ICEDUMP_INC
%define INCLUDED_ICEDUMP_INC

%define ICEDUMP_VERSION_MAJOR 6
%define ICEDUMP_VERSION_MINOR1 0
%define ICEDUMP_VERSION_MINOR2 2
%define ICEDUMP_VERSION_MINOR3 2
%assign ICEDUMP_VERSION (ICEDUMP_VERSION_MAJOR << 12) + (ICEDUMP_VERSION_MINOR1 << 8) + (ICEDUMP_VERSION_MINOR2 << 4) + ICEDUMP_VERSION_MINOR3
%define ICEDUMP_VERSION_ASCII '0'+ICEDUMP_VERSION_MAJOR,'.','0'+ICEDUMP_VERSION_MINOR1,'.','0'+ICEDUMP_VERSION_MINOR2,'.','0'+ICEDUMP_VERSION_MINOR3

%define WINICE_VERSION_MINOR2 (WINICE_VERSION_MINOR / 10)
%define WINICE_VERSION_MINOR1 (WINICE_VERSION_MINOR % 10)

%ifdef WINICE_BUILD
%define WINICE_BUILD3 (WINICE_BUILD / 100)
%define WINICE_BUILD2 ((WINICE_BUILD / 10) % 10)
%define WINICE_BUILD1 (WINICE_BUILD % 10)
%define WINICE_VERSION_ASCII '0'+WINICE_VERSION_MAJOR,'.','0'+WINICE_VERSION_MINOR2,'0'+WINICE_VERSION_MINOR1,' build ','0'+WINICE_BUILD3,'0'+WINICE_BUILD2,'0'+WINICE_BUILD1
%else
%define WINICE_VERSION_ASCII '0'+WINICE_VERSION_MAJOR,'.','0'+WINICE_VERSION_MINOR2,'0'+WINICE_VERSION_MINOR1
%endif

%define ICEDUMP_DDB_NAME     ICEDUMP
%define ICEDUMP_DEVICE_NAME 'ICEDUMP'

; common stuff
%ifndef debugflags
%define debugflags sdata+DebugFlags
%endif

SICE_Device_ID		equ 0x0202
SIWVID_Device_ID	equ 0x7A5F
SIWDEBUG_Device_ID	equ 0x0002

%define CMD_INVALID 0
%define CMD_PAGEIN 0x9E

%define KBD_TAB		0x09
%define KBD_ENTER	0x0D
%define KBD_ESC		0x1B
%define KBD_LEFT	0x81
%define KBD_RIGHT	0x82
%define KBD_UP		0x83
%define KBD_DOWN	0x84

struc WiniceIntHandler
.IntNum:	resb 1
.oIDT:		resd 1
.PUSH:		resb 1
.oOldHandler:	resd 1
.JMP:		resb 1
.IntHandler:	resd 1
endstruc

struc WCRS
.valid:		resd 1
.oINT3:		resd 1
.dClient_EAX	resd 1
.dClient_EBX	resd 1
.dClient_ECX	resd 1
.dClient_EDX	resd 1
.dClient_ESI	resd 1
.dClient_EDI	resd 1
.dClient_EBP	resd 1
.dClient_ESP	resd 1
.dClient_EIP	resd 1
.dClient_EFLAGS	resd 1
.dClient_CS	resd 1
.dClient_DS	resd 1
.dClient_SS	resd 1
.dClient_ES	resd 1
.dClient_FS	resd 1
.dClient_GS	resd 1
.dClient_CR2	resd 1
.dClient_CR3	resd 1
endstruc

; Bhrama related stuff

struc BhramaComStruc
.version	resd 1	; Internal Check (03h)
.PID		resd 1	; Target PID
.EIP		resd 1	; EntryPoint to Set after DUMP
.OptL1		resd 1	; Internal ProcDump Options Dword1
.OptL2		resd 1	; Internal ProcDump Options Dword2
.OptL3		resd 1	; Internal ProcDump Options Dword3
.OptL4		resd 1	; Internal ProcDump Options Dword4
.OptL5		resd 1	; Internal ProcDump Options Dword5
endstruc

;SERVICE_VERSION	EQU 0x0000
SERVICE_DUMP		EQU 0x0001
SERVICE_LOAD		EQU 0x0002
SERVICE_SUSPEND		EQU 0x0003
SERVICE_SUSPENDX	EQU 0x0004
SERVICE_RESUME		EQU 0x0005
SERVICE_KILL		EQU 0x0006
SERVICE_CDPLAYER	EQU 0x0007
SERVICE_MP3PLAYER	EQU 0x0008
SERVICE_PEDUMP		EQU 0x0009
SERVICE_TRACE		EQU 0x000A
SERVICE_TRACEX		EQU 0x000B
SERVICE_BREAKR3		EQU 0x000C
SERVICE_FDUMP		EQU 0x000D
SERVICE_MAX		EQU 0x000E

%define	CRLF0	13,10,0

;48 bytes max filename length
OPT_EMODE_FILENAMELEN	EQU 48
OPT_EMODE_NUMLEN	EQU 3

TempBuffer_size equ 65536

; macros for stack allocation with proper alignment
%macro salloc 1
	sub	esp,((%1) + 3) & 0xFFFFFFFC
	mov	edi,esp
%endmacro

%macro sfree 1
	lea	esp,[esp + (((%1) + 3) & 0xFFFFFFFC)]
%endmacro

; size optimization macros
%macro movb 2
	%ifndef MAKEDEP
		%if (%2 > 127 || %2 < -128)
			%error immediate argument to MOVB does not fit in 1 byte
		%endif
	%endif
		push	byte %2
		pop	%1
%endmacro

; MSCDEX structures
struc CdReq
.Len		resb 1	; length of hdr
.SubUnit	resb 1	; subunit code
.Cmd		resb 1	; command code
.Status		resw 1	; status
.Reserved	resb 8
endstruc

struc CdIoctlReq
.Len		resb 1	; length of hdr
.SubUnit	resb 1	; subunit code
.Cmd		resb 1	; command code
.Status		resw 1	; status
.Reserved	resb 8
.MediaDesc	resb 1	; media descriptor byte
.XferOfs	resw 1	; transfer addr offset part
.XferSeg	resw 1	; transfer addr segment part
.XferSize	resw 1	; transfer block size
.Sector		resw 1	; starting sector #
.VolumeId	resd 1	; DWORD ptr to requested vol ID if error 0FH
.CtrlCode:
endstruc

struc CdPlayReq
.AddrMode	resb 1	; addressing mode
.Sector		resd 1	; starting sector number
.Count		resd 1	; number of sectors to play
endstruc

struc CdDiskInfo
.Code		resb 1	; control block code
.TrackLo	resb 1	; lowest track #
.TrackHi	resb 1	; highest track #
.LeadOut	resd 1	; starting point of the lead-out track
endstruc

struc CdTrackInfo
.Code		resb 1	; control block code
.Track		resb 1	; track #
.Start		resd 1	; starting point of the track
.Ctrl		resb 1	; track control info
endstruc

struc WiniceDeviceParams
.LogicalSeg:	resw 1
.ActualSeg:	resw 1
.Base:		resd 1
.Length:	resd 1
.Type:		resw 1	; 0/1: code/data
.SymName:	resb 8
endstruc

struc CallBack
.offset		resw 1
.selector	resw 1
endstruc

struc HookedInts
.VMCB:	resd	1
.cAPP:	resd	1

	resd	1
Handler_Int02:
	resb	3	; 36/ff/25: jmp dword [ss:x]
	resd	1

	resb	5

	resd	1
Handler_Int00:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int01:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int03:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int04:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int05:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int06:
	resb	3
	resd	1

	resb	5+16

	resd	1
Handler_Int09:
	resb	3
	resd	1

	resb	1

	resd	1
Handler_Int0F:
	resb	3
	resd	1

	resb	5+16+4

	resd	1
Handler_Int0B:
	resb	3
	resd	1

	resb	5	; fix: should be -3

	resd	1
Handler_Int0C:
	resb	3
	resd	1

	resb	5	; fix: should be -3

	resd	1
Handler_Int0D:
	resb	3
	resd	1

	resb	5	; fix: should be -3

	resd	1
Handler_Int0E:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int41:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int51:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int53:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int54:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int57:
	resb	3
	resd	1

	resb	5

	resd	1
Handler_Int5C:
	resb	3
	resd	1

	resb	5
endstruc

ICEDUMP_DEBUG_SYSCTRL		equ 0
ICEDUMP_DEBUG_HOOKS		equ 1
ICEDUMP_DEBUG_FILEIO		equ 2
ICEDUMP_DEBUG_MP3		equ 3
ICEDUMP_DEBUG_PEDUMP		equ 4
ICEDUMP_DEBUG_TASKMOD		equ 5
ICEDUMP_DEBUG_COMMON		equ 6
ICEDUMP_DEBUG_TRACE		equ 7
ICEDUMP_DEBUG_PROTECT		equ 8
ICEDUMP_DEBUG_FDUMP   		equ 9

ICEDUMP_DEBUG_FLAG_COUNT	equ 10

struc StaticData
loadcount:		resd 1
oWinice:		resd 1
oOld_CMD_INVALID:	resd 1
s_fWiniceIsActive:	resd 1
s_pSendSpecificEOI:	resd 1
PMCB:			resb CallBack_size
SimIretCB:		resb CallBack_size
V86CB:			resb CallBack_size
V86IDT:			resb HookedInts_size
MP3:
.PlayerPresent:		resb 1
.nIRQ:			resb 1
OldSoundCardIntProc:
.off:			resd 1
.sel:			resd 1
DebugFlags:		resd (ICEDUMP_DEBUG_FLAG_COUNT+31)/32
endstruc

%endif
