;////////////////////////////////////////////////////////////
;// vxdn.inc
;//
;// VxD definitions for NASM
;//
;// Collective effort of fOSSiL and The Owl =)
;//
;// 06-Aug-1999	fOSSiL		Initial version
;// 16-Jan-2000 The Owl		bunch of structs and equates
;// 16-Jan-2000 fOSSiL		Separated Auto-generated stuff from hand-made, better MASM-compat
;// 18-Jan-2000 The Owl		modified DDB builder macro

%ifndef INCLUDED_VXDN_INC
%define INCLUDED_VXDN_INC

DDK_VERSION		EQU 0x0400
UNDEFINED_DEVICE_ID	EQU 0x0000
UNDEFINED_INIT_ORDER	EQU 0x80000000

SYS_CRITICAL_INIT	EQU 0000H
DEVICE_INIT		EQU 0001H
INIT_COMPLETE		EQU 0002H
SYS_VM_INIT		EQU 0003H
SYS_VM_TERMINATE	EQU 0004H
SYSTEM_EXIT		EQU 0005H
SYS_CRITICAL_EXIT	EQU 0006H
CREATE_VM		EQU 0007H
VM_CRITICAL_INIT	EQU 0008H
VM_INIT			EQU 0009H
VM_TERMINATE		EQU 000AH
VM_NOT_EXECUTEABLE	EQU 000BH
DESTROY_VM		EQU 000CH

VNE_CRASHED_BIT		EQU 00H
VNE_CRASHED		EQU (1 << VNE_CRASHED_BIT)
VNE_NUKED_BIT		EQU 01H
VNE_NUKED		EQU (1 << VNE_NUKED_BIT)
VNE_CREATEFAIL_BIT	EQU 02H
VNE_CREATEFAIL		EQU (1 << VNE_CREATEFAIL_BIT)
VNE_CRINITFAIL_BIT	EQU 03H
VNE_CRINITFAIL		EQU (1 << VNE_CRINITFAIL_BIT)
VNE_INITFAIL_BIT	EQU 04H
VNE_INITFAIL		EQU (1 << VNE_INITFAIL_BIT)
VNE_CLOSED_BIT		EQU 05H
VNE_CLOSED		EQU (1 << VNE_CLOSED_BIT)

VM_SUSPEND		EQU 000DH
VM_RESUME		EQU 000EH
SET_DEVICE_FOCUS	EQU 000FH
BEGIN_MESSAGE_MODE	EQU 0010H
END_MESSAGE_MODE	EQU 0011H
REBOOT_PROCESSOR	EQU 0012H
QUERY_DESTROY		EQU 0013H
DEBUG_QUERY		EQU 0014H
BEGIN_PM_APP		EQU 0015H

BPA_32_BIT		EQU 01H
BPA_32_BIT_FLAG		EQU 1

END_PM_APP		EQU 0016H
DEVICE_REBOOT_NOTIFY	EQU 0017H
CRIT_REBOOT_NOTIFY	EQU 0018H
CLOSE_VM_NOTIFY		EQU 0019H
POWER_EVENT		EQU 001AH
SYS_DYNAMIC_DEVICE_INIT	EQU 001BH
SYS_DYNAMIC_DEVICE_EXIT	EQU 001CH
CREATE_THREAD		EQU 001DH
THREAD_INIT		EQU 001EH
TERMINATE_THREAD	EQU 001FH
THREAD_NOT_EXECUTEABLE	EQU 0020H
DESTROY_THREAD		EQU 0021H
PNP_NEW_DEVNODE		EQU 0022H
W32_DEVICEIOCONTROL	EQU 0023H

DIOC_GETVERSION		EQU 0H
DIOC_OPEN		EQU DIOC_GETVERSION
DIOC_CLOSEHANDLE	EQU -1

SYS_VM_TERMINATE2	EQU 0024H
SYSTEM_EXIT2		EQU 0025H
SYS_CRITICAL_EXIT2	EQU 0026H
VM_TERMINATE2		EQU 0027H
VM_NOT_EXECUTEABLE2	EQU 0028H
DESTROY_VM2		EQU 0029H
VM_SUSPEND2		EQU 002AH
END_MESSAGE_MODE2	EQU 002BH
END_PM_APP2		EQU 002CH
DEVICE_REBOOT_NOTIFY2	EQU 002DH
CRIT_REBOOT_NOTIFY2	EQU 002EH
CLOSE_VM_NOTIFY2	EQU 002FH
GET_CONTENTION_HANDLER	EQU 0030H
KERNEL32_INITIALIZED	EQU 0031H
KERNEL32_SHUTDOWN	EQU 0032H
CREATE_PROCESS		EQU 0033H
DESTROY_PROCESS		EQU 0034H
SYS_DYNAMIC_DEVICE_REINIT	EQU 0035H
SYS_POWER_DOWN		EQU 0036H
MAX_SYSTEM_CONTROL	EQU 0036H

BEGIN_RESERVED_PRIVATE_SYSTEM_CONTROL	EQU 70000000H
END_RESERVED_PRIVATE_SYSTEM_CONTROL	EQU 7FFFFFFFH


%macro VxD_Service 2
  @@%2 EQU (%1_Device_ID << 16) | __Cur_Service_Num__
  %assign __Cur_Service_Num__ (__Cur_Service_Num__ + 1)
  %ifdef Create_Service_Table_%1
    dd %2
  %endif
%endmacro

%macro Begin_Service_Table 1
  %assign __Cur_Service_Num__ 0
  %define %1_Service VxD_Service %1,

  %ifdef Create_Service_Table_%1
[segment _LDATA]
    %1_Service_Table:
  %endif
%endmacro

%macro End_Service_Table 1
  Num_%1_Services equ __Cur_Service_Num__
  %undef __Cur_Service_Num__
  %undef %1_Service
  %ifdef Create_Service_Table_%1
__SECT__
  %endif
%endmacro


%include "winddk.inc"


; Client Register Structure as passed to V86/PM CallBacks
struc CRS
.EDI		resd 1		; 0
.ESI		resd 1		; 4
.EBP		resd 1		; 8
.res0		resd 1		; C
.EBX		resd 1		; 10
.EDX		resd 1		; 14
.ECX		resd 1		; 18
.EAX		resd 1		; 1C
.Error		resd 1		; 20
.EIP		resd 1		; 24
.CS		resw 1		; 28
.res1		resw 1		;
.EFlags		resd 1		; 2C
.ESP		resd 1		; 30
.SS		resw 1		; 34
.res2		resw 1
.ES		resw 1		; 38
.res3		resw 1
.DS		resw 1		; 3C		
.res4		resw 1
.FS		resw 1		; 40
.res5		resw 1
.GS		resw 1		; 44
.res6		resw 1
.Alt_EIP	resd 1		; 48
.Alt_CS		resw 1		; 4C
.res7		resw 1
.Alt_EFlags	resd 1
.Alt_ESP	resd 1
.Alt_SS		resw 1
.res8		resw 1
.Alt_ES		resw 1
.res9		resw 1
.Alt_DS		resw 1
.res10		resw 1
.Alt_FS		resw 1
.res11		resw 1
.Alt_GS		resw 1
.res12		resw 1
endstruc

struc cb_s
CB_VM_Status		resd 1
CB_High_Linear		resd 1
CB_Client_Pointer	resd 1
CB_VMID			resd 1
CB_Signature		resd 1
endstruc

VMCB_ID				EQU	62634D56H
VMSTAT_EXCLUSIVE_BIT		EQU	00H
VMSTAT_EXCLUSIVE		EQU	(1 << VMSTAT_EXCLUSIVE_BIT)
VMSTAT_BACKGROUND_BIT		EQU	01H
VMSTAT_BACKGROUND		EQU	(1 << VMSTAT_BACKGROUND_BIT)
VMSTAT_CREATING_BIT		EQU	02H
VMSTAT_CREATING			EQU	(1 << VMSTAT_CREATING_BIT)
VMSTAT_SUSPENDED_BIT		EQU	03H
VMSTAT_SUSPENDED		EQU	(1 << VMSTAT_SUSPENDED_BIT)
VMSTAT_NOT_EXECUTEABLE_BIT	EQU	04H
VMSTAT_NOT_EXECUTEABLE		EQU	(1 << VMSTAT_NOT_EXECUTEABLE_BIT)
VMSTAT_PM_EXEC_BIT		EQU	05H
VMSTAT_PM_EXEC			EQU	(1 << VMSTAT_PM_EXEC_BIT)
VMSTAT_PM_APP_BIT		EQU	06H
VMSTAT_PM_APP			EQU	(1 << VMSTAT_PM_APP_BIT)
VMSTAT_PM_USE32_BIT		EQU	07H
VMSTAT_PM_USE32			EQU	(1 << VMSTAT_PM_USE32_BIT)
VMSTAT_VXD_EXEC_BIT		EQU	08H
VMSTAT_VXD_EXEC			EQU	(1 << VMSTAT_VXD_EXEC_BIT)
VMSTAT_HIGH_PRI_BACK_BIT	EQU	09H
VMSTAT_HIGH_PRI_BACK		EQU	(1 << VMSTAT_HIGH_PRI_BACK_BIT)
VMSTAT_BLOCKED_BIT		EQU	0AH
VMSTAT_BLOCKED			EQU	(1 << VMSTAT_BLOCKED_BIT)
VMSTAT_AWAKENING_BIT		EQU	0BH
VMSTAT_AWAKENING		EQU	(1 << VMSTAT_AWAKENING_BIT)
VMSTAT_PAGEABLEV86BIT		EQU	0CH
VMSTAT_PAGEABLEV86_BIT		EQU	VMSTAT_PAGEABLEV86BIT
VMSTAT_PAGEABLEV86		EQU	(1 << VMSTAT_PAGEABLEV86BIT)
VMSTAT_V86INTSLOCKEDBIT		EQU	0DH
VMSTAT_V86INTSLOCKED_BIT	EQU	VMSTAT_V86INTSLOCKEDBIT
VMSTAT_V86INTSLOCKED		EQU	(1 << VMSTAT_V86INTSLOCKEDBIT)
VMSTAT_IDLE_TIMEOUT_BIT		EQU	0EH
VMSTAT_IDLE_TIMEOUT		EQU	(1 << VMSTAT_IDLE_TIMEOUT_BIT)
VMSTAT_IDLE_BIT			EQU	0FH
VMSTAT_IDLE			EQU	(1 << VMSTAT_IDLE_BIT)
VMSTAT_CLOSING_BIT		EQU	10H
VMSTAT_CLOSING			EQU	(1 << VMSTAT_CLOSING_BIT)
VMSTAT_TS_SUSPENDED_BIT		EQU	11H
VMSTAT_TS_SUSPENDED		EQU	(1 << VMSTAT_TS_SUSPENDED_BIT)
VMSTAT_TS_MAXPRI_BIT		EQU	12H
VMSTAT_TS_MAXPRI		EQU	(1 << VMSTAT_TS_MAXPRI_BIT)
VMSTAT_USE32_MASK		EQU	(VMSTAT_PM_USE32 | VMSTAT_VXD_EXEC)

struc tcb_s
TCB_Flags		resd 1 ; 00
TCB_Reserved1		resd 1 ; 04
TCB_Reserved2		resd 1 ; 08
TCB_Signature		resd 1 ; 0C
TCB_ClientPtr		resd 1 ; 10
TCB_VMHandle		resd 1 ; 14
TCB_ThreadId		resw 1 ; 18
TCB_PMLockOrigSS	resw 1 ; 1A
TCB_PMLockOrigESP	resd 1 ; 1C
TCB_PMLockOrigEIP	resd 1 ; 20
TCB_PMLockStackCount	resd 1 ; 24
TCB_PMLockOrigCS	resw 1 ; 28
TCB_PMPSPSelector	resw 1 ; 2A
TCB_ThreadType		resd 1 ; 2C
TCB_pad1		resw 1 ;
TCB_pad2		resb 1 ;
TCB_extErrLocus		resb 1 ;
TCB_extErr		resw 1 ;
TCB_extErrAction	resb 1 ;
TCB_extErrClass		resb 1 ;
TCB_extErrPtr		resd 1 ;
endstruc

%if 0
; this used to be true for win95, win98 (perhaps even OSR2) added a new first
; element, but unfortunately winme seems to have changed the field ordering,
; so this is kept here for reference only. someone wanted to be smart at MS ;P
struc TDBX
.pTDB:			resd 1 ; 00
.pPDB:			resd 1 ; 04
.hContext:		resd 1 ; 08
.R0TCB:			resd 1 ; 0C
.hTimeOut:		resd 1 ; 10
.WakeParam:		resd 1 ; 14
.hBlock:		resd 1 ; 18
.BlockState:		resd 1 ; 1C
.SuspendCount:		resd 1 ; 20
.hSuspend:		resd 1 ; 24
.cMustComplete:		resd 1 ; 28
.WaitExFlags:		resd 1 ; 2C
.cSyncWait:		resd 1 ; 30
.QueuedSyncFuncs:	resd 1 ; 34
.UserAPCList:		resd 1 ; 38
.KernAPCList:		resd 1 ; 3C
.pPMPSPSelector:	resd 1 ; 40
.BlockedOnID:		resd 1 ; 44
.unknown2:		resd 7 ; 48
.TraceRefData:		resd 1 ; 64
.TraceCallBack:		resd 1 ; 68
.hTraceEvent:		resd 1 ; 6C
.TraceOutLastCS:	resw 1 ; 70
.K16TDB:		resw 1 ; 72
.K16PDB:		resw 1 ; 74
.DosPDBSeg:		resw 1 ; 76
.cException:		resw 1 ; 78
endstruc
%endif

SCHED_OBJ_ID_THREAD		EQU	42434854H
THFLAG_SUSPENDED_BIT		EQU	03H
THFLAG_SUSPENDED		EQU	(1 << THFLAG_SUSPENDED_BIT)
THFLAG_NOT_EXECUTEABLE_BIT	EQU	04H
THFLAG_NOT_EXECUTEABLE		EQU	(1 << THFLAG_NOT_EXECUTEABLE_BIT)
THFLAG_THREAD_CREATION_BIT	EQU	08H
THFLAG_THREAD_CREATION		EQU	(1 << THFLAG_THREAD_CREATION_BIT)
THFLAG_THREAD_BLOCKED_BIT	EQU	0AH
THFLAG_THREAD_BLOCKED		EQU	(1 << THFLAG_THREAD_BLOCKED_BIT)
THFLAG_RING0_THREAD_BIT		EQU	1CH
THFLAG_RING0_THREAD		EQU	(1 << THFLAG_RING0_THREAD_BIT)
THFLAG_ASYNC_THREAD_BIT		EQU	1FH
THFLAG_ASYNC_THREAD		EQU	(1 << THFLAG_ASYNC_THREAD_BIT)
THFLAG_CHARSET_BITS		EQU	10H
THFLAG_CHARSET_MASK		EQU	(3 << THFLAG_CHARSET_BITS)
THFLAG_ANSI			EQU	(0 << THFLAG_CHARSET_BITS)
THFLAG_OEM			EQU	(1 << THFLAG_CHARSET_BITS)
THFLAG_UNICODE			EQU	(2 << THFLAG_CHARSET_BITS)
THFLAG_RESERVED			EQU	(3 << THFLAG_CHARSET_BITS)
THFLAG_EXTENDED_HANDLES_BIT	EQU	12H
THFLAG_EXTENDED_HANDLES		EQU	(1 << THFLAG_EXTENDED_HANDLES_BIT)
THFLAG_OPEN_AS_IMMOVABLE_FILE_BIT	EQU	13H
THFLAG_OPEN_AS_IMMOVABLE_FILE	EQU	(1 << THFLAG_OPEN_AS_IMMOVABLE_FILE_BIT)

struc pmcb_s
PMCB_Flags	resd 1
PMCB_Parent	resd 1
endstruc

struc Exception_Handler_Struc
EHS_Reserved	resd 1
EHS_Start_EIP	resd 1
EHS_End_EIP	resd 1
EHS_Handler	resd 1
endstruc

struc VMFaultInfo
VMFI_EIP	resd 1
VMFI_CS		resw 1
VMFI_Ints	resw 1
endstruc
 
RESERVED_LOW_BOOST		EQU	00000001H
CUR_RUN_VM_BOOST		EQU	00000004H
LOW_PRI_DEVICE_BOOST		EQU	00000010H
HIGH_PRI_DEVICE_BOOST		EQU	00001000H
CRITICAL_SECTION_BOOST		EQU	00100000H
TIME_CRITICAL_BOOST		EQU	00400000H
RESERVED_HIGH_BOOST		EQU	40000000H
PEF_WAIT_FOR_STI_BIT		EQU	0
PEF_WAIT_FOR_STI		EQU	(1 << PEF_WAIT_FOR_STI_BIT)
PEF_WAIT_NOT_CRIT_BIT		EQU	1
PEF_WAIT_NOT_CRIT		EQU	(1 << PEF_WAIT_NOT_CRIT_BIT)
PEF_DONT_UNBOOST_BIT		EQU	2
PEF_DONT_UNBOOST		EQU	(1 << PEF_DONT_UNBOOST_BIT)
PEF_ALWAYS_SCHED_BIT		EQU	3
PEF_ALWAYS_SCHED		EQU	(1 << PEF_ALWAYS_SCHED_BIT)
PEF_TIME_OUT_BIT		EQU	4
PEF_TIME_OUT			EQU	(1 << PEF_TIME_OUT_BIT)
PEF_WAIT_NOT_HW_INT_BIT		EQU	5
PEF_WAIT_NOT_HW_INT		EQU	(1 << PEF_WAIT_NOT_HW_INT_BIT)
PEF_WAIT_NOT_NESTED_EXEC_BIT	EQU	6
PEF_WAIT_NOT_NESTED_EXEC	EQU	(1 << PEF_WAIT_NOT_NESTED_EXEC_BIT)
PEF_WAIT_IN_PM_BIT		EQU	7
PEF_WAIT_IN_PM			EQU	(1 << PEF_WAIT_IN_PM_BIT)
PEF_THREAD_EVENT_BIT		EQU	8
PEF_THREAD_EVENT		EQU	(1 << PEF_THREAD_EVENT_BIT)
PEF_WAIT_FOR_THREAD_STI_BIT	EQU	9
PEF_WAIT_FOR_THREAD_STI		EQU	(1 << PEF_WAIT_FOR_THREAD_STI_BIT)
PEF_RING0_EVENT_BIT		EQU	10
PEF_RING0_EVENT			EQU	(1 << PEF_RING0_EVENT_BIT)
PEF_WAIT_CRIT_BIT		EQU	11
PEF_WAIT_CRIT			EQU	(1 << PEF_WAIT_CRIT_BIT)
PEF_WAIT_CRIT_VM_BIT		EQU	12
PEF_WAIT_CRIT_VM		EQU	(1 << PEF_WAIT_CRIT_VM_BIT)
PEF_PROCESS_LAST_BIT		EQU	13
PEF_PROCESS_LAST		EQU	(1 << PEF_PROCESS_LAST_BIT)
PEF_WAIT_PREEMPTABLE_BIT	EQU	14
PEF_WAIT_PREEMPTABLE		EQU	(1 << PEF_WAIT_PREEMPTABLE_BIT)
PEF_WAIT_FOR_PASSIVE_BIT	EQU	15
PEF_WAIT_FOR_PASSIVE		EQU	(1 << PEF_WAIT_FOR_PASSIVE_BIT)
PEF_WAIT_FOR_APPY_BIT		EQU	16
PEF_WAIT_FOR_APPY		EQU	(1 << PEF_WAIT_FOR_APPY_BIT)
PEF_WAIT_FOR_WORKER_BIT		EQU	17
PEF_WAIT_FOR_WORKER		EQU	(1 << PEF_WAIT_FOR_WORKER_BIT)
PEF_WAIT_NOT_TIME_CRIT_BIT	EQU	PEF_WAIT_NOT_HW_INT_BIT
PEF_WAIT_NOT_TIME_CRIT		EQU	PEF_WAIT_NOT_HW_INT
PEF_WAIT_NOT_PM_LOCKED_STACK_BIT	EQU	PEF_WAIT_NOT_NESTED_EXEC_BIT
PEF_WAIT_NOT_PM_LOCKED_STACK	EQU	PEF_WAIT_NOT_NESTED_EXEC
PEF_WAIT_FOR_CONFIGMG_CALLABLE	EQU	PEF_WAIT_FOR_WORKER
PEF_WAIT_FOR_CONFIGMG_QUICK	EQU	PEF_WAIT_FOR_APPY
BLOCK_SVC_INTS_BIT		EQU	0
BLOCK_SVC_INTS			EQU	(1 << BLOCK_SVC_INTS_BIT)
BLOCK_SVC_IF_INTS_LOCKED_BIT	EQU	1
BLOCK_SVC_IF_INTS_LOCKED	EQU	(1 << BLOCK_SVC_IF_INTS_LOCKED_BIT)
BLOCK_ENABLE_INTS_BIT		EQU	2
BLOCK_ENABLE_INTS		EQU	(1 << BLOCK_ENABLE_INTS_BIT)
BLOCK_POLL_BIT			EQU	3
BLOCK_POLL			EQU	(1 << BLOCK_POLL_BIT)
BLOCK_THREAD_IDLE_BIT		EQU	4
BLOCK_THREAD_IDLE		EQU	(1 << BLOCK_THREAD_IDLE_BIT)
BLOCK_FORCE_SVC_INTS_BIT	EQU	5
BLOCK_FORCE_SVC_INTS		EQU	(1 << BLOCK_FORCE_SVC_INTS_BIT)

PAGEZEROINIT		EQU	00000001H
PAGEUSEALIGN		EQU	00000002H
PAGECONTIG		EQU	00000004H
PAGEFIXED		EQU	00000008H
PAGEDEBUGNULFAULT	EQU	00000010H
PAGEZEROREINIT		EQU	00000020H
PAGENOCOPY		EQU	00000040H
PAGELOCKED		EQU	00000080H
PAGELOCKEDIFDP		EQU	00000100H
PAGESETV86PAGEABLE	EQU	00000200H
PAGECLEARV86PAGEABLE	EQU	00000400H
PAGESETV86INTSLOCKED	EQU	00000800H
PAGECLEARV86INTSLOCKED	EQU	00001000H
PAGEMARKPAGEOUT		EQU	00002000H
PAGEPDPSETBASE		EQU	00004000H
PAGEPDPCLEARBASE	EQU	00008000H
PAGEDISCARD		EQU	00010000H
PAGEPDPQUERYDIRTY	EQU	00020000H
PAGEMAPFREEPHYSREG	EQU	00040000H
PAGEPHYSONLY		EQU	04000000H
PAGENOMOVE		EQU	10000000H
PAGEMAPGLOBAL		EQU	40000000H
PAGEMARKDIRTY		EQU	80000000H

PR_PRIVATE	EQU	80000400H
PR_SHARED	EQU	80060000H
PR_SYSTEM	EQU	80080000H
PR_FIXED	EQU	00000008H
PR_4MEG		EQU	00000001H
PR_STATIC	EQU	00000010H
PD_ZEROINIT	EQU	00000001H
PD_NOINIT	EQU	00000002H
PD_FIXEDZERO	EQU	00000003H
PD_FIXED	EQU	00000004H
PC_FIXED	EQU	00000008H
PC_LOCKED	EQU	00000080H
PC_LOCKEDIFDP	EQU	00000100H
PC_WRITEABLE	EQU	00020000H
PC_USER		EQU	00040000H
PC_INCR		EQU	40000000H
PC_PRESENT	EQU	80000000H
PC_STATIC	EQU	20000000H
PC_DIRTY	EQU	08000000H
PC_CACHEDIS	EQU	00100000H
PC_CACHEWT	EQU	00080000H
PC_PAGEFLUSH	EQU	00008000H

P_SIZE		EQU	1000H
P_PRESBIT	EQU	0
P_PRES		EQU	(1 << P_PRESBIT)
P_WRITEBIT	EQU	1
P_WRITE		EQU	(1 << P_WRITEBIT)
P_USERBIT	EQU	2
P_USER		EQU	(1 << P_USERBIT)
P_ACCBIT	EQU	5
P_ACC		EQU	(1 << P_ACCBIT)
P_DIRTYBIT	EQU	6
P_DIRTY		EQU	(1 << P_DIRTYBIT)
P_AVAIL		EQU	(P_PRES+P_WRITE+P_USER)
PG_VM		EQU	0
PG_SYS		EQU	1
PG_RESERVED1	EQU	2
PG_PRIVATE	EQU	3
PG_RESERVED2	EQU	4
PG_RELOCK	EQU	5
PG_INSTANCE	EQU	6
PG_HOOKED	EQU	7
PG_IGNORE	EQU	0FFFFFFFFH
D_PRES		EQU	080H
D_NOTPRES	EQU	0
D_DPL0		EQU	0
D_DPL1		EQU	020H
D_DPL2		EQU	040H
D_DPL3		EQU	060H
D_SEG		EQU	010H
D_CTRL		EQU	0
D_GRAN_BYTE	EQU	000H
D_GRAN_PAGE	EQU	080H
D_DEF16		EQU	000H
D_DEF32		EQU	040H
D_CODE		EQU	08H
D_DATA		EQU	0
D_X		EQU	0
D_RX		EQU	02H
D_C		EQU	04H
D_R		EQU	0
D_W		EQU	02H
D_ED		EQU	04H
D_ACCESSED	EQU	1
RW_DATA_TYPE	EQU	(D_PRES+D_SEG+D_DATA+D_W)
R_DATA_TYPE	EQU	(D_PRES+D_SEG+D_DATA+D_R)
CODE_TYPE	EQU	(D_PRES+D_SEG+D_CODE+D_RX)
D_PAGE32	EQU	(D_GRAN_PAGE+D_DEF32)
SELECTOR_MASK	EQU	0FFF8H
SEL_LOW_MASK	EQU	0F8H
TABLE_MASK	EQU	04H
RPL_MASK	EQU	03H
RPL_CLR	EQU	(~RPL_MASK)
IVT_ROM_DATA_SIZE	EQU	500H

LMEM_STRING	EQU	00010000H
LMEM_OEM2ANSI	EQU	00020000H
QAAFL_APPYAVAIL	EQU	00000001H
QAAFL_APPYNOW	EQU	00000002H
CAAFL_RING0	EQU	00000001H
CAAFL_TIMEOUT	EQU	00000002H

PAGEOUT_PRIVATE	EQU	00000001H
PAGEOUT_SHARED	EQU	00000002H
PAGEOUT_SYSTEM	EQU	00000004H
PAGEOUT_REGION	EQU	00000008H
PAGEOUT_ALL	EQU	(PAGEOUT_PRIVATE | PAGEOUT_SHARED | PAGEOUT_SYSTEM)

PG_UNCACHED			EQU	00000001H
PG_WRITECOMBINED		EQU	00000002H
FLUSHCACHES_NORMAL		EQU	00000000H
FLUSHCACHES_GET_CACHE_LINE_PTR	EQU	00000001H
FLUSHCACHES_GET_CACHE_SIZE_PTR	EQU	00000002H
FLUSHCACHES_TAKE_OVER		EQU	00000003H
FLUSHCACHES_FORCE_PAGES_OUT	EQU	00000004H
FLUSHCACHES_LOCK_LOCKABLE	EQU	00000005H
FLUSHCACHES_UNLOCK_LOCKABLE	EQU	00000006H

HEAPZEROINIT	EQU	00000001H
HEAPZEROREINIT	EQU	00000002H
HEAPNOCOPY	EQU	00000004H
HEAPALIGN_SHIFT	EQU	16
HEAPALIGN_MASK	EQU	000F0000H
HEAPALIGN_4	EQU	00000000H
HEAPALIGN_8	EQU	00000000H
HEAPALIGN_16	EQU	00000000H
HEAPALIGN_32	EQU	00010000H
HEAPALIGN_64	EQU	00020000H
HEAPALIGN_128	EQU	00030000H
HEAPALIGN_256	EQU	00040000H
HEAPALIGN_512	EQU	00050000H
HEAPALIGN_1K	EQU	00060000H
HEAPALIGN_2K	EQU	00070000H
HEAPALIGN_4K	EQU	00080000H
HEAPALIGN_8K	EQU	00090000H
HEAPALIGN_16K	EQU	000A0000H
HEAPALIGN_32K	EQU	000B0000H
HEAPALIGN_64K	EQU	000C0000H
HEAPALIGN_128K	EQU	000D0000H
HEAPTYPESHIFT	EQU	8
HEAPTYPEMASK	EQU	00000700H
HEAPLOCKEDHIGH	EQU	00000000H
HEAPLOCKEDIFDP	EQU	00000100H
HEAPSWAP	EQU	00000200H
HEAPINIT	EQU	00000400H
HEAPCLEAN	EQU	00000800H
HEAPCONTIG	EQU	00001000H
HEAPFORGET	EQU	00002000H
HEAPLOCKEDLOW	EQU	00000300H
HEAPSYSVM	EQU	00000500H
HEAPPREEMPT	EQU	00000600H

LF_ASYNC_BIT		EQU	0
LF_ASYNC		EQU	(1 << LF_ASYNC_BIT)
LF_USE_HEAP_BIT		EQU	1
LF_USE_HEAP		EQU	(1 << LF_USE_HEAP_BIT)
LF_ALLOC_ERROR_BIT	EQU	2
LF_ALLOC_ERROR		EQU	(1 << LF_ALLOC_ERROR_BIT)
LF_SWAP			EQU	(LF_USE_HEAP+(1 << 3))

ASSERT_RANGE_NULL_BAD		EQU	00000000H
ASSERT_RANGE_NULL_OK		EQU	00000001H
ASSERT_RANGE_IS_ASCIIZ		EQU	00000002H
ASSERT_RANGE_IS_NOT_ASCIIZ	EQU	00000000H
ASSERT_RANGE_NO_DEBUG		EQU	80000000H
ASSERT_RANGE_BITS		EQU	80000003H

VXDLDR_INIT_DEVICE		EQU	000000001H

VXDLDR_ERR_OUT_OF_MEMORY	EQU	1
VXDLDR_ERR_IN_DOS		EQU	2
VXDLDR_ERR_FILE_OPEN_ERROR	EQU	3
VXDLDR_ERR_FILE_READ		EQU	4
VXDLDR_ERR_DUPLICATE_DEVICE	EQU	5
VXDLDR_ERR_BAD_DEVICE_FILE	EQU	6
VXDLDR_ERR_DEVICE_REFUSED	EQU	7
VXDLDR_ERR_NO_SUCH_DEVICE	EQU	8
VXDLDR_ERR_DEVICE_UNLOADABLE	EQU	9
VXDLDR_ERR_ALLOC_V86_AREA	EQU	10
VXDLDR_ERR_BAD_API_FUNCTION	EQU	11
VXDLDR_ERR_MAX			EQU	11

VXDLDR_NOTIFY_OBJECTUNLOAD	EQU	0
VXDLDR_NOTIFY_OBJECTLOAD	EQU	1

VXDLDR_APIFUNC_GETVERSION   EQU 0
VXDLDR_APIFUNC_LOADDEVICE   EQU 1
VXDLDR_APIFUNC_UNLOADDEVICE EQU 2


struc DIOCParams
.Internal1		resd 1	; 00
.VMHandle		resd 1	; 04
.Internal2		resd 1	; 08
.dwIoControlCode	resd 1	; 0C
.lpvInBuffer		resd 1	; 10
.cbInBuffer		resd 1	; 14
.lpvOutBuffer		resd 1	; 18
.cbOutBuffer		resd 1	; 1C
.lpcbBytesReturned	resd 1	; 20
.lpoOverlapped		resd 1	; 24
.hDevice		resd 1	; 28
.tagProcess		resd 1	; 2C
endstruc

VWIN32_DIOC_GETVERSION		EQU	DIOC_GETVERSION
VWIN32_DIOC_DOS_IOCTL		EQU	1
VWIN32_DIOC_DOS_INT25		EQU	2
VWIN32_DIOC_DOS_INT26		EQU	3
VWIN32_DIOC_DOS_INT13		EQU	4
VWIN32_DIOC_SIMCTRLC		EQU	5
VWIN32_DIOC_DOS_DRIVEINFO	EQU	6
VWIN32_DIOC_CLOSEHANDLE		EQU	DIOC_CLOSEHANDLE

struc DIOCRegs
.reg_EBX	resd 1
.reg_EDX	resd 1
.reg_ECX	resd 1
.reg_EAX	resd 1
.reg_EDI	resd 1
.reg_ESI	resd 1
.reg_Flags	resd 1
endstruc

%ifndef FILE_FLAG_OVERLAPPED
struc _OVERLAPPED
.O_Internal	resd 1
.O_InternalHigh	resd 1
.O_Offset	resd 1
.O_OffsetHigh	resd 1
.O_hEvent	resd 1
endstruc
%endif


R0_OPENCREATFILE		equ	0D500h	; Open/Create a file
R0_OPENCREAT_IN_CONTEXT		equ	0D501h	; Open/Create file in current context
R0_READFILE			equ	0D600h	; Read a file, no context
R0_WRITEFILE			equ	0D601h	; Write to a file, no context
R0_READFILE_IN_CONTEXT		equ	0D602h	; Read a file, in thread context
R0_WRITEFILE_IN_CONTEXT		equ	0D603h	; Write to a file, in thread context
R0_CLOSEFILE			equ	0D700h	; Close a file
R0_GETFILESIZE			equ	0D800h	; Get size of a file
R0_FINDFIRSTFILE		equ	04E00h	; Do a LFN FindFirst operation
R0_FINDNEXTFILE			equ	04F00h	; Do a LFN FindNext operation
R0_FINDCLOSEFILE		equ	0DC00h	; Do a LFN FindClose operation
R0_FILEATTRIBUTES		equ	04300h	; Get/Set Attributes of a file
R0_RENAMEFILE			equ	05600h	; Rename a file
R0_DELETEFILE			equ	04100h	; Delete a file
R0_LOCKFILE			equ	05C00h	; Lock/Unlock a region in a file
R0_GETDISKFREESPACE		equ	03600h	; Get disk free space
R0_READABSOLUTEDISK		equ	0DD00h	; Absolute disk read
R0_WRITEABSOLUTEDISK		equ	0DE00h	; Absolute disk write

RCODE_OBJ	EQU	-1
LCODE_OBJ	EQU	01H
LDATA_OBJ	EQU	02H
PCODE_OBJ	EQU	03H
PDATA_OBJ	EQU	04H
SCODE_OBJ	EQU	05H
SDATA_OBJ	EQU	06H
CODE16_OBJ	EQU	07H
LMSG_OBJ	EQU	08H
PMSG_OBJ	EQU	09H
DBOC_OBJ	EQU	0BH
DBOD_OBJ	EQU	0CH
PLCODE_OBJ	EQU	0DH
PPCODE_OBJ	EQU	0FH
ICODE_OBJ	EQU	11H
IDATA_OBJ	EQU	12H
ICODE16_OBJ	EQU	13H
IMSG_OBJ	EQU	14H

struc ObjectLocation
OL_LinearAddr	resd 1
OL_Size		resd 1
OL_ObjType	resb 1
endstruc
MAXOBJECTS	EQU	25

struc Device_Location_List
DLL_DDB		resd 1
DLL_NumObjects	resb 1
DLL_ObjLocation	resb ObjectLocation_size
endstruc

%macro GetDeviceServiceOrdinal 2
  mov %1, @@%2
%endmacro

%macro VxDCall 1-*
  %rep %0 - 1
    %rotate -1
    push %1
  %endrep
  %rotate -1
  db 0xCD, 0x20
  dd @@%1
  %if %0 > 1
    lea esp, [esp + 4*(%0 - 1)]
  %endif
%endmacro

%define VxDcall VxDCall

%macro VMMCall 1-2+
  %ifndef MAKEDEP
    %if (@@%1 >> 16) <> VMM_Device_ID
      %error %1 is not a VMM Service
    %endif
  %endif
  VxDcall %1, %2
%endmacro

%define VMMcall VMMCall

%macro VxDJmp 1
  db 0xCD, 0x20
  dd (@@%1 | 0x80000000)
%endmacro
%define VxDjmp VxDJmp

%macro VMMJmp 1
  %ifndef MAKEDEP
    %if (@@%1 >> 16) <> VMM_Device_ID
      %error %1 is not a VMM Service
    %endif
  %endif
  VxDJmp %1
%endmacro

%define VMMjmp VMMJmp

struc VxD_Desc_Block
DDB_Next		resd 1
DDB_SDK_Version		resw 1;   DW  DDK_VERSION
DDB_Req_Device_Number	resw 1;   DW  UNDEFINED_DEVICE_ID
DDB_Dev_Major_Version	resb 1;   DB  0
DDB_Dev_Minor_Version	resb 1;   DB  0
DDB_Flags		resw 1;   DW  0
DDB_Name		resb 8;   DB  "        "
DDB_Init_Order		resd 1;   DD  UNDEFINED_INIT_ORDER
DDB_Control_Proc	resd 1;    DD  ?
DDB_V86_API_Proc	resd 1;    DD  0
DDB_PM_API_Proc		resd 1; DD  0
DDB_V86_API_CSIP	resd 1;    DD  0
DDB_PM_API_CSIP		resd 1; DD  0
DDB_Reference_Data	resd 1;  DD  ?
DDB_Service_Table_Ptr	resd 1;   DD  0
DDB_Service_Table_Size	resd 1;  DD  0
DDB_Win32_Service_Table	resd 1; DD  0
DDB_Prev		resd 1;    DD  'Prev'
DDB_Size		resd 1;    DD  SIZE(VxD_Desc_Block)
DDB_Reserved1		resd 1;   DD  'Rsv1'
DDB_Reserved2		resd 1;   DD  'Rsv2'
DDB_Reserved3		resd 1;   DD  'Rsv3'
endstruc

;
; Params 5-9 are optional, since most of the time they are generic
; params: devname, quoted devname, major, minor, devid, initorder, v86, pm, ref
; Control_Proc must be named devname_Control
;
%macro Declare_Virtual_Device 4-9 UNDEFINED_DEVICE_ID, UNDEFINED_INIT_ORDER, 0, 0, 0
global %1_DDB
%1_DDB:
istruc VxD_Desc_Block
	at DDB_Next,			dd 0
	at DDB_SDK_Version,		dw DDK_VERSION
	at DDB_Req_Device_Number,	dw %5
	at DDB_Dev_Major_Version,	db %3
	at DDB_Dev_Minor_Version,	db %4
	at DDB_Flags,			dw 0
%%start:
	at DDB_Name,			db %2
%%end:
	TIMES 8-(%%end-%%start)		db ' '

	at DDB_Init_Order,		dd %6
	at DDB_Control_Proc,		dd %1_Control
	at DDB_V86_API_Proc,		dd %7
	at DDB_PM_API_Proc,		dd %8
	at DDB_V86_API_CSIP,		dd 0
	at DDB_PM_API_CSIP,		dd 0
	at DDB_Reference_Data,		dd %9

%ifdef Create_Service_Table_%1
	at DDB_Service_Table_Ptr,	dd %1_Service_Table
	at DDB_Service_Table_Size,	dd Num_%1_Services
%else
	at DDB_Service_Table_Ptr,	dd 0
	at DDB_Service_Table_Size,	dd 0
%endif

	at DDB_Win32_Service_Table,	dd 0
	at DDB_Prev,			db 'verP'
	at DDB_Size,			dd VxD_Desc_Block_size
	at DDB_Reserved1,		db '1vsR'
	at DDB_Reserved2,		db '2vsR'
	at DDB_Reserved3,		db '3vsR'
iend
%endmacro

%macro Begin_Control_Dispatch 1
	%push	ControlDispatch
%1_Control:
%endmacro

;Message,Proc
%macro Control_Dispatch 2
%ifctx ControlDispatch
	cmp	eax,byte %1
	je	near %2
%else
	%error no matching Begin_Control_Dispatch for Control_Dispatch
%endif
%endmacro

%macro End_Control_Dispatch 0
%ifctx ControlDispatch
	xor	eax,eax		; clears carry too
	inc	eax
	retn
	%pop
%else
	%error no matching Begin_Control_Dispatch for End_Control_Dispatch
%endif
%endmacro

%macro Trace_Out 1
[segment _LDATA]
%%msg: db %1, 13, 10, 0
__SECT__
push	dword %%msg
VMMCall _Trace_Out_Service
%endmacro

%macro Trace_Outcc 2
j%-1	%%cont
Trace_Out %2
%%cont:
%endmacro

%macro Trace_OutE 1
Trace_Outcc e, %1
%endmacro
%define Trace_OutZ Trace_OutE

%macro Trace_OutNE 1
Trace_Outcc ne, %1
%endmacro
%define Trace_OutNZ Trace_OutNE

%macro Trace_OutC 1
Trace_Outcc c, %1
%endmacro

%macro Trace_OutNC 1
Trace_Outcc nc, %1
%endmacro


%endif
