%include "vxdn.inc"
%include "win32n.inc"
%include "util.mac"


global GetHeap
global GetMem
global FreeHeap
global FreeMem
global IsBadPtr


bits 32


segment _LTEXT

;HANDLE GetMem(DWORD SIZE)
;
; Allocate SIZE and return Handle (0 on failure).

GetHeap:
GetMem:
	push	ebp
	mov	ebp,esp
	push	edx
	push	ecx

%define SIZE ebp+8

	VMMCall	_HeapAllocate, dword [SIZE], byte HEAPZEROINIT

	pop	ecx
	pop	edx
	pop	ebp

%undef SIZE

	retn	4


;BOOL   FreeMem(HANDLE hMem)
;
; Free Block of memory and return TRUE on success.

FreeHeap:
FreeMem:
	push	ebp
	mov	ebp,esp
	push	edx
	push	ecx

%define hMem ebp+8

	VMMCall	_HeapFree, dword [hMem], byte 0

	pop	ecx
	pop	edx
	pop	ebp

%undef hMem

	retn	4


;BOOL   IsBadPtr(DWORD hBase, DWORD NbBytes)
;
; Check if NbBytes starting with hBase can be read.
; Return 0 if read can be performed.

IsBadPtr:
	push	ebp
	mov	ebp,esp
	push	edx
	push	ecx

%define hBase ebp+8
%define NbBytes ebp+12

	VMMCall	_Assert_Range, dword [hBase], dword [NbBytes], byte 0, byte 0, byte ASSERT_RANGE_NULL_BAD
	cmp	eax,byte 1
	sbb	eax,eax

	pop	ecx
	pop	edx
	pop	ebp

%undef hBase
%undef NbBytes

	retn	8
