; #########################################################################
;
;                  MasmFlip.asm  (c) Mike Bibby  14/10/98
;
; #########################################################################

      .586
      .MODEL FLAT,STDCALL
      option casemap :none  ; case sensitive

      include MasmFlip.inc
      include MasmFDD.inc

      includelib \masm32\lib\kernel32.lib
      includelib \masm32\lib\user32.lib
      includelib \masm32\lib\gdi32.lib
      includelib \masm32\lib\ddraw.lib
      includelib \masm32\lib\winmm.lib

BUFFERS			=	  	1

;################################################################################
;#                           prototypes of my PROCs                             #
;################################################################################
	Update				PROTO	STDCALL	:HWND
	Fail PROTO STDCALL, fhwnd:DWORD, ptrszMsg:DWORD

;################################################################################
;#                                 DATA                                         #
;################################################################################

.DATA

      szClassName               DB 'MasmFlip1',0
      szWindowTitle             DB 'MasmFlip 1',0

      hInstance                 DWORD           NULL
      hWnd                      DWORD           NULL
      hDC                       DWORD           NULL

      wc                        WNDCLASS        <?>
      msg                       MSG             <?>
      ps                        PAINTSTRUCT     <?>

      rect                      RECT            <?>

      fIsActive                 DWORD           FALSE
;---------------------- Feedback messages ---------------------------------
	szMessage			DB  "This is MasmFlip1!",0
	dwMessageLen		DWORD $ - szMessage - 1
	szEscMessage		DB "Press Escape to exit",0
	dwEscMessageLen		DWORD $ - szEscMessage - 1
	
;---------------------- Direct Draw Objects, etc.---------------------------------
	lpDD 			LPDIRECTDRAW 		NULL    	; DirectDraw object


      ; hDCPrimary          DD  NULL                          ; my device context
        hDCBack             DD  NULL


	ddsd 			DDSURFACEDESC 	<0>            
	ddscaps			DDSCAPS			<0>				

	lpDDSPrimary	LPDIRECTDRAWSURFACE NULL 		; DirectDraw primary surface
	lpDDSBack 		LPDIRECTDRAWSURFACE NULL 		; DirectDraw back buffer 

	ddbltfx 		DDBLTFX 	<?>
	
;--------------------- used in GetFrameRate --------------------------------------
	dwFrameTime 			DWORD 	0				;  Time of the last frame.
	dwFrames 				DWORD  	0				;  The frame rate (frames/second).
	dwFrameCount 			DWORD 	0				;  Frames displayed.

	outputBuffer 	DB			64 DUP(42)
	
	formatString 	DB 			'%d fps',0			; takes a decimal "input" - %d
	dwLength		DWORD			0
	
;-------- used in update to position and fill black rectangle --------------------
	dwXPos				DWORD  0
	dest				RECT 		<?>
	
;--------------------------------------------------------------------------
;---------------------- Feedback messages ---------------------------------
;----------------------- for DirectDraw   ---------------------------------
;---------------------- related failures  ---------------------------------
;--------------------------------------------------------------------------
szDirectDrawCreateFail 		DB 	"Unable to create DirectDraw object.",0
szSetCooperativeLevelFail 	DB 	"Unable to set cooperative level.",0
szSetDisplayModeFail 		DB 	"Unable to set display mode."
szCreateSurfaceFail 		DB 	"Unable to create (primary) surface.",0
szGetAttachedSurfaceFail	DB 	"Unable to find the attached surface (back buffer).",0
szBltFail					DB 	"Unable to do the blit.",0
szFlipFail					DB 	"Unable to perform flip." ,0
szGetDCFail					DB	"Unable to get DC.",0
;--- from my PROC Fail --------
szFromFail 					DB 'Message from Fail',0
szFail						DB "Fail",0
;--------------------------------------------------------------------------

;################################################################################
;#                                 CODE                                         #
;################################################################################

.CODE

;===============================================================================
;=== WinMain																 ===
;=== Initialise window, show/update it, enter message loop					 ===
;===============================================================================

WinMain	PROC

; first get the module handle
	invoke GetModuleHandleA, NULL	
	mov	[hInstance], eax

; initialise the main window
	call Initialise

    invoke ShowWindow, hWnd,SW_SHOWNORMAL			
    invoke UpdateWindow, hWnd
       
    call doDDInit
      
.WHILE TRUE
	invoke PeekMessageA, OFFSET msg,0,0,0,PM_NOREMOVE
	.IF eax != 0
    	invoke GetMessageA, OFFSET msg, 0,0,0
		cmp	eax, 0
    	je  end_loop
    	invoke TranslateMessage, OFFSET msg
    	invoke DispatchMessageA, OFFSET msg
    .ELSE
    	mov eax,[fIsActive]
    	.IF eax == TRUE
    		invoke Update,hWnd
    	.ELSE
    		invoke WaitMessage
    	.ENDIF	
    .ENDIF
.ENDW

end_loop:: 
    invoke ExitProcess, msg.msg_wParam

	ret

WinMain ENDP


;================================================================================
;=== WindowProc                     										  === 
;=== Deals with the messages by calling specific subroutines			      ===
;=== or passes them on to the default window procedure.						  ===
;================================================================================

WindowProc PROC  STDCALL, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

	mov eax,[wmsg]
	
	.if eax == WM_ACTIVATEAPP
		mov eax,wparam
		mov [fIsActive],eax
		xor eax,eax
		ret
	.elseif eax == WM_KEYDOWN
		mov eax,wparam
		.if eax==VK_ESCAPE
			invoke PostMessageA,hwnd,WM_CLOSE,0,0
			xor eax,eax
		.endif
		ret
    .elseif eax==WM_PAINT
		call wmPaint
		xor eax,eax
		ret
	.elseif eax==WM_DESTROY
	  	call	wmDestroy
	  	xor eax,eax
	  	ret
	.else
	    invoke DefWindowProcA, hwnd,wmsg,wparam,lparam
	    ret
	.endif	

WindowProc ENDP
;===============================================================================

;================================================================================
;=== wmPaint                     											  === 
;=== Draws a message centrally in the window's client area.				      ===
;================================================================================
wmPaint PROC

    invoke BeginPaint, hWnd,OFFSET ps
    mov	hDC, eax
	invoke GetClientRect,hWnd,offset rect
	invoke DrawTextA, hDC,offset szMessage,-1, offset rect, \ 
	     DT_CENTER OR DT_VCENTER OR DT_SINGLELINE
    invoke EndPaint, hWnd,OFFSET ps
    
    ret

wmPaint ENDP
;===============================================================================

;================================================================================
;=== wmDestroy                     											  === 
;=== Calls for WM_QUIT to be put in message queue.           			      ===
;================================================================================
wmDestroy PROC
	call ReleaseObjects
	invoke PostQuitMessage,0					; exit code of 0
	
	ret

wmDestroy ENDP
;==============================================================================

;===============================================================================
;=== Initialise 															 ===
;=== fills in a class structure, registers the class						 ===
;=== and creates a window based on that class.					        	 ===
;===============================================================================

Initialise PROC

; next initialize the window class structure
	mov	wc.wc_style, 		CS_HREDRAW + CS_VREDRAW	; redraw if height or width change
	mov	wc.wc_lpfnWndProc, 	offset WindowProc		; this handles messages for this class
	mov	wc.wc_cbClsExtra, 	0
	mov	wc.wc_cbWndExtra, 	0
	mov eax,[hInstance]								; superfluous - eax still has this
	mov	wc.wc_hInstance, 	eax						; got via GetModuleHandleA
	invoke LoadIconA, NULL, 	IDI_APPLICATION			; default application icon
	mov	wc.wc_hIcon, eax
  	invoke LoadCursorA,NULL, 	IDC_ARROW				; standard arrow cursor
	mov	wc.wc_hCursor, eax
	invoke GetStockObject, WHITE_BRUSH				; this ensures a white background...
	mov wc.wc_hbrBackground, eax					; ... on painting.
	mov wc.wc_lpszMenuName, NULL					; no menu to identify at present
    mov wc.wc_lpszClassName, offset szClassName		; used to identify the class you want
    												; whencreating an individual window
    
;now register this class of window  
    invoke RegisterClassA, 	offset wc				; tell it where the details are...
													; ... and log it in
													
; create a window based on the class registered above 
 	invoke CreateWindowExA,	WS_EX_TOPMOST,				\ 
 	 						offset szClassName,			\ 
 	 						offset szWindowTitle,		\ 
							WS_POPUP,					\ 
							0,0,						\ 
							200,						\ 
							200,						\ 
							0, 							\ 
							0, 							\ 
							hInstance,					\ 
							0							\ 
					
	mov	hWnd, eax
	
	ret

Initialise ENDP
;===============================================================================


;================================================================================
; Update 
;================================================================================
; This:
;	1. Puts the frame rate into outputBuffer with a call to GetFrameRate.
;   2. Clears the back buffer to white using the blitter.
;	3. Update the position of the black rectangle we're moving across it left to right.
;	4. Blit this rectangle - dest - with black.
;	5. Put frame rate, title and escape message onto the back surface.
;   6. Flip the back and primary surfaces to display our updated rectangle.
;================================================================================
Update PROC STDCALL, hwnd:HWND


;	1. Put the frame rate into outputBuffer with a call to GetFrameRate.
	call GetFrameRate

;   2. Clear the back buffer to white using the blitter.
	; first fill the ddbltfx structure with required values
	mov ddbltfx.dwSize, SIZE ddbltfx 
	mov ddbltfx.dwFillColor,NOT 0
    
	; now fill the the whole back surface with a blit by pushing the parameters
	; then dereferencing the pointer to the object and calling the blit method
	lea eax, ddbltfx							; here we're just specifying the colour
	push eax
	mov eax, DDBLT_COLORFILL + DDBLT_WAIT		; specify the blit we want
	push eax
	push 0
	push 0
	push NULL						; this is the whole of the surface, so it's NULL	
   	mov eax,[lpDDSBack] 			; the pointer to the object instance - the back buffer - 
    push eax						; is the last parameter...
    
    mov eax,[eax]					; dereference the pointer
    call DWORD PTR [eax + DDBLT]   			; index into the object's virtual table to find the Blt method
									; and call it
	.IF eax != DD_OK
    	invoke Fail, hwnd, offset szBltFail
    	jmp end_loop
    .ENDIF	

;3.  Having crudely made the back surface all white we update the position
; 	 of the black rectangle we're moving across it left to right

	mov eax,[dwXPos]
    mov ddbltfx.dwFillColor,0
    mov dest.rect_left,eax
    mov dest.rect_top, 200
    add eax,100
    mov dest.rect_right,eax
    mov dest.rect_bottom,300
    
    ;------ if rectangle's reached the right side, move back to the left
    sub eax,95
    .IF eax >540
    	mov eax,0
    .ENDIF
    
    mov [dwXPos],eax
    
    ;------ now fill the rectangle... as we did with the whole back surface
	lea eax, ddbltfx
	push eax
	mov eax, DDBLT_COLORFILL + DDBLT_WAIT
	push eax
	push 0
	push 0
	push offset dest					;this is the rectangle 	
   	mov eax,[lpDDSBack] 				; instance
    push eax
    mov eax,[eax]
    call DWORD PTR [eax + DDBLT]   		; Blt

	.IF eax != DD_OK
    	invoke Fail, hwnd, offset szBltFail
    	jmp end_loop
    .ENDIF

;5. Now we write the frame rate in outputBuffer, as well as the  title and 
;   a message to press escape to exit, onto our back surface.


	;------ get device context for back buffer/surface
    lea eax, hDCBack
    push eax
    mov eax,[lpDDSBack] ; instance
    push eax
    mov eax,[eax]
    call DWORD PTR [eax + DDGETDC]
	.IF eax != DD_OK
    	invoke Fail, hwnd, offset szGetDCFail
    	jmp end_loop
    .ENDIF  

	;------ use this to do some text manipulation/output
	invoke SetTextColor,hDCBack,0
	invoke SetTextAlign,hDCBack,TA_CENTER
	invoke TextOutA,hDCBack,320,0,offset outputBuffer, [dwLength]  
	invoke TextOutA,hDCBack,320,20,offset szMessage, [dwMessageLen] 
	invoke TextOutA,hDCBack,320,40,offset szEscMessage, [dwEscMessageLen] 

	;------ release device context for back buffer/surface
    mov eax, [hDCBack]
    push eax
    mov eax,[lpDDSBack] ; instance
    push eax
    mov eax,[eax]
    call DWORD PTR [eax + DDRELEASEDC]



; Finally, perform the flip which makes the contents of our back surface/buffer
; that of the primary surface and vice-versa. ie we see what we have drawn.

	push DDFLIP_WAIT
	push 0
	mov eax,[lpDDSPrimary] 				; instance
    push eax
    mov eax,[eax]
    call DWORD PTR [eax + DDFLIP]   				; Flip
    
    .IF eax != DD_OK
    	invoke Fail, hwnd, offset szFlipFail
    	jmp NEAR PTR end_loop
    .ENDIF	
	
	
	ret

Update ENDP
;==============================================================================
; GetFrameRate
;==============================================================================
; This:
; 1. Increases the frame count - dwFrameCount
; 2. Gets the system time in millseconds - checks it against last calc's time
; 	 in dwFrameTime. IF a second or over has past: 
;		a. it recalculates frames per second and store value in dwFrames. 
;		b. It then sets dwFrameTime to the current time
;    	c. resets dwFrameCount to zero.
; 3. Uses wsprintfA to put the frame rate as a stringin outputBuffer.
; 4. Uses lstrlenA to put string's length into dwLength
;==============================================================================
 GetFrameRate PROC

	inc [dwFrameCount]
	
	invoke timeGetTime
	sub eax, dwFrameTime
	mov ecx,eax
	.IF eax >= 1000
		mov	eax, [dwFrameCount]
		lea	edx, DWORD PTR [eax+eax*4]
		lea	eax, DWORD PTR [edx+edx*4]
		lea	edx, DWORD PTR [eax+eax*4]
		lea	eax, DWORD PTR [edx*8]
		sub	edx, edx
 	 	div	ecx
	  	mov [dwFrames],eax	

		invoke timeGetTime
		mov [dwFrameTime],eax
		mov [dwFrameCount],0
.ENDIF
	
	
	push  [dwFrames]
	push offset formatString
	push offset outputBuffer

	call wsprintfA 

	add esp,12
	
	invoke lstrlenA, offset outputBuffer		; API to get null terminated string length
	mov [dwLength],eax

ret

 GetFrameRate ENDP

;==============================================================================
; doDDInit
;==============================================================================
; This:
; 1. Creates a DirectDraw object.
; 2. Greedily sets the coperative level so that it's in exclusive mode.
; 3. Switches display mode to 640 by 480 palettised.
; 4. Creates a primary surface with a back buffer
; 5. Gets a pointer to the back buffer.
;==============================================================================

doDDInit PROC
; 1. Create a DirectDraw object.
    invoke DirectDrawCreate, NULL, offset lpDD,NULL
    ; take action if it fails
    .IF eax != DD_OK
    	invoke Fail, hWnd, offset szDirectDrawCreateFail
    	jmp end_loop
    .ENDIF
    
; 2. Greedily set the coperative level so that it's in exclusive mode										
    push (DDSCL_EXCLUSIVE OR DDSCL_FULLSCREEN)
    push [hWnd]
    mov eax,[lpDD]
    push eax       ; this pushes instance onto stack
    mov eax,[eax]  ; first step to decode...
    call DWORD PTR [eax+DDSETCOOPERATIVELEVEL]  ; ... call address for SetCooperativeLevel   
	;check for error
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szSetCooperativeLevelFail
    	jmp end_loop
    .ENDIF	
    
  
;  3. Switch display mode to 640 by 480 palettised. 	
    push 8         ; bpp
    push 480       ; cy
    push 640       ; cx
    mov eax,[lpDD] ; pointer to the instance of the DDobject
    push eax
    mov eax,[eax]	; dereference the pointer
    call DWORD PTR [eax + DDSETDISPLAYMODE]		; Call SetDisplayMode method by indexing
    									; into object's virtual methods
	;check for error
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szSetDisplayModeFail
    	jmp end_loop
    .ENDIF

; 4. Create a primary surface with a back buffer.
    mov ddsd.dwSize, SIZE ddsd
    mov ddsd.dwsurfFlags,DDSD_CAPS+DDSD_BACKBUFFERCOUNT			

    mov ddsd.ddssurfCaps.dwCaps, 		DDSCAPS_PRIMARYSURFACE OR\
    								 	DDSCAPS_FLIP OR\
    								  	DDSCAPS_COMPLEX OR\
    								  	DDSCAPS_VIDEOMEMORY
    mov ddsd.dwBackBufferCount, BUFFERS	
 
    push NULL
    mov eax, offset lpDDSPrimary
    push eax
    mov eax, offset ddsd
    push eax
    mov eax,[lpDD] ; instance
    push eax
    mov eax,[eax]
    call DWORD PTR [eax + DDCREATESURFACE]				;CreateSurface
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szCreateSurfaceFail
    	jmp end_loop
    .ENDIF	     
    
; 5. Get a pointer to the back buffer. 
	mov ddscaps.dwCaps, DDSCAPS_BACKBUFFER  ; specifythe back buffer
	lea eax, lpDDSBack						; the pointer you get is stored here
	push eax
	lea eax, ddscaps
	push eax
	mov eax,[lpDDSPrimary]					; the surface the back buffer is attached to
	push eax
	mov eax,[eax]
	call DWORD PTR [eax + DDGETATTACHEDSURFACE]		; GetAttachedSurface
	.IF eax != DD_OK
    	invoke Fail, hWnd, offset szGetAttachedSurfaceFail
    	jmp end_loop
    .ENDIF
    
ret
doDDInit ENDP
;===============================================================================


;===============================================================================
; Fail
;===============================================================================
; This releases objects, outputs the supplied message and returns.
;===============================================================================
	
Fail PROC, fhwnd:DWORD, ptrszMsg:DWORD
	call ReleaseObjects
	invoke MessageBoxA,fhwnd,ptrszMsg,offset szFromFail,MB_OK
	mov eax,0
	ret	

Fail ENDP
;===============================================================================


;===============================================================================
; ReleaseObjects
;===============================================================================
; This
; 1. Releases Primary surface if any (plus, implicitly, other attached surfaces)
; 2. Makes Primary and Back surface pointers NULL
; 3. Releases DirectDraw object
; 4. Makes pointer to DirectDraw object NULL
;===============================================================================
ReleaseObjects PROC
	.IF lpDD != NULL
		.IF lpDDSPrimary != NULL
			;release Primary surface
    		mov eax, [lpDDSPrimary]
    		push eax
    		mov eax, [eax]
    		call DWORD PTR [eax + DDRELEASE]			; Release
			mov [lpDDSPrimary],NULL
			mov [lpDDSBack], NULL
		.ENDIF
		;release DirectDraw object
    	mov eax, [lpDD]
    	push eax
    	mov eax, [eax]
    	call DWORD PTR [eax + DDRELEASE]			; Release
		mov [lpDD],NULL
	.ENDIF
	ret
szReleaseObjects  	DB	"ReleaseObjects",0
ReleaseObjects ENDP
;===============================================================================



;################################################################################
;#                              CODE ENDS                                       #
;################################################################################

end WinMain 

################################################################################
#                              END OF FILE                                     #
################################################################################


