;
; Virogen's API Importer v0.10
; Fri. 05/07/99 8:00pm
; ----------------------------------------------------------------
; This procedure finds API addresses by traversing the export table
; of a given module handle (base), thereby removing the necessity of
; GetProcAddress. The usefulness of this is clear, combined with my 
; procedure to find the kernel32 base, one can import kernel32 API
; addresses without relying on the system module loader in any way,
; or on any pre-imported APIs. This procedure may also be useful
; on other occaisions where it is desirable not to use GetProcAddress.
; Many people asked for explainations on how lorez and heretic 
; performed this operation, so here'z to yall.
;
; This procedure simply traverses the export table of the given
; module, and finds the API address. This is best described in
; the following formulas:
;
;    APINameIndex=Number of the entry in the ExportNamePointerTable
;    Ordinal Number=OrdinalTable[(APINameIndex+1)*2]
;    API RVA=ExportAddressTable[(OrdinalNumber-OrdinalBase)*4]
;
; DWORD VgImport(DWORD ModuleBase, DWORD pAPIName, DWORD Ordinal)
;
; ModuleBase=Base of the module you want to import the API from.
; pAPIName  =pointer to the ASCIIz name of the API, or NULL if you
; 	     are importing by ordinal.
; Ordinal   =Ordinal number if you wish to import by ordinal, use
; 	     0 if pAPIName is supplied.
;
; Returns:
; 0 if error, otherwise the return value (in eax) is the address
; of the API.
;
;
;
;						Enjoy!
;						Virogen
;						http://virogen.cjb.net

.386
locals
jumps
.model flat,STDCALL

public VgImport
extrn ExitProcess:PROC	; this is imported cuz NT doesn't like not
			; having an import table in this DLL.. I think
			; this is a tasm related bug.

org 0  
.data                                 
db 	'__Virogen''s API Importer',0
.code    
start:
; DLLMain	
	pop	eax
	add	esp,12
	push	eax
	mov	eax,1
	ret
; 
; DWORD VgImport(DWORD ModuleBase, DWORD pAPIName, DWORD Ordinal)
;
VgImport proc
	pop	eax			
	pop	ebx		; ebx->ModuleBase
	pop	edi		; edi->pAPIName
	pop	ecx		; ecx=Ordinal	
	push	eax
	
	mov	edx,ebx		; edx=base
	
	cmp	word ptr [ebx],'ZM'
	jnz	ret_error
	movzx	eax,word ptr [ebx+3ch]
	add	ebx,eax		; ebx->PE Header
	cmp	word ptr [ebx],'EP'
	jnz	ret_error
	
	mov	ebx,[ebx+120]	; ebx->RVA of Export Table
	add	ebx,edx		; ebx->Export table
	
	or	edi,edi		; was pAPIName supplied?
	jz	ImportByOrdinal

	mov	esi,[ebx+32]	; esi->RVA of Address Name Table
	add	esi,edx		; esi->Address Name Table
				
	mov	ecx,[ebx+24]	; ecx=number of API Names
	
	push	ebx
	xor	ebx,ebx		; use ebx as counter
SearchLoop:
	lodsd			; eax->RVA of API Name	
	add	eax,edx		; eax->API Name	
	push	esi edi
	xchg	edi,esi		; esi->pAPINamse
	xchg	edi,eax		; edi->API Name
strcmpi:
	lodsb
	or	al,al		; end of string?
	jnz	not_zero
	cmp	byte ptr [edi],0
	jz      found_api	; if so make sure other string ends
	jmp	didnt_find_api
not_zero:
	cmp	byte ptr [edi],al
	jnz	didnt_find_api	
	inc	edi	
	jmp	strcmpi
didnt_find_api:
	mov	al,1		; 1==continue search to next api	
found_api:			
	pop	edi esi
	or	al,al		; if 0 then we found the api
	jz	EndLoop
	inc	ebx
	loop	SearchLoop
EndLoop:					
	xchg	eax,ebx		; eax=index					
	pop	ebx		; ebx->Export Table
	mov	esi,[ebx+36]	; esi->RVA of Ordinal Table
	add	esi,edx		; esi->Ordinal Table
	mov	ecx,2		; *2 for word table
	inc	eax
	call	MultiplyEaxEcx
	add	esi,eax		; esi->Ordinal number
	movzx	ecx,word ptr [esi] ; ecx=Ordinal number		
; entry:
; ecx=ordinal
ImportByOrdinal:		
	sub	ecx,dword ptr [ebx+16]	; subtract ordinal base	
	mov	esi,[ebx+28]	; esi->RVA of Address table
	add	esi,edx		; esi->Address Table
	xchg	eax,ecx		; eax=ordinal #
	mov	ecx,4		; *4 for dword table
	call	MultiplyEaxEcx
	add	esi,eax		; esi->Address
	mov	eax,dword ptr [esi] ; eax->RVA of API
	add	eax,edx		; eax->API
	ret
ret_error:
	xor	eax,eax
	ret	
   	
VgImport endp

MultiplyEaxEcx proc
	push	edx
	xor	edx,edx
	mul	ecx
	pop	edx
	ret
MultiplyEaxEcx endp

db 'VGIMPORT010',0
end start
ends