         title   CD Player
         comment '===========================================================|'
         comment '* CD Player v1.0                                           *'
         comment '* Copyright (c) 2000 Ewayne L. Wagner, All Rights Reserved.*'
         comment '* Unless you can improve on the program and send me        *'
         comment '* the changes. yooper@kalamazoo.net                        *'
         comment '===========================================================|'
         .586
         .model flat, stdcall
            option   casemap: none
            include  \MASM32\include\windows.inc
            include  \MASM32\include\user32.inc
            include  \MASM32\include\kernel32.inc
            include  \MASM32\include\gdi32.inc
            include  \MASM32\include\winmm.inc
            include  \MASM32\include\comctl32.inc
            include  \MASM32\include\advapi32.inc

;     include  \MASM32V1\include\DSPMACRO.asm

         includelib  \MASM32\LIB\USER32.LIB
         includelib  \MASM32\LIB\KERNEL32.LIB
         includelib  \MASM32\LIB\GDI32.LIB
         includelib  \MASM32\LIB\winmm.lib
         includelib  \MASM32\LIB\comctl32.lib
         includelib  \MASM32\LIB\advapi32.lib

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

.data

BitMap       db  'PlayCD.bmp',0
ClassName    db  'CD Player',0
ButtClass    db  'BUTTON',0
ToolTipClass db  'Tooltips_class32',0

;FontNameA    db  'Arial Narrow',0
FontNameA    db  'MS Sans Serif',0
DriveLetter  db  'C:\',0
szSubKey     db  'System\CurrentControlSet\control\MediaResources\mci\cdaudio',0 
szKey        db  'Default Drive',0
szSubKeyCD   db  'Software\EW Software\CD Player\',0
szREGSZ      db  'REG_SZ',0
szTrk        db  'Trk '
szIndex      db  2 dup(?),0
szCDName     db  'CD Name',0
szUntitled   db  'Untitled ',0
szPlayList   db  'z Play List',0 
szHelp       db  'CDPlay.hlp',0
dlgname      db  'PlayList',0
szSpace      db  ' ',0

szAbout      db  '              CD Player v1.0  Written in Assembler.'
             db   0Dh,0Ah
             db   0Dh,0Ah
             db  'CD Player  2000 Ewayne Wagner. All rights reserved.'
             db   0Dh,0Ah
             db   0Dh,0Ah
             db  '     Send any comments to: yooper@kalamazoo.net'
             db   0Dh,0Ah
             db  '                     Ewayne Wagner 09-08-2000',0

hInst        dd  0
hWnd         dd  0
hSMenu       dd  0
hToolTip     dd  0
hDlg         dd  0
hDC          dd  0
hMemDC       dd  0
hFontA       dd  0
hMixer       dd  0
hKey         dd  0
hReg         dd  0
hRegD        dd  0
DriveCD      dd  0
CurDriveCD   dd  0
DefaultCD    dd  0
VolCtlIDM    dd  0
VolCtlID     dd  0
VolValue     dd  0
SerialNum    dd  0      
SubButt      dd  0
SubSlider    dd  0
PosX         dd  0
PosY         dd  0
KeyDown      dd  0
sKeyDown     dd  0
Cnt          dd  0
PM           dd  0
TrackOn      dd  0
TrkSel       dd  0
Play         dd  0
Stop         dd  0
Pause        dd  0
Sample       dd  0
Sound        dd  0
NumChannels  dd  0 
Mode         dd  0
Samp         dd  0
NoSet        dd  0
StopFlg      dd  0
PlayFlg      dd  0
PauseFlg     dd  0
SampleFlg    dd  0
SoundFlg     dd  0
Counter      dd  0
PlayCD       dd  0
LoopTrk      dd  0
TotTrks      dd  0
Shuttle      dd  0
SavTrkNum    dd  0
NoPaint      dd  0
FromButt     dd  0
Incr         dd  0

DriveArray   db  10 dup(?)
szVol        db  20 dup(?)
szTrkNum     db  3  dup(?)
szTrkTot     db  3  dup(?)
szTrkSel     db  3  dup(?)
szSavTrkNum  db  3  dup(?)
szWork       db  50 dup(?)
szBuff       db  50 dup(?)
szMin        db  3  dup(?)
szSec        db  3  dup(?)
szDrive      db  ' ',0
szCDNameD    db  50 dup(?)

hStat        dd  5  dup(0)
hButtD       dd  2  dup(0)
hListL       dd  0
hListR       dd  0
hVolM        dd  0
hVolL        dd  0
hVolR        dd  0
Style        dd  0
hButt1       dd  0
hButt2       dd  0
hButt3       dd  0
hButt4       dd  0
hButt5       dd  0
hButt6       dd  0
hButt7       dd  0
hButt8       dd  0
hButt9       dd  0
hButt10      dd  0
hButt11      dd  0
hButt12      dd  0
hButt13      dd  0
hButt14      dd  0

;***** DON'T CHANGE THE FOLLOWING SQUENCE OR ADD TO
;***** UNLESS YOU CHANGE THE APPROPRIATE CODE
hBitMap      dd  0
hButt1U      dd  0
hButt2U      dd  0
hButt3U      dd  0
hButt4U      dd  0
hButt5U      dd  0
hButt6U      dd  0
hButt7U      dd  0
hButt8U      dd  0
hButt9U      dd  0
hButt10U     dd  0
hButtStop    dd  0
hButtPlay    dd  0
hButtPause   dd  0
hN0          dd  0
hN1          dd  0
hN2          dd  0
hN3          dd  0
hN4          dd  0
hN5          dd  0
hN6          dd  0
hN7          dd  0
hN8          dd  0
hN9          dd  0
hStat1       dd  0
hStat1On     dd  0
hStat2       dd  0
hStat2On     dd  0
hStat3       dd  0
hStat3On     dd  0
hMode1       dd  0
hMode1On     dd  0
hMode2       dd  0
hMode2On     dd  0
hMode3       dd  0
hMode3On     dd  0
hMode4       dd  0
hMode4On     dd  0
hMode5       dd  0
hMode5On     dd  0
hButt11U     dd  0
hButt12U     dd  0
hButtCD      dd  0
hButtSndOn   dd  0
hButtSndOff  dd  0
hVol         dd  0
hDlgButt1    dd  0
hDlgButt2    dd  0
;**************************

bArray       dd  0, 0, 0, 0

SelTrk       dd  435, 40, 452, 51
CDNameD      dd  118, 20, 268, 30
TrkNameD     dd  118, 41, 268, 51
UniNum       dd  157, 41, 170, 51

TrkNum       dd  446, 23, 458, 33, 0
TrkTot       dd  479, 23, 492, 33, 0
LenTrk       dd  373, 35, 402, 45, 0
LenTot       dd  373, 46, 402, 56, 0

Mode1        dd  501, 19, 522, 33, 0
Mode2        dd  528, 19, 547, 33, 0
Mode3        dd  501, 39, 522, 53, 0
Mode4        dd  528, 39, 547, 53, 0
Mode5        dd  460, 39, 495, 53, 0
Drive        dd  408, 39, 428, 53, 0
Track        dd  434, 39, 454, 53, 0
Exit1        dd  598, 10, 613, 25, 0
Info         dd  582, 10, 597, 25, 0

szOpen       db  'open cdaudio',0
szDevID      db  'cdaudio',0
szClose      db  'close cdaudio',0
szPlay       db  'play cdaudio',0
szPlayL      db  'play cdaudio notify',0              ; Set notify for loop
szPlayF      db  'play cdaudio from 01:01:01 notify',0
szPause      db  'pause cdaudio',0
szStop       db  'stop cdaudio',0
szSeekTo     db  'seek cdaudio to 01',0               ; Set track number in 01
szEject      db  'set cdaudio door open wait',0
szShut       db  'set cdaudio door closed wait',0
szTMSF       db  'set cdaudio time format tmsf',0
szMilSec     db  'set cdaudio time format milliseconds', 0
szSoundOF    db  'set cdaudio audio all oxx',0        ; Set xx to "n " for sound on, or "ff" for sound off
szMode       db  'status cdaudio mode',0
szPosition   db  'status cdaudio position',0
szPositionT  db  'status cdaudio position track 01',0
szPositionC  db  'status cdaudio 01', 0
szNumTrks    db  'status cdaudio number of tracks',0
szTotLen     db  'status cdaudio length wait',0       ; Total length
szTrkLen     db  'status cdaudio length track 01',0   ; Track length


Test4        dd  0
NotDone      dd  1

rect   RECT       <?>
lf     LOGFONT    <?>
time   SYSTEMTIME <?>
ti     TOOLINFO   <?>

align     DWORD
ProgBar   struc
      left    dd  279
      top     dd  47
      right   dd  360
      bottom  dd  50
ProgBar   ends
pb     ProgBar    <>

mxdc    MIXERCAPS                    <?>
mxl     MIXERLINE                    <?>
mxlc    MIXERLINECONTROLS            <?>
mxc     MIXERCONTROL                 <?>
mxcd    MIXERCONTROLDETAILS          <?>
mxcdVol MIXERCONTROLDETAILS_UNSIGNED <?>

CreateWindowButt PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
CreateSliders    PROTO :DWORD, :DWORD, :DWORD, :DWORD
EnumChild        PROTO :DWORD, :DWORD
ControlButt      PROTO :DWORD, :DWORD, :DWORD, :DWORD
SliderCtl        PROTO :DWORD, :DWORD, :DWORD, :DWORD
PlayList         PROTO :DWORD, :DWORD, :DWORD, :DWORD
CDName           PROTO :DWORD, :DWORD, :DWORD, :DWORD
TrkName          PROTO :DWORD, :DWORD, :DWORD, :DWORD
CopyBitMap       PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
LoadBmp          PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
DisplayTime      PROTO :DWORD, :DWORD
CreateRect       PROTO :DWORD, :DWORD
AsciiBase        PROTO :DWORD
BaseAscii        PROTO :DWORD, :DWORD, :DWORD

.code
START:

      INVOKE     GetModuleHandle, 0 ; Get hmod (in eax)
         mov     hInst, eax         ; hInst is same as HMODULE
      INVOKE     InitCommonControls

        call     WinMain
      INVOKE     ExitProcess, eax

;==========================================
; WndMain
;==========================================
WinMain proc
LOCAL    wc:WNDCLASSEX
LOCAL    msg:MSG

         mov     wc.cbSize, sizeof WNDCLASSEX
         mov     wc.style, CS_HREDRAW or CS_VREDRAW
         mov     wc.lpfnWndProc, offset WndProc
         mov     wc.cbClsExtra, 0
         mov     wc.cbWndExtra, 0
       MOVmd     wc.hInstance, hInst
         mov     wc.hbrBackground, COLOR_BTNTEXT+1
         mov     wc.lpszMenuName, 0
         mov     wc.lpszClassName, offset ClassName
      INVOKE     LoadIcon, hInst, 4000
         mov     wc.hIcon, eax
         mov     wc.hIconSm, 0 ;eax
      INVOKE     LoadCursor, 0, IDC_ARROW
         mov     wc.hCursor, eax
      INVOKE     RegisterClassEx, addr wc

      INVOKE     LoadMenu, hInst, 10001
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenu, eax

      INVOKE     CreateWindowEx, 0, addr ClassName, addr ClassName,\
                 WS_POPUPWINDOW or WS_VISIBLE, 0, 0, 662, 98, 0, 0, hInst, 0
         mov     hWnd, eax

      INVOKE     ShowWindow, hWnd, SW_SHOWNORMAL
      INVOKE     UpdateWindow, hWnd

      .while TRUE
         INVOKE     GetMessage, addr msg, 0, 0, 0
         .break .if (!eax)
         INVOKE     TranslateMessage, addr msg
         INVOKE     DispatchMessage, addr msg
      .endw
         mov     eax, msg.wParam
         ret
WinMain endp

;==========================================
; WndProc
;==========================================
WndProc proc uses ebx edx esi edi hwnd:DWORD,wMsg:DWORD,wParam:DWORD,lParam:DWORD
LOCAL     ps:PAINTSTRUCT
LOCAL     wF:DWORD, wT, xPos, CurTime, TrkTime, hBR, w1, SavSecs, Rand, id, lpcbData
LOCAL     szTimeC[6]:BYTE, szTimeT[6], szName[160]

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_CREATE
;---------- [C R E A T E] ----------
      .if wMsg == WM_CREATE
         INVOKE     GetSystemMetrics, SM_CXSCREEN
            sub     eax, 662
            shr     eax, 1
           push     eax 
         INVOKE     GetSystemMetrics, SM_CYSCREEN
            sub     eax, 98
            shr     eax,1
            pop     ebx
         INVOKE     MoveWindow, hwnd, ebx, eax, 662, 98, 1

;---------- [Create the buttons] ----------
            mov     Style, WS_CHILD or WS_VISIBLE or BS_OWNERDRAW
         INVOKE     CreateWindowButt, 0, Style, 111, 69, 38, 27, hwnd, 51, addr hButt1
         INVOKE     CreateWindowButt, 0, Style, 150, 69, 38, 27, hwnd, 52, addr hButt2
         INVOKE     CreateWindowButt, 0, Style, 189, 69, 38, 27, hwnd, 53, addr hButt3
         INVOKE     CreateWindowButt, 0, Style, 228, 69, 38, 27, hwnd, 54, addr hButt4
         INVOKE     CreateWindowButt, 0, Style, 267, 69, 38, 27, hwnd, 55, addr hButt5
         INVOKE     CreateWindowButt, 0, Style, 306, 69, 38, 27, hwnd, 56, addr hButt6
         INVOKE     CreateWindowButt, 0, Style, 345, 69, 38, 27, hwnd, 57, addr hButt7
         INVOKE     CreateWindowButt, 0, Style, 384, 69, 38, 27, hwnd, 58, addr hButt8
         INVOKE     CreateWindowButt, 0, Style, 423, 69, 38, 27, hwnd, 59, addr hButt9
         INVOKE     CreateWindowButt, 0, Style, 575, 69, 38, 27, hwnd, 60, addr hButt10
         INVOKE     CreateWindowButt, 0, Style, 500, 79, 28, 17, hwnd, 61, addr hButt11
         INVOKE     CreateWindowButt, 0, Style, 529, 79, 28, 17, hwnd, 62, addr hButt12
         INVOKE     CreateWindowButt, 0, Style, 471, 79, 28, 17, hwnd, 63, addr hButt13
         INVOKE     CreateWindowButt, 0, Style, 89, 75, 12, 12, hwnd, 64, addr hButt14

;---------- [Create the sliders] ----------
         INVOKE     CreateSliders, 46, hwnd, 65, addr hVolM
         INVOKE     CreateSliders, 68, hwnd, 66, addr hVolL
         INVOKE     CreateSliders, 90, hwnd, 67, addr hVolR

;---------- [Load the bitmaps] ----------
         INVOKE     LoadBmp, 5001, addr hButt1U, 13, 38, 27
         INVOKE     LoadBmp, 6001, addr hN0, 10, 20, 21
         INVOKE     LoadBmp, 7001, addr hStat1, 6, 15, 10
         INVOKE     LoadBmp, 8001, addr hMode1, 8, 21, 14
         INVOKE     LoadBmp, 8009, addr hMode5, 2, 35, 14
         INVOKE     LoadBmp, 9001, addr hButt11U, 3, 28, 17
         INVOKE     LoadBmp, 9004, addr hButtSndOn, 2, 12, 12
         INVOKE     LoadBmp, 9006, addr hVol, 1, 10, 11

;---------- [Create the ToolTips] ----------
         INVOKE     CreateWindowEx, 0, addr ToolTipClass, 0, TTS_ALWAYSTIP,\
                    CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,\
                    0, 0, hInst, 0
            mov     hToolTip, eax
;         INVOKE     SendMessage, hToolTip, TTM_SETDELAYTIME, TTDT_AUTOMATIC   , 1000

            mov     Cnt, 50
            mov     ti.cbSize, sizeof TOOLINFO
            mov     ti.uFlags, TTF_SUBCLASS or TTF_CENTERTIP

         INVOKE     EnumChildWindows, hwnd, addr EnumChild, addr ti

            mov     ti.uFlags, TTF_SUBCLASS
          MOVmd     ti.hWnd, hwnd
            mov     Cnt, 73 ;71
            lea     esi, LenTrk ;TrkNum
         .while (Cnt < 84)
             MOVmd     ti.rect.left, [esi]
             MOVmd     ti.rect.top, [esi+4]
             MOVmd     ti.rect.right, [esi+8]
             MOVmd     ti.rect.bottom, [esi+12]
             MOVmd     ti.hInst, hInst
             MOVmd     ti.lpszText, Cnt
              push     esi 
            INVOKE     SendMessage, hToolTip, TTM_ADDTOOL, 0, addr ti
               pop     esi
               inc     Cnt
               add     esi, 20 
         .endw

;--------- [Open the Mixer} ----------
         INVOKE     mixerOpen, addr hMixer, 0, 0, 0, 0
           test     eax, eax
            jnz     NoSetSnd

GetLR:
;--------- [Get the Line ID and the num of Channels] ----------
            mov     mxl.cbStruct, sizeof mxl
         .if !VolCtlIDM
               mov     mxl.dwComponentType, MIXERLINE_COMPONENTTYPE_DST_SPEAKERS     ; Master volume
         .else
               mov     mxl.dwComponentType, MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC  ; CD volume
         .endif
         INVOKE     mixerGetLineInfo, hMixer, addr mxl, MIXER_OBJECTF_HMIXER or MIXER_GETLINEINFOF_COMPONENTTYPE
           test     eax, eax
            jnz     NoSetSnd
          MOVmd     NumChannels, mxl.cChannels

;--------- [Get the volume control ID} ----------
            mov     mxlc.cbStruct, sizeof mxlc
          MOVmd     mxlc.dwLineID, mxl.dwLineID
            mov     mxlc.dwControlType, MIXERCONTROL_CONTROLTYPE_VOLUME
            mov     mxlc.cControls, 1
            mov     mxlc.cbmxctrl, sizeof mxc
            mov     mxlc.pamxctrl, offset mxc
         INVOKE     mixerGetLineControls, hMixer, addr mxlc, MIXER_OBJECTF_HMIXER or MIXER_GETLINECONTROLSF_ONEBYTYPE
           test     eax, eax
            jnz     NoSetSnd
         .if !VolCtlIDM
             MOVmd     VolCtlIDM, mxc.dwControlID
         .else
             MOVmd     VolCtlID, mxc.dwControlID
         .endif

;---------- [Get the volume value] ----------
          MOVmd     mxcdVol.dwValue, NumChannels
            mov     mxcd.cbStruct, sizeof mxcd
         .if !VolCtlID
             MOVmd     mxcd.dwControlID, VolCtlIDM
         .else
             MOVmd     mxcd.dwControlID, VolCtlID
         .endif
          MOVmd     mxcd.cChannels, NumChannels
            mov     mxcd.cMultipleItems, 0
            mov     mxcd.cbDetails, sizeof mxcdVol
            mov     mxcd.paDetails, offset mxcdVol
         INVOKE     mixerGetControlDetails, hMixer, addr mxcd, MIXER_OBJECTF_HMIXER or MIXER_GETCONTROLDETAILSF_VALUE
           test     eax, eax
            jnz     NoSetSnd

;---------- [Set the M/L/R volume sliders] ----------
         .if !VolCtlID
             MOVmd     VolValue, mxcdVol[0].dwValue
              call     GetSliderValue
            INVOKE     MoveWindow, hVolM, 46, ebx, 10, 11, 1
         .else
             MOVmd     VolValue, mxcdVol[0].dwValue
              call     GetSliderValue
            INVOKE     MoveWindow, hVolL, 68, ebx, 10, 11, 1
            .if NumChannels > 1
                MOVmd     VolValue, mxcdVol[4].dwValue
            .endif
              call     GetSliderValue
            INVOKE     MoveWindow, hVolR, 90, ebx, 10, 11, 1
         .endif
            cmp     VolCtlID, 0
             je     GetLR

;---------- [Find available CD ROM drives] ----------
         INVOKE     GetLogicalDrives
            mov     ebx, eax
            shr     ebx, 2                             ; Skip test for drives A: & B:
            xor     edx, edx
         .while (ebx > 0)
               shr     ebx, 1
              push     edx                             ; Push & Pop are for NT
              push     ebx
            INVOKE     GetDriveType, addr DriveLetter  ; Get type of drive
               pop     ebx
               pop     edx

;---------- [If CD ROM drive add the letter to the array] ----------
            .if eax == DRIVE_CDROM
                  mov     al, byte ptr DriveLetter
                  mov     DriveArray[edx], al
                  inc     edx
            .endif
               inc     DriveLetter
         .endw

;      ****** T E S T ******
;            mov     DriveArray[edx], 'Q'
;            inc     edx
;            mov     DriveArray[edx], 'R'
;            inc     edx
;            mov     DriveArray[edx], 'S'
;            inc     edx

            mov     DriveArray[edx], 0
;INVOKE     MessageBox, NULL, addr DriveArray, addr ClassName, MB_OK

;---------- [Find the default CD ROM drive in the registry] ----------
         INVOKE     RegOpenKeyEx, HKEY_LOCAL_MACHINE, addr szSubKey,\ ; Get Key 
                    0, KEY_QUERY_VALUE, addr hKey
            mov     lpcbData, 4
         INVOKE     RegQueryValueEx, hKey, addr szKey, 0, 0,\         ; Get default Drive
                    addr DriveCD, addr lpcbData

          MOVmd     DefaultCD, DriveCD                                ; Save default drive
            mov     eax, DriveCD
            mov     CurDriveCD, eax
            mov     bl, byte ptr DriveArray[eax]
            mov     szDrive, bl
            mov     DriveLetter, bl
;INVOKE     MessageBox, NULL, addr szDrive, addr ClassName, MB_OK

         INVOKE     SetTimer, hwnd, 44, 1000, 0 ; Timer every second

         INVOKE     lstrcpy, addr lf.lfFaceName, addr FontNameA
            mov     lf.lfHeight, -8
            mov     lf.lfWidth, 0
            mov     lf.lfWeight, 500
         INVOKE     CreateFontIndirect, addr lf
            mov     hFontA, eax
            mov     Mode1+16, 1 ; +16 = Button Down

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_NOTIFY
;---------- [N O T I F Y] ----------
      .elseif wMsg == WM_NOTIFY
            mov     ebx, lParam    ; Get pointer to NMHDR
            mov     eax, (NMHDR ptr [ebx]).code
         .if eax == TTN_SHOW || eax == TTN_POP
               mov     NoPaint, 1  ; Bypass paint if ToolTip
         .endif

      .elseif wMsg ==WM_SETFOCUS                ;????????????
.if NoPaint
;DSPValue hWnd, NoPaint
      and     NoPaint, 0
   INVOKE     SendMessage, hWnd, WM_PAINT, 0, 0 ;????????????
.endif

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_PAINT
;---------- [P A I N T] ----------
      .elseif wMsg == WM_PAINT
         INVOKE     BeginPaint, hwnd, addr ps
         .if !sKeyDown && !NoPaint
            .if FromButt
               INVOKE     SetTimer, hWnd, 44, 10, 0
            .endif

            INVOKE     GetDC, hWnd
               mov     hDC, eax
            INVOKE     CreateCompatibleDC, hDC
               mov     hMemDC, eax
            INVOKE     LoadBitmap, hInst, 4001
               mov     hBitMap, eax 
            INVOKE     SelectObject, hMemDC, hBitMap
            INVOKE     BitBlt, hDC, 0, 0, 660, 96, hMemDC, 0, 0, SRCCOPY ; Copy the bitmap
            INVOKE     ReleaseDC, hWnd, hDC      ; Release the control dc

            INVOKE     InvalidateRect, hVolM, 0, 0
            INVOKE     InvalidateRect, hVolL, 0, 0
            INVOKE     InvalidateRect, hVolR, 0, 0
         .endif

            and     NoPaint, 0
            and     FromButt, 0
         .if !Mode1+16
            INVOKE     CopyBitMap, hWnd, hMode1, 501, 19, 21, 14
         .endif
         .if Mode1+16
            INVOKE     CopyBitMap, hWnd, hMode1On, 501, 19, 21, 14
         .elseif Mode2+16
            INVOKE     CopyBitMap, hWnd, hMode2On, 528, 19, 21, 14
         .elseif Mode3+16
            INVOKE     CopyBitMap, hWnd, hMode3On, 501, 39, 21, 14
         .endif
         .if !Mode3+16
            INVOKE     CopyBitMap, hWnd, hMode3, 501, 39, 21, 14
         .endif
         .if Mode4+16
            INVOKE     CopyBitMap, hWnd, hMode4On, 528, 39, 21, 14
         .elseif Mode5+16
            INVOKE     CopyBitMap, hWnd, hMode5On, 460, 39, 35, 14
         .endif
         INVOKE     EndPaint, hwnd, addr ps

SetValues:
         INVOKE     ControlButt, hButt3, WM_PAINT, 0, 0
           call     DrawDrive

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_TIMER
;---------- [T I M E R] ----------
      .elseif wMsg == WM_TIMER
            cmp     wParam, 44        ; Is it our timer?
            jne     wmtimex           ; No, then exit timer

         .if PlayCD
            .if !Shuttle
               INVOKE     SetTimer, hWnd, 44, 1000, 0
            .endif
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szTimeC, addr szBuff+3, 6

            INVOKE     DisplayTime, 3, 278
            INVOKE     DisplayTime, 4, 298
            INVOKE     DisplayTime, 6, 322
            INVOKE     DisplayTime, 7, 342
            .if Drive+16
                  dec     Drive+16
            .endif
              call     DrawDrive

            INVOKE     GetDC, hwnd
               mov     hDC, eax
            INVOKE     SelectObject, hDC, hFontA    ; Select the font into the dc
            INVOKE     SetTextColor, hDC, 00ffff00h ; Set the text color
;            INVOKE     SetBkMode, hDC, TRANSPARENT  ; Set the text background to transparent
            INVOKE     SetBkColor, hDC, 00000000h   ; Set the text background color
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szIndex, addr szBuff, 3
            .if szBuff == '0'
               INVOKE     lstrcpyn, addr szTrkNum, addr szBuff+1, 2
            .else
               INVOKE     lstrcpyn, addr szTrkNum, addr szBuff, 3
            .endif
            INVOKE     mciSendString, addr szMode, addr szBuff, sizeof szBuff, hWnd
      INVOKE     SetWindowText, hWnd, addr szBuff

               cmp     Shuttle, 171  ; Track iterate
               jne     Pass
               mov     eax, TrkSel
            .if PM 
                  inc     eax
               .if eax > TotTrks
                     mov     eax, 1
               .endif
            .else
                  dec     eax
               .if eax == 0 || eax > 7fffffffh
                     mov     eax, TotTrks
               .endif
            .endif
               mov     TrkSel, eax 
            INVOKE     BaseAscii, eax, addr szTrkSel, 0
            INVOKE     CreateRect, addr SelTrk, addr rect
            INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
            INVOKE     DrawText, hDC, addr szTrkSel, -1, addr rect, DT_CENTER or DT_VCENTER or DT_SINGLELINE
Pass:
            .if TrackOn
                 inc     TrackOn
               .if TrackOn > 5
                     and     TrackOn, 0
                  INVOKE     CreateRect, addr Track, addr rect
                  INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
               .endif
            .endif
 
            .if szBuff == 's' && !Pause
                  mov     word ptr szTrkNum, '  '
            .endif

            INVOKE     CreateRect, addr TrkNum, addr rect
            INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
            INVOKE     DrawText, hDC, addr szTrkNum, -1, addr rect, DT_RIGHT or DT_VCENTER or DT_SINGLELINE

            INVOKE     CreateRect, addr CDNameD, addr rect
            INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
            INVOKE     DrawText, hDC, addr szCDNameD, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE

               mov     lpcbData, 50
            INVOKE     RegQueryValueEx, hReg, addr szTrk, 0, addr szREGSZ, addr szBuff, addr lpcbData
            .if eax == ERROR_SUCCESS
               INVOKE     CreateRect, addr TrkNameD, addr rect
               INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
               INVOKE     DrawText, hDC, addr szBuff, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE
            .else
               INVOKE     CreateRect, addr UniNum, addr rect
               INVOKE     FillRect, hDC, addr rect, COLOR_BTNTEXT+1
               INVOKE     DrawText, hDC, addr szTrkNum, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE
            .endif

            INVOKE     mciSendString, addr szNumTrks, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szWork, addr szBuff, 3
            INVOKE     CreateRect, addr TrkTot, addr rect
            INVOKE     DrawText, hDC, addr szWork, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE

            .if Shuttle == 171    ; Track iterate
                  jmp     Ret0
            .endif

            INVOKE     mciSendString, addr szMode, addr szBuff, sizeof szBuff, hWnd
            .if szBuff == 's' && !Pause
                  jmp     Pass1
            .endif

            INVOKE     lstrcpyn, addr szTrkLen+28, addr szTrkNum, 3
            INVOKE     mciSendString, addr szTrkLen, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szTimeT, addr szBuff, 6
            INVOKE     CreateRect, addr LenTrk, addr rect
            INVOKE     DrawText, hDC, addr szTimeT, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE

            INVOKE     mciSendString, addr szTotLen, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szWork, addr szBuff, 6
            INVOKE     CreateRect, addr LenTot, addr rect
            INVOKE     DrawText, hDC, addr szWork, -1, addr rect, DT_LEFT or DT_VCENTER or DT_SINGLELINE

;---------- [Progress bar] ----------
               mov     byte ptr szTimeC+2, 0
               mov     byte ptr szTimeT+2, 0
            INVOKE     AsciiBase, addr szTimeC
              imul     eax, 60 
               mov     CurTime, eax
            INVOKE     AsciiBase, addr szTimeC+3
               add     CurTime, eax
               mov     SavSecs, eax
            INVOKE     AsciiBase, addr szTimeT
              imul     eax, 60 
               mov     TrkTime, eax
            INVOKE     AsciiBase, addr szTimeT+3
               add     TrkTime, eax
             finit
              fild     TrkTime
              fild     CurTime
              fdiv     ST(0), ST(1)
               mov     CurTime, 81
              fild     CurTime
              fmul     ST(0), ST(1)
             fistp     pb.right
               add     pb.right, 279
            .if pb.right > 360
                  mov     pb.right, 360
            .endif
                 push     pb.right
                  mov     pb.right, 360
               INVOKE     FillRect, hDC, addr pb, COLOR_BTNTEXT+1
                  pop     pb.right
            INVOKE     CreateSolidBrush, 00ffff00h
               mov     hBR, eax
            INVOKE     FillRect, hDC, addr pb, eax
            INVOKE     DeleteObject, hBR           ; Delete the brush handle
            INVOKE     ReleaseDC, hwnd, hDC        ; Release the control dc

Pass1:
            INVOKE     mciSendString, addr szMode, addr szBuff, sizeof szBuff, hWnd
            .if szBuff == 's' && !Pause && !TrackOn  ; Stopped
               INVOKE     mciSendString, addr szStop, 0, 0, hWnd
               INVOKE     mciSendString, addr szClose, 0, 0, hWnd
                  and     PlayCD, 0
                  and     Play, 0
               INVOKE     SendMessage, hWnd, WM_PAINT, 0, 0
            .endif

            .if Shuttle == 151        ; Shuttle back
               INVOKE     SendMessage, hWnd, WM_COMMAND, 151, 0
            .endif
            .if Shuttle == 155        ; Shuttle forward
               INVOKE     SendMessage, hWnd, WM_COMMAND, 155, 0
            .endif

            .if Samp && SavSecs > 10  ; Next track for sample
               INVOKE     SendMessage, hWnd, WM_COMMAND, 59, 0
            .endif

            .if LoopTrk || Mode2+16   ; Track loop or play list
               jmp     ChkLoop
            .endif

            .if Mode3+16              ; Random play
               jmp     ChkRand
            .endif
         .endif

wmtimex:

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ MM_MCINOTIFY
;---------- [L O O P   CD] ----------
      .elseif wMsg == MM_MCINOTIFY && wParam != MCI_NOTIFY_ABORTED
         INVOKE     mciSendString, addr szStop, 0, 0, hWnd
         INVOKE     mciSendString, addr szClose, 0, 0, hWnd
         INVOKE     SendMessage, hWnd, WM_COMMAND, 8805, 0

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_COMMAND
;---------- [C O N T R O L S] ----------
      .elseif wMsg == WM_COMMAND
         .if wParam == 53 || wParam > 57 && wParam < 61 || wParam == 8804 || wParam == 8810 ||\
             wParam == 8805 || wParam == 8808 || wParam == 161 || wParam == 171 || wParam == 60
            INVOKE     mciSendString, addr szOpen, 0, 0, hWnd
            INVOKE     mciSendString, addr szTMSF, 0, 0, hWnd
            INVOKE     mciSendString, addr szNumTrks, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szTrkTot, addr szBuff, 3
            INVOKE     AsciiBase, addr szTrkTot
               mov     TotTrks, eax
            .if eax < 2
;Send error message not a valid CD
                  jmp     Ret0
            .endif
               mov     PlayCD, 1
            INVOKE     lstrcpy, addr szCDNameD, addr szUntitled
            INVOKE     GetVolumeInformation, addr DriveLetter, addr szVol, sizeof szVol,\
                       addr SerialNum, 0, 0, 0, 0
            INVOKE     BaseAscii, SerialNum, addr szWork, 0
               mov     word ptr szBuff, 'DC'
            INVOKE     lstrcpy, addr szBuff+2, addr szWork  ; Serial num
            INVOKE     lstrcpy, addr szName, addr szSubKeyCD
            INVOKE     lstrcat, addr szName, addr szBuff
            INVOKE     RegOpenKeyEx, HKEY_CURRENT_USER, addr szName,\
                       0, KEY_QUERY_VALUE, addr hReg
            .if eax == ERROR_SUCCESS
                  mov     lpcbData, 50
               INVOKE     RegQueryValueEx, hReg, addr szCDName, 0, addr szREGSZ, addr szCDNameD, addr lpcbData
            .endif
         .endif
 
;---------- [Fast shuttle back] ----------
         .if wParam == 151
            INVOKE     mciSendString, addr szMilSec, 0, 0, hWnd
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     AsciiBase, addr szBuff
            .if eax > 5000
               sub     eax, 5000
            .else
               mov     eax, 0
            .endif 
            INVOKE     BaseAscii, eax, addr szBuff, 0
            INVOKE     lstrcpy, addr szPlayF+18, addr szBuff
            INVOKE     mciSendString, addr szPlayF, 0, 0, hWnd
            INVOKE     mciSendString, addr szTMSF, 0, 0, hWnd

;---------- [Stop CD] ----------
         .elseif wParam == 52 && !Stop || wParam == 53 && Play && !Pause
StopEM:
            INVOKE     mciSendString, addr szStop, 0, 0, hWnd
            INVOKE     mciSendString, addr szClose, 0, 0, hWnd
               and     PlayCD, 0
               and     Samp, 0
               and     Sample, 0
            .if wParam != 52 && wParam != 53
                  and     Play, 0
            .endif
               mov     Mode1+16, 1
               and     Mode2+16, 0
               and     Mode4+16, 0
               and     Mode5+16, 0
               and     LoopTrk, 0
            INVOKE     SetWindowText, hWnd, addr ClassName
            INVOKE     RedrawWindow, hWnd, 0, 0, RDW_INTERNALPAINT or RDW_UPDATENOW ;or RDW_ALLCHILDREN
            INVOKE     SendMessage, hWnd, WM_PAINT, 0, 0 ; In case RedrawWindow didn't force WM_PAINT
               jmp     Ret0

;---------- [Play CD] ----------
         .elseif wParam == 53 && !Play || wParam == 54 && Pause && Play ||\
                 wParam == 53 && Play && Pause || wParam == 8804
            .if wParam == 8804
               INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
               INVOKE     lstrcpyn, addr szSeekTo+16, addr szBuff, 3
               INVOKE     mciSendString, addr szStop, 0, 0, hWnd
               INVOKE     mciSendString, addr szSeekTo, 0, 0, hWnd
            .endif
            INVOKE     mciSendString, addr szPlay, 0, 0, hWnd
            .if !Mode5+16
                  and     LoopTrk, 0
            .endif
            .if wParam == 53
                  mov     PM, 44
                  mov     eax, dword ptr Mode1+4
                  shl     eax, 16
                  mov     ax, word ptr Mode1
               INVOKE     SendMessage, hWnd, WM_LBUTTONDOWN, MK_LBUTTON, eax
            .endif

;---------- [Play CD and loop] ----------
         .elseif wParam == 8805
            .if Mode5+16 && LoopTrk
               INVOKE     lstrcpyn, addr szSeekTo+16, addr szTrkNum, 3
               INVOKE     mciSendString, addr szStop, 0, 0, hWnd
               INVOKE     mciSendString, addr szSeekTo, 0, 0, hWnd
            .else
                  and     LoopTrk, 0
            .endif
            INVOKE     mciSendString, addr szPlayL, 0, 0, hWnd

;---------- [Pause CD] ----------
         .elseif wParam == 54 && !Pause
            INVOKE     mciSendString, addr szPause, 0, 0, hWnd

;---------- [Fast shuttle forward] ----------
         .elseif wParam == 155
            INVOKE     mciSendString, addr szMilSec, 0, 0, hWnd
            INVOKE     mciSendString, addr szTotLen, addr szBuff, sizeof szBuff, hWnd
            INVOKE     AsciiBase, addr szBuff
               mov     w1, eax
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     AsciiBase, addr szBuff
               add     eax, 5000
            .if eax > w1
                  mov     eax, w1
            .endif
            INVOKE     BaseAscii, eax, addr szBuff, 0
            INVOKE     lstrcpy, addr szPlayF+18, addr szBuff
            INVOKE     mciSendString, addr szPlayF, 0, 0, hWnd
            INVOKE     mciSendString, addr szTMSF, 0, 0, hWnd

;---------- [Open drawer] ----------
         .elseif wParam == 56
            INVOKE     mciSendString, addr szStop, 0, 0, hWnd
            INVOKE     mciSendString, addr szClose, 0, 0, hWnd
            INVOKE     mciSendString, addr szEject, addr szBuff, sizeof szBuff, hWnd
               and     PlayCD, 0

;---------- [Close drawer] ----------
         .elseif wParam == 57
            INVOKE     mciSendString, addr szShut, addr szBuff, sizeof szBuff, hWnd

;---------- [Play previous, next track or sample] ----------
         .elseif wParam == 58 || wParam == 59
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szTrkNum, addr szBuff, 3
            INVOKE     AsciiBase, addr szTrkNum

            .if !Play
                  mov     word ptr szSeekTo+16, '10'
                  jmp     ReStart
            .endif

            .if wParam == 58
               .if eax > 1
                     dec     eax
               .else
                     mov     eax, TotTrks
               .endif
            .else
               .if eax < TotTrks
                     inc     eax
               .else
                     cmp     Samp, 1
                      je     StopEM
                     mov     eax, 1
               .endif
            .endif
            INVOKE     BaseAscii, eax, addr szTrkNum, 0
            INVOKE     lstrcpyn, addr szSeekTo+16, addr szTrkNum, 3

ReStart:
            INVOKE     mciSendString, addr szStop, 0, 0, hWnd
            INVOKE     mciSendString, addr szSeekTo, 0, 0, hWnd
               and     LoopTrk, 0

            .if !Mode3+16 && !Mode4+16 && !Mode5+16
               INVOKE     mciSendString, addr szPlay, 0, 0, hWnd
            .else
               INVOKE     mciSendString, addr szPlayL, 0, 0, hWnd
            .endif

            .if Mode5+16
               INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
               INVOKE     lstrcpyn, addr szSavTrkNum, addr szBuff, 3
                   or     LoopTrk, 1
            .endif

            .if !Play
                  mov     Play, 1
               INVOKE     CopyBitMap, hButt3, hButtPlay, 0, 0, 38, 27
               INVOKE     CopyBitMap, hWnd, hStat1On, 373, 21, 15, 10
            .endif
               jmp     Ret0

;---------- [Stop loop current track] ----------
         .elseif wParam == 8806 && Play
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szPlayF+18, addr szBuff, 9
            INVOKE     mciSendString, addr szPlayF, 0, 0, hWnd
               mov     LoopTrk, 0

;---------- [Loop current track] ----------
         .elseif wParam == 8807
            INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            INVOKE     lstrcpyn, addr szSeekTo+16, addr szBuff, 3
            INVOKE     lstrcpyn, addr szSavTrkNum, addr szBuff, 3
            INVOKE     AsciiBase, addr szSavTrkNum
            .if eax == TotTrks
               INVOKE     mciSendString, addr szPlayL, 0, 0, hWnd
            .endif
               mov     LoopTrk, 1

;---------- [Random play] ----------
         .elseif wParam == 8808
LoopR:
               mov     Rand, 5398475 ; Seed numbed
            INVOKE     GetLocalTime, addr time
               xor     eax, eax
               mov     ax, time.wMilliseconds
               add     Rand, eax
               mov     ax, time.wSecond
               add     Rand, eax
               mov     ebx, TotTrks  ; Hi num
               sub     ebx, 1        ; Lo num
               inc     ebx
               xor     edx, edx
               mov     eax, Rand
               div     ebx
               add     Rand, eax
               add     edx, 1        ; Lo num
               mov     eax, edx
            .if eax > TotTrks || eax == SavTrkNum
                  jmp     LoopR
            .endif
               mov     SavTrkNum, eax
            INVOKE     BaseAscii, eax, addr szBuff, 0
            INVOKE     lstrcpyn, addr szSeekTo+16, addr szBuff, 3
               jmp     ReStart

;---------- [Play List] ----------
         .elseif wParam == 8810
            mov     lpcbData, 160
         INVOKE     RegQueryValueEx, hReg, addr szPlayList, 0, addr szREGSZ, addr szName, addr lpcbData
            .if eax == ERROR_SUCCESS && byte ptr szName != ';'
                  mov     eax, Incr
               INVOKE     lstrcpyn, addr szSeekTo+16, addr szName[eax], 3
                  mov     eax, Incr
               INVOKE     lstrcpyn, addr szSavTrkNum, addr szName[eax], 3
                  add     Incr, 2
                  jmp     ReStart
            .endif

;---------- [Sample play] ----------
         .elseif wParam == 161
            .if !Sample
                  mov     Samp, 1
               INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
               INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
               INVOKE     CopyBitMap, hButt2, hButt2U, 0, 0, 38, 27
                  and     Stop, 0
                  mov     Mode4+16, 0
                  mov     Mode5+16, 0
                  and     LoopTrk, 0
            .else
                  and     Samp, 0
            .endif

;---------- [Select mode] ----------
         .elseif wParam == 162
            .if Mode1+16
                  lea     ecx, Mode2
            .elseif Mode2+16
                  lea     ecx, Mode3
            .elseif Mode3+16
                  lea     ecx, Mode1
            .endif
               mov     eax, [ecx+4]
               shl     eax, 16
               mov     ax, [ecx]
            INVOKE     SendMessage, hWnd, WM_LBUTTONDOWN, MK_LBUTTON, eax

;---------- [Iterate CD drives] ----------
         .elseif wParam == 63
               mov     eax, DriveCD
               inc     eax
            .if byte ptr DriveArray[eax] == 0
                  mov     eax, 0
            .endif
               mov     DriveCD, eax
               mov     bl, byte ptr DriveArray[eax]
               mov     szDrive, bl
               mov     DriveLetter, bl  ; Note
               mov     Drive+16, 5
               jmp     SetValues

ChkDriveCD:
              call     DrawDrive
               mov     eax, DriveCD
               cmp     eax, CurDriveCD
                je     Ret0
               mov     CurDriveCD, eax
            INVOKE     RegSetValueEx, hKey, addr szKey, 0, REG_BINARY, addr DriveCD, sizeof DriveCD
               and     Play, 0
               jmp     StopEM

;---------- [Set sound On/Off] ----------
         .elseif wParam == 164
            .if !Sound
                  mov     dword ptr szSoundOF+21, 'ffo '
            .else
                  mov     dword ptr szSoundOF+21, ' no '
            .endif
            INVOKE     mciSendString, addr szSoundOF, 0, 0, hWnd

;---------- [Select track] ----------
         .elseif wParam == 171    ; Track iterate
               mov     Shuttle, 171

         .elseif wParam == 10002  ; About
            INVOKE     MessageBox, NULL, addr szAbout, addr ClassName, MB_OK or MB_ICONINFORMATION or MB_SYSTEMMODAL

         .elseif wParam == 10003  ; Help
            INVOKE     WinHelp, hWnd, addr szHelp, HELP_CONTENTS, 0

         .elseif wParam == 60     ; Play List
            INVOKE     DialogBoxParam, hInst, addr dlgname, 0, addr PlayList, 0

         .endif

            jmp     Ret0

;---------- [Check for track loop or play list] ----------
ChkLoop:
         INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
            xor     eax, eax
            xor     ebx, ebx
            mov     al, byte ptr szBuff
            shl     eax, 8
            mov     al, byte ptr szBuff+1
            mov     bl, byte ptr szSavTrkNum
            shl     ebx, 8
            mov     bl, byte ptr szSavTrkNum+1
         .if eax > ebx
               cmp     LoopTrk, 1
                je     LoopEM
            .if Mode2+16               ; Play list
Reload:
                  mov     lpcbData, 160
               INVOKE     RegQueryValueEx, hReg, addr szPlayList, 0, addr szREGSZ, addr szName, addr lpcbData
               .if byte ptr szName == ';'
                     jmp     StopEM
               .endif
                     mov     ecx, Incr
               .if eax == ERROR_SUCCESS && byte ptr szName[ecx] != ';'
                     mov     eax, Incr
                  INVOKE     lstrcpyn, addr szSeekTo+16, addr szName[eax], 3
                     mov     eax, Incr
                  INVOKE     lstrcpyn, addr szSavTrkNum, addr szName[eax], 3
                     add     Incr, 2
                     jmp     ReStart
               .elseif byte ptr szName[ecx] == ';'
                  .if !Mode4+16
                        jmp     StopEM
                  .else
                        and     Incr, 0
                        jmp     Reload
                  .endif
               .endif
            .endif
            jmp     Ret0

LoopEM:
            INVOKE     mciSendString, addr szStop, 0, 0, hWnd
            INVOKE     mciSendString, addr szSeekTo, 0, 0, hWnd
            INVOKE     mciSendString, addr szPlay, 0, 0, hWnd
         .endif
            jmp     Ret0

;---------- [Set new random track] ----------
ChkRand:
         INVOKE     mciSendString, addr szPosition, addr szBuff, sizeof szBuff, hWnd
         INVOKE     lstrcpyn, addr szTrkNum, addr szBuff, 3
         INVOKE     AsciiBase, addr szTrkNum
         .if eax != SavTrkNum
               jmp     LoopR
         .endif
            jmp     Ret0

;~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ WM_LBUTTONDOWN
;---------- [H O T   S P O T S] ----------
      .elseif wMsg == WM_LBUTTONDOWN
            mov     eax, lParam
            mov     ebx, lParam
            and     eax, 0000ffffh
            shr     ebx, 16

;---------- [Sequentual Mode] ----------
         .if eax >= Mode1 && eax <= Mode1+8 && ebx >= Mode1+4 && ebx <= Mode1+12
               mov     wParam, 44
            INVOKE     CopyBitMap, hWnd, hMode1On, 501, 19, 21, 14
               mov     Mode1+16, 1 ; +16 = Button Down
            INVOKE     CopyBitMap, hWnd, hMode2, 528, 19, 21, 14
               mov     Mode2+16, 0
            INVOKE     CopyBitMap, hWnd, hMode3, 501, 39, 21, 14
               mov     Mode3+16, 0
            INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
               mov     Mode5+16, 0
            .if PM != 44 && PM != 45
                  mov     word ptr szSeekTo+16, '10'
                  jmp     ReStart
            .elseif PM ==45
                  and     PM, 0
                  jmp     ReStart
            .else
                  and     PM, 0
            .endif

;---------- [Play List Mode] ----------
         .elseif eax >= Mode2 && eax <= Mode2+8 && ebx >= Mode2+4 && ebx <= Mode2+12
               mov     wParam, 44
            INVOKE     CopyBitMap, hWnd, hMode2On, 528, 19, 21, 14
               mov     Mode2+16, 1
            INVOKE     CopyBitMap, hWnd, hMode1, 501, 19, 21, 14
               mov     Mode1+16, 0
            INVOKE     CopyBitMap, hWnd, hMode3, 501, 39, 21, 14
               mov     Mode3+16, 0
            INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
               mov     Mode5+16, 0
            and     Incr, 0
         INVOKE     SendMessage, hWnd, WM_COMMAND, 8810, 0

;---------- [Random Mode] ----------
         .elseif eax >= Mode3 && eax <= Mode3+8 && ebx >= Mode3+4 && ebx <= Mode3+12
               mov     wParam, 44
            INVOKE     CopyBitMap, hWnd, hMode3On, 501, 39, 21, 14
               mov     Mode3+16, 1
               and     LoopTrk, 0
            INVOKE     CopyBitMap, hWnd, hMode2, 528, 19, 21, 14
               mov     Mode2+16, 0
            INVOKE     CopyBitMap, hWnd, hMode1, 501, 19, 21, 14
               mov     Mode1+16, 0
            INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
               mov     Mode4+16, 0
            INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
               mov     Mode5+16, 0
         INVOKE     SendMessage, hWnd, WM_COMMAND, 8808, 0

;---------- [Loop CD] ----------
         .elseif eax >= Mode4 && eax <= Mode4+8 && ebx >= Mode4+4 && ebx <= Mode4+12
               mov     wParam, 44
               cmp     Mode3+16, 1
                je     NoLoop
            .if Mode4+16
               INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
                  mov     Mode4+16, 0
         INVOKE     SendMessage, hWnd, WM_COMMAND, 8804, 0
            .elseif !Samp
               INVOKE     CopyBitMap, hWnd, hMode4On, 528, 39, 21, 14
                  mov     Mode4+16, 1
               INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
                  mov     Mode5+16, 0
                  and     LoopTrk, 0
         INVOKE     SendMessage, hWnd, WM_COMMAND, 8805, 0
            .endif
NoLoop:

;---------- [Loop Track] ----------
         .elseif eax >= Mode5 && eax <= Mode5+8 && ebx >= Mode5+4 && ebx <= Mode5+12
               mov     wParam, 44
            .if Mode5+16
               INVOKE     CopyBitMap, hWnd, hMode5, 460, 39, 35, 14
                  mov     Mode5+16, 0
                  and     LoopTrk, 0
               INVOKE     SendMessage, hWnd, WM_COMMAND, 8806, 0  ; Stop track loop
            .elseif !Samp
               INVOKE     CopyBitMap, hWnd, hMode5On, 460, 39, 35, 14
                  mov     Mode5+16, 1
               INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
                  mov     Mode4+16, 0
               INVOKE     SendMessage, hWnd, WM_COMMAND, 8807, 0  ; Start track loop
            .endif

;---------- [Select CD Drive] ----------
         .elseif eax >= Drive && eax <= Drive+8 && ebx >= Drive+4 && ebx <= Drive+12
               mov     wParam, 44
               mov     Drive+16, 0
               jmp     ChkDriveCD

;---------- [Select Track] ----------
         .elseif eax >= Track && eax <= Track+8 && ebx >= Track+4 && ebx <= Track+12
               mov     wParam, 44
            .if TrackOn
                  mov     TrackOn, 5
               INVOKE     BaseAscii, TrkSel, addr szTrkNum, 0
               INVOKE     lstrcpyn, addr szSeekTo+16, addr szTrkNum, 3

                  mov     PM, 45
                  mov     eax, dword ptr Mode1+4
                  shl     eax, 16
                  mov     ax, word ptr Mode1
               INVOKE     SendMessage, hWnd, WM_LBUTTONDOWN, MK_LBUTTON, eax

                  jmp     ReStart
            .endif

;---------- [Exit] ----------
         .elseif eax >= Exit1 && eax <= Exit1+8 && ebx >= Exit1+4 && ebx <= Exit1+12
               jmp     EndIt

;---------- [Info & Help] ----------
         .elseif eax >= Info && eax <= Info+8 && ebx >= Info+4 && ebx <= Info+12
               mov     wParam, 44
            INVOKE     GetWindowRect,hWnd,ADDR rect
               mov     eax, lParam        ;x/y pos of window
               mov     ebx, eax
               and     ebx, 0000ffffh     ;ebx = LOWORD(lparam) = x pos
               shr     eax, 16            ;eax = HIWORD(lparam) = y pos
               add     ebx, rect.left
               add     eax, rect.top
            INVOKE     TrackPopupMenu, hSMenu, TPM_LEFTALIGN or TPM_LEFTBUTTON, ebx, eax, 0, hWnd, ADDR rect
         .endif

;---------- [N O N   H O T   S P O T S] ----------
         .if wParam != 44
               mov     KeyDown, 1
            INVOKE     LoadCursor, hInst, 4003
            INVOKE     SetCursor, eax
            INVOKE     PostMessage, hwnd, WM_NCLBUTTONDOWN, HTCAPTION, 0 ; Post to drag window in the client area
         .endif

      .elseif wMsg == WM_LBUTTONUP
            and     KeyDown, 0
         INVOKE     LoadCursor, 0, IDC_ARROW ;, hInst, 4002
         INVOKE     SetCursor, eax

      .elseif wMsg == WM_MOUSEMOVE
;         .if KeyDown
;            INVOKE     LoadCursor, hInst, 4002
;            INVOKE     SetCursor, eax
;         .endif

      .elseif wMsg == WM_DESTROY
EndIt:
         INVOKE     DeleteDC, hMemDC     ; Delete the memory dc
         INVOKE     ReleaseDC, hwnd, hDC ; Release the window dc

            mov     Cnt, 48 ;50 ;46 ;45 ;44 ;42 ;40 ;30 ;24 ;14 ;21
            lea     ebx, hBitMap
         .while (Cnt)
              push     ebx
            INVOKE     DeleteObject, dword ptr[ebx] ; Delete the bitmap/region handles
               pop     ebx
               add     ebx, 4
               dec     Cnt
         .endw 

         INVOKE     KillTimer, hwnd, 44
         INVOKE     mciSendString, addr szStop, 0, 0, 0
         INVOKE     mciSendString, addr szClose, 0, 0, 0
         INVOKE     mixerClose, addr hMixer
         INVOKE     RegSetValueEx, hKey, addr szKey, 0, REG_BINARY, addr DefaultCD, sizeof DefaultCD
         INVOKE     RegCloseKey, hKey
         INVOKE     RegCloseKey, hReg
         INVOKE     WinHelp, hwnd, addr szHelp, HELP_QUIT, 0
         INVOKE     PostQuitMessage, 0

      .else
NoSetSnd:
DefWndProc:
         INVOKE     DefWindowProc, hwnd, wMsg, wParam, lParam
            ret
      .endif
         jmp     Ret0

GetOut:
      INVOKE     DestroyWindow, hwnd

Ret0:
         xor eax, eax
         ret
WndProc endp

;=============================================================================
; Creates the Control Buttons
;=============================================================================
CreateWindowButt PROC uses ebx EXStyle, style, xPos, yPos, wh, ht, hwnd, ID, hButt

      INVOKE     CreateWindowEx, EXStyle, addr ButtClass, 0, style,
                 xPos, yPos, wh, ht, hwnd, ID, hInst, NULL
         mov     ebx, hButt
         mov     dword ptr[ebx], eax
      INVOKE     SetWindowLong, dword ptr[ebx], GWL_WNDPROC, ControlButt
         mov     SubButt, eax
         ret
CreateWindowButt endp

;=============================================================================
; Creates the Sliders
;=============================================================================
CreateSliders PROC uses ebx xPos, hwnd, ID, hSlide

      INVOKE     CreateWindowEx, 0, addr ButtClass, 0,
                 WS_CHILD or WS_VISIBLE or BS_OWNERDRAW,
                 xPos, 38, 10, 11, hwnd, ID, hInst, 0
         mov     ebx, hSlide
         mov     dword ptr[ebx], eax
      INVOKE     SetWindowLong, dword ptr[ebx], GWL_WNDPROC, SliderCtl
         mov     SubSlider, eax
         ret
CreateSliders endp

;=============================================================================
; Enumerate the Control Buttons
;=============================================================================
EnumChild proc uses edi hChild:DWORD,lParam:DWORD

         inc     Cnt
         mov     edi, lParam
      assume     edi:ptr TOOLINFO
       MOVmd     [edi].uId, hChild
          or     [edi].uFlags, TTF_IDISHWND
      INVOKE     GetWindowText, hChild, addr szBuff, sizeof szBuff
       MOVmd     [edi].hInst, hInst
       MOVmd     [edi].lpszText, Cnt
      INVOKE     SendMessage, hToolTip, TTM_ADDTOOL, 0, edi
      assume     edi:nothing
      ret
EnumChild endp

;=============================================================================
; Draw drive image
;=============================================================================
DrawDrive proc 
LOCAL     hBR:DWORD

      INVOKE     GetDC, hWnd
         mov     hDC, eax
      .if Drive+16
         INVOKE     CreateSolidBrush, 000000ffh
      .else
         INVOKE     CreateSolidBrush, 0000007fh
      .endif
         mov     hBR, eax
      INVOKE     CreateRect, addr Drive, addr rect
      INVOKE     FrameRect, hDC, addr rect, hBR
      INVOKE     SelectObject, hDC, hFontA       ; Select the font into the dc
      .if Drive+16
         INVOKE     SetTextColor, hDC, 00ffff00h ; Set the text color
      .else
         INVOKE     SetTextColor, hDC, 007f7f00h ; Set the text color
      .endif
      INVOKE     SetBkColor, hDC, 00000000h      ; Set the text background color
      INVOKE     DrawText, hDC, addr szDrive, -1, addr rect, DT_CENTER or DT_VCENTER or DT_SINGLELINE
;      INVOKE     SetTextColor, hDC, 00ffff00h ; Set the text color
      INVOKE     DeleteObject, hBR               ; Delete the brush handle
      INVOKE     ReleaseDC, hWnd, hDC            ; Release the control dc
      ret
DrawDrive endp

;=============================================================================
; Creates the Control Buttons
;=============================================================================
GetSliderValue PROC uses edx

            xor     edx, edx
            mov     eax, VolValue
            mov     ebx, 1310
            div     ebx
            mov     ebx, 48
            sub     ebx, eax
         .if ebx < 49
               add     ebx, 12
         .else
               mov     ebx, 60
         .endif
         ret
GetSliderValue endp

;=============================================================================
; Create a standard rectangle from the HotSpot array
;=============================================================================
CreateRect  proc  uses esi edi  Butt:DWORD, Rect
         mov     ecx, 4
         xor     eax, eax
         mov     esi, Butt
         mov     edi, Rect

Loop1:
        push     dword ptr[esi+eax]
         pop     dword ptr[edi+eax]
         add     eax, 4
        loop     Loop1

         ret
CreateRect  endp

;=============================================================================
; Load the bitmaps
;=============================================================================
LoadBmp  proc  uses ebx  InPut:DWORD, OutPut, Num, bWh, bHt
LOCAL     wF:DWORD, wT

          MOVmd     wF, InPut          ; From addr
            mov     ebx, OutPut
            mov     wT, ebx            ; To addr
          MOVmd     Cnt, Num
         .while (Cnt)
            INVOKE     LoadImage, hInst, wF, IMAGE_BITMAP, bWh, bHt, LR_DEFAULTCOLOR
               mov     ebx, wT
               mov     [ebx], eax
               inc     wF
               dec     Cnt
               add     wT, 4
         .endw
         ret
LoadBmp  endp

;=============================================================================
; Display the track time
;=============================================================================
DisplayTime  proc  uses ebx  Incre:DWORD, xPos
         xor     eax, eax
         mov     ebx, Incre
         mov     al, byte ptr szBuff[ebx]
         sub     eax, 30h
        imul     eax, 4
         lea     ebx, hN0
      INVOKE     CopyBitMap, hWnd, dword ptr[ebx+eax], xPos, 20, 20, 21
         ret
DisplayTime  endp

;========================================================================
; Converts an ascii string to a 32 bit num value.
;========================================================================
AsciiBase proc uses edx edi esi InPut:DWORD

         xor     eax, eax
         mov     esi, InPut
         xor     ecx, ecx
         xor     edx, edx
         mov     al, [esi]
         inc     esi
      .while al != 0
            sub     al, '0'          ; Convert to bcd
            lea     ecx, [ecx+ecx*4] ; ecx = ecx * 5
            lea     ecx, [eax+ecx*2] ; ecx = eax + old ecx * 10
            mov     al, [esi]
            inc     esi
      .endw

         lea     eax, [ecx]          ; Move to eax and negate
         ret

AsciiBase endp

;=========================================================================
;  Converts a 32 bit num value to a  ascii string.
;=========================================================================
BaseAscii proc uses edx esi edi InPut:DWORD, OutPut, Fill

         mov     eax, InPut
         mov     edi, OutPut
      .if eax < 10 && Fill
            mov     byte ptr [edi], '0'
            inc     edi
      .endif
         mov     esi, edi
         mov     ecx, 10
      .while (eax > 0)
            xor     edx, edx
            div     ecx              ; Put next digit in edx
            add     dl, '0'          ; Convert to ASCII
            mov     [edi], dl        ; Store it
            inc     edi
      .endw
         mov     byte ptr [edi], 0   ; Terminate the string
      .while (esi < edi)
            dec     edi
            mov     al, [esi]
            mov     ah, [edi]
            mov     [edi], al
            mov     [esi], ah
            inc     esi
      .endw
         ret

BaseAscii endp

;=============================================================================
; Copies an image to the face of a Button
;=============================================================================
CopyBitMap  PROC hButt:DWORD, hBmp, xPos, yPos, bWh, bHt

      INVOKE     GetDC, hButt               ; Get the dc of the button
         mov     hDC, eax
      INVOKE     CreateCompatibleDC, hDC    ; Create a compatible dc in memory
         mov     hMemDC, eax
      INVOKE     SelectObject, hMemDC, hBmp ; Select the opened bitmap into the dc
      .if yPos == 1
            dec     bHt
      .endif
      INVOKE     BitBlt, hDC, xPos, yPos, bWh, bHt, hMemDC, 0, 0, SRCCOPY ; Copy the bitmap
      INVOKE     DeleteDC, hMemDC           ; Delete the memory dc
      INVOKE     ReleaseDC, hButt, hDC      ; Release the control dc

         xor    eax, eax
         ret
CopyBitMap  endp

;=============================================================================
; Subclass procedure for the Volume Controls
;=============================================================================
SliderCtl  proc  uses ebx  hwnd:DWORD, wMsg, wParam, lParam
LOCAL     pt:POINT

      INVOKE     CallWindowProc, SubSlider, hwnd, wMsg, wParam, lParam

      .if wMsg == WM_PAINT
         INVOKE     CopyBitMap, hwnd, hVol, 0, 0, 10, 11
      .endif

      .if wMsg == WM_LBUTTONDOWN
         INVOKE     GetCursorPos, addr pt
         INVOKE     ScreenToClient, hWnd, addr pt
          MOVmd     PosY, pt.y
            mov     sKeyDown, 1      ; Stop main window paint
         INVOKE     SetCapture, hwnd

      .elseif wMsg == WM_LBUTTONUP
            and     sKeyDown, 0
         INVOKE     ReleaseCapture

      .elseif wMsg == WM_MOUSEMOVE
         .if sKeyDown
            INVOKE     GetCursorPos, addr pt
            INVOKE     ScreenToClient, hWnd, addr pt
             MOVmd     rect.top, pt.y
               sub     rect.top, 5
               mov     eax, hwnd
            .if eax == hVolM
                  mov     rect.left, 46
            .elseif eax == hVolL
                  mov     rect.left, 68
            .elseif eax == hVolR
                  mov     rect.left, 90
            .endif
            .if rect.top < 12 || rect.top > 00007fffh
                  jmp     Ret1
            .elseif rect.top > 60
                  jmp     Ret1
            .endif
            INVOKE     MoveWindow, hwnd, rect.left, rect.top, 10, 11, 1

;---------- [Set the volume value] ----------
            cmp     hMixer, 0
             je     Ret1
            mov     ebx, rect.top
         .if ebx > 11
            sub     ebx, 12
         .else
            mov     ebx, 0
         .endif
            mov     eax, 48
            sub     eax, ebx
           imul     eax, 1310
            mov     VolValue, eax
            mov     eax, hwnd
         .if eax == hVolM
             MOVmd     mxcdVol[0].dwValue, VolValue
         .elseif eax == hVolL
             MOVmd     mxcdVol[0].dwValue, VolValue
         .elseif eax == hVolR
            .if NumChannels > 1
                MOVmd     mxcdVol[4].dwValue, VolValue
            .endif
         .endif
            mov     mxcd.cbStruct, sizeof mxcd
         .if eax == hVolM
             MOVmd     mxcd.dwControlID, VolCtlIDM
               mov     mxcd.cChannels, 1
         .else
             MOVmd     mxcd.dwControlID, VolCtlID
             MOVmd     mxcd.cChannels, NumChannels
         .endif
            mov     mxcd.cMultipleItems, 0
            mov     mxcd.cbDetails, sizeof mxcdVol
            mov     mxcd.paDetails, offset mxcdVol
         INVOKE     mixerSetControlDetails, hMixer, addr mxcd, MIXER_OBJECTF_HMIXER or MIXER_GETCONTROLDETAILSF_VALUE
        .endif
     .endif

Ret1:
         mov     eax, TRUE
         ret

Ret0:
         mov     eax, FALSE
         ret
SliderCtl  ENDP

;=============================================================================
; Subclass procedure for the Control Buttons
;=============================================================================
ControlButt  PROC  uses ebx edx  hwnd:DWORD, wMsg, wParam, lParam
LOCAL     UpDown:DWORD, xPos, yPos, hBR

      INVOKE     CallWindowProc, SubButt, hwnd, wMsg, wParam, lParam

         and     UpDown , 0
      .if wMsg == WM_PAINT
            mov     FromButt, 1

PaintEM:
            mov     eax, hwnd
            mov     Cnt, 10
            lea     ebx, hButt1
            lea     edx, hButt1U
         .while (Cnt)
            .if eax == dword ptr[ebx]
               INVOKE     CopyBitMap, hwnd, dword ptr[edx], 0, UpDown, 38, 27
               .break
            .endif
               add     ebx, 4
               add     edx, 4
               dec     Cnt
         .endw

            mov     eax, hwnd
            mov     Cnt, 3
            lea     ebx, hButt11
            lea     edx, hButt11U
         .while (Cnt)
            .if eax == dword ptr[ebx]
               INVOKE     CopyBitMap, hwnd, dword ptr[edx], 0, UpDown, 28, 17
               .break
            .endif
               add     ebx, 4
               add     edx, 4
               dec     Cnt
         .endw

            mov     eax, hwnd
         .if eax == hButt14
            INVOKE     CopyBitMap, hButt14, hButtSndOn, 0, UpDown, 12, 12
         .endif

         .if Stop && StopFlg != 44
            INVOKE     CopyBitMap, hButt2, hButtStop, 0, 0, 38, 27
         .elseif Play && PlayFlg != 44
            INVOKE     CopyBitMap, hButt3, hButtPlay, 0, 0, 38, 27
         .endif
         .if Pause && PauseFlg != 44
            INVOKE     CopyBitMap, hButt4, hButtPause, 0, 0, 38, 27
         .endif
         .if Sound && SoundFlg != 44
            INVOKE     CopyBitMap, hButt14, hButtSndOff, 0, 0, 12, 12
         .endif

         .if !Play
            INVOKE     CopyBitMap, hWnd, hStat1, 373, 21, 15, 10
         .else
            INVOKE     CopyBitMap, hWnd, hStat1On, 373, 21, 15, 10
         .endif
         .if !Pause
            INVOKE     CopyBitMap, hWnd, hStat2, 388, 21, 15, 10
         .else
            INVOKE     CopyBitMap, hWnd, hStat2On, 388, 21, 15, 10
         .endif
         .if !Sample
            INVOKE     CopyBitMap, hWnd, hStat3, 403, 21, 15, 10
         .else
            INVOKE     CopyBitMap, hWnd, hStat3On, 403, 21, 15, 10
         .endif
            and     UpDown, 0

      .elseif wMsg == WM_RBUTTONDOWN
            mov     eax, hwnd
         .if eax == hButt8 || eax == hButt9           ; Track iterate
            INVOKE     GetDC, hWnd
               mov     hDC, eax
            INVOKE     CreateSolidBrush, 000000ffh
               mov     hBR, eax
            INVOKE     CreateRect, addr Track, addr rect
            INVOKE     FrameRect, hDC, addr rect, hBR
            INVOKE     DeleteObject, hBR              ; Delete the brush handle
            INVOKE     ReleaseDC, hWnd, hDC           ; Release the control dc
               and     TrackOn, 0
               mov     eax, hwnd
            .if eax == hButt8
                  and     PM, 0
               INVOKE     SetTimer, hWnd, 44, 200, 0
               INVOKE     CopyBitMap, hButt8, hButt8U, 0, 1, 38, 27
               INVOKE     SendMessage, hWnd, WM_COMMAND, 171, 0
            .elseif eax == hButt9
                  mov     PM, 1
               INVOKE     SetTimer, hWnd, 44, 200, 0
               INVOKE     CopyBitMap, hButt9, hButt9U, 0, 1, 38, 27
               INVOKE     SendMessage, hWnd, WM_COMMAND, 171, 0
            .endif
         .endif

      .elseif wMsg == WM_RBUTTONUP
            mov     eax, hwnd
         .if eax == hButt8
               mov     TrackOn, 1
               and     Shuttle, 0
            INVOKE     SetTimer, hWnd, 44, 1000, 0
            INVOKE     CopyBitMap, hButt8, hButt8U, 0, 0, 38, 27
         .elseif eax == hButt9
               mov     TrackOn, 1
               and     Shuttle, 0
            INVOKE     SetTimer, hWnd, 44, 1000, 0
            INVOKE     CopyBitMap, hButt9, hButt9U, 0, 0, 38, 27
         .endif

      .elseif wMsg == WM_MOUSEMOVE
         INVOKE     GetClientRect, hwnd, addr rect
          MOVmd     bArray, rect.left
          MOVmd     bArray+4, rect.top
          MOVmd     bArray+8, rect.right
          MOVmd     bArray+12, rect.bottom
            mov     eax, lParam
            mov     xPos, eax
            mov     yPos, eax
            and     xPos, 0000ffffh
            shr     yPos, 16
            mov     eax, hwnd

            mov     ebx, xPos
            mov     ecx, yPos
         .if ebx >= bArray && ebx <= bArray+8 && ecx >= bArray+4 && ecx <= bArray+12
            .if wParam == MK_LBUTTON
                  mov     UpDown, 1
                  and     NoSet, 0
               .if eax == hButt2
                     mov     StopFlg, 44
               .endif
               .if eax == hButt3
                     mov     PlayFlg, 44
               .endif
               .if eax == hButt4
                     mov     PauseFlg, 44
               .endif
               .if eax == hButt11
                     mov     SampleFlg, 44
               .endif
               .if eax == hButt14
                     mov     SoundFlg, 44
               .endif

            .else
                  mov     UpDown, 0
            .endif
         .else
               and     StopFlg, 0
               and     PlayFlg, 0
               and     PauseFlg, 0
               and     SampleFlg, 0
               and     SoundFlg, 0
               mov     NoSet, 1
         .endif
            jmp     PaintEM

      .elseif wMsg == WM_LBUTTONDOWN || wMsg == WM_LBUTTONDBLCLK
            mov     eax, hwnd
            mov     UpDown, 1
            and     NoSet, 0

         .if eax == hButt1
            INVOKE     SetTimer, hWnd, 44, 50, 0
               mov     Shuttle, 151
;            .if Mode4+16
;               INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
;                  mov     Mode4+16, 0
;            .endif
            INVOKE     SendMessage, hWnd, WM_COMMAND, 151, 0
         .endif
         .if eax == hButt2
               mov     StopFlg, 44
         .endif
         .if eax == hButt3
               mov     PlayFlg, 44
         .endif
         .if eax == hButt4
               mov     PauseFlg, 44
         .endif
         .if eax == hButt11
               mov     SampleFlg, 44
            INVOKE     SendMessage, hWnd, WM_COMMAND, 161, 0
         .endif
         .if eax == hButt14
               mov     SoundFlg, 44
            INVOKE     SendMessage, hWnd, WM_COMMAND, 164, 0
         .endif

         .if eax == hButt5
            INVOKE     SetTimer, hWnd, 44, 50, 0
               mov     Shuttle, 155
;            .if Mode4+16
;               INVOKE     CopyBitMap, hWnd, hMode4, 528, 39, 21, 14
;                  mov     Mode4+16, 0
;            .endif
            INVOKE     SendMessage, hWnd, WM_COMMAND, 155, 0
         .endif

         .if eax == hButt12
            INVOKE     SendMessage, hWnd, WM_COMMAND, 162, 0
         .endif

            jmp     PaintEM

      .elseif wMsg == WM_LBUTTONUP
            and     StopFlg, 0
            and     PlayFlg, 0
            and     PauseFlg, 0
            and     SoundFlg, 0
            mov     eax, hwnd
         .if eax == hButt1 || eax == hButt5
               and     Shuttle, 0
            INVOKE     SetTimer, hWnd, 44, 1000, 0
         .endif

         .if eax == hButt2 && Stop == 0 && !NoSet
               mov     Stop, 1
            INVOKE     CopyBitMap, hwnd, hButtStop, 0, 0, 38, 27
               and     Play, 0
            INVOKE     CopyBitMap, hButt3, hButt3U, 0, 0, 38, 27
            INVOKE     CopyBitMap, hWnd, hStat1, 373, 21, 15, 10
               and     Pause, 0
            INVOKE     CopyBitMap, hButt4, hButt4U, 0, 0, 38, 27
            INVOKE     CopyBitMap, hWnd, hStat2, 388, 21, 15, 10
         .elseif eax == hButt2 && !NoSet
               and     Stop, 0

         .elseif eax == hButt3 && Play == 0 && !NoSet ||\
                 eax == hButt3 && Play == 1 && Pause == 1 && !NoSet
               mov     Play, 1
            INVOKE     CopyBitMap, hwnd, hButtPlay, 0, 0, 38, 27
            INVOKE     CopyBitMap, hWnd, hStat1On, 373, 21, 15, 10
               and     Stop, 0
            INVOKE     CopyBitMap, hButt2, hButt2U, 0, 0, 38, 27
               and     Pause, 0
            INVOKE     CopyBitMap, hButt4, hButt4U, 0, 0, 38, 27
            INVOKE     CopyBitMap, hWnd, hStat2, 388, 21, 15, 10
         .elseif eax == hButt3 && !NoSet
            INVOKE     CopyBitMap, hWnd, hStat1, 373, 21, 15, 10
               and     Play, 0

         .elseif eax == hButt4 && Pause == 0 && !NoSet
               mov     Pause, 1
            INVOKE     CopyBitMap, hwnd, hButtPause, 0, 0, 38, 27
            INVOKE     CopyBitMap, hWnd, hStat2On, 388, 21, 15, 10
               and     Stop, 0
            INVOKE     CopyBitMap, hButt2, hButt2U, 0, 0, 38, 27
         .elseif eax == hButt4 && !NoSet
            INVOKE     CopyBitMap, hWnd, hStat2, 388, 21, 15, 10
               and     Pause, 0

         .elseif eax == hButt11 && Sample == 0 && !NoSet
               mov     Sample, 1
         .elseif eax == hButt11 && !NoSet
               and     Sample, 0

         .elseif eax == hButt14 && Sound == 0 && !NoSet
               mov     Sound, 1
            INVOKE     CopyBitMap, hwnd, hButtSndOff, 0, 0, 12, 12
         .elseif eax == hButt14 && !NoSet
               and     Sound, 0

         .else
            .if eax != hButt2 && eax != hButt10 && !NoSet
                  and     Stop, 0
               INVOKE     CopyBitMap, hButt2, hButt2U, 0, 0, 38, 27
            .endif
               jmp     PaintEM
         .endif
      .endif

Ret1:
         mov     eax, TRUE
         ret

Ret0:
         mov     eax, FALSE
         ret
ControlButt  ENDP

;=============================================================================
; PlayList dialog
;=============================================================================
PlayList proc   hwnd:DWORD, wMsg, wParam, lParam
LOCAL     lpdwDisp:DWORD, lpcbData, ItemCnt, Num
LOCAL     szName[160]:BYTE

      .if wMsg == WM_INITDIALOG
          MOVmd     hDlg, hwnd

         INVOKE     GetVolumeInformation, addr DriveLetter, addr szVol, sizeof szVol,\
                    addr SerialNum, 0, 0, 0, 0
         .if word ptr szVol+6 != 'DC'
               ; No Audio CD msg and exit
         .endif
         INVOKE     BaseAscii, SerialNum, addr szWork, 0
            mov     word ptr szBuff, 'DC'
         INVOKE     lstrcpy, addr szBuff+2, addr szWork  ; Serial num

         INVOKE     lstrcpy, addr szName, addr szSubKeyCD
         INVOKE     lstrcat, addr szName, addr szBuff

         INVOKE     RegCreateKeyEx, HKEY_CURRENT_USER, addr szName, 0, addr szREGSZ, 0,\
                    KEY_WRITE or KEY_READ, 0, addr hRegD, addr lpdwDisp
         .if lpdwDisp == REG_OPENED_EXISTING_KEY
               jmp     NotNew
         .endif

;--------------- [Add the initial values to the registry] --------------- 
            mov     lpcbData, 8
         INVOKE     RegSetValueEx, hRegD, addr szCDName, 0, REG_SZ, addr szUntitled, lpcbData

          MOVmd     Num, TotTrks
            mov     ItemCnt, 01
         .while (Num)
            INVOKE     BaseAscii, ItemCnt, addr szIndex, 1
            INVOKE     lstrcpy, addr szBuff, addr szUntitled
            INVOKE     lstrcat, addr szBuff, addr szIndex
            INVOKE     lstrlen, addr szBuff
               mov     lpcbData, eax
            INVOKE     RegSetValueEx, hRegD, addr szTrk, 0, REG_SZ, addr szBuff, lpcbData
               inc     ItemCnt
               dec     Num
         .endw
            mov     word ptr szName, 003bh
            mov     lpcbData, 3
         INVOKE     RegSetValueEx, hRegD, addr szPlayList, 0, REG_SZ, addr szName, lpcbData

NotNew:
         INVOKE     LoadIcon, hInst, 4000
         INVOKE     SendMessage, hwnd, WM_SETICON, 1, eax

            mov     Cnt, 9
            mov     Num, 100
            lea     eax, hStat
            mov     ItemCnt, eax
         .while (Cnt)
            INVOKE     GetDlgItem, hwnd, Num
               mov     ecx, ItemCnt
               mov     [ecx], eax
               dec     Cnt
               inc     Num
               add     ItemCnt, 4
         .endw

         INVOKE     LoadBmp, 9007, addr hDlgButt1, 2, 40, 20
         INVOKE     SendMessage, hButtD, BM_SETIMAGE, IMAGE_BITMAP, hDlgButt1
         INVOKE     SendMessage, hButtD+4, BM_SETIMAGE, IMAGE_BITMAP, hDlgButt2

         INVOKE     mciSendString, addr szTotLen, addr szBuff, sizeof szBuff, hWnd
         INVOKE     lstrcpyn, addr szWork, addr szBuff, 6

         INVOKE     SetDlgItemText, hwnd, 101, addr szTrkTot
         INVOKE     SetDlgItemText, hwnd, 102, addr szWork

            mov     lpcbData, 160
         INVOKE     RegQueryValueEx, hRegD, addr szCDName, 0, addr szREGSZ, addr szName, addr lpcbData
            mov     szBuff, ' '
         INVOKE     lstrcpy, addr szBuff+1, addr szName
         INVOKE     SetDlgItemText, hwnd, 100, addr szBuff
            mov     lpcbData, 160
         INVOKE     RegQueryValueEx, hRegD, addr szPlayList, 0, addr szREGSZ, addr szName, addr lpcbData

          MOVmd     Num, TotTrks
            mov     ItemCnt, 1
            mov     Cnt, 0
         .while (Num)
            INVOKE     BaseAscii, ItemCnt, addr szIndex, 1
               mov     lpcbData, 50
            INVOKE     RegQueryValueEx, hRegD, addr szTrk, 0, addr szREGSZ, addr szBuff, addr lpcbData
            INVOKE     SendMessage, hListL, LB_ADDSTRING, 0, addr szBuff
               mov     eax, Cnt
            .if byte ptr szName[eax] != ';'
               INVOKE     lstrcpyn, addr szWork, addr szName[eax], 3
               INVOKE     lstrcmpi, addr szWork, addr szIndex
               .if !eax
                  INVOKE     lstrcpy, addr szWork, addr szIndex
                  INVOKE     lstrcat, addr szWork, addr szSpace
                  INVOKE     lstrcat, addr szWork, addr szBuff
                  INVOKE     SendMessage, hListR, LB_ADDSTRING, 0, addr szWork
                     add     Cnt, 2
               .endif
            .endif
               inc     ItemCnt
               dec     Num
         .endw
         INVOKE     SetFocus, hStat
            jmp     CountEM

      .elseif wMsg == WM_CTLCOLORSTATIC
            mov     eax, lParam
         .if eax == hStat || eax == hStat+4 || eax == hStat+8 || eax == hStat+12 || eax == hStat+16
            INVOKE     SetBkColor, wParam, 00000000h       ; Background color is black
            INVOKE     SetTextColor, wParam, 00ffff00h     ; Text color of edit box is lt blue
            INVOKE     GetStockObject, BLACK_BRUSH         ; Select the black brush for background
               ret
         .endif 

      .elseif wMsg == WM_COMMAND
         .if wParam == 401      ; Name CD
            INVOKE     GetDlgItemText, hwnd, 100, addr szBuff, sizeof szBuff
            INVOKE     lstrcpy, addr szBuff, addr szBuff+1
            INVOKE     DialogBoxParam, hInst, 4401, 0, addr CDName, 0
               mov     szName, ' '
            INVOKE     lstrcpy, addr szName+1, addr szBuff
            INVOKE     SetDlgItemText, hwnd, 100, addr szName
            INVOKE     SetFocus, hStat

         .elseif wParam == 402  ; Name Track
            INVOKE     SendMessage, hListL, LB_GETSELITEMS, TotTrks, addr szName
            .if eax
               INVOKE     SendMessage, hListL, LB_GETTEXT, dword ptr szName, addr szBuff
               INVOKE     DialogBoxParam, hInst, 4402, 0, addr TrkName, 0
               INVOKE     SendMessage, hListL, LB_DELETESTRING, dword ptr szName, 0
               INVOKE     SendMessage, hListL, LB_INSERTSTRING, dword ptr szName, addr szBuff
            .endif

         .elseif wParam == 105  ; Copy S/M
            INVOKE     SendMessage, hListL, LB_GETSELITEMS, TotTrks, addr szName
               mov     Num, eax
               and     Cnt, 0
            .while (Num)
                  mov     ecx, Cnt
               INVOKE     SendMessage, hListL, LB_GETTEXT, dword ptr szName[ecx], addr szBuff
                  mov     ecx, Cnt
                  mov     eax, dword ptr szName[ecx]
                  inc     eax
               INVOKE     BaseAscii, eax, addr szIndex, 1
               INVOKE     lstrcpy, addr szWork, addr szIndex
               INVOKE     lstrcat, addr szWork, addr szSpace
               INVOKE     lstrcat, addr szWork, addr szBuff
               INVOKE     SendMessage, hListR, LB_SELECTSTRING, 0, addr szWork
               .if eax != LB_ERR
                  INVOKE     SendMessage, hListR, LB_DELETESTRING, eax, 0
               .endif
               INVOKE     SendMessage, hListR, LB_ADDSTRING, 0, addr szWork
                  add     Cnt, 4
                  dec     Num
            .endw
            INVOKE     SendMessage, hListL, LB_SETSEL, 0, -1
               jmp     CountEM

         .elseif wParam == 106  ; Cut S/M
            INVOKE     SendMessage, hListR, LB_GETSELITEMS, TotTrks, addr szName
               mov     Num, eax
            .while (Num)
               INVOKE     SendMessage, hListR, LB_DELETESTRING, dword ptr szName, 0
               INVOKE     SendMessage, hListR, LB_GETSELITEMS, TotTrks, addr szName
                  mov     Num, eax
            .endw
CountEM:
            INVOKE     SendMessage, hListR, LB_GETCOUNT, 0, 0
            INVOKE     BaseAscii, eax, addr szBuff, 0
            INVOKE     SetDlgItemText, hwnd, 103, addr szBuff

         .elseif wParam == 407  ; Update
            INVOKE     SendMessage, hListR, LB_GETCOUNT, 0, 0
               mov     Num, eax
               and     Cnt, 0
            .while (Num)
               INVOKE     SendMessage, hListR, LB_GETTEXT, Cnt, addr szBuff
               INVOKE     lstrcpyn, addr szWork, addr szBuff, 3
               .if !Cnt
                  INVOKE     lstrcpy, addr szName, addr szWork
               .else
                  INVOKE     lstrcat, addr szName, addr szWork
               .endif
                  dec     Num
                  inc     Cnt
            .endw
               mov     eax, Cnt
              imul     eax, 2
               mov     byte ptr szName[eax], ';'
               inc     eax
               mov     byte ptr szName[eax], 0
            INVOKE     GetDlgItemText, hwnd, 100, addr szBuff, sizeof szBuff
            INVOKE     lstrcpy, addr szBuff, addr szBuff+1
               mov     lpcbData, 50
            INVOKE     RegSetValueEx, hRegD, addr szCDName, 0, REG_SZ, addr szBuff, lpcbData
               mov     lpcbData, 160
            INVOKE     RegSetValueEx, hRegD, addr szPlayList, 0, REG_SZ, addr szName, lpcbData
            INVOKE     SendMessage, hListL, LB_GETCOUNT, 0, 0
               mov     Num, eax
               and     Cnt, 0
               mov     ItemCnt, 1
            .while (Num)
               INVOKE     SendMessage, hListL, LB_GETTEXT, Cnt, addr szBuff
               INVOKE     BaseAscii, ItemCnt, addr szIndex, 1
                  mov     lpcbData, 50
               INVOKE     RegSetValueEx, hRegD, addr szTrk, 0, REG_SZ, addr szBuff, lpcbData
                  dec     Num
                  inc     Cnt
                  inc     ItemCnt
            .endw
               jmp     Endit

         .elseif wParam == 408  ; Cancel
               jmp     Endit

         .elseif wParam == 409  ; Help

         .endif

      .elseif wMsg == WM_CLOSE
Endit:
         INVOKE     DeleteObject, hDlgButt1
         INVOKE     DeleteObject, hDlgButt2
            and     hDlg, 0
         INVOKE     RegCloseKey, hRegD
         INVOKE     EndDialog, hwnd, 0
      .endif

Ret0:
         xor     eax, eax
         ret

PlayList endp

;=============================================================================
; CD Name Edit dialog
;=============================================================================
CDName proc   hwnd:DWORD, wMsg, wParam, lParam

      .if wMsg == WM_INITDIALOG
         INVOKE     SetDlgItemText, hwnd, 503, addr szBuff
         INVOKE     GetDlgItem, hwnd, 503
           push     eax
         INVOKE     SendMessage, eax, EM_SETSEL, 0, -1
            pop     eax
         INVOKE     SetFocus, eax

      .elseif wMsg == WM_COMMAND
         .if wParam == 410      ; Name CD
            INVOKE     GetDlgItemText, hwnd, 503, addr szBuff, sizeof szBuff
            INVOKE     EndDialog, hwnd, 0
         .endif

      .elseif wMsg == WM_CLOSE
         INVOKE     GetDlgItemText, hwnd, 503, addr szBuff, sizeof szBuff
         INVOKE     EndDialog, hwnd, 0
      .endif
         xor     eax, eax
         ret
CDName endp

;=============================================================================
; Track Name Edit dialog
;=============================================================================
TrkName proc   hwnd:DWORD, wMsg, wParam, lParam

      .if wMsg == WM_INITDIALOG
         INVOKE     SetDlgItemText, hwnd, 503, addr szBuff
         INVOKE     GetDlgItem, hwnd, 503
           push     eax
         INVOKE     SendMessage, eax, EM_SETSEL, 0, -1
            pop     eax
         INVOKE     SetFocus, eax

      .elseif wMsg == WM_COMMAND
         .if wParam == 410      ; Name Track
            INVOKE     GetDlgItemText, hwnd, 503, addr szBuff, sizeof szBuff
            INVOKE     EndDialog, hwnd, 0
         .endif

      .elseif wMsg == WM_CLOSE
         INVOKE     GetDlgItemText, hwnd, 503, addr szBuff, sizeof szBuff
         INVOKE     EndDialog, hwnd, 0
      .endif
         xor     eax, eax
         ret
TrkName endp

END START
;INVOKE     MessageBox, NULL, addr szTrkNum, addr ClassName, MB_OK
