.386
.model flat,stdcall
option casemap:none

include \masm32\include\windows.inc
include \masm32\include\user32.inc
include \masm32\include\kernel32.inc
includelib \masm32\lib\user32.lib
includelib \masm32\lib\kernel32.lib

DlgProc      PROTO :DWORD,:DWORD,:DWORD,:DWORD

.const
CM_EXIT	equ 101
EB_DATA	equ 101
PB_ADD	equ 102
PB_RETURN	equ 103
PB_NEXT     equ 104

ACCESS_TYPE equ GPTR ;Type of memory allocation
MAX_TEXT    equ 16   ;Maximum characters in the edit box


NODE STRUCT
    next DWORD ?
    data db (MAX_TEXT + 1) DUP (?)
NODE ENDS


.data
DlgName  db "MainDlg",0
stub     DWORD 0     ;Address of the root node

.data?
hInstance HINSTANCE ?
hNext     HWND ?     ;Handle of the Next button
hReturn   HWND ?     ;Handle of the Return button
current   DWORD ?    ;Address of the current node

.code
start:
    invoke GetModuleHandle, NULL
    mov hInstance, eax

    invoke DialogBoxParam, eax, ADDR DlgName, NULL, ADDR DlgProc, NULL
    invoke ExitProcess, eax

DlgProc PROC hWnd:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM
    .IF uMsg==WM_INITDIALOG
        invoke GetDlgItem, hWnd, PB_NEXT ;Get the handle to the "Next" button
        mov hNext, eax
        invoke EnableWindow, eax, FALSE  ;Disable the "Next" button

        invoke GetDlgItem, hWnd, PB_RETURN ;Get the handle of the "Return" button
        mov hReturn, eax
        invoke EnableWindow, eax, FALSE    ;Disable it!

        invoke GetDlgItem, hWnd, EB_DATA   ;Get the handle of the edit box
        invoke SendMessage, eax, EM_LIMITTEXT, MAX_TEXT, 0
                                           ;Limit it to MAX_TEXT characters
        
    .ELSEIF uMsg==WM_CLOSE
	  invoke SendMessage,hWnd,WM_COMMAND,CM_EXIT,0
        ;If closed, act like it was the "Exit" command from the menu

    .ELSEIF uMsg==WM_COMMAND
	  mov eax,wParam
        .IF lParam==0
	      .IF ax==CM_EXIT ;Menu - exit
                mov edx, stub ;Start at the root node

                .REPEAT
                    push (NODE PTR [edx]).next ;Store the next pointer
                    invoke GlobalFree, edx     ;Delete current pointer
                    pop edx ;Move on to the next
                    or edx, edx
                .UNTIL edx==0

		    invoke EndDialog, hWnd,NULL    ;Exit the dialog box proc
	      .ENDIF
        .ELSE
		mov edx,wParam
		shr edx,16
		.IF dx==BN_CLICKED
		   .IF ax==PB_ADD
                    .IF stub==0                                      ;If there is no root
                        invoke GlobalAlloc, ACCESS_TYPE, SIZEOF NODE ;Create one
                        mov (NODE PTR [eax]).next, 0                 ;Set the terminator
                        mov stub, eax                                ;Set the root pointer
                        mov current, eax                             ;Set the current pointer

                        lea eax, (NODE PTR [eax]).data
                        invoke GetDlgItemText, hWnd, EB_DATA, eax, MAX_TEXT
                        ;Fill the allocated space with the text from EB_DATA (the edit box)

                    .ELSE ;A linked list already exists!
                        invoke GlobalAlloc, ACCESS_TYPE, SIZEOF NODE ;Create a new node
                        mov edx, current               ;Move the current pointer to a reg, ready for use
                        mov ecx, (NODE PTR [edx]).next ;Move the current.next pointer to a reg
                        mov (NODE PTR [eax]).next, ecx ;"Insert" the new node
                        mov (NODE PTR [edx]).next, eax ;Make the current point to the new instead

                        lea eax, (NODE PTR [eax]).data

                        invoke GetDlgItemText, hWnd, EB_DATA, eax, MAX_TEXT
                        ;Fill the allocated space with the data from the edit box

                        invoke EnableWindow, hNext, TRUE
                        ;Make sure the "Next" button is enabled

                        mov edx, current
                        lea eax, (NODE PTR [edx]).data
                        invoke SetDlgItemText, hWnd, EB_DATA, eax
                        ;Restore the text to that of the current node
                    .ENDIF

               .ELSEIF ax==PB_RETURN
                        mov eax, stub
                        mov current, eax ;Make current = stub

                        lea eax, (NODE PTR [eax]).data

                        invoke SetDlgItemText, hWnd, EB_DATA, eax
                        invoke EnableWindow, hReturn, FALSE
                        invoke EnableWindow, hNext, TRUE
                        ;Update buttons etc.

               .ELSEIF ax==PB_NEXT
                        mov edx, current
                        mov edx, (NODE PTR [edx]).next
                        ;Make current = current.next

                        lea eax, (NODE PTR [edx]).data
                        push edx ;Store new current for later

                        invoke SetDlgItemText, hWnd, EB_DATA, eax
                        ;Get appropriate text

                        pop edx ;restore new current

                        mov eax, (NODE PTR [edx]).next
                        mov current, edx ;Save new current over old current
                        
                        .IF eax==0 ;If the next node is the null terminator
                            invoke EnableWindow, hNext, FALSE ;Disable the "Next" button
                        .ENDIF

                        invoke EnableWindow, hReturn, TRUE ;Enable the "Return" button
		   .ENDIF
		.ENDIF
	  .ENDIF
    .ELSE
        mov eax, FALSE
	  ret
    .ENDIF
    mov eax,TRUE
    ret
DlgProc endp

end start
