;            
;=======================================================
;-------------------------------------------------------
;
;         Modify PE                  
;
;	Author:	metheus@gmx.net
;
;-------------------------------------------------------
;	-File must be <4GB
;	
;
;-------------------------------------------------------
;
;	20.07.99
;	26.07.99 implemented Add Virtual Space
;	         restructured CommandLine Interface
;	27.07.99 implemented Credits,Checksum,Verbosity,
;		 Delete Virtual Space
;	28.08.99 deleted some options which seemed
;		 useless
;	29.08.99 implemented Add Physical Space, Delete
;	         Physical Space
;	30.08.99 implemented Realign Virtual, Realign 
;		 Physical, Prevent Padding
;	31.08.99 cleaned up code
;
;
;-------------------------------------------------------
;
;	nasmw file.asm -f win32
;	alink file.obj -oPE win32.lib -subsys con -entry main
;-------------------------------------------------------
;=======================================================
;

%INCLUDE "f:\text\com\asm\src\include\Win32definitions.INC" 	; Some useful includes
%INCLUDE "f:\text\com\asm\src\include\PE-Header.INC"		; PE-Header Structure
%INCLUDE "f:\text\com\asm\src\include\Standard.INC"		; Useful macros, equs and strucs

EXTERN	CloseHandle
EXTERN	CreateFileA
EXTERN	CreateFileMappingA
EXTERN	DeleteFileA
EXTERN  ExitProcess
EXTERN 	LoadLibraryA
EXTERN	MapViewOfFile
EXTERN	MessageBoxA
EXTERN  MoveFileA
EXTERN	GetCommandLineA
EXTERN	GetFileInformationByHandle
EXTERN	GetLastError
EXTERN	GetProcAddress
EXTERN	GetTempFileNameA
EXTERN	GetTempPathA
EXTERN	GetStdHandle
EXTERN	UnmapViewOfFile
EXTERN	WriteFile

MAX_PARAMETERS		EQU	10h

SECTION .text
GLOBAL main

main:		
;
;		Do some init stuff
;
		xor	eax,eax					;Init some virtual data
		mov	edi,init_data_start			; to zero
		mov	ecx,INIT_DATA_SIZE
		rep	stosb					

		push.d	STD_OUTPUT_HANDLE
		call	GetStdHandle
		inc	eax
		jz.l	.no_stdhandle
		dec	eax
		mov	[hStdOutput],eax

		call	GetCommandLineA	 
		mov	[lpCommandLine],eax
		mov	ebx,lpParameters
		mov	ecx,MAX_PARAMETERS
		call	get_parameters
		mov	[nParameter],eax
		cmp	eax,byte 2
		jc.l	.help				;to few parameters
;
;		Errorcheck Commandline && Read in Parameters && Get Operation Mode
;
		mov	edi,cFileName			;extract filename from
		mov	esi,[lpParameters]		; parameters
		movzx	ecx,word [lpParameters+CLP_Length]
		rep	movsb
		mov	byte [edi],0h			;Terminate Filename

		mov	eax,[nParameter]		;Calc length of parameter table
		mov	ecx,COMMAND_LINE_PARAMETER_size
		mul	ecx	

		mov	esi,lpParameters
		mov	edi,esi
		add	edi,eax				;Calc end of parameter table
		add	esi,COMMAND_LINE_PARAMETER_size ;Skip first parameter
		
.next_parameter:mov	eax,[esi]
		movzx	eax,word [eax]			;get first two chars of parameter
		mov	ebx,lpParamTable
		call	scan_table_w
		jeaxz.l	.invalid_parameter
		xchg	esi,eax	
		call	esi		
		jeaxz.l	.invalid_parameter
		xchg	esi,eax
		cmp	esi,edi				;end of parameter table ?
		jnz	.next_parameter
;
;		Create Temp File
;
		push.d	cTempFileName
		push.d	MAX_PATH
		call	GetTempPathA	
		jeaxz.l	.no_temp_path		
		mov	edi,cTempFileName
		add	edi,eax				;Set edi to end of TempPath

		mov	esi,cTempFile			;append TempFile
		call	copy_string
		
		push.d	cTempFileName			;Try to delete our tmp file in case
		call	DeleteFileA			; it already exists

		push.d	cTempFileName			;lpNewFile
		push.d	cFileName			;lp
		call	MoveFileA		
		jeaxz.l	.no_file_move			
				
		mov	eax,cTempFileName		;Open source 
		mov	ebx,OPEN_EXISTING
		call	create_file
		jeaxz.l	.no_out_file_open
		mov	[hFile],eax

		push.d	FileInfo			;lpFileInformation
		push.d	[hFile]				;hFile
		call	GetFileInformationByHandle
		jeaxz.l	.no_out_file_open

		mov	eax,[hFile]
		mov	ebx,[FileInfo+HFI_nFileSizeLow]
		call	memmap_file

		call	is_PE
		jeaxz.l	.invalid_file

		mov	eax,[lpMapAddress]
		call	get_pe_lps			;get lpPEHeader & lpObjectTableStart
;
;		Extend MemMapping if physical space is added
;
		movzx	eax,word [cMode]
		cmp	ax,"-a"				;add phyiscal space ?
		jnz	.no_add_physical
		
		mov	eax,[dParamLength]
		mov	ebx,[lpPEHeader]
		mov	ebx,[ebx+PE_FileAlignment]
		call	align_eax
		push	eax				;SAVE SizeIncrease
		jmp	.reopen_file

.no_add_physical:
		cmp	ax,"-r"				;realign physical
		jnz	.no_physical_realign

		mov	eax,[dParamAlignment]		;Reserve space, in case new Filealign
		mov	ebx,[nPESections]		; is bigger than old Filealign
		inc	ebx				;space for PEHeader (section 0)
		mul	ebx
		push	eax				;SAVE SizeIncrease
		
.reopen_file:	push.d	[lpMapAddress]
		call	UnmapViewOfFile 
		push.d	[hFileMappingObject]
		call	CloseHandle			;Close hFileMappingObject
		
		pop	ebx				;RESTORE SizeIncrease
		mov	eax,[hFile]
		add	ebx,[FileInfo+HFI_nFileSizeLow]
		call	memmap_file
		call	get_pe_lps
		
.no_physical_realign:
		mov	eax,cFileName			;Create destination file
		mov	ebx,CREATE_NEW			; 
		call	create_file
		jeaxz.l	.no_in_file_open
		mov	[hFile2],eax			;Save FileHandle
;
;		Get Operation Mode and Execute Operation
;		
		movzx	eax,word [cMode]		;Get 2.Parameter
		mov	ebx,lpModeTable
		call	scan_table_w			;get Address of subroutine
		jeaxz.l	.minor_operations	
		
		call	eax				;Dispatch call
		jeaxnz.l .error				;Error ?		
;
;		Minor Operation 
;
.minor_operations:
		mov	eax,[dSwitches]
		test	eax,SWITCH_ON_CHECKSUM
		jz	.no_checksum
		mov	eax,[lpPEHeader]
		push	eax
		mov	dword [eax+PE_FileChecksum],0	;Clear Checksumfield 
		mov	eax,[lpMapAddress]
		mov	ebx,[FileInfo+HFI_nFileSizeLow]
		add	ebx,[dPhysicalSizeIncrease]	;The file may have grown/shrunken
		call	calc_checksum
		pop	ebx	
		mov	[ebx+PE_FileChecksum],eax	;Paste new Checksum
		mov	[dChecksum],eax
.no_checksum:
;
;		Clean Up
;
		mov	eax,[lpPEHeader]
		mov	eax,[eax+PE_ImageSize]
		mov	[dVirtualSize],eax
		mov	esi,[FileInfo+HFI_nFileSizeLow]
		add	esi,[dPhysicalSizeIncrease]	;FileSize may have changed
		mov	[dPhysicalSize],esi	
		
		push.b	NULL				;lpOverlapped
		push.d	dBytesWritten			;lpNumberOfBytesWritte
		push	esi				;nNumberOfBytesToWrite
		push.d	[lpMapAddress]			;lpBuffer
		push.d	[hFile2]			;hFile
		call	WriteFile
		jeaxz.l	.fatal_error
		
		cmp	esi,[dBytesWritten]		
		jnz.l	.fatal_error
		
		push.d	[hFile2]
		call	CloseHandle
		call	memmap_file.close_all
		push.d	cTempFileName			;Del TempFile
		call	DeleteFileA
;
;		Write extended output (verbose mode)
;
		mov	eax,[dSwitches]
		test	eax,SWITCH_ON_VERBOSE
		jz.l	.no_verbose
	
		mov	eax,cVirtualSize		;Write Image Size
		call	write_stdoutput
		mov	eax,cHexstringBuffer
		mov	ebx,[dVirtualSize]
		call	dw_to_hexstring
		call	write_stdoutput
		mov	eax,cNextLine
		call	write_stdoutput

		mov	eax,cVirtualSizeIncrease	;Write Image Size Increase
		call	write_stdoutput
		mov	eax,cHexstringBuffer
		mov	ebx,[dVirtualSizeIncrease]
		call	dw_to_hexstring
		call	write_stdoutput
		mov	eax,cNextLine
		call	write_stdoutput

		mov	eax,cPhysicalSize		;Write File Size
		call	write_stdoutput
		mov	eax,cHexstringBuffer
		mov	ebx,[dPhysicalSize]
		call	dw_to_hexstring
		call	write_stdoutput
		mov	eax,cNextLine
		call	write_stdoutput

		mov	eax,cPhysicalSizeIncrease	;Write File Size Increase
		call	write_stdoutput
		mov	eax,cHexstringBuffer
		mov	ebx,[dPhysicalSizeIncrease]
		call	dw_to_hexstring
		call	write_stdoutput
		mov	eax,cNextLine
		call	write_stdoutput

		mov	eax,[dChecksum]			;Write Checksum
		jeaxz	.skip_checksum
		mov	eax,cChecksumCalculated
		call	write_stdoutput
		
		mov	ebx,[dChecksum]
		mov	eax,cHexstringBuffer
		call	dw_to_hexstring
		call	write_stdoutput

		mov	eax,cNextLine
		call	write_stdoutput	
.skip_checksum:
.no_verbose:	
;
;		Print Success Message, to make user smile
;			
		mov	eax,cSuccess			;Write Success Message
		call	write_stdoutput

;
;		Print Credits
;
		mov	eax,[dSwitches]
		test	eax,SWITCH_ON_CREDITS
		jz	.no_credits
		test	eax,SWITCH_ON_VERBOSE
		jz	.no_verbose_credits
		mov	eax,cVerboseCredits
		jmp	.credits	
.no_verbose_credits:
		mov	eax,cCredits
.credits:	call	write_stdoutput
.no_credits:	jmp	.exit
;
;		Errormessages
;
.no_stdhandle:	mov	esi,cNoStdhandleError
		jmp	.message
.help:		mov	esi,cHelp
		jmp	.message
.no_temp_path:	mov	esi,cNoTempPathError
		jmp	.message
.no_file_move:	mov	esi,cNoFileMoveError
		jmp	.message
.no_in_file_open:
		mov	esi,cNoInFileOpenError
		jmp	.restore_file
.no_out_file_open:
		mov	esi,cNoOutFileOpenError
		jmp	.close_source
.invalid_file:	mov	esi,cInvalidFileError
		jmp	.close_source
.invalid_parameter:
		mov	esi,cInvalidParameterError
		jmp	.message
.fatal_error:	mov	esi,cFatalError
		jmp	.error
;
;		Clean up after Error
;	
.error:		push.d	[hFile2]			;Close Destination File
		call	CloseHandle			;
		push.d	cFileName			;Delete Destination File
		call	DeleteFileA			;
.close_source:	call	memmap_file.close_all		;Close Soure File		
.restore_file:	push.d	cFileName			;Move Source file
		push.d	cTempFileName			; to original place
		call	MoveFileA			;

.message	xchg	eax,esi
		call	write_stdoutput
;
;		Print Message and Exit
;						
.exit:		push.b  0             			;Terminate program 
		call    ExitProcess		      


;
;
;=======================================================================================
;
;	SUBROUTINES	
;
;=======================================================================================
;
;           				
;-------------------------------------------------------
; 	delete physical space
;          
;     			      
;	JOB: 	
;       USED:
;       NOTE:				
;-------------------------------------------------------
;
delete_physical_space:
		mov	eax,[dParamLength]
		not	eax
		inc	eax
		mov	[dParamLength],eax
;           				
;-------------------------------------------------------
;	add physical space
;      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 
add_physical_space:
		mov	eax,cSectionName
		call	get_ot_by_name
		jeaxz.l	.invalid_section
		xchg	esi,eax

		mov	eax,[esi+OT_PhysicalSize]
		mov	ebx,[lpPEHeader]
		mov	ebx,[ebx+PE_FileAlignment]
		call	align_eax			;Calc start of next section

		push	eax
		mov	eax,[dParamLength]
		add	eax,[esi+OT_PhysicalSize]
		mov	ebx,[lpPEHeader]
		mov	ebx,[ebx+PE_FileAlignment]
		call	align_eax		
		pop	ebx
		sub	eax,ebx				;Calc shifting distance
		xchg	ebx,eax				;Distance

		mov	eax,[dParamLength]		;Extend section
		add	[esi+OT_PhysicalSize],eax

		cmp	esi,[lpObjectTableEnd]
		jz	.no_shifting			;section is the last OT Entry
		
		mov	eax,[esi+OT_PhysicalOffset]
		mov	ecx,[FileInfo+HFI_nFileSizeLow]
		sub	ecx,eax
		add	eax,[lpMapAddress]	
		push	ebx				;SAVE Distance
		call	move_data

		pop	ebx				;RESTORE Distance
		mov	eax,esi				;lpOT Entry
		call	fix_OT_phys_offsets	
.no_shifting:		
		mov	[dPhysicalSizeIncrease],ebx
		mov	[dParamLength],ebx
		call	add_virtual_space

		xor	eax,eax
		ret
;
;	Local Subroutines & Error Messages
;
.invalid_parameter:
		mov	eax,cInvalidParameterError
		call	write_stdoutput			;Write ErrorMessage
.error		ret
.invalid_section:mov	eax,cSectionNotFoundError
		call	write_stdoutput			;Write ErrorMessage
		ret	
;           				
;-------------------------------------------------------
;	delete virtual space
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
;
delete_virtual_space:
		mov	eax,[dParamLength]
		not	eax
		inc	eax
		mov	[dParamLength],eax
;           				
;-------------------------------------------------------
;	add virtual space
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
add_virtual_space:
		mov	eax,cSectionName
		call	get_ot_by_name
		jeaxz	.invalid_section
		xchg	esi,eax

		mov	eax,[esi+OT_RVA]		;Calc RVA of section end
		add	eax,[esi+OT_VirtualSize]
		mov	[dParamOffset],eax	
	
		mov	eax,[esi+OT_VirtualSize]
		mov	ebx,[lpPEHeader]
		mov	ebx,[ebx+PE_ObjectAlignment]
		call	align_eax

		push	eax
		mov	eax,[dParamLength]
		add	eax,[esi+OT_VirtualSize]
		mov	ebx,[lpPEHeader]
		mov	ebx,[ebx+PE_ObjectAlignment]
		call	align_eax		
		pop	ebx
		sub	eax,ebx
		
		mov	ebx,[dParamLength]
		add	[esi+OT_VirtualSize],ebx

		mov	[dParamLength],eax
		
		mov	eax,[dParamOffset]
		mov	ebx,[dParamLength]
		mov	[dVirtualSizeIncrease],ebx
		call	fix_rvas
		
		xor	eax,eax
		ret
;
;	Local Subroutines & Error Messages
;
.invalid_parameter:
		mov	eax,cInvalidParameterError
		call	write_stdoutput			;Write ErrorMessage
.error		ret
.invalid_section:mov	eax,cSectionNotFoundError
		call	write_stdoutput			;Write ErrorMessage
		ret
;           				
;-------------------------------------------------------
;	realign physical
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 
realign_physical:
		mov	esi,[lpPEHeader]

		mov	eax,[dParamAlignment]
		mov	[esi+PE_FileAlignment],eax	;Paste new FileAlign in PE Header
		mov	edi,[FileInfo+HFI_nFileSizeLow]
		mov	ebp,[lpObjectTableStart]

		mov	eax,[esi+PE_HeaderSize]
		mov	ebx,[esi+PE_FileAlignment]
		call	align_eax
		
		xchg	eax,ebx
		mov	eax,[ebp+OT_PhysicalOffset]	
		sub	ebx,eax				;Distance
		push	ebx				;SAVE Distance
		mov	ecx,edi
		add	edi,ebx				;Physical Length of File
		sub	ecx,eax				;Length
		add	eax,[lpMapAddress]		;lpData				
		call	move_data
	
		mov	eax,ebp
		pop	ebx				;RESTORE Distance
		call	fix_OT_phys_offsets

		add	ebp,IMAGE_OBJECT_TABLE_size
.next_section:	mov	eax,[ebp+OT_PhysicalOffset-IMAGE_OBJECT_TABLE_size]
		add	eax,[ebp+OT_PhysicalSize-IMAGE_OBJECT_TABLE_size]
		mov	ebx,[esi+PE_FileAlignment]
		call	align_eax
		
		xchg	eax,ebx
		mov	eax,[ebp+OT_PhysicalOffset]	
		sub	ebx,eax				;Distance
		push	ebx				;SAVE Distance
		mov	ecx,edi
		add	edi,ebx
		sub	ecx,eax				;Length
		add	eax,[lpMapAddress]		;Offset				
		call	move_data

		mov	eax,ebp
		pop	ebx				;RESTORE Distance
		call	fix_OT_phys_offsets

		add	ebp,IMAGE_OBJECT_TABLE_size
		cmp	[lpObjectTableEnd],ebp		
		jnc	.next_section				
;
;		Exit 
;
.exit:		mov	eax,[ebp+OT_PhysicalOffset-IMAGE_OBJECT_TABLE_size]
		add	eax,[ebp+OT_PhysicalSize-IMAGE_OBJECT_TABLE_size]

		mov	ebx,[dSwitches]
		test	ebx,SWITCH_OFF_PADDING
		jnz	.no_padding

		mov	ebx,[esi+PE_FileAlignment]
		call	align_eax

.no_padding:	sub	eax,[FileInfo+HFI_nFileSizeLow]
		mov	[dPhysicalSizeIncrease],eax

		xor	eax,eax
		ret
;           				
;-------------------------------------------------------
;	realign virtual
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
realign_virtual:		
		mov	esi,[lpPEHeader]
		mov	eax,[esi+PE_ImageSize]
		mov	[dOldImageSize],eax

		mov	eax,[dParamAlignment]
		mov	[esi+PE_ObjectAlignment],eax	;Paste new ObjectAlign in PE Header
		mov	ebp,[lpObjectTableStart]

		mov	eax,[esi+PE_HeaderSize]
		mov	ebx,[esi+PE_ObjectAlignment]
		call	align_eax
		
		mov	ebx,[ebp+OT_RVA]		;Offset
		sub	eax,ebx				;Length
		xchg	eax,ebx
		call	fix_rvas

		add	ebp,IMAGE_OBJECT_TABLE_size
.next_section:	mov	eax,[ebp+OT_RVA-IMAGE_OBJECT_TABLE_size]
		add	eax,[ebp+OT_VirtualSize-IMAGE_OBJECT_TABLE_size]
		mov	ebx,[esi+PE_ObjectAlignment]
		call	align_eax
		
		mov	ebx,[ebp+OT_RVA]
		sub	eax,ebx
		xchg	eax,ebx		
		call	fix_rvas

		add	ebp,IMAGE_OBJECT_TABLE_size
		cmp	[lpObjectTableEnd],ebp		
		jnc	.next_section				
;
;		Exit 
;
.exit:		mov	eax,[ebp+OT_RVA-IMAGE_OBJECT_TABLE_size]
		add	eax,[ebp+OT_VirtualSize-IMAGE_OBJECT_TABLE_size]
		mov	ebx,[esi+PE_ObjectAlignment]
		call	align_eax

		mov	[esi+PE_ImageSize],eax
		mov	ebx,[dOldImageSize]
		sub	eax,ebx
		mov	[dVirtualSizeIncrease],eax

		xor	eax,eax
		ret
;           				
;-------------------------------------------------------
;	switch on checksum
;               			      
;
;	JOB: 
;       USED: ebx
;       NOTE:					
;-------------------------------------------------------
; 	
switch_on_checksum:
		mov	ebx,[dSwitches]
		or	ebx,SWITCH_ON_CHECKSUM
		mov	[dSwitches],ebx
		add	eax,COMMAND_LINE_PARAMETER_size
		ret
;           				
;-------------------------------------------------------
;	switch on credits
;               			      
;
;	JOB:
;       USED: ebx
;       NOTE:					
;-------------------------------------------------------
;
switch_on_credits:
		mov	ebx,[dSwitches]
		or	ebx,SWITCH_ON_CREDITS
		mov	[dSwitches],ebx
		add	eax,COMMAND_LINE_PARAMETER_size
		ret  
;           				
;-------------------------------------------------------
;	switch off padding
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
switch_off_padding:
		mov	ebx,[dSwitches]
		or	ebx,SWITCH_OFF_PADDING
		mov	[dSwitches],ebx
		add	eax,COMMAND_LINE_PARAMETER_size
		ret 		
;           				
;-------------------------------------------------------
;	switch on verbose
;               			      
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
switch_on_verbose:
		mov	ebx,[dSwitches]
		or	ebx,SWITCH_ON_VERBOSE
		mov	[dSwitches],ebx
		add	eax,COMMAND_LINE_PARAMETER_size
		ret 	
;           				
;-------------------------------------------------------
;	get alignment
;               			      
;       -> eax = lp CommandLineParameter Structure
;       <- eax = lp CommandLineParameter Structure
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
get_alignment:	xchg	esi,eax
		mov	eax,[esi]			;get lp to Parameter
		movzx	eax,word [eax]			;get first two chars of parameter
		mov	[cMode],ax

		add	esi,byte COMMAND_LINE_PARAMETER_size
		movzx	ebx,word [esi+CLP_Length]
		cmp	ebx,byte 8
		jnc	.error				;Offset to long		
		mov	eax,[esi]
		call	hexstring_to_dw
		jc	.error		
		mov	[dParamAlignment],eax

.exit:		xchg	esi,eax
		add	eax,byte COMMAND_LINE_PARAMETER_size
		ret
.error:		mov	eax,cInvalidAlignmentError
		call	write_stdoutput			;Write ErrorMessage
		xor	eax,eax
		ret	
;           				
;-------------------------------------------------------
;	get_section_length
;               			      
;       -> eax = lp CommandLineParameter Structure
;       <- eax = lp CommandLineParameter Structure
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 	
get_section_length:
		push_edi_esi
		xchg	esi,eax
		mov	eax,[esi]			;get lp to Parameter
		movzx	eax,word [eax]			;get first two chars of parameter
		mov	[cMode],ax

		add	esi,byte COMMAND_LINE_PARAMETER_size
		movzx	ecx,word [esi+CLP_Length]
		cmp	ecx,byte 8
		jnc	.error				;Offset to long
		mov	edi,cSectionName
		push	esi
		mov	esi,[esi]
		rep	movsb
		pop	esi
		xor	eax,eax				;Terminate string
		stosb					;
				
		add	esi,byte COMMAND_LINE_PARAMETER_size
		movzx	ebx,word [esi+CLP_Length]
		cmp	ebx,byte 8
		jnc	.invalid_number			;Offset to long		
		mov	eax,[esi]
		call	hexstring_to_dw
		jc	.invalid_number
		mov	[dParamLength],eax

.exit:		xchg	esi,eax
		add	eax,byte COMMAND_LINE_PARAMETER_size
		pop_esi_edi
		ret

.invalid_number:mov	eax,cInvalidNumberError
		jmp	.error
.invalid_name	mov	eax,cNameTooLongError
		jmp	.error
	
.error		call	write_stdoutput			;Write ErrorMessage
		xor	eax,eax
		pop_esi_edi
		ret
;           				
;-------------------------------------------------------
;	hexstring_to_dw				26.07.99
;               			      	v1.0
;       -> eax = lp String 
;	   ebx = length of string (maximal 8 byte)
;       <- eax = number
;
;	JOB: convert string at eax to hex
;       USED:
;       NOTE: stc on error					
;-------------------------------------------------------
; 
hexstring_to_dw:push	esi
		or	ebx,ebx
		jz	.error
		xor	edx,edx
		mov	esi,eax
.next_nibble:	lodsb					;get char
		call	hexchar_to_b
		jc	.error
		sal	edx,4
		or	dl,al
		dec	ebx
		jnz	.next_nibble
		xchg	eax,edx
.exit:		pop	esi
		clc
		ret
.error:		pop	esi
		stc
		ret
;           				
;-------------------------------------------------------
;	dw_to_hexstring				27.07.99
;               			      	v1.0b
;       -> eax = lpHexstring Buffer
;	   ebx = number
;       <- eax = lpHexstring Buffer
;
;	JOB: convert number in eax to 8 byte Hexstring
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 
dw_to_hexstring:push	edi
		push	eax
		std
		xchg	edi,eax
		dec	edi
		dec	edi
		mov	ecx,edi
		add	edi,byte 8
.next_nibble:	mov	al,bl
		call	b_to_hexchar			
		stosw					
		shr	ebx,8				;get next nibble
		cmp	edi,ecx				
		jnz	.next_nibble
.exit		cld
		pop	eax
		pop	edi
		ret
;           				
;-------------------------------------------------------
;	calc_checksum				14.05.99
;               			      	v1.0
;       -> eax = lpMapAddress
;	   ebx = FileLength in Bytes
;       <- eax = Checksum
;
;	JOB: Calculate the checksum for nt-driver
;       USED: eax,ebx,ecx,edx
;       NOTE: Checksumfield in PE-Header must be set
;	      to zero before calling calc_checksum
;-------------------------------------------------------
; 
calc_checksum:	push	esi
		xor	edx, edx
		mov	esi, eax
		mov	ecx, ebx
		shr	ecx, 1				;Convert Bytes to Words
.next_word:	movzx	eax, word [esi]
		add	edx, eax
		mov	eax, edx
		and	edx, 0FFFFh	
		shr	eax, 10h
		add	edx, eax
		inc	esi
		inc	esi
		loop	.next_word
		mov	eax, edx
		shr	eax, 10h
		add	ax, dx
		add	eax, ebx			;add Filelength
		pop	esi
		ret		
;           				
;-------------------------------------------------------
; 	get_pe_lps		(extended)	16.07.99
;               				v1.12b
;      	->  eax = lpMapAddress of File
;      	<-  eax = lpPEHeaderAddress
;	    ebx = lpObjectTableStart
;
;      	JOB: Calculate Address of PEHeaderBase
;	     ,lpObjectTableStart, lpObjectTableEnd
;	     and PE_NumberOfObjects
;      	USED:eax,ebx,ecx,edx
;      	NOTE:					
;-------------------------------------------------------
;
get_pe_lps:	add	eax,dword [eax+MZ_PEHeaderBase]	; Calculate Header
		mov	[lpPEHeader],eax		; Address

		movzx	ebx,word [eax+PE_NTHeaderSize] 	;Calculate Object		
		add	ebx,eax		   	   	; Table Start
		add	ebx,byte 18h
		mov	[lpObjectTableStart],ebx

		push	eax				;Calulate Object 
		movzx	eax,word [eax+PE_NumberOfObjects]; Table End
		mov	[nPESections],eax
		dec	eax
		mov	ecx,IMAGE_OBJECT_TABLE_size
		mul	ecx
		add	eax,ebx
		mov	[lpObjectTableEnd],eax
		pop	eax
		ret
;           				
;-------------------------------------------------------
;	copy_string				27.02.99
;               			      
;       -> esi = String source
;	   edi = String destination 
;       <-
;
;	JOB: Copy string from esi to edi
;	     including terminating 0h byte:
;       USED:
;       NOTE:					
;-------------------------------------------------------
;
copy_string:	lodsb
		stosb
		or	al,al
		jnz	copy_string
		ret 
;           				
;-------------------------------------------------------
;	get_parameters				20.07.99
;               			      
;       -> eax = lpCommandLine
;	   ebx = lpParameterStructure
;	   ecx = max Number of Parameters
;       <- eax = Number of Parameters found
;
;	JOB:
;       USED:
;       NOTE:					
;-------------------------------------------------------
;
get_parameters:	push_edi_esi
		mov	edi,eax
		mov	edx,ecx
		push	edx

		xor	eax,eax
		xor	ecx,ecx
		dec	ecx
		push	edi
		repnz	scasb
		not	ecx
		
		pop	edi
		mov	eax,20h
		repnz	scasb
		jecxz	.exit
		
.next_parameter:mov	esi,edi
		repnz	scasb
		mov	[ebx],esi			;store lpParameter
		sub	esi,edi
		not	esi
		mov	word [ebx+4],si
		add	ebx,COMMAND_LINE_PARAMETER_size
		dec	edx
		jecxz	.exit				;End of Commandline ?
		or	edx,edx				;Max Parameters count reached ?
		jnz	.next_parameter
				
.exit:		pop	eax		
		sub	eax,edx
		pop_esi_edi
		ret
;           				
;-------------------------------------------------------
;	write_stdoutput				21.07.99	
;               			      
;       -> eax = lpString (0h terminated)
;       <-
;
;	JOB: Write String to Standard Output
;       USED: eax,ebx
;       NOTE: hStdOutput must be initialized
;	      stc on error		
;-------------------------------------------------------
; 
write_stdoutput:push	eax				;SAVE lpString
		call	scan_for_0h			;get string length
		
		pop	ecx				;RESTORE lpString
		push.b	NULL				;lpOverlapped
		push.d	dBytesWritten 			;lpNumberOfBytesWritte
		push	eax				;nNumberOfBytesToWrite
		push	ecx				;lpBuffer
		push.d	[hStdOutput]			;hFile
		call	WriteFile
		call 	GetLastError
		jeaxz	.error
.exit:		clc
		ret
.error:		stc
		ret 
;           				
;-------------------------------------------------------
;	scan_for_0h 				22-01-99
;               			      	v1.01
;       -> eax = lpString
;       <- eax = length of string (excluding 0h byte)
;
;	JOB:Length of given string is calculated
;           by parsing for 0 byte.
;       USED: eax, ecx
;       NOTE:				
;-------------------------------------------------------
; 	   				    
scan_for_0h:	push	edi
		xchg	edi,eax
		xor	ecx,ecx
		dec	ecx
		xor	eax,eax
		repnz	scasb
		xchg	eax,ecx
		not	eax
		dec	eax
		pop	edi
		ret
;           				
;-------------------------------------------------------
;	create file								
;               			      	v1.0
;       -> eax = lpFileName
;	   ebx = dwCreationDistribution
;       <- eax = hFile
;
;	JOB: 
;       USED:
;       NOTE: eax = 0 on error			
;-------------------------------------------------------
;
create_file:	push.b	0				;hTemplateFile
		push.b	0				;dwFlagsAndAttributes
		push	ebx				;dwCreationDistribution
		push.b	0				;lpSecurityAttributes
		push.b	0				;dwShareMode
		push.d	GENERIC_READ | GENERIC_WRITE 	;dwDesiredAccess
		push	eax				;lpFileName
		call	CreateFileA
		ret
;           				
;-------------------------------------------------------
;	memmap file				29.08.99
;               			      	v1.0b
;       -> eax = hFile
;	   ebx = SizeOfMapping
;       <- eax = lpMapAddress
;
;	JOB: map file in memory
;       USED:
;       NOTE: eax = 0 on error	
;-------------------------------------------------------
;
memmap_file:	xchg	ebx,ebp
		
		push.b	NULL				;lpName
		push	ebp				;dwMaximumSizeLow
		push.b	0		        	;dwMaximumSizeHigh
		push.d	PAGE_READWRITE		
		push.b  NULL				;lpFileMappingAttributes
		push	eax				;hFile
		call	CreateFileMappingA
		jeaxz	.close_file			;Error ?
		mov	[hFileMappingObject],eax 	;save hFileMappingObject 

		push.b	ebp				;dwNumberOfBytesToMap
		push.b	0				;dwFileOffsetLow
		push.b	0				;dwFileOffsetHigh
		push.d	FILE_MAP_WRITE
		push	eax				;hFileMappingObject
		call	MapViewOfFile
		jeaxz	.unmap				;Error?		
		mov	[lpMapAddress],eax			
		ret			

.close_all:	push.d	[lpMapAddress]
		call	UnmapViewOfFile 
.unmap:		push.d	[hFileMappingObject]
		call	CloseHandle			;Close hFileMappingObject
.close_file:	push.d	[hFile]
		call	CloseHandle			;Close hFile
.error:		ret
;           				
;-------------------------------------------------------
;	scan_table_w				21.07.99
;               			      	v1.01
;       -> eax = parameter
;	   ebx = lpTable
;       <- eax = lpAddress
;
;	JOB: scan Table for parameter and return
;	     call address
;       USED:
;       NOTE: Table must be terminated by 0FFFFh				
;-------------------------------------------------------
; 	
s_t_w_1:	add	ebx,6	
scan_table_w:	cmp	word [ebx],0FFFFh
		jz	.error
		cmp	ax,word [ebx]
		jnz	s_t_w_1
.exit:		mov	eax,dword [ebx+2]	;get address
		ret
.error:		xor	eax,eax			;no match
		ret
;           				
;-------------------------------------------------------
;	scan_table_dw				26.07.99
;               			      	v1.0b
;       -> eax = parameter
;	   ebx = lpTable
;       <- eax = lpAddress
;
;	JOB: scan Table for parameter and return
;	     call address
;       USED: ebx
;       NOTE: Table must be terminated by 0FFFFh				
;-------------------------------------------------------
; 	
s_t_dw_1:	add	ebx,8	
scan_table_dw:	cmp	dword [ebx],0FFFFFFFFh	;End of Table ?
		jz	.error
		cmp	eax,dword [ebx]
		jnz	s_t_dw_1
.exit:		mov	eax,dword [ebx+4]	;get address
		ret
.error:		xor	eax,eax			;no match
		ret
;           				
;-------------------------------------------------------
;	fix_rvas				19.06.99
;               		      		v1.13
;       -> eax = RVA in FileImage
;	   ebx = size (must be rounded to object align)
;       <- eax = 
;
;	JOB: Fix Rvas in FileImage 
;
;       USED:
;       NOTE: fixes 
;	      PE_ExportTableRVA		yes
;	      PE_ImportTableRVA		yes
;	      PE_ResoureTableRVA	no (need not be fixed ?)	
;	      PE_ExceptionTableRVA	no	
;	      PE_SecurityTableRVA	no	
;	      PE_RelocationTableRVA	yes (and reloc items)	
;	      PE_DebugDirectoriesRVA	yes	
;	      PE_ImageDescriptionRVA	no	
;	      PE_MachineSpecificRVA	no	
;	      PE_ThreadLocalStorageRVA	no	
;	      PE_BoundImportRVA		no
;	      PE_ImportAddressTableRVA	yes
;-------------------------------------------------------
; 	
fix_rvas:	push_edi_esi_ebp
		mov	esi,eax
		mov	ebp,[lpPEHeader]
		add	[ebp+PE_ImageSize],ebx		;adjust size

		lea	edi,[ebp+PE_EntrypointRVA]
		call	adjust_RVA

		mov	ecx,[ebp+PE_NumberOfRvaSizes]
		lea	edi,[ebp+PE_ExportTableRVA]
.next_RVA:	call	adjust_RVA
		add	edi,8
		dec	ecx
		jnz	.next_RVA

		lea	edi,[ebp+PE_CodeBaseRVA]
		cmp	[edi],esi
		jc	.no_increase2
		add	[edi],ebx
.no_increase2:	lea	edi,[ebp+PE_DataBaseRVA]
		cmp	[edi],esi
		jc	.no_increase3
		add	[edi],ebx
.no_increase3:
;
;		Fix ObjectTable
;		
		movzx	ecx,word [ebp+PE_NumberOfObjects]
		mov	edi,[lpObjectTableStart]
		add	edi,OT_RVA
.next_OT_entry:	cmp	[edi],esi
		jc	.no_increase
		add	[edi],ebx			;adjust RVA
.no_increase:	add	edi,IMAGE_OBJECT_TABLE_size
		dec	ecx
		jnz	.next_OT_entry
;
;		Fix Imports
;
fix_imports:	mov	eax,[ebp+PE_ImportTableRVA]
		or	eax,eax
		push	ebx
		call	rva_to_a
		pop	ebx
		xchg	eax,edi				
.next_entry:	xor	eax,eax
		mov	ecx,IMAGE_IMPORT_DIRECTORY_TABLE_size
		push	edi
		repz	scasb
		pop	edi
		or	ecx,ecx				
		jz	fix_exports
		
		cmp	dword [edi], byte 0		;Some linker set  	
		jz	.table_empty			; IDT_OriginalLookupTableRVA to zero (bug ?)
		cmp	[edi],esi
		jc	.no_increase1
		add	[edi],ebx
.no_increase1:	mov	eax,[edi]
		push	ebx
		call	rva_to_a
		pop	ebx
		call	fix_import_table.enter	
.table_empty:	add	edi,IDT_NameRVA
		cmp	[edi],esi		
		jc	.no_increase2
		add	[edi],ebx

.no_increase2:	add	edi,byte 4
		cmp	[edi],esi
		jc	.no_increase3
		add	[edi],ebx
.no_increase3:	mov	eax,[edi]
		push	ebx
		call	rva_to_a
		pop	ebx
		call	fix_import_table.enter
		add	edi,byte 4
		jmp	.next_entry
.no_imports:
;
;		Fix Exports
;
fix_exports:	mov	eax,[ebp+PE_ExportTableRVA]
		or	eax,eax
		jz	.no_exports
		push	ebx
		call	rva_to_a
		pop	ebx
		xchg	eax,edi
		cmp	[edi+EDT_NameRVA],esi
		jc	.no_increase1
		add	[edi+EDT_NameRVA],ebx
.no_increase1:	cmp	[edi+EDT_AddressTableRVA],esi
		jc	.no_increase2
		add	[edi+EDT_AddressTableRVA],ebx
.no_increase2:	mov	ecx,[edi+EDT_EATEntries]
		or	ecx,ecx				;Sanity Check
		jz	.no_eat_entries
		mov	eax,[edi+EDT_AddressTableRVA]
		push	ebx
		push	ecx
		call	rva_to_a
		pop	ecx
		pop	ebx
		call	fix_export_table
.no_eat_entries:cmp	[edi+EDT_NamePtrTableRVA],esi
		jc	.no_increase3
		add	[edi+EDT_NamePtrTableRVA],ebx
.no_increase3:	mov	ecx,[edi+EDT_NamePtrs]
		or	ecx,ecx
		jz	.no_name_ptrs
		mov	eax,[edi+EDT_NamePtrTableRVA]
		push	ebx
		push	ecx
		call	rva_to_a
		pop	ecx
		pop	ebx
		call	fix_export_table
.no_name_ptrs:
.no_exports:
;
;		Fix Relocations
;
fix_relocations:mov	ecx,[ebp+PE_RelocationSize]	;size of relocations
		or	ecx,ecx
		jz	.no_relocations
		mov	eax,[ebp+PE_RelocationTableRVA]
		or	eax,eax
		jz	.no_relocations
		push	ebx
		push	ecx
		call	rva_to_a
		pop	ecx
		pop	ebx
		xchg	eax,edi				;edi = Start of relocations
.next_fixup_block:
		cmp	[edi],esi
		jc	.no_increase1
		add	[edi],ebx

.no_increase1:	push	ebx
		push	ecx
		mov	eax,[edi]
		call	rva_to_a			;get lp to FixupPage
		pop	ecx
		pop	ebx
			
		push	edi				;SAVE lpFixupBlock
		push	ecx				;SAVE PE_RelocationSize
		push	esi				;SAVE RVA
		mov	ecx,[edi+BR_SizeOfBlock]
		sub	ecx,byte IMAGE_BASE_RELOCATION_size
		add	edi,byte IMAGE_BASE_RELOCATION_size						
		add 	esi,[ebp+PE_ImageBase]		
		
		push	eax				;SAVE lp to FixupPage
.next_fixup:	pop	eax	
		push	eax	
		
		movzx	edx,word [edi]
		and	edx,0F000h			;get type
		cmp	edx,IMAGE_REL_BASED_HIGHLOW*4096;Only correct one type of fixup
		jnz	.no_increase2			; (should probably extended somtime)

		movzx	edx,word [edi]
		and	edx,0FFFh			;get offset
		add	eax,edx

		cmp	[eax],esi						
		jc	.no_increase2
		add	[eax],ebx	
.no_increase2:	inc	edi				;next type/offset
		inc	edi
		dec	ecx
		dec	ecx
		jnz	.next_fixup		
	
		pop	eax				;CLEAN Stack
		pop	esi				;RESTORE RVA
		pop	ecx				;RESTORE PE_ReloctionSize
		pop	edi				;RESTORE lpFixupBlock		
		sub	ecx,[edi+BR_SizeOfBlock]
		jz	.no_relocations			;End of FixupTable
		add	edi,[edi+BR_SizeOfBlock]	;next relocation page
		jmp	.next_fixup_block	
.no_relocations:
;
;		Fix Debug
;
fix_debug_info:	mov	ecx,[ebp+PE_DebugDirectories]
		or	ecx,ecx
		jz	.no_debug_info
		mov	eax,[ebp+PE_DebugDirectoriesRVA]
		or	eax,eax
		jz	.no_debug_info
		push	ebx
		call	rva_to_a
		pop	ebx
		xchg	eax,edi
		mov	ecx,[ebp+PE_DebugDirectories]
.next_directory:cmp	[edi+DDT_DataRVA],esi
		jc	.no_increase1
		add	[edi+DDT_DataRVA],ebx
.no_increase1:	dec	ecx
		jz	.no_debug_info	
		add	edi,byte IMAGE_DEBUG_DIRECTORY_TABLE_size 
		jmp	.next_directory
.no_debug_info:
;
;		Fix Import Address Table
;
fix_IAT:	mov	eax,[ebp+PE_IATRVA]
		or	eax,eax
		jz	.no_IAT
		push	ebx
		call	rva_to_a
		pop	ebx
		mov	ecx,[ebp+PE_IATSize]
		shr	ecx,2				;Convert Length in Bytes to NumberOfEntries
		call	fix_iat
.no_IAT:	

;
;		Exit
;
		pop_ebp_esi_edi
		ret	

;
;	Local	Subroutines
;
adjust_RVA:	cmp	[edi],esi
		jc	.no_increase
		add	[edi],ebx			;adjust RVA
.no_increase:	ret

fix_import_table:test	dword [eax],80000000h
		jnz	.next_entry
		cmp	[eax],esi
		jc	.next_entry
		add	[eax],ebx			;fix RVA
.next_entry:	add	eax,byte 4
.enter:		cmp	dword [eax],byte 0				
		jnz	fix_import_table
.exit:		ret

fix_export_table:cmp	[eax],esi
		jc	.next_entry
		add	[eax],ebx			;adjust RVA
.next_entry:	add	eax,byte 4
		dec	ecx				;Last Entry
		jnz	fix_export_table 
.exit:		ret

fix_iat:	cmp	[eax],esi
		jc	.next_entry
		add	[eax],ebx			;adjust RVA
.next_entry:	add	eax,4
		dec	ecx				;Last Entry
		jnz	fix_iat 
.exit:		ret
;           				
;-------------------------------------------------------
;	Move Data				30.08.99
;               			      	v1.01
;       -> eax = lpData
;	   ebx = Distance in Bytes
;	   ecx = Size of Data to move
;       <-
;
;	JOB: Move data up or down. The gap is filled 
;	     0h bytes
;       USED:
;       NOTE:					
;-------------------------------------------------------
; 
move_data:	push_edi_esi
		xchg	esi,eax
		mov	edi,esi
		add	edi,ebx
		cmp	edi,esi				
		jc	.forward
		
.backward:	std
		add	edi,ecx
		add	esi,ecx
		dec	edi
		dec	esi
		not	ebx				;Make ebx negativ
		inc	ebx				;

.forward:	rep	movsb

		not	ebx
		inc	ebx
		mov	ecx,ebx
		xor	eax,eax
		rep	stosb				;Fill up with 0 bytes		

.exit		cld
		pop_esi_edi
		ret
;           				
;-------------------------------------------------------
;	fix OT Physical Offsets			30.08.99
;               			      	v1.01b
;       -> eax = lpOT Entry
;	   ebx = Distance
;       <- eax = Physical Offset
;	   ebx = Distance
;
;	JOB:
;       USED:
;       NOTE: lpObjectTableStart must be initialized
;	      lpObjectTableEnd must be initialized					
;-------------------------------------------------------
;
fix_OT_phys_offsets:
		add	[eax+OT_PhysicalOffset],ebx	;Shift up OT Entry
		add	eax,IMAGE_OBJECT_TABLE_size	
		cmp	[lpObjectTableEnd],eax
		jnc	fix_OT_phys_offsets	
		ret 	
;           				
;-------------------------------------------------------
;	RVA_to_A				23.06.99
;               				v1.11	      
;       -> eax = RVA
;       <- eax = A
;	   ebx = lp to Object-Table of section
;
;	JOB: Convert RVA to Absolut Address
;       USED:eax,ebx
;       NOTE: eax = 0 on error
;	      lpObjectTableAddress must be initialized
;	      lpMapAddress must be initialized					
;-------------------------------------------------------
; 
rva_to_a:	call	rva_to_ra
		or	eax,eax
		jz	.exit
		add	eax,[lpMapAddress]
.exit:		ret
;           				
;-------------------------------------------------------
;	A_to_RVA
;               				v1.1b	      
;       -> eax = RA
;       <- eax = RVA
;	   ebx = lp to Object-Table of section
;
;	JOB: Convert RA to RVA
;       USED:eax,ebx,ecx
;       NOTE: lpObjectTableAddress must be initialized
;	      eax = 0 on error					
;-------------------------------------------------------
;
a_to_rva:	sub	eax,[lpMapAddress]
		call	ra_to_rva
.exit:		ret
;           				
;-------------------------------------------------------
;	RVA_to_RA
;               			      	v1.11
;       -> eax = RVA
;       <- eax = RA
;	   ebx = lp to Object-Table of section
;
;	JOB: Convert RVA to RA
;       USED:eax,ebx,ecx
;       NOTE: lpObjectTableAddress must be initialized					
;-------------------------------------------------------
; 
rva_to_ra:	mov	ebx,eax
		call	get_ot_by_rva
		jeaxz	.error
		sub	ebx,dword [eax+OT_RVA]
		add	ebx,dword [eax+OT_PhysicalOffset]
		xchg	ebx,eax
.error:		ret 
;           				
;-------------------------------------------------------
;	RA_to_RVA
;               			  	v1.1b   
;       -> eax = RA
;       <- eax = RVA
;	   ebx = lp to Object-Table of section
;
;	JOB: Convert RA to RVA
;       USED:eax,ebx,ecx
;       NOTE: lpObjectTableAddress must be initialized					
;-------------------------------------------------------
;
ra_to_rva:	mov	ebx,eax
		call	get_ot_by_ra
		jeaxz	.error
		sub	ebx,dword [eax+OT_PhysicalOffset]
		add	ebx,dword [eax+OT_RVA]
		xchg	ebx,eax
.error:		ret 
;           				
;-------------------------------------------------------
;	get_ot_by_name				27.07.99
;               			      	v1.03b
;       -> eax = lpName	
;       <- eax = lpOT_Entry
;
;	JOB: Get lp to ObjectTable with specified name 
;       USED:
;       NOTE: eax = 0 on error
;-------------------------------------------------------
;
get_ot_by_name: push_edi_esi
		mov	edx,eax
		call	scan_for_0h		
		mov	ebx,[lpObjectTableStart]
.next_section:	mov	edi,ebx
		mov	esi,edx				;restore lpName
		mov	ecx,eax
		repz	cmpsb
		jecxz	.exit
		add	ebx,byte IMAGE_OBJECT_TABLE_size
		cmp	[lpObjectTableEnd],ebx
		jnc	.next_section
.error:		xor	ebx,ebx
.exit:		xchg	eax,ebx
		pop_esi_edi
		ret
;           				
;-------------------------------------------------------
;	get_ot_by_rva				24.07.99
;               			      	v1.03b
;       -> eax = RVA	
;       <- eax = lpOT_Entry
;
;	JOB: Get lp to ObjectTable Entry of Section 
;	     where eax is pointing to.
;       USED:
;       NOTE: eax = 0 on error
;-------------------------------------------------------
;
get_ot_by_rva:	jeaxz	.error
		xchg	edx,eax
		mov	eax,[lpObjectTableStart]
		cmp	edx,dword [eax+OT_RVA]		;RVA points to location before
		jc	.error				; first section
.next_section:	mov	ecx,dword [eax+OT_RVA]
		add	ecx,dword [eax+OT_VirtualSize]
		cmp	edx,ecx
		jc	.exit
		add	eax,byte IMAGE_OBJECT_TABLE_size
		cmp	[lpObjectTableEnd],eax
		jnc	.next_section		
.error:		xor	eax,eax
.exit:		ret
;           				
;-------------------------------------------------------
;	get_ot_by_ra				24.07.99
;               			      	v1.03b
;       -> eax = RA
;       <- eax = lpOT_Entry
;
;	JOB: Get lp to ObjectTable Entry of Section 
;	     where eax is pointing to.
;       USED:
;       NOTE: eax = 0 on error
;-------------------------------------------------------
;
get_ot_by_ra:	xchg	edx,eax
		mov	eax,[lpObjectTableStart]
		cmp	edx,dword [eax+OT_PhysicalOffset];RA points to location before
		jc	.error				; first section
.next_section:	mov	ecx,dword [eax+OT_PhysicalOffset]
		add	ecx,dword [eax+OT_PhysicalSize]
		cmp	edx,ecx
		jc	.exit
		add	eax,byte IMAGE_OBJECT_TABLE_size
		cmp	[lpObjectTableEnd],eax
		jnc	.next_section		
.error:		xor	eax,eax
.exit:		ret
;           				
;-------------------------------------------------------
;	align_eax				30.05.99
;               			      
;       -> eax = Number to align
;	   ebx = size of alignment
;       <- eax = aligned number
;	   ebx = size of alignment
;
;	JOB:  Round number to multiple of ebx
;       USED: eax,ebx,edx
;       NOTE: slow !!				
;-------------------------------------------------------
; 
align_eax:	xor	edx,edx
		or	ebx,ebx
		jz	.exit
		div	ebx
		or	edx,edx
		jz	.no_increase
		inc	eax
.no_increase:	mul	ebx
.exit:		ret	
;           				
;-------------------------------------------------------
;	hexchar_to_b				24.07.99
;               			      	v1.03
;       -> al = char
;       <- al = byte value (low nibble)
;
;	JOB: convert a hexchar to
;	     byte value 
;       USED:eax
;       NOTE:stc on error
;	     big and small letters can be used
;-------------------------------------------------------
; 	
hexchar_to_b:	sub	al,30h				;convert number to bytevalue
		cmp	al,0Ah				;was it a letter
		jc	.exit
		sub	al,7h				;convert big letter to bytevalue
		cmp	al,10h
		jc	.exit
		sub	al,20h				;convert small letter to bytevalue
		cmp	al,10h
		jnc	.error
.exit:		clc
		ret
.error:		stc			
		ret
;           				
;-------------------------------------------------------
;	b_to_hexchar		      		27.07.99		
;               			     	v1.0b
;       -> al = Byte Value
;	   ax = hexchar
;       <- 
;	JOB: Convert byte to hex value in ascii
;       USED: eax
;	NOTE:				
;-------------------------------------------------------
; 			    
b_to_hexchar:	mov	ah,al
		and	al,0Fh				;Mask out high nibble
		cmp	al,0Ah
		jc	.number2
		add	al,7
.number2:	add	al,30h
		xchg	al,ah	
		shr	al,4
		cmp	al,0Ah				
		jc	.number
		add	al,7				
.number:	add	al,30h		
		ret
;           				
;-------------------------------------------------------
;	is PE					30.08.99
;               			      	v1.0
;       -> eax = lpMapAddress 
;       <-
;
;	JOB: Test if the memmapped file is an PE file
;       USED: eax
;       NOTE: eax = 0 on error					
;
;-------------------------------------------------------
; 
is_PE:		cmp	[eax],word MZ_SIGNATURE
		jnz	.error
		add	eax,[eax+MZ_PEHeaderBase]
		cmp	[eax],dword PE_SIGNATURE
		jz	.exit
.error		xor	eax,eax
.exit		ret		
;
;=======================================================================================
;
;	DATA
;
;=======================================================================================
;
SECTION .data
cHelp			db	"Modify PE v0.81 <c> 1999 metheus",CR,LF
			db	"Syntax: ModifyPE file [operation] [switches]",CR,LF,LF
			db	" SWITCHES",CR,LF			
			db	" -c                            Checksum File",CR,LF
			db	" -C                            Print Credits",CR,LF
			db	" -p                            Prevent Padding of Last Section",CR,LF
			db	" -v                            Verbose Output",CR,LF
			db	LF
			db	" OPERATIONS                    Only one can be used",CR,LF
			db	" -a sectionname length         Add Physical Space",CR,LF
			db	" -A sectionname length         Add Virtual Space",CR,LF
			db	" -d sectionname length         Delete Physical Space",CR,LF
			db	" -D sectionname length         Delete Virtual Space",CR,LF
			db	" -r alignment                  Realign Physical",CR,LF
			db	" -R alignment                  Realign Virtual",CR,LF
			db	LF						
			db	" offset is relativ to Image Base",CR,LF
			db	" all number are to be entered and read in hex, of course ;)",CR,LF
			db	"       e.g 12babe",CR,LF,0
cCredits		db	LF,"GREETS FLY TO:",CR,LF,LF
			db	" ElyZa",CR,LF,LF,0
cVerboseCredits		db	LF,"GREETS GO TO:",CR,LF,LF
			db	" arcTEUS",CR,LF
			db	" JonMatrix [MOM]",CR,LF
			db	" ElyZa [ERASMUS]",CR,LF
			db	" Zimoana [ERASMUS]",CR,LF			
			db	" Bakuryu [GOLDEN HARVEST]",CR,LF
			db	" Yuen Bao [GOLDEN HARVEST]",CR,LF
			db	" Fong Sai Yuk [GOLDEN HARVEST]",CR,LF		
			db	" and all hardcore asm coders",CR,LF,LF,0
cChecksumCalculated	db	"Checksum calulated :",0
cVirtualSize		db	"Virtual Size :",0
cVirtualSizeIncrease	db	"Increased by :",0
cPhysicalSize		db	"Physical Size:",0
cPhysicalSizeIncrease	db	"Increased by :",0
cSuccess		db	"No Error occurred, have a nice day",CR,LF,0
cNoStdhandleError	db	"Could not get StdHandle",CR,LF,0
cNoTempPathError	db	"Could not get TempPath",CR,LF,0
cNoFileMoveError	db	"Could not open file",CR,LF,0
cNoInFileOpenError	db	"Could not open/map input file modifype.tmp",CR,LF,0
cNoOutFileOpenError	db	"Could not create output file",CR,LF,0
cInvalidParameterError	db	"Invalid Parameter, type ModifyPE to get help",CR,LF,0
cInvalidLengthError	db	"Specified length exceeds length of section",CR,LF,0
cSectionNotFoundError	db	"Could not find section",CR,LF,0
cInvalidNumberError	db	"Length is invalid",CR,LF,0
cInvalidAlignmentError	db	"Alignment is invalid",CR,LF,0
cNameTooLongError	db	"Sectionname is too long",CR,LF,0
cInvalidOffsetError	db	"Offset does not point into a Section",CR,LF,0
cInvalidFileError	db	"File is not a PE File",CR,LF,0
cFatalError		db	"Fatal Error, file is now probably corrupted",CR,LF,0
cNextLine		db	CR,LF,0
cTempFile		db	"modifype.tmp",0
cHexstringBuffer	db	"00000000",0
lpParamTable		dw	"-c"
			dd	switch_on_checksum
			dw	"-C"
			dd	switch_on_credits
			dw	"-p"
			dd	switch_off_padding
			dw	"-v"
			dd	switch_on_verbose
			dw	"-a"			;add_virtual_space
			dd	get_section_length
			dw	"-A"			;add_physical_space
			dd	get_section_length
			dw	"-d"			;delete_virtual_space
			dd	get_section_length
			dw	"-D"			;delete_physical_space
			dd	get_section_length
			dw	"-r"
			dd	get_alignment
			dw	"-R"
			dd	get_alignment						
			dw	0FFFFh

lpModeTable		dw	"-a"
			dd	add_physical_space
			dw	"-A"
			dd	add_virtual_space
			dw	"-d"
			dd	delete_physical_space
			dw	"-D"
			dd	delete_virtual_space
			dw	"-r"
			dd	realign_physical
			dw	"-R"
			dd	realign_virtual			
			dw	0FFFFh
					
;
;=======================================================================================
;
;	VIRTUAL DATA (initialized to zero)
;
;=======================================================================================
;
SECTION	.bss
init_data_start:
dChecksum		resd	1
dVirtualSize		resd	1
dVirtualSizeIncrease	resd	1
dPhysicalSize		resd	1
dPhysicalSizeIncrease	resd	1
dParamLength		resd	1				;Size entered by user
dParamOffset		resd	1				;Offset entered by user
dParamAlignment		resd	1
dSwitches		resd	1
init_data_end:

INIT_DATA_SIZE		EQU	init_data_end-init_data_start
;
;=======================================================================================
;
;	VIRTUAL DATA (uninitialized)
;
;=======================================================================================
;
hFile			resd	1				;File Handle Input File
hFileMappingObject	resd	1
hStdOutput		resd	1
nParameter		resd	1
nPESections		resd	1
dBytesWritten		resd	1
dOldImageSize		resd	1

hFile2			resd	1				;File Handle Output File

cMode			resw	1				;Operation Mode		
lpMapAddress		resd	1
lpPEHeader		resd	1
lpObjectTableStart	resd	1				;First OT Entry
lpObjectTableEnd	resd	1				;Last OT Entry
lpCommandLine		resd	1				
lpParameters		times	MAX_PARAMETERS*COMMAND_LINE_PARAMETER_size resb 1

FileInfo		times 	BY_HANDLE_FILE_INFORMATION_size resb 1
cFileName		times 	MAX_PATH resb 1
cTempFileName		times	MAX_PATH resb 1	
cSectionName		resb	8	
;
;=======================================================================================
;
;	EQUs
;
;=======================================================================================
;

;
;	Command Line Switches
;
SWITCH_ON_CREDITS		EQU	1h
SWITCH_ON_CHECKSUM		EQU	2h
SWITCH_OFF_PADDING		EQU	4h
SWITCH_ON_VERBOSE		EQU	8h

