      .386
      option casemap :none  ; case sensitive
      
.code


;=========================================================================
; Converting qword value (adress - Fval) into string (adress - Simb)
;  Nsppo - number of symbols post point
;========================================================================= 
CONVBS64 PROC  Fval: DWORD , Simb: DWORD , Nsppo: BYTE

      pushad
      
      m2m curabt,Simb
      mov edi,Simb
      mov byte ptr[edi],"#"     ;sign of error
      mov ecx,80
Simb0:                          ;writing zeroes into Simb                          
      inc edi
      mov byte ptr[edi],0
      loop Simb0
                   
      mov esi,Fval
      mov eax,dword ptr [esi]
      mov s2,eax
      mov eax,dword ptr [esi+4]
      mov s1,eax
      
      mov edi,curabt
      cmp eax,0
      je zero
      and eax,0FFFFFFFFh
      cmp eax,0BFF00000h
      je edinm
      mov eax,s1
      and eax,0FFFFFFFFh
      cmp eax,03FF00000h
      je edin
      jmp ins2
zero:      
      mov byte ptr[edi],30h          ;Fval=0  
      jmp sm5
edinm:     
      mov byte ptr[edi],"-"
      inc edi
      mov byte ptr[edi],31h          ;Fval=-1 
      jmp sm5
edin:     
      mov byte ptr[edi],31h          ;Fval=1
      jmp sm5
      
ins2:      
      
      mov eax,s1
      and eax,80000000h
      mov sign,eax
      cmp eax,80000000h
      jne insign
      mov edi,Simb
      mov byte ptr[edi],"-"           ;Fval is negative
      inc edi
      mov curabt,edi
insign:       

      
      mov eax,s1
      and eax,40000000h
      mov signlm,eax             ;sign of order mantissa 
      
      mov eax,s1
      and eax,3FF00000h
      ror eax,20
      mov levma,eax             ;order of mantissa
      cmp signlm,40000000h
      je inlevma
      mov eax,3FFh
      sub eax,levma
      mov levma,eax
inlevma:      

      mov eax,s1                 ;assemble of mantissa for Fval >  1      
      and eax,000FFFFFh          ;                         Fval < -1  
      rol eax,12
      mov mantsav,eax
      mov eax,s2
      and eax,0FFF00000h
      ror eax,20
      or eax,mantsav
      mov mantsav,eax
      
      mov eax,s2                 ;assemble of mantissa for Fval < 1 
      and eax,0FFFFFh            ;                         Fval > -1 
      rol eax,12
      mov mantsav1,eax
      
      cmp signlm,40000000h                           
      jne apointf                            ;   2 > Fval > -2      
      mov eax,080000000h
      mov ebx,080000000h
      mov ecx,levma
      cmp ecx,0
      je wwmask
loopwm:                            ;making mask (wmask) for integer
      ror eax,1                    ;part of mantissa 
      or ebx,eax
      loop loopwm
wwmask:
      mov wmask,ebx
inwmask:
      
      mov eax,mantsav             ;making integer part (ipart)
      and eax,wmask               ;of mantissa 
      mov ecx,31
      sub ecx,levma
      ror eax,cl
      mov ipart,eax
      mov eax,1
      mov ecx,levma
      inc ecx
      rol eax,cl
      or eax,ipart
      mov ipart,eax
      
      invoke wsprintf, ADDR bufsif1, ADDR formatipart,ipart,ipart  ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1

      mov edi,curabt
      mov eax,ipart
csint:                      ;converting ipart into string      
      mov w3,eax            ;(first passage) 
      xor edx,edx
      div D10
      mov w3,eax
      mov w4,edx
      add dl,30h
      mov byte ptr[edi],dl
      inc edi
      cmp w3,0
      jne csint 
      mov byte ptr[edi],"."
      inc edi
      mov curabt,edi
      dec edi
      dec edi
      mov eax,ipart
csint1:                     ;converting ipart into string      
      mov w3,eax            ;(second passage)
      xor edx,edx
      div D10
      mov w3,eax
      mov w4,edx
      add dl,30h
      mov byte ptr[edi],dl
      dec edi
      cmp w3,0
      jne csint1
      
      mov eax,01h        ;making mask (wmask) for excluding 
      mov ebx,01h        ;fractional part of mantissa from mantsav 
      mov ecx,32
      sub ecx,levma
      dec ecx
      dec ecx
loopwm1:
      rol eax,1
      or eax,ebx
      loop loopwm1
      mov wmask1,eax
      mov eax,mantsav
      and eax,wmask1
      
      mov ecx,levma            ;shifting fractional part of 
      inc ecx                  ;mantissa to the left border 
      mov ebx,080000000h       ;and adding bits from mantsav1 
      mov wmask2,ebx           ;to the end 
loopwm2:
      rol eax,1
      mov ebx,wmask2
      and ebx,mantsav1
      cmp ebx,0
      je lwm2
      or eax,1
lwm2:
      mov ebx,wmask2
      ror ebx,1
      mov wmask2,ebx
      loop loopwm2            
      mov mantsav,eax 

      mov eax,mantsav
      jmp N1MNDR

apointf:                                  ; 2 > Fval > -2
      mov eax,s1
      mov edi,curabt
      and eax,03FF00000h
      cmp eax,03FF00000h
      jne pdr
      mov byte ptr[edi],"1"               ;Fval=+-1.???????
      inc edi
pdr:
      mov byte ptr[edi],"."
      inc edi
      mov curabt,edi
      
      mov eax,mantsav                    ;shifting mantissa of
      mov ecx,levma                      ;fractional part to the right 
      shr eax,cl                                              
      mov ebx,080000000h
      cmp cl,0
      je N1MNDR
      dec cl
      shr ebx,cl
      or eax,ebx                         ;and adding leading 1  
      
N1MNDR:      
      mov mantdr,eax                     ;making sumdr= 
      mov eax,0                          ;+apoint[i]*b[i]   i=1,23 
      mov sumdr,eax                      ;b[i] - value of bit i of mantissa 
      mov esi, offset apoint             ;fractional part 
      mov ebx,080000000h
      mov ecx,23
loopsudr:
      mov eax,mantdr
      and eax,ebx
      cmp eax,0
      je consudr
      mov eax,dword ptr[esi]
      add sumdr,eax
consudr:   
      inc esi      
      inc esi      
      inc esi      
      inc esi 
      shr ebx,1
      loop loopsudr     

      mov edi,curabt
      mov eax,sumdr
      add edi,8
csfra1:                     ;converting sumdr in string      
      mov w3,eax
      xor edx,edx
      div D10
      mov w3,eax
      mov w4,edx
      add dl,30h
      mov byte ptr[edi],dl
      dec edi
      cmp w3,0
      jne csfra1
cs0:  cmp edi,curabt
      jl imsu
      mov al,"0"            ;adding leading zero in fractional
      mov byte ptr[edi],al  ;part of string
      dec edi
      jmp cs0
imsu:
      mov al,Nsppo
      add edi,eax
      mov esi,edi
      mov bl,byte ptr[edi]
      mov byte ptr[edi],0       ;cutting off symbols fractional part
      cmp bl,35h
      jl end_round               ;not rounding
      dec edi
cicl_round:                      ;rounding       
      mov al,byte ptr[edi]
      inc al
      cmp al,3Ah
      je c_r1
      mov byte ptr[edi],al
      jmp end_round
c_r1:      
      mov byte ptr[edi],30h
      cmp edi,Simb
      je sh_str
      dec edi
      cmp byte ptr[edi],"-"
      je sh_str
      cmp byte ptr[edi],"."
      jne cicl_round
      cmp edi,Simb
      je sh_str
      dec edi
      cmp byte ptr[edi],"-"
      je sh_str
      jmp cicl_round
sh_str:
      mov al,byte ptr[esi]
      inc esi
      mov byte ptr[esi],al
      dec esi
      dec esi
      cmp esi,Simb
      jl wlround
      cmp byte ptr[esi],"-"
      jne sh_str
wlround:
      inc esi
      mov byte ptr[esi],"1"      
            
end_round:  


sm5:
      mov edi, offset bufsif
      mov byte ptr[edi],0
      invoke wsprintf, ADDR bufsif1, ADDR formats2,s2   ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formats1,s1
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatzv,sign   ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatslm,signlm   ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatlm,levma      ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatms,mantsav       ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatms1,mantsav1
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatwmsk,wmask    ;for debugging
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatdd,w3,w4 
      invoke lstrcat,offset bufsif,offset bufsif1
 ;    invoke SendMessage, hEdit5, WM_SETTEXT,NULL, ADDR bufsif
      
      mov edi, offset bufsif
      mov byte ptr[edi],0
      invoke wsprintf, ADDR bufsif1, ADDR formatwmsk1,wmask1
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatmsdr,mantsav
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatwmsk2,wmask2
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatmd,mantdr,sumdr
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatkspp,kspp
      invoke lstrcat,offset bufsif,offset bufsif1
;     invoke SendMessage, hEdit7, WM_SETTEXT,NULL, ADDR bufsif
      
      popad
         RET
CONVBS64  ENDP






;=========================================================================
; Converting string(adress - Simb1) into qword value (adress - Fval1) 
;========================================================================= 
CONVSB64 PROC  Fval1: DWORD , Simb1: DWORD , Nsppo1: BYTE

      pushad

      mov s1,0
      mov s2,0
      mov edi,Simb1
      mov asimb1,edi
      mov lenbsb,0
clenbsb:                       ;counting lenbsb
      cmp byte ptr[edi],0
      je olenbsb
      inc lenbsb
      inc edi
      jmp clenbsb
olenbsb: 
      cmp lenbsb,0
      je wrs1s2
      mov edi,Simb1
      cmp byte ptr[edi],"-"
      jne positivsb
      mov s1,080000000h        ;Fval1 is negative            
      cmp lenbsb,1
      je wrzero
      inc edi
positivsb:
      mov lintsb,0
      mov bintsb,edi
cclisb:      
      cmp byte ptr[edi],0      ;counting lintsb
      je occlisb
      cmp byte ptr[edi],"."
      je occlisb
      inc lintsb
      inc edi
      jmp cclisb 
occlisb:
      mov apoisb,0
      mov edi,bintsb
sepoi:                         ;defining apoisb
      cmp byte ptr[edi],0
      je osepoi
      cmp byte ptr[edi],"."
      je wapoi
      inc edi
      jmp sepoi
wapoi:
      mov apoisb,edi
osepoi:
      mov lifrasb,0
      m2m afrasb,apoisb
      mov edi,afrasb
      cmp apoisb,0
      je oclfrasb
      inc afrasb
clfrasb:                      ;counting lifrasb
      inc edi
      cmp byte ptr[edi],0
      je oclfrasb
      inc lifrasb
      jmp clfrasb
oclfrasb:      
      mov ipartsb,0         ;prepare for counting ipartsb
      mov w1,1              
      cmp lintsb,0
      je ocipartsb
      mov edi,bintsb
      add edi,lintsb
cipartsb:
      dec edi
      xor eax,eax
      mov al,byte ptr[edi]
      cmp al,30h
      jb ccipartsb          ; < "0"  
      cmp al,39h
      ja ccipartsb          ; > "9"
      sub al,30h
      imul w1
      add ipartsb,eax
      mov eax,D10
      imul w1
      mov w1,eax
ccipartsb:      
      cmp edi,bintsb
      jne cipartsb
             
ocipartsb:

      mov fpartsb,0         ;prepare for counting fpartsb
      mov w1,100000000              
      cmp lifrasb,0
      je ocfpartsb
      mov edi,afrasb
      mov ecx,lifrasb
cfpartsb:
      xor eax,eax
      mov al,byte ptr[edi]
      cmp al,30h
      jb ccfpartsb          ; < "0"  
      cmp al,39h
      ja ccfpartsb          ; > "9"
      sub al,30h
      imul w1
      add fpartsb,eax
      xor edx,edx
      mov eax,w1
      idiv D10
      mov w1,eax
ccfpartsb:      
      inc edi
      loop cfpartsb
             
ocfpartsb:

      mov fmantsb,0           ;prepare for defining fmantsb
      mov w1,0
      mov esi,offset apoint
      mov ebx,080000000h
      mov ecx,23
cfmantsb:
      mov eax,w1
      add eax,dword ptr[esi]
      cmp eax,fpartsb
      ja cocfmantsb
      mov w1,eax
      mov eax,fmantsb
      or eax,ebx
      mov fmantsb,eax
cocfmantsb:      
      inc esi
      inc esi
      inc esi
      inc esi
      ror ebx,1
      loop cfmantsb
ocfmantsb:

      cmp ipartsb,0
      ja nonzero
      cmp fmantsb,0
      ja nonzero
wrzero:                       ; Fval1=0
      mov s1,0
      mov s2,0
      jmp wrs1s2

nonzero:
      cmp ipartsb,1
      jne nonedin
      cmp fmantsb,0
      jne nonedin
      mov ebx,03FF00000h      ;Fval=+-1
      or s1,ebx
      jmp wrs1s2

nonedin:

      cmp fmantsb,0
      je ocfmantsbl
      m2m fmantsbl,fmantsb
      mov ksdsbl,0
cfmantsbl:                      ;shifting fmantsb to the left edge
      mov eax,fmantsbl
      and eax,080000000h
      cmp eax,080000000h
      je ocfmantsbl
      shl fmantsbl,1
      inc ksdsbl
      jmp cfmantsbl
ocfmantsbl:

      cmp ipartsb,0
      ja valb1
      mov eax,3FEh              ;Fval < 1       
      sub eax,ksdsbl
      mov ordmant,eax
      mov eax,ordmant
      shl eax,20
      or eax,s1
      mov ebx,fmantsbl
      shl ebx,1
      shr ebx,12
      or eax,ebx
      mov s1,eax
      jmp wrs1s2

valb1:                          ;Fval1 > 1

      m2m ipartsbl,ipartsb
      mov ordmanti,30
cipartsbl:                      ;shifting ipartsb to the left edge
      mov eax,ipartsbl
      and eax,080000000h
      cmp eax,080000000h
      je ocipartsbl
      shl ipartsbl,1
      dec ordmanti
      jmp cipartsbl
ocipartsbl:

      cmp ipartsb,1
      ja fordvb1
      mov eax,03FF00000h
      or s1,eax
      jmp anfpartsb
fordvb1:      
      mov eax,ordmanti                     
      shl eax,20
      or eax,s1
      mov ebx,ipartsbl
      shl ebx,1
      shr ebx,12
      or eax,ebx
      or eax,040000000h
      mov s1,eax

anfpartsb:   
      cmp fpartsb,0
      je wrs1s2               ;Fval = integer only

      mov ecx,12              ;making fmants1 
      add ecx,ordmanti
      add ecx,1
      m2m fmants1,fmantsb
      shr fmants1,cl
      mov eax,s1              ;adding fmants1 into s1
      or eax,fmants1
      mov s1,eax

      mov ecx,19              ;making fmants2
      sub ecx,ordmanti
      m2m fmants2,fmantsb
      shl fmants2,cl
      m2m s2,fmants2          ;adding fmants2 into s2
      

wrs1s2:
      mov esi,Fval1
      mov eax,s2
      mov dword ptr[esi],eax
      inc esi
      inc esi
      inc esi
      inc esi        
      mov eax,s1
      mov dword ptr[esi],eax        
      

indsb64:
      mov edi, offset bufsif
      mov byte ptr[edi],0
      invoke lstrcat,offset bufsif, Simb1
      invoke wsprintf, ADDR bufsif1, ADDR formatassb,asimb1
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatbsb,lenbsb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatblsb,bintsb,lintsb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatposb,apoisb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatfrsb,afrasb,lifrasb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatipsb,ipartsb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatfpsb,fpartsb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatfmsb,fmantsb
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formats1,s1
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formats2,s2   
      invoke lstrcat,offset bufsif,offset bufsif1
;     invoke SendMessage, hEdit8, WM_SETTEXT,NULL, ADDR bufsif
      mov edi, offset bufsif
      mov byte ptr[edi],0
      invoke wsprintf, ADDR bufsif1, ADDR formatfmsbl,fmantsbl   
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatksd,ksdsbl   
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatordm,ordmant   
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatipsbl,ipartsbl   
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatordmi,ordmanti   
      invoke lstrcat,offset bufsif,offset bufsif1
      invoke wsprintf, ADDR bufsif1, ADDR formatms12,fmants1,fmants2
      invoke lstrcat,offset bufsif,offset bufsif1
 ;    invoke SendMessage, hEdit9, WM_SETTEXT,NULL, ADDR bufsif 

      popad
         RET
CONVSB64  ENDP



;========================================================================
; Converting  qword value (adress - Fval1) into integer dd (Ival) 
;========================================================================= 
CONVQWINT PROC  Fval2: DWORD , Ival: DWORD 

      pushad

      mov esi,Fval2
      FLD qword ptr[esi]
      FLD qw2
      FADDP ST(1),ST
      FSTP wcnvq
     
      mov esi, offset wcnvq
      mov eax,dword ptr [esi]
      mov s2i,eax
      mov eax,dword ptr [esi+4]
      mov s1i,eax

      mov eax,s1i
      and eax,40000000h
      mov signlm,eax             ;sign of order mantissa 
      
      mov eax,s1i
      and eax,3FF00000h
      ror eax,20
      mov levma,eax             ;order of mantissa
      cmp signlm,40000000h
      je inlevmai
      mov eax,3FFh
      sub eax,levma
      mov levma,eax
inlevmai:      

      mov eax,s1i                 ;assemble of mantissa for Fval >  1      
      and eax,000FFFFFh          ;                         Fval < -1  
      rol eax,12
      mov mantsav,eax
      mov eax,s2i
      and eax,0FFF00000h
      ror eax,20
      or eax,mantsav
      mov mantsav,eax
      
      mov eax,s2i                 ;assemble of mantissa for Fval < 1 
      and eax,0FFFFFh            ;                         Fval > -1 
      rol eax,12
      mov mantsav1,eax
      
      cmp signlm,40000000h                           
      jne WINTQW                            ;   2 > Fval > -2      
      mov eax,080000000h
      mov ebx,080000000h
      mov ecx,levma
      cmp ecx,0
      je wwmaski
loopwmi:                            ;making mask (wmask) for integer
      ror eax,1                    ;part of mantissa 
      or ebx,eax
      loop loopwmi
wwmaski:
      mov wmask,ebx
inwmaski:
      
      mov eax,mantsav             ;making integer part (ipart)
      and eax,wmask               ;of mantissa 
      mov ecx,31
      sub ecx,levma
      ror eax,cl
      mov ipart,eax
      mov eax,1
      mov ecx,levma
      inc ecx
      rol eax,cl
      or eax,ipart
      mov ipart,eax
      mov intqww,eax
      
      mov eax,01h        ;making mask (wmask) for excluding 
      mov ebx,01h        ;fractional part of mantissa from mantsav 
      mov ecx,32
      sub ecx,levma
      dec ecx
      dec ecx
loopwmi1:
      rol eax,1
      or eax,ebx
      loop loopwmi1
      mov wmask1,eax
      mov eax,mantsav
      and eax,wmask1
      
      mov ecx,levma            ;shifting fractional part of 
      inc ecx                  ;mantissa to the left border 
      mov ebx,080000000h       ;and adding bits from mantsav1 
      mov wmask2,ebx           ;to the end 
loopwmi2:
      rol eax,1
      mov ebx,wmask2
      and ebx,mantsav1
      cmp ebx,0
      je lwmi2
      or eax,1
lwmi2:
      mov ebx,wmask2
      ror ebx,1
      mov wmask2,ebx
      loop loopwmi2            
      mov mantsav,eax 
      and eax,080000000h
      cmp eax,080000000h
      jne WINTQW
      inc intqww
      
      
WINTQW:                          ;writing intqw and exit
      dec intqww
      dec intqww
      mov edi, Ival
      mov eax,intqww
      mov dword ptr[edi],eax      
     
      mov edi, offset bufst
      mov byte ptr[edi],0
      invoke wsprintf, ADDR bufst1, ADDR formats12i,s1i,s2i,mantsav   
      invoke lstrcat,offset bufst,offset bufst1
      .IF pr_debug == 1
        invoke SendMessage, hqwi,WM_SETTEXT,NULL, ADDR bufst
      .ENDIF  
     
      popad
         RET
CONVQWINT ENDP


