
      .386
      .model flat, stdcall  ; 32 bit memory model
      option casemap :none  ; case sensitive

      include pidw.inc        ; local includes for this file
      include formatr.asm     ; formatter subroutines
      include miscel.asm      ; miscelaneous subroutines
      include piobr.asm       ; PI process


.code

start:
      invoke GetModuleHandle, NULL
      mov hInstance, eax

      invoke GetCommandLine
      mov CommandLine, eax

      invoke WinMain,hInstance,NULL,CommandLine,SW_SHOWDEFAULT
      invoke ExitProcess,eax


;===============================================================
WinMain proc hInst     :DWORD,
             hPrevInst :DWORD,
             CmdLine   :DWORD,
             CmdShow   :DWORD


      invoke LoadIcon,hInst,1    ; icon ID
      mov hIcon, eax

      szText szClassName,"bmbtn_Class"
      
; Fill WNDCLASSEX structure with required variables

      mov wc.cbSize,         sizeof WNDCLASSEX     
      mov wc.style,          CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW
      mov wc.lpfnWndProc,    offset WndProc
      mov wc.cbClsExtra,     NULL
      mov wc.cbWndExtra,     NULL
      m2m wc.hInstance,      hInst
      mov wc.hbrBackground,  COLOR_MENUTEXT
      mov wc.lpszMenuName,   NULL
      mov wc.lpszClassName,  offset szClassName
      m2m wc.hIcon,          hIcon
        invoke LoadCursor,NULL,IDC_ARROW
      mov wc.hCursor,        eax
      m2m wc.hIconSm,        hIcon
       
      invoke RegisterClassEx,ADDR wc


      mov Wwd, 800        ; Centre window at following size
      mov Wht, 600

      invoke GetSystemMetrics,SM_CXSCREEN
      invoke TopXY,Wwd,eax
      mov Wtx, eax

      invoke GetSystemMetrics,SM_CYSCREEN
      invoke TopXY,Wht,eax
      mov Wty, eax

      invoke CreateWindowEx,WS_EX_LEFT,
                            ADDR szClassName,
                            ADDR szDisplayName,
                            WS_OVERLAPPED or WS_SYSMENU,
                            Wtx,Wty,Wwd,Wht,
                            NULL,NULL,
                            hInst,NULL
      mov   hWnd,eax


      invoke ShowWindow,hWnd,SW_SHOWNORMAL
      invoke UpdateWindow,hWnd


    StartLoop:                              ; Loop until PostQuitMessage is sent
      invoke GetMessage,ADDR msg,NULL,0,0
      cmp eax, 0
      je ExitLoop
      invoke TranslateMessage, ADDR msg
      invoke DispatchMessage,  ADDR msg
      jmp StartLoop
    ExitLoop:

      return msg.wParam

WinMain endp



;===============================================================================
WndProc PROC uses ebx edi esi, hwnd:DWORD, wmsg:DWORD, wparam:DWORD, lparam:DWORD

    mov eax,wmsg
    cmp eax,WM_CREATE
    je wmcreate 
    cmp eax,WM_COMMAND
    je wmcommand
    cmp eax,WM_PAINT
    je wmpaint
    cmp eax,WM_TIMER
    je wmtimer
    cmp eax,WM_CLOSE
    je wmdestroy
    jmp defwndproc

wmcommand:
    mov eax,wparam
    cmp eax,100              ;LOOK
    je wbms   
    cmp eax,300
    je set_fr1_10                
    cmp eax,301
    je set_fr1_20                
    cmp eax,302
    je set_fr1_4                
    cmp eax,303
    je set_fr0                
    cmp eax,400
    je set_st_frc1        
    cmp eax,401
    je set_st_lrc2        
    invoke Test_gr_bt, hwnd        ;graphic buttons 
    jmp defwndproc

    
wbms:                        ;LOOK                      
    invoke Look_lo
    jmp defwndproc            
 
set_fr1_10:                  ;frequence 1/10 sec
    mov cur_freq,0
    jmp defwndproc

set_fr1_20:                  ;frequence 1/20 sec
    mov cur_freq,1
    jmp defwndproc

set_fr1_4:                   ;frequence 1/4 sec
    mov cur_freq,2
    jmp defwndproc

set_fr0:                     ;frequence 0 sec
    mov cur_freq,3
    jmp defwndproc

set_st_frc1:                 ;set state FRC1
    .IF st_frc1 == 0
     invoke SendMessage, hbfrc1,WM_SETTEXT,NULL, ADDR st_ma
     mov st_frc1,1
     jmp defwndproc
    .ENDIF 
    .IF st_frc1 == 1
     invoke SendMessage, hbfrc1,WM_SETTEXT,NULL, ADDR st_au
     mov st_frc1,0
    .ENDIF 
    jmp defwndproc


set_st_lrc2:                 ;set state LRC2
    .IF st_lrc2 == 0
     invoke SendMessage, hblrc2,WM_SETTEXT,NULL, ADDR st_ma
     mov st_lrc2,1
     jmp defwndproc
    .ENDIF 
    .IF st_lrc2 == 1
     invoke SendMessage, hblrc2,WM_SETTEXT,NULL, ADDR st_au
     mov st_lrc2,0
    .ENDIF 
    jmp defwndproc



wmpaint:
    inc kpaint
    invoke BeginPaint,hwnd,ADDR paintstr 
    mov hdc,eax
    

    invoke CreateFont,18,7,0,0,900,0,0,0,OEM_CHARSET,\
                      OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,\
                      DEFAULT_QUALITY,DEFAULT_PITCH or FF_SCRIPT,\
                      ADDR FontName
    mov retcrf,eax
    invoke SelectObject,hdc,eax
    mov hfont,eax
    invoke SetTextColor,hdc,0FFFFh
    invoke SetBkColor,hdc,0

    invoke Dsp_tex

    invoke Cr_Pens

    invoke Risunok
         
    
    invoke EndPaint,hwnd,ADDR paintstr 
    
    jmp defwndproc                                 ; END PAINT


wmtimer:
     .if wparam == 800  && cur_freq==0
      jmp tim_pro
     .endif
     .if wparam == 801  && cur_freq==1
      jmp tim_pro
     .endif
     .if wparam == 802  && cur_freq==2
      jmp tim_pro
     .endif
     jmp defwndproc

  tim_pro:    
     inc cwmtimer
     .IF pr_debug == 1
       invoke wsprintf, ADDR bufst, ADDR formatcwmt,cwmtimer,cwmtimer1
       invoke SendMessage, hindtm,WM_SETTEXT,NULL, ADDR bufst
       invoke wsprintf, ADDR bufst, ADDR formatngri,n_cur_gr1,n_cur_gr2,n_cur_gr3
       invoke SendMessage, hqwi1,WM_SETTEXT,NULL, ADDR bufst
     .ENDIF 

     invoke GetDC,hwnd
     mov hdc1,eax
     
     invoke PI_OBR, hwnd
     invoke Gr_vari, hwnd      
     invoke Dis_lev, hwnd
     invoke Mark_val,hwnd
     
    
    jmp defwndproc                                 ;END TIMER
    

wmcreate:
     invoke GetSysColor,COLOR_MENU
     mov BackGC,eax

     invoke Cr_fnt, hwnd

     invoke Cr_ed_w, hwnd

     invoke Cr_btn, hwnd
       
     invoke Cr_gr_bt, hwnd
       
     invoke SetTimer,hwnd,800,50,NULL
     mov hTimer1_10,eax 
     invoke SetTimer,hwnd,801,100,NULL
     mov hTimer1_20,eax
     invoke SetTimer,hwnd,802,500,NULL
     mov hTimer1_4,eax

     mov cur_freq,0
 
     mov esi,offset tg1
     mov ebx,dword ptr [esi+8]
     mov n_cur_gr1,ebx
     mov ebx,dword ptr [esi+12]
     mov n_cur_gr2,ebx
     mov ebx,dword ptr [esi+16]
     mov n_cur_gr3,ebx
     mov pri_chg,0
    
     jmp returnP;
    

wmdestroy:
     invoke KillTimer,hwnd,800
     invoke KillTimer,hwnd,801
     invoke PostQuitMessage,NULL
     jmp returnP;
        

defwndproc:
    invoke DefWindowProc,hwnd,wmsg,wparam,lparam
    jmp finish;

returnP: xor eax,eax
finish: RET
    ret

WndProc endp



end start
