      .386
      option casemap :none  ; case sensitive
      
.code

;=========================================================================
;  PI Control                                
;========================================================================= 
PI_OBR PROC hwnd:DWORD  
      pushad

     inc cpi_obr
     invoke GetFocus
     mov focus_cur,eax
       
     mov cpicont,0
;     FLD qw0
;     FSTP sumpiv
  crd_piv:             ;circle of reading 
     imul ecx,cpicont,LFIPER
     mov esi,offset tb1
     add esi,ecx
     inc cpicont
     
     FLD qword ptr [esi+20]
     .IF cpicont == 1
      FSTP pv_frc1
     .ENDIF 
     .IF cpicont == 2
      FSTP sp_frc1
     .ENDIF 
     .IF cpicont == 3
      FSTP mv_frc1
     .ENDIF 
     .IF cpicont == 4
      FSTP p_frc1
     .ENDIF 
     .IF cpicont == 5
      FSTP i_frc1
     .ENDIF 
     .IF cpicont == 6
      FSTP tl_frc1
     .ENDIF 
     .IF cpicont == 7
      FSTP ip_frc1
     .ENDIF 
     .IF cpicont == 8
      FSTP pp_frc1
     .ENDIF 
     .IF cpicont == 9
      FSTP bp_frc1
     .ENDIF 
     .IF cpicont == 10
      FSTP pv_lrc2
     .ENDIF 
     .IF cpicont == 11
      FSTP sp_lrc2
     .ENDIF 
     .IF cpicont == 12
      FSTP mv_lrc2
     .ENDIF 
     .IF cpicont == 13
      FSTP p_lrc2
     .ENDIF 
     .IF cpicont == 14
      FSTP i_lrc2
     .ENDIF 
     .IF cpicont == 15
      FSTP tl_lrc2
     .ENDIF 
     .IF cpicont == 16
      FSTP ip_lrc2
     .ENDIF 
     .IF cpicont == 17
      FSTP pp_lrc2
     .ENDIF 
     .IF cpicont == 18
      FSTP bp_lrc2
     .ENDIF 
     .IF cpicont == 19
      FSTP k_reservoir
     .ENDIF 
     .IF cpicont == 20
      FSTP gv_lrc2
     .ENDIF 

      FLD qword ptr [esi+20]
      FSTP vape
      
;     .IF cpicont != 19
;      FLD qword ptr [esi+20]
;      FLD sumpiv
;      FADDP ST(1),ST
;      FSTP sumpiv
;     .ENDIF 
       
      FLD qword ptr [esi+36]
      FLD qword ptr [esi+28]
      FSUBP ST(1),ST
      FSTP wpiobr1
      FLD vape
      FLD qword ptr [esi+28]
      FSUBP ST(1),ST
      FSTP wpiobr2
      FLD wpiobr2
      FLD wpiobr1
      FDIVP ST(1),ST
      FSTP wpiobr
      FLD wpiobr
      FLD qw250
      FMULP ST(1),ST
      FSTP wpiobr
      invoke CONVQWINT,offset wpiobr, offset intsksut
      mov eax,intsksut
      cmp eax,250
      jl Intsk_L_250
      mov intsksut,250
      jmp PIOBR_HPE
     Intsk_L_250:
      cmp eax,0
      ja PIOBR_HPE
      mov intsksut,0
       
     PIOBR_HPE: 
      mov eax,dword ptr [esi]
      mov hpe,eax
      
      mov ebx,hpen7
      mov eax,cpicont
      .IF eax == n_cur_gr1
       m2m y_cur_gr1,intsksut
      .ENDIF 
      .IF eax == n_cur_gr2
       m2m y_cur_gr2,intsksut
      .ENDIF 
      .IF eax == n_cur_gr3
       m2m y_cur_gr3,intsksut
      .ENDIF
      
      mov eax,dword ptr [esi]
      mov hpe,eax
      .IF eax != focus_cur
        invoke CONVBS64, offset vape, offset bufst,5
        invoke SendMessage, hpe,WM_SETTEXT,NULL, ADDR bufst
      .ENDIF 
        
      mov esi,offset arx_val
      mov eax,cpicont
      imul ebx,eax,800
      dec ebx
      mov ecx,799
    C_ARX_VAL_W:
      dec ebx
      mov al, byte ptr[esi+ebx]
      inc ebx
      mov byte ptr[esi+ebx],al
      dec ebx
      dec ecx
      cmp ecx,0
      ja C_ARX_VAL_W
      xor eax,eax
      mov eax,intsksut
      mov byte ptr[esi+ebx], al    
      
      mov eax,cpicont
      cmp eax,nupe
      jl crd_piv
     
     mov edi, offset bufst
     mov byte ptr[edi],0
     invoke lstrcat,offset bufst,offset formpi_sum
     invoke CONVBS64, offset sumpiv,offset bufst1,6
     invoke lstrcat,offset bufst,offset bufst1
     invoke wsprintf, ADDR bufst1, ADDR formatinq,intsksu,skala
     invoke lstrcat,offset bufst,offset bufst1
     .IF pr_debug == 1
       invoke SendMessage, hpi_deb1,WM_SETTEXT,NULL, ADDR bufst
     .ENDIF  
     
     mov edi, offset bufst
     mov byte ptr[edi],0
     mov esi,offset arx_val
     mov wpiobr2,0
   C_IND_ARX:
     xor eax,eax
     mov al,byte ptr[esi+4800]
     mov wpiobr3,eax 
     invoke wsprintf, ADDR bufst1, ADDR format_arx,wpiobr3
     invoke lstrcat,offset bufst,offset bufst1
     inc esi
     inc wpiobr2
     cmp wpiobr2,25
     jb C_IND_ARX

     .IF pr_debug
       invoke SendMessage,hEdit11,WM_SETTEXT,NULL, ADDR bufst
     .ENDIF  

     invoke Formula_pi
    
     mov cpicont,0
  crw_piv:             ;circle of writing 
     imul ecx,cpicont,LFIPER
     mov esi,offset tb1
     add esi,ecx
     inc cpicont
     
     .IF cpicont == 1
      FLD pv_frc1
     .ENDIF 
     .IF cpicont == 2
      FLD sp_frc1
     .ENDIF 
     .IF cpicont == 3
      FLD mv_frc1
     .ENDIF 
     .IF cpicont == 4
      FLD p_frc1
     .ENDIF 
     .IF cpicont == 5
      FLD i_frc1
     .ENDIF 
     .IF cpicont == 6
      FLD tl_frc1
     .ENDIF 
     .IF cpicont == 7
      FLD ip_frc1
     .ENDIF 
     .IF cpicont == 8
      FLD pp_frc1
     .ENDIF 
     .IF cpicont == 9
      FLD bp_frc1
     .ENDIF 
     .IF cpicont == 10
      FLD pv_lrc2
     .ENDIF 
     .IF cpicont == 11
      FLD sp_lrc2
     .ENDIF 
     .IF cpicont == 12
      FLD mv_lrc2
     .ENDIF 
     .IF cpicont == 13
      FLD p_lrc2
     .ENDIF 
     .IF cpicont == 14
      FLD i_lrc2
     .ENDIF 
     .IF cpicont == 15
      FLD tl_lrc2
     .ENDIF 
     .IF cpicont == 16
      FLD ip_lrc2
     .ENDIF 
     .IF cpicont == 17
      FLD pp_lrc2
     .ENDIF 
     .IF cpicont == 18
      FLD bp_lrc2
     .ENDIF 
     .IF cpicont == 19
      FLD k_reservoir
     .ENDIF 
     .IF cpicont == 20
      FLD gv_lrc2    
     .ENDIF 
     FSTP qword ptr[esi+20]
      
     mov eax,cpicont
     cmp eax,nupe
     jl crw_piv
     
     popad
     RET
PI_OBR ENDP




;=========================================================================
;  Graphics of variables                                
;========================================================================= 
Gr_vari PROC hwnd:DWORD  
      pushad

      invoke SelectObject,hdc1,hpen7
      invoke MoveToEx,hdc1,790,321,NULL
      invoke LineTo,hdc1,790,572

      mov c_graphi,0
   C_GRAPHICUM:
      mov eax,c_graphi
      .IF eax==0
        m2m intsksu,y_cur_gr1
        m2m intsksul,y_cur_gr1_p
        invoke SelectObject,hdc1,hpen9
      .ENDIF      
      .IF eax==1
        m2m intsksu,y_cur_gr2
        m2m intsksul,y_cur_gr2_p
        invoke SelectObject,hdc1,hpen10
      .ENDIF      
      .IF eax==2
        m2m intsksu,y_cur_gr3
        m2m intsksul,y_cur_gr3_p
        invoke SelectObject,hdc1,hpen11
      .ENDIF      
      
      mov ebx,571
      sub ebx, intsksu
      mov intsksu,ebx

     .IF intsksu != 0
      .IF pri_chg==1
       invoke MoveToEx,hdc1,789,intsksul,NULL
       invoke LineTo,hdc1,790,intsksu    
      .ENDIF
       mov eax,c_graphi
       .IF eax==0
        m2m y_cur_gr1_p,intsksu
       .ENDIF      
       .IF eax==1
        m2m y_cur_gr2_p,intsksu
       .ENDIF      
       .IF eax==2
        m2m y_cur_gr3_p,intsksu
       .ENDIF      
      .ENDIF 

       inc c_graphi     
       mov eax,c_graphi
       cmp eax,3
       jb C_GRAPHICUM
       mov pri_chg,1

      .if backupbitdc ==0
       invoke CreateCompatibleDC,hdc1
       mov backupbitdc,eax
       invoke CreateCompatibleBitmap,hdc1,790,300
       mov backupbit,eax
       invoke SelectObject,backupbitdc,backupbit
      .endif
      invoke BitBlt,backupbitdc,0,321,790,251,hdc1,0,321,SRCCOPY
      invoke BitBlt,hdc1,0,321,790,251,hdc1,1,321,SRCCOPY
      invoke ReleaseDC,hwnd,hdc
     
      popad
      RET
Gr_vari ENDP


;=========================================================================
;                                            
;========================================================================= 
Formula_pi PROC             
      pushad

      .IF st_frc1 == 1
       FLD pv_frc1
       FSTP sp_frc1
      .ENDIF

      .IF st_lrc2 == 1
       FLD pv_lrc2
       FSTP sp_lrc2
      .ENDIF


      .IF st_frc1 == 0       
          FLD spf1p             ;FRC1 in automatic   
          FCOMP sp_frc1
          FSTSW ax
          sahf
          jne IN_PI_FRC1
          mov eax,st_frc1
          cmp eax,sklfrc1p
          je IN_FRC1_C
         IN_PI_FRC1:             ;new SP_FRC1 or new state FRC1
          inc ktest
          FLD sp_frc1
          FSTP spf1p
          FLD qw0
          FSTP infrc1p
          FLD mv_frc1
          FSTP outf1p
          m2m sklfrc1p,st_frc1
         IN_FRC1_C: 
          FLD i_frc1
          FCOMP qw0
          FSTSW ax
          sahf
          je I_FRC1_0
          FLD sp_frc1            ;calculating IP_FRC1
          FLD pv_frc1
          FSUBP ST(1),ST
          FLD i_frc1
          FMULP ST(1),ST
          FLD p_frc1
          FMULP ST(1),ST
          FLD infrc1p
          FADDP ST(1),ST
          FSTP ip_frc1
          jmp LIM_I_FRC1
         I_FRC1_0:
          FLD qw0
          FSTP ip_frc1
          FLD qw0
          FSTP infrc1p
         LIM_I_FRC1:  
          invoke Lim_val,offset ip_frc1,qwm100,qw100
          
       FRC1_PP:
          FLD ip_frc1
          FSTP infrc1p
          FLD sp_frc1            ;calculating PP_FRC1
          FLD pv_frc1
          FSUBP ST(1),ST
          FLD p_frc1
          FMULP ST(1),ST
          FSTP pp_frc1
          invoke Lim_val,offset pp_frc1,qwm100,qw100
          
         FRC1_OU:  
          FLD outf1p               ;calculating mv_frc1
          FLD pp_frc1
          FADDP ST(1),ST
          FLD ip_frc1
          FADDP ST(1),ST
          FSTP mv_frc1
          invoke Lim_val,offset mv_frc1,qw0,qw100
      .ENDIF                


      FLD lpv_frc1              ;PV FRC1
      FCOMP mv_frc1
      FSTSW ax
      sahf
      je PRO_LAG1
      FLD mv_frc1               
      FSTP lpv_frc1
      FLD qw1
      FSTP tclag1
      FLD pv_frc1
      FSTP pvl1b
    PRO_LAG1:
      FLD tclag1
      FLD tl_frc1
      FADDP ST(1),ST
      FSTP wcb2
      FLD tclag1
      FLD wcb2
      FDIVP ST(1),ST
      FSTP wcb1
      FLD mv_frc1
      FCOMP pv_frc1
      FSTSW ax
      sahf
      jb MV_L_PV
      FLD mv_frc1      ;MV > PV
      FLD pvl1b
      FSUBP ST(1),ST
      FLD wcb1
      FMULP ST(1),ST
      FLD pvl1b
      FADDP ST(1),ST
      FSTP pv_frc1
      jmp TCLAG1F
   MV_L_PV:   
      FLD pvl1b        ;MV < PV
      FLD mv_frc1
      FSUBP ST(1),ST
      FLD wcb1
      FMULP ST(1),ST
      FSTP wcb2
      FLD pvl1b
      FLD wcb2
      FSUBP ST(1),ST
      FSTP pv_frc1
      jmp TCLAG1F
   TCLAG1F:      
      FLD tclag1           ;tclag1=tclag1+1
      FLD qw1
      FADDP ST(1),ST
      FSTP tclag1

      FLD lpv_frc2              ;PV LRC2
      FCOMP mv_lrc2
      FSTSW ax
      sahf
      je PRO_LAG2
      FLD mv_lrc2               
      FSTP lpv_frc2
      FLD qw1
      FSTP tclag2
      FLD gv_lrc2
      FSTP pvl2b
    PRO_LAG2:
      FLD tclag2
      FLD tl_lrc2
      FADDP ST(1),ST
      FSTP wcb2
      FLD tclag2
      FLD wcb2
      FDIVP ST(1),ST
      FSTP wcb1
      FLD mv_lrc2
      FCOMP gv_lrc2
      FSTSW ax
      sahf
      jb MV_L_PV2
      FLD mv_lrc2      ;MV > PV
      FLD pvl2b
      FSUBP ST(1),ST
      FLD wcb1
      FMULP ST(1),ST
      FLD pvl2b
      FADDP ST(1),ST
      FSTP gv_lrc2
      jmp TCLAG2F
   MV_L_PV2:   
      FLD pvl2b        ;MV < PV
      FLD mv_lrc2
      FSUBP ST(1),ST
      FLD wcb1
      FMULP ST(1),ST
      FSTP wcb2
      FLD pvl2b
      FLD wcb2
      FSUBP ST(1),ST
      FSTP gv_lrc2
      jmp TCLAG2F
   TCLAG2F:      
      FLD tclag2           ;tclag2=tclag2+1
      FLD qw1
      FADDP ST(1),ST
      FSTP tclag2

      mov eax,level_c
      mov level_p,eax
      FLD pv_frc1
      FLD gv_lrc2
      FSUBP ST(1),ST
      FLD k_reservoir
      FMULP ST(1),ST
      FLD pv_lrc2
      FADDP ST(1),ST
      FSTP pv_lrc2
      
      invoke Lim_val,offset pv_lrc2,qw0,qw100
      invoke CONVQWINT,offset pv_lrc2, offset level_c
      mov eax,level_c
      shl eax,1
      mov level_c,eax


      .IF st_lrc2 == 0       
          FLD spf2p             ;LRC2 in automatic   
          FCOMP sp_lrc2
          FSTSW ax
          sahf
          jne IN_PI_LRC2
          mov eax,st_lrc2
          cmp eax,sklfrc2p
          je IN_LRC2_C
         IN_PI_LRC2:             ;new SP_FRC1 or new state FRC1
          FLD sp_lrc2
          FSTP spf2p
          FLD qw0
          FSTP infrc2p
          FLD mv_lrc2
          FSTP outf2p
          m2m sklfrc2p,st_lrc2
         IN_LRC2_C: 
          FLD i_lrc2
          FCOMP qw0
          FSTSW ax
          sahf
          je I_LRC2_0
          FLD pv_lrc2            ;calculating IP_FRC1
          FLD sp_lrc2
          FSUBP ST(1),ST
          FLD i_lrc2
          FMULP ST(1),ST
          FLD p_lrc2
          FMULP ST(1),ST
          FLD infrc2p
          FADDP ST(1),ST
          FSTP ip_lrc2
          jmp LIM_I_LRC2
         I_LRC2_0:
          FLD qw0
          FSTP ip_lrc2
          FLD qw0
          FSTP infrc2p 
         LIM_I_LRC2:
          invoke Lim_val,offset ip_lrc2,qwm100,qw100

       LRC2_PP:
          FLD ip_lrc2
          FSTP infrc2p
          FLD pv_lrc2            ;calculating PP_FRC1
          FLD sp_lrc2
          FSUBP ST(1),ST
          FLD p_lrc2
          FMULP ST(1),ST
          FSTP pp_lrc2
          invoke Lim_val,offset pp_lrc2,qwm100,qw100

          FLD outf2p               ;calculating mv_frc1
          FLD pp_lrc2
          FADDP ST(1),ST
          FLD ip_lrc2
          FADDP ST(1),ST
          FSTP mv_lrc2
          invoke Lim_val,offset mv_lrc2,qw0,qw100

      .ENDIF                


      popad
      RET
Formula_pi ENDP





Lim_val PROC valli:DWORD, minli:QWORD, maxli:QWORD  
      pushad

      mov esi,valli
      
      FLD qword ptr[esi]
      FCOMP maxli
      FSTSW ax
      sahf
      ja AB_MAX
      FLD minli
      FCOMP qword ptr[esi]           
      FSTSW ax
      sahf
      ja LE_MIN
      popad
      RET
    AB_MAX:
      FLD qword ptr[esi]
      FSTP sumpiv
      FLD maxli
      FSTP qword ptr[esi]
      jmp EN_Lim_val
    LE_MIN:
      FLD minli
      FSTP qword ptr[esi]                 
    EN_Lim_val:

      popad
      RET
Lim_val ENDP
