         title    Help Generator

         .586
         .model   flat, STDCALL

         option   casemap: none   ; case sensitive
            include  \MASM32V1\include\Windows.inc
            include  \MASM32V1\include\WordEdit.inc
            include  \MASM32V1\include\USER32.inc
            include  \MASM32V1\include\KERNEL32.inc
            include  \MASM32V1\include\GDI32.inc
            include  \MASM32V1\include\COMCTL32.inc
            include  \MASM32V1\include\COMDLG32.inc
            include  \MASM32V1\include\SHELL32.inc
            include  \MASM32V1\include\ADVAPI32.inc
;            include  \MASM32V1\include\DSPMACRO.asm

MOVmd    MACRO Var1, Var2
         push     Var2
          pop     Var1
         ENDM

;--------------------------------------------------
.data

richedit     db      'RichEdit20A',0

WndClass     db      'Help File Generator',0
listbox      db      'LISTBOX',0
Butt         db      'BUTTON',0
Stat         db      'Static',0
szNoSelect   db      'A selection has to be made on the main window.',0
szMiddle     db      'You can not select in the middle of the name.',0
szNotJump    db      'You selected Jump in the dialog, but this is a Topic.',0
szNotTopic   db      'You selected Topic in the dialog, but this is a Jump.',0
szSelect     db      'You can not select text for BitMap insertion.'
             db      0Dh,0Ah
             db      'Either Click to the Left or Right of the Text.',0
szBuilt      db      'Has sucessfully been created.',0
szDoSel      db      'Try selecting again, sometimes'
             db      0Dh,0Ah
             db      " it's a little touchy.",0

szNoCont     db      'Did you mean to create a Jump, because there is'
             db      0Dh,0Ah
             db      'not a Jump name for this selection.'
             db      0Dh,0Ah,0Dh,0Ah
             db      'Or you might get this message if you are'
             db      0Dh,0Ah
             db      'creating a Popup or NonPrimary Topic.'
             db      0Dh,0Ah,0Dh,0Ah
             db      'Select NO if you are creating a Popup'
             db      0Dh,0Ah
             db      'or Non-Primary Topic for:'
             db      0Dh,0Ah,0Dh,0Ah
szName1      db      64 dup(0),0

szNoJump     db      'The jump has not been created in the table'
             db      0Dh,0Ah
             db      'of contents, it will make your life easier'
             db      0Dh,0Ah
             db      'if you would do that first for:'
             db      0Dh,0Ah,0Dh,0Ah
szName2      db      64 dup(0),0
szSaving     db      'File modified: ',0
szSemi       db      'ONLY use for Primary Jumps and Topics.',0
szComplete   db      'First select the proper TEXT in the formatted window below.',0

hWndW        dd      0
hInstW       dd      0
hREditW      dd      0
lpRichEditW  dd      0
lpStaticW    dd      0 
hSMenuW      dd      0
hREditF      dd      0
hEdit8       dd      0
hEdit9       dd      0
hCursor      dd      0
hHelpGen     dd      0
hListW       dd      0
hFootDlg     dd      0
hUpdate      dd      0
SubControl   dd      0
hHideShow    dd      0
hCloseSes    dd      0
hStatic      dd      0
hAutoU       dd      0
hPopup       dd      0
hReset       dd      0
hToggle      dd      0
hShow        dd      0
hBmp1        dd      0
hDC          dd      0
aFont        dd      0

sPos         dd      0
ePos         dd      0
Num          dd      0
Var          dd      0
SetPage      dd      0
TopLine      dd      0
SavS         dd      0
SavE         dd      0
SavSP        dd      0
SavEP        dd      0   
MoveIt       dd      0
sw4          dd      0
PopupTopic   dd      0
NonPop       dd      0
Flags        dd      5  ;FR_DOWN or FR_MATCHCASE  ;or FR_WHOLEWORD
Jump         dd      0
Topic        dd      0
ScrollPos    dd      0
InsertL      dd      0
InsertR      dd      0
Flag         dd      0
Style        dd      0
HideDlg      dd      0
ShowW        dd      0
Toggle       dd      0
BmpBut       dd      0
BStyle       db      0

hMem         dd      0
pMem         dd      0
;BytesO       dd      0

szFind       db      256 dup(0),0
szHWS        db      256 dup(0),0
szAth        db      50  dup(0),0
szKeys       db      75  dup(0),0
szParam      db      10  dup(0),0
Clear        db      10  dup(' '),0
szExe        db      '*.exe',0,'*.exe',0,0
szBackS      db      '\',0  
szEQ         db      '=',0
szCaret      db      '^',0
szSpace      db      ' ',0
szSpace3     db      '   ',0
szCRLF       db      0Dh,0Ah,0
szCR         db      0dh,0
szTab        db      09h,0
FontAr       db      'Arial',0
FontArN      db      'Arial Narrow',0
szHideDlg    db      'Hide Dialog',0
szShowDlg    db      'Show Dialog',0
szCloseSes   db      'Close Session',0
Butt1        db      'Jump',0
Butt2        db      'Topic',0
Butt3        db      'Border',0
Butt4        db      'BitMap',0
Update       db      'Update Parent',0
AutoU        db      'Auto Update',0
Popup        db      'Popup or Non-Primary Topic',0
Show         db      'Show Work Window',0
szReset      db      'Reset',0 
szToggle     db      'Toggle',0 

;---------- [Help window info including pos, size, and color] ----------
hpjTemp      db      '; This file is maintained by HCW. Do not modify this file directly.'
             db      0Dh,0Ah,0Dh,0Ah
             db      '[OPTIONS]', 0Dh,0Ah
             db      'LCID=0x409 0x0 0x0 ; English (United States)', 0Dh,0Ah
             db      'REPORT=Yes', 0Dh,0Ah
             db      'CONTENTS=A111      ; First topic to show on open', 0Dh,0Ah
             db      'TITLE=B111', 0Dh,0Ah
             db      'COPYRIGHT=(c) C111, All Rights Reserved', 0Dh,0Ah
             db      'HLP=D111', 0Dh,0Ah,0Dh,0Ah
             db      '[FILES]', 0Dh,0Ah
             db      'E111', 0Dh,0Ah,0Dh,0Ah
             db      '[MAP]', 0Dh,0Ah
             db      'F111', 0Dh,0Ah,0Dh,0Ah
             db      '[WINDOWS]', 0Dh,0Ah
szWinParms   db      75  dup(0),0
;szPosClr     db      'main="7111",(240,66,390,600),20736,(r16777213),(r15266815),f2',0 
szPosClr     db      'main="G111",(H111,I111,J111,K111),20736,(rL111),(rM111),f2',0
HelpX        dd      525
HelpY        dd      25
HelpW        dd      425
HelpH        dd      600
ColorH       dd      00e8f3ffh
ColorT       dd      00fffffdh
CustClrs     dd      16 dup(?)

szHPJ        db      'hpj',0
szHLP        db      'hlp',0
szFields     db      '1111',0

BrdBSH       db      '\box\brdrsh ',0
BrdBSN       db      '\box\brdrrs ',0
BrdBTH       db      '\box\brdrth ',0
BrdBDB       db      '\box\brdrdb ',0
BrdRT        db      '\brdrt ',0
BrdRB        db      '\brdrb ',0
BrdRTRB      db      '\brdrt\brdrb ',0
BrdTH        db      '\brdrth ',0

Bmp1L        db      '\fs21\strike\{bmc ',0
Bmp1R        db      '\fs21   \strike\{bmc ',0
Bmp2         db      '\}\strike0\v ',0
Bmp3         db      '\v0 ',0

szIDFootS    db      '${\footnote  ',0
szIDFootID   db      '#{\footnote  ',0
szIDFootK    db      'K{\footnote  ',0
szQ          db      '\q',0
szQc         db      '\qc',0
szQr         db      '\qr',0
szFontS      db      '\fs',0 
;szPage       db      '\page\',0
szPage       db      '\page',0
szKeepn      db      '\keepn',0
szBox        db      '\box',0
szBrdr       db      '\brdr',0
szPar        db      '\par',0
szParCR      db      '\par'
             db      0dh,0
szPard       db      '\pard',0
szParPard    db      '\par\pard',0
szUL         db      '{\ul',0

Jmp1         db      '{\uldb ',0
Jmp1Pop      db      '{\ul ',0
Jmp2         db      '\ul0\v ',0
Jmp3         db      '\v0}',0
Jmp4         db      '\ulnone',0
Jmp5         db      '\v0',0
Jmp6         db      '\ul ',0
Jmp7         db      '\uldb',0

Foot1        db      '\keepn\sb280\sa10'
             db      0Dh,0Ah,0
Foot1P       db      '\keepn\sb280\sa10\page'
             db      0Dh,0Ah,0
T            db      '{\super ${\footnote  ',0
ID           db      '{\super #{\footnote  ',0
K            db      '{\super K{\footnote  ',0
B            db      '{\super +{\footnote  ',0
A            db      '{\super A{\footnote  ',0
M            db      '{\super !{\footnote  ',0
Foot2        db      '}}'
             db      0Dh,0Ah,0
Foot3        db      '{',0
;Foot4        db      '}\sb40\sa40\fs2'
Foot4        db      '}\sb40\sa40'
             db      0Dh,0Ah,0

;szFoot       db      '\sa40\fs2',0
szFoot       db      '\sb40\sa40',0
szFootnote   db      '}}',0
szViewkind   db      '\viewkind',0
szTitle      db      '$#',0

ControlButt      PROTO :DWORD, :DWORD, :DWORD, :DWORD
ButtonType4      PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD

ofn      OPENFILENAME  <?>
ft       FINDTEXT      <>
lf       LOGFONT       <>

;--------------------------------------------------
.code

;=========================================================================|
;* Create the Help Generator Dialog                                       |
;=========================================================================|
HelpGenerate  PROC hWnd:DWORD, hInst, Class, hFont, DlgBox
       MOVmd     Toggle, DlgBox
         mov     eax, offset HelpGen
      .if !DlgBox || DlgBox == 10
         INVOKE     CreateDialogParam, hInst, 4402, hWnd, eax, 0  ; Complete
      .else
         INVOKE     CreateDialogParam, hInst, 8801, hWnd, eax, 1  ; Semi-Auto
      .endif
         ret
HelpGenerate  ENDP

;=========================================================================|
;* Create the unformatted RTF file window                                 |
;=========================================================================|
CreateWinRTF  PROC hWnd:DWORD, hInst, Class, hFont, Code
LOCAL     rect:RECT

       MOVmd     hWndW, hWnd
       MOVmd     hInstW, hInst
      INVOKE     LoadMenu, hInst, 4401   
      INVOKE     GetSubMenu, eax, 0
         mov     hSMenuW, eax
      INVOKE     LoadCursor, NULL, IDC_ARROW
         mov     hCursor, eax
      INVOKE     GetWindowRect, hWnd, addr rect
         mov     eax, rect.right
         sub     eax, rect.left
         add     rect.left, eax
         sub     rect.left, 300
         add     rect.top, 40

         mov     ebx, WS_POPUP or WS_THICKFRAME or ES_MULTILINE or ES_NOHIDESEL or\
                 ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or\
                 ES_AUTOVSCROLL or WS_TABSTOP
      .if Code != 37
             or     ebx, WS_VISIBLE
      .endif

      INVOKE     CreateWindowEx, 0, Class, 0,
                 ebx,
                 rect.left, rect.top, 400, 500, 0, 0, hInst, 0
         mov     hREditW, eax
      INVOKE     SetWindowLong, hREditW, GWL_WNDPROC, RichEditProcW
         mov     lpRichEditW, eax

      INVOKE     SendMessage, hREditW, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
      INVOKE     SendMessage, hREditW, EM_EXLIMITTEXT, 0, 2000000
      INVOKE     SendMessage, hREditW, WM_SETFONT, hFont, 1
      .if Code != 37
         INVOKE     ShowWindow, hREditW, SW_SHOWNORMAL
      .endif
         ret
CreateWinRTF  ENDP

;=========================================================================|
;* Save and restore the RTF file                                          |
;=========================================================================|
SaveRestore  PROC 
LOCAL     cr:CHARRANGE

         and     RTF, 0
         mov     sw1, 3
      INVOKE     SaveFile
          or     RTF, 1
          or     OA, 1
      INVOKE     OpenFileA
       MOVmd     ft.chrg.cpMin, SavS
       MOVmd     ft.chrg.cpMax, SavE

      .if ft.chrg.cpMin > 9
            sub     ft.chrg.cpMin, 10
      .endif
         add     ft.chrg.cpMax, 64
         lea     eax, offset szBuff
         mov     ft.lpstrText, eax
         mov     ebx, FR_DOWN or FR_MATCHCASE
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, ebx, addr ft

      .if eax != -1
            mov     SavS, eax
            mov     SavE, eax
         INVOKE     lstrlen, addr szBuff
            add     SavE, eax
      .endif
       MOVmd     cr.cpMin, SavS
       MOVmd     cr.cpMax, SavE
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
         mov     ScrollPos, eax
         mov     eax, TopLine
         sub     eax, ScrollPos
      INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, eax ; Scroll parent to org pos
      INVOKE     SendMessage, hREditW, EM_SETMODIFY, 0, 0

         ret
SaveRestore  ENDP

;=========================================================================
;* RICH EDIT PROCEDURE - RICH EDIT IS A SUB CLASS                        *
;=========================================================================
RichEditProcW PROC  hwnd:DWORD, wmsg, wparam, lparam
LOCAL     cr:CHARRANGE
LOCAL     rect:RECT
LOCAL     XP:DWORD, YP:DWORD

      INVOKE     CallWindowProc, lpRichEditW, hwnd, wmsg, wparam, lparam

      .if wmsg == WM_LBUTTONDBLCLK
            mov     MoveIt, 1
      .endif

      .if wmsg == WM_NCLBUTTONUP
            and     MoveIt, 0
         INVOKE     SendMessage, hwnd, EM_SETSEL, 0, 0
      .endif

      .if wmsg == WM_INITMENU
         INVOKE     SetCursor, hCursor
      .endif

      .if wmsg == WM_NCHITTEST && MoveIt
         INVOKE     PostMessage, hwnd, WM_NCLBUTTONDOWN, HTCAPTION, 0 ;Post to drag window in the client area
         INVOKE     PostMessage, hwnd, WM_NCLBUTTONUP, 0, 0 ;Post to clear switch
         INVOKE     SendMessage, hwnd, EM_SETSEL, 0, 0   ; Added for win95
      .endif

         cmp     wmsg, WM_RBUTTONUP
          je     PopUp
         cmp     wmsg, WM_COMMAND
          je     wmcommand

         jmp     ThatsAll

wmcommand:
         mov     eax, wparam
         cwde                         ;Only low word contains command
      .if eax == IDM_CUT
         INVOKE     SendMessage, hwnd, WM_CUT, 0 ,0
      .endif
      .if eax == IDM_COPY
         INVOKE     SendMessage, hwnd, WM_COPY, 0 ,0
      .endif
      .if eax == IDM_PASTE
         INVOKE     SendMessage, hwnd, WM_PASTE, 0 ,0
      .endif
      .if eax == IDM_DEL
         INVOKE     SendMessage, hwnd, WM_CLEAR, 0 ,0
      .endif
      .if eax == IDM_SAVE
         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     TopLine, eax

           call     SaveRestore
      .endif
      .if eax == IDM_CLOSE
         INVOKE     DestroyWindow, hwnd
      .endif
         jmp     ThatsAll

PopUp:
      INVOKE     GetWindowRect, hwnd, addr rect
         mov     eax, lparam        ;x/y pos of window
         mov     ebx, eax
         and     ebx, 0000ffffh     ;ebx = LOWORD(lparam) = x pos
         shr     eax, 16            ;eax = HIWORD(lparam) = y pos
         add     ebx, rect.left
         add     eax, rect.top
         mov     XP, ebx            ;x position
         mov     YP, eax            ;y position
         add     XP, -10
         add     YP, -10
      INVOKE     TrackPopupMenu, hSMenuW, TPM_LEFTALIGN or TPM_LEFTBUTTON, XP, YP, 0, hwnd, addr rect
mov     eax, 1
ret

ThatsAll:
         ret
RichEditProcW ENDP

;========================================================================|
; Subclass procedure for the Control Buttons                             *
;========================================================================|
ControlButt  PROC  hwnd:DWORD, wMsg, wParam, lParam
LOCAL     UpDown:DWORD

      INVOKE     CallWindowProc, SubControl, hwnd, wMsg, wParam, lParam

         mov     UpDown , 1
      .if wMsg == WM_PAINT
PaintEM:
            mov     eax, hwnd
         .if eax == hHideShow
            .if !HideDlg
               INVOKE     ButtonType4, hHideShow, aFont, 00c1ffc1h, 00006000h, addr szHideDlg, UpDown
            .elseif HideDlg
               INVOKE     ButtonType4, hHideShow, aFont, 00006000h, 00c1ffc1h, addr szShowDlg, UpDown
            .endif
         .elseif eax == hCloseSes
            INVOKE     ButtonType4, hCloseSes, aFont, 000000ffh, 00ff0000h, addr szCloseSes, UpDown
         .elseif eax == hToggle
            INVOKE     ButtonType4, hToggle, aFont, 0000ff00h, 00000000h, addr szToggle, UpDown
         .elseif eax == hReset
            INVOKE     ButtonType4, hReset, aFont, 00ffffd2h, 00000000h, addr szReset, UpDown
         .elseif eax == hUpdate
            INVOKE     ButtonType4, hUpdate, aFont, 00a6a600h, 00000000h, addr Update, UpDown
         .endif
            mov     UpDown, 1

      .elseif wMsg == WM_LBUTTONDOWN
            mov     eax, hwnd
         .if eax == hHideShow || eax == hCloseSes || hToggle || hReset || hUpdate
               mov     UpDown, 2
               jmp     PaintEM
         .endif

      .elseif wMsg == WM_MOUSEMOVE || wMsg == WM_NCMOUSEMOVE
            mov     eax, hwnd
         .if eax == hHideShow || eax == hCloseSes || hToggle || hReset || hUpdate
            .if wParam == MK_LBUTTON
                  mov     UpDown, 2
            .else
                  mov     UpDown, 1
            .endif
               jmp     PaintEM
         .endif

      .elseif wMsg == WM_LBUTTONUP
            mov     eax, hwnd
         .if eax == hHideShow || eax == hCloseSes || hToggle || hReset || hUpdate
               mov     UpDown, 1
               jmp     PaintEM
         .endif
      .endif

Ret1:
         mov     eax, TRUE
         ret
ControlButt  ENDP

;=============================================================================
; Creates various appearances of Buttons
;=============================================================================
ButtonType4  PROC hButt:DWORD, hFont, BackC, TextC, szText, Bor
LOCAL     rect:RECT
LOCAL     hOldFont:DWORD, hBR

      INVOKE     GetDC, hButt
         mov     hDC, eax
      INVOKE     CreateSolidBrush, BackC
         mov     hBR, eax
      INVOKE     GetClientRect, hButt, addr rect
      INVOKE     FillRect, hDC, addr rect, hBR
      INVOKE     DeleteObject, hBR            ; Delete the brush handle
      .if Bor == 1
         INVOKE     DrawEdge, hDC, addr rect, BDR_RAISEDOUTER, BF_TOPLEFT
         INVOKE     DrawEdge, hDC, addr rect, BDR_RAISEDOUTER, BF_BOTTOMRIGHT
      .elseif Bor == 2
         INVOKE     DrawEdge, hDC, addr rect, EDGE_SUNKEN, BF_RECT
      .endif
      INVOKE     SelectObject, hDC, hFont     ; Select the font into the dc
         mov     hOldFont, eax
      INVOKE     SetTextColor, hDC, TextC     ; Set the text color
      INVOKE     SetBkMode, hDC, TRANSPARENT  ; Set the text background to transparent
      INVOKE     DrawText, hDC, szText, -1, addr rect, DT_CENTER or DT_VCENTER or DT_WORDBREAK
      INVOKE     SelectObject, hDC, hOldFont
      INVOKE     ReleaseDC, hButt, hDC        ; Release the control dc

         xor    eax, eax
         ret
ButtonType4  ENDP

;========================================================================|
;* Help Generator procedure                                              *
;========================================================================|
HelpGen PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     cr:CHARRANGE
LOCAL     tbb:TBBUTTON
LOCAL     rect:RECT
LOCAL     tbab:TBADDBITMAP      
Local     len:DWORD, bar, SavTab, w1, ctlID, xPos, hBR

      .if wmsg == WM_INITDIALOG
          MOVmd     hHelpGen, hdlg
          MOVmd     Flag, lparam 
         .if Toggle < 2    
               mov     ShowW, 1
         .endif

;============================
; Create the Help Gen Toolbar
;============================

         INVOKE     ShowWindow, hMiscTool, SW_HIDE

         INVOKE     CreateWindowEx, 0, addr ToolClass, 0,
                    WS_CHILD or WS_VISIBLE or TBSTYLE_TOOLTIPS or CCS_NOPARENTALIGN or CCS_NORESIZE or\
                    TBSTYLE_FLAT or TBSTYLE_LIST,
                    1,24,1200,28, hWndW, 46, hInstW, NULL
            mov     hToolBarH, eax
         INVOKE     MoveWindow, hToolBarH, 0, 24, 1200, 28, TRUE

         INVOKE     lstrcpy, addr lf.lfFaceName, addr FontAr ;FontArN
            mov     lf.lfHeight, 12 ;14 ;12
            mov     lf.lfWeight, 500
         INVOKE     CreateFontIndirect, ADDR lf
            mov     aFont, eax
   
         INVOKE     lstrcpy, addr lf.lfFaceName, addr FontAr
;      .if osvID < 2
            mov     lf.lfHeight, -11 ; -11 for win9x -12 for NT
;      .else
;         mov     lf.lfHeight, -12
;      .endif  
            mov     lf.lfWeight, 500
         INVOKE     CreateFontIndirect, addr lf
         INVOKE     SendMessage, hToolBarH, WM_SETFONT, eax, 1

         INVOKE     SendMessage, hToolBarH, TB_BUTTONSTRUCTSIZE, sizeof TBBUTTON, 0

            mov     eax, 00130000h  ; loword = Bitmap Width, hiword = Bitmap Height
         INVOKE     SendMessage, hToolBarH, TB_SETBITMAPSIZE, 0, eax

;         mov     eax, 00220022h  ;00130032h
;      INVOKE     SendMessage, hToolBarH, TB_SETBUTTONSIZE, 0, eax

;---------- [Create Help Gen Toolbar Buttons] ----------
;          TBSep     hToolBarH, 0 ;100 ;50
            mov     BStyle, TBSTYLE_BUTTON
            mov     ctlID, B1
         .if lparam
               or     BStyle, TBSTYLE_CHECKGROUP
              mov     ctlID, B10
         .endif

         INVOKE     SendMessage, hToolBarH, TB_ADDSTRING, 0, addr szSpace
            mov     w1, eax
            mov     ecx, 5
         .while (ecx)                 ; (5) Dummy fill buttons
               mov     eax, w1
              push     ecx
            TBButt     hToolBarH, -1, 14, 0, TBSTYLE_BUTTON, eax
               pop     ecx
               dec     ecx
         .endw

         INVOKE     SendMessage, hToolBarH, TB_ADDSTRING, 0, addr Butt1
            mov     bl, BStyle
         TBButt     hToolBarH, -1, ctlID, TBSTATE_ENABLED, bl, eax ;101
         INVOKE     SendMessage, hToolBarH, TB_ADDSTRING, 0, addr Butt2
            mov     bl, BStyle
            add     ctlID, 1
         TBButt     hToolBarH, -1, ctlID, TBSTATE_ENABLED, bl, eax ;102
         .if !lparam
            INVOKE     SendMessage, hToolBarH, TB_ADDSTRING, 0, addr Butt3
               add     ctlID, 1
            TBButt     hToolBarH, -1, ctlID, TBSTATE_ENABLED, TBSTYLE_BUTTON, eax ;103
               add     ctlID, 1
            INVOKE     SendMessage, hToolBarH, TB_ADDSTRING, 0, addr Butt4
            TBButt     hToolBarH, -1, ctlID, TBSTATE_ENABLED, TBSTYLE_BUTTON, eax ;104
         .endif

;---------- [Create Push Buttons] ----------
            mov     ebx, 6
         .if !lparam
               mov     ebx, 8
         .endif 
         INVOKE     SendMessage, hToolBarH, TB_GETITEMRECT, ebx, addr rect
            mov     eax, rect.right
            add     eax, 8
            mov     xPos, eax
            mov     Style, WS_CHILD or WS_VISIBLE or BS_TEXT or BS_MULTILINE
         INVOKE     Button, hToolBarH, addr szHideDlg, Style, 2, 0, 42, 25, 91
            mov     hHideShow, eax
      INVOKE     SetWindowLong, hHideShow, GWL_WNDPROC, ControlButt
         mov     SubControl, eax

         INVOKE     Button, hToolBarH, addr szCloseSes, Style, 47, 0, 42, 25, 92
            mov     hCloseSes, eax
      INVOKE     SetWindowLong, hCloseSes, GWL_WNDPROC, ControlButt
         mov     SubControl, eax

;---------- [Create Static window] ----------
            mov     eax, 95
         .if !lparam
               mov     eax, 129
         .endif
           push     eax
         INVOKE     CreateWindowEx, NULL, addr Stat, 0,
                    WS_CHILD or WS_VISIBLE,
                    93,1,eax,25, hToolBarH, 93, hInstW, 0
            mov     hStatic, eax
         INVOKE     SendMessage, eax, WM_SETFONT, aFont, 1

         INVOKE     SetWindowLong, hStatic, GWL_WNDPROC, StaticProc
            mov     lpStaticW, eax
            pop     eax
         INVOKE     MoveWindow, hStatic, 94, 1, eax, 25, TRUE   ; Force repaint

         .if lparam
               mov     Style, WS_CHILD or WS_VISIBLE or BS_MULTILINE ;or BS_BITMAP
            INVOKE     Button, hToolBarH, addr Update, Style, xPos, 0, 43, 25, 94
               mov     hUpdate, eax
            INVOKE     SetWindowLong, hUpdate, GWL_WNDPROC, ControlButt
               mov     SubControl, eax
;            INVOKE     LoadBitmap, hInstW, 5555 
;               mov     hBmp1, eax
;            INVOKE     SendMessage, hUpdate, BM_SETIMAGE, 0, hBmp1

;---------- [Create Check Boxes] ----------
               add     xPos, 48   ; x Pos of check boxes
               mov     Style, WS_CHILD or WS_VISIBLE or BS_AUTOCHECKBOX
            INVOKE     Button, hToolBarH, addr AutoU, Style, xPos, 1, 70, 12, cb3
               mov     hAutoU, eax
               mov     eax, xPos
            INVOKE     Button, hToolBarH, addr Show, Style, xPos, 13, 100, 12, cb2
               mov     hShow, eax

         .else
sub     xPos, 3
               mov     Style, WS_CHILD or WS_VISIBLE or BS_AUTOCHECKBOX
            INVOKE     Button, hToolBarH, addr Popup, Style, xPos, 1, 140, 12, cb1
               mov     hPopup, eax
            INVOKE     Button, hToolBarH, addr Show, Style, xPos, 13, 100, 12, cb2
               mov     hShow, eax
         .endif
            add     xPos, 105

;---------- [Create Reset and Toggle Buttons] ----------
         .if lparam
               mov     Style, WS_CHILD or WS_VISIBLE or BS_MULTILINE
            INVOKE     Button, hToolBarH, addr szReset, Style, xPos, 0, 40, 12, 89
               mov     hReset, eax
            INVOKE     SetWindowLong, hReset, GWL_WNDPROC, ControlButt
               mov     SubControl, eax
add     xPos, 88
         .endif
            mov     Style, WS_CHILD or WS_VISIBLE or BS_MULTILINE
         INVOKE     Button, hToolBarH, addr szToggle, Style, xPos, 13, 40, 12, 90
            mov     hToggle, eax
         INVOKE     SetWindowLong, hToggle, GWL_WNDPROC, ControlButt
            mov     SubControl, eax

         .if ShowW
            INVOKE     CheckDlgButton, hdlg, cb2, BST_CHECKED        ; Sets Show Work Window
            INVOKE     SendMessage, hShow, BM_SETCHECK, BST_CHECKED, 0
         .endif

            and     Jump, 0
            and     Topic, 0
            and     NonPop, 0
            and     HideDlg, 0

;---------- [Delete the NULL character at EOF] ---------- 
         INVOKE     SendMessage, hREditW, EM_GETLINECOUNT, 0, 0
            dec     eax
         INVOKE     SendMessage, hREditW, EM_LINEINDEX, eax, 0
            dec     eax     
            mov     cr.cpMin, eax
            add     eax, 2
            mov     cr.cpMax, eax
         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szFind

            mov     eax, dword ptr szFind
         .if !eax || ax == 000dh
            INVOKE     SendMessage, hREditW, WM_CLEAR, 0 ,0
              call     SaveRestore
         .endif
         INVOKE     SendMessage, hREditW, EM_SETSEL, 0, 0
         INVOKE     SetDlgItemText, hdlg, E1, addr szHWS
      .endif

      .if wmsg == WM_CTLCOLORDLG
         INVOKE     GetStockObject, WHITE_BRUSH  ; Select the white brush for the background
            jmp     HelpGenRet
      .endif

      .if wmsg == WM_CTLCOLORSTATIC
         INVOKE     GetStockObject, WHITE_BRUSH  ; Select the white brush for the background
            jmp     HelpGenRet
      .endif

      .if wmsg == WM_NCMOUSEMOVE
         INVOKE     SetFocus, hWndW
            jmp     HelpGenDone
      .endif

      .if wmsg != WM_COMMAND  ; See if msg is a command
            jmp     HelpGenDone
      .endif
         mov     eax, wparam

      .if eax == 90           ; Toggle the Toolbar
         and     hHelpGen, 0
         and     Jump, 0
         and     Topic, 0
      INVOKE     DestroyWindow, hToolBarH
         and     hToolBarH, 0
      INVOKE     EndDialog, hdlg, wparam
         mov     eax, TRUE    ; Return
         jmp     HelpGenRet   ; with TRUE
      .endif

      .if eax == 91           ; Hide or Show Dialog
         .if !HideDlg
      INVOKE     DestroyWindow, hHideShow
            INVOKE     ShowWindow, hHelpGen, SW_HIDE
               mov     Style, WS_CHILD or WS_VISIBLE or BS_TEXT or BS_MULTILINE
            INVOKE     Button, hToolBarH, addr szShowDlg, Style, 2, 0, 42, 25, 91
               mov     hHideShow, eax
            INVOKE     SendMessage, eax, WM_SETFONT, aFont, 1

      INVOKE     SetWindowLong, hHideShow, GWL_WNDPROC, ControlButt
         mov     SubControl, eax

                or     HideDlg, 1
         .else
      INVOKE     DestroyWindow, hHideShow
            INVOKE     ShowWindow, hHelpGen, SW_SHOWNORMAL
               mov     Style, WS_CHILD or WS_VISIBLE or BS_TEXT or BS_MULTILINE
            INVOKE     Button, hToolBarH, addr szHideDlg, Style, 2, 0, 42, 25, 91
               mov     hHideShow, eax
            INVOKE     SendMessage, eax, WM_SETFONT, aFont, 1

      INVOKE     SetWindowLong, hHideShow, GWL_WNDPROC, ControlButt
         mov     SubControl, eax

               and     HideDlg, 0
         .endif
         INVOKE     SetFocus, hREdit
      .endif

      .if eax == cb1          ; Popup or Non-Primary Topic
         INVOKE     IsDlgButtonChecked, hdlg, cb1
            mov     NonPop, eax
         .if eax
            INVOKE     SendMessage, hPopup, BM_SETCHECK, BST_CHECKED, 0
         .else
            INVOKE     SendMessage, hPopup, BM_SETCHECK, BST_UNCHECKED, 0
         .endif
      .endif

      .if eax == cb2          ; Show or Hide Work window
         INVOKE     IsDlgButtonChecked, hdlg, cb2
         .if eax
            INVOKE     ShowWindow, hREditW, SW_SHOWNORMAL
            INVOKE     SendMessage, hShow, BM_SETCHECK, BST_CHECKED, 0
               mov     ShowW, 1
         .else
            INVOKE     ShowWindow, hREditW, SW_HIDE
            INVOKE     SendMessage, hShow, BM_SETCHECK, BST_UNCHECKED, 0
               and     ShowW, 0
         .endif
         INVOKE     SetFocus, hREdit
      .endif
         mov     eax, wparam

;==============================================
;               [Common stuff]
;==============================================
      .if eax > B0 && eax < B6 || eax == IDOK
         .if !hREditW
               jmp     HelpGenDone
         .endif
           push     eax
         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     TopLine, eax
            pop     eax
      .endif

;==============================================
;               [Quick jumps and topics]
;==============================================
      .if eax == 89  ; Reset
         INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B10, MF_UNCHECKED or MF_BYCOMMAND
         INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B11, MF_UNCHECKED or MF_BYCOMMAND
         INVOKE     CheckDlgButton, hdlg, B10, BST_UNCHECKED    ; Resets the appropiate radio button
         INVOKE     CheckDlgButton, hdlg, B11, BST_UNCHECKED    ; Resets the appropiate radio button
            and     Jump, 0
            and     Topic, 0
         INVOKE     SetFocus, hREdit
            jmp     HelpGenDone
      .endif

      .if eax == B10 || eax == B11
         .if !hREditW
               jmp     HelpGenDone
         .endif
         INVOKE     IsDlgButtonChecked, hdlg, B10
         .if eax
            INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B10, MF_CHECKED or MF_BYCOMMAND
            INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B11, MF_UNCHECKED or MF_BYCOMMAND
               mov     Jump, 1
               and     Topic, 0
         .else
            INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B10, MF_UNCHECKED or MF_BYCOMMAND
            INVOKE     SendMessage, hToolBarH, TB_CHECKBUTTON, B11, MF_CHECKED or MF_BYCOMMAND
               mov     Topic, 1
               and     Jump, 0
         .endif
         INVOKE     SetFocus, hWndW
            jmp     HelpGenDone
      .endif

      .if eax == cb3      ; Auto update from quick Jump & Topic
         INVOKE     IsDlgButtonChecked, hdlg, cb3
         .if eax
            INVOKE     SendMessage, hAutoU, BM_SETCHECK, BST_CHECKED, 0
         .else
            INVOKE     SendMessage, hAutoU, BM_SETCHECK, BST_UNCHECKED, 0
         .endif
         INVOKE     SetFocus, hWndW
            jmp     HelpGenDone
      .endif

      .if eax == IDOK     ; Update from quick Jump & Topic
           call     SaveRestore
            jmp     HelpGenDone
      .endif

;==============================================
;               [Create jumps]
;==============================================
      .if eax == B1
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
            mov     bar, 1
            jmp     CheckSel

RetB1:
            mov     len, eax
            mov     ecx, eax
            xor     eax, eax
         .while (ecx)
            .if szFind[eax] == '^'
                  mov     ebx, len
                  mov     len, eax
                  sub     ebx, eax
                  sub     cr.cpMax, ebx
                  sub     SavE, ebx
               INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
               .break
            .endif
               dec     ecx
               inc     eax
         .endw

            mov     eax, len
            dec     eax
         .if byte ptr szFind[eax] == 09h   ; Check for Tab
               mov     len, eax
               sub     cr.cpMax, 1
               sub     SavE, 1
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         .endif
            and     Num, 0
         INVOKE     LockWindowUpdate, hREdit  ; Lock parent to avoid flicker

         INVOKE     FRProcW, hREdit, 0, len, 0, addr szFind
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

         INVOKE     FRProcW, hREditW, 1, len, 0, addr szFind
         .if eax == -1
            INVOKE     LockWindowUpdate, 0    ; Unlock parent
               jmp     HelpGenDone            ; Not found
         .endif
;DSPValue hWndW, 8888 
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff

         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     ScrollPos, eax
            mov     eax, TopLine
            sub     eax, ScrollPos
         INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, eax ; Scroll parent to org pos

         .if Jump
             MOVmd     ft.chrg.cpMin, sPos
             MOVmd     ft.chrg.cpMax, ePos
               sub     ft.chrg.cpMin, 14
               lea     eax, offset szUL ; {\ul  ;Jmp2
              call     FindEM
            .if eax != -1
;DSPValue hWndW, 9999
               INVOKE     LockWindowUpdate, 0    ; Unlock parent
                  jmp     HelpGenDone
            .endif
            INVOKE     lstrcpy, addr szFind, addr Jmp1
            INVOKE     lstrcat, addr szFind, addr szBuff
            INVOKE     lstrcat, addr szFind, addr Jmp2
               mov     sw4, 0
              call     FillBlank
            INVOKE     lstrcat, addr szFind, addr szCaret
            INVOKE     lstrcat, addr szFind, addr szBuff
            INVOKE     lstrcat, addr szFind, addr Jmp3
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind
            INVOKE     IsDlgButtonChecked, hdlg, cb3
            .if eax
                 call     SaveRestore
            .endif
            INVOKE     LockWindowUpdate, 0    ; Unlock parent
               jmp     HelpGenDone
         .endif

            mov     eax, offset CreateJmp
         INVOKE     CreateDialogParam, hInstW, 4403, hWndW, eax, 0  ; Modeless dialog box
         INVOKE     LockWindowUpdate, 0       ; Unlock parent
            jmp     HelpGenDone
      .endif

;==============================================
;             [Create footnotes]
;==============================================
      .if eax == B2

;---------- [Check to see if topic needs a page break] ----------
         INVOKE     SendMessage, hREdit, EM_LINEFROMCHAR, -1, 0
            mov     SetPage, eax   ; If first line no page

;---------- [Get the field name and length and (field number] ----------
;---------- [in case there are multible names)from the parent window] ----------

         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
            mov     bar, 2
            jmp     CheckSel

RetB2:
            mov     len, eax
            and     Num, 0

;---------- [Check to see if the selection is on a created jump name] ----------
            add     cr.cpMax, 1
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szWork
            sub     cr.cpMax, 1
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            mov     ecx, len
            inc     ecx
            xor     eax, eax
         .while (ecx)
            .if szWork[eax] == '^'
               INVOKE     MessageBox, NULL, addr szNotTopic, addr WndClass,\
                          MB_OK or MB_ICONWARNING or MB_TASKMODAL
                  jmp     HelpGenDone
            .endif
               dec     ecx
               inc     eax
         .endw

         INVOKE     LockWindowUpdate, hREdit  ; Lock parent to avoid flicker

         INVOKE     FRProcW, hREdit, 0, len, 1, addr szFind
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

;---------- [Find the matching field in the work window and open the footnote dialog] ----------
            mov     szWork, 0
         INVOKE     FRProcW, hREditW, 1, len, 1, addr szFind
         .if eax == -1
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            INVOKE     LockWindowUpdate, 0    ; Unlock parent
            INVOKE     CheckDlgButton, hdlg, cb1, BST_UNCHECKED ; Popup or Non-Primary Topic
            INVOKE     SendMessage, hPopup, BM_SETCHECK, BST_UNCHECKED, 0
               and     NonPop, 0
               jmp     HelpGenDone            ; Not found
         .endif
         INVOKE     CheckDlgButton, hdlg, cb1, BST_UNCHECKED    ; Popup or Non-Primary Topic
         INVOKE     SendMessage, hPopup, BM_SETCHECK, BST_UNCHECKED, 0
            and     NonPop, 0
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff

         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     ScrollPos, eax
            mov     eax, TopLine
            sub     eax, ScrollPos
         INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, eax  ; Scroll parent to org pos

         .if Topic
             MOVmd     ft.chrg.cpMin, ePos
             MOVmd     ft.chrg.cpMax, ePos
               sub     ft.chrg.cpMax, 20
               lea     eax, offset Foot4 ; }\sb40\sa40\fs2
              call     FindEM
            .if eax != -1
               INVOKE     LockWindowUpdate, 0  ; Unlock parent
                  jmp     HelpGenDone
            .endif
               mov     eax, offset CreateFoot
            INVOKE     CreateDialogParam, hInstW, 4404, hWndW, eax, 0  ; Modeless dialog box
            INVOKE     ShowWindow, hFootDlg, SW_HIDE
            INVOKE     IsDlgButtonChecked, hdlg, cb3
            INVOKE     SendMessage, hFootDlg, WM_COMMAND, IDOK, eax    ; Create footnotes eax 0 = no update
            INVOKE     SendMessage, hFootDlg, WM_COMMAND, IDCANCEL, 0  ; Close dialog
            INVOKE     LockWindowUpdate, 0     ; Unlock parent
               jmp     HelpGenDone
         .endif
            mov     eax, offset CreateFoot
         INVOKE     CreateDialogParam, hInstW, 4404, hWndW, eax, 0     ; Modeless dialog box
         INVOKE     LockWindowUpdate, 0        ; Unlock parent
            jmp     HelpGenDone
      .endif

;==============================================
;             [Create Borders]
;==============================================
      .if eax == B3
         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
          MOVmd     sPos, cr.cpMin
          MOVmd     SavS, cr.cpMin
          MOVmd     SavE, cr.cpMax
         INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         .if !eax
               jmp     NoSelect
         .endif  
            mov     len, eax
            and     Num, 0

         INVOKE     FRProcW, hREdit, 0, len, 0, addr szFind
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

         INVOKE     FRProcW, hREditW, 1, len, 0, addr szFind
           test     eax, eax
             js     HelpGenDone    ; Not found 
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff

            mov     eax, offset CreateBor
         INVOKE     CreateDialogParam, hInstW, 4406, hWndW, eax, 0  ; Modeless dialog box
            jmp     HelpGenDone
      .endif

;==============================================
;             [Create BitMaps or Buttons]
;==============================================
      .if eax == B4 ;|| eax == B5
            and     InsertL, 0
            and     InsertR, 0
            and     SavTab, 0
            mov     BmpBut, 1

         INVOKE     SendMessage, hREdit, EM_EXGETSEL, 0, addr cr
          MOVmd     sPos, cr.cpMin
          MOVmd     SavS, cr.cpMin
          MOVmd     SavE, cr.cpMax
         INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         .if !eax
            .if !cr.cpMin
                   or     InsertL, 1
                  jmp     FindCR
            .endif
               sub     cr.cpMin, 1
               add     cr.cpMax, 1
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
               add     cr.cpMin, 1
               sub     cr.cpMax, 1
            .if byte ptr szFind >= 'a' && byte ptr szFind <= 'z'\
             || byte ptr szFind >= 'A' && byte ptr szFind <= 'Z'\
             || byte ptr szFind == ')' || byte ptr szFind == '.'\
             || byte ptr szFind == '!' || byte ptr szFind == '?'\
             || byte ptr szFind == ':' || byte ptr szFind == ';'
                  or     InsertR, 1
            .endif
            .if byte ptr szFind+1 >= 'a' && byte ptr szFind+1 <= 'z'\
             || byte ptr szFind+1 >= 'A' && byte ptr szFind+1 <= 'Z'\
             || byte ptr szFind+1 == '('
                  or     InsertL, 1
            .endif
            .if InsertL && InsertR || !InsertL && !InsertR
               INVOKE     MessageBox, NULL, addr szMiddle, addr WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
                  jmp     HelpGenDone
            .endif

FindCR:
               mov     eax, cr.cpMin
               mov     ft.chrg.cpMin, eax
               mov     ft.chrg.cpMax, eax
            .if InsertL
                  add     ft.chrg.cpMax, 500
                  lea     eax, offset szCR
                  mov     ft.lpstrText, eax
               INVOKE     SendMessage, hREdit, EM_FINDTEXT, Flags, addr ft
            .else
                  mov     ft.chrg.cpMax, 0
                  lea     eax, offset szTab
                  mov     ft.lpstrText, eax
                  mov     ebx, FR_MATCHCASE
               INVOKE     SendMessage, hREdit, EM_FINDTEXT, ebx, addr ft
               .if eax != -1
                     mov     SavTab, eax
               .endif
                  lea     eax, offset szCR
                  mov     ft.lpstrText, eax
                  mov     ebx, FR_MATCHCASE
               INVOKE     SendMessage, hREdit, EM_FINDTEXT, ebx, addr ft
               .if eax != -1 && SavTab > eax
                     mov     eax, SavTab
               .endif 
            .endif
            .if eax != -1
               .if InsertL
                     mov     cr.cpMax, eax
               .else
                     inc     eax
                     mov     cr.cpMin, eax
               .endif
            .else
               .if InsertR
                  .if cr.cpMin > 9
                        sub     cr.cpMin, 10
                  .else
                        mov     cr.cpMin, 0
                  .endif
               .else
                     jmp     HelpGenDone
               .endif
            .endif
               mov     eax, cr.cpMax
               sub     eax, cr.cpMin
            .if eax > 9 && InsertL
                MOVmd     cr.cpMax, cr.cpMin
                  add     cr.cpMax, 10
            .elseif eax > 9 && InsertR
                MOVmd     cr.cpMin, cr.cpMax
                  sub     cr.cpMin, 10
            .endif

Again:
             MOVmd     sPos, cr.cpMin
             MOVmd     SavS, cr.cpMin
             MOVmd     SavE, cr.cpMax
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
               mov     len, eax

            .if szFind == ' ' || szFind == '$' || szFind == '#' && szFind+1 != 'K'
                  inc     cr.cpMin
                  jmp     Again
            .elseif szFind == '#'
                  add     cr.cpMin, 2
                  jmp     Again
            .endif
            INVOKE     SetFocus, hWndW
         .else
            INVOKE     MessageBox, NULL, addr szSelect, addr WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
               jmp     HelpGenDone
         .endif

            and     Num, 0
         INVOKE     FRProcW, hREdit, 0, len, 0, addr szFind

         INVOKE     FRProcW, hREditW, 1, len, 0, addr szFind
           test     eax, eax
             js     HelpGenDone    ; Not found 
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff

         INVOKE     SendMessage, hREdit, EM_GETFIRSTVISIBLELINE, 0, 0
            mov     ScrollPos, eax
            mov     eax, TopLine
            sub     eax, ScrollPos
         INVOKE     SendMessage, hREdit, EM_LINESCROLL, 0, eax ; Scroll parent to org pos

            mov     eax, offset CreateBitBut
         INVOKE     CreateDialogParam, hInstW, 4407, hWndW, eax, 0  ; Modeless dialog box
            jmp     HelpGenDone
      .endif

;==============================================
;             [Create the .hjp file]
;==============================================
      .if eax == B6
         .if !hREditW
               jmp     HelpGenDone
         .endif      
            mov     eax, offset CreateHPJ
         INVOKE     CreateDialogParam, hInstW, 4405, hWndW, eax, 0  ; Modeless dialog box
            jmp     HelpGenDone
      .endif

;==============================================
;             [Get path for hcw.exe]
;==============================================
      .if eax == B7
         INVOKE     GetCurrentDirectory, sizeof CurDir, addr CurDir
            mov     szHWS, 0
            mov     ofn.lStructSize, sizeof ofn
          MOVmd     ofn.hwndOwner, hWndW
          MOVmd     ofn.hInstance, hInstW
            mov     ofn.lpstrFilter, offset szExe
            mov     ofn.lpstrFile, offset szHWS
            mov     ofn.nMaxFile, lengthof szHWS
            mov     ofn.lpstrInitialDir, 0
            mov     ofn.lpstrTitle, 0
            mov     ofn.Flags, OFN_PATHMUSTEXIST or OFN_FILEMUSTEXIST
            mov     ofn.lpstrDefExt, 0
         INVOKE     GetOpenFileName, offset ofn
            cmp     eax, FALSE       ;Cancel'ed or error occurred
            je      HelpGenDone
         INVOKE     SetDlgItemText, hdlg, E1, addr szHWS
         INVOKE     SetCurrentDirectory, addr CurDir
            jmp     HelpGenDone
      .endif

;==============================================
;             [Open the .hjp file]
;==============================================
      .if eax == B8
            mov     sw1, 44
            mov     eax, offset CreateHPJ
         INVOKE     CreateDialogParam, hInstW, 4405, hWndW, eax, 0  ; Modeless dialog box
            jmp     CancelOut
      .endif

         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     HelpGenDone

NoSelect:
      INVOKE     MessageBox, NULL, addr szNoSelect, addr WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
         jmp     HelpGenDone

;=================================================
;             [Check selection for Jumps & Topics]
;=================================================
CheckSel:
LoopSel:
       MOVmd     sPos, cr.cpMin
       MOVmd     SavS, cr.cpMin
       MOVmd     SavE, cr.cpMax
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind

      .if eax && szFind == ' '
            add     cr.cpMin, 1
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
            jmp     LoopSel
      .endif

      .if eax
            dec     eax
         .if byte ptr szFind[eax] == 0ah || byte ptr szFind[eax] == 0dh
               sub     cr.cpMax, 1
            INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
               jmp     LoopSel
         .endif
            inc     eax
      .endif

      .if !eax
         .if Jump || Topic
              call     FindJT
            .if !eax
                  jmp     NoSelect
            .endif
            .if eax == 44
               INVOKE     SendMessage, hREdit, EM_SETSEL, cr.cpMax, cr.cpMax
                  jmp     HelpGenDone
            .endif
             MOVmd     cr.cpMin, SavS
             MOVmd     cr.cpMax, SavE
         .else
               jmp     NoSelect
         .endif
      .endif
      .if bar == 1
            jmp     RetB1
      .elseif bar == 2
            jmp     RetB2
      .endif
         jmp     HelpGenDone

CancelOut:
      INVOKE     SendMessage, hREditW, EM_GETMODIFY, 0, 0
         cmp     eax, FALSE
          je     NoMod
      MsgBox     ERROR_SAVE_BEFORE_QUIT, szSaving,  MB_YESNO or MB_ICONEXCLAMATION or MB_TASKMODAL
      .if eax == IDYES
           call     SaveRestore
      .endif

NoMod:
         and     hHelpGen, 0
         and     Jump, 0
         and     Topic, 0
      INVOKE     DestroyWindow, hToolBarH
         and     hToolBarH, 0
      INVOKE     ShowWindow, hMiscTool, SW_SHOWNORMAL
      INVOKE     DestroyWindow, hREditW
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     HelpGenRet        ; with TRUE

HelpGenDone:
         mov     eax, FALSE        ; Return with FALSE

HelpGenRet:
         ret                       ; Return to caller
HelpGen ENDP

;========================================================================|
;* Create a jump procedure                                               *
;========================================================================|
CreateJmp PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     cr:CHARRANGE
LOCAL     SW:DWORD

      .if wmsg == WM_INITDIALOG
         INVOKE     SetDlgItemText, hdlg, E1, addr szBuff
            and     SW, 0

;---------- [Check to see if jump has been created, if so remove] ----------
          MOVmd     cr.cpMin, sPos
          MOVmd     cr.cpMax, ePos
          MOVmd     ft.chrg.cpMin, cr.cpMin
          MOVmd     ft.chrg.cpMax, cr.cpMin
            sub     ft.chrg.cpMin, 14
            lea     eax, offset szUL ; {\ul
           call     FindEM

         .if eax != -1
               mov     cr.cpMin, eax
            INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
            INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
            .if szWork+4 != 'd'      ; Popup Topic
                  add     sPos, 2
                  add     ePos, 2
                  mov     PopupTopic, 1 
            .endif

            .if !PopupTopic
               INVOKE     GetDlgItem, hdlg, cb1                         ; Get handle Page Topic
               INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets Page Topic
            .else
               INVOKE     GetDlgItem, hdlg, cb2                         ; Get handle Poppu Topic
               INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets Poppu Topic
            .endif

             MOVmd     ft.chrg.cpMin, cr.cpMin
             MOVmd     ft.chrg.cpMax, cr.cpMin
               add     ft.chrg.cpMax, 100 ;50
               lea     eax, offset Jmp3  ; \v0
              call     FindEM
            .if eax != -1
                  mov     cr.cpMax, eax
                  add     eax, 4

;---------- [Get the jump's exsisting ID and display it] ----------
                MOVmd     SavSP, cr.cpMin
                  mov     SavEP, eax
                MOVmd     cr.cpMin, ePos
               .if szWork+4 != 'd'      ; Popup Topic
                     add     cr.cpMin, 5 ;8
               .else
                     add     cr.cpMin, 7 ;10
               .endif
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
               INVOKE     SetDlgItemText, hdlg, E2, addr szWork
                   or     SW, 1
                MOVmd     cr.cpMin, SavSP
                MOVmd     cr.cpMax, SavEP

;---------- [Clear the jump's exsisting ID] ----------
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
                  sub     sPos, 7
                  sub     ePos, 7
            .else
                  add     sPos, 7  ; ????????????????????????????
            .endif
         .else
            INVOKE     GetDlgItem, hdlg, cb1                         ; Get handle Page Topic
            INVOKE     SendMessage, eax, BM_SETCHECK, BST_CHECKED, 0 ; Sets Page Topic
         .endif

         .if !SW
            INVOKE     lstrcpy, addr szWork, addr szCaret
            INVOKE     lstrcat, addr szWork, addr szBuff
            INVOKE     SetDlgItemText, hdlg, E2, addr szWork
         .endif 
          MOVmd     cr.cpMin, sPos
          MOVmd     cr.cpMax, ePos
         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      .endif

      .if wmsg != WM_COMMAND       ; See if msg is a command
            jmp     CreateJmpDone
      .endif
         mov     eax, wparam
      .if eax == IDOK
         INVOKE     IsDlgButtonChecked, hdlg, cb1
         .if eax
            INVOKE     lstrcpy, addr szFind, addr Jmp1
         .else
            INVOKE     lstrcpy, addr szFind, addr Jmp1Pop
         .endif
         INVOKE     lstrcat, addr szFind, addr szBuff
         INVOKE     lstrcat, addr szFind, addr Jmp2

         INVOKE     GetDlgItemText, hdlg, E2, addr szBuff, 256
           test     eax, eax
             jz     NoReplace
            mov     sw4, 0
           call     FillBlank
         .if byte ptr szBuff != '^'
            INVOKE     lstrcat, addr szFind, addr szCaret
         .endif
         INVOKE     lstrcat, addr szFind, addr szBuff
         INVOKE     lstrcat, addr szFind, addr Jmp3
         INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind

;---------- [Save settings and restore the main window] ----------
NoReplace:
         INVOKE     GetDlgItemText, hdlg, E1, addr szBuff, 256
           call     SaveRestore
            jmp     CancelOut
      .endif
         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     CreateJmpDone

CancelOut:
         and     PopupTopic, 0 
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     CreateJmpRet      ; with TRUE

CreateJmpDone:
         mov     eax, FALSE        ; Return with FALSE

CreateJmpRet:
         ret                       ; Return to caller
CreateJmp ENDP

;========================================================================|
;* Create footnotes procedure                                            *
;========================================================================|
CreateFoot PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     cr:CHARRANGE
LOCAL     LNum:DWORD, Len, FieldID, FieldName

      .if wmsg == WM_INITDIALOG
         INVOKE     SetDlgItemText, hdlg, E1, addr szBuff
         INVOKE     SetDlgItemText, hdlg, E2, addr szBuff
         INVOKE     SetDlgItemText, hdlg, E3, addr szWork
         .if !szKeys && SetPage > 1
            INVOKE     lstrcpy, addr szBuff, addr szWork
               mov     sw4, 1
              call     FillBlank
            .if byte ptr szBuff == '^'
               INVOKE     lstrcpy, addr szBuff, addr szBuff+1
            .endif
            INVOKE     SetDlgItemText, hdlg, E4, addr szBuff
         .else
            INVOKE     SetDlgItemText, hdlg, E4, addr szKeys
         .endif
          MOVmd     hFootDlg, hdlg
      .endif

      .if wmsg != WM_COMMAND  ; See if msg is a command
            jmp     CreateFootDone
      .endif
         mov     eax, wparam
      .if eax == IDOK
         .if SetPage > 1      ; Needs a page break

;---------- [Save current position and get the address of the current line] ----------
            INVOKE     SendMessage, hREditW, EM_EXGETSEL, 0, addr cr
             MOVmd     sPos, cr.cpMin
             MOVmd     ePos, cr.cpMax
            INVOKE     SendMessage, hREditW, EM_LINEFROMCHAR, -1, 0
               mov     LNum, eax
            INVOKE     SendMessage, hREditW, EM_LINEINDEX, LNum, 0
               mov     cr.cpMin, eax
               inc     eax
               mov     cr.cpMax, eax

            INVOKE     GetDlgItemText, hdlg, E2, addr szBuff, 256
              test     eax, eax
                jz     SaveRest

;---------- [Insert page break if missing] ----------
              push     cr.cpMin
              push     cr.cpMax
             MOVmd     ft.chrg.cpMin, sPos
             MOVmd     ft.chrg.cpMax, sPos
               sub     ft.chrg.cpMax, 40
               lea     eax, offset szPage
               mov     ft.lpstrText, eax
               mov     ebx, FR_MATCHCASE
            INVOKE     SendMessage, hREditW, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  jmp     NoPage
            .endif
   
               lea     eax, offset szPar
               mov     ft.lpstrText, eax
Again:
               mov     ebx, FR_MATCHCASE
            INVOKE     SendMessage, hREditW, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  mov     cr.cpMin, eax
                  add     eax, 5
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
               .if byte ptr szWork+4 == 'd'
                 MOVmd     ft.chrg.cpMin, cr.cpMin
                   jmp     Again
               .endif
               .if byte ptr szWork+4 != 'd'
                     sub     cr.cpMax, 1
                     add     sPos, 1
                     add     ePos, 1
                  INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               .endif
                  pop     cr.cpMax
                  pop     cr.cpMin
            .else
                  pop     cr.cpMax
                  pop     cr.cpMin
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
            .endif
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szPage

;---------- [Delete new paragraph marker if present] ----------
               mov     ebx, FR_MATCHCASE
            INVOKE     SendMessage, hREditW, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  mov     cr.cpMin, eax
                  add     eax, 5
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
               .if byte ptr szWork+4 == '\'
                     sub     cr.cpMax, 1
                     sub     sPos, 4
                     sub     ePos, 4
                  INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                     mov     szWork, 0            
                  INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szWork
               .endif
            .endif
             MOVmd     cr.cpMin, sPos
             MOVmd     cr.cpMax, ePos
            INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         .endif

NoPage:
;---------- [Build the footnote field] ----------
         INVOKE     lstrcpy, addr szFind, addr Foot1
            mov     FieldID, E2 
            lea     eax, T
            mov     FieldName, eax
         .while FieldID < E8
            INVOKE     GetDlgItemText, hdlg, FieldID, addr szBuff, 256
            .if FieldID == E2 || FieldID == E3
                 test     eax, eax
                   jz     SaveRest
            .else
                 test     eax, eax
                   jz     Blank
            .endif
            .if FieldID == E3
                  mov     sw4, 0
                 call     FillBlank
            .endif
            .if FieldID == E4 || FieldID == E6
                  mov     sw4, 1
                 call     FillBlank
            .endif
            INVOKE     lstrcat, addr szFind, FieldName
            .if FieldID == E3 && byte ptr szBuff != '^'
               INVOKE     lstrcat, addr szFind, addr szCaret
            .endif
            INVOKE     lstrcat, addr szFind, addr szBuff
            INVOKE     lstrcat, addr szFind, addr Foot2
Blank:
               add     FieldID, 1
               add     FieldName, 22
         .endw

Finish:
         INVOKE     lstrcat, addr szFind, addr Foot3
         INVOKE     GetDlgItemText, hdlg, E1, addr szBuff, 256
         INVOKE     lstrcat, addr szFind, addr szBuff
         INVOKE     lstrcat, addr szFind, addr Foot4
         INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind

;---------- [Save settings and restore the main window] ----------
SaveRest:
         INVOKE     GetDlgItemText, hdlg, E1, addr szBuff, 256
         .if lparam
              call     SaveRestore
         .endif
            jmp     CancelOut
      .endif

         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     CreateFootDone

CancelOut:
         and     hFootDlg, 0
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     CreateFootRet     ; with TRUE

CreateFootDone:
         mov     eax, FALSE        ; Return with FALSE

CreateFootRet:
         ret                       ; Return to caller
CreateFoot ENDP

;========================================================================|
;* Create a Border procedure                                             *
;========================================================================|
CreateBor PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     pf:PARAFORMAT2
LOCAL     cr:CHARRANGE
LOCAL     SW:DWORD

      .if wmsg == WM_INITDIALOG
            mov     szWork, 0
            mov     Var, 0
         INVOKE     SetDlgItemText, hdlg, E1, addr szBuff

;---------- [Check to see if Border has been created, if so remove] ----------
          MOVmd     cr.cpMin, sPos
          MOVmd     cr.cpMax, ePos
          MOVmd     ft.chrg.cpMin, sPos
            sub     ft.chrg.cpMin, 30
          MOVmd     ft.chrg.cpMax, sPos
            lea     eax, offset szBox      ; \box
           call     FindEM
         .if eax != -1
               jmp     Remove
         .else
               lea     eax, offset szBrdr  ; \brdr
              call     FindEM
            .if eax != -1
Remove:
                  mov     ebx, sPos
                  mov     ecx, sPos
                  sub     ecx, eax
                  sub     cr.cpMin, ecx
                  sub     cr.cpMax, ecx
               INVOKE     SendMessage, hREditW, EM_SETSEL, eax, ebx
               INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szWork
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                  jmp     CreateBorDone
            .endif
         .endif

;---------- [Check to see if \pard and parms need to be inserted] ----------
          MOVmd     ft.chrg.cpMin, sPos
            mov     ft.chrg.cpMax, -1
            lea     eax, offset szPar       ; \par
           call     FindEM
         .if eax != -1
               mov     cr.cpMin, eax
               mov     cr.cpMax, eax
               add     cr.cpMax, 4
             MOVmd     ft.chrg.cpMin, cr.cpMax
             MOVmd     ft.chrg.cpMax, cr.cpMax
               add     ft.chrg.cpMax, 6
               lea     eax, offset szPard  ; \pard
              call     FindEM
            .if eax != -1
                  jmp     NoPard
            .endif

            INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
            INVOKE     lstrcpy, addr szWork, addr szParPard
               mov     pf.cbSize, SIZEOF pf
            INVOKE     SendMessage, hREdit, EM_GETPARAFORMAT, 0, addr pf
            .if pf.wAlignment == PFA_CENTER
               INVOKE     lstrcat, addr szWork, addr szQc
            .elseif pf.wAlignment == PFA_RIGHT
               INVOKE     lstrcat, addr szWork, addr szQr
            .endif
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szWork
NoPard:
             MOVmd     cr.cpMin, sPos
             MOVmd     cr.cpMax, ePos
            INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         .endif
            jmp     CreateBorDone
      .endif

      .if wmsg != WM_COMMAND       ; See if msg is a command
            jmp     CreateBorDone
      .endif

         mov     eax, wparam

;---------- [Box Borders] ----------
      .if eax > 1599 && eax < 1604
            mov     Var, eax
            sub     eax, 1600
           imul     eax, 13
            lea     ebx, offset BrdBSH
         INVOKE     lstrcpy, addr szFind, addr BrdBSH[eax]
         INVOKE     GetDlgItem, hdlg, sb8                            ; Get handle thick border
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0  ; Sets thick border to unchecked
      .endif

;---------- [Borders] ----------
      .if eax > 1603 && eax < 1607
            mov     Var, eax
         .if eax == 1604
            INVOKE     lstrcpy, addr szFind, addr BrdRT
         .elseif eax == 1605
            INVOKE     lstrcpy, addr szFind, addr BrdRB
         .elseif eax == 1606
            INVOKE     lstrcpy, addr szFind, addr BrdRTRB
         .endif
      .endif

      .if eax == 1607 && Var > 1599 && Var < 1604
         INVOKE     GetDlgItem, hdlg, sb8                            ; Get handle thick border
         INVOKE     SendMessage, eax, BM_SETCHECK, BST_UNCHECKED, 0  ; Sets thick border to unchecked
      .endif
         mov     eax, wparam

      .if eax == IDOK && Var
         INVOKE     IsDlgButtonChecked, hdlg, sb8
         .if eax
            INVOKE     lstrlen, addr szFind
            INVOKE     lstrcpyn, addr szFind, addr szFind, eax
            INVOKE     lstrcat, addr szFind, addr BrdTH
         .endif
         INVOKE     lstrcat, addr szFind, addr szBuff
;INVOKE     MessageBox,NULL, addr szFind, offset WndClass, MB_OK
         INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind
      .endif
         mov     eax, wparam

;---------- [Save settings and restore the main window] ----------
      .if eax == IDOK
         INVOKE     GetDlgItemText, hdlg, E1, addr szBuff, 256
           call     SaveRestore
            jmp     CancelOut
      .endif

         mov     eax, wparam
         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     CreateBorDone

CancelOut:
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     CreateBorRet       ; with TRUE

CreateBorDone:
         mov     eax, FALSE        ; Return with FALSE

CreateBorRet:
         ret                       ; Return to caller
CreateBor ENDP

;========================================================================|
;* Create a BitMap or Button procedure                                   *
;========================================================================|
CreateBitBut PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     cr:CHARRANGE
LOCAL     szTemp[256]:BYTE
LOCAL     SavPos:DWORD

      .if wmsg == WM_INITDIALOG
            mov     szWork, 0
            mov     szParam, 0
            and     Var, 0
            and     sw4, 0
;         INVOKE     SetDlgItemText, hdlg, E1, addr szBuff
;---------- [Check to see if Bitmap has been created, if so remove] ----------
          MOVmd     cr.cpMin, sPos
          MOVmd     cr.cpMax, ePos
          MOVmd     ft.chrg.cpMin, cr.cpMin
          MOVmd     ft.chrg.cpMax, cr.cpMin
         .if InsertL || InsertR  ; Remove .if  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!1
               sub     ft.chrg.cpMax, 120
               lea     eax, offset szFontS        ; \fs
               mov     ft.lpstrText, eax
GetNext:
               mov     ebx, FR_MATCHCASE
            INVOKE     SendMessage, hREditW, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  mov     cr.cpMin, eax
                  mov     cr.cpMax, eax
                  add     cr.cpMax, 5
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szParam
               .if word ptr szParam+3 == '12'
                   MOVmd     ft.chrg.cpMin, cr.cpMin
                     jmp     GetNext
               .endif 
                MOVmd     cr.cpMin, sPos
                MOVmd     cr.cpMax, ePos
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
            .endif
             MOVmd     ft.chrg.cpMax, cr.cpMin
               add     ft.chrg.cpMax, 256 ;120
               lea     eax, offset szPar    ; \Par
               mov     ft.lpstrText, eax
               mov     ebx, FR_MATCHCASE
            INVOKE     SendMessage, hREditW, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  inc     eax
                  mov     ft.chrg.cpMin, eax
            .endif

               lea     eax, offset szPar    ; \Par
              call     FindEM
            .if eax != -1
                  mov     ft.chrg.cpMax, eax
            .endif
         .endif
         .if InsertL
               lea     eax, offset Bmp1L    ; \fs21\strike\{bmc
         .else
             MOVmd     ft.chrg.cpMin, cr.cpMin
               lea     eax, offset Bmp1R    ; \fs21   \strike\{bmc
         .endif
           call     FindEM
         .if eax != -1
               mov     SavPos, eax
               mov     cr.cpMin, eax
            .if InsertL 
                  add     cr.cpMin, 18      ; Offset to start of Bitmap
            .else
                  add     cr.cpMin, 21      ; Offset to start of Bitmap
            .endif
               lea     eax, offset Bmp2     ; \}\strike0\v 
              call     FindEM

;---------- [Get Bitmap name] ----------
            .if eax != -1
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
                  mov     Var, eax
               INVOKE     SetDlgItemText, hdlg, E2, addr szWork     ; szWork = BitMap
                MOVmd     cr.cpMin, cr.cpMax
                  add     cr.cpMin, 13      ; Offset to start of ID
                  lea     eax, offset Bmp3  ; \v0 
                 call     FindEM

;---------- [Get Topic ID] ----------
               .if eax != -1
                     mov     cr.cpMax, eax

                    push     cr.cpMax
                   MOVmd     ft.chrg.cpMin, cr.cpMin
                     mov     ft.chrg.cpMax, eax
                     lea     eax, offset szFontS        ; \fs
                    call     FindEM
                  .if eax != -1
                        mov     cr.cpMax, eax
                  .endif

                  INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                  INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork
                  INVOKE     SetDlgItemText, hdlg, E3, addr szWork  ; szWork = Keyword
                     pop     cr.cpMax
                     add     cr.cpMax, 4
                   MOVmd     cr.cpMin, SavPos

;---------- [Remove Bitmap and Topic ID] ----------
                  INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                     mov     szWork, 0
                  INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szWork
                  .if InsertL
                        mov     eax, ePos
                        sub     eax, sPos
                      MOVmd     cr.cpMax, cr.cpMin
                        add     cr.cpMax, eax
                  .else
                      MOVmd     cr.cpMin, sPos
                      MOVmd     cr.cpMax, ePos
                  .endif 
                  INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                  INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff
                  .if word ptr szBuff == 'f\'
                       push     cr.cpMax
                      MOVmd     cr.cpMax, cr.cpMin
                        add     cr.cpMax, 8
                     INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                        mov     szFind, 0
                     INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind
                        pop     cr.cpMax
                     INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
                     INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff
                  .endif
               .endif
            .endif
         .endif 
            jmp     CreateBitButDone
      .endif

      .if wmsg != WM_COMMAND       ; See if msg is a command
            jmp     CreateBitButDone
      .endif

         mov     eax, wparam
      .if eax == IDOK
         INVOKE     lstrcpy, addr szTemp, addr szBuff
         INVOKE     GetDlgItemText, hdlg, E2, addr szWork, 100
            mov     sw4, eax
         .if eax
            .if InsertL
               INVOKE     lstrcpy, addr szFind, addr Bmp1L
            .else
               INVOKE     lstrcpy, addr szFind, addr szTemp
               INVOKE     lstrcat, addr szFind, addr Bmp1R
            .endif
            INVOKE     lstrcat, addr szFind, addr szWork
            INVOKE     lstrcat, addr szFind, addr Bmp2
            INVOKE     GetDlgItemText, hdlg, E3, addr szBuff, 256
            .if !eax
                ;Do a warning message
            .else
                  mov     sw4, 0
                 call     FillBlank
               .if byte ptr szBuff != '^'
                  INVOKE     lstrcat, addr szFind, addr szCaret
               .endif
            .endif
            INVOKE     lstrcat, addr szFind, addr szBuff
            INVOKE     lstrcat, addr szFind, addr szParam
            INVOKE     lstrcat, addr szFind, addr Bmp3
            .if InsertL
               INVOKE     lstrcat, addr szFind, addr szParam
               INVOKE     lstrcat, addr szFind, addr szSpace3
               INVOKE     lstrcat, addr szFind, addr szTemp
            .endif
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szFind
            INVOKE     lstrcpy, addr szBuff, addr szTemp
         .else
            .if InsertL && !sw4
               INVOKE     lstrcpy, addr szBuff, addr szTemp
                  mov     eax, Var
                  add     eax, 12
                  sub     SavS, eax
                  sub     SavE, eax
            .endif
         .endif

;---------- [Save settings and restore the main window] ----------
           call     SaveRestore
            and     InsertL, 0
            and     InsertR, 0
            jmp     CancelOut
      .endif

         mov     eax, wparam
         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     CreateBitButDone

CancelOut:
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     CreateBitButRet       ; with TRUE

CreateBitButDone:
         mov     eax, FALSE        ; Return with FALSE

CreateBitButRet:
         ret                       ; Return to caller
CreateBitBut ENDP

;========================================================================|
;* Fill blanks with underbar                                             *
;========================================================================|
FillBlank PROC  uses ebx edx
LOCAL     szTemp[256]:BYTE

      INVOKE     lstrcpy, addr szTemp, addr szBuff
      INVOKE     lstrlen, addr szTemp
         mov     ecx, eax
         lea     ebx, szTemp
         xor     eax, eax
      .while (ecx)
            mov     dl, byte ptr szTemp[eax]
         .if !sw4
            .if dl == 20h
                 mov     dl, '_'
            .endif
         .else
            .if dl == '_'
                 mov     dl, 20h
            .endif
         .endif
            mov     byte ptr szBuff[eax], dl
            inc     eax
            dec     ecx
      .endw
         ret                       ; Return to caller
FillBlank ENDP

;========================================================================|
;* Create the help project file                                          *
;========================================================================|
CreateHPJ PROC  uses ebx  hdlg:DWORD, wmsg, wparam, lparam
LOCAL     cc:CHOOSECOLOR
LOCAL     ps:PAINTSTRUCT
LOCAL     cr:CHARRANGE
LOCAL     szSavPath[256]:BYTE
LOCAL     Map[5]:BYTE
LOCAL     hpjName[20]:BYTE
LOCAL     hlpName[20]:BYTE
LOCAL     hpMem:DWORD, fpMem, First, Val, LNum, Cnt, hBR

      .if wmsg == WM_INITDIALOG
         .if sw1 == 44
              jmp     OpenHPJ
         .endif
         INVOKE     lstrcpy, addr szWinParms, addr szPosClr
         INVOKE     GetDlgItem, hdlg, E8
            mov     hEdit8, eax
         INVOKE     GetDlgItem, hdlg, E9
            mov     hEdit9, eax

         INVOKE     ShowWindow, hREditW, SW_HIDE
         INVOKE     CreateWindowEx, WS_EX_CLIENTEDGE, ADDR listbox, 0,
                    WS_CHILD or WS_VSCROLL or WS_VISIBLE or LBS_HASSTRINGS or LBS_NOINTEGRALHEIGHT or \
                    LBS_DISABLENOSCROLL or LBS_SORT,
                    15, 72, 128, 137, hdlg, 68, hInstW, 0
            mov     hListW, eax
         INVOKE     SendMessage, hListW, WM_SETFONT, cFont, 1

            mov     First, 1
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1

;---------- [Get the title] ----------
            lea     ecx, offset szIDFootS    ; #{\footnote
         INVOKE     FindF, hREditW, 0, -1, Flags
           test     eax, eax
             js     NoTitle
            add     eax, 13
            mov     cr.cpMin, eax

            lea     ecx, offset szFootnote   ; }}
         INVOKE     FindF, hREditW, cr.cpMin, -1, Flags
           test     eax, eax
             js     NoTitle
            mov     cr.cpMax, eax

         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff
         INVOKE     SetDlgItemText, hdlg, E2, addr szBuff

         INVOKE     SetDlgItemInt, hdlg, E4, HelpX, 0
         INVOKE     SetDlgItemInt, hdlg, E5, HelpY, 0
         INVOKE     SetDlgItemInt, hdlg, E6, HelpW, 0
         INVOKE     SetDlgItemInt, hdlg, E7, HelpH, 0

;szPosClr     db      'main="7111",(240,66,390,600),20736,(r16777213),(r15266815),f2'
;            INVOKE     BaseAscii, Cnt, addr Map, 0, 10, 0, 0, 1

NoTitle:
            mov     ft.chrg.cpMin, 0
         INVOKE     SetDlgItemText, hdlg, E3, addr szAth

LoopFind:
            lea     eax, offset szIDFootID   ; #{\footnote
           call     FindEM
           test     eax, eax
             js     CreateHPJDone  ;NoMore
            mov     cr.cpMin, eax
         INVOKE     lstrlen, addr szIDFootID ; #{\footnote
            add     cr.cpMin, eax
          MOVmd     cr.cpMax, cr.cpMin
            add     eax, 50
            add     cr.cpMax, eax
         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff
            xor     eax, eax
            mov     ecx, 50
         .while (ecx)
            .if byte ptr szBuff[eax] == '}'  ; Get topic ID's
                MOVmd     cr.cpMax, cr.cpMin
                  add     cr.cpMax, eax
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szBuff
               INVOKE     SendMessage, hListW, LB_ADDSTRING, 0, addr szBuff
               .if First
                  INVOKE     SetDlgItemText, hdlg, E1, addr szBuff
                     and     First, 0
               .endif
               .break
            .endif
               inc     eax
               dec     ecx
         .endw
          MOVmd     ft.chrg.cpMin, cr.cpMin
            mov     ft.chrg.cpMax, -1
            jmp     LoopFind
      .endif

      .if wmsg == WM_CTLCOLORDLG || wmsg == WM_CTLCOLORSTATIC
         INVOKE     GetStockObject, WHITE_BRUSH
            jmp     CreateHPJRet
      .endif

      .if wmsg == WM_CTLCOLOREDIT
            mov     eax, lparam
         .if eax == hEdit8 || eax == hEdit9
            .if eax == hEdit8
               INVOKE     CreateSolidBrush, ColorH
                  mov     hBR, eax
            .elseif eax == hEdit9
               INVOKE     DeleteObject, hBR
               INVOKE     CreateSolidBrush, ColorT
                  mov     hBR, eax
            .endif
               jmp     CreateHPJRet
         .else
            INVOKE     DeleteObject, hBR
         .endif
      .endif

      .if wmsg == WM_PAINT
         INVOKE     GetDC, hdlg
            mov     hDC, eax
         INVOKE     SetBkColor, hDC, ColorH
         INVOKE     TextOut, hDC, 155, 246, addr Clear, 4
         INVOKE     SetBkColor, hDC, ColorT
         INVOKE     TextOut, hDC, 224, 246, addr Clear, 4
         INVOKE     ReleaseDC, hdlg, hDC
            jmp     CreateHPJDone
      .endif

      .if wmsg != WM_COMMAND       ; See if msg is a command
            jmp     CreateHPJDone
      .endif
         mov     eax, wparam

      .if eax == B1 || eax == B2
            mov     ebx, eax
            sub     ebx, 1901
            mov     Val, ebx

            mov     ecx, Val
           imul     ecx, 4
          MOVmd     cc.rgbResult, ColorH[ecx]
            mov     cc.lStructSize, sizeof cc
          MOVmd     cc.hwndOwner, hWndW
          MOVmd     cc.hInstance, hInstW
            mov     cc.lpCustColors, offset CustClrs
            mov     cc.Flags, CC_RGBINIT          ;CC_FULLOPEN or 
         INVOKE     ChooseColor, addr cc
            cmp     eax, FALSE         ;Cancel'ed or error occurred
             je     CreateHPJDone
            mov     ecx, Val
           imul     ecx, 4
          MOVmd     ColorH[ecx], cc.rgbResult
            jmp     CreateHPJDone
      .endif


      .if eax == IDOK
         INVOKE     GetDlgItemText, hdlg, E3, addr szAth, 49
         INVOKE     GetDlgItemInt, hdlg, E4, 0, 0
            mov     HelpX, eax
         INVOKE     GetDlgItemInt, hdlg, E5, 0, 0
            mov     HelpY, eax
         INVOKE     GetDlgItemInt, hdlg, E6, 0, 0
            mov     HelpW, eax
         INVOKE     GetDlgItemInt, hdlg, E7, 0, 0
            mov     HelpH, eax

;------------ [Create a memory block to write the sorted ID's to] ------------ 
         INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, 2000, 0
            mov     hpMem, eax
         INVOKE     HeapAlloc, hpMem, HEAP_GENERATE_EXCEPTIONS, 2000
            mov     fpMem, eax
            mov     First, eax
            mov     Cnt, 0
            mov     szBuff, 0
         INVOKE     lstrcpy, fpMem, addr szBuff
         INVOKE     SendMessage, hListW, LB_GETCOUNT, 0, 0
            mov     LNum, eax

         .while LNum > 0              ; LNum = num of ID's in the listbox
            INVOKE     SendMessage, hListW, LB_GETTEXT, Cnt, addr szBuff
               sub     LNum, 1
               add     Cnt, 1
               mov     eax, First
            .if eax == fpMem
               INVOKE     lstrcpy, fpMem, addr szBuff
            .else
               INVOKE     lstrcat, fpMem, addr szBuff
            .endif
               mov     First, 0
            INVOKE     lstrcat, fpMem, addr szEQ
            INVOKE     BaseAscii, Cnt, addr Map, 0, 10, 0, 0, 1
            INVOKE     lstrcat, fpMem, addr Map
            INVOKE     lstrcat, fpMem, addr szCRLF
         .endw

            and     RTF, 0
            mov     sw1, 3
         INVOKE     SaveFile
             or     RTF, 1

OpenHPJ:
         INVOKE     lstrlen, addr PathName
            mov     Cnt, eax
         .while (eax)
            .if byte ptr PathName[eax] == '\'
                  inc     eax
                 push     eax
               INVOKE     lstrcpyn, addr CurDir, addr PathName, eax
                  pop     eax
                  sub     Cnt, eax
                  sub     Cnt, 2
                 push     eax 
               INVOKE     lstrcpyn, addr hpjName, addr PathName[eax], Cnt
                  pop     eax
                  add     Cnt, 5
               INVOKE     lstrcpyn, addr szWork, addr PathName[eax], Cnt
               INVOKE     lstrcpy, addr hlpName, addr hpjName
               INVOKE     lstrcat, addr hlpName, addr szHLP
               INVOKE     lstrcat, addr hpjName, addr szHPJ
               .break
            .endif
               dec     eax
         .endw
         .if sw1 == 44
               and     sw1, 0
            INVOKE     DestroyWindow, hREditW
               and     hREditW, 0
            INVOKE     lstrcpy, addr szBuff, addr szHWS
            INVOKE     lstrcat, addr szBuff, addr szSpace
            INVOKE     lstrcat, addr szBuff, addr CurDir
            INVOKE     lstrcat, addr szBuff, addr szBackS
            INVOKE     lstrcat, addr szBuff, addr hpjName
            INVOKE     WinExec, addr szBuff, SW_SHOWNORMAL     ; Exec the hcw program
               mov     szBuff, 0
               jmp     CancelOut
         .endif
         INVOKE     lstrcpy, addr szSavPath, addr PathName
         INVOKE     lstrcpy, addr PathName, addr CurDir
         INVOKE     lstrcat, addr PathName, addr szBackS
         INVOKE     lstrcat, addr PathName, addr hpjName

         INVOKE     SendMessage, hREditW, WM_SETTEXT, 0, addr hpjTemp
          MOVmd     Cnt, E1
            mov     dword ptr szFields, 31313141h

LoopHPJ:
;DSPValue hWndW, Cnt
;INVOKE     MessageBox,NULL, addr szFields, offset WndClass, MB_OK
            mov     ft.chrg.cpMin, 0
            mov     ft.chrg.cpMax, -1
            lea     eax, offset szFields
           call     FindEM
           test     eax, eax
             js     AllDone ;CreateHPJDone  ;NoMore
            mov     cr.cpMin, eax
            add     eax, 4
            mov     cr.cpMax, eax
         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
           mov     eax, Cnt
         .if eax < E4
            INVOKE     GetDlgItemText, hdlg, Cnt, addr szBuff, 256
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E4
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr hlpName
         .elseif eax == E5
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szWork
         .elseif eax == E6
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, fpMem
         .elseif eax == E7
            INVOKE     GetDlgItemText, hdlg, E2, addr szBuff, 256
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E8
            INVOKE     BaseAscii, HelpX, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E9
            INVOKE     BaseAscii, HelpY, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E10
            INVOKE     BaseAscii, HelpW, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E11
            INVOKE     BaseAscii, HelpH, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E12
            INVOKE     BaseAscii, ColorT, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .elseif eax == E13
            INVOKE     BaseAscii, ColorH, addr szBuff, 0, 10, 0, 0, 1
            INVOKE     SendMessage, hREditW, EM_REPLACESEL, 1, addr szBuff
         .endif

AllDone:
            add     szFields, 1
            add     Cnt, 1
            mov     eax, Cnt
         .if eax < E14
               jmp     LoopHPJ
         .endif 
            and     RTF, 0
            mov     sw1, 3
         INVOKE     SaveFile
             or     RTF, 1
         INVOKE     lstrcpy, addr PathName, addr szSavPath

             or     OA, 1
         INVOKE     OpenFileA
          MOVmd     cr.cpMin, SavS
          MOVmd     cr.cpMax, SavE
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr

             or     HG, 1 
             or     OA, 1
         INVOKE     OpenFileA
         INVOKE     ShowWindow, hREditW, SW_SHOWNORMAL
         INVOKE     SetFocus, hdlg

         INVOKE     HeapDestroy, hpMem
         INVOKE     MessageBox, NULL, addr szBuilt, addr hpjName, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
            jmp     CancelOut
      .endif

         mov     eax, wparam
         cmp     eax, IDCANCEL     ; See if its CANCEL that was pressed
         je      CancelOut         ; and if not either of these
         jmp     CreateHPJDone

CancelOut:
        push     wparam            ; Terminate with wparam as the return
        push     hdlg              ; Handle of the dialog
        call     EndDialog         ; End the dialog
         mov     eax, TRUE         ; Return
         jmp     CreateHPJRet      ; with TRUE

CreateHPJDone:
         mov     eax, FALSE        ; Return with FALSE

CreateHPJRet:
         ret                       ; Return to caller
CreateHPJ ENDP

;=========================================================================
;* Find and Replace text procedure                                       *
;=========================================================================
FRProcW PROC  uses ebx edx edi hWnd:DWORD, Work, Len, Foot, FText
LOCAL     cr:CHARRANGE
LOCAL     Match:DWORD, Contents, uldb, SW, SavPos, SavJmp, Prev, w1
LOCAL     szTemp[256]:BYTE

         and     Contents, 0
         and     szWork, 0
         and     Match, 0
         mov     szParam, 0
         and     PopupTopic, 0
         and     Prev, 0
         mov     ft.chrg.cpMin, 0
         mov     ft.chrg.cpMax, -1

         lea     eax, offset szViewkind
         mov     ft.lpstrText, eax
      INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
      .if eax != -1 && Work  ; Match from the work window
            mov     ft.chrg.cpMin, eax
      .endif
         mov     eax, FText
         mov     ft.lpstrText, eax

LoopFind:
      INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft

;---------- [Parent Window] ----------
      .if eax != -1 && !Work  ; Match from the parent window
            add     Num, 1    ; Increment the number of like fields
         .if eax >= sPos      ; At the original selected field
               mov     cr.cpMin, eax
               add     eax, Len
               mov     cr.cpMax, eax
            INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               ret
         .else
               mov     ebx, eax
               add     eax, 1
               mov     ft.chrg.cpMin, eax

;---------- [Check if Jump was created if so, decrease count] ----------
              push     ft.chrg.cpMin
               mov     ft.chrg.cpMin, ebx
               mov     ft.chrg.cpMax, ebx
               add     ft.chrg.cpMax, 64
               lea     eax, offset szCR
               mov     ft.lpstrText, eax
            INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
            .if eax != -1
                MOVmd     cr.cpMin, ft.chrg.cpMin
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hWnd, EM_GETSELTEXT, 0, addr szTemp
                  mov     ecx, eax
                  xor     eax, eax
               .while (ecx)
                  .if szTemp[eax] == '^'
                        add     ft.chrg.cpMin, eax
                        mov     eax, FText
                        mov     ft.lpstrText, eax
                     INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
                     .if eax != -1
                           sub     Num, 1
                     .endif
                     .break
                  .endif
                     dec     ecx
                     inc     eax
               .endw
            .endif
               pop     ft.chrg.cpMin
               mov     ft.chrg.cpMax, -1
               mov     eax, FText
               mov     ft.lpstrText, eax
               jmp     LoopFind 
         .endif
      .endif
         cmp     Work, 0
          je     FRProcWRet

;---------- [Work Window] ----------
      .if eax == -1

;---------- [If no match check for special characters] ----------
            and     SW, 0
         INVOKE     lstrcpy, addr szTemp, FText
         INVOKE     lstrlen, addr szTemp
            mov     ecx, eax
            xor     eax, eax
            xor     edi, edi
         .while (ecx)
               mov     dl, byte ptr szTemp[eax]
            .if dl == '' || dl == ''
                 mov     dword ptr szFind[edi], 3961275ch ; \'a9
               .if dl == ''
                    mov     dword ptr szFind[edi], 6561275ch ; \'ae
               .endif
                 add     edi, 3
                 add     Len, 3
                 mov     SW, 12
                 jmp     Pass
            .endif
               mov     byte ptr szFind[edi], dl
Pass:
               inc     eax
               inc     edi
               dec     ecx
         .endw
            mov     byte ptr szFind[edi], 0
         INVOKE     lstrcpy, FText, addr szFind
         .if SW == 12  ; Try again
               and     SW, 0
               Jmp     LoopFind
         .endif
         INVOKE     MessageBox, NULL, addr szDoSel, offset WndClass, MB_OK or MB_ICONEXCLAMATION
            mov     eax, -1
            ret
      .endif
         mov     SavPos, eax

;---------- [Try to find a matching field for the jump] ----------
      .if eax != -1 && Work && !Foot ; Match from the work window jump
            add     Match, 1         ; Increment the number of like fields
            mov     SW, 32
            jmp     FindFoot

GoBack:
            mov     ebx, Num
         .if Match < ebx
               add     eax, 1
               mov     ft.chrg.cpMin, eax
               jmp     LoopFind
         .endif
            mov     ft.chrg.cpMin, eax
            mov     ft.chrg.cpMax, eax
            sub     ft.chrg.cpMax, 5
            lea     eax, offset szFootnote
            mov     ft.lpstrText, eax
            mov     ebx, FR_MATCHCASE
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, ebx, addr ft
            .if eax != -1
                  mov     eax, SavPos
                  add     eax, Len
                  mov     cr.cpMin, eax
                  mov     cr.cpMax, eax
               .if !BmpBut
                  INVOKE     MessageBox, NULL, addr szNotJump, addr WndClass,\
                             MB_OK or MB_ICONWARNING or MB_TASKMODAL
                     mov     eax, -1
                     jmp     FRProcWRet
               .endif
                  and     BmpBut, 0
            .endif
      .endif

;---------- [Try to find a matching ID for the topic] ----------
      .if eax != -1 && Work && Foot  ; Match from the work window footnote
            add     Match, 1         ; Increment the number of like fields

FindFoot:
           push     eax
           push     ft.chrg.cpMin
            mov     Prev, eax

            mov     ft.chrg.cpMin, eax
            mov     ft.chrg.cpMax, eax
            sub     ft.chrg.cpMax, 40
            lea     eax, offset Jmp2   ; \ul0\v 
            mov     ft.lpstrText, eax
            mov     ebx, FR_MATCHCASE
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, ebx, addr ft
         .if eax != -1
               mov     ft.chrg.cpMin, eax
               mov     ft.chrg.cpMax, eax
               add     ft.chrg.cpMax, 64
               lea     eax, offset Jmp3  ; Jmp3 = \v0} 
               mov     ft.lpstrText, eax
            INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
            .if eax != -1
                  mov     ft.chrg.cpMax, eax
                  mov     ebx, FText
                  mov     ft.lpstrText, ebx
               INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
               .if eax != -1
                     sub     Match, 1
               .endif
            .endif      
         .endif

            mov     eax, Prev
            mov     ft.chrg.cpMin, eax
            mov     ft.chrg.cpMax, eax
            sub     ft.chrg.cpMin, 1  ; sub 1 from min and go out 40 and check for }}
            add     ft.chrg.cpMax, 40
            lea     eax, offset szFootnote  ; szFootnote = }}
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft

;---------- [Decrease the footnote count, because they're bypassed on the Parent Window] ----------
         .if eax != -1
               sub     Match, 1
         .endif
            pop     ft.chrg.cpMin
            pop     eax
            mov     ft.chrg.cpMax, -1
            mov     ebx, FText
            mov     ft.lpstrText, ebx
         .if SW == 32
              and     SW, 0
              jmp     GoBack
         .endif
            mov     ebx, Num
         .if Match < ebx || ebx == 1
               add     eax, 1
               mov     ft.chrg.cpMin, eax

;---------- [We are in a table of contents area] ----------
;---------- [Format = \uldb Name\ul0\v NameID\v0 ] ----------
            .if Match == 1 || Match != 1          ; Get the ID for the topic from the contents field  N O T E !!!!!!!!!!!!

                 push     eax
                  sub     eax, 6
                  mov     cr.cpMin, eax
                  add     eax, 4
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
                  and     uldb, 0

;---------- [Start of the Jump name] ----------
               .if dword ptr szTemp == 62646c75h  ; uldb
                      or     uldb, 1
               .endif
               .if szTemp+2 != 'd'                ; Popup Topic
                     mov     PopupTopic, 1 
               .endif
                  pop     eax
                  add     eax, Len
                  dec     eax 
                  mov     cr.cpMin, eax
                  add     eax, 7 ;10 ;7
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp

;---------- [No Jump ID has been built] ----------
               .if dword ptr szTemp == 7261705ch  ; \par
                     mov     Contents, 1
               .endif

;---------- [End of the Jump name] ----------
               .if dword ptr szTemp == 306c755ch && uldb ; \ul0
                     mov     eax, cr.cpMax
                     mov     cr.cpMin, eax
                     add     eax, 50
                     mov     cr.cpMax, eax
                  INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
                  INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
                     xor     eax, eax
                     mov     ecx, 50

;---------- [Check to see if the jump ID has been built] ----------
                  .while (ecx)
                     .if dword ptr szTemp[eax] == 7d30765ch  ; \v0}
                         MOVmd     cr.cpMax, cr.cpMin
                           add     cr.cpMax, eax
                        INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
                        .if !szWork
                           INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szWork ; Topic ID
                        .endif
                        .break
                     .endif
                        inc     eax
                        dec     ecx
                  .endw
;---------- [End of the ID] ----------
               .endif   ; .if dword ptr szTemp == 755c765ch  ; \v\u
            .endif   ; .if Match == 1 || Match != 1

Gotem:
            .if Num > 1
                  jmp     LoopFind
            .endif
         .endif   ; .if Match < ebx || ebx == 1

         .if !szWork && Num == 1 && SetPage || !Contents && !szWork && SetPage
            .if !NonPop
               INVOKE     lstrcpy, addr szName1, FText
                  mov     eax, SavPos
                  mov     cr.cpMin, eax
                  add     eax, Len
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     MessageBox,NULL, addr szNoCont, offset WndClass, MB_YESNO or MB_ICONSTOP or MB_TASKMODAL
               .if eax == IDYES
                     mov     eax, -1
                     ret
               .endif
            .endif
         .elseif !szWork && Num > 1 && !NonPop
            INVOKE     lstrcpy, addr szName2, FText
            INVOKE     MessageBox,NULL, addr szNoJump, offset WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
         .endif
      .endif   ; .if eax != -1 && Work && Foot

         mov     eax, SavPos
         mov     cr.cpMin, eax
         mov     sPos, eax
         add     eax, Len
         mov     cr.cpMax, eax
         mov     ePos, eax

;---------- [Check to see if the footnote has been built] ----------
      .if Foot
            mov     szKeys, 0
          MOVmd     SavSP, cr.cpMin
          MOVmd     SavEP, cr.cpMax

          MOVmd     ft.chrg.cpMin, cr.cpMin
          MOVmd     ft.chrg.cpMax, cr.cpMax
            add     ft.chrg.cpMax, 8
            lea     eax, offset Jmp2         ; \ul0\v
           call     FindEM
         .if eax != -1
            INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
            INVOKE     MessageBox, NULL, addr szNotTopic, addr WndClass,\
                       MB_OK or MB_ICONWARNING or MB_TASKMODAL
               mov     eax, -1
               jmp     FRProcWRet
         .endif

          MOVmd     ft.chrg.cpMin, cr.cpMin
          MOVmd     ft.chrg.cpMax, cr.cpMin
            sub     ft.chrg.cpMin, 50
            lea     eax, offset szIDFootK   ; K{\footnote
           call     FindEM
           test     eax, eax
             js     NoKey
            mov     cr.cpMin, eax
         INVOKE     lstrlen, addr szIDFootK
            add     cr.cpMin, eax
          MOVmd     cr.cpMax, cr.cpMin
            add     eax, 50
            add     cr.cpMax, eax
         INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
            xor     eax, eax
            mov     ecx, 50
         .while (ecx)
            .if byte ptr szTemp[eax] == '}'  ; Get topic Key's
                MOVmd     cr.cpMax, cr.cpMin
                  add     cr.cpMax, eax
               INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szKeys
               .break 
            .endif
               dec     ecx
               inc     eax 
         .endw

NoKey:
          MOVmd     cr.cpMin, SavSP
          MOVmd     cr.cpMax, SavEP
          MOVmd     ft.chrg.cpMin, cr.cpMin
            sub     ft.chrg.cpMin, 150
          MOVmd     ft.chrg.cpMax, ft.chrg.cpMin
            add     ft.chrg.cpMax, 150

            lea     eax, offset szKeepn    ; \keepn
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
         .if eax != -1 && Work
              push     eax
               mov     w1, eax
               mov     ft.chrg.cpMin, eax
               inc     eax
               mov     ft.chrg.cpMax, eax
               sub     ft.chrg.cpMin, 40
               lea     eax, offset szPage  ; \Page
               mov     ft.lpstrText, eax
            INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
            .if eax != -1
                  mov     cr.cpMin, eax
                  mov     cr.cpMax, eax
                  add     cr.cpMax, 5
                  sub     w1, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     lstrcpy, addr szTemp, addr szPar
               .if w1 == 5
                  INVOKE     lstrcat, addr szTemp, addr szSpace
                     pop     eax
                     inc     eax
                    push     eax
               .endif
               INVOKE     SendMessage, hWnd, EM_REPLACESEL, 1, addr szTemp  ;szPar
                  pop     eax
                  dec     eax
            .else
                  pop     eax
            .endif

               mov     cr.cpMin, eax
               mov     ft.chrg.cpMin, eax
               mov     ft.chrg.cpMax, -1
               lea     eax, offset szFoot  ; \sb40\sa40
               mov     ft.lpstrText, eax
            INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
            .if eax != -1
                  add     eax, 11 ;10          ; Offset of \sb40\sa40 ;\sa40\fs2
                  mov     cr.cpMax, eax
               INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
               INVOKE     SendMessage, hWnd, EM_REPLACESEL, 1, FText
                MOVmd     SavSP, cr.cpMin
                MOVmd     SavEP, cr.cpMin
                  mov     eax, Len
                  add     SavEP, eax
            .endif

             MOVmd     cr.cpMin, SavSP
             MOVmd     cr.cpMax, SavEP
               jmp     SetSel
         .endif
      .endif

;---------- [Check to see if a \pard needs to be inserted for dual colored windows] ---------- 
      .if Foot

;---------- [Check to see if there are parameters for the Topic  \qc, \qr] ---------- 
          MOVmd     ft.chrg.cpMin, sPos
          MOVmd     ft.chrg.cpMax, sPos
            sub     ft.chrg.cpMin, 40
            lea     eax, offset szQ
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
         .if eax != -1 && Work
               mov     ebx, eax
               add     ebx, 3
            INVOKE     SendMessage, hWnd, EM_SETSEL, eax, ebx
            INVOKE     SendMessage, hWnd, EM_GETSELTEXT, 0, addr szParam
         .endif

          MOVmd     ft.chrg.cpMin, ePos
          MOVmd     ft.chrg.cpMax, ePos
            add     ft.chrg.cpMax, 100
            lea     eax, offset szParPard
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
         .if eax != -1 && Work
               jmp     SetSel
         .endif

            lea     eax, offset szPar
            mov     ft.lpstrText, eax
         INVOKE     SendMessage, hWnd, EM_FINDTEXT, Flags, addr ft
         .if eax != -1 && Work
               mov     ebx, eax
               sub     ebx, ePos
            .if ebx < 100    ; ?????????
                  jmp     InsertPard
            .endif
         .else
               jmp     SetSel
         .endif

InsertPard:
               mov     ebx, eax
               add     ebx, 4
            INVOKE     SendMessage, hWnd, EM_SETSEL, eax, ebx
            INVOKE     lstrcpy, addr szTemp, addr szParPard
            INVOKE     lstrcat, addr szTemp, addr szParam
            INVOKE     SendMessage, hWnd, EM_REPLACESEL, 1, addr szTemp
      .endif

SetSel:
      INVOKE     SendMessage, hWnd, EM_EXSETSEL, 0, addr cr
FRProcWRet:
         ret
FRProcW ENDP

;=========================================================================
;* Find text                                                             *
;=========================================================================
FindEM  PROC
         mov     ft.lpstrText, eax
      INVOKE     SendMessage, hREditW, EM_FINDTEXT, Flags, addr ft
         ret
FindEM  ENDP

;=========================================================================
;* Find text                                                             *
;=========================================================================
FindJT  PROC
LOCAL     cr:CHARRANGE
Local     len:DWORD

       MOVmd     cr.cpMin, SavS
       MOVmd     cr.cpMax, SavE
         add     cr.cpMax, 1
      INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 1, 0
      INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         sub     cr.cpMax, 1
      INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
         xor     eax, eax
      .if byte ptr szFind[eax] >= 'a' && byte ptr szFind[eax] <= 'z'\
       || byte ptr szFind[eax] >= 'A' && byte ptr szFind[eax] <= 'Z'\
       || byte ptr szFind[eax] == ' '
         INVOKE     MessageBox, NULL, addr szMiddle, addr WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
            mov     eax, 44  ; Middle of a word
            ret
      .endif

       MOVmd     ft.chrg.cpMin, SavS
       MOVmd     ft.chrg.cpMax, SavE
      .if SavE > 99
            sub     ft.chrg.cpMax, 100
      .else
            mov     ft.chrg.cpMax, 0
      .endif
         lea     eax, offset szCR
         mov     ft.lpstrText, eax
         mov     ebx, FR_MATCHCASE
      INVOKE     SendMessage, hREdit, EM_FINDTEXT, ebx, addr ft
      .if eax != -1
            mov     cr.cpMin, eax
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     SendMessage, hREdit, EM_GETSELTEXT, 0, addr szFind
            mov     len, eax
            xor     eax, eax

         .while (len)
            .if byte ptr szFind[eax] == '$'
               .if Jump
                  INVOKE     MessageBox, NULL, addr szNotJump, addr WndClass, MB_OK or MB_ICONWARNING or MB_TASKMODAL
               .endif
                  mov     eax, 44
                  ret
            .endif
            .if byte ptr szFind[eax] == '(' && byte ptr szFind[eax+2] == ')'\
             || byte ptr szFind[eax] == '(' && byte ptr szFind[eax+3] == ')'\
             || byte ptr szFind[eax] == '(' && byte ptr szFind[eax+2] == '.'\
             || byte ptr szFind[eax] == '(' && byte ptr szFind[eax+3] == '.'
                  jmp     Reject
            .endif
            .if byte ptr szFind[eax] == '(' && byte ptr szFind[eax+2] == ' '\
             || byte ptr szFind[eax] == '(' && byte ptr szFind[eax+3] == ' '
                  jmp     Reject
            .endif
            .if byte ptr szFind[eax] >= 'a' && byte ptr szFind[eax] <= 'z'\
             || byte ptr szFind[eax] >= 'A' && byte ptr szFind[eax] <= 'Z'\
             || byte ptr szFind[eax] == '('
               .break
            .endif
Reject:
               sub     len, 1
               inc     eax
         .endw

            add     len, 1
         INVOKE     lstrcpyn, addr szFind, addr szFind[eax], len
          MOVmd     cr.cpMin, cr.cpMax
         INVOKE     SendMessage, hREdit, EM_HIDESELECTION, 0, 0
         INVOKE     SendMessage, hREdit, EM_EXSETSEL, 0, addr cr
         INVOKE     lstrlen, addr szFind
            sub     sPos, eax
          MOVmd     SavS, sPos
          MOVmd     SavE, cr.cpMax
      .else
;         INVOKE     MessageBox, NULL, addr szNoSelect, addr WndClass, MB_OK or MB_ICONINFORMATION or MB_TASKMODAL
            xor     eax, eax 
      .endif
        ret
FindJT  ENDP

;=========================================================================
;* Repair the RTF for dropped HCW codes procedure                        *
;=========================================================================
RepairRTF PROC  uses ebx  hWnd:DWORD, hInst, hFont
LOCAL     rect:RECT
LOCAL     EditS:EDITSTREAM
LOCAL     cr:CHARRANGE
LOCAL     StartF:DWORD, StartW, fMin, fMax, tMin, tMax, SubJmp, Len, Chg
LOCAL     szTemp[750]:BYTE

         and     StartF, 0
         and     StartW, 0
         and     fMin, 0
         and     fMax, 0
         and     tMin, 0
         and     tMax, 0
and     Len, 0

      INVOKE     GetWindowRect, hWnd, addr rect
         mov     eax, rect.right
         sub     eax, rect.left
         sub     rect.left, 100
         add     rect.top, 40
      INVOKE     CreateWindowEx, 0, addr richedit, 0,
                 WS_POPUP or WS_THICKFRAME or ES_MULTILINE or ES_NOHIDESEL or\
                 ES_WANTRETURN or ES_SAVESEL or WS_VSCROLL or\
                 ES_AUTOVSCROLL or WS_TABSTOP,
                 rect.left, rect.top, 400, 500, 0, 0, hInst, 0
         mov     hREditF, eax

      INVOKE     SetWindowLong, hREditF, GWL_WNDPROC, RichEditProcW
         mov     lpRichEditW, eax
      INVOKE     SendMessage, hREditF, WM_SETFONT, hFont, 1
      INVOKE     SendMessage, hREditF, EM_SETOPTIONS, ECOOP_XOR, ECO_SELECTIONBAR
      INVOKE     SendMessage, hREditF, EM_EXLIMITTEXT, 0, 2000000
;INVOKE     ShowWindow, hREditF, SW_SHOWNORMAL
      INVOKE     SendMessage, hREdit, EM_GETMODIFY, 0, 0
         mov     Chg, eax
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, FALSE, 0

;---------- [Allocate some memory] ----------
         mov     BytesO, 2000000
      INVOKE     HeapCreate, HEAP_GENERATE_EXCEPTIONS, BytesO, 0
         mov     hMem, eax
      INVOKE     HeapAlloc, hMem, HEAP_GENERATE_EXCEPTIONS, BytesO
         mov     pMem, eax

;---------- [Load the file prior to change to hREditW as text] ---------- 
      INVOKE     CreateWinRTF, hWnd, hInst, addr richedit, hFont, 37 ; 37 = Hide the window
          or     HG, 1
          or     OA, 1
        call     OpenFileA
      INVOKE     SendMessage, hREdit, EM_SETMODIFY, Chg, 0

;---------- [StreamOut the changed file to memory] ---------- 
         and     Hold, 0
       MOVmd     EditS.dwCookie, pMem
         mov     EditS.dwError, 0
         mov     EditS.pfnCallback, offset EditStreamWrite4
      INVOKE     SendMessage, hREdit, EM_STREAMOUT, SF_RTF, addr EditS
         mov     BytesO, eax   ; eax = bytes written

;---------- [StreamIn from memory to hREditF as text] ---------- 
         and     Hold, 0
       MOVmd     EditS.dwCookie, pMem
         mov     EditS.dwError, 0
         mov     EditS.pfnCallback, offset EditStreamRead4
      INVOKE     SendMessage, hREditF, EM_STREAMIN, SF_TEXT, addr EditS
      INVOKE     HeapDestroy, hMem

;---------- [Remove the null character at the EOF] ----------
      INVOKE     SendMessage, hREditF, EM_GETLINECOUNT, 0, 0
         dec     eax
      INVOKE     SendMessage, hREditF, EM_LINEINDEX, eax, 0
         dec     eax     
         mov     cr.cpMin, eax
         add     eax, 2
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind
         mov     eax, dword ptr szFind
      .if !eax || ax == 000dh
         INVOKE     SendMessage, hREditF, WM_CLEAR, 0 ,0
      .endif

;---------- [Find and fix the Header] ----------
         lea     ecx, offset szViewkind
      INVOKE     FindF, hREditF, 0, -1, Flags
        test     eax, eax
          js     DoBoxes
         mov     fMin, eax
         add     eax, 20
         mov     ebx, eax
         add     ebx, 200
         lea     ecx, offset szPard
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     DoBoxes
         add     eax, 4
         mov     ebx, eax
         add     ebx, 200
         lea     ecx, offset szPar
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     DoBoxes
         mov     fMax, eax

         lea     ecx, offset szViewkind
      INVOKE     FindF, hREditW, 0, -1, Flags
        test     eax, eax
          js     DoBoxes
         mov     tMin, eax
         add     eax, 20
         mov     ebx, eax
         add     ebx, 500
         lea     ecx, offset szPard
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     DoBoxes
         add     eax, 10
         mov     ebx, eax
         add     ebx, 200
         lea     ecx, offset szPar
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     DoBoxes
         mov     tMax, eax

       MOVmd     cr.cpMin, fMin
       MOVmd     cr.cpMax, fMax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
       MOVmd     cr.cpMin, tMin
       MOVmd     cr.cpMax, tMax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
      INVOKE     SendMessage, hREditF, EM_REPLACESEL, 1, addr szTemp
         mov     eax, tMax
         sub     eax, fMax
         add     fMax, eax

DoBoxes:
;---------- [Find and fix boxes] ----------
         mov     eax, fMax
         mov     fMin, eax
         mov     ebx, eax
         add     ebx, 100
         lea     ecx, offset szBox
      INVOKE     FindF, hREditF, eax, -1, Flags
        test     eax, eax
          js     DoTopics

         add     eax, 10
         mov     ebx, eax
         add     ebx, 300
         lea     ecx, offset szPar
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     DoTopics
         mov     fMax, eax

GoBackF:
         lea     ecx, offset szPar
      INVOKE     FindF, hREditF, eax, 0, FR_MATCHCASE
        test     eax, eax
          js     DoTopics

         mov     fMin, eax
         mov     cr.cpMin, eax
         add     eax, 5
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind
      .if szFind+4 == 'd'
           mov     eax, cr.cpMin
           jmp     GoBackF
      .endif

       MOVmd     cr.cpMin, fMax
       MOVmd     cr.cpMax, fMax
         sub     cr.cpMin, 50
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind
         lea     ecx, offset szFind
      INVOKE     FindF, hREditW, tMin, -1, Flags
        test     eax, eax
          js     DoTopics
         lea     ecx, offset szBox
      INVOKE     FindF, hREditW, eax, 0, FR_MATCHCASE
        test     eax, eax
          js     DoTopics
         lea     ecx, offset szPar
      INVOKE     FindF, hREditW, eax, -1, Flags
        test     eax, eax
          js     DoTopics
         mov     tMax, eax

GoBackW:
         lea     ecx, offset szPar
      INVOKE     FindF, hREditW, eax, 0, FR_MATCHCASE
        test     eax, eax
          js     DoTopics

         mov     tMin, eax
         mov     cr.cpMin, eax
         add     eax, 5
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szFind
      .if szFind+4 == 'd'
           mov     eax, cr.cpMin
           jmp     GoBackW
      .endif

       MOVmd     cr.cpMin, fMin
       MOVmd     cr.cpMax, fMax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
       MOVmd     cr.cpMin, tMin
       MOVmd     cr.cpMax, tMax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
      INVOKE     SendMessage, hREditF, EM_REPLACESEL, 1, addr szTemp
         mov     eax, tMax
         sub     eax, fMax
         add     fMax, eax
       MOVmd     fMin, fMax
       MOVmd     tMin, tMax
         jmp     DoBoxes

DoTopics:
;---------- [Find and fix topics] ----------
         mov     eax, StartF
         lea     ecx, offset szFootF
      INVOKE     FindF, hREditF, eax, -1, Flags
        test     eax, eax
          js     NoTopic

         add     eax, 14 ;15
         mov     ebx, eax
         mov     cr.cpMin, eax
         add     ebx, 750
         lea     ecx, offset szBackS
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoTopic

         mov     cr.cpMax, eax
OneMore:
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind
.if szFind == ' '
inc     cr.cpMin
jmp     OneMore
.endif

         mov     eax, cr.cpMax
         lea     ecx, offset szPage    ; \page
      INVOKE     FindF, hREditF, eax, 0, FR_MATCHCASE
        test     eax, eax
          js     NoTopic
         mov     fMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 500
         lea     ecx, offset szPard    ; \pard
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoTopic
add     eax, 6
         mov     fMax, eax

         sub     ebx, 450
      mov     ebx, eax
      add     ebx, 15
         lea     ecx, offset szPage    ; \page
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     ChkParF
         mov     fMax, eax
         jmp     BackTopicW

ChkParF:
         mov     eax, fMax
      mov     ebx, eax
      add     ebx, 100
         lea     ecx, offset szParCR   ; \par 0dh
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoTopic
         mov     fMax, eax

BackTopicW:
         mov     eax, StartW
         lea     ecx, offset szFind
      INVOKE     FindF, hREditW, eax, -1, Flags
        test     eax, eax
          js     NextTopic
         mov     tMin, eax

         mov     ebx, eax
         sub     ebx, 40
         lea     ecx, offset T         ; {\super ${\footnote
      INVOKE     FindF, hREditW, eax, ebx, FR_MATCHCASE
      .if eax == -1
         mov     eax, tMin
         add     eax, 10
         mov     StartW, eax
         jmp     BackTopicW
      .endif

         lea     ecx, offset szPage    ; \page
      INVOKE     FindF, hREditW, eax, 0, FR_MATCHCASE
        test     eax, eax
          js     NextTopic
         mov     tMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 750
         lea     ecx, offset szPard    ; \pard
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     NextTopic
         mov     tMax, eax

         mov     ebx, eax
         add     ebx, 30
         lea     ecx, offset szPage    ; \page
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     ChkParW
         mov     tMax, eax
         jmp     NoPar

ChkParW:
         mov     eax, tMax
         mov     ebx, eax
         add     ebx, 100
         lea     ecx, offset szParCR   ; \par 0dh
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     NextTopic
         mov     tMax, eax

NoPar:
       MOVmd     cr.cpMin, fMin
       MOVmd     cr.cpMax, fMax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr

      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szTemp
      .if dword ptr szTemp[eax-5] == 7261705ch   ; \par
            sub     cr.cpMax, 5
         INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
       .endif
       MOVmd     cr.cpMin, tMin
       MOVmd     cr.cpMax, tMax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
      .if byte ptr szTemp[eax-1] == 0dh
            mov     byte ptr szTemp[eax-1], 0
      .endif
      INVOKE     SendMessage, hREditF, EM_REPLACESEL, 1, addr szTemp

NextTopic:
       MOVmd     StartF, fMax
       MOVmd     StartW, tMax
         jmp     DoTopics

NoTopic:
         and     StartF, 0
         and     StartW, 0

DoJumps:
;---------- [Find and fix jumps] ----------
         and     SubJmp, 0
         mov     eax, StartF
         lea     ecx, offset Jmp4      ; \ulnone
      INVOKE     FindF, hREditF, eax, -1, Flags
        test     eax, eax
          js     NoJmps

         add     eax, 10
         mov     ebx, eax
         mov     cr.cpMin, eax
         add     ebx, 150
         lea     ecx, offset szBackS   ; \
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoJmps

         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind
      .if byte ptr szFind != '^'
          MOVmd     StartF, cr.cpMax
            jmp     DoJumps
      .endif

         mov     eax, cr.cpMax
         mov     ebx, eax
         sub     ebx, 100
         lea     ecx, offset Jmp7      ; \uldb
      INVOKE     FindF, hREditF, eax, ebx, FR_MATCHCASE
        test     eax, eax
         jns     NotSub

         mov     eax, cr.cpMax
         mov     ebx, eax
         sub     ebx, 100
         lea     ecx, offset Jmp6      ; \ul
      INVOKE     FindF, hREditF, eax, ebx, FR_MATCHCASE
        test     eax, eax
          js     NotSub
         mov     fMin, eax

       MOVmd     fMax, cr.cpMax
         add     fMax, 3
          or     SubJmp, 1
         jmp     GotJmpF

NotSub:
         mov     eax, cr.cpMax
         mov     ebx, eax
         sub     ebx, 500
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditF, eax, ebx, FR_MATCHCASE
        test     eax, eax
          js     NoJmps
         inc     eax
         mov     fMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 1024
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoJmps
         mov     fMax, eax

GotJmpF:
         mov     eax, StartW
         lea     ecx, offset szFind
      INVOKE     FindF, hREditW, eax, -1, Flags
        test     eax, eax
          js     NextJmp
         mov     tMin, eax

         mov     ebx, eax
         sub     ebx, 200
      .if SubJmp
            lea     ecx, offset szUL   ; {\ul
      .else
            lea     ecx, offset szCR   ; 0dh
      .endif
      INVOKE     FindF, hREditW, eax, ebx, FR_MATCHCASE
        test     eax, eax
          js     NextJmp
         mov     tMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 750
      .if SubJmp
            lea     ecx, offset Jmp3   ; \v0}
      .else
            inc     tMin
            lea     ecx, offset szCR   ; 0dh
      .endif
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     NextJmp
         mov     tMax, eax
       .if SubJmp
             add     fMax, 1
             add     tMax, 4
       .endif
       MOVmd     cr.cpMin, fMin
       MOVmd     cr.cpMax, fMax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
       MOVmd     cr.cpMin, tMin
       MOVmd     cr.cpMax, tMax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
      .if !SubJmp && byte ptr szTemp+8 == '#'
          MOVmd     StartW, tMax
            jmp     GotJmpF
      .endif
      INVOKE     SendMessage, hREditF, EM_REPLACESEL, 1, addr szTemp

NextJmp:
       MOVmd     StartF, fMax
       MOVmd     StartW, tMax
         jmp     DoJumps

NoJmps:
         and     StartF, 0
         and     StartW, 0

DoBmps:
;---------- [Find and fix bmps] ----------
         mov     eax, StartF
         lea     ecx, offset Bmp2      ; \}\strike0\v
      INVOKE     FindF, hREditF, eax, -1, Flags
        test     eax, eax
          js     NoMore

         mov     cr.cpMin, eax
         add     eax, 12
         mov     ebx, eax
         add     ebx, 150
         lea     ecx, offset szBackS   ; \
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoMore
         mov     cr.cpMax, eax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditF, EM_GETSELTEXT, 0, addr szFind

         mov     eax, cr.cpMin
         mov     ebx, eax
         sub     ebx, 500
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditF, eax, ebx, FR_MATCHCASE
        test     eax, eax
          js     NoMore
         inc     eax
         mov     fMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 1024
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditF, eax, ebx, Flags
        test     eax, eax
          js     NoMore
         mov     fMax, eax

         mov     eax, StartW
         lea     ecx, offset szFind
      INVOKE     FindF, hREditW, eax, -1, Flags
        test     eax, eax
          js     NextBmp

         mov     ebx, eax
         sub     ebx, 200
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditW, eax, ebx, FR_MATCHCASE
        test     eax, eax
          js     NextBmp
         inc     eax
         mov     tMin, eax

         add     eax, 10
         mov     ebx, eax
         add     ebx, 750
         lea     ecx, offset szCR      ; 0dh
      INVOKE     FindF, hREditW, eax, ebx, Flags
        test     eax, eax
          js     NextBmp
         mov     tMax, eax

       MOVmd     cr.cpMin, fMin
       MOVmd     cr.cpMax, fMax
      INVOKE     SendMessage, hREditF, EM_EXSETSEL, 0, addr cr
       MOVmd     cr.cpMin, tMin
       MOVmd     cr.cpMax, tMax
      INVOKE     SendMessage, hREditW, EM_EXSETSEL, 0, addr cr
      INVOKE     SendMessage, hREditW, EM_GETSELTEXT, 0, addr szTemp
      INVOKE     SendMessage, hREditF, EM_REPLACESEL, 1, addr szTemp

NextBmp:
       MOVmd     StartF, fMax
       MOVmd     StartW, tMax
         jmp     DoBmps

NoMore:
         and     RTF, 0
         mov     sw1, 4
      INVOKE     SaveFile
          or     RTF, 1
          or     OA, 1
      INVOKE     OpenFileA

      INVOKE     DestroyWindow, hREditF
      INVOKE     DestroyWindow, hREditW

         ret
RepairRTF ENDP

;=========================================================================
;* Find text                                                             *
;=========================================================================
FindF    PROC  uses ebx  hWnd:DWORD, FindS, FindE, Parm
       MOVmd     ft.chrg.cpMin, FindS
       MOVmd     ft.chrg.cpMax, FindE
         mov     ft.lpstrText, ecx
      INVOKE     SendMessage, hWnd, EM_FINDTEXT, Parm, addr ft
         ret
FindF    ENDP

;========================================================================|
;* Button Create buttons PROCEDURE                                       *
;========================================================================|
Button   PROC  hWnd:DWORD, ButText, ButStyle, xPos, yPos, wd, ht, ButID

      INVOKE     CreateWindowEx, 0,
                 addr Butt, ButText, ButStyle,
                 xPos, yPos, wd, ht, hWnd, ButID, hInstW, NULL
        push     eax    
      INVOKE     SendMessage, eax, WM_SETFONT, aFont, 1
         pop     eax
         ret
Button   ENDP

;========================================================================|
;* Draw text PROCEDURE                                                   *
;========================================================================|
DoText   PROC
LOCAL     rect:RECT
      .if !hToolBarH || !hStatic
            jmp     DoTextRet
      .endif
      INVOKE     GetClientRect, hStatic, addr rect
      INVOKE     GetDC, hStatic
         mov     hDC, eax
      INVOKE     SelectObject, hDC, aFont
      INVOKE     GetSysColor, COLOR_MENU
      INVOKE     SetBkColor, hDC, eax
      .if !Flag
         INVOKE     SetTextColor, hDC, 00ff0000h
         INVOKE     lstrlen, addr szComplete
         INVOKE     DrawText, hDC, addr szComplete, -1, addr rect, DT_LEFT or DT_WORDBREAK
      .else
         INVOKE     SetTextColor, hDC, 000000ffh
         INVOKE     lstrlen, addr szSemi
         INVOKE     DrawText, hDC, addr szSemi, -1, addr rect, DT_LEFT or DT_WORDBREAK
      .endif
      INVOKE     ReleaseDC, hStatic, hDC
DoTextRet:
         ret
DoText   ENDP
;========================================================================|
;* Static PROCEDURE - Static IS A SUB CLASS                              *
;========================================================================|
StaticProc PROC  hwnd:DWORD, wmsg, wparam, lparam

      INVOKE     CallWindowProc, lpStaticW, hwnd, wmsg, wparam, lparam

      .if wmsg == WM_PAINT
            call     DoText
      .endif
         ret
StaticProc ENDP

         END

;INVOKE     MessageBox,NULL, addr szFind, offset WndClass, MB_OK
